\ {{{1 GNU General Public License
{
Program Tops - a stack-based computing environment
Copyright (C) 1999-2005  Dale R. Williamson

Author: Dale R. Williamson <dale.williamson@prodigy.net>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
1}}} 
}

{ File xterm.v  October 1999

   Copyright (c) 1999   D. R. Williamson

   X11 references:

      Redhat 5.2 Linux: /usr/doc/HOWTO/XFree86-HOWTO

      Linux and Unix:
         man pages for X11 commands, like man XrmMergeDatabases

         subdirectory /usr/include/X11: grep the .h files

         www.rahul.net/kenton/xsites.html: "X Windows Version 11.5,
            a Concise Description," by Tom Love, 1996.

   X11 examples using this program:

      Example for manual created below.
      Run manual example (fire 'man wincreate' and copy and drop text
         at use > prompt); note how each of 9 handler words in event
         control block (ecb) structure detects keys, mouse buttons, 
         exposure, visibility, ... .
      Turn on wtrace to see window handler events as window is resized,
         moved, ... .
      See file plot.v for drawing graphs, using colors in graphics
         context, ... .
      
}
   X11 not IF " X11 graphics required" . halt THEN

\  This file is sourced by xterminit() during start up.
   "WCBcreate" exists? IF halt THEN 

   private time push

\-----------------------------------------------------------------------

\  Events, windows, and graphics context 

\  Structures for events, windows, and graphics contexts--items in them
\  match corresponding enumerations in term.h:
  
   "ecb" "bp br ce cm ee kp kr me ve" struct \ event control block
   define: ECBcreate ( --- hECB) ecb.sizeof 1 null ;

   "wcb" "win usr w h x y flags wam wav ecb" struct \ win control block
   define: WCBcreate ( --- hWCB) UDEF wcb.sizeof 1 fill ;
   define: WAVcreate ( --- hWAV) wav.sizeof 1 null ;

   "gcb" "gcc gam gav" struct \ graphics context block
   define: GCBcreate ( --- hGCB) UDEF gcb.sizeof 1 fill ;
   define: GAVcreate ( --- hGAV) gav.sizeof 1 null ;

\  Constants for pressed and released button events, ecb.bp and ecb.br:
   "1" "LtButt" inlinex
   "2" "MdButt" inlinex
   "3" "RtButt" inlinex

\-----------------------------------------------------------------------
{
   Window attributes mask (wam) and window attributes vector (wav)

   Window attributes mask.  These are Create Window (CW) bit flags for
   attributes that are present in the window attributes vector.  When
   ORed together, they form element wam of the window control block.

   If a bit in wcb.wam is zero, the corresponding attribute value in
   struct wav, whose pointer is element wcb.wav, is ignored:
}   0 2^ long makes CWBackPixmap            (1L<<0)
    1 2^ long makes CWBackPixel             (1L<<1)
    2 2^ long makes CWBorderPixmap          (1L<<2)
    3 2^ long makes CWBorderPixel           (1L<<3)
    4 2^ long makes CWBitGravity            (1L<<4)
    5 2^ long makes CWWinGravity            (1L<<5)
    6 2^ long makes CWBackingStore          (1L<<6)
    7 2^ long makes CWBackingPlanes         (1L<<7)
    8 2^ long makes CWBackingPixel          (1L<<8)
    9 2^ long makes CWOverrideRedirect      (1L<<9)
   10 2^ long makes CWSaveUnder             (1L<<10)
   11 2^ long makes CWEventMask             (1L<<11)
   12 2^ long makes CWDontPropagate         (1L<<12)
   13 2^ long makes CWColormap              (1L<<13)
   14 2^ long makes CWCursor                (1L<<14)
{
   Window attributes vector.
   Attributes in Xlib structure XSetWindowAttributes are all contained
   in struct wav defined here:
}  "wav" list:        \ default** and type description (see Xlib.h)
      "backPixmap"    \ 0 (None); Pixmap background_pixmap
      "backpixel"     \ 0 (black); unsigned long background_pixel
      "borderPixmap"  \ 0; Pixmap border_pixmap
      "borderpixel"   \ 0 (black); unsigned long border_pixel
      "bitgravity"    \ 0; int bit_gravity
      "wingravity"    \ 0; int win_gravity
      "backing_store" \ 0; int backing_store
      "backingplanes" \ 0; unsigned long backing_planes
      "backingpixel"  \ 0; unsigned long backing_pixel
      "saveunder"     \ 0; Bool save_under
      "eventmask"     \ 0; long event_mask
      "propnotmask"   \ 0; long do_not_propagate_mask
      "override"      \ 0; Bool override_redirect
      "colormap"      \ 0; Colormap colormap
      "cursor"        \ 0; Cursor cursor
      \ ** default if CW bit not defined; if CW bit is defined, a
      \    value must be provided
   end struct (matches _wav in term.h)

\  Some names that Xlib uses for attributes:
   0 is None
   1 is ParentRelative
   0 is CopyFromParent
   0 is NotUseful
   1 is WhenMapped
   2 is Always

   define: wprops (hW --- ) \ display window properties
      .m ;
{
   Example window attributes vector and matching CW bit mask for a case
   where backpixel, colormap, and cursor elements are set:

      WCBcreate makes MYwcb \ window control block

\     Setting the window attributes:
      WAVcreate makes mywav
      "blue" colorpix mywav wav.backpixel poke
      myColorMap      mywav wav.colormap poke
      myCursor        mywav wav.cursor poke
      "mywav" ptr MYwcb wcb.wav poke \ attributes vec ptr into MYwcb.wav

\     Setting the CW bit mask for these attributes:
      CWBackPixel CWColormap CWCursor or or \ bits are ORed together
      MYwcb wcb.wam poke \ mask number into MYwcb.wam
}
\-----------------------------------------------------------------------
{
   Graphics context attributes mask and graphics attributes vector (gav)

   References: 
      man page XCreateGC
      subdirectory /usr/include/X11, files X.h and Xlib.h
 
   These are the graphics context (GC) bit flags for attributes
   that are present in the graphics context attributes vector: 

   Graphics context attribute vector mask bits:
}   0 2^ long makes GCFunction                  (1L<<0)
    1 2^ long makes GCPlaneMask                 (1L<<1)
    2 2^ long makes GCForeground                (1L<<2)
    3 2^ long makes GCBackground                (1L<<3)
    4 2^ long makes GCLineWidth                 (1L<<4)
    5 2^ long makes GCLineStyle                 (1L<<5)
    6 2^ long makes GCCapStyle                  (1L<<6)
    7 2^ long makes GCJoinStyle                 (1L<<7)
    8 2^ long makes GCFillStyle                 (1L<<8)
    9 2^ long makes GCFillRule                  (1L<<9)
   10 2^ long makes GCTile                      (1L<<10)
   11 2^ long makes GCStipple                   (1L<<11)
   12 2^ long makes GCTileStipXOrigin           (1L<<12)
   13 2^ long makes GCTileStipYOrigin           (1L<<13)
   14 2^ long makes GCFont                      (1L<<14)
   15 2^ long makes GCSubwindowMode             (1L<<15)
   16 2^ long makes GCGraphicsExposures         (1L<<16)
   17 2^ long makes GCClipXOrigin               (1L<<17)
   18 2^ long makes GCClipYOrigin               (1L<<18)
   19 2^ long makes GCClipMask                  (1L<<19)
   20 2^ long makes GCDashOffset                (1L<<20)
   21 2^ long makes GCDashList                  (1L<<21)
   22 2^ long makes GCArcMode                   (1L<<22)

{  This is the graphics context attributes structure.  Attributes in 
   Xlib structure XGCValues are all contained in struct gav defined
   here:
}  "gav" list:     \ default** and type description (see Xlib.h)
      "function"   \ 0; int function: combining pixels
      "planemask"  \ 0; unsigned long plane_mask
      "foreground" \ 0; unsigned long foreground: pixel
      "background" \ 0; unsigned long background: pixel
      "linewidth"  \ 0; int line_width: in pixels
      "linestyle"  \ 0; int line_style: LineSolid, 
                   \    LineOnOffDash, LineDoubleDash 
      "capstyle"   \ 0; int cap_style: CapNotLast, CapButt, CapRound,
                   \   CapProjecting  
      "joinstyle"  \ 0; int join_style: FillSolid, FillTiled, 
                   \    FillStippled FillOpaqueStippled
      "fillstyle"  \ 0;int fill_style: FillSolid, FillTiled,
                   \   FillStippled, FillOpaeueStippled
      "fillrule"   \ 0; int fill_rule: EvenOddRule, WindingRule
      "arcmode"    \ 0; int arc_mode: ArcChord, ArcPieSlice
      "pixtile"    \ 0; Pixmap tile: tile pixmap for tiling
      "pixstipple" \ 0; Pixmap stipple: stipple 1 plane pixmap
      "tsXorigin"  \ 0; int ts_x_origin: offset for tile or stipple
      "tsYorigin"  \ 0; int ts_y_origin: offset for tile or stipple
      "font"       \ 0; Font font: default text font 
      "subwmode"   \ 0; int subwindow_mode: ClipByChildren, 
                   \    IncludeInferiors
      "expose"     \ 0; Bool graphics_exposures: generate exposures
      "clipXorg"   \ 0; int clip_x_origin: origin for clipping
      "clipYorg"   \ 0; int clip_y_origin: origin for clipping
      "clipmask"   \ 0; Pixmap clip_mask:  bitmap clipping
      "dashoff"    \ 0; int dash_offset: patterned/dashed line info
      "dashes"     \ 0; char dashes
      \ ** default if GC bit not defined; if GC bit is defined, a
      \    value must be provided
   end struct (matches _gav in term.h)

\  Functions for combining pixels (see X.h for others):
   "1" "GXand"  inlinex \ source destination AND
   "3" "GXcopy" inlinex \ source only
   "6" "GXxor"  inlinex \ source destination XOR
   "7" "GXor"   inlinex \ source destination OR

\  A setting for gav.planemask (bit GCPlaneMask):
   0 not long makes AllPlanes ((unsigned long)~0L)

\  Foreground, background colors: word colorpix provides values to use

\  LineStyle (file X.h):
   "0" "LineSolid" inlinex
   "1" "LineOnOffDash" inlinex
   "2" "LineDoubleDash" inlinex
{
   LineWidth in pixels: using width 0 draws width of 1 using a device-
   dependent algorithm that is probably faster.  Here's a quote from
   man XCreateGC (thin line refers to 0 width line): 

       In general, drawing a thin line will be faster than draw-
       ing a wide line of width one.  However, because of their
       different drawing algorithms, thin lines may not mix well
       aesthetically with wide lines.  If it is desirable to
       obtain precise and uniform results across all displays, a
       client should always use a line-width of one rather than a
       line-width of zero.
}
\  Text font: word fontid provides fid that can be used to specify font
{
   Example graphics context block:

      GCBcreate makes myGC \ graphics context block

\     Setting desired GC attributes in graphics attributes vector:

         GAVcreate makes mygav

         1 (Bool yes)              mygav gav.expose     poke
         GXcopy                    mygav gav.function   poke
         "DarkSlateGray"  colorpix mygav gav.background poke
         "BlanchedAlmond" colorpix mygav gav.foreground poke
         0 (LineWidth)             mygav gav.linewidth  poke
         LineSolid                 mygav gav.linestyle  poke

         "mygav" ptr myGC gcb.gav poke \ gav ptr into myGC.gav

\     Setting the corresponding GC mask bits:
         GCFunction, GCGraphicsExposures or
         GCForeground, GCBackground or or
         GCLineWidth or GCLineStyle or
         myGC gcb.gam poke \ mask number into myGC.gam
}
\-----------------------------------------------------------------------
{
   Colors

   Word colorpix receives a quoted color name, and returns the system
   color pixel value.

   File color.txt lists 752 color names that can be used with word
   colorpix.  Also, colors can be mixed to obtain a color number of
   the form #RRGGBB that can also be used with word colorpix (as 
   #60c0a0 below).

   Here is a sampling of color names and numbers (in addition to the
   usual black, white, red, green, blue, etc.):

      Aquamarine, PeachPuff, SlateBlue, #266294 (bluish), DimGrey,
      BlanchedAlmond, LightSkyBlue, Wheat, #5c54c0 (bluish),
      #60c0a0 (greenish), DarkSlateGray
}
\  This word makes a string suitable for word colorpix:

   inline: colorvalue (R G B --- qS) \ RGB color value string
\     Incoming R, G, B values range from 0 to 255. 
\     File color.txt shows RGB values for over 750 colors.
      [ BITS 64 = IF "int8" "int" overload THEN ]
      two roll int "#%02x" format
      two roll int "%02x" format
      two roll int "%02x" format
      cat cat 1st quote ;

   inline: Cpix (hV --- hCpix) \ matrix of RGB into color pix values
\     The three columns of incoming V contain, respectively, the color
\     values for red, green, and blue.  A color value is an integer 
\     from 0 to 255.
\     Returned vector Cpix contains the X11 index currently assigned
\     to the pixel color.
      [ 1 is R, 2 is G, 3 is B ]
      into V,
      list: V rows 1st
         DO V I reach, this R ndx pry, that G ndx pry, rot B ndx pry
            colorvalue colorpix
         LOOP
      end freed is V
   end

\-----------------------------------------------------------------------

\  Fonts

\  This is the font structure, fcb:
   "fcb" "name XFontStruct fid" struct \ font control block

\  The following defines fontTable, a matrix of font control blocks. 
   0 fcb.sizeof null makes fontTable \ each row is a font control block

{  Word fontadd (using fontload) adds new fonts to fontTable.  Fonts
   are accessed from fontTable using fontfcb to obtain the entire fcb 
   or word fontid to obtain just the font id for a graphics context. 
}
   public

   define: .fontTable ( --- ) \ display fontTable, matrix of fcbs
      fontTable rows 0= IF " fontTable is empty" . nl return THEN
      fontTable 1st catch bend mat2vol notrailing
      fontTable 2nd catch uints " %X" format park
      fontTable 2nd 1+ catch uints " %X" format park
      dot ;

   define: fontadd (qS --- ) \ adding font to fontTable
      strchop this fontfcb cols any IF drop return THEN
      '*' over lowercase '*' cat cat (qS) 
      fontload (0 | XFont fid) dup any
      IF rot lowercase str2num rev (qS XFont fid) 3 listn bend
         fontTable pile onto fontTable
      ELSE drop " fontadd: font " swap " not found" cat cat dot nl  
      THEN ;

   define: fontfcb (qS --- fcb) \ font control block from fontTable
\     Returned fcb has 0 columns if font not found in fontTable
      strchop lowercase fontTable again (fontTable) 1st catch (hName)
      rot str2num those rows once fill (hName hS) less
      (fontTable hRake) rake drop, these rows any
      IF 1st reach THEN bend ;

   define: fontid (qS --- fid) \ font id from fontTable, for use in GC
\     Returned fid is 0 if font not found in fontTable
      strchop lowercase fontfcb these cols any 
      IF fcb.fid pry ELSE drop 0 THEN ;

   private

   "font" Xresource is fontdef \ from resource dbase set by xterminit()
   fontdef chars any IF fontdef fontadd THEN

\  Here are some names for which word fontadd will fetch fonts: 
\     Helvetica, Courier, Times, Fixed
 
\-----------------------------------------------------------------------

\  Pixmaps (not yet developed)
   
\  Structure to contain a pixmap (matches _pcb in term.h):
   "pcb" "pix w h xhot yhot" struct \ pixmap control block

\-----------------------------------------------------------------------

\  Drawing (not yet developed; see plot.v for plotting)

\-----------------------------------------------------------------------

\  Making example for manual--wcb1:

   WCBcreate makes wcb1 \ window control block 

\  Window control block wcb1 needs a window attributes vector (wav)
\  and an event control block (ecb).

\  Here is the wav, called wav1:
      WAVcreate makes wav1 \ window attributes vector for wcb1 
      "wav1" ptr wcb1 wcb.wav poke 

\  Here is the ecb, called ecb1:
      ECBcreate makes ecb1 \ event control block for wcb1
      "ecb1" ptr wcb1 wcb.ecb poke

   (Note: This example does not draw, so no graphics context (GC)
   is used.  Drawing graphs in plot.v shows usage of GC.)

{  Making some simple message handlers for ecb1:
      Message handlers have stack diagram: (hE hW --- ) where hE 
      contains information about the event and hW is the window's 
      wcb.  Since the handlers here simply report the event, 2drop 
      appears in each to remove hE and hW from the stack before 
      returning--true to the stack diagram that shows nothing is
      returned.

      Here is a message handler word for each of the 9 elements of ecb:
}
      " ' Button pressed' . nl 2drop"  "_bp1" inlinex
      " ' Button released' . nl 2drop" "_br1" inlinex
      " ' Configure' . nl 2drop"       "_ce1" inlinex
      " ' Client message'  . nl 2drop" "_cm1" inlinex
      " ' Expose' . nl 2drop"          "_ee1" inlinex
      " ' Key pressed' . nl 2drop"     "_kp1" inlinex
      " ' Key released' . nl 2drop"    "_kr1" inlinex
      " ' Motion' . nl 2drop"          "_me1" inlinex
      " ' Visibility' . nl 2drop"      "_ve1" inlinex

\  Placing message handler words into event control block ecb1:
      "_bp1" ptr ecb1 ecb.bp poke \ ButtonPressedEvent
      "_br1" ptr ecb1 ecb.br poke \ ButtonReleasedEvent
      "_ce1" ptr ecb1 ecb.ce poke \ ConfigureEvent
      "_cm1" ptr ecb1 ecb.cm poke \ ClientMessageEvent
      "_ee1" ptr ecb1 ecb.ee poke \ ExposeEvent
      "_kp1" ptr ecb1 ecb.kp poke \ KeyPressedEvent
      "_kr1" ptr ecb1 ecb.kr poke \ KeyReleasedEvent
      "_me1" ptr ecb1 ecb.me poke \ MotionEvent
      "_ve1" ptr ecb1 ecb.ve poke \ VisibilityEvent

\  Window background pixel in window attributes vector for wcb1:
      "DarkSlateGray" colorpix wav1 wav.backpixel poke

\  For the attribute backpixel to be used, a matching attribute bit 
\  CWBackpixel must be set in the attributes mask of wcb1:
      CWBackPixel wcb1 wcb.wam poke \ window attributes mask

\  Setting initial window size and placement in wcb1:
      324 wcb1 wcb.w  poke \ window width
      225 wcb1 wcb.h  poke \ window height
      5   wcb1 wcb.x  poke \ upper left corner at x on screen
      20  wcb1 wcb.y  poke \ upper left corner at y on screen

\  End making example for manual

\-----------------------------------------------------------------------

   time pull less " info: seconds elapsed to load xterm.v:" . .i nl

   halt 

\-----------------------------------------------------------------------

\  Example pixmap control block, pcb1:
      pcb.sizeof 1 null makes pcb1

\-----------------------------------------------------------------------
;
