/* {{{1 GNU General Public License

Program Tops - a stack-based computing environment
Copyright (C) 1999-2005  Dale R. Williamson

Author: Dale R. Williamson <dale.williamson@prodigy.net>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
}}}1 */

/* 
   sparse.h
   Albert Danial  (pre-cvs: Oct 2 2001; Feb 23 2002)
 */

/* The items of this enum comprise the sparse matrix header. */
enum { ROWS              = 0,

       COLS                 ,

       n_STR                ,

       n_NONZ               ,   /* number of non-zero *terms*; a complex *
                                 * value is a single term                */
       COMPLX               ,   /* 0 => real          1 => complex       */

       DATA_SIZE                /* in bytes; total length of .data[]        */
                                /* This should always stay as the last term */
                                /* of the header since the constant         */
                                /* SPARSE_HDR_SIZE is defined from it.      */
};

/* The sparse magic numbers came from:
           perl -e 'for (1..4) {printf "%d\n", rand(1000000000)}'
 */
#define BPI 4   /* bytes per int    word ( = 8 on IA64) */
#define BPD 8   /* bytes per double word                */
#define SPARSE_MAGIC_SIZE           4
#define SPARSE_MAGIC_0       97038593
#define SPARSE_MAGIC_1      338847044
#define SPARSE_MAGIC_2      905434576
#define SPARSE_MAGIC_3      450194058
#define SPARSE_HDR_SIZE     DATA_SIZE + 1
#define SPARSE_START        BPI*SPARSE_MAGIC_SIZE
#define SPARSE_ZERO_THRESH    1.0e-16
#ifdef   BLAS
#ifdef FORT_UDSC
void   daxpy_();
void   dcopy_();
void   dscal_();
double ddot_ ();
#else
void   daxpy();
void   dcopy();
void   dscal();
double ddot();
#endif
#endif

typedef struct {
    int     len       ; /* Number of terms in the string (a complex       */
                        /* number counts as a single term).               */
    int     start_row ; /* Zero based, so first row has start_row = 0.    */
    int     N_idx     ; /* Index into N[] to first numeric term for this  */
                        /* string.                                        */
} str_t;

typedef struct {
    int     *magic    ;
    int     *H        ;         /* size = SPARSE_HDR_SIZE  */
    int     *S_start  ;         /* size = # columns + 1    */
    int     *N_start  ;         /* size = # columns + 1    */
    str_t   *S        ;         /* size = n_strings_total  */
    double  *N        ;         /* size = n_nonzeros_total */

    char    *data     ;         /* main data block         */

} SparseMatrix;

SparseMatrix sparse_overlay(char *tex);
int  sparse();      /* sparse      (hA --- hA_sp) */
int  dense();       /* dense       (hA_sp --- hA) */
int  spbend();      /* spbend      (hA_sp --- hA_sp') */
int  sprand();      /* sprand      (r c rho --- hA_sp) */
int  sperror();     /* sperror     (hA_sp --- hA_sp e ) */
int  is_sparse();   /* is_sparse   (hA --- hA f) */
int  spdump();      /* spdump      (hA_sp --- hA_sp) */
int  speye();       /* speye       (n --- hI_sp) */
int  spdiag();      /* spdiag      (hA_sp --- hD) */
int  spy();         /* spdiag      (hA_sp --- ) */
int  spnull();      /* spnull      (r c --- hN_sp) */
int  spadd();       /* spadd       (hA_sp hB_sp --- hC_sp) */
int  spadd_rr();    /* spadd_rr    (hA_sp hB_sp --- hC_sp) */
int  spadd_rc();    /* spadd_rc    (hA_sp hB_sp --- hC_sp) */
int  spadd_cc();    /* spadd_cc    (hA_sp hB_sp --- hC_sp) */
int  spadd_cx();    /* spadd_cx    (hA_sp hB_sp --- hC_sp) */
int  spscale();     /* spscale     (hA_sp f --- hAf_sp) */
int  spones();      /* spones      (hA_sp --- hO_sp) */
int  spreal_imag(); /* spreal_imag (hC_sp --- hRe_sp hIm_sp) */
int  spparkn();     /* spparkn     (hA1_sp ... hAn_sp n --- hA_sp) */
int  spconvert();   /* spconvert   (hIJV --- hA_sp)  */
int  sp2ijv();      /* sp2ijv      (hA_sp --- hIJV)  */
int  sppilen();     /* sppilen     (hA1_sp ... hAn_sp n --- hA_sp) */
int  spcatch();     /* spcatch     (hA_sp c | hA_sp hCols --- hB_sp) */
int  spreach();     /* spcatch     (hA_sp c | hA_sp hRows --- hB_sp) */
int  spcomb();      /* spcomb      (hA_sp c01 --- hA0_sp hA1_sp) */
int  sprake();      /* sprake      (hA_sp r01 --- hA0_sp hA1_sp) */
int  spmesh();      /* spmesh      (hA0_sp hA1_sp c01 --- hA_sp) */

void test_random_subset();
int  f_sp_error(char *data);
int  random_subset(int n, 
                   int m, 
                   int *result);
void sp_data_offsets(int  nCols,
                     int  nStr, 
                     int  nNz,
                     int  cmplx,        /* in     0=real  1=complex     */
                     int *ptr_H,        /* out byte offset to H[]       */
                     int *ptr_S_start,  /* out byte offset to S_start[] */
                     int *ptr_N_start,  /* out byte offset to N_start[] */
                     int *ptr_S,        /* out byte offset to S[]       */
                     int *ptr_N,        /* out byte offset to N[]       */
                     int *size);        /* out # bytes taken by matrix  */
void sp_set_header(char *tos,          /* in  pointer to TOS           */
                   SparseMatrix *m,
                   int   ptr_H,        /* in  byte offset to H[]       */
                   int   ptr_S_start,  /* in  byte offset to S_start[] */
                   int   ptr_N_start,  /* in  byte offset to N_start[] */
                   int   ptr_S,        /* in  byte offset to S[]       */
                   int   ptr_N,        /* in  byte offset to N[]       */
                   int   size,         /* in  # bytes taken by matrix  */
                   int   nRols, 
                   int   nCols, 
                   int   cmplx,        /* in     0=real  1=complex */
                   int   nStr, 
                   int   nNz);
void stringify_vector(int           nrows,  /* in     number of rows */
                      int           c,      /* in     column index */
                      double       *vector, /* in     the dense vector */
                      int           cmplx,  /* in     0=real  1=complex */
                      SparseMatrix *m,      /* in/out */
                      int          *iS,     /* in/out index to S */
                      int          *iN);    /* in/out index to N */
int  f_is_sparse(char *tex);
void f_sp_dump(const char *title, char *tex);
void dump_sp_detail(SparseMatrix m);
int  comp_IJV_cr(const void *a, const void *b );
int  comp_IJV_rc(const void *a, const void *b );
int  IJV_to_sparse(char   *name,      /* in  */
                   int    *IJV,       /* in  size = 3*num_size, [i,j,iv] ptrs */
                   int     cmplx,     /* in  0=real  1=complex */
                   double *N,         /* in  numeric data */
                   int     num_size,  /* in  length of numeric array N */
                   int     transpose, /* in  1 = treat rows as cols */
                   int     nrows,     /* in  number of rows */
                   int     ncols);    /* in  number of columns */
void sp_copy_index_data(int ncols,            /* in */
                        int nstr,             /* in */
                        SparseMatrix m_in,    /* in */
                        SparseMatrix m_out);  /* out */
int  get_fp_scalar(double  *Re,    /* out */
                   double  *Im     /* out */
                  );
void strings_in_list(int  n_terms,        /* in  length of list[]            */
                     mwIndex *list,       /* in                              */
                     int *n_str,          /* out number of strings in list[] */
                     int *start_ind,      /* out index of 1st string terms   */
                     int *str_len,        /* out length of each string       */
                     int *max_length);    /* out longest string in list[]    */
void sp_copy_column(int col_index_in,     /* in  */
                    int col_index_out,    /* in  */
                    SparseMatrix m_in,    /* in  */
                    SparseMatrix m_out);  /* out */

