\ {{{1 GNU General Public License
{
Program Tops - a stack-based computing environment
Copyright (C) 1999-2005  Dale R. Williamson

Author: Dale R. Williamson <dale.williamson@prodigy.net>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
1}}} 
}

{  File perl.v  April 2001

   Utilities for Perl
}
\-----------------------------------------------------------------------

\  Proposed words for an interactive Perl engine.

\  Setting up a Perl engine requires some C code with pipes and forks 
\  to a running perl program.  Words like these might interface to
\  such a Perl engine:

   inline: perlClose ( --- ) \ close pipe to Perl
   end

   inline: perlEval (hT --- ) \ evaluate text T through Perl engine
\     Used in command loop of word _perl.
      perlRun 
   end

   inline: perlGet (hT --- hT1) \ evaluate T and return result on stack
      perl>
   end

   inline: perlOpen ( --- ) \ open pipe to Perl
   end

\-----------------------------------------------------------------------

   inline: _perl ( --- ) \ Perl command prompt and loop
      [ "<" is quitting, " [perl@" host "] $"
        cat cat spaced is perlPrompt 
        {"
        Running Perl
         - Key < to return to the ready prompt
         - Commands are run by Perl
         - Commands beginning with ; are run by this program
        "} -7 indent makes Header

        no is promptOn
        ";" 1st byte says run_local
      ]
      yes promptOn = IF return THEN \ no recursion; return if running
      yes is promptOn, Header dot perlOpen
      BEGIN nl perlPrompt query (qS), quitting that alike
         IF drop true 
         ELSE strchop any?
            IF nl (qS) run_local that 1st byte =

               IF BL 1st strput main \ running phrase in this program

               ELSE perlEval \ running phrase in Perl

               THEN 

            THEN false
         THEN
         (f) depth one > IF (f) push ok ontop .sf pull THEN (f)
      UNTIL
      no is promptOn
   end

\-----------------------------------------------------------------------

   inline: perl> (hT --- hT1) \ run Perl text T, return output on stack
   \  Uses program files scratch and scratch1.
      [ "#!" perl$ cat makes sh
        "chmod u+x " makes ch
      ]
      any?
      IF sh swap pile scratch save
         ch scratch cat shell
         scratch " > " scratch1 cat cat shell
         scratch1 asciiload notrailing "_perl>" naming
      ELSE 0 0 blockofblanks
      THEN
   end

   inline: perlRun (hT --- ) \ run Perl text T, output to display
   \  Uses program file scratch.
      [ "#!" perl$ cat makes sh
        "chmod u+x " makes ch
      ] 
      any? 
      IF sh swap pile scratch save
         ch scratch cat shell
         scratch shell
      THEN
   end


