/* {{{1 GNU General Public License

Program Tops - a stack-based computing environment
Copyright (C) 1999-2005  Dale R. Williamson

Author and copyright holder of op4_master.c, loadop4.c, saveop4.c, op4.c: 
Al Danial <al.danial@gmail.com>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
1}}} */


/*
 *  This file is automatically generated from the tops file
 *  admin/templates/op4_master.c.  Changes applied to this
 *  file will be lost.
 */

#ifndef __STRICT_ANSI__
   #define __STRICT_ANSI__
#endif
#define _XOPEN_SOURCE 500 /* snprintf */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>      /* fabs */
#include <ctype.h>     /* isdigit, isalpha */


#include "sparse.h"
#include "op4.h"

#include "mex.h"
#define  MAX(a,b)              ((a) >  (b)) ? (a)  : (b)
void get_file_suffix(char *file, char *ext);

void strings_in_list(int  n_terms,        /* in  length of list[]            */
                     mwIndex *list,       /* in                              */
                     int *n_str,          /* out number of strings in list[] */
                     int *start_ind,      /* out index of 1st string terms   */
                     int *str_len,        /* out length of each string       */
                     int *max_length);    /* out longest string in list[]    */



/* constants {{{1 
   would like to have the constant arrays below defined in op4.h
   but they cause 'multiple definition' errors 
 */

const char op4_store_str[3][3] = { {'d',  'n',  0}, 
                                   {'s',  '1',  0}, 
                                   {'s',  '2',  0}  
                           };
const int op4_words_per_term[5] = {-1, 1, 2, 2, 4};
const int Nm_per_term[2]  = {1,  /* numbers per term[real data type]    = 1  */
                             2}; /* numbers per term[complex data type] = 2  */
const char op4_type_str[4][3] = { {'R',  'S',  0}, 
                                  {'R',  'D',  0}, 
                                  {'C',  'S',  0}, 
                                  {'C',  'D',  0}  
                           };
 /* 1}}} */

/* internal functions */

int    flip_bytes_int(int x) {  /* {{{1 */
    int   y;
    char *c_x, *c_y;

    c_x = (char *) &x;
    c_y = (char *) &y;

    c_y[0] = c_x[3];
    c_y[1] = c_x[2];
    c_y[2] = c_x[1];
    c_y[3] = c_x[0];

    return y;
} /* 1}}} */
float  flip_bytes_float(float x) {  /* {{{1 */
    /* Looks identical to flip_bytes_int() and it practice it might
       be possible to use this function and flip_bytes_int() 
       interchangably.  The combination of gcc and x86 hardware may
       cause problems though since floats might be assigned extra
       bytes internally.
     */
    float   y;
    char    *c_x, *c_y;

    c_x = (char *) &x;
    c_y = (char *) &y;

    c_y[0] = c_x[3];
    c_y[1] = c_x[2];
    c_y[2] = c_x[1];
    c_y[3] = c_x[0];

    return y;
} /* 1}}} */
double flip_bytes_double(double x) {  /* {{{1 */
    double   y;
    char    *c_x, *c_y;

    c_x = (char *) &x;
    c_y = (char *) &y;

    c_y[0] = c_x[7];
    c_y[1] = c_x[6];
    c_y[2] = c_x[5];
    c_y[3] = c_x[4];
    c_y[4] = c_x[3];
    c_y[5] = c_x[2];
    c_y[6] = c_x[1];
    c_y[7] = c_x[0];

    return y;
} /* 1}}} */

int  op4_valid_name(char   *name)         /* {{{1 */
{
     /* Returns:
      *    1 if the name passed in is a valid Nastran op4 matrix name
      *   -1 if the name is null
      *    0 if the name is not valid
      */
int DEBUG = 0;

    int i, len, fixed_len;
if (DEBUG) printf("op4_valid_name with [%s]\n", name);

    len = strlen(name);

    /* strip trailing blanks */
    fixed_len = len;
    for (i = len-1; i >= 0; i--) {
        if (ISBLANK(name[i])) {
            name[i] = 0;
            --fixed_len;
        } else {
            break;
        }
    }
    len = fixed_len;

    if (!len) {                            /* null string? */
        return -1;
    } else if (len > 8) {                  /* too long?    */
        return  0;
    } else if (!isalpha((int) name[0])) {  /* first char must be [a-zA-Z] */
        return  0;
    }

    for (i = 1; i < len; i++) {
        /* this test is too conservative; Nastran allows names like 'a+' */
        if (!(ISUNERDSCORE( name[i]) ||
              isalpha((int) name[i]) ||
              isdigit((int) name[i]))) {
            return 0;
        }
    }

    return 1;
} /* 1}}} */

/* words */



void get_file_suffix(char *file,  /* in  {{{2 */
                     char *ext) { /* out */
    int L     = strlen(file);
    int i     = L; 

    *ext = '\0';
    if (strpbrk(file, ".")) {
        while (i && (file[--i] != '.')) { }
        strncpy(ext, &file[i+1], L-i);
    }
} /* 2}}} */
void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
 
    char     filename[80];
    double  *Ai, *Ar;
    int      r, s, j, first_mat, nNZ, storage, size,
             n_str_one_col, ptr_H, ptr_S_start, ptr_N_start, ptr_S, ptr_N,
             n_str, n_ptr, Ar_ptr, Ai_ptr, max_length,
            *start_ind, *str_len;
    mwIndex *row_ind, *col_ind;
             print_header = 1;  /* 1=print matrix info after saving; 0=don't */
    char     ext[80];
    const char *Mname;
 /* validate inputs {{{2 */
    if (nrhs < 2) {
        mexErrMsgTxt("Usage: saveop4(filename, [digits,] matrix_1 [, ... ])\n");
        return;
    }
    if (!mxIsChar(prhs[0])) {
        mexErrMsgTxt("saveop4:  first RHS argument must be a string\n");
        return;
    }
    mxGetString(prhs[0], filename, 80);
    get_file_suffix(filename, ext);
    if ((mxGetN(prhs[1]) == 1) && (mxGetM(prhs[1]) == 1)) {
        /* Second RHS argument is a scalar -- use as digits count */
        digits    = mxGetScalar(prhs[1]);
        if ((digits < -1) || !digits) {  /* allowable values are    */
            digits = 0;                  /* digits = -1, digits = 0 */
        } else {                         /* and 2 <= digits <= 26   */
            if (digits < 2) {
                digits = 2;
            } else if (digits > 26) {
                digits = 26;
            }
        }
        first_mat = 2;
    } else if (!strncmp(ext, "bcd", 3)) {
        digits    = 9;
        first_mat = 1;
    } else if (!strncmp(ext, "bin", 3)) {
        digits    = 0;
        first_mat = 1;
    } else {
        mexErrMsgTxt("saveop4:  second RHS argument must be an integer, the string \"bcd\", or the string \"bin\"\n");
        return;
    }
    nMatrices      = nrhs - first_mat;    /* # of matrices to write out */
/* 2}}} */  
    for (i = first_mat; i <= nMatrices+first_mat-1; i++) {
 /* get handle to matrix from arg list; malloc xfer variable {{{2 */
        if (!mxIsNumeric(prhs[i])) {
            mexErrMsgTxt("saveop4:  input is not numeric matrix\n");
            return;
        }
        if (mxIsComplex(prhs[i]))  {
            complx = 1;
            type   = 4;       /* complex double precision */
        }
        NPT     = Nm_per_term[complx]; 
        sparse  = 0;
        nR      = mxGetM(prhs[i]);
        nC      = mxGetN(prhs[i]);
        Ar      = mxGetPr(prhs[i]);
        if (complx) {
            Ai  = mxGetPi(prhs[i]);
        }
        Mname = mxGetName(prhs[i]);
        strncpy(name, Mname, 8);

        if (mxIsSparse(prhs[i])) {           /* sparse */
            sparse  = 2;
            nNZ     = mxGetNzmax(prhs[i]);
            row_ind = mxGetIr(   prhs[i]);
            col_ind = mxGetJc(   prhs[i]);
            Ar_ptr  = 0;
            Ai_ptr  = 0;

            if (!nR*nC) { /* zero rows and/or columns; make null 1x1 */
                nR      = 1;
                nC      = 1;
                Ar[0]   = (double) 0.0;
                complx  = 0;
                sparse  = 0;
            }

            /* Declare a tops native sparse matrix having only 1 column.   */
            /* Assume worst case values for # strings, # non-zeros.  Have  */
            /* to declare a double to force alignment to multiple of 8.    */
            /* This code duplicates code in the following functions:       */
            /*  - src/sparce.c:sp_data_offsets()                           */
            /*  - src/sparce.c:sp_set_header()                             */
            /*  - src/sparce.c:sparse_overlay()                            */
            n_str_one_col = nR/2 + 1;
            ptr_H         =               SPARSE_MAGIC_SIZE;
            ptr_S_start   = ptr_H       + SPARSE_HDR_SIZE;
            ptr_N_start   = ptr_S_start +     (1 + 1);  /* nCOl = 1 */
            ptr_S         = ptr_N_start +     (1 + 1);  /* nCOl = 1 */
            ptr_N         = ptr_S       + n_str_one_col*sizeof(str_t)/
                                                        sizeof(int);

            if (ptr_N % 2) ++(ptr_N);

            size          = (ptr_N)*sizeof(int) + NPT*nR*sizeof(double);

            if ((A = (double *) malloc(size)) == NULL) {
                mexErrMsgTxt("saveop4:  insufficient memory for matrix column");
                return;
            }
            m.data        = (char   *)   A;
            m.magic       = (int *) m.data;
            m.H           =            &m.magic[SPARSE_MAGIC_SIZE];
            m.S_start     =            &m.magic[ptr_S_start];
            m.N_start     =            &m.magic[ptr_N_start];
            m.S           = (str_t  *) &m.magic[ptr_S      ];
            m.N           = (double *) &m.magic[ptr_N      ];

            m.H[ROWS]     = nR;
            m.H[COLS]     =  1; 
            m.H[COMPLX]   = complx; 
            m.H[n_STR]    = nR/2 + 1; 
            m.H[n_NONZ]   = nR*NPT; 
            m.H[DATA_SIZE]= size;

            if ((start_ind = (int *) malloc(m.H[n_STR]*sizeof(int))) == NULL) {
                mexErrMsgTxt("saveop4:  insufficient memory for start_ind");
                return;
            }
            if ((str_len   = (int *) malloc(m.H[n_STR]*sizeof(int))) == NULL) {
                mexErrMsgTxt("saveop4:  insufficient memory for str_len");
                return;
            }

        } else {          /* dense  */
            if (!mxIsDouble(prhs[i])) {
                mexErrMsgTxt("saveop4:  input is not double precision\n");
                return;
            }

            if ((A = (double *) malloc(NPT*nR*sizeof(double))) == NULL) {
                mexErrMsgTxt("saveop4:  insufficient memory for matrix column");
                return;
            }

        }
/* 2}}} */  /* copy sparse column from matlab variable to tops variable {{{2 */
                strings_in_list(col_ind[c+1] - col_ind[c], /* in  # terms  */
                              &(row_ind[col_ind[c]]),   /* in  row indices */
                              &n_str,                   /* out # strings      */
                               start_ind,               /* out leading index  */
                               str_len,                 /* out string lengths */
                              &max_length);
                m.S_start[0] = 0;
                m.N_start[0] = 0;
                m.S_start[1] = n_str;
                n_ptr        = 0;
                for (s = 0; s < n_str; s++) {
                    m.S[s].start_row = row_ind[col_ind[c] + start_ind[s] ];
                    m.S[s].len       = str_len[s];
                    m.S[s].N_idx     = n_ptr;
                    for (j = 0; j < str_len[s]; j++) {
                        m.N[n_ptr++] = Ar[Ar_ptr++];
                        if (complx)
                            m.N[n_ptr++] = Ai[Ai_ptr++];
                    }
                }
                m.N_start[1] = n_ptr;
/* 2}}} */ 
                               0  ,
 /* copy dense column from matlab variable to tops variable {{{2 */
                if (complx) {
                    for (r = 0; r < nR; r++) {
                        A[2*r    ] = Ar[c*nR + r];
                        A[2*r + 1] = Ai[c*nR + r];
                    }
                } else {
                    for (r = 0; r < nR; r++)
                        A[r] = Ar[c*nR + r];
                }
 /* 2}}} */ 
                               A  ,

        if (sparse) {
            free(str_len);
            free(start_ind);
        }
        free(A);
        if (print_header) {
            printf("saveop4: %-8s %4d x %4d [%2s] %2s dg=%2d  %1d of %1d\n",
                    name, nR, nC, op4_type_str[type-1],
                    op4_store_str[sparse], digits, i-1, nMatrices );
        }



/* code below a direct copy from src/sparse.c */
void strings_in_list( /* {{{1 */
                     int  n_terms,        /* in  length of list[]            */
                     mwIndex *list,       /* in                              */
                     int *n_str,          /* out number of strings in list[] */
                     int *start_ind,      /* out index of 1st string terms   */
                     int *str_len,        /* out length of each string       */
                     int *max_length)     /* out longest string in list[]    */
     /*  list[] contains non-negative integers in ascending order, eg:
      *     n_terms = 7
      *     list[0..6]  =  2, 5, 6, 7, 10, 12, 13
      *  This routine counts the number of blocks of consecutive terms
      *  and also returns the length of the longest string.  In the example
      *  the strings are   (2)  (5,6,7)  (10)  (12,13)
      *  so:
      *      n_str                   = 4 
      *      start_ind[0..(n_str-1)] =  0, 1, 4, 5
      *      str_len[  0..(n_str-1)] =  1, 3, 1, 2
      *      max_length              = 3
      */
{
int DEBUG = 0;
    int i, length_current;

    *n_str         = 0;
    *max_length    = 0;
    length_current = 0;
    if (n_terms > 0) {
        length_current    = 1;
        start_ind[*n_str] = 0;
        str_len[  *n_str] = length_current;
        ++(*n_str);
    } else {
        return;
    }
    for (i = 1; i < n_terms; i++) {
        if (list[i] != (list[i-1] + 1)) {
            length_current    = 1;
            start_ind[*n_str] = i;
            str_len[  *n_str] = length_current;
if (DEBUG) {
printf("list[%d]=%d  list[%d]=%d  nstr=%d   len=%d\n", 
i, list[i], i-1, list[i-1], *n_str, str_len[*n_str]);
}
            ++(*n_str);
        } else {
            ++length_current;
            str_len[*n_str-1] = length_current;
if (DEBUG) {
printf("           nstr=%d   len=%d\n", *n_str-1, str_len[*n_str-1]);
}
        }
        *max_length = MAX(*max_length, length_current);
    }
} /* 1}}} */


