\ {{{1 GNU General Public License
{
Program Tops - a stack-based computing environment
Copyright (C) 1999-2008  Dale R. Williamson

Author: Dale R. Williamson <dale.williamson@prodigy.net>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
1}}}
}
{  File sys/dog.v  September 2002

   Copyright (c) 2002   D. R. Williamson

   Watchdog.

   Simple interprocess communication.
      Words for simple communication, over a shared message file,
      between different instances of this program running, perhaps
      as watchdogs on intruders.

   Words to watch files.
      File can mean regular file, subdirectory, or device.

\-----------------------------------------------------------------------

   The words in this file are listed below.

   syspath "dog.v" cat asciiload this " inline:" grepr reach dot

   Interprocess communication:
   inline: msgClean ( --- ) \ delete communication files
   inline: msgComm ( --- hM) \ fetch all of the communication messages
   inline: msgDel (qS --- ) \ delete message S from the messages
   inline: msgGet (qS --- hM) \ get message S and remove S from messages
   inline: msgGetIP (qS qIP nPort --- hM) \ get msgs for S at IP(Port)
   inline: msgHold ( --- ) \ idle until messages are available
   inline: msgPeek (qS --- hM) \ sneak a peek at messages for S
   inline: msgPeekSocket (qS nSocket -- hM) \ messages S from Socket
   inline: msgPoll (qName --- ) \ create a word that polls for messages
   inline: msgPut (hM qS --- ) \ put new message S with the messages
   inline: msgPutIP (qM qS qIP nPort --- ) \ put msg S(M) at IP(Port)
   inline: msgRel ( --- ) \ give up control of message file
   inline: msgRm ( --- ) \ delete the message file and busy file
   inline: msgToc ( --- ) \ show all the messages

   File watching:
   inline: BUSY ( --- addr) \ global busy flag for all watch words
   inline: dir_watch (qToPath qDir qWord --- ) \ watch files in Dir
   inline: file_watch (qToPath qFile qWord --- ) \ save file on deletion
}
\-----------------------------------------------------------------------

   CATMSG push no catmsg
{
   Interprocess communication.
 
   Simple interprocess communication using a shared message file.
 
      Each line in the text file of messages has the form:

         S Message

      For messages that use more than one line, each line begins with 
      the same pattern S.  Word msgPut will transform a message string
      or the lines of a message text volume to this format, and all 
      lines will be gathered by word msgGet.

      The access status of the communication messages after a word 
      finishes running is noted in its definition below by its "Comple-
      tion status."  Status "Released" means other words can access and 
      change messages; "Hold" means they will be barred from access 
      until Hold is released.  Words msgComm and msgHold are the only 
      ones that exit in the Hold state.

      When a word cannot access the messages, it idles in a loop and 
      checks periodically until they are available (word msgHold).

      Communication is made using two files: msgcomm and msghold.  Here
      are the default file names and how to reset them:

         The messages file (default is /tmp/msgcomm):
            "/path/filename" "msgComm" "File" bank

         The file used for the busy flag (default is /tmp/msghold):
            "/path/filename" "msgHold" "File" bank
}
   inline: msgClean ( --- ) \ delete communication files
\     Completion status: Released
      [ yes is cleanup ] cleanup IF msgRm THEN
   end

   inline: msgComm ( --- hM) \ fetch all of the communication messages
{     Completion status: Hold

      Fetches all the messages and sets Hold, so others cannot see
      or modify them.

}     [ "/tmp/msgcomm" is File ]

      File file?
      IF msgHold File asciiload chop noblanklines
      ELSE no no blockofblanks
      THEN
   end

   inline: msgDel (qS --- ) \ delete message S from the messages
\     Completion status: Released
      msgGet drop ;

   inline: msgGet (qS --- hM) \ get message S and remove S from messages
{     Completion status: Released

      Gets message S and removes it from the communication messages. 

}     1st word (S1 f)
      IF (S1) msgComm (hM) any?
         IF (S1 hM) this 1st word trash them grepe any?
            IF (S1 hM hRows) those rows teeth rake (S1 hM0 hM1)
               (hM1) "msgPut" "msgSave" localrun \ saving what is left
               (S1 hM0) swap (S1) chars tic negate indent chop (hM)
            ELSE (S1 hM) 2drop ""
            THEN
         ELSE (S1) drop ""
         THEN 
      ELSE " msgGet: incoming stack error" ersys ""
      THEN (hM) msgRel
   end

   inline: msgGetIP (qS qIP nPort --- hM) \ get msgs for S at IP(Port)
{     Connect to this program's HTTP server at IP(Port) and get the
      messages for S from the remote interprocess message file.

      Received messages S(M) are removed from the remote's message file.

      Note: This word requires REMOTE_CONNECT1 which is not generally
      available.  It is here for example only, showing how output is
      diverted to a temporary log file while a connection is made.  If 
      there is an error, the log file is displayed before it is deleted
      when the word returns.
}
      [ -1 "S" book ] \ socket to remote HTTP server

      "PORT" book "IP" book
      S -1 > IF S sclose THEN

      SYSOUT "SYSOUTsav" book \ record connection to log file
      ftempsys (qLOG) dup "LOG" book (qLOG) set_sysout

      IP PORT REMOTE_CONNECT1 (nS) \ connection on socket S

      SYSOUTsav set_sysout

      (nS) dup 0< 
      IF LOG asciiload . nl \ display log file
         " msgGetIP: connection from X failed" "X" IP strp . nl
         (qS nS) 2drop 
         
      ELSE " msgGetIP: connected to " IP + . nl
         (nS) "S" book

         (qS) strchop quoted " msgGet remotefd remoteput" + (qT) 

         (qT) dup push S remoterun1 (hT)
         " msgGetIP sent: " . pull (qT) . nl

         (hT) any?
         IF " msgGetIP OK: " . nl dup 3 indent . nl (hT)
         ELSE " msgGetIP: no message" . nl "" 
         THEN 

         -1 S sclose "S" book
         " msgGetIP: connection closed" . nl
      THEN
      LOG delete
   end

   inline: msgHold ( --- ) \ idle until messages are available
{     Completion status: Hold

      Waits for messages to become available, then holds the messages 
      so others cannot see or modify them.

      Later, word msgRel is run to again make the messages available
      to others.

      A one-byte file is used to broadcast the Hold flag.  Over a 
      shared network, the file must be closed every time it is acces-
      sed.  If not, there is huge latency (perhaps 10 or 15 seconds) 
      before other machines reading the file get the latest update.

      By closing the file on every access, response between machines 
      is instantaneous (at least on the scale of human reaction times).

      Here is a phrase that runs msgHold for more than maxwait (about
      2 seconds), forcing msgRel (a "hit maxwait" message) and return:
         "msgHold" "capture" localrun \ set non-null byte
         4 "msgRel" ALARM \ delay release beyond 2 seconds
         msgHold \ holding

      Here is a phrase that runs msgHold for less than maxwait seconds,
      resulting in normal termination (no "hit maxwait" message)
         "msgHold" "capture" localrun \ set non-null byte
         1 "msgRel" ALARM \ release before 2 seconds
         msgHold \ holding
}
      [ "/tmp/msghold" is File \ a one-byte file
        .25 (sec) is wait
        2 (sec) is maxwait

        no into hFile
        no is total

        {" Setting non-null byte:
              File forn binary "hFile" open
              NLch hFile dup rewind fput hFile close
        "} "capture" inlinex

        {" Checking for non-null byte:
              File forn binary "hFile" open
              hFile one fget nullbyte strmatch 0<> hFile close (f)
        "} "busy" inlinex

      ]
      hFile filetrue IF hFile close THEN

      BEGIN busy 
         IF wait dup idle total bump
            " msgHold: " runid + " idling " + dot date dot nl
         ELSE capture return \ the short way out
         THEN 
         total maxwait > 
         IF msgRel yes
            " msgHold: " runid + " hit maxwait " + dot date dot nl
         ELSE no
         THEN
      UNTIL 

      capture
   end

   inline: msgPeek (qS --- hM) \ sneak a peek at messages for S
{     Completion status: Released

      Messages remain on the message file.
      M has zero rows if there are no messages for S.
      Works even if there is a Hold on the messages. 
}
      "msgComm" "File" yank into File
      File file?
      IF File asciiload chop noblanklines (hM) any?
         IF this 1st word drop (qS hM) them grepe any?
            IF (S1 hM hRows) those rows teeth rake (S1 hM0 hM1) drop
               (S1 hM0) swap (S1) chars tic negate indent chop (hM)
            ELSE (S1 hM) 2drop ""
            THEN
         ELSE (qS) drop ""
         THEN
      ELSE (qS) drop ""
      THEN
   end

   inline: msgPeekSocket (qS nSocket -- hM) \ messages S from Socket
\     Mon Jun  8 06:06:31 PDT 2009

\     Note: Socket is not closed by this word.

      (nSocket) swap
      (qS) quoted " msgPeek remotefd remoteput" + swap remoterun1 (hM)
   end

   inline: msgPoll (qName --- ) \ create a word that polls for messages
{     Creates a word called Name to poll for messages and act upon the 
      ones that have its name.

      Any number of words can be created by this word, msgPoll.

      After it is created, Name can be started in the multitasker (using
      word PLAY or word TASK) to begin polling.

      Message strings are sent to word Name using msgPut:
         "quoted phrase 1" "Name" msgPut
         "quoted phrase 2" "Name" msgPut
         "quoted phrase 3" "Name" msgPut

      A volume of text strings can also be sent to Name using msgPut:
         (hMessage) "Name" msgPut
      where Message can contain many lines of text.

      Messages are stacked by word msgPut in the order received, with 
      latest one last.
}
      [  
       {" This is the text for the word called Name to be created:
         [ defname is Name

         \ The stack diagram for Cyc and Ack is (qName --- ), so the
         \ initial ptr for them is set to the ptr to word drop:
              "drop" ptr is Cyc \ the cyclic task, run every cycle
              "drop" ptr is Ack \ the task run when message is received
         ]
{        Cyc and Ack are words being run (by exe) whose ptrs have been
         banked here.  But they are not like inlines that may have been
         created here when word Name was created, and so do not share 
         Name's local library.  They see only their own local libraries,
         not Name's, and so they will need to use word extract to get 
         anything out of the library of Name.

         Example 1 in the Appendix explores some uses of words for Cyc
         and Ack, including the issue of their local libraries.
}
       \ These phrases are run every time word Name runs:

       \ This word is running in the multitasker.  Put it to sleep
       \ until it is ready to exit (probably not really necessary):
         Name SLEEP 

       \ MsgGet can be time consuming if others have a hold on the
       \ message file (word msgHold), so use msgPeek first to see if 
       \ there are any messages:
         Name msgPeek chars any
         IF
          \ Get the mail:
            Name msgGet (hM) any?
            IF "M" book
               Name Ack exe  \ perform acknowledgement task
               M any?        \ ack task may have deleted M or banked new
               IF (hM) local \ run phrase M
               THEN
            THEN
         THEN

       \ Perform the cyclic task:
         Name Cyc exe 

         Name WAKE

       "} into Ftext \ this is the text used to create word called Name
      ] 
    \ These phrases are run at the time word Name is created:
      (qName) "Name" book  \ name of word to make

      CATMSG (f) no catmsg \ turn off console 'into catalog' message

      Ftext Name inlinex   \ making Name using phrases in Ftext

      (f) catmsg           \ reset console message flag
   end

   inline: msgPut (hM qS --- ) \ put new message S with the messages
\     Completion status: Released

\     Puts this new message with the current messages.

      [ "(hM) noblanklines 'msgComm' 'File' yank save" "msgSave" inlinex
      ]
      spaced nose (hM0)
      msgComm (hM1) swap (hM1 hM0) pile \ newest message on the bottom
      (hM) msgSave 
      msgRel
   end

   inline: msgPutIP (hM qS qIP nPort --- ) \ put msg S(M) at IP(Port)
{     Connect to this program's HTTP server at IP(Port) and put message
      M for S on the remote interprocess message file.

      If M is a text VOL, only the first line is taken.

      Note: This word requires REMOTE_CONNECT1 which is not generally
      available.  It is here for example only, showing how output is
      diverted to a temporary log file while a connection is made.  If 
      there is an error, the log file is displayed before it is deleted
      when the word returns.
}
      [ -1 "S" book ] \ socket to remote HTTP server

      "PORT" book "IP" book
      S -1 > IF S sclose THEN

      SYSOUT "SYSOUTsav" book \ record connection to log file
      ftempsys (qLOG) dup "LOG" book (qLOG) set_sysout

      IP PORT REMOTE_CONNECT1 (nS) \ connection on socket S

      SYSOUTsav set_sysout

      (nS) dup 0< 
      IF LOG asciiload . nl \ display log file
         " msgPutIP: connection from X failed" "X" IP strp . nl
         (hM qS nS) drop 2drop 
         
      ELSE " msgPutIP: connected to " IP + . nl
         (nS) "S" book

         (hM hS) swap 1st quote notrailing quoted spaced
         swap strchop quoted + " msgPut" + (qT) \ phrase: "M" "S" msgPut

         (qT) "T" book 

         T " ACK" + S remoterun1 (f)

         IF " msgPutIP OK: " ELSE " msgPutIP FAILED: " 
         THEN T + . nl

         -1 S sclose "S" book
         " msgPutIP: connection closed" . nl
      THEN
      LOG delete
   end

   inline: msgRel ( --- ) \ give up control of message file
\     Completion status: Released

\     Broadcasting that messages are available by setting null
\     byte in msgHold File (the busy file).

      [ no into hFile ]

      hFile filetrue IF hFile close THEN
      "msgHold" "File" yank (qFile)

    \ Setting a null byte where Hold.capture set a non-null byte:
      (qFile) forn binary "hFile" open
      nullbyte hFile fput, hFile close

      no "msgHold" "total" bank
   end

   inline: msgRm ( --- ) \ delete the message file and busy file
      "msgComm" "File" yank deleteif 
      "msgHold" "File" yank deleteif ;

   inline: msgToc ( --- ) \ show all the messages
\     Completion status: Released
      time ctime -3 indent . 
      " Messages in " "msgComm" "File" yank ":" cat cat .
      msgComm (hM) msgRel (hM) any?
      IF (hM)
      ELSE "no messages"
      THEN two indent nl .
   end

\  Initialization.

\  Default paths for msgcomm and msghold:
   "HOME" env "msgcomm" catpath "msgComm" "File" bank
   "HOME" env "msghold" catpath "msgHold" "File" bank

\  Making a msgHold file if there is none or if the existing one has
\  zero bytes:
   "msgHold" "File" yank (qFile) this file?
   IF (qFile) filesize 0= IF msgRel THEN
   ELSE (qFile) drop msgRel
   THEN

\-----------------------------------------------------------------------

\  File watching.

   inline: BUSY ( --- addr) \ global busy flag for all watch words
\     Used to constrain sampling to one watch word at a time, so con-
\     secutive lines in DGLOG are for that word.
      [ scalar "busy" book, no busy ! ] busy (addr)
   end

   inline: dir_watch (qToPath qDir qWord --- ) \ watch files in Dir
{     This word makes a word called Word to watch creation, deletion,
      and modification of files in Dir.  Running Word in the multitasker
      allows continuous monitoring of the files in Dir.  

      This word looks at file times, while word file_watch looks at 
      file sizes.

      Example. Making a directory-watch word D1 and starting it at 
      sample rate 4 Hz:

         "/tmp" "/home/ftp" "D1" dir_watch
         4 (Hz) "D1" PLAY

      While the directory-watch word runs and new files appear in Dir, 
      or existing ones change or disappear, an action word in the cre-
      ated directory-watch word is fired.

      The action word receives lists of new and changed files (hFnew),
      and files gone since the last sample (hFgone), under the follow-
      ing stack diagram:

         Action (hFnew hFgone --- )

      As examples, the action word might examine list Fnew and set a 
      file-watch word to monitor changes in a new file or in a changing
      file; or, the action word might deactivate a previous file-watch
      word when the file it is watching is reported gone.

      The ptr to an action word is banked into each directory-watch
      word, so any variety of actions can be taken.  To bank the ptr to
      an action word into a directory-watch word, say one called D1, a
      phrase of the following form is used:

         "Start_dogs" ptr "D1" "Action" bank

      where Start_dogs is the action word, and it has the stack diagram:

         Start_dogs (hFnew hFgone --- )

      This program allows changes at any time to items in a word's local
      library, even while it is running under the multitasker.  So while
      a directory-watch word runs, a new action word can be banked into
      its library and the new action will immediately take effect, as in

         "More_dogs" ptr "D1" "Action" bank

      The default action word, in any directory-watch word created, is
      the ptr to 2drop, to drop the two incoming lists from the stack.
      Thus a directory-watch word will run with no action word banked,
      and simply report changes in log file DGLOG.

      The default name of file DGLOG is built into dir_watch, and can
      be changed by banking a new one into dir_watch before directory-
      watch words are made.  Here is sourcing this file and viewing
      the default DGLOG file name on a user's machine:

         [tops@clacker] ready > "dog.v" source
          word BUSY into catalog
          word dir_watch into catalog
          word file_watch into catalog

         [tops@clacker] ready > "dir_watch" "DGLOG" yank .
         /home/dale/dirwatch.log

      File-watch words use the same DGLOG file name, so all logging is 
      in consistent time order.  The global flag BUSY is used to con-
      strain logging to one word at a time.

      ToPath is where file-watch words, started by the directory-watch
      words, will write their watched-file results.

      Notes on file time.

         For directories on a network, the time for a file just written 
         can vary from the machine's clock time.  To overcome this pro-
         blem, word net_file_time is used to determine the time delta 
         needed to add to file times to align them with machine time.  

         The file time delta, dT, is determined only when Word is cre-
         ated.  If Word is used to monitor a directory on a network, 
         accurate dT is important.  To keep dT current, it may be re-
         quired to run word net_file_time periodically and bank an up-
         dated dT into Word (perhaps by a word running under the multi-
         tasker).

         Note that word filetime gives modification times, and will not
         catch the case where the date is preserved while a file is 
         copied or moved within a directory.  But word filectime will 
         catch such cases, and it is used below.
}
      [ "HOME" env "/dirwatch.log" + "DGLOG" book \ default log file

       {" A local word to characterize the directory:
          Dir dirnames Dir nose (hFname) dup

          (hFname) filectime \ catches cp and mv with preserved dates
          dT plus            \ clock delta added to file times 

          dup totals ontop (hFname hFtime nTag)
       "} "tag" book

       {" This is the text for Word to be created:
         [ "" is ToPath, "" is Dir, no is seen, no is gone

           "dir_watch" "tag" yank "tag" inlinex

           "dir_watch" "DGLOG" yank "DGLOG" book \ get log file name
           "2drop" ptr "Action" book             \ set default Action

           defname is myName
         ]
           BUSY @ IF return THEN yes BUSY !
           Dir dir?
           IF seen not
              IF yes is seen
                 time "Time" book
                 tag (hFname hFtime nTag)
                 "Tag" book "Ftime" book "Fname" book
              ELSE
                 time "Time1" book
                 tag (hFname hFtime nTag) 
                 "Tag1" book "Ftime1" book "Fname1" book

                 Tag Tag1 <> \ has Tag changed?

                 IF SYSOUT (S) push DGLOG set_sysout \ write to DGLOG

                  \ Files with times later or same as last time must 
                  \ have changed or are new:
                    Fname1 Ftime1 Time those rows repeat >=
                    rake lop (hT) any?
                    IF (hT) time ctime . sp
                       myName ": dir_watch files new or changed:" + . nl
                       these rows 1st 
                       DO this I quote strchop its dir? 
                          IF "" catpath THEN three spaces . . nl
                       LOOP (hT)
                    ELSE no no blockofblanks (hT)
                    THEN (hT) "Fnew" book
      
                  \ Files from last time that have disappeared:
                    Fname dup filesize 0<
                    rake lop (hT) any?
                    IF (hT) time ctime . sp
                       myName ": dir_watch files gone:" + . nl
                       dup chop three indent . nl
                    ELSE no no blockofblanks (hT)
                    THEN (hT) "Fgone" book

                    flush_sysout
      
                  \ Resume SYSOUT before running the action word, since
                  \ it may have its own log file:
                    pull (S) set_sysout \ resume writing to SYSOUT

                  \ Running the action word:
                    Fnew Fgone Action exe

                  \ Advance the references, forgetting the past:
                    Fname1 "Fname" book
                    Ftime1 "Ftime" book
                    Time1 "Time" book
                    Tag1 "Tag" book
                 THEN
              THEN

           ELSE gone not
              IF yes is gone
                 SYSOUT (S) push DGLOG set_sysout \ write to DGLOG
                 time ctime . sp 
                 myName ": subdirectory gone: " + . nl
                    Dir . nl
                 pull (S) set_sysout \ resume writing to SYSOUT
              THEN
           THEN 
           no BUSY !
       "} into Ftext
      ]
      other other (qToPath qWord) alike
      IF " dir_watch: ToPath must be different from Dir"
         " (and ToPath must not be within Dir, or logged activity will"
         " generate more and more activity; this is not checked)"
         + + sp COLS .out nl "" ersys return
      THEN
      (qWord) "Word" book
      CATMSG (f) no catmsg
      Ftext Word inlinex \ making Word
      (f) catmsg

      (qDir) "" catpath dup (qDir)

      (qDir) Word "Dir" bank              \ banking Dir name into Word

      (qDir) dup "test" + fallow 
      IF net_file_time    \ newtork dT
      ELSE (qDir) drop 0  \ can't test; set dT to zero
      THEN Word "dT" bank \ banking file time delta

      (qToPath) Word "ToPath" bank \ banking the to-path for file_watch
   end

   inline: file_watch (qToPath qFile qWord --- ) \ save file on deletion
{     This word makes a word called Word to watch creation and deletion
      of File.  Running Word in the multitasker will monitor the comings
      and goings of File.

      This word looks at file sizes, while word dir_watch looks at 
      file times.

      As File is deleted or rendered smaller, its contents that were
      captured while it was being watched are written to another file
      at ToPath.

      Example:
         Making file_watch word f1 to watch for arrival of a particular
         file:
            "/home/data/" "/home/ftp/newdata.c" "f1" file_watch

         This line starts f1 in the multitasker to continuously grab
         new portions of file /home/ftp/newdata.c as it grows, and save 
         everything collected if it disappears:
            4 (Hz) "f1" PLAY

         When newdata.c arrives, f1 will capture newer portions of it 
         in memory it as is being written.  

         When /home/ftp/newdata.c shrinks or disappears, f1 will write 
         its memory contents to file newdata.c.1, at /home/data.  

         It then continues watching for another instance of newdata.c.

         Note that nothing will be saved at /home/data if the file
         being watched never shrinks or disappears.
}
      [
       {" This local inline saves the captured text to file at ToPath:

         hFile filetrue not IF no is seen return THEN
         hFile close

         nl time ctime . sp "myName" local .
          ": " . File . " saved;" . no is seen

         ToPath File -path catpath
         "." count suffix cat (qF) this deleteif

         (qF) T chars .i " bytes to " . dup . nl
         (qF) forn binary "hFile" open hFile any?

         IF (hFile) T over fput (hFile) close
         ELSE " save: invalid file handle" . nl
         THEN

       "} "save" book

       {" This is the text for Word to be created:
         [ "" is ToPath, "" is File, no is hFile, no is fptr
           no is count, no is T, no is seen

           "dir_watch" "DGLOG" yank "DGLOG" book

           "file_watch" "save" yank "save" inlinex

           defname is myName
           no no blockofblanks into T \ initialize
         ]
           BUSY @ IF return THEN yes BUSY !
           SYSOUT (S) push DGLOG set_sysout \ write to DGLOG
           File file?
           IF File filesize one > \ bigger than one byte
              IF seen not
                 IF yes is seen
                    time ctime . sp 
                    myName ": " File " here" cat cat cat .

                    hFile filetrue IF hFile close THEN
                    File old binary "hFile" open, hFile any?

                    IF (hFile) INF fget (hT) into T
                       hFile fpos into fptr
                       count tic into count
                    ELSE no is seen " open failed" . 
                    THEN nl

                 ELSE
                    File filesize dup fptr <
                    IF \ file has shrunk; save the grabbed bytes:
                       (filesize) drop save
                    ELSE \ if file is growing, grab latest bytes:
                       (filesize) fptr >
                       IF \ file is growing; must close and reopen
                          \ to get the size right in hFile:

                          hFile filetrue IF hFile close THEN
                          File old binary "hFile" open hFile any?

                          IF (hFile) fptr fseek \ to end of prev fget
                             T hFile INF fget (hT) park into T
                             hFile fpos into fptr
                          ELSE time ctime . sp 
                             myName ": " File cat cat .
                             " open failed after size" . nl
                          THEN

                       THEN
                    THEN
                 THEN
              ELSE save \ file has shrunk; save the grabbed bytes
              THEN
           ELSE \ file gone; save the grabbed bytes if seen:
              seen IF save THEN
           THEN 
           pull (S) set_sysout \ resume writing to SYSOUT
           no BUSY !
       "} into Ftext
      ]
      (qWord) "Word" book
      CATMSG (f) no catmsg
      Ftext Word inlinex \ making Word
      (f) catmsg
      (qFile) Word "File" bank \ banking File name into Word
      (qToPath) Word "ToPath" bank \ banking the to-path for saved bytes
   end

   pull catmsg halt

\-----------------------------------------------------------------------

;  Appendix.

   Example 1.

   This example shows some behavior of a word created by msgPoll.

   It explores how a message acknowledgment task (Ack) and a cyclic 
   task (Cyc) performed by msgPoll words can be installed into them, 
   and shows some simple control of behavior using messages sent.

   To run Example 1, first source its Part 1 using this phrase:

      "dog.v" "Part 1." msource

   Loading Part 1 creates word D1 and starts it running every four
   seconds.

   Then move down to Part 2 and copy and drop the phrases there to 
   affect word D1, now running.

\  ------------------------------------------------------------------
   Part 1.

   "msgPoll" missing IF "dog.v" source THEN
   "ranint" missing IF "math.v" source THEN

   "D1" msgPoll

\  Banking a message acknowledgement task into D1:

   inline: ackD1 (qName --- ) \ acknowledgement
\     D1 acknowledging receipt and time.
      drop "D1: received on " time ctime cat nl . nl
   end

   "ackD1" ptr "D1" "Ack" bank

\  Banking a cyclic task into D1:

   inline: cycD1 (qName --- ) \ cyclic task
{     D1 showing a random sample of some data in its library.
      This task is performed on every cycle.

      A ptr to this word is in D1's libaray and is run by D1.  But 
      this word still cannot see anything in D1's libary.  It needs 
      words bank and yank as used below to access the library of D1 
      where its ptr resides.
}
      drop "D1" "DATA" yank (hDATA) \ yank DATA from D1
      (hDATA) 1st those rows ndx 6 1 ranint reach (hdata)
      "D1" . (hdata) .i nl

      [ 1 1000 uniform "D1" "DATA" bank ] \ bank initial DATA into D1
   end

   "cycD1" ptr "D1" "Cyc" bank

\  Starting D1 running at 1/4 Hz:

   1 4 / (Hz) "D1" PLAY

   private halt

\  ------------------------------------------------------------------
   Part 2. 

\  Things to run while D1 is running:

\  Shows D1 running at 0.25 Hz:
   tasks 

\  Sending D1 a message to negate its DATA (remember there is a lag of 
\  up to 4 seconds since D1 is running at 1/4 Hz): 
   "DATA negate 'DATA' book" "D1" msgPut \ D1 will acknowledge

\  Sending D1 a message to turn its cyclic task off (an alternative
\  to just directly banking noop as in: "noop" ptr "D1" "Cyc" bank):

   '"drop" ptr into Cyc' "D1" msgPut \ D1 will acknowledge

\  Shows D1 still running (its just not doing the cyclic task):
   tasks 

\  Sending D1 a message to turn cyclic task back on:
   "'cycD1' ptr into Cyc" "D1" msgPut \ D1 will acknowledge

\  Changing D1's rate:
   1 2 / (once every two seconds) "D1" PLAY
   1 4 / (once every four seconds) "D1" PLAY

\  Stopping D1 entirely, and starting it again:
   "D1" SLEEP 
   tasks
   "D1" WAKE 

\  D1 Gone completely:
   "D1" OMIT
   tasks

   private halt

\-----------------------------------------------------------------------
