\ {{{1 GNU General Public License
{
Program Tops - a stack-based computing environment
Copyright (C) 1999-2005  Dale R. Williamson

Author: Dale R. Williamson <dale.williamson@prodigy.net>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
1}}} 
}

{ File mat.v  October 1999

   Copyright (c) 1999   D. R. Williamson
}

   CATMSG push no catmsg

\-----------------------------------------------------------------------

\  Matrix and vector operations:

\ TO DO: add above and below to mat.c, and remove A(i) restrictions.

   define: above (hA x --- hA1) \ values in A above x, zeroes elsewhere
{     Example: 
        list: 1 10 2 20 3 30 ; is A, A A 4 above A 4 below park park .m
      Warning: meant for A(i) > 0; will miss 0 values in A--see greater
}     [ "that rose negate +d, these dims empty max, zero pow *by"
        "above" inlinex ] above ;

   inline: align (hD1 hC1 hD2 hC2 --- hD hC1' hC2')
\     Align C1, for dates D1, with C2 for dates D2.
\     Outgoing C1' and C2' both apply to dates D=D1+D2.
      over swap park "B2" book push
      over swap park "B1" book pull
      (hD1 hD2) pile nodupes yes sort (hD)

    \ adjust to mininum size:
      B1 rows B2 rows min push
      B1 peek endmost "B1" book
      B2 peek endmost "B2" book
      pull endmost (hD)

      (hD) B1 over those cows nit clone look (hC1')
      (hD hC1') B2 other those cows nit clone look (hC2')
      freed "B1" book
      freed "B2" book
   end

   define: and0 (hR1 hR2 --- hR) \ R=0 where R1 and R2 rows are null
      park nullr "0_rakes_both_null" naming ;

   define: below (hA x --- hA1) \ values in A below x, zeroes elsewhere
\     Warning: meant for A(i) < 0; will miss 0 values in A--see beneath
      [ "that rose negate +d, these dims empty min, zero pow *by"
        "below" inlinex ] below ;

   define: columnMaxMin (hA --- hB) \ max and mins of each column of A
{     Returned B has number of rows equal the number of columns of A 
      and two columns, where column 1 contains maximums and column 2 
      contains minimums as follows:
         row N of column 1 contains max of A col N
         row N of column 2 contains min of A col N
}     [ {"
           left two empty, rose, dup push cows 1st
           DO peek I catch dup, maxfetch 2drop
              swap minfetch 2drop park pile
           LOOP pull drop
        "} "mm" inlinex 
      ] mm 
   end

   define: compare (A B --- C%) 100 2 compareRef ;

   define: compareAbove (A B eps --- C%)
\     Compares values above threshold eps:
      rot over filter, rev filter, 100 2 compareRef ;

   inline: eqrows (hA --- hB) \ B(k,j) is true where A(k,j)==A(k+1,j)
{     Thu Jun 25 14:33:13 PDT 2009

      In column j of B, row k is true if A(k,j) and A(k+1,j) are equal.       It follows that the last row of B must be false for all columns.
      Columns of incoming A must already be in ascending order.
}
      (hA) push
      peek (hA) 1st peek rows 1- items reach
      peek (hA) 2nd peek rows 1- items reach - 0=
      1 pull cols null pile (hB)
   end

   inline: get_same (qF1 qS1 qF2 qS2 --- f)
\     Files F1 and F2 were written by word put, and are read by
\     word get; S1 and S2 may be type MAT or type VOL.

\     Get S1 and S2 and return true if the bytes of S1 on file F1 are 
\     the same as the bytes of S2 on file F2.

      [ no "F1" book no "F2" book ]

      F1 filetrue IF F1 fclose THEN
      F2 filetrue IF F2 fclose THEN

      "S2" book "F2" book "S1" book "F1" book
      F1 file? not
      F2 file? not or IF false return THEN

    \ Below, file names F1 and F2 become file handles:
      F1 old binary "F1" file
      F2 old binary "F2" file

      F1 S1 get this type VOL = IF vol2mat THEN (hA1)
      F2 S2 get this type VOL = IF vol2mat THEN (hA2)

      (hA1 hA2) over sizeof over sizeof =
      IF (hA1 hA2) xor nullc totals @ 0= \ true when all cols are null
      ELSE (hA1 hA2) 2drop false
      THEN

      F1 fclose
      F2 fclose
   end

   inline: load_demo ( --- hC) \ time histories for demos
{     Loading the matrix on file usr/plotdemo.bin

      Loading model data for DJIA index nearest future, 1310 market
      days (5 years) ending December 19, 2002.

      Columns of C:
         1-3 bull dogs
         4-6 bear dogs
           7 DJIA nearest future, 10-06-97 to 12-19-02
}     
      syspath "../usr" cat "plotdemo.bin" catpath (qFile) dup file?
      IF (qFile) yes ELSE drop no THEN (no | qFile yes)

      its not IF drop "plotdemo.bin" filefound (no | qFile yes) THEN

      (no | qFile yes)
      IF
         (qFile) old binary "File" this closeif open
         File its file.size pry fget (hT)
         PDP_ENDIAN import2 (hA) \ 2-byte int data from file
         File close

         (hA) 1310 (days) foldr (1310-by-7) (hA)
         "_demo" naming (hC) \ column 7 is DJIA nearest future

      ELSE " load_demo: file not found: plotdemo.bin" . purged (hC)
      THEN (hC)
   end

   inline: looking2 (hV hU hR --- hW) \ V(R!=0) and U(R==0) into W
{     Fri Feb 27 16:21:23 PST 2009
 
      Where R(k) is equal to 0 (false), W(k) equals U(k) and where
      R(k) not equal to 0, W(k) equals V(k).

      Equivalent to the following:
         R = V<X;             // R(i) is true where V(i)<X(i)
         (x, y) = rake(U, R); // use false part, x
         (u, v) = rake(V, R); // use true part, v
         W = tier(x, v, R);        
}
      (hR) dup push
      (hU hR) rake drop (hW0)       \ false part of U on stack
      swap (hV) peek rake lop (hW1) \ true part of V on stack
      (hW0 hW1) pull (hR) tier (hW)
   end

   define: or0 (hR1 hR2 --- hR) \ R=0 where R1 or R2 rows are null
      nullr swap nullr *by "0_rakes_either_null" naming ;

   inline: Rstore (hC hX hRows --- hC1) \ ram X into Rows of C
\     Matrices C and X are complex; returned complex C1 contains old C,
\     with X at Rows.

      "R" book, real-imag (Xr Xi) push push
      (hC) real-imag (hCr hCi)

      (hCr hCi) pull (Xr) R three pick (hCr) ram
      (hCr hCi) pull (Xi) R two   pick (hCi) ram (hCr hCi) complex

      purged is R
   end

   inline: scrape (hA x --- hA1) \ replace terms smaller than x with x
      says tiny this is_complex
      IF real-imag (hAr hAi)
         tiny scrape swap (hAr)
         tiny scrape swap (hAi)
         (hAr hAi) complex (hA1)
      ELSE
         these rows into r chain, 
         tiny above again this push rake
         tiny rot dims fill, 
         swap pull tier r fold (hA1)
      THEN
   end

   pull catmsg halt

\-----------------------------------------------------------------------

;  Appendix

  _inline: readop4 (qFile --- hA) \ read a Nastran text .op4 file
\     Warning: assumes all values for each column are present, i.e.,
\     that no zeroes have been skipped to cause the column to be
\     written in two or more pieces.

\     For format (1p,3e23.15)
      [ 3 "perline" book, 23 fieldwidth ]

      asciiload into T, T 1st quote numerate
      this 1st pry into Cols, 2nd pry into Rows

      Rows perline /mod swap 0> IF 1+ THEN into Lines

      2nd 1+ into nline, Cols 1st
      DO T nline Lines items reach push
         perline 1st
         DO peek I field crop, " " tail LOOP
         pull drop perline parkn
         numerate, 1st Rows items reach
         nline Lines + 1+ into nline
      LOOP Cols parkn
   end


  









