{ File usr/uboot.v (at usrpath)

   User additional words at boot time.

   When this file is present, it will be sourced by boot.v during
   start up.
}
   uboot_done 
   IF " uboot.v: only at start up" . nl halt THEN \ only source once

\  The words from sys/uboot.v are obtained by sourcing it first, and 
\  then you can override or add to them with the ones in this version.

\  Sourcing the system sys/uboot.v if it is found:
   syspath "uboot.v" cat filefound IF source THEN

\  What follows is run at start up, after the system's sys/uboot.v runs.

\  Phrases always run at start up go below here.

\-----------------------------------------------------------------------

\  Files to always be sourced at start up (like: "myfile.v" source):
      "_pppconnect" missing IF "web.v" source THEN

\  Setting verbose display in NISTdelta, to show each connection:
   "NISTdelta" exists?
   IF yes "NISTdelta" "VERBOSE" bank THEN

\-----------------------------------------------------------------------

\  Network:
   {"
      127.0.0.1     loopback
      102.128.1.254 clacker
      102.128.1.253 plunger
      102.128.1.252 diego
      102.128.1.251 riggo
      102.128.1.250 rugger
   "} chop dup
   "CLIENT_ALLOW" "clients" bank
   "SERVER_ALLOW" "clients" bank

{  Info: this shows file /etc/sysconfig/network-scripts/ifcfg-eth0 on
   each machine (RH 7.3):
      DEVICE=eth0
      ONBOOT=yes
      BOOTPROTO=static
      IPADDR=202.108.1.25X
      NETMASK=255.255.255.0
      #GATEWAY=202.108.1.25X

   File ifcfg-eth0 is sufficient to enable networking between machines.
   Just plug in cables between them.
}

\ Here is an example of fetching the dynamic IP address from a vendor
\ under DHCP DSL:

host "plunger" = getlogin "dale" = and
IF \ the author's machine and its DSL, replacing word IPlocal just
   \ created above when web.v was sourced:
   inline: IPlocal ( --- qS)
{     For machine plunger, using Verizon DSL.

      Connect to the Verizon web interface on network 192.168.1.1 and
      get the web page that contains the dynamic IP address (running
      HTTPget in quotes using >stk puts the HTTPget text normally
      written to the display (describing the connection and speed)
      into VOL T on the stack, which is then dropped):
}     "192.168.1.1" (gateway)
      "/router_stat.htm" "HTTPget" >stk (hT) drop (hHTML)

{     Extract the IP address from the returned Verizon HTML (setting
      this up to use word between requires viewing the HTML in an 
      editor, like vi, to see what unique text surrounds the IP 
      address):
}     (hHTML) "Broadband IP Address:" "</TR>" between \ phrase with IP
      (hHTML) '">' '</TD>' between \ just the IP
      (hHTML) vol2str (qS) strchop (qS)
   end
THEN

\-----------------------------------------------------------------------

\  Setting display and options if on certain machines:

   host "sigma" alike
   host "clacker" alike or
   host "gutter" alike or
   IF getlogin "jdoe" alike \ is it me?
      IF
       \ Setting my display:
         "DISPLAY=140.125.68.46:0.0" setenv 

       \ Path for fbook files:
         "/scratch" "fbook" "path" bank 

       \ Additional files I want to source at start up when running
       \ on the hosts listed above:

         "nas.v" filefound IF source THEN \ words for Nastran

      THEN
   THEN

   host "crab" alike
   IF
      define: anchove ( --- ) \ remote login to machine anchove
         "xtermsb" "XSET" yank \ save original

         TERM
         "-bg MidnightBlue -fg NavajoWhite -cr Salmon -fn 7x14 " cat
         "-display " "DISPLAY" env spaced cat cat
         "-sb -sl 1024 -geometry 72x32+1+1 -title " cat
         "xtermsb" "XSET" bank 

         "rlogin anchove" xtermsb
         
         "xtermsb" "XSET" bank \ put original back
      end

    \ Allow these machines to connect to each other:
      depth push
         "clacker" IPhost
         "diego" IPhost 
         "gutter"  IPhost
         "plunger" IPhost
         "rugger" IPhost
         "riggo" IPhost
      depth pull less pilen "SERVER_ALLOW" "clients" bank
   THEN

\  My words to allow file and path names without quotes:

   host "gutter" alike host "clacker" alike or
   IF
      "'march.v'"  "march.v"  inlinex
      "'mfil.v'"   "mfil.v"   inlinex
      "'mday.v'"   "mday.v"   inlinex
      "'mini.v'"   "mini.v"   inlinex
      "'mweb.v'"   "mweb.v"   inlinex

      inline: mdat ( --- ) mdat.v source keys ;
      inline: mday ( --- ) mday.v source ;

      inline: mweb ( --- ) 
      \  getuid 0<> IF " Must be root" . nl return THEN
         mweb.v source \ webstart 
      end

      "'/home/dale/mdat/'" "mpath" inlinex
   THEN

   private halt

\-----------------------------------------------------------------------

   This section is not sourced. 
 
   Examples.

\  Parameters saved at exit and read at start up.

   inline: params_get ( --- ) \ gather saved parameters from last run
\     Get parameters saved by params_put and set them.

      [ no "FILE" book, list: 0 seed0 ; "NUMS" book ]

      usrpath ".params.bin" catpath "Fname" book \ name of file
      Fname file? not IF return THEN

      FILE filetrue IF FILE close THEN

      Fname old binary "FILE" open
      FILE "NUMS" get "NUMS" book
      FILE close

      NUMS 1st pry (delta) GMTdelta \ correction used by word time
      NUMS 2nd pry (last random seed) seedset
   end

   inline: params_put ( --- ) \ parameters on a file for next time
{     Put parameters on a file at usrpath, to be loaded by word
      params_get when the program is started again.

      The same file is written to usrpath each time an instance
      of the program exits.
}
      [ no "FILE" book, no "ROOT" book ]

      getuid 0= ROOT no = and
      IF return THEN \ do not let root write this file
{
      Since GMTdelta is what's important on this file that is common to
      all instances of the program, do not write the file unless the
      GMTdelta value is different from the initial one.

      A different value implies a new one from an Internet connection,
      and it will be recorded.  A program instance that did not connect
      and started before and closed after the one that did write a new
      GMTdelta will not be allowed to overwrite with its same-old value.
}
      ROOT no =
      IF "params_get" "NUMS" yank 1st pry  \ GMTdelta value at start up
         time integer time1 integer less = \ GMTdelta value now
         IF return THEN
      THEN

      "params_get" "Fname" yank "Fname" book
      Fname fallow not IF return THEN

      FILE filetrue IF FILE close THEN
      Fname deleteif

      Fname new binary "FILE" open
      list:

         time integer time1 integer less \ GMTdelta
         seedget                         \ last random seed

      end (hA)
      (hA) "NUMS" naming FILE put
      FILE close
      getuid 0= IF Fname 256 128 + 32 16 + + 4 2 + + chmod THEN
   end

   inline: uclean ( --- ) \ called by word clean on exit
\     User clean up.
      params_put \ parameters to file that is read on start up
   end
   params_get \ get parameters now during start up

\-----------------------------------------------------------------------
