/* {{{1 GNU General Public License

Program Tops - a stack-based computing environment
Copyright (C) 1999-2005  Dale R. Williamson

Author and copyright holder of spadd_master.c, spadd_cc.c, spadd_cx.c,
spadd_rc.c, spadd_rr.c:  Al Danial <al.danial@gmail.com>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
1}}} */
/* headers {{{1 */
#include <stdio.h>
#include <stdlib.h>  /* random, RAND_MAX */
#include <string.h>  /* strncmp */
#include <math.h>    /* fabs */

#include "main.h"
#include "stk.h"
#include "exe.h"     /* xmain */
#include "tag.h"
#include "sparse.h"

#include "ctrl.h"
#include "inpo.h"
#include "mem.h"


#ifndef MAX
#define  MAX(a,b)              ((a) >  (b)) ? (a)  : (b)
#endif
#ifndef MIN
#define  MIN(a,b)              ((a) <  (b)) ? (a)  : (b)
#endif
#define  INDEX_MAX(ia,a, ib,b) ((a) >  (b)) ? (ia) : (ib)
#define  INDEX_MIN(ia,a, ib,b) ((a) <  (b)) ? (ia) : (ib)
#define  NUM_PER_TERM(a)       ((a) == (1)  ? (2)  : (1))
#define  TRUE      1
#define  FALSE     0
/*                 ((1<<31) - 1) gives overflow warning in sqrt()  */
#define  MAXINT    ((1<<30) - 1)
#ifdef BLAS
#ifdef LAPACK
#ifdef FORT_UDSC
#define DAXPY daxpy_
#define DCOPY dcopy_
#define DSCAL dscal_
#define DDOT  ddot_ 
#else
#define DAXPY daxpy
#define DCOPY dcopy
#define DSCAL dscal
#define DDOT  ddot
#endif
#endif
#endif

/* headers 1}}} */

int  spadd_rr()
/* 
 *   Add two sparse matrices:    [C] = [A] + [B]
 * man entry:  spadd_rr {{{2
 * (hA_sp hB_sp --- hC_sp) Add two real sparse matrices, put sum on stack.
 * category: math::matrix::sparse 
 * related: dense, sparse, spadd, sprand, spy, spconvert, spdiag
 * 
 * 2}}}
 */ 
{
int DEBUG = 0;
    const int A = 0, 
              B = 1,
              C = 2;
    int     i, j, c, m_w_first, m_w_last, str_len, terms_remain,
            n_str_this_col, n_nonz_this_col, longest_str_this_col, 
            Z = -1, Z_end_row, extra, offset, NPT_C, 
            n_str[3], s_ptr[3], start_row[3], end_row[3], N_ptr[3],
            n_str_C, n_nonz_C, C_start_row, C_end_row, C_s_ptr, C_n_ptr,
            upper_tri = 1, 
            lower_tri = 1,
            cmplx     = 0;
    SparseMatrix m[3];
    char   *name = "_spadd_rr";

/*

            [A] is real           [B] is real         [C] is real




*/
if (DEBUG) gprintf("top of %s\n", name);

    if (!is_sparse(tos)) {
        stkerr(" spadd:  matrix 2 ",SPARSENOT); 
        return 0;
    }
    m[A] = sparse_overlay(tos-1);      /* index 1 -> matrix [A] */

    if (!is_sparse(tos-1)) {
        stkerr(" spadd:  matrix 1 ",SPARSENOT); 
        return 0;
    }
    m[B] = sparse_overlay(tos);        /* index 0 -> matrix [B] */


    cmplx = 0;




    NPT_C = NUM_PER_TERM( cmplx );

if (DEBUG) {
gprintf("A %2d x %2d cmplx=%d\n", m[A].H[ROWS], m[A].H[COLS],m[A].H[COMPLX]);
gprintf("B %2d x %2d cmplx=%d\n", m[B].H[ROWS], m[B].H[COLS],m[B].H[COMPLX]);
}
    if (m[A].H[ROWS] != m[B].H[ROWS]) {
        stkerr(" spadd: ",ROWSNOT); 
        return 0;
    }
    if (m[A].H[COLS] != m[B].H[COLS]) {
        stkerr(" spadd: ",COLSNOT); 
        return 0;
    }

    n_str_C  = 0;
    n_nonz_C = 0;

    /*   Pass 1:  determine the number of strings and nonzeros in [C] {{{2 */
    for (c = 0; c < m[A].H[COLS]; c++) {
if (DEBUG) {
gprintf("\ncolumn %d\n", c);
}
        n_str[A] = m[A].S_start[c+1] - m[A].S_start[c];
        n_str[B] = m[B].S_start[c+1] - m[B].S_start[c];
        s_ptr[A] = m[A].S_start[c];
        s_ptr[B] = m[B].S_start[c];
if (DEBUG) {
gprintf("A1:  #str = %2d   str_ptr=%2d\n", n_str[A], s_ptr[A]);
gprintf("B1:  #str = %2d   str_ptr=%2d\n", n_str[B], s_ptr[B]);
}
        C_start_row          = -2;
        C_end_row            = -2;
        n_str_this_col       =  0;
        longest_str_this_col =  0;
        /* while both matrices still have strings in column c {{{3 */
        while (n_str[A] && n_str[B]) {
            start_row[A] = m[A].S[s_ptr[A]].start_row;
            end_row[  A] = start_row[A] + m[A].S[s_ptr[A]].len - 1;
            start_row[B] = m[B].S[s_ptr[B]].start_row;
            end_row[  B] = start_row[B] + m[B].S[s_ptr[B]].len - 1;

            /* m_w_first and m_w_last are the matrix indices, either
             * 0 or 1, of the input matrix whose strings start first and
             * end last.
             */
            m_w_first  = INDEX_MIN(A, start_row[A], B, start_row[B]);
            m_w_last   = INDEX_MAX(A, end_row[  A], B, end_row[  B]);
if (DEBUG) {
gprintf("\n");
gprintf("A1:  start,end row=%2d,%2d\n", start_row[A], end_row[A]);
gprintf("B1:  start,end row=%2d,%2d\n", start_row[B], end_row[B]);
}
            if (start_row[A] == start_row[B]) {
if (DEBUG) {
gprintf("a:  A and B start at the same row, row %d\n", start_row[A]);
}
                /* current strings in A and B start at the same row */
                --n_str[A];
                ++s_ptr[A];
                --n_str[B];
                ++s_ptr[B];
                /* in this case the matrix with the longer string is needed */
                m_w_first = m_w_last; 
                C_end_row = end_row[m_w_last];
                if (C_end_row > c) upper_tri = 0;
            } else {
if (DEBUG) {
gprintf("b:  A starts row %d  B starts row %d\n", start_row[A], start_row[B]);
}
                --n_str[m_w_first];
                ++s_ptr[m_w_first];
            }
if (DEBUG) {
gprintf("c:  start_row[%d]=%d    C_end_row=%d\n", 
m_w_first, start_row[m_w_first], C_end_row);
}
            if ((start_row[m_w_first] > (C_end_row + 1)) ||
                (start_row[A] == start_row[B])) {
                /* start a new string in C */
                ++n_str_C;
                ++n_str_this_col;
                C_start_row = start_row[m_w_first];
                C_end_row   = end_row[  m_w_first];
                n_nonz_C   += C_end_row - C_start_row + 1;
                if (C_start_row < c) lower_tri = 0;
                if (C_end_row   > c) upper_tri = 0;
            } else {
if (DEBUG) {
gprintf("d:  end_row[%d]=%d    C_end_row=%d\n", 
m_w_first, end_row[m_w_first], C_end_row);
}
                /* string in A or B continues a string in C */
                if (end_row[m_w_first] > C_end_row) {
                    n_nonz_C   += end_row[  m_w_first] - C_end_row ;
                    C_end_row   = end_row[  m_w_first];
                    if (C_end_row > c) upper_tri = 0;
                }
            }
if (DEBUG) {
gprintf("C1:  start,end row=%2d,%2d   nStr=%2d   nNnz=%2d\n", 
C_start_row, C_end_row, n_str_C, n_nonz_C);
}
        }   /* 3}}} */
        /* copy strings in remaining column directly into [C] {{{3 */
        /* Z is the placeholder for the matrix that still has data */
        terms_remain = MAX(n_str[A], n_str[B]);
        if      (n_str[A])
            Z = A;
        else if (n_str[B])
            Z = B;
        if (terms_remain) {
if (DEBUG) {
gprintf("spadd only one matrix ([%c]) has data left; %d strings remain\n", 
'A' + Z, n_str[Z]);
}
            for (i = 0; i < n_str[Z]; i++) {
if (DEBUG) {
gprintf("spadd i=%d m[Z].S[i + s_ptr[Z]].start_row=%d  C_end_row=%d\n",
i, m[Z].S[i + s_ptr[Z]].start_row, C_end_row);
}
                if (m[Z].S[i + s_ptr[Z]].start_row > C_end_row + 1) {
                    /* new string; doesn't overlap last one in [C] */
                    ++n_str_C;
                    ++n_str_this_col;
                    n_nonz_C += m[Z].S[i + s_ptr[Z]].len;
                    if (m[Z].S[i + s_ptr[Z]].start_row < c) lower_tri = 0;
                } else {
                    /* a continuation of the last one in [C] */
                    j = m[Z].S[i+s_ptr[Z]].start_row + 
                        m[Z].S[i+s_ptr[Z]].len - 1;
                    /* j = [Z] string's end row */
                    extra = j - C_end_row;
if (DEBUG) {
gprintf("spadd extra=%d,  j (end_row)=%d\n", extra, j);
}
                    if (j > c) lower_tri = 0;
                    if (extra > 0) {
                        /* don't bother if this string is completely */
                        /* embedded within [C]'s last string         */
                        n_nonz_C += extra;
                    }
                }
            }
        } /* 3}}} */
    }
if (DEBUG) {
gprintf("spadd end of symbolic phase: nStr=%2d nNnz=%2d\n", n_str_C, n_nonz_C);
}
    /* 2}}} */
    /*   allocate memory for the sum, put it on the stack */
    if (!sparse_stk(m[A].H[ROWS], /* in  */
                    m[A].H[COLS], /* in  */
                    n_str_C     , /* in  number of strings       */
                    n_nonz_C    , /* in  number of nonzero terms */
                    cmplx       , /* in  0=real  1=complex       */
                    0           , /* in  not internally indexed  */
                    name        , /* in  */
                   &m[C])) {      /* out */
        return 0;
    }
    /* Pass 2:  add the numeric values {{{2 */
    for (i = 0; i < NPT_C*m[C].H[n_NONZ]; i++) 
        m[C].N[i] = 0.0;

    m[C].S_start[0] = 0;
    m[C].N_start[0] = 0;
    C_s_ptr         = 0;
    C_n_ptr         = 0;

    for (c = 0; c < m[A].H[COLS]; c++) {
if (DEBUG) {
gprintf("\ncolumn %d\n", c);
}
        n_str[A] = m[A].S_start[c+1] - m[A].S_start[c];
        n_str[B] = m[B].S_start[c+1] - m[B].S_start[c];
        s_ptr[A] = m[A].S_start[c];
        s_ptr[B] = m[B].S_start[c];
if (DEBUG) {
gprintf("A2:  #str = %2d   str_ptr=%2d\n", n_str[A], s_ptr[A]);
gprintf("B2:  #str = %2d   str_ptr=%2d\n", n_str[B], s_ptr[B]);
}
        C_start_row          = -2;
        C_end_row            = -2;
        n_str_this_col       =  0;
        n_nonz_this_col      =  0; 
        /* while both matrices still have strings in column c {{{3 */
        while (n_str[A] && n_str[B]) {
            start_row[A] = m[A].S[s_ptr[A]].start_row;
            end_row[  A] = start_row[A] + m[A].S[s_ptr[A]].len - 1;
            N_ptr[    A] = m[A].S[s_ptr[A]].N_idx;
            start_row[B] = m[B].S[s_ptr[B]].start_row;
            end_row[  B] = start_row[B] + m[B].S[s_ptr[B]].len - 1;
            N_ptr[    B] = m[B].S[s_ptr[B]].N_idx;

            /* m_w_first and m_w_last are the matrix indices, either
             * 0 or 1, of the input matrix whose strings start first and
             * end last respectively.
             */
            m_w_first  = INDEX_MIN(A, start_row[A], B, start_row[B]);
            m_w_last   = INDEX_MAX(A, end_row[  A], B, end_row[  B]);
if (DEBUG) {
gprintf("\n");
gprintf("A2:  start,end row=%2d,%2d\n", start_row[A], end_row[A]);
gprintf("B2:  start,end row=%2d,%2d\n", start_row[B], end_row[B]);
gprintf("C2:  start,end row=%2d,%2d\n", C_start_row, C_end_row);
}
            if (start_row[A] == start_row[B]) {
                /* current strings in A and B start at the same row */
                str_len = MAX(m[A].S[s_ptr[A]].len, m[B].S[s_ptr[B]].len);

                m[C].S[C_s_ptr].start_row = start_row[A];
                m[C].S[C_s_ptr].len       = str_len;
                m[C].S[C_s_ptr].N_idx     = C_n_ptr;
                n_nonz_this_col          += str_len;
if (DEBUG) {
gprintf("C2a: m[C].S[%d].len=%d m[C].S[%d].N_idx=%d\n", 
C_s_ptr, m[C].S[C_s_ptr].len, C_s_ptr, m[C].S[C_s_ptr].N_idx);
}

                for (i = 0; i < m[A].S[s_ptr[A]].len; i++) { 

                    m[C].N[C_n_ptr + i]     += m[A].N[N_ptr[A] + i];




                }
                for (i = 0; i < m[B].S[s_ptr[B]].len; i++)  {

                    m[C].N[C_n_ptr + i]     += m[B].N[N_ptr[B] + i];




                }

                C_start_row      = m[C].S[C_s_ptr].start_row;
                C_end_row        = m[C].S[C_s_ptr].start_row + str_len - 1;
                ++n_str_this_col;

                ++C_s_ptr;
                --n_str[A]; --n_str[B];
                ++s_ptr[A]; ++s_ptr[B];
                C_n_ptr += NPT_C*str_len;
            } else if (start_row[m_w_first] <= (C_end_row + 1)) {
                /* overlap existing string in [C] */
                --C_s_ptr;
                offset = start_row[m_w_first] - m[C].S[C_s_ptr].start_row;
                extra  = end_row[  m_w_first] - 
                        (m[C].S[C_s_ptr].start_row + m[C].S[C_s_ptr].len - 1); 

if (DEBUG) {
gprintf("C5z: start_row[%d] = %d \n", m_w_first, start_row[m_w_first]);
gprintf("C5z: end_row[  %d] = %d \n", m_w_first, end_row[m_w_first]);
gprintf("C5z: m[C].S[%d].start_row=%d\n", C_s_ptr, m[C].S[C_s_ptr].start_row);
gprintf("C5z: m[C].S[%d].len      =%d\n", C_s_ptr, m[C].S[C_s_ptr].len      );
gprintf("C5a: overlap existing string in [C] offset=%d extra=%d\n",
offset, extra);
}
/*
if (DEBUG) {
gprintf("C5b: m[C].N[%d] = % 12.6le + % 12.6le = % 12.6le\n", 
       m[C].S[C_s_ptr].N_idx + offset + i,
m[C].N[m[C].S[C_s_ptr].N_idx + offset + i],
                                             m[m_w_first].N[N_ptr[m_w_first]+i],
m[C].N[m[C].S[C_s_ptr].N_idx + offset + i] + m[m_w_first].N[N_ptr[m_w_first]+i]
);
}
*/
                if (m_w_first == A) {
                    for (i = 0; i < m[A].S[s_ptr[A]].len; i++) {

                        m[C].N[m[C].S[C_s_ptr].N_idx + offset + i    ] += 
                            m[A].N[N_ptr[A] + i    ];




                    }
                } else {
                    for (i = 0; i < m[B].S[s_ptr[B]].len; i++) {

                        m[C].N[m[C].S[C_s_ptr].N_idx + offset + i    ] += 
                            m[B].N[N_ptr[B] + i    ];




                    }
                }
                if (extra > 0) {
                    C_n_ptr             += NPT_C*extra;
                    m[C].S[C_s_ptr].len += extra;
                    C_end_row           += extra;
                    n_nonz_this_col     += extra;
                }
if (DEBUG) {
gprintf("C5c: updated m[C].S[%d].len = %d\n", C_s_ptr, m[C].S[C_s_ptr].len);
}

                --n_str[m_w_first];
                ++s_ptr[m_w_first];
                ++C_s_ptr;
            } else { /* start a new string in C */

                C_start_row = start_row[m_w_first];
                C_end_row   = end_row[  m_w_first];
                str_len     = C_end_row - C_start_row + 1;

                m[C].S[C_s_ptr].start_row = C_start_row;
                m[C].S[C_s_ptr].len       = C_end_row - C_start_row + 1;
                n_nonz_this_col          += C_end_row - C_start_row + 1;

/*
if (DEBUG) {
gprintf("C2c: m[C].N[%d] = % 12.6le + % 12.6le = % 12.6le\n", 
C_n_ptr + i,
m[C].N[C_n_ptr + i],
m[m_w_first].N[N_ptr[m_w_first] +i],
m[C].N[C_n_ptr + i] + m[m_w_first].N[N_ptr[m_w_first] +i]);
}
*/
                if (m_w_first == A) {
                    for (i = 0; i < m[C].S[C_s_ptr].len; i++) {

                        m[C].N[C_n_ptr + i]     += m[A].N[N_ptr[A] + i];




                    }
                } else {
                    for (i = 0; i < m[C].S[C_s_ptr].len; i++) {

                        m[C].N[C_n_ptr + i    ] += m[B].N[N_ptr[B] + i    ];




                    }
                }
                m[C].S[C_s_ptr].N_idx = C_n_ptr;
if (DEBUG) {
gprintf("C2d: m[C].S[%d].N_idx = %d   m[C].S[].len=%d\n", 
C_s_ptr, m[C].S[C_s_ptr].N_idx,
m[C].S[C_s_ptr].len);
}
                C_n_ptr += NPT_C*str_len;
                ++n_str_this_col;
                ++C_s_ptr;
                --n_str[m_w_first];
                ++s_ptr[m_w_first];

            }
if (DEBUG) {
gprintf("C2 end while:  start,end row=%2d,%2d  nNnz=%2d  n_str[A]=%d n_str[B]=%d\n", 
C_start_row, C_end_row, n_nonz_C, n_str[A], n_str[B]);
}
        } /* 3}}} */
        /* copy strings in remaining column directly into [C] {{{3 */
        /* Z is the matrix that still has strings left             */
        N_ptr[A] = m[A].S[s_ptr[A]].N_idx;
        N_ptr[B] = m[B].S[s_ptr[B]].N_idx;
        terms_remain = MAX(n_str[A], n_str[B]);
        if      (n_str[A])
            Z = A;
        else if (n_str[B])
            Z = B;
        if (terms_remain) {
if (DEBUG) {
gprintf("C3i only one matrix ([%c]) has data left; %d strings remain\n", 
'A' + Z, n_str[Z]);
}
            for (i = 0; i < n_str[Z]; i++) {
if (DEBUG) {
gprintf("C3i i=%d C_end_row=%d\n", i, C_end_row);
gprintf("C3i m[%c].S[%d + %d].start_row=%d\n",
'A' + Z, i, s_ptr[Z], m[Z].S[i + s_ptr[Z]].start_row, C_end_row);
gprintf("C3i m[%c].S[%d + %d].len      =%d\n",
'A' + Z, i, s_ptr[Z], m[Z].S[i + s_ptr[Z]].len);
gprintf("C3i m[%c].S[%d + %d].N_idx    =%d\n",
'A' + Z, i, s_ptr[Z], m[Z].S[i + s_ptr[Z]].N_idx);
}
                Z_end_row = m[Z].S[i + s_ptr[Z]].start_row +
                            m[Z].S[i + s_ptr[Z]].len - 1;
                if (m[Z].S[i + s_ptr[Z]].start_row > C_end_row + 1) {
                    /* new string; doesn't overlap last one in [C] */
                    ++n_str_this_col;
                    n_nonz_C += m[Z].S[i + s_ptr[Z]].len;
                    m[C].S[C_s_ptr].N_idx = C_n_ptr;
if (DEBUG) {
gprintf("C3a: C_s_ptr=%d  s_ptr[%c]=%d  i=%d\n", C_s_ptr, 'A'+Z, s_ptr[Z], i);
gprintf("C3a: m[%c].S[%d].start_row = %d\n", 
'A'+Z, i + s_ptr[Z], m[Z].S[i + s_ptr[Z]].start_row);
gprintf("C3a: m[%c].S[%d].len       = %d\n", 
'A'+Z, i + s_ptr[Z], m[Z].S[i + s_ptr[Z]].len      );
gprintf("C3a: m[%c].S[%d].N_idx     = %d\n", 
'A'+Z, i + s_ptr[Z], m[Z].S[i + s_ptr[Z]].N_idx    );
}
/*
if (DEBUG) {
gprintf("C3b: m[%c].N[%d+%d]      = % 12.6le\n",
'A'+Z, N_ptr[Z], j, m[Z].N[m[Z].S[i + s_ptr[Z]].N_idx + j]);
gprintf("C3b: m[C].N[%d+%d] = % 12.6le + % 12.6le = % 12.6le\n",
        m[C].S[C_s_ptr].N_idx,  j,
m[C].N[ m[C].S[C_s_ptr].N_idx + j],
                                     m[Z].N[m[Z].S[i + s_ptr[Z]].N_idx + j],
m[C].N[ m[C].S[C_s_ptr].N_idx + j] + m[Z].N[m[Z].S[i + s_ptr[Z]].N_idx + j]
);
}
*/
                    if (Z == A) {
                        for (j = 0; j < m[A].S[i + s_ptr[A]].len; j++) {

                            m[C].N[ m[C].S[C_s_ptr].N_idx + j]     += 
                                m[A].N[m[A].S[i+s_ptr[A]].N_idx + j];




                        }
                    } else {
                        for (j = 0; j < m[B].S[i + s_ptr[B]].len; j++) {

                            m[C].N[ m[C].S[C_s_ptr].N_idx + j]     += 
                                m[B].N[m[B].S[i+s_ptr[B]].N_idx + j];




                        }
                    }
                    m[C].S[C_s_ptr].start_row = m[Z].S[i + s_ptr[Z]].start_row;
                    m[C].S[C_s_ptr].len       = m[Z].S[i + s_ptr[Z]].len;
                    m[C].S[C_s_ptr].N_idx     = C_n_ptr;
if (DEBUG) {
gprintf("C3y: m[C].S[%d].len=%d m[C].S[%d].N_idx=%d\n", 
C_s_ptr, m[C].S[C_s_ptr].len, C_s_ptr, m[C].S[C_s_ptr].N_idx);
}
                    N_ptr[Z]        +=       m[Z].S[i + s_ptr[Z]].len;
                    C_n_ptr         += NPT_C*m[Z].S[i + s_ptr[Z]].len;
                    n_nonz_this_col +=       m[Z].S[i + s_ptr[Z]].len;
                    ++C_s_ptr;
                } else {
                    --C_s_ptr;  /* does overlap, rewind C string pointer */
                    /* In this example, [C] already contains [A] and  */
                    /* so [Z] == [B] since [A] has been depleted      */
                    /*   [A]  = [ 1 2 3 0 0 0 0 ]'     ( = [C] )      */
                    /*   [B]  = [ 0 0 3 4 5 6 0 ]'     ( = [Z] )      */
                    /* then                                           */
                    /* offset = 2 because [Z]'s start row is 2        */
                    /*            positions after [C]'s start row     */
                    /* extra  = 3 because [Z]'s end row is 3          */
                    /*            positions after [C]'s end row       */
                    /*            If extra is < 0 then [C] completely */
                    /*            contains the string in [Z]          */
                  
                    offset = m[Z].S[i + s_ptr[Z]].start_row - C_start_row;
                    extra  = Z_end_row - C_end_row;
if (DEBUG) {
gprintf("C3z offset=%d  extra=%d\n", offset, extra);
}
/*
if (DEBUG) {
gprintf(" m[C].N[%d] = % 12.6le + % 12.6le = % 12.6le\n", 
m[C].S[C_s_ptr].N_idx + offset + j, 
m[C].N[m[C].S[C_s_ptr].N_idx + offset + j],
m[Z].N[m[Z].S[i + s_ptr[Z]].N_idx + j],
m[C].N[m[C].S[C_s_ptr].N_idx + offset + j] + 
m[Z].N[m[Z].S[i + s_ptr[Z]].N_idx + j]
);
}
*/
                    if (Z == A) {
                        for (j = 0; j < m[A].S[i+s_ptr[A]].len; j++) {

                            m[C].N[ m[C].S[C_s_ptr].N_idx + offset + j] += 
                                m[A].N[m[A].S[i + s_ptr[A]].N_idx + j];




                        }
                    } else {
                        for (j = 0; j < m[B].S[i+s_ptr[B]].len; j++) {

                            m[C].N[ m[C].S[C_s_ptr].N_idx + offset + j] += 
                                m[B].N[m[B].S[i + s_ptr[B]].N_idx + j];




                        }
                    }
if (DEBUG) {
gprintf("C_s_ptr = %d\n", C_s_ptr);
}
                    if (extra > 0) {
                        /* don't bother if this string is completely */
                        /* embedded within [C]'s last string         */
                        n_nonz_C            +=       extra;
                        n_nonz_this_col     +=       extra;
                        C_n_ptr             += NPT_C*extra;
                        m[C].S[C_s_ptr].len +=       extra;
                    }
                    ++C_s_ptr;
                }
            }
            ++s_ptr[Z];
        } /* 3}}} */
if (DEBUG) {
for (i = 0; i < n_str_this_col; i++) {
gprintf("column %d C string %d m[C].S[%d].start_row=%d m[C].S[].len=%d m[C].S[].N_idx=%d\n", 
                         c, i,
                         m[C].S_start[c] + i              , 
                 m[C].S[ m[C].S_start[c] + i ].start_row  ,
                 m[C].S[ m[C].S_start[c] + i ].len        ,
                 m[C].S[ m[C].S_start[c] + i ].N_idx );
for (j = 0; j < m[C].S[ m[C].S_start[c] + i ].len; j++) {
gprintf("C row %2d = %12.4le\n", 
         m[C].S[ m[C].S_start[c] + i ].start_row     + j  , 
         m[C].N[ m[C].S[ m[C].S_start[c] + i ].N_idx + j]
         );
}
}
}
        m[C].S_start[c+1] = m[C].S_start[c] + n_str_this_col; 
        m[C].N_start[c+1] = m[C].N_start[c] + NPT_C*n_nonz_this_col; 
    }
    /* 2}}} */

    if (lower_tri) set_low_tri(tos);
    if (upper_tri) set_up_tri( tos);

    lop(); /* drop B from the stack */
    lop(); /* drop A from the stack */
    return 1;
}
