/* {{{1 GNU General Public License

Program Tops - a stack-based computing environment
Copyright (C) 1999-2010  Dale R. Williamson

Author: Dale R. Williamson <dale.williamson@prodigy.net>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
1}}} */

/* term.h  September 1999

Copyright (c) 1999  D. R. Williamson

These functions control the event loop when running interactively.  
They handle key inputs, asynchronous tasks in the multitasker, and 
X11 graphics events in various displayed windows.  

This file also contains variables and defaults shared between term.c
and xterm.c.  File xterm.h defines other functions for X11 graphics, 
the primary focus of file xterm.c.

Some elements adapted from:
Gnuplot, gplt_x11.c, distributed with Redhat 5.2 Linux
Copyright 1986 - 1993, 1998   Thomas Williams, Colin Kelley

----------------------------------------------------------------------*/

#include <errno.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include <sys/ioctl.h>
#include <sys/time.h>
#ifndef _SYS_SELECT_H
   #include <sys/select.h>
#endif
#include <sys/types.h>
#include <fcntl.h>

#define _NO_PROTO
#include <unistd.h>

#ifdef NET
   #ifndef NET_H
      #include "net.h"
   #endif
   #ifdef OPENSSL
      #include "ssl.h"
   #endif
#endif

/*--------------------------------------------------------------------*/

/* Messages for terminal errors: */
#define SYSTASKNOT "cannot modify system task"
#define TASKDUPE "task already defined"
#define TASKNOT "task not found"
#define TASKSNOT " No tasks defined"
#define TERMNOT "terminal not initialized"

/* Descriptors for select() running in terminal(): */
int In;   /* keyboard input descriptor, stdin */
int Out;  /* stdout descriptor */
int Cn;   /* X11 window descriptor */

int REMOTE_SOCKET; /* socket in remoteprompter() */
char *REMOTE_PROMPT; /* prompt to show when running remoteprompter() */

/* Multitasker struct: */
struct ticker { /* multitasker */
   catitem *cat; /* catalog addr of word to run */
   int typ; /* 0 if continuous, 1 if alarm (one-shot) */
   int tic; /* tics remaining until time-out */
   double tout; /* time-out time in future (machineGMT + DELTA_T (sec),
                   used by alarms) */
   double fps; /* frames per second: frequency, Hz */
   struct ticker *nex; /* next in linked list */
   struct ticker *pre; /* previous in linked list */
};
int BUSY; 

#ifdef NET
   int block(int sockfd, double sec);
   int block1(); /* BLOCK (nSocket --- ) */
   int blockhold(); /* HOLD (f --- ) */
   int clientclose(int sockfd, int errflag);

#ifdef OPENSSL
   int clientmake(int confd, int port, SSL *ssl, int type, double ptr,\
      char *IPaddr, char *LOGINid);
#else
   int clientmake(int confd, int port, int type, double ptr,\
      char *IPaddr, char *LOGINid);
#endif

   int conn_alarm(); /* conn_alarm, ( --- ) */
   int daemon_init();
#endif
int disassemble(); /* disassemble (hFile key --- hT) */
#ifndef X11
   int *Dpy;
#endif
int errmon();
int errmon1(int reset);
int errmonset();
#ifdef NET
   int FOREVER; /* server flag */
   int FOREVER_set(); /* FOREVER (f --- ) */
#endif
int frate(); /* frate (n --- ) */
int ftic(); /* ftic ( --- n) */
int LOCK1(); /*  LOCK (s --- ) */
int LOCKED1(); /*  LOCKED ( --- f) */
#ifdef NET
   int new_client_timeout(); /* new_client_timeout (s --- ) */
   int NEW_CLIENT_TIMEOUT(); /* NEW_CLIENT_TIMEOUT ( --- s) */
   int nextport();  /* nextport (nPORT --- nPORT1) */
#endif
void noop1(int signal);
#ifdef NET
   int NTRACE;
   int ntrace(); /* ntrace ( --- ) */
   int ntraceoff(); /* nontrace ( --- ) */
   int ntraceflag(); /* NTRACE ( --- f) */
#endif
int ping(); /* ping (n --- ) */
int prompter(); /* prompter (ptrRun qPrompt --- f) */
#ifdef NET
   int remoteprompter(); /* remoteprompter (nSocket qPrompt --- ) */
   int SECURE;
   int server(); /* SERVER (IPaddr nPort --- ) */
   int server1(); /* DSERVER (IPaddr nPort --- ) */
   #ifdef OPENSSL
      int server2(); /* SERVER_SSL (qIPaddr nPort --- ) */
      int server3(); /* DSERVER_SSL (qIPaddr nPort --- ) */
   #endif
   int serverclose(); /* serverclose ( --- ) */
   int setready(); /* READY (f --- ) */
   int setselect(); /* SELECT (nSocket f --- ) */
#endif
int socket_open(); /* socket_open (nSocket --- f) */
int taskadd(struct ticker *new, struct ticker **table, \
            struct ticker **end);
int taskalarm(); /* ALARM (n qS --- ) */
int taskdef(); /* TASK (w qS --- ) */
int taskdisp(); /* tasks ( --- ) */
void tasker(int signal);
struct ticker *taskfind(char *nam, struct ticker *table);
void tasklist(struct ticker *tasks);
int taskomit(); /* OMIT (qS --- ) */
int taskomit1(); /* -ALARM (qS --- ) */
int taskrate(); /* RATE (w qS --- ) */
int taskrem(char *nam, struct ticker **table,struct ticker **end);
int tasks_omit(); /* tasks_omit ( --- ) */
int tasksleep(); /* SLEEP (qS --- ) */
int taskwake(); /* WAKE (qS --- ) */
int tdecode(); /* decode (hT1 --- hT) */
int tencode(); /* encode (hT --- hT1) */
void terminal();
int terminit();
int test_socket_open(int sock);
void ticadvance(struct ticker *p);
int tics(double ftask);
int timtic1(); /* timtic ( --- n) */
int tkey(); /* (hT --- hT) */
int tload(); /* bload (hT key --- hT1) */
int tload1(); /* brun (hT key --- ) */
int tmake(); /* tmake (hT --- hT1) */
#ifdef NET
   int unblock(); /* unblock, ( --- ) */
#endif
int UNLOCK(); /* UNLOCK ( --- ) */
int winfocus(); /* winfocus ( --- nFocus) */
double WINKEY; /* window number when have interactive prompt */
int winkey(); /* winkey ( --- nWin) */
int WTRACE;
int wtrace(); /* wtrace ( --- ) */
int wtraceoff(); /* nowtrace ( --- ) */
int _X11(); /* X11 ( --- f) */

#ifndef MAXHOSTNAMELEN
   #define MAXHOSTNAMELEN 64
#endif

#if defined(HAVE_SYS_SYSTEMINFO_H) && defined(HAVE_SYSINFO)
  #include <sys/systeminfo.h>
  #define SYSINFO_METHOD "sysinfo"
  #define GP_SYSTEMINFO(host) sysinfo(SI_HOSTNAME,(host),MAXHOSTNAMELEN)
#else
  #define SYSINFO_METHOD "gethostname"
  #define GP_SYSTEMINFO(host) gethostname((host),MAXHOSTNAMELEN)
#endif

/* End of terminal functions */

/*--------------------------------------------------------------------*/

/* Begin X11 terminal functions.  These have to do with making windows
   and tracking window events, and are separate from the X11 graphics 
   functions of xterm.c and xterm.h. */

#ifdef X11

   #include <X11/Xos.h>
   #include <X11/Xlib.h>
   #include <X11/Xresource.h>
   #include <X11/Xutil.h>
   #include <X11/Xatom.h>
   #include <X11/keysym.h>
   #include <X11/cursorfont.h>

   #ifdef X11EXT
      #include <X11/extensions/XTest.h>
   #endif
      
   #ifndef WINNOT
   /* Defining X11 graphics functions */
      #include "xterm.h"
   #endif

/*--------------------------------------------------------------------*/

/* Uppercase enum items correspond to similarly ordered elements in
   structures of xterm.v: */
enum _ecb {BP,BR,CE,CM,EE,KP,KR,ME,VE,ecbsize};
enum _gcb {GCC,GAM,GAV,gcbsize};
enum _gav {FUNC,PLMASK,FORE,BACK,LINEWID,LINESTY,CAPSTY,JOINSTY,
           FILSTY,FILRUL,ARCMOD,PIXTILE,PIXSTIP,TSX,TSY,FONT,SUBMOD,
           EXPOSE,CLIPX,CLIPY,CLIPMASK,DASHOFF,DASHES,GAVsize};
enum _pcb {PIX,PW,PH,XHOT,YHOUT,pcbsize};
enum _wav {BACKPMAP,BACKPIX,BORDPMAP,BORDPIX,BGRAV,WGRAV,BACKSTOR,
           BACKGPLANE,BACKGPIX,SAVEU,EVENTM,PROPNOM,OVERRIDE,
           COLORM,CURSOR,WAVsize};
enum _wcb {WIN,USR,W,H,X,Y,FLAGS,WAM,WAV,ECB,TYP,wcbsize};

/*--------------------------------------------------------------------*/

/* dispatcher() events: */

/* ButtonPressedEvent (ButtonPress): */
enum eventBP {BPwin,BPx,BPy,BPrx,BPry,BPst,BPbu,BPsize};

/* ButtonReleasedEvent (ButtonRelease): */
enum eventBR {BRwin,BRx,BRy,BRrx,BRry,BRst,BRbu,BRsize};

/* ConfigureEvent (ConfigureNotify): */
enum eventCE {CEwin,CEx,CEy,CEw,CEh,CEb,CEsize};

/* ClientMessageEvent (ClientMessage): */
enum eventCM {CMwin,CMtyp,CMfmt,CMl0,CMl1,CMl2,CMl3,CMl4,CMsize};

/* ExposeEvent (Expose): */
enum eventEE {EEwin,EEx,EEy,EEw,EEh,EEsize};

/* KeyPressedEvent (KeyPress): */
enum eventKP {KPwin,KPx,KPy,KPrx,KPry,KPst,KPkc,KPsize};

/* KeyReleasedEvent (KeyRelease): */
enum eventKR {KRwin,KRx,KRy,KRrx,KRry,KRst,KRkc,KRsize};

/* MotionEvent (MotionNotify): */
enum eventME {MEwin,MEx,MEy,MErx,MEry,MEst,MEh,MEsize};

/* VisibliityEvent (VisibilityEvent): */
enum eventVE {VEwin,VEst,VEsize};

/* xterminit() */
Display *Dpy;
Window Root;
int Scr;
Visual *Vis;
unsigned int Dep; /* default depth */
Atom WM_PROTOCOLS,WM_DELETE_WINDOW;

/* terminal() */
XEvent Events[LASTEvent];

/* wgeometry() */
unsigned int BorderWidth,gFlags,gH,gW;
int gX,gY;

/*--------------------------------------------------------------------*/

int atomget(); /* Xatom (n --- qS) */
char *dbget(XrmDatabase db, char *resource);
int dbget1(); /* Xresource (qOpt --- qDb) */
int dheight(); /* dheight ( --- h) */
int dheightMM(); /* dheightMM ( --- hMM) */
void dispatcher();
int dprops(); /* dprops ( --- ) */
int dwidth(); /* dwidth ( --- w) */
int dwidthMM(); /* dwidthMM ( --- wMM) */
#ifdef X11EXT
   void _mouseClick(int button);
   void _mouseDoubleClick();
   int mouseClick(); /* mouseClick ( --- ) */
   int mouseClick2(); /* mouseClick2 ( --- ) */
#endif
int wcolor();
int wfont();
int wgeometry();
Window wcreate(char *name, unsigned int flags, int x, int y, 
   unsigned int width, unsigned int length, unsigned long CWmask,
   XSetWindowAttributes *CWattributes);
int wwidth(); 
/* Code for XEventHandler is in xterm.c: */
void XEventHandler(int event); /* (hE --- ) */
int xterminit();

#endif

/*--------------------------------------------------------------------*/

/* end term.h headers */
