\ {{{1 GNU General Public License
{
Program Tops - a stack-based computing environment
Copyright (C) 1999-2010  Dale R. Williamson

Author: Dale R. Williamson <dale.williamson@prodigy.net>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
1}}} 
}

{ File boot.v  June 1999                                         
                                            
   Copyright (c) 1999   D. R. Williamson

\-----------------------------------------------------------------------

   This is the program path hierarchy created when the program is in-
   stalled:

     /home/user/tops/
                     \_ admin/ (no program path)
                     \_ doc/ docpath (documentation .doc)
                     \_ src/ (source files: .c, .h, .o, .p)
                     \_ sys/ syspath (system files: .v, .bin, .scr, ...)
                     \_ test/ (no program path)
                     \_ usr/ usrpath (your files: .v, ...)

   There are three directories that contain files the program might use
   while it runs: doc/, sys/, and usr/.  In the program they are called
   docpath, syspath and usrpath. 

   When looking for files to use, the program searches paths in the fol-
   lowing order: the local directory you are working in, then usrpath, 
   then syspath, then docpath=sys/../doc.

   Note that the definition of docpath relative to syspath (sys/.../doc)
   requires that doc/ and sys/ be in the same directory.  No such re-
   quirement applies to usrpath, and it might be beneficial to have your
   own usr/ directory elsewhere on the machine where you keep modified 
   files taken from the program's usr/ directory in addition to the new
   ones you are working on.

   Usrpath and syspath can be defined as command line arguments when 
   the program is started.  At the command line, syspath is defined by 
   the '-s syspath/' command line argument pair.

   Usrpath does not have to be under the top level hierarchy as shown
   above.  It can be anywhere else on the machine and its path defined 
   using the '-u usrpath/' command line argument pair.

   This file, boot.v, is expected to be at syspath.  If boot.v is moved
   for some reason, one way for the program to always find it is to put
   a one-line file boot.v at syspath that sources the moved one, using
   a line such as: 
      "/my/new/path/boot.v" source

   Here are ways to define program directory paths, in precedential or-
   der:

      syspath (location of directory sys/): 
         1) pair '-s syspath/' given on the command line
         2) environment variable TOPS_SYSPATH
         3) local, ./

      usrpath (location of directory usr/): 
         1) pair '-u usrpath/' given on the command line
         2) environment variable TOPS_USRPATH
         3) a usr/ directory relative to sys/../usr
         4) local, ./

      docpath (location of directory doc/): 
         not controllable--doc/ is in the same directory as sys/ and
         is located relative to it: sys/../doc

   These lines in a user's .kshrc file are an example of a setup to run
   the program:

      export TOPS_SYSPATH=/opt/tops-2.4.1/sys/
      export TOPS_USRPATH=/opt/mytops/usr/
      alias tops='/opt/tops-2.4.1/src/tops'

\  -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -

   Below is a list of some vocabulary (.v) files in sys/ (syspath).  
   Files required for start up are preceded by *.  

   To use a modified version of one of the system .v files while keep-
   ing the original one, a modified copy can be placed at usr/ (usrpath)
   where the program will find it first.  

   Some vocabulary files in sys/ and usr/:
       batch.v - sample file for running in batch
     * boot.v - run by start up script (must be at syspath)
       cal.v - calendar
       clu.v - running on a cluster
       dog.v - watch directories and files; simple messaging
     * file.v - files
       gyroant.v - attitude problem demo
     * hash.v - disordered arrays
     * key.v - keyboard
       konet.v - unsupervised learning networks
       lapack.v - running Atlas/Lapack matrix functions
       mat.v - matrix 
       math.v - math 
       matlab.v - running the Matlab program
       mmath.v - matrix math 
       myclu.v - define my cluster for clu.v
       nas.v - using output from the Nastran program
       nasrun.v - running the Nastran program
     * net.v - networks (required if compiler option -DNET was used)
       netbp.v - back-propagation networks
       perl.v - running Perl
       plot.v - graphics
       pppcon.v - modem connection information used by file web.v
       pppsec.v - secrets: user name and password used by pppcon.v
       recurse.v - recursion demos
       sam.v - samples and examples
       say.v - making the machine talk
       signal.v - data analysis and measurement
       snd.v - working with sound
       sparse.v - words that use native words for sparse matrices
     * sys.v - operating system
       task.v - multitasker queuing system
       tex.v - text
       uboot.v - optional user file sourced by boot.v at start up
       ukey.v - optional user file run at interactive start up
       vmo.v - controlling a voice modem
       web.v - connecting to the Internet with pppd
       work.v - your current work, sourced by word ww
     * xterm.v - terminal graphics (if compiler option -DX11 was used)

   Any vocabulary file is loaded (sourced) by the word source as in

      "math.v" source
      'tex.v' include (include is a synonym for word source)

   and its words immediately become available for use.  

   Single- and double-quotes required to define strings work the same 
   way (word ' is thus a synonym for word "). 

   Some of the common vocabulary file names are defined as words at
   start up (below in this file), so surrounding quotes are not 
   required:

      math.v source
      tex.v include

   This is easy to do by defining a word that puts the desired quote
   on the stack when it runs, as in:

      define: web.v "web.v" end

   For new vocabulary files, the .v extension is a convention, not a 
   requirement.
}
\-----------------------------------------------------------------------

\  Booting.
{
   Continuing start up that began in main.c, function start().  Words
   that belong at the foundation, near the native (C and Fortran) words
   just loaded, are sourced next.

   Then words from file uboot.v, if present, are sourced before return-
   ing to main.c where the file specified on the command line will fi-
   nally be sourced (see function main() in file main.c).
}

\  Not allowing this file to be sourced again:
   "_bin" exists? IF " system is running" dot nl halt THEN

\  " Loading..." . 
   private 1based time push

   CATMSG (f) push no catmsg

   inline: host ( --- qS) _host ; \ name of the machine

   inline: minshell (qS or hT --- ) \ minshell anywhere reverts to this
      [ \ These guys get nullshell in their minshell:
          getlogin "dale" alike \ getlogin "a113566" alike or
          IF "nullshell" ELSE "shell" THEN (qS)
          (qS) ptr "shell" book
      ] shell exe ;

\  The name that invoked the program:
   inline: pname ( --- qS) 
      [ ARGV 1st quote -path "p" book ] p 
   end

   pull (f) catmsg

\  -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -

\  Help argv dialog:
   "-h" argv chars any
   "-help" argv chars any or 
   "--help" argv chars any or 

   IF \ display help message and then halt
      set_stdout \ vector output to STDOUT

      "      " pname + spaced 
      _syspath "manindex.bin" + dup file? 
      IF asciiload 1st quote strchop + (qP)
      ELSE (qS) drop
      THEN
      "      http://savannah.gnu.org/projects/tops"
      pile

   \  When this is modified, get a copy to paste into tops/README by 
   \  running something like tops -h > myfile; nedit myfile:
      {"

        This program provides a stack-based computing environment.  Four
        types of stack items--numbers, matrices, strings, and arrays of
        strings--are manipulated by commands called words.  Words inter-
        act through items on the stack, and can be assembled as building
        blocks into new and more powerful words. 
        
        The stack and stack items, the catalog and catalog items, and 
        simple pattern matching to items in the catalog keep the machine
        running from word to word.  A few stack manipulation words allow
        a user to juggle stack items and feed words in phrases with ex-
        traordinary interactive control of the machine, word by word.  
        Useful new words and phrases committed to text files or scripts
        can later be run in batch mode.

        Manipulation of the stack and the running of words follows post-
        fix notation, and a writer of postfix phrases is responsible for
        staging operations with the correct precedence.  Payoff for the 
        effort of writing for a stack machine is speed comparable to 
        compiled code with simple phrases that run immediately from the 
        interactive prompt or an included file.  Networking, multitask-
        ing, text manipulation and queuing are examples where interac-
        tive development of postfix phrases to control the machine is 
        very convenient.

        When writing numerical equations, rather than a series of steps
        to, say, manage a network connection, staging stack operations 
        for postfix input is cumbersome due to precedence.  Infix nota-
        tion, common to C, Fortran and other programming languages, uses
        algebraic expressions that are more convenient to write.  Paren-
        theses, brackets and braces are used to isolate terms and force
        precedence.  Unlike postfix, infix statements cannot be run sym-
        bol by symbol, and require a parser to turn them into sequential
        operations, like postfix, that can run the machine.

        For applications better suited to infix notation, the program 
        uses an infix parser of C-like statements and matrix bracket
        notation to transform infix phrases like these into their post-
        fix analogs and immediately run them:

          i = sqrt(-1); // cmplx number i

          (Alpha, Beta, VL, VR) = zggev(A, B*(1 + 0*i)); // B into cmplx

       // Sig(t) is updated to H(t) when P(t) equals S1 or S2 
          Sig = looking(H, (P==S1 || P==S2)); // Sig[0] = H[0]

          eta = H \* gam[*, 1:cols(gam)/2]; // all rows, left half cols

       /* Using << ... >> to embed a postfix phrase into infix (in post-
          fix, items in parentheses are comments): */
          STEPS = (<< H (hr) 60 (min/hr) M (min/step) / * >>);

          C = rget(node[3])[*, .C]; /* column .C from rget(node[3]) */

       /* Sort all rows of D based upon real part of column 3 of D: */
          Dsort = D[[sort([Re(D[*, 3]) , 1:rows(D)], yes)][*, 2]];

        Applications can be written that take advantage of the conven-
        ience and matrix symbols of infix notation and the immediacy of
        postfix notation, all in the same file.

        Over 1,500 words exist as concrete examples of tasks in matrix 
        analysis, signal processing, sound, voice, text manipulation,
        multitasking and networking.  Words for new applications can be
        written from existing words, using postfix or infix, and sourced
        from text files; or as new words in C or Fortran compiled into
        the program to work alongside existing native words.

      "} pile -6 indent . nl

      "Usage: " . nl 
      pname sp sp . sp 

      "-h -i -l -p -v [-c sh] [-d /bin] [-u usrpath] [-s syspath] file"
      . nl
      {"

      Arguments:
        -h    Display this message and halt
        -i    After start up, text read will be infix
        -l    Log file, /tmp/Txx.tops.log, not deleted (xx = Unix PID)
        -p    After start up, text read will be postfix (default)
        -v    Display the program version and halt

        -c    Name of the Unix shell program file (default sh)
        -d    Directory of the Unix shell program file (default /bin)
        -u    Define usrpath (default ./), the path to program user 
                source files, such as: uboot.v, ukey.v
        -s    Define syspath, the path to program system source files, 
                such as: boot.v, file.v, hash.v, key.v, sys.v, xterm.v
        file  Input file name (given last)

      Argument Notes:
        Input file name is the last argument on the command line 
        Runs interactively if last argument is not a file name
        Search path: present directory, then usrpath, then syspath
        File boot.v on the search path is required at program start up
        File uboot.v, if found, is run after boot.v for additional
           user-specific actions during program start up
        If -u is not given, environment variable TOPS_USRPATH is sought,
           pre-defined as in: export TOPS_USRPATH=/opt/tops/mytops/usr
        If -s is not given, environment variable TOPS_SYSPATH or a path
           defined at compile time is used
      "} -6 indent . nl
      nl halt
   THEN

\  -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -

   inline: _bin (n --- qName) \ various types of system information
      [
\     As this word is created, these lines within brackets [ ... ]
\     perform start up functions and set paths for the host machine.  

   "Tops 3.2.0" \ since Jan 09:
{  Note: Update tops/AUTHORS when this region is changed.
         Mar 10: graphics - key and mouse event handlers
         Jan 10: sound - resample and scale sound files
         Jul 09: web - click the mouse in a web page
         Jun 09: network queuing - remote nodes queue central actions
         Jan 09: voice queuing - queue voices that try to talk at once

   "Tops 3.1.0" \ Jan 06 through Jan 09:
         Oct 08: web - continuous data collection
         Jun 08: graphics - zoom in and out
         Apr 08: sound - voices, Morse code
         Feb 08: multitasker - queuing system
         Dec 07: writing and hyphenation - Oxford dictionary words
         Jun 06: math - solution of complex matrix equations
         Jan 06: networking - Secure Sockets Layer (SSL)

   "Tops 3.0.1" \ Apr 05 through Dec 05:
      D. Williamson
         Nov 05: server - interact with clients not this program
         May 05: parser - turn infix text into postfix
         Apr 05: catalog - new memory model: DATA__ and CODE__

   "Tops 2.4.3" \ Jan 03 through Mar 05:
      A. Danial
         Jan 05: metis - partition and renumber graphs
         Mar 04: sparse - eigensolution
         Mar 04: umfpack - solve unsymmetric sparse linear systems
         Jan 04: tags - stkitem element for data type encoding
         Nov 03: sql - SQL database operations
         Oct 03: sparse - solve
         May 03: sparse - multiply
         Mar 03: loadtx - dynamic loading of shared libraries

      D. Williamson
         Mar 05: server - service HTTP requests
         Aug 04: daemon - running in background as server
         Mar 04: program - 64-bit ptrs, running on 64-bit machines
         Feb 04: stack - complex numbers
         Sep 03: http - fetch data from HTTP servers
         Jul 03: clusters - beowulf clusters, networked machines
         Jun 03: TCP/IP - socket connections

      Beginning:
         "Tops 2.4.2" \ Mar 02 through Dec 02:
                        sparse, complex, loadop4, saveop4
                        fft, messages, watchdogs, xdbfetch
         "Tops 2.4.1" \ Jan 02: open source for CVS; frozen 3-24-02
         "Tops 2.4" \ Sep 01: merge with A. Danial code; begin using
                    \    A. Danial make process; compile switch for
                    \    making non-X11 version;
         "Tops 2.3" \ Aug 01: hash, memptr, sig process, map text files

         "Tops 2.2" \ Apr 01: support for ESSL, Matlab, and Nastran
         "Tops 2.1" \ Jun 00: first version for open source
         "Tops 2.0" \ May 00: wexe() embed addr to resolve references
         "Tops 1.9" \ Apr 00: runaway monitor; put4() packed matrix
         "Tops 1.8" \ Mar 00: cursor loc in graphs; word inline:
         "Tops 1.6" \ Jan 00: endian, files
         "Tops 1.4" \ Dec 99: ptr, exe, struct
         "Tops 1.2" \ Nov 99: windows event dispatcher
         "Tops 1.1" \ Oct 99: graphics X11, XY plotting
         "Tops 1.0" \ Oct 99: multitasker
         "Tops 0.5" \ Sep 99: terminal (event loop)
         "Sage 0.4" \ Aug 99: keyboard
         "Sage 0.2" \ Jun 99: catalog, inline
         "Sage 0.1" \ Apr 99: stack
}
      "prog_version" (like Tops 2.3) book
      "pname" main into pname

      "/tmp/" is tmppath \ all system files write to here, not to
                         \ local, since permission may not allow

\     ID for this run (used later in making unique file names):
         "T" getpid _int$ cat makes runid 

\     The log file is written only during start up as this file and
\     uboot.v (if present), are sourced:
         tmppath runid cat "." pname ".log" cat cat cat 
         (qS) "filelog" book \ name of log file

         filelog set_sysout \ open log file for current output

\  -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -

\     Doing tasks in boot(), sys.c:
         tmppath runid cat "." pname ".tmp" cat cat cat (qS)
\        Name like /tmp/T1234.tops.tmp
         (qS) 1 boot \ sys scratch file

         prog_version 2 boot \ prog version

   " info: program shell environment:" . nl getenv 3 indent . nl nl

\  -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -

\     User scratch files for words scratch and scratch1:
         tmppath runid "." pname ".tmp" cat cat cat cat
\        Names like /tmp/T1234.tops.tmp1 and /tmp/T1234.tops.tmp2
         (4.1) dup 1 _int$ cat makes scratch1
         (4.2)     2 _int$ cat makes scratch2

\  -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -

\     Path SBIN for common Unix functions like ls, move, mkdir, uname:
         "-d" argv any? 
         IF (qS) "" catpath ELSE "/bin/" THEN SBIN_set

\     File SH that runs the command shell in SBIN:
         "-c" argv any? 
         IF (qS) ELSE "sh" THEN SH_set

\     Path syspath:
         _syspath "syspath" book 
         syspath (qSyspath) 3 boot

\     Path usrpath:
         "-u" argv any? not
         IF "TOPS_USRPATH" env any? not
            IF syspath "../usr" cat THEN
         THEN (qS) " " catpath strchop \ this adds an ending slash
         (qS) this dir? not IF drop "./" THEN
         "usrpath" book 

\     Prompt:
         (00) "'[' pname '@' cat cat host ']' + + lowercase"
         "prompt" macro

\  -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -

\     On-line documentation files (usually .doc files):

         (12) syspath "../doc/" catpath "dpath" book \ documentation

         (50) dpath "manual.doc" catpath is manual

         (50.5) dpath "newman.doc" catpath is newman

         (50.6) "appman.doc" is appman \ no path; man uses filefound

         (50.7) dpath "automan.doc" catpath is automan

         (51) dpath "mantutor.doc" catpath "notes" book

         dpath "hints.doc" catpath "hints" book

\  -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -

\     Perl on this system (reset this in uboot.v if necessary):
         (05) os "linux" alike
         IF "/usr/bin/perl"
         ELSE "/usr/local/bin/perl"
         THEN "perl$" book

\  -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -

\    X11 terminal:
        "/usr/bin/X11/xterm" this file? not
        IF drop "/usr/bin/X11/rxvt" THEN this file? not
        IF drop "xterm" THEN \ environment will need to tell where
        spaced "TERM" book

\    Command line for xterm default resources:
        (9.0) "termcmd -background black -foreground white "
               "-font fixed -geometry 324x225+1+1 "     cat
               "-width 320 -height 225 "                cat
               "-title Untitled "                       cat
               "-xorigin 1 -yorigin 1 "                 cat 
               "-proc defproc -draw defdraw "           cat
               "-pointsize 1 " (pointsize 0-10)         cat 
               makes termcmd 

\  -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -
{
      Note: after word extract was invented to pull items out of a
      word's local library, the code below is not really needed and
      this word _bin can be considered just a local library to be 
      drawn from.

      For example, where previously usrpath was only obtained by 
      running:

         2.1 _bin (qS)

      which causes entry into the code below to return usrpath at
      the match to 2.1, another way to get it now is by running:

         "_bin" "usrpath" extract (qS)
}

      ] uh 00  = IF drop prompt                            return THEN
      what 1   = IF drop prog_version                      return THEN
      what 2   = IF drop syspath                           return THEN
      what 2.1 = IF drop usrpath                           return THEN
      what 03  = IF drop tmppath                           return THEN
      what 4.1 = IF drop scratch1                          return THEN
      what 4.2 = IF drop scratch2                          return THEN
      what 4.3 = IF drop filelog                           return THEN
      what 05  = IF drop perl$                             return THEN
      what 06  = IF drop runid                             return THEN

      what 9.0 = IF drop termcmd (xterm default resources) return THEN
      what 9.1 = IF drop pname (Name in xterminit)         return THEN
      what 9.2 = IF drop pname (Class in xterminit)        return THEN
      what 9.3 = IF drop \ Xwindows app defaults (xterminit): 
                    "/usr/lib/X11/app-defaults/" pname cat return THEN

      what 12   = IF drop dpath                            return THEN
      what 50   = IF drop manual                           return THEN
      what 50.5 = IF drop newman                           return THEN
      what 50.6 = IF drop appman                           return THEN
      what 50.7 = IF drop automan                          return THEN
      what 51   = IF drop notes                            return THEN

      .i " is invalid index in _bin" . nl 
   end

   define: _binh (n --- qName) \ called by C functions to limit trace
      hide _bin nohide \ hides from trace to reduce extraneous output
   end

\  Version argv dialog:

   "-v" argv chars any
   "-V" argv chars any or 

   IF \ display version message and then halt
      set_stdout \ vector output to STDOUT

      pname spaced _syspath "manindex.bin" + dup file? 
      IF asciiload 1st quote strchop + (qP)
      ELSE (qS) drop
      THEN sp . nl

      {"
         Copyright (C) 1999-2007  Dale R. Williamson

         This program is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY.  For details, including conditions of
         copying and distribution, see the GNU General Public License in
         the program file named LICENSE.

         CVS and tar files of the program are available at:
            http://savannah.gnu.org/projects/tops

      "} -8 indent
      "2007" date strings dup rows ndx reach strchop strp . nl

      \  Deleting the log file (regardless of -l argv):
      '_bin' 'filelog' extract (log file name) delete

      halt
   THEN

   "library" _container \ creates word container, one time only

   inline: library (qWord --- ) \ library as a synonym for container
      container 
   end 

\-----------------------------------------------------------------------

   "PARSER_FUNCTION" container \ used by the function parser (prs.c)

\  The library of container word PARSER_FUNCTION is loaded next, which
\  enables parsed functions to be created.

{" \ Parsed function preface; runs when a function begins.

\  Halt if there are insufficient input arguments:
   depth arg_inp__ <
   IF nl name__ " HALT: need " arg_inp__ intstr " input"
      cat cat cat one indent ersys HALT
   THEN

   ercnt "ercnt__" book \ initial error count

   depthMIN "depthMIN__" book \ save former
   depth arg_inp__ - depthMIN_set \ restrict stack clearing by xx

"} textput PARSER_FUNCTION "PRE" bank

{" \ Parsed function standard return; runs when a function returns.

   depthMIN__ depthMIN_set \ set to former

\  Halt if not returning the correct number of arguments:
   depth arg_ret__ <
   IF nl name__ " HALT: need " arg_ret__ intstr " returned"
      cat cat cat one indent ersys HALT
   THEN

\  Halt if error count does not equal the initial:
   ercnt ercnt__ <>
   IF nl name__ ": HALT" cat one indent ersys HALT
   THEN


"} textput PARSER_FUNCTION "RET" bank

{" \ Parsed function user return(); runs instead of RET.

   depthMIN__ depthMIN_set \ set to former

\  Halt if not returning the correct number of arguments:
   depth arg_ret__ <
   IF nl name__ " HALT: need " arg_ret__ intstr " returned"
      cat cat cat one indent ersys HALT
   THEN

"} textput PARSER_FUNCTION "ret" bank

\-----------------------------------------------------------------------

   inline: TERM ( --- qFile) \ which xterm to use
\     This is needed for words about to be sourced.
      [ "_bin" "TERM" yank into term ] term ;

   inline: .s ( --- ) \ displaying all items on the stack
      depth 0> ok ontop and 
      IF return (because .sf will auto-show) THEN
      .sdo on, yes .sf, .sdo off ; 

   inline: .sdo ( --- addr) \ address of stack display flag
\     This flag is toggled by word .s and used by word .sf.
      [ scalar is .sdo ] .sdo ;

   inline: .sf (f --- ) \ displaying all items on the stack
\     Incoming flag f, perhaps placed on the stack by word execute, is
\     true when things are ok.
 
      [ \ The next inlines--.name, .rxc, .number, .string, .volume, 
        \ sparse?, and .sprxc--are used in the quote lines of cases, 
        \ a volume which is defined below them: 

        "named 1st word IF sp dot 32 putch THEN" ".name" inlinex

        "these rows .i ' by' dot cols .i" ".rxc" inlinex

        "(hA) is_sparse (f)" "sparse?" inlinex

        {" (X --- qX) Formatting a number:
           [ "%0.4E" "EFORM" book
             "%0.12G" "GFORM" book 
             "%0.0f" "IFORM" book
           ] 
           (X) this 0=
           IF IFORM
           ELSE (X) this abs log10 abs integer six >
              IF EFORM 
              ELSE (X) this one /mod drop 0<> 
                 IF GFORM ELSE IFORM THEN 
              THEN
           THEN (X qFORMAT) format strchop
        "} "FORM" inlinex

        {" (x --- ) Showing a number, with name if any:
           (x) this ptr?            \ is NUM a ptr?
           IF (x) " ptr->" swap ptrtok notag cat dot
           ELSE (x) this named (qS) this exists? \ NUM in library?
              IF (x qS)
                 (qS) dup number (f)  \ check if name same as number
                 IF 2drop \ don't show name if same as number
                 ELSE notag sp dot sp \ showing name without its lib tag
                 THEN
              ELSE (qS) drop
              THEN

              this is_complex
              IF real-imag (xr xi) this 0< (sign) push (xi) abs swap
                 (xr) dup abs 1E-15 < IF drop 0 THEN
                 FORM sp dot \ real part
                 dup 1E-15 < IF drop 0 THEN dup 0>
                 IF peek IF " - " ELSE " + " THEN 
                 ELSE "+"
                 THEN dot \ sign of imag
                 (xi) FORM dot "i" dot \ imag part
                 pull drop
              ELSE FORM sp dot
              THEN
           THEN 
        "} ".number" inlinex

        {" STR: showing just the left portion of very long strings:
           (qS) 32 putch
           "  " those chars dup _int$ ' character' rot one <> 
           IF 's' cat THEN cat cat (tail) swap
           these chars out less, them chars less three >
           \ shows about 35 characters of the string:
           IF (tail qS) one ndx, 68 out less three pick chars 
              less them chars min ndx crop "..." cat
           THEN asciify swap (qS tail) cat dot
        "} ".string" inlinex
 
        {" VOL can admit a variety of types:
           (hT) its sparse? 
           IF (hT) dup is_complex
              IF "spcplx:" dot this .name .rxc
              ELSE "sparse:" dot this .name .rxc
              THEN
           ELSE "volume:" dot this .name, .rxc
           THEN 
        "} ".volume" inlinex

        {" MAT can be matrix or complex, er, complx:
           (hA) dup is_complex
           IF "complx:" dot this .name .rxc
           ELSE "matrix:" dot this .name, .rxc
           THEN
        "} ".matrix" inlinex

        \  Cases of items on stack:
        {" Each row is a phrase that displays a type of stack item:
           (0    ) "unknown:" dot drop
           (1 DEF) "define:" dot drop
           (2 NUM) "number:" dot .number
           (3 MAT) .matrix
           (4 STR) "string:" dot .string
           (5 VOL) .volume 
           (6 PTR) "inline:" dot this .name, .rxc 
        "} left justify 
           makes cases (x --- ) 

        \ With x on stack, to fire nth line in cases (nth quote), say:
        \    (x) cases n quote local

        \ Making a couple of inlinex phrases for the main text:

           "_int$ hand '........' pile right justify,"
           "1st quote ' ' cat nl dot" pile "element" inlinex

           "' [' depth nit _int$ cat '] ' cat" "[depth]" inlinex

           no says revstk
      ] 
      \ Here is the main text of this word, drawing upon local inlines
      \ created above (in text within brackets, [...]): 

      \ If incoming f is missing or wrong type, say yes and keep going:
      no NUM stkok not IF yes THEN

      .sdo @ ok @ (f1 f2) or not IF drop return THEN

      (f) "flag" book \ into local lib

      depth any
      IF " stack elements:" dot 
         1st "base" book 0based \ zero-based indexing for word pick
 
         revstk
         IF
            depth 1- zero swap
            DO I 0< IF EXIT THEN 
               I element 
               I pick these type (n) cases 
               rose quite loca (hey reeky!!)
               -1
            +LOOP 
         ELSE
            depth zero
            DO I element 
               I pick these type (n) cases 
               rose quite loca (hey reeky!!)
            LOOP 
         THEN

         base indexbase \ restoring user index base
         ok @ not IF return THEN

      ELSE " stack is empty" dot return

      THEN 

      [depth] revstk IF "luhrs " cat THEN
      flag IF "ok!" ELSE "huh?" THEN cat nl dot nl
   end

   inline: alphabetize (hT --- hT1) \ based on first 8 chars
      again chop these \ ignoring leading blanks
      chars 8 min leading
      8 +trailing lowercase
      1st those rows items bend
      mat2vol park, yes sort
      -8 indent vol2mat
      bend reach (hT1)
      "_alphabetize" naming
   end

   define: backward (hT --- hT1) \ bytes of all rows in reversed order
{     Keep this as a defined word, not an inline, because inlinex bkw 
      below is used in an example in man.  In this form, this word is
      essentially an inline the way inlines were originally made: they
      simply were defined words running a local inline, which in this 
      case is bkw (and here, bkw runs local inline "rev_catch").

}     [ "1st those chars items reversed catch" "rev_catch" inlinex

        {" (hT --- hT1)
           this type MAT =
           IF bend mat2vol rev_catch vol2mat bend ELSE rev_catch THEN
        "} "bkw" inlinex
      ] bkw
   end

   inline: clean ( --- ) \ cleanup at exit
\     Chores to do when the program calls this word at exit.

      xx xl \ clear the stacks
      "stkdelete" mainif

    \ Put the log file text on temp stack if -l argv, then write it
    \ after all the cleanup:
      "-l" argv chars any
      IF '_bin' 'filelog' yank (qName) dup file?
         IF (qName) dup asciiload (hLog) 
            (qName hLog) push push
            true (f)
         ELSE (qName) drop false (f)
         THEN
      ELSE false (f)
      THEN (f) push

    \ User clean up--give user first shot at cleanup, like closing 
    \ sockets before they are operated on below:
      "uclean" mainif

      noscratch \ deleting user scratch files

    \ Deleting files made by eview:
      "eview" "eviewlist" yank noblanklines any?
      IF (hT) these rows 1st
         DO this I quote deleteif LOOP trash
      THEN

    \ Deleting files made by fbook, fbook2, fbook4:
      "fbook" exists?
      IF "fbook" "cleanup" yank
         IF "fbook" "Fnames" yank any?
            IF (hT) these rows 1st
               DO this I quote deleteif LOOP trash
            THEN
         THEN
      THEN
      "fbook2" exists?
      IF "fbook2" "cleanup" yank
         IF "fbook2" "Fnames" yank any?
            IF (hT) these rows 1st
               DO this I quote deleteif LOOP trash
            THEN
         THEN
      THEN
      "fbook4" exists?
      IF "fbook4" "cleanup" yank
         IF "fbook4" "Fnames" yank any?
            IF (hT) these rows 1st
               DO this I quote deleteif LOOP trash
            THEN
         THEN
      THEN

    \ Deleting files in /tmp:
      cleantmp

    \ Closing cluster nodes (do this before closing local connections):
      no "SOCKETS" book
      "cluster_close" exists? 
      IF cluster_close 
         yes "SOCKETS" book 
      THEN

    \ Closing local connections to remote (listening server has already
    \ been closed in function unload()):
      "clientsockets" exists?
      IF clientsockets 1st catch any? 
         IF these rows 1st DO this I pry sclose LOOP drop 
            yes "SOCKETS" book
         THEN
      THEN

    \ Closing the voice modem:
      "vmunregister" mainif

    \ Closing Matlab:
      "engOff" mainif

    \ Closing telecommunication (do this after sockets are closed):
      "PPPCON" exists? 
      IF "PPPCON" "pppcon" yank \ did this program instance connect?
         IF SOCKETS IF 3 idle THEN pppclose THEN 
      THEN

    \ Writing the log file text if f is true:
      pull (f) IF pull pull (qName hLog) swap save THEN
  
   end

   inline: cleantmp ( --- ) \ delete job-related files at /tmp
\     Only removes files with runid in name, not runid1.  
      [ 3 _bin is pathtmp, 6 _bin is runid ] 
      pathtmp dirnames any?
      IF this runid grepr reach any?
         IF pathtmp nose these rows 1st
            DO this I quote deleteif LOOP drop
         THEN
      THEN
   end

   inline: commas (hT --- qS) \ words into a string with commas between
      words right justify "," tail vol2str (qS)
      chop 1st those chars nit items catch neat
   end

   inline: cr0 (n --- ) \ clear n spaces and return carriage
      cr spaces dot cr ;

   inline: cstr (qS --- qS1) \ string S into an ascii counted string
\     Example: >> (cstr(brandom(32,127,1,254)) dup dot nl .hex)
      these chars dup 256 < 
      IF export1 swap + 
      ELSE drop " cstr: require a string with less than 256 bytes" 
         ersys return 
      THEN
   end

   inline: deleteif (qS --- ) \ delete file if permitted and it exists
      no STR stkok not IF "deleteif" stknot return THEN
      this file? 
      IF this fallow \ checking permission
         IF delete ELSE drop THEN 
      ELSE drop
      THEN ;

   inline: docpath ( --- qS) 12 _bin ; \ path to doc files

   " info: docpath is " . docpath . nl

   define: edit (qFile --- ) \ run the editor script
{     If stack contains a volume, runs eview.
      If stack is empty (no quoted file name), uses word typing to
      see if file name follows word edit, as in: edit myfile.

      Keep this a define; it is an example for cprops and libpry in man.
}
      [ defname makes dname, dname chars negate makes dent 

\        XSET is a script that runs an editor; may be reset by banking
\        another string here, as in: (qS) "edit" "XSET" bank.
         TERM
         "-bg Black -fg White -cr Salmon -fn 7x14 " cat
         "+sb -geometry 72x32+1+1 -e view" cat
         "XSET" book
      ]
      depth 0>
      IF this type VOL = IF eview return THEN
      ELSE typing dent indent any? not
         IF " file name not given" . return THEN
      THEN
      this type STR =
      IF strchop filefound
         IF X11 
            IF XSET spaced swap quoted cat ' &' cat shell
            ELSE _view
            THEN
         ELSE " file not found" .
         THEN
      ELSE dname stknot
      THEN done
   end

   inline: eview (hT --- ) \ view volume in an editor window
\     Writes T to a file at tmppath, then calls edit with string
\     containing the name of the file.
      [ 3 _bin (tmppath) 6 _bin (runid) "_" + + is eviewname 
        "" is eviewlist \ list of files to delete upon exit
      ] 
      depth 0= IF return THEN
      (hT) dup is_sparse IF fview return THEN

      hand this type MAT = IF fview return THEN \ view MAT 

      no VOL stkok not IF return THEN

      (hT) this named notag -path (Tname) push hand (hT)

      eviewname (qName)
    \ Add a tag that makes file name unique, to avoid persistent Nedit
    \ messages about the same file being edited:
      (qName) eviewlist rows intstr + "_" + (qName1)

      (qName1) pull (Tname) + (qFilename) dup push 
      (hT qFilename) save \ save a tmp file that edit will use

      peek (qFilename) eviewlist pile onto eviewlist 
      pull (qFilename) done_off edit
   end

   inline: fview (hA --- ) \ view fp matrix A in editor, mformat
\     Use word mformatset to set format, as in: "%8.3f" mformatset
      depth 0= IF return THEN
      (hT) this is_sparse IF dense THEN
      no MAT stkok not IF eview return THEN
      this named push 
      mtext 
      this named notag "toobig" alike \ too big?
      IF sp dot                       \ display too big message
      ELSE
         these rows columnofints left justify (hR)
         "Row " nose right justify ": " tail swap (hR hT) park
         one indent
         peek naming eview 
      THEN pull drop 
   end

   define: hints ( --- ) \ show hints in editor window
      [ "_bin" "hints" extract is file ]
      file edit
   end

   inline: int$ (hA --- hT) \ format matrix A into text integers
\     Note: Performs rounding if A is MAT.  To obtain truncated 
\     integers, say integer first.
      [ "%9.0f " is Aformat ]
      this is_complex 
      IF " int$: not for complex" ersys return THEN

      this type NUM =
      IF _int$
      ELSE this type MAT =
         IF Aformat those cols dup push cats format 
            (if not VOL, format failed: too many cols)
            this type VOL = pull (cols) 1 = and
            IF left justify chop right justify THEN
         ELSE " int$: expecting a number or a matrix" ersys 
         THEN
      THEN
   end

   inline: luhrs ( --- ) \ reverse items in stack display by word .sf
\     Last-out-Up-High--Reversed-Stack.
\     This word toggles revstk of word .sf to its other state.
      true 
      ".sf" "revstk" yank
      xor 
      ".sf" "revstk" bank
   end

   inline: mainbook (X qS --- ) \ book X into the main library
\     Sun Jun  7 08:59:50 PDT 2009

\     If working inside a word, book X into the main library instead
\     of the local library.

\     Works the same as word book if already working in main.

      quoted " book" + main
   end

   inline: memlog ( --- ) \ write memory usage info to a log file
      [ "_bin" "tmppath" yank
        "_bin" "runid" yank "_mem.log" cat catpath "LOG" book 
      ]
      memprobe1 (dmem)                \ capture delta_mem at start
      SYSOUT (S) push, LOG set_sysout \ vector the output to LOG
      time ctime . nl 5 spaces .      \ time to LOG
      "memprobe:" . (dmem) .i nl      \ meminuse change to LOG
      mallinfo                        \ mallinfo structure to LOG
      pull set_sysout                 \ reset output to SYSOUT
   end

   " info: word memlog will write to file " . "memlog" "LOG" yank . nl

   inline: mbook (hA qWord --- ) \ book matrix in sparse form
{     Matrix A (type MAT) is booked into the catalog as sparse, and 
      given the name Word.  

      Saying Word later will produce the original MAT A on the stack; 
      the fact that it is stored sparse in the catalog is transparent.

}     [ {" This is the text for Word to be created:
         [ defname 'matName' book, no is Mat ] 
         Mat dense matName naming \ get Mat from lib and make dense
        "} "mText" book
      ]
      true 1 STR stkok and, 2 MAT stkok and not
      IF "mbook" stknot return THEN

      "Word" book
      Word exists? not
      IF CATMSG (f) no catmsg
         mText Word inlinex
         (f) catmsg
      THEN
      \ Now make A sparse and bank it into Word's lib with name Mat:
      (hA) sparse Word "Mat" bank
   end

   inline: missing (qS --- f) \ true if S is not in main library
\     Returns true if S is not a catalog item in the main library.
      "exists?" main not ;

   inline: noroot ( --- )
      getuid 0= IF " noroot: root not allowed; exit" . nl exit THEN
   end

   inline: noscratch ( --- ) \ remove the scratch files
      scratch deleteif, scratch1 deleteif
   end

   inline: nose (hT qS --- hT1) \ place string S on left edge of all T
      over hand rows pileof duck park ;

   define: notes ( --- ) \ show tutorial in editor window
      51 _bin these chars any 
      IF edit ELSE drop " not available" . THEN
   end

   inline: nstr (n --- qN) \ integer n into an ascii counted string
\     Example: 2 48 pow negate dup .i nl nstr .hex
      "%0.f" format these chars export1 swap +
   end

   define: off (addr --- ) \ set to false the value at addr
      [ "false swap !" "off" inlinex ] off ;

   define: ok ( --- addr) \ stack display flag: say ok on or ok off
      [ scalar "okflag" book ] okflag ;

   inline: on (addr --- ) \ set to true the value at addr
      true swap ! ;

   ok on \ default

   inline: orderbyte (k --- n) \ offset to kth order byte in 4-byte int
{     For 0based, k and n range from 0 to 3, lowest to highest order;
      for 1based, k and n range from 1 to 4, lowest to highest order
      Examples (for index base equal to 1):
         On Unix (aix) RISC 6000: 1st orderbyte .i gives 4
         On Linux PC: 1st orderbyte .i gives 1
}     [ endian intstr makes ndian ]
      dup four ndx 1 ndx within
      IF ndian swap character number drop ndx
      ELSE drop " endian error" . nl 
      THEN ;

   inline: overload (qS qR --- ) \ word R runs code of existing word S
{     In bracket mode while a word is being defined, make local word R 
      that will run the code of existing word S.

      The word being defined must have a local library (private is in
      effect) so R is hidden.

      Note that during bracket mode, defname used below will supply the
      name of the word being defined.
}     
      that ptr other defname swap localref book
      swap " exe" cat defname rot localref inlinex
   end

   inline: parse_save (qFile --- )
{     Parse File and save the postfix version.  The saved file name has
      a "v" appended to File name.  
      Sourcing postfix files can be much faster.
}
      filefound
      IF dup "v" + swap asciiload parse any?
         IF textget asciify chop noblanklines
            over save
            " parse_save: wrote file " swap + . nl
         THEN
      ELSE " parse_save: file not found" . nl
      THEN
   end

   inline: pause ( --- ) \ wait for Enter key to be pressed
      keys? 
      IF nl " press Enter to continue " (qS) query drop nl THEN ;

   define: perl$ ( --- qProg) \ string to run Perl on this machine
      "_bin" "perl$" extract spaced ;

   define: progname ( --- qS) \ puts program name on stack
      [ one _bin 1st word drop lowercase into name ] name ; 

   define: runid ( --- qS) \ unique id for this session
\     Pattern to use when making unique file names.  In /tmp, files
\     with this pattern will be deleted upon exit (word cleantmp).
      [ 6 _bin "id" book ] id ;

   define: runid1 ( --- qS) \ unique id for this session
\     Pattern to use when making unique file names in /tmp that will
\     not be found and deleted upon exit (word cleantmp).
\     Use "S" instead of "T":
      [ runid "T" "S" strp "id" book ] id ;

   inline: sane ( --- ) \ reset things when they get crazy
{     Vectoring output to a file and not getting back right will
      cause output from commands (like man XXX) to not be visible
      on the screen.  This word will help.
}     keys? IF set_keyout "stty" mainif THEN "ureset" mainif
   end

   define: scratch ( --- qFile) 
      [ "_bin" "scratch1" extract "s" book ] s ;

   define: scratch1 ( --- qFile) 
      [ "_bin" "scratch2" extract "s" book ] s ;

   inline: stknot (qW --- ) \ report stack not set up as expected by W
      " " swap cat, ": " cat, "stack not as expected" cat ersys ;

   inline: stkok (n type --- f) \ is stack item n one of type?
{     Once a word works, a layer of robustness can be added with a few
      lines to verify the correct stack items before it runs, especially
      if it contains branching or looping with words like IF, DO, BEGIN.

      Interpreted words are quite forgiving of stack errors, but the
      same words turned into inlines can easily bounce out on segmenta-
      tion faults.

      This word, and word stknot, were written to help make this 
      straightforward. 

      See below, "Notes on using the stack display to set up phrases for
      word stkok" for an example. 
}
      SYSOUT push TRACE 
      IF ftempsys (qFile)             \ temp file from system
         (qFile) dup push set_sysout  \ output to temp file if TRACE
      THEN

    \ Verifying the incoming stack (n type --- f):
      depth two < 
      IF "stkok" stknot no (f) 
      ELSE over (n) type NUM = (f1),  
         over (type) type NUM = (f1 f2) and (f) 

       \ Testing stack item n to see if it is type:
         IF depth two less, other >
            IF swap tic pick type = (f)
            ELSE 2drop no (f) \ n is below stack depth
            THEN
         ELSE "stkok" stknot no
         THEN
      THEN (f)

      TRACE IF pull (qFile) delete THEN
      pull set_sysout
   end

\  Here is an example of a word that creates other words (inlines)--in
\  this case, words that perform a simple calculation and leave the
\  result on top of the stack:

   inline: struct (qS qE --- ) \ functions to access structure elements
{     Quoted list of element names, E, tied to structure name S.

      All structures are vectors of 8-byte numbers.  Some elements may 
      be ordinary numbers and others may be pointers to items in the 
      catalog.

      Word ptr will turn any type of catalog item--words native and de-
      fined; numbers, matrices, strings, volumes--into a pointer suit-
      able for placing into a structure.  This means there is nothing 
      in this system that cannot be put into a structure.

      Word struct defined here enables the creation of names that make
      it convenient to fetch and store (using words pry and poke) num-
      ber and pointer elements of a vector.

      Notes:
         Switching index base after creating the structure will not 
         affect the pointers created by word struct.

         The name "sizeof" is reserved for returning structure size
         (see example below).

      Example:    

         Using this word to declare a structure "xcb" and its element 
         names (commas between element names are ignored):

            "xcb" "handle, proc, draw, xorigin, yorigin" struct

         That's it.  Here is running the word that puts the size of 
         this structure on the stack:

            xcb.sizeof (5) 

         Here are some functions to go into a type xcb,

            define: myproc " Default window event handler ..." nl . ;
            define: mydraw " Default window painter ..." nl . ;

         and here is creation of a structure of type xcb called myXCB,
         using word vector: to put its elements into a vector of 8-byte
         numbers in the same order as "xcb" ... struct above:

            vector: 50004, "myproc" ptr, "mydraw" ptr, 0 0 ; is myXCB

         Aside: 
            There is no check above to see if myXCB is the size of
            xcb.sizeof.  If it is too small, attempting to store or
            fetch beyond its boundary will be reported.  

            Storing elements as above presumes the order of structure
            items.  There is plenty of rope here to hang oneself.

            To be more formal, the next lines guarantee correct size 
            and storage to proper elements, regardless of code order:

               xcb.sizeof 1 null "myXCB" book       (a 5-by-1 vector)
               "myproc" ptr  myXCB xcb.proc   poke  (2nd element)
               "mydraw" ptr  myXCB xcb.draw   poke  (3rd element)
               50004         myXCB xcb.handle poke  (1st element)

               (and null gave the 0 0 values in 4th and 5th elements) 

         Fetching the handle element from myXCB:

            myXCB xcb.handle pry .i (50004)

         Storing a value in the xorigin element, then fetching it:

            17 myXCB xcb.xorigin poke 
            myXCB xcb.xorigin pry .i (17)

         Fetching myproc, a function pointer, and running it:

            myXCB xcb.proc pry exe 
            (Default window event handler ...)
}
      [ "sizeof" into key, "." key cat makes .key 
        " is the reserved word for length of this structure" says msg
        " fault at word: struct" is fault
      ] 
      words dup key those rows pileof match   
      these totals ontop, swap rows = not  
      IF drop .key cat sp . msg . nl fault . return
      THEN 

\     Making an inline that leaves the struct size (rows) on the stack:
      these rows _int$ " 'sizeof' naming" cat other .key cat inlinex 

      xbase push, 0based swap "." cat nose chop these rows 1st

\     And here is creation of a set of inlines that provides the offsets
\     to elements of the struct.  Any can be called upon later to add 
\     its offset to the index base at the time and leave the result on 
\     the stack:
      ?DO I _int$ " xbase + " cat that I quote inlinex
      LOOP 
      drop pull indexbase
   end

   inline: syspath ( --- qS) two _bin ; \ path to system files

   " info: syspath is " . syspath . nl

   inline: tag? (hA --- qTag) \ type tag for A, or empty quote if none
\     Assumes show_tag text contains NULL when tag is undefined, and 
\     has a colon preceding tag type when tag is defined.
   
      (n) this ptr?
      IF ".sf" ".number" "localrun" >stk 
          1st quote strchop (qTag)
      ELSE
         this type MAT = 
         IF "dense " ELSE "" THEN (qD) swap 

         (hA) "show_tag" >stk this "NULL" grepr rows any
         IF drop "" 
         ELSE ":" tug -1 indent "[]" chblank
         THEN (qT)
         (qD qT) cat words vol2str strchop (qTag)
      THEN
   end

   inline: tagmain ( --- qTag) \ tag constraining catalog search to main
      "tag" main ;

   define: tiny ( --- x) \ value of one bit in 8-byte fp number
{     tiny is the value of a single bit in the 8-byte floating point
      numbers of the machine. 

      The following phrase

         1.0 "%30.29f" format . tiny "%30.29f" format nl .

      shows how 1.0 and tiny stack up:

         1.00000000000000000000000000000
         0.00000000000000011102230246252 (1.1102E-16)

      1/tiny equals 2 53 pow, and is the largest of the consecutive
      integers in the 52 mantissa bits of the machine's IEEE 8-byte 
      fp number.

      The phrase "1 tiny slash '%18.0f' format dot" shows this largest
      integer:  

         9007199254740992 (9.0072E+15)

      Above this number, consecutive integers are not possible because
      bits are lost.  For example, adding 1 just gives the same number:

         9007199254740992 1 + "%18.0f" format dot 
         9007199254740992
 
      It happens that (1/2.54)*2.54 does not equal 1.0 by one bit, so it
      is used below to derive tiny.  Of course 1/(2^53) would work too.

      2.54 also happens to be the factor for converting centimeters to
      inches, so blindly converting from centimeters to inches and back
      again will incur this bit loss.  Words in/cm and in/mm given be-
      low take tiny into account when they calculate the conversion, so
      they get it right: one minus cm/in times in/cm will equal 0, not
      tiny.  
}
      [ once again 2.54 slash 2.54 star less "tiny" book ] tiny ;

   inline: usrpath ( --- qS) \ path to user files
      "_bin" "usrpath" yank
   end

   " info: usrpath is " . usrpath . nl

   inline: usrpath_set (qS --- ) \ set the path to user files
\     Override usrpath that was set at start up.
      "_bin" "usrpath" 1st quote bank
   end

   define: version ( --- qS) \ puts version number on stack
      [ "_bin" "prog_version" extract 2nd word 
        drop into version ] version  
   end

   inline: vstruct (hMat k num --- f) \ validate a structure
{     Validate structure Mat through its magic number at element k.

      Example (see also man vstruct):

         \ Making a struct called frame with a magic element, mag:
            "frame" "la ti da mag" struct

         \ Making some vectors that might be structures:
            frame.sizeof 1 null "Rxx" book
            frame.sizeof 1 null "Sxx" book
            frame.sizeof 2 * 1 null "Txx" book

         \ Arbitrary magic number
            "frame" str2num makes frame_magic 

         \ Installing the magic number in Rxx and Txx:
            frame_magic Rxx frame.mag poke 
            frame_magic Txx frame.mag poke 

         \ Later, validating some frame structures:
            Rxx (hMat) frame.mag frame_magic vstruct (f=yes)
            Sxx (hMat) frame.mag frame_magic vstruct (f=not)
            Txx (hMat) frame.mag frame_magic vstruct (f=yes)
}
      true one NUM stkok and, two NUM stkok and, three MAT stkok and
      not IF "vstruct" stknot return THEN

      push those rows over (rows k) >= 
      IF (hMat k) pry peek (m num) = (f)
      ELSE 2drop false (f)
      THEN pull drop
   end

\-----------------------------------------------------------------------

\  This is the second layer of foundation words:

   inline: +path (qS --- qS1) \ add path to file name S
{     To the file name in S, add the path that filefound would find; 
      otherwise add nothing.
      S can be a volume T with one file name per row.
}     [
         255 is Wmax \ assumed max width of any string, including path
         "  " is 2spaces \ lengthen for two quotes possibly removed
      ]
      chop Wmax +trailing these rows 1st
      DO this I quote unquoted filefound 
         IF 2spaces cat that I said THEN 
      LOOP chop
   end

   inline: -ext (qS.ext --- qS) \ remove trailing extension from string
\     Removes the rightmost dot and all to its right.
\     Returns original string if no extension found.

      \ verifying the incoming stack:
      no STR stkok not IF "-ext" stknot return THEN

      words dup push rows 1st
      DO peek I quote
         (qS.ext) strchop this "x" cat backward
         "." those chars cats xor 
         these chars spaces or 
         this 2nd word (f)
         IF drop 1st word (f) drop 1st 
            two pick (qS.ext) chars
            two roll (.ext) chars 
            (len1 len2) less items catch
         ELSE drop \ no 2nd word--no extension
         THEN (qS)
      LOOP
      pull rows pilen vol2str strchop
   end
   
   inline: -filename (qPathFilename --- qPath) \ remove file name
      strchop this -path 
      strlen 1st them chars 
      rot less items catch
   end

   inline: .m (hA --- ) \ display a matrix according to mformat
      depth 0= IF " .m: empty stack" ersys return THEN
      this is_sparse IF dense THEN
      no MAT stkok 
      IF any?
         IF mtext (hT)
            these rows columnofints left justify (hR)
            "Row " nose right justify ": " tail swap (hR hT) park
            one indent 
         ELSE " .m: matrix is purged"
         THEN
      THEN dot 
   end

   define: .me (hA --- ) \ display terms with exponent if required
      [ "%12.5g" is form ] mformat form mformatset swap .m mformatset ;

   inline: .out (qT n --- ) \ display T with up to n chars per line
{     Works best for many small strings on one line.

      This word uses recursion and is subject to overflow of the
      return stack if many strings in T are very wide (approaching 
      the size of n).  

      On entry, the value of out is used for indenting.  The very
      first use may need a prior nl or cr to initialize out prior
      to running this word (see man out).

      See word mano (key.v) where a file formatted with .out is
      created.
}
      [ one "INDENT" book ]

    \ Verifying the stack first:
      false two STR stkok or, two VOL stkok or, one NUM stkok and not
      IF ".out" stknot return THEN

      out "INDENT" book
      those rows 1st
      DO that I quote over .out1, those rows ndx I <>
         IF INDENT spaces nl dot THEN
      LOOP 2drop
   end

   inline: .out1 (qS n --- ) \ display S with up to n chars per line
\     Splitting S at n, and then splitting all remainders of S at n,
\     until nothing is left.

      swap left justify this 
      other out less split1 (hHead hTail)

      swap (hHead) notrailing any?
      IF (hHead) dot THEN

      (hTail) any? \ more lines?
      IF ".out" "INDENT" yank two plus spaces \ indenting plus two
         (qSpaces) nl dot
         lop swap (qS n) .out1 \ recursing
      ELSE 2drop
      THEN
   end

   define: .uinthex (n --- ) \ display hex 4-byte unsigned int pattern
      uints "%X" format dot ;

   inline: 0i (hAr --- hAr hAi) \ zero imaginary part for real Ar
      this type NUM = IF zero ELSE these dims null THEN ;

   define: 4ints (hV --- hT) \ 8-byte fp matrix column to 4-byte int
{     Note: V is a column vector; returned T is text vector 4 bytes wide

      Uses: Making integer matrices half as big for file storage, or
      formatting as in this example:

         list: 3 2 1 ; 4ints vol2mat bend '%d' format "dat." nose dot 

}     [ list: 0 0 0 0 1 1 1 1 ; "apart" book
        "ints hand bend mat2vol apart claw hawk" "run" inlinex 
      ] run ;

   inline: == (qA qB --- qF) \ bitwise equate; 0 bits where not equal
\     For STR, NUM, MAT; for VOL, use vol2mat first.
      2dup xor rev nott swap nott xor and nott
   end

   inline: across (hA --- hV) \ vec V contains totals of each row of A
      bend down ;

   define: beneath (hV x --- hR) \ rake for V vals equal to x or beneath
      -INF inclusive [ "_0_rakes_x_or_beneath" says N ] N naming ;

   inline: between (hT qS1 qS2 --- hT1) \ text between S1 and S2
\     The text from T that is between pairs of strings S1 and S2 is in
\     T1.  Lines of T without paired S1-S2 are blank in T1.

      no 
      three STR stkok or, three VOL stkok or
      two STR stkok and, one STR stkok and not
      IF "between" stknot return THEN
       
      this any? not IF 3 dump "" return THEN drop
      that any? not IF 3 dump "" return THEN drop
      them any? not IF 3 dump "" return THEN drop

      xbase push 
      0based \ using smap indices, which are offsets (0based)

      "S2" book "S1" book, S1 strlen is Slen
      (hT) hand again push rows 1st   
      DO peek I quote (qS) push

       \ Mapping offsets to patterns:
         peek (qS) S1 smap "O1" book
         peek (qS) S2 smap "O2" book
         no "count" book

       \ Operating on paired offsets where O2 > O1:
         O1 rows any, O2 rows any and
         IF O1 rows 1st
            
            DO peek (qS), O1 I pry (c1) this Slen plus swap

             \ Raking out O2 offsets that are less than O1(i):
               (c1) O2 rows one fill O2 >
               O2 bob rake trash any?

             \ The O2 offset to use, if any, is on top:
               IF ontop (c2) over less (c2-c1) items catch (qS)
                  spaced hand (hTi), one count bump

               ELSE (qS c1) 2drop
               THEN (hTi) 
            LOOP count any? IF (n) parkn chop ELSE " " hand THEN

         ELSE " " hand
         THEN
         pull drop

      LOOP
      pull rows pilen "_between" naming
      pull indexbase
   end

   inline: blanklines (hT --- hR) \ R contains 0 at blank rows in T
\     R contains 1 at rows matching T rows that are not blank.
      these chars spaces, those rows pileof match ;

   inline: center (hT wid --- hT1) \ center text in field of wid chars
                     says wid, oh no blockofblanks
                      back hand left justify again
                             push rows 1st
                            DO peek I quote
                       notrailing wid those chars
                         less two slash indent
                          pile LOOP pull trash
                                  end

   inline: catitems ( --- hT) \ list of all items in the catalog
      no _catitems ;

   inline: char (u --- c) \ unsigned NUM u into character STR c
{     Examples:
         command         gives
         10 char .hex    0A
        127 char .hex    7F
        128 char .hex    80
       -128 char .hex    80
       -129 char .hex    7F
        255 char .hex    FF
}     
      (u) uint4 (string) 1st orderbyte catch (c) ;

   inline: chpack (hT --- hT1) \ T1 is T without any blanks
      " " "" strp chop
   end
{
   inline: chpack (qS --- qS1) \ no blanks in string S
      chop any? 
      IF push "" peek chars 1st
         DO peek I character dup " " alike IF drop ELSE cat THEN LOOP
         pull drop
      ELSE "" 
      THEN
   end
}
   inline: _cite (hT n1 qS --- hRake) \ rake for lines citing S at n1
\     Up to eight characters in S are matched for citing
      1st those chars 8 min ndx crop push
      (hT n1) peek chars items catch vol2mat
      pull those chars pileof vol2mat less nullc
   end

   inline: cite (hT n1 qS -- hRake) \ rake for lines citing S at char n1
\     Up to eight characters in S are matched for citing
      [ "0_at_matched" notrailing makes tok ]
      true
      one STR stkok and
      two NUM stkok and
      three VOL stkok and
      not IF "cite" stknot return THEN
      _cite tok naming
   end

   inline: COLS ( --- c) \ current columns in window text
\     Returns nominal value when no keyboard, for cases where stty 
\     called by _COLS would cause an error.
      [ 80 "nominal" book ]
      keys? IF _COLS any? not IF nominal THEN ELSE nominal THEN ;

   inline: columnofints (n --- hT) \ text column of integers, 1 to n
      one duck items, "%.0f" format, chop right justify
      "_colints" naming
   end

   inline: CRLF ( --- q0D0A) \ 2-byte carriage return and line feed
\     The ^M on heritage DOS files.
      [ 13 char (0D)
        10 char (0A) cat "crlf" book
      ] crlf 
   end

   inline: crowd (qS --- qS1) \ left justified, no commas, 1 space apart
      no one STR stkok or, one VOL stkok or not 
      IF "crowd" stknot return THEN 

      words vol2str strchop 
   end

   inline: dice (hA --- hA1 hA2) \ A1 and A2 hold every other of A
\     Example:
\        101 9 items dup .i nl dice .i nl .i
      these rows two spikes rake swap
   end

   define: digits (x --- n) \ powers of 10 in x
      (n negative for x <= .1) [ {"
         no NUM stkok
         IF abs this one <
            IF its 0= IF trash once again
                      ELSE one duck slash, -1 duck
                      THEN
            ELSE one duck
            THEN log10 integer star
         ELSE "digits" stknot
         THEN
      "} "digits" inlinex ] digits end

   define: dump (x0 x1 ... xn N --- ) \ drop N stack items
\     N is a count, not an index; it can equal 0, so 0based and ?DO
\     are handy here:
      [ "no max 1st push 0based, depth nit min (N) zero "
        "?DO (xI) drop LOOP, pull (1st) indexbase" cat "d" inline 
      ] d run ;

   inline: dupes (hV --- hV1) \ duplicates from V into V1
\     One of the duplicates from V is in V1; elements remain in 
\     original order.
\     Example:
\       list: 4.1 5.1 1.1 2.1 5.1 4.1 6.1 4.1 ; dup .m dupes nl nl .m

      INF pile, 1st those rows items park, yes sort this
      1st catch sling1 rake drop, yes 2nd sorton 1st catch
      1st those rows nit items reach
   end

   inline: dup_sum (hA --- hB)
{     Where values in column 1 of A are duplicates, sum the correspond-
      ing values in column 2.

      Example
         list: 3 3 4 3 5 6 4 10 10 4 ;
         list: 1 1 1 1 1 1 1 1  1  1 ; park dup_sum .m

         Since col 2 values are all 1, the col 2 sums show that there
         are:
            3 threes, 3 fours, one five, one six, and two tens:
               Row 1:        3        3
               Row 2:        4        3
               Row 3:        5        1
               Row 4:        6        1
               Row 5:       10        2
}
      yes sort 
      this 2nd catch 
      partials park
      nodupes1 \ this word takes the last duplicate
      this 1st catch
      swap 3rd catch 
      this 1st pry       \ save 1st sum
      swap delta 
      swap that 1st poke \ store 1st sum
      park
   end

   inline: endcols (hC k --- hC1) \ the last k columns from C
      any? 
      IF integer push these cols ndx peek less tic pull items catch
      ELSE rows no null
      THEN
   end

   inline: endmost (hC k --- hC1) \ the last k rows from C
      any?
      IF integer push these rows ndx peek less tic pull items reach 
      ELSE cols no swap null
      THEN
   end
   
   inline: erase (qA n --- qA1) \ erase first n characters of A
      swap that negate, indent swap indent ;

   inline: even (n -- nEven) \ round n down to closest even
      integer this two mod less ;

   inline: field (n --- c1 c2) \ column indices for nth field of a line
\     Works for index 0 or 1 based, using
\        c1=width*(n-xbase)+xbase
\        c2=c1+width-1=c1+delta
      [ scalar "width" book, scalar "delta" book ]
      integer xbase less width ontop star 
      xbase plus this delta ontop plus
   end

   inline: fieldwidth (n --- ) \ sets field width to n characters
      integer its one <
      IF " field width must be 1 or greater" . nl drop return THEN
      dup "field" "width" implant1
      nit "field" "delta" implant1
   end

   8 fieldwidth \ default width for word field

   inline: flip ( --- f) urn 0.5 > end \ heads or tails

   inline: freed ( --- hPurged) \ handle to a purged matrix
\     Making huge M negligible with phrase: freed is M
      [ 0 0 null "purged" book ] purged ;

   inline: getCLIP ( --- hL) \ get rectangle limits for plot
      "setCLIP" "L" yank
   end

   inline: grab (hT qS n --- hL) \ lines of T with S in field n
{     L has no rows if no lines found.
      Note: This word is not sensitive to case; S length is 8 chars max.
      Example: "abc dEf" "efg def" pile "EF" 6 grab . nl
}     push that lowercase, pull rot lowercase, cite rake trash ;

   inline: grabs (hT qS n --- hL) \ lines of T with S in field n
{     L has no rows if no lines found.
      Note: This word is sensitive to case; S length is 8 chars max.
      Example: "abc dEf" "efg def" pile "ef" 6 grabs . nl
}     push that, pull rot, cite rake trash ;

   define: greater (hV x --- hR) \ rake for V vals equal to x or greater
      INF inclusive N naming [ "_0_rakes_x_or_greater" says N ] ;

   define: greaterthan (hA n --- hF) \ F(i,j) true where A(i,j) > n
      [ "those dims fill >" "gt" inlinex ] gt ;

   inline: idle (secs --- ) \ idle for secs
      no NUM stkok not IF "idle" stknot return THEN 
      "UNLOCK" swap (secs) LOCK 
   end

   define: in/cm ( --- x) \ inches per cm
      [ 1 cm/in / tiny cm/in / + makes i ] i ; 

   define: in/mm ( --- x) \ inches per mm
      [ 1 mm/in / tiny mm/in / + makes i ] i ; 

   inline: itext (hA --- hT) \ matrix A terms rounded to integer text
      mformat push       \ save format
      this named swap rounded "%8.0f" mformatset
      mtext (qName hT) swap naming
      pull mformatset    \ restore format
   end

   inline: Ivec (i r --- hIvec) \ rake of length r, with 0 at row i
      push hand, pull teeth "_Ivec" naming end

   inline: leading (hT n --- hT1) \ n leading characters of T into T1
      1st this rot, plus nit crop ;

   define: lerp1 (hX ht ht1 --- hX1) \ X vecs at t into X1 vecs at t1
{     Example: values (no, two, pi) at times (0, 1, 2) are interpolated
      at other times: (0, .1, .5, .75, 1.0, 1.6, 1.9, 2, 3).
   
         vector: no two pi ; (hX) list: 0 1 2 ; (ht)
         2dup swap park push,
         list: 0, .1, .5, .75, 1, 1.6, 1.9 2.0 3.0 ; (ht1)
         dup push lerp1 (hX1) pull swap park
         " Lerped:" nl . nl .m " Original:" nl nl . nl pull .m, nl

}     [ {" (tries X bend (transpose) if X rows don't match rows of t)
           (making inline to speed up IF branches)
           rev back those rows, those rows <>
           IF (hX) bend true ELSE false THEN
           push park back, those cols nit clone lerp
           pull IF bend THEN (hX1)
        "} "lerp1" inline ] lerp1 run
   end

   define: lessthan (hA n --- hF) \ F(i,j) true where A(i,j) < n
      [ "those dims fill <" "lt" inlinex ] lt ;

   inline: LINES ( --- c) \ current lines in window text
\     Returns nominal value when no keyboard, when stty called by _LINES
\     would cause an error.
      [ 25 "nominal" book ]
      keys? IF _LINES any? not IF nominal THEN ELSE nominal THEN ;

   define: match (hT1 hT2 --- hV) \ V(i)=0 if row i of T1 and T2 match
\     Note: embedded NL characters (x0A) can mess up a match; they
\     can be seen using word .hex and removed with word asciify.
      [ {" 
           2dup rows swap rows <>
           IF " volumes have different rows" dot nl return THEN
           notrailing swap notrailing 2dup chars swap chars max,
           dup rev +trailing, rev +trailing
           vol2mat swap vol2mat xor nullc 
        "} "match" -strict inline strict
      ] match run
   end

   inline: matlist (hM1 hM2 ... hMk k --- hA) \ k handles into ptr list
\     Turn k handles for cataloged matrices, sitting on the stack, into
\     a list of ptr numbers
      no NUM stkok not IF "matlist" stknot return THEN
      dup nit push 1st DO peek roll named ptr LOOP
      pull tic listn 
   end

   inline: mean (hA --- hV) \ means of the columns of A
      these totals swap rows /f ;

   inline: merge (A00 A10 A01 A11 r01 c01 --- hA)
\     Assembling four submatrices into A using row rake r01 and
\     column rake c01:
      push, dup push, tier (A00 A10 Aright)
      rev, pull tier swap  (Aleft Aright)
      pull mesh            (hA)
   end

   define: mformat ( --- qS) "mformatset" "format" extract ;

   define: mformatset (qS --- ) \ set mformat, used by mtext
      no STR stkok IF "format" book ELSE "mformatset" stknot THEN end

{  Examples for mformatset:
      X.Y denotes width X and Y characters right of the decimal point
      Examples for -23.4567:
         "%8.4f"  -23.4567
         "%8.4e"  -2.3457e+01
         "%8.4E"  -2.3457E+01
         "%8.4g"  -23.46 
         "%10.6g" -23.4567 
}
   "%8.4g" mformatset \ setting initial mformat string

   inline: mtext (hA --- hT) \ matrix formatted using mformat
\     Uses format from word mformat; to set format, use mformatset
      [ "matrix is purged" hand "msg" book

      \ Note: sys/ukey.v may reset these values of RowsMax and ColsMax 
      \ at start up:
           80000 "RowsMax" book, 64 "ColsMax" book

      ]
      dup is_sparse IF dense THEN
      no MAT stkok not IF "mtext" stknot return THEN

      these dims star 0= IF drop msg return THEN

      these cols ColsMax >
      IF "mtext: " ColsMax int$ " columns max" cat cat hand return THEN

      these rows RowsMax >
      IF "mtext: " RowsMax int$ " rows max" cat cat hand return THEN 

      mformat "form" book 
      no "strip" book

      (hA) again push cols 1st, peek is_complex (f)

      IF DO peek I catch real-imag (hAr hAi)
            (hAi) form format left justify swap
            (hAr) form format right justify "," tail                   
            swap park (hTi)
            backward notrailing backward notrailing "  " tail
         LOOP  

      ELSE peek rows one = \ if 1 row, add another for neat cols:
         IF pull these dims null pile push true "strip" book THEN

         DO peek I catch, form format right justify " " tail 
         LOOP

      THEN (hT1 hT2 ... hTN) pull cols (N) parkn
      strip IF 1st reach THEN \ get back 1 row

   end

   inline: namedupes (hT --- hR) \ 0 at rows of R for dup names in T
{     R has 0 for rows of T names that match in two or more rows.
      T contains names of 8 characters or less in the first field of 8
      characters of each row.  When T is left justified, only the name
      followed by necessary spaces is assumed to occupy the first 8 
      characters.
}     (hT) left justify, 8 +trailing, 1st 8 items catch
      dup vol2mat (hA) bend these rows over nodupes, rows =
      IF (hT hA) drop one swap rows one fill (hR)
      ELSE (hT hT) dupes bend mat2vol makes Dupes
         these rows 1 null (hR), Dupes rows 1st
         DO (hT hR) over 1st Dupes I quote _cite 0= or LOOP 
         (hT hR) lop, not abs (hR) \ convert from [-1, 0] to [0, 1]
      THEN
   end

   inline: neat1 (hT w --- hT1) \ sub-strings of T in cols, max width w
{     Sub-strings of T are listed across rows of T1 in a number of
      columms that fits within w.

      Example:
         "/usr/include" dirnames alphabetize COLS neat1 .
}
      false
      2 VOL stkok or
      2 STR stkok or
      1 NUM stkok and not
      IF "neat1" stknot return THEN

      swap asciify chop noblanklines these chars 0=
      IF 2drop VOL tpurged return THEN

      strings swap

      those chars slash integer "cols" book

      these rows cols mod cols swap less
      (r) this 1 < IF drop cop return THEN

      (r) one blockofblanks (hT hU) pile (hT)

      (hT) push peek rows 1st
      DO peek I cols items reach vol2str cols +LOOP

      pull rows cols slash pilen neat noblanklines
      "_neat1" naming (hT1)
   end

   inline: NLch ( --- c) \ newline character
\     Example:
\        "line 1" NLch cat, "line 2 but no carriage return hit" cat .
      [ NL char "nlch" book ] nlch ;

   inline: no_ext (qS.ext --- qS) \ remove trailing extension from S
\     Version of -ext for parser.
      -ext ;

   inline: null? (hA --- f) \ true if matrix A is null
      these dims star 0> \ a zero dim array is considered null here 
      IF dup is_sparse IF dense THEN (hA)
         abs totals totals ontop 0= 
      ELSE drop true 
      THEN
   end

   inline: nulls (n --- qS) \ quote-string of n nulls
      this one null mat2vol 1st quote 1st rot items catch ;

   inline: numbad (hA --- hR) \ true at rows of V with invalid numbers
{     Bad numbers in V are denoted by INF, -INF, NANQ, and -NANQ.
      Returned R has true at rows of bad numbers.

      If A is a matrix, R is also a matrix.

      Example:
         list: 1 0 slash, dup negate, 0 0 slash, dup negate pi ;
         these numbad park .m

         Here is the example run under AIX on a RISC 6000:
             Row 1:      INF       -1
             Row 2:     -INF       -1
             Row 3:     NaNQ       -1
             Row 4:    -NaNQ       -1
             Row 5:    3.142        0

         In linux, there is no -NaN.  NaN is displayed whether or not
         the sign bit is set, i.e., 0 0 / and 0 0 / negate both display
         NaN as this shows:

         Here is the example run under linux on a 486 pc; note row 4:
             Row 1:      Inf       -1
             Row 2:     -Inf       -1
             Row 3:      NaN       -1
             Row 4:      NaN       -1
             Row 5:    3.142        0
}
      [ 0 0 slash "NANQ" book ]
      abs its INF those dims fill =
      swap NANQ those dims fill xor 0= or
   end

   inline: numerate (hT --- hV) \ pulling all numbers out of text
{     Reading numbers from volume T and putting them into vector V.  
      Non-numbers are skipped, and V has 0 rows if no numbers are 
      found in T.

      Examples:
         "1.2 in., 6.3-2 in/sec, .003 g " 
         " -1.2 10 66 " pile 
         numerate 3 fold .m

         " A B C " numerate any?
         IF .m ELSE " no nums" . THEN nl

}     any?
      IF numbers its INF those rows one fill xor rake lop 
      ELSE purged
      THEN
      "_numerate" naming 
   end

   inline: oclock (hh:mm:ss --- n) \ time string into a number
      ":" chblank numbers
      this 1st pry 10000 *
      that 2nd pry 100 * +
      swap 3rd pry + ;

   inline: odd (n -- nOdd) \ round n down to closest odd
      integer this two mod nit plus ;

   define: ones (n --- hOnes) \ making vector of n ones
      [ "once one rev fill, '_1vec' naming" "ones" inline ] ones run ;

   inline: parkText (hA hB --- hT) \ park text A on left of B
\     Park A on left of B, where initially they have different heights.
\     Resulting volume T has height of the tallest.
      makes B, makes A, A rows, B rows =
      IF A B \ heights are same, so just park
      ELSE A rows, B rows <
         IF   A,   B rows A rows less, A chars blockofblanks pile, B,
         ELSE A B, A rows B rows less, B chars blockofblanks pile,
         THEN (A B)
      THEN (A B) park (hT), freed freed says A says B,
      "_Tpark"  naming
   end

   inline: partition (A r01 c01 --- A00 A10 A01 A11)
\     Breaking A into four submatrices using row rake r01 and column 
\     rake c01:
      swap, push claw,   (Aleft Aright)
      swap, peek rake,   (Aright A00 A10)
      two roll, pull rake, (A00 A10 A01 A11)
   end

   inline: plot (hY hX --- ) \ plot Y versus X
\     Firing word _plot in file plot.v.
      X11 
      IF "_plot" missing IF "plot.v" source THEN _plot
      ELSE " plot: X11 graphics required" ersys 
      THEN
   end

   inline: plotclose ( --- )
      "_plotclose" missing 
      IF " _plotclose: plot window not found" ersys return THEN
      _plotclose ;

   inline: powmat (A1 n --- A) \ raise square matrix A to power n
    \ For reference, an infix version of this word follows below.

      [ 1E-8 "eps" book ]
      true 1 NUM stkok and, 2 MAT stkok and not
      IF "powmat" stknot return THEN

      those rows them cols (r c) <>
      IF " powmat: matrix must be square" ersys return THEN

      this Re -1 = that Im 0= and
      IF (A1 n) drop purged swap (hPurged hA1) solve (hA) return THEN

      "zggev" exists? not
      IF " powmat: lapack function zggev() not found" ersys return THEN

      "n" book (hA1) dup is_complex
      IF false ELSE 0i complex true THEN "real" book "A" book

      A dup rows identity 0i complex (hA hI)
      (hA hI) zggev "R" book "L" book /by "W" book

      W L conj transpose
      A R * mpydg /by 0.5 ^ (fac) push
      R peek (fac) diagpost "R" book \ right hand eigs normalized
      L conj pull diagpost transpose "L" book \ left hand normalized

    { Notes:
         See sys/lapack.v for eigenvector normalization examples

         Normalization makes L the inverse of R:
            R * L = I

         L and R transform A1 into diagonal B:
            B = L * A1 * R

         Diagonal B to power n is back transformed to A^n:
            A^n = R * B^n * L
    }
      L A * R * diag (hB) n ^ (hB^n) \ diagonal matrix to power n
      R swap (hR hB^n) diagpost L * (hA) \ transform back to A

      real
      IF (hA) dup Im abs maxfetch 2drop (e) eps <
         IF (hA) Re THEN
      THEN

      purged "W" book purged "R" book purged "L" book purged "L" book
   end
{
   Below is a version of powmat() written in infix, for comparison with
   the postfix version above:

   function (A) = powmat(A1, n) { // raise square matrix A1 to power n
      { eps = 1E-8; }

      if(rows(A1) != cols(A1))
         return(ersys(" powmat: matrix must be square"));

      if(Re(n)==-1 && Im(n)==0) return(solve(purged, A1));

      if(!exists?("zggev"))
         return(ersys(" powmat: lapack function zggev() not found"));

      if(!is_complex(A1)) A = complex(A1, null(dims(A1)));
      else A = A1;

      (a, b, L, R) = zggev(A, complex(eye(rows(A)), null(dims(A))));
      W = a./b;

      fac = (W ./ mpydg(conj(L)', A*R))^0.5;
      R = R *\ fac; # right hand eigenvectors normalized
      L = (conj(L) *\ fac)'; # left hand eigenvectors normalized

   /* Notes:
         See sys/lapack.v for eigenvector normalization examples

         Normalization makes L the inverse of R:
            R * L = I

         L and R transform A1 into diagonal B:
            B = L * A1 * R

         Diagonal B to power n is back transformed to A^n:
            A^n = R * B^n * L
   */
      B = diag(L * A * R)^n;
      A = R *\ B * L;

      IF(!is_complex(A1)) ;
         (e, i, j) = maxfetch(abs(Im(A)));
         if(e < eps) A = Re(A);
      THEN

      B = L = R = W = purged;
   }
}
   inline: psource (qFile --- ) \ parse and run the phrases in text File
{     Array buf and integer count allow this word to be reentered and
      to keep the setting of INFIX so it can be reset before returning,
      in case File sourced changed it.
}
      [ 32 "levels" book, levels 1 null "buf" book, no "count" book 
        "_bin" "scratch1" extract -filename runid1 + "_psource" +
        "FSAVE" book
      ]
      this filefound not 
      IF " psource: file " swap cat " not found" cat ersys return THEN

      lop count tic levels min "count" book
      INFIX buf count ndx poke

      old ascii "T" file
      T INF fget (hT)
      T fclose

      ercnt "ERR" book

      (hT) parse (hT1) \ parse text

      ercnt ERR less 0<> 
      IF (hT1) drop " psource: halt with errors" ersys return THEN

      (hT1) push FSAVE count suffix stksave pull \ save old stk

      (hT1) main \ run parsed text

      depth 0>
      IF FSAVE "A" + stksave yes ELSE no THEN push \ save new stk
      FSAVE count suffix stkrestore pull           \ restore old stk
      IF FSAVE "A" + stkrestore THEN               \ restore new stk

      buf count ndx pry infix_set
      count nit zero max "count" book
   end

   inline: purged ( --- hPurged) \ handle to a purged matrix
      "freed" "purged" yank ;

   inline: qreplace (hT qS1 qS2 --- hT1) \ replace S1 lines in T with S2
\     Every line in T containing quote S1--anywhere in the line--will 
\     be replaced entirely by the quote S2.

      true one STR stkok and, two STR stkok and, \ top two STR
      three VOL stkok four STR stkok or and      \ third VOL or STR 
      not IF "qreplace" stknot return THEN

      "S2" book, "S1" book 
      (hT) these chars, S1 chars, S2 chars max max +trailing
      these S1 grepr, those rows teeth 0= 
      ape push rake, S2 bob rows pileof 
      those chars +trailing pull tier 
      "_qreplace" naming
   end

   inline: ranint (n1 n2 r c --- hN) \ r-by-c random ints, n1-n2
\     Example.  Expect about 1000 in each of 21 bins from -10 to +10:
\        -10 10 21000 1 ranint -10 10 21 bins .m

      push push 2dup min 0.5 less rev max 0.5 plus pull pull
      ranreal dup sign bit 2 *f 1 +d push abs 0.5 +d integer pull *by ;

   inline: ranreal (x1 x2 r c --- hX) \ r-by-c randoms in range x1-x2
      random swap other less star swap plus ;

   inline: seedt ( --- ) \ set random seed based upon microsecond time
    \ Fri Apr  9 08:28:38 PDT 2010
      [ 16 0 9 items - "CHARS" book ]
      time 1E6 * intstr CHARS ndx catch number drop (nseed)
      (nseed) dup "s" book seedset
   end

   inline: setCLIP (hL --- ) \ set rectangle limits for plot
\     List L contains:
\        Xmin, Xmax, Ymin, Ymax
\     for the graph about to be drawn.

\     To turn clipping off, say: purged setCLIP

      any?
      IF these dims star four <>
         IF " setCLIP: require 4 values: Xmin, Xmax, Ymin, Ymax" ersys
         ELSE chainr "L" book
         THEN
      ELSE purged "L" book
      THEN
      [ purged is L ] 
   end

   inline: sorted? (hA --- f) \ test for ascending values in cols of A
      no MAT stkok not IF "sorted?" stknot return THEN
      dup cols push dup rows negate push
      delta 0 >= totals pull = pull 1 = IF @ THEN ;

   inline: spaces " " bob cats ; (n --- qS) \ quote-string of n spaces

   inline: spikes (n m --- hR) \ pattern rake for every mth of n items
\     R has ones on 1st and every mth.
      xbase push 1based
      those uniform one +d, this other bsearch drop
      1st swap items reach, swap teeth 0= abs 
      pull indexbase
   end

   inline: split (hT n --- hHead hTail) \ n chars in hHead, rem in hTail
      2dup leading, "_head" naming rev, negate indent "_tail" naming ;

   inline: split1 (qS n --- qHead qTail) \ split at nearest blank < n
\     Splitting quote line S at blank nearest or before nth character.
\     Tail will have 0 characters for short strings.

    \ Not running without verifying the stack first:
      false two VOL stkok or, two STR stkok or, one NUM stkok and, not
      IF "split1" stknot return THEN

      (n) 2 max \ require n > 1
      swap 1st quote swap \ if VOL, just doing 1st row
      those chars over <
      IF drop once no blockofblanks return
      THEN
      xbase push 1based
      tic " " other park
      swap those chars
      min tic makes k, true is ch
      BEGIN
         ch BL <> k 1st > and
      WHILE
         k nit makes k,
         this k byte makes ch
      REPEAT drop k nit split notrailing (hHead hTail)
      those chars 0= IF swap THEN \ use Tail if Head is empty
      pull indexbase
   end

   inline: strmin (hT qS --- qS1) \ min length sub-string S* in T
{     Minimum length, left-most sub-string in T that begins with S and
      partially matches one or more quotes (rows) in T.

      Example:
         '"Makefile.hp" "Makefile.ibm" "Makefile.linux"'
         words dup . nl '"Ma' strmin nl .
}
      those chars those chars (Tchar Schar) < 
      IF 2drop "" return THEN \ return empty if S is wider than T

      "S" book, (hT) noq_alike (hT)
      (hT) dup 1st S strlen items catch, S grepe any?
      IF reach "T" book

         T chars S chars = 
         T rows one = or
         IF T 1st quote strchop return THEN

         T chars "Cmax" book
         T rows "R" book  
         S chars tic "C" book
         
         T 1st C items catch noq_alike (hT1)

       \ Adding characters until more than one row is different:
         BEGIN 
            (hT1) rows one = (f1)
            C Cmax < (f2)
            and (f)
         WHILE
            one C bump
            T 1st C items catch noq_alike (hT1)
         REPEAT
         T 1st C nit items catch, 1st quote strchop

      ELSE (hT) drop ""
      THEN
   end

   inline: submat (hA hRows hCols --- hA1) \ submatrix of A
      swap push catch pull reach ;

   inline: suffix (qS n --- qS1) \ append number n to string
      _int$ butt ; 

   inline: systime$ ( --- qHH:mm:ss) \ current program time
      time ctime words this ":" grepr ontop quote strchop ;

   inline: tear (hT hQ --- hTop hBot) \ split text T at line matching Q
\     Tear T at its line that matches quote Q; Q will be the last line
\     in Top returned.  Leftmost spaces in Q, and indentation in T, are
\     ignored during matching.

      1st quote swap hand swap
      true one STR stkok and two VOL stkok and not
      IF "tear" stknot return THEN (hQ) chop

      over left justify, 1st them chars items catch
      swap those rows pileof match
      one those rows items, swap rake drop any?
      IF 1st swap ontop items
         those rows teeth rake
      ELSE no those chars blockofblanks
      THEN swap "_hTop" naming, swap "_hBot" naming
   end

   inline: teeth (hRows n -- hRake) \ len n Rake: 0 at Rows, 1 elsewhere
      once one rev fill duck, hen no replace "_teeth" naming ;

   inline: there (hA c x --- hRake) \ rake for rows of A with x in col c
      rev catch back thereat ;

   inline: thru (n n2 --- n n+1 n+2 n+3 ... n2) 
      2dup = IF drop return THEN
      xbase 0= IF 2dup < IF tic THEN THEN
      swap DO I LOOP
   end

   inline: tile (A B C D --- E) \ pile A onto B, C onto D; then park
{                 A  C
             E = 
                  B  D
}     pile rev pile swap park ;
   
   inline: uboot_done ( --- ans) \ true when uboot.v has been sourced
      [ no "ans" book ] ans ; \ uboot.v will look for ans

   inline: ukey_done ( --- ans) \ true when ukey.v has been sourced
      [ no "ans" book ] ans ; \ ukey.v will look for ans

   inline: wrap (hA qName --- _hA1) \ copy A to A1, give qName to A1
\     Remember that new hA1 is temporary on the stack until it is in a 
\     library; old A, if in a library, can be freed, as in: freed is A.
      bob hand cop duck naming end

   inline: yearfix (hYYY --- hYYY1) \ add 100 to any YYY(i) less than 70
      this type NUM = push
      hand again 70 those rows one fill <
      -100 those rows one fill *by plus
      pull IF ontop THEN
   end

\-----------------------------------------------------------------------

\  Inlines that save typing quotes around file names often used:
   "'cal.v'"   "cal.v"   inlinex
   "'mat.v'"   "mat.v"   inlinex \ puts string mat.v on stack
   "'math.v'"  "math.v"  inlinex
   "'mmath.v'" "mmath.v" inlinex
   "'nas.v'"   "nas.v"   inlinex
   "'plot.v'"  "plot.v"  inlinex
   "'tex.v'"   "tex.v"   inlinex
   "'web.v'"   "web.v"   inlinex

\-----------------------------------------------------------------------

\  Required vocabulary files at start up, before uboot.v and ukey.v:
   "hash.v" filefound IF source THEN \ words for hash
   "file.v" filefound IF source THEN \ words for working with files
   "sys.v"  filefound IF source THEN \ operating system words
   "CONNECT" exists?
   IF "dog.v" filefound IF source THEN \ interprocess words
      "net.v" filefound IF source THEN \ network words
   THEN

 \ Define now some things for later, so they will be behind fence: 
      1 1 xray drop         \ file handle .xray.tmp 
      no "__TEMP_FILE" book \ temporary file handle 
   
   time pull less " info: seconds elapsed to load boot.v:" . .i nl
{
   From here, control returns to main.c which will source the input 
   file defined on the command line.  

   If no input file is defined on the command line, then main.c will
   cause file key.v to be sourced.  

   File key.v is the file that runs the program interactively.  It may 
   load additional user-specific words from file ukey.v, then it runs 
   word console which locks the program into an endless loop until word
   bye, quit or exit is keyed.
}
   private halt \ done with boot.v

\-----------------------------------------------------------------------
;  Appendix.
\-----------------------------------------------------------------------

{  Words that empty the stack, and serve as models for inlining, DO ...
   LOOP, BEGIN ... f WHILE ... REPEAT, and BEGIN ... f UNTIL:

   Which version is faster?  Here's a word that loads up the stack to
   time them:
     _define: dd [ "xx 32000 1st DO I LOOP" "dd" inline ] dd run ;
}
  _define: xx3 (... --- ) \ clearing everything off the stack
      [ "1 depth 1st DO drop LOOP" "xx3" inline ] xx3 run ;

  _define: xx2 (... --- ) \ clearing everything off the stack
      [ "BEGIN depth WHILE drop REPEAT" "xx2" inline ] xx2 run ;

  _define: xx1 (... --- ) \ clearing everything off the stack
      [ "1 BEGIN drop depth 0= UNTIL" "xx1" inline ] xx1 run ;

\-----------------------------------------------------------------------

\  Here are some phrases for making a unique id.  In _bin, the program 
\  uses the PID instead.

\     Making a unique id for this session: a string starting with T
\     and followed by 7 random hex chars:
      "t" seedget time seedset 1 8 trandom swap seedset
      vol2mat "%x" format 1st 7 items catch 1st quote cat
      makes runid

\-----------------------------------------------------------------------
{
   Notes on using the stack display to set up phrases for word stkok:

      With interactive word console (key.v) always showing the stack on
      every NL (by firing word .sf in this file), it is pretty easy to
      write these instructions.  The stack display is handy because an
      item to be tested can get further down in the stack as flags ac-
      cumulate from prior tested items--what was item 2 to test may be
      item 4 when it is time to test it.

      Consider word .out, defined in this file, and its stack diagram
      shown in this line of its definition:

         define: .out (hT n --- ) \ display text T with n char ...

      The following phrase was written for word .out to verify that a
      number, n, is topmost and a handle to a text string or volume,
      hT, is second:

           (hT n) 1 VOL stkok, 2 STR stkok or, 1 NUM stkok and (f)

      Since many words share similar stack diagrams, once a phrase like
      this is worked out it can be used in a number of places.  Word
      split1 received this same test, and just scanning stack diagrams
      of words here shows others that can use it.  And words fold and
      matrix defined below can use a very similar but simpler test,
      where checks for VOL and STR are replaced with one just for MAT.

      Shown next is a demonstration of this phrase as it was written,
      where a text string and ordinary number are first placed on the
      stack to mimic hT and n expected by word .out.  Note that number-
      ing of stack elements is always 0 based, with 0 the topmost.  This
      is always the convention, regardless of our choice of index base
      (made with words 0based and 1based).

         [user@gutter] /home/dale/proj/sage/sou > sage > myfile
                  Tops 0.5.1
         Mon Sep  6 21:59:39 PDT 1999
         [tops@gutter] ready > "my output" 5 << phrase to test: hT n

          stack elements:
                0 number: 5                 << that's n
                1 string: my output  1 by 9 << that's hT (9 char STR)
          [2] ok!
         [tops@gutter] ready > 1 VOL stkok  << testing hT, element 1,
                                                 for type VOL
          stack elements:
                0 number: 0                 << false flag from stkok:
                1 number: 5                      hT is not VOL
                2 string: my output  1 by 9 << hT is now element 2
          [3] ok!
         [tops@gutter] ready > 2 STR stkok  << testing hT for type STR,
                                                 but now it is element 2
          stack elements:                        as seen above
                0 number: -1                << true flag from stkok:
                1 number: 0                      hT is a STR
                2 number: 5
                3 string: my output  1 by 9
          [4] ok!
         [tops@gutter] ready > or           << ORing the flags 0, -1

          stack elements:
                0 number: -1                << have true from ORing, so
                1 number: 5                      hT is a STR or VOL
                2 string: my output  1 by 9
          [3] ok!
         [tops@gutter] ready > 1 NUM stkok  << testing the 5 for NUM

          stack elements:
                0 number: -1                << true flag for NUM 5
                1 number: -1                << true flag from hT ORing
                2 number: 5
                3 string: my output  1 by 9
          [4] ok!
         [tops@gutter] ready > and          << ANDing flags -1, -1

          stack elements:
                0 number: -1                << final flag is true: .out
                1 number: 5                      will test it and return
                2 string: my output  1 by 9      if it is not true
          [3] ok!
         [tops@gutter] ready > bye
                 Good-bye
         Mon Sep  6 22:15:06 PDT 1999
         [user@gutter] /home/dale/proj/sage/sou >

      And in word, stkok, one can see what it does to check its stack 
      items before checking the stack for another.
}
\-----------------------------------------------------------------------
{
   Obsolete words.  These obsolete words are now in the compiled pro-
   gram or replaced above by better versions.  They are left here for
   reference.

  _inline: +trailing (hT n --- hT1) \ widen text T to n characters
      that type rev back hand -trailing no rot blockofblanks pile
      back STR = IF 1st quote THEN
   end

  _inline: -path (qPath/File --- qFile) # remove path from quote-string
\     Returns the name beyond the last slash.
\     Returns an empty (0 character) string if the incoming string ends
\     with slash.

      no STR stkok not IF "-path" stknot return THEN
      dup chars any not IF return THEN

      [ "/" is slash ]
      dup again strlen ndx catch slash alike not
      IF (qPath/File) slash chblank words
         these rows ndx quote strchop (qFile)
      ELSE drop ""
      THEN (qFile)
   end

  _inline: -path (qPath/Filename --- qFilename) \ remove path name
\     Removes the rightmost slash and all to its left.
\     Returns an empty (0 character) string if no file name found.

      no STR stkok not IF "-path" stknot return THEN

      (qPath/Filename) strchop backward this "x" cat
      "/" those chars cats xor 1st word (f)
      IF 1st swap chars
         other chars min
         items catch backward
      ELSE drop ""
      THEN (qFilename)
   end

  _inline: 2nd ( --- 1 or 2) \ second index under current index base
      1st tic ;

  _inline: 3rd ( --- 2 or 3) \ third index under current index base
      1st tic tic ;

  _inline: clean (f --- ) \ cleanup at exit
\     Chores to do when the program calls this word at exit.
\     Incoming f is true if ok to delete .out file.
      [ 4.3 _bin (qFile) ".out" book ]
      [ "info: start up complete" is split_line ]
      keys?
      IF (f) \ normally no file; .log file if f is false
         IF .out deleteif
         ELSE "/bin/mv " .out spaced progname ".log" cat cat cat shell
         THEN

      \ Batch job splits .out file into .log and .out:
      ELSE (f) drop .out file? \ separating file at split_line:
         IF .out asciiload split_line tear swap (hOut hLog)
            (hLog) asciify progname ".log" cat save .out deleteif
            "sleep 1" shell
            (hOut) any? IF progname ".out" cat save THEN
         THEN
      THEN

      noscratch \ deleting user scratch files

      \ Deleting files made by eview:
      "eview" "eviewlist" extract noblanklines any?
      IF these rows 1st
         DO dup I quote deleteif LOOP drop
      THEN

      \ Deleting files in /tmp:
      cleantmp

      \ Closing telecommunication:
      "PPPCON" exists? IF PPPCON IF pppclose THEN THEN

      \ Closing the voice modem:
      "vmunregister" exists? IF vmunregister THEN
      cr
   end

   _define: chop (qS --- qS1) \ chop surrounding blanks
      left justify notrailing ;

  _inline: crowd (qS --- qS1) \ left justified, no commas, 1 space apart
      no one STR stkok or, one VOL stkok or not 
      IF "crowd" stknot return THEN words any?
      IF xbase push 0based  
         this push 1st quote notrailing, peek rows 2nd
         ?DO " " peek I quote notrailing cat cat LOOP
         pull drop pull indexbase
      ELSE ""
      THEN
   end

  _define: date ( --- qS) \ current date and time to stack
      [ {"
           'date > ' scratch cat system,
            scratch asciiload 1st quote,
            notrailing scratch extern delete
        "} "U" inline ] U run ;

  _define: delete (qS --- ) \ deletes file called S
      [ "'/bin/rm ' swap cat system" "U" inline ] U run ;

  _inline: delta (hA --- hdA) \ change in A vals from one row to next
\     dA(k,j) = A(k,j) - A(k-1,j), and the first element, dA(1,j) = 0
      this one lag less ;

\ Parsed functions are not stack-friendly; for low level, use the 
\ postfix version of this word.
function (B)=dup_sum(A1) {
\  Sum the values in column 2 of A1 wherever the values in column 1
\  are equal.  See man dup_sum1 for an example.

\  Sort incoming A1 rows on column 1 values, then append a third column
\  of the partial sums of column 2, and finally remove rows that are
\  duplicates in column 1:
   A=nodupes1(park((A=sort(A1,yes)), partials(catch(A,ndx(2)))));

   S=catch(A, ndx(3)); \ partial sums from 3rd column
   s=pry(S, ndx(1));   \ save 1st partial sum

   S=delta(S);         \ delta partial sums (but S(1)=0)
   poke(s, S, ndx(1)); \ 1st partial sum replaces 0 in S(1)

   B=park(catch(A,ndx(1)), S); \ return column 1 of A and S, parked

   A=S=purged; \ local arrays no longer needed
}

  _define: fetch (hA i j --- x) \ putting value of A(i,j) on stack
      [ "1st less, 2 pick rows star, plus pry" "fetch" inline ]
      fetch run end 

  _define: fold (hV n --- hA) \ vector V into matrix A, n rows per col
\     Turns a vector, containing an n-row matrix stored by columns, 
\     back into a matrix of n rows (see matrix).
      [ {"
           makes n push, n no empty (hA),
           peek (hV) rows n /mod lop (cols), n star 1st max, 1st
           ?DO peek (hV) I n items reach park, n +LOOP,
           pull (hV) drop, (hA) "_fold" naming
        "} "fold" inline 
      ] fold run
   end

  _define: host ( --- qS) 0.1 _bin ; \ puts host name on stack

  _define: intervals (x1 x2 n --- hX) \ n equal spaces between x1 and x2
\     n+1 points in X define the n intervals from x1 to x2.
      [ "push over less peek slash, pull tic uniform swap +d"
        "intervals" inline ] intervals run ;

   _inline: lag (hA n -- hA1) \ all A rows shifted down by n rows
\     First n rows are unchanged.  Rows shifted up if n is negative.
      uh, 0< IF swap reversed swap true, ELSE false THEN push abs
      2dup 1st swap, items reach rev, 1st them rows rot less,
      items reach pile, pull IF reversed THEN
   end

   Word localpry has been replaced by native word extract:
  _inline: localpry (qW qS--- hS) \ get S from local library of W
\     Warning: if S is an inlinex, it will fire--have stack ready
\     Example: "erif-12345" "backward" "bkw" localpry dot
      tagsep rot cat cat ptr exe ;

  _inline: localref1 (qWord qName --- qS) \ catalog S for Name in Word
\     Make a catalog name with local library tag, for use with names
\     sent to words that make words.
      strchop tagsep rot, strchop any? 
      IF cat ELSE drop tagmain THEN cat
   end

  _define: matrix (hV r --- hA) \ reorder vec V into r-row mat A
\     Turns a vector, containing an r-row matrix stored by rows, back
\     into a matrix of r rows (see fold).
      [ {"
           1st push 1based says r, these rows r slash into c
           r ones into R, no one null  
           c once DO R I *f pile LOOP
           once r uniform bend, c clone bend, c *f plus reach
           r fold (hA) "_matrix" naming, pull indexbase
        "} "matrix" -strict inline strict
      ] matrix run
   end

  _inline: missing (qS --- f) \ true if S is not a file and not in main
      this file? duck "exists?" main or not ;

\  Replaced by native word:
  _inline: neat (hT --- hT1) \ sub-strings of T into neat columns
      push one into count
      BEGIN peek count ndx string
         IF one count bump
            left justify " " tail
            no
         ELSE yes
         THEN
      UNTIL count nit any? IF parkn ELSE "" THEN
      pull drop notrailing "_neat" naming
   end
{
\ Parsed functions are not stack-friendly; for low level, use the 
\ postfix version of this word.
   function (S)=no_ext(S1) {
   \ Infix version of -ext (which, to infix, looks like negative ext).
      return(chop(backward(indent(tug(backward(S1),"."),-1))));
   }
}

\  Replaced by native word:
  _inline: nodupes (hV --- hV1) \ vector V1 is V without duplicates
\     One duplicate is kept in V1; elements remain in original order.
\     Example:
\       list: 4 4 1 2 5 4 6 5 ; dup .m nodupes nl nl .m

      1st those rows items park, yes sort this 1st catch 
      sling1 rake lop, yes 2nd sorton 1st catch
   end

  _inline: nodupes (hV --- hV1) \ vector V1 is V without duplicates
\     One duplicate is kept in V1; elements remain in original order.
\     Example:
\       list: 4.1 4.1 1.1 2.1 5.1 4.1 6.1 5.1 ; dup .m nodupes nl nl .m

      INF pile, 1st those rows items park, yes sort this
      1st catch sling1 rake lop, yes 2nd sorton 
      1st those rows nit items, 1st submat
   end
 
  _inline: noq_alike (hT --- hT1) \ rows from T that are unique
\     Returns T1 with no quotes (rows) from T that are alike.
      these rows any
      IF push 
         list: peek rows 1st
            DO peek again I quote grepe ontop LOOP
          end nodupes pull swap (hT hRows) reach
      THEN
   end

  _inline: nullbyte ( --- qS) \ a null byte
      [ 0 num2str 1st character "S" book ] S ;

  _inline: NULLch ( --- c) \ null character
      [ nullbyte "nullch" book ] nullch ;

  _define: numbers (qS --- hV) \ pulling all numbers out of a quote str
      [ {" \ V will have zero rows if no numbers in S
           extern words push, no one empty
           list: peek rows 1st DO peek I quote number drop LOOP 
           end pull drop
        "} "numbers" inline ] numbers run 
   end     

  _inline: oclock (hh:mm:ss --- n) \ time string into a number
\     Expects two digits for each number.
      [ 1st push, 1 indexbase
        0 255 1 byte!, 255 2 byte!, 255 4 byte!,
          255 5 byte!, 255 7 byte!, 255 8 byte! num2str into mask1
        0  32 3 byte!,  32 6 byte! num2str into mask2, pull indexbase
      ] chop mask1 and, mask2 or, numerate 
        this 1st pry 10000 *
        that 2nd pry 100 * + 
        swap 3rd pry + ;

  _inline: os ( --- qS) \ operating system of this machine
      [ "_bin" "_os" yank "os" book ] os ;

  _inline: pwd ( --- qS) \ string showing present working-directory
      SBIN "pwd > " cat scratch cat minshell
      scratch asciiload scratch delete
      (hT) strchop (hT) "/" cat ;

  _inline: quoted (qS --- q"S") \ string in quotes
      again '"' grepr rows any IF "'" ELSE '"' THEN 
      back over cat cat ;
 
  _define: rounded (hA --- hA1) \ terms of A rounded to nearest integer
      [ {"
           this hand again sign bit
           again plus one +d \ +1,-1 for signs
           swap abs 0.5 +d integer swap *by
           swap type NUM = IF 1st pry THEN
      "} "rounded" inline 
      ] rounded run
   end

  _define: sign ( --- b) \ location of sign bit in 8-byte fp words
      [ {" Note: b includes the current base index, 1st.
           [ -1 1 xor, 64 1st
             DO dup I bit ontop abs any IF I 1st less EXIT THEN
             LOOP into s drop
           ] 1st s plus
        "} "sign" inline
      ] sign run
   end

  _inline: sling (hV --- hRake) \ rake for last of consecutive dups
{     Rake has 1 at location of last in series of zero or more equal
      values in V, zeroes elsewhere; example:
            list: 12 12 11 11 15 15 17 20 20 ; this sling park .i
      Note that ending 20 20 is not considered consecutive duplicates.

      To force ending duplicates to be considered, pile a different
      value on the end, like:
         list: 12 12 11 11 15 15 17 20 20 ; INF pile this sling park .i

      In some cases, V must be sorted first to group all duplicate
      items, as in word bins (file express file math.voc).
      But word toggled (file matrix.voc) uses sling with unsorted V.

}     1st catch this, 2nd those rows nit items reach, INF pile less
      abs these rows ones min zero pow, 0 over these rows poke ;

  _inline: sling1 (hV --- hRake) \ rake for first of consecutive dups
{     Rake has 1 at location of first in series of zero or more equal
      values in V, zeroes elsewhere; first value in Rake is always 1.
      Example:
            list: 11 12 12 11 11 15 15 17 12 12 ; this sling1 park .i
}  
      reversed INF pile sling 0 over 1st poke
      1st those rows nit items reach reversed ;

  _inline: spaced (qS --- qS_) \ appending one space to S
{     If this word is changed, to verify continued operability test it
      using tabfill on a unique match, like -ALARM:

           [tops@clacker] ready > man -ALA [tab tab]

       should display

          [tops@clacker] ready > man -ALARM _

      where the cursor (shown above as _) follows a space after the M.
}
      these rows 1 = IF hand 1st quote " " butt ELSE " " tail THEN
   end
\  This version is slow for large n:
  _inline: spikes (n m --- hR) \ pattern rake for every mth of n items
\     R has ones on 1st and every mth.
      those uniform one +d, one rot items find ;

\  Replaced by version that uses ersys:
   _inline: stknot (qW --- ) \ report stack not set up as expected by W
      " stack for " swap " not as expected " cat cat dot nl ;
 
  _define: store (x hA i j --- ) \ storing x at A(i,j)
      [ "1st less 2 pick rows star plus poke" "store" inline ] 
      store run end

  _inline: tagsep ( --- qXXX) \ separator between itemName and libName
{     XXX is the separator in every catalog name, as in this example:

         If a stack item named kingPixmap is booked into the library of
         word chessMen (by firing phrase '"kingPixmap" book' while in-
         side word chessMen), the string "kingPixmap" is itemName, XXX
         is the separator, and "chessMen" is the libName.  The catalog
         name is formed by the concatenation of these three strings:

            catalog name = itemNameXXXlibName
                         = kingPixmapXXXchessMen

      The phrase in brackets below works because word tag returns the
      tag of this word, XXXtagsep, right now as this word is being
      created; the remaining words in brackets strip off characters
      tagsep so just XXX remains, and place XXX into the local library
      under the name tagsep.  When the word runs later, quote string
      tagsep from this local library is simply pushed to the stack.
}     [ tag                          \ XXXtagsep
        backward -6 indent backward  \ removes the 6 characters, tagsep
        1st quote (XXX) makes tagsep \ XXX chars into local library
      ] tagsep ;                     \ when run, XXX from local lib

  _inline: tail (hT qS --- hT1) \ add string S on right edge of all T
     over hand rows (qS n) pileof park ;

  _inline: vol2str (hT --- qS) \ volume T into string S
      hand 0 VOL stkok not IF "vol2str" stknot return THEN
      asciify notrailing " " tail vol2mat chain mat2vol 1st quote ;

   Word "words" below should test that qS is a string, or this can hap-
   pen (the new native word, "words," does test qS):

   [tops@gutter] ready > "1 2 3 4 5 "  " 7 6 5 4 3 " pile <<< Not string
   [tops@gutter] ready > words
    word: expect string on stack
    Jz: expect flag, true or false, on stack
   Segmentation fault (core dumped)
   [user@gutter] /home/dale/proj/sage/sou >

  _define: words (qS --- hT) \ each word in string S is row in matrix T
      [ {"
           1st push 0based, push 0 0 blockofblanks
           BEGIN peek those rows word,
              IF pile false, ELSE true THEN
           UNTIL notrailing pull drop, pull indexbase
        "} "words" inline ] words run
   end

  _inline: xl (... --- ) \ clearing everything off the local stack
      no push tdepth 1st DO pull trash LOOP ;

  _inline: xx (... --- ) \ clearing everything off the stack
      no depth 1st DO trash LOOP ;

