\ {{{1 GNU General Public License
{
Program Tops - a stack-based computing environment
Copyright (C) 1999-2005  Dale R. Williamson

Author: Dale R. Williamson <dale.williamson@prodigy.net>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
1}}} 
}

\ File gyroant.v                                            October 2000

\ Adapted from express gyroant.voc, December 1998

\ The 100 line input file, gyro.dat, is appended below.

\-----------------------------------------------------------------------

   "trap" missing IF "mmath.v" include THEN
   "plot" missing IF plot.v source THEN
   private 1based

\  yes \ making data file and running solution
   no  \ not making data file, just running solution
   IF
\-----------------------------------------------------------------------

\  Curves and sample times:

\     These are the coarse X,Y data points used to make the curve:
         list: 3.4,5.6  3.4,5.6  3.4,5.6  3.4,5.6  3.4,5.6  3.0,6.0 
               2.0,5.8  1.1,5.2  .95,4.5  1.2,4.0  1.6,3.8  2.2,3.8
               2.6,4.2  2.9,5.2  3.0,6.0 2.95,5.2  2.9,4.2  2.8,3.5
               2.5,2.5  2.0,1.5  1.2,0.9  .76,1.4  .80,2.0  1.2,2.5
               2.0,3.0  2.8,3.5  3.6,4.0 ; 
         10 /f, these rows 2 slash matrix, 
         bend dup 1 catch negate IC+ bend \ remove initial X, Y values
         list: 1 0 ; claw into X, into Y

\     The curve will be drawn in 3.1 sec, with acceleration sampled 
\     32 times per second.  Time points of sampled data are:
         3.1 (sec) push one, 32 (Hz) /, peek over /, 
         tic uniform into tsamp

{     Corresponding time points of coarse data X,Y read above are 
      determined by assuming that an equal amount of time passes 
      between each pair of values in the table above, no matter how 
      far apart:
}        list: 1 X rows ; list: 0 pull (sec) ; 
         park 1 X rows items lerp into tX 

{     Fit splines to the coarse X(t) and Y(t) data.  Word s3coef is 
      used to fit a cubic spline to the coarse data, then word s3eval 
      evaluates the spline function for the tsamp time points, also 
      producing first and second derivatives:
}        X Y park, tX s3coef (hC) tsamp s3eval (x x' x'') 
         (x x' x'') bend into ddXY, bend into dXY, bend into XY

{     These phrases plot what's been done so far.  Copy and drop any 
      or all:

         X Y park, tX plot       \ coarse d(t) (X is blue, Y is green)
         XY tsamp plot           \ d(t)
         dXY tsamp plot          \ v(t)
         ddXY tsamp plot         \ a(t)
         Y X plot                \ coarse Y(X)
         XY bend list: 1 0 ; claw plot \ sampled Y(X)

      Copy and drop the following to demonstrate integrating the 
      sampled acceleration data (try it with and without initial 
      contitions):
         ddXY tsamp trap, dXY 1st catch, IC+ \ acceleration to velocity
         tsamp trap, XY 1st catch IC+        \ velocity to displacement
         its XY 0.1 +offset pile tsamp plot  \ compare to XY displaced
         bend list: 1 0 ; claw plot          \ show Y(X)
}
\     Curve for top end of pen, used to generate pen motion (resembles 
\     a lowercase omega):
         list: 3.5,5.2  3.5,5.2  3.5,5.2  3.5,5.2  3.5,5.2  
               2.5,4.5  3.0,3.5  4.0,3.7  4.8 5.1  4.8,3.8  
               6.0,3.2  6.5,5.5 ; 
         10 /f, these rows 2 / matrix, 
         bend dup 1 catch negate IC+ bend \ remove initial X, Y values
         list: 1 0 ; claw into Xb, into Yb
         list: 1 Xb rows ; list: 0 tX its rows pry (sec) ; 
         park 1 Xb rows items lerp into tXb 
         Xb Yb park, tXb s3coef (hC) tsamp s3eval (x x' x'') 
         (x x' x'') drop drop bend into XYb
\        XYb bend list: 1 0 ; claw plot

\----------------------------------------------------------------------

{  Initial measurements: 

      The pen is in Doc Mano's right hand ready to write, and Gyro is 
      an inch or two below the far end using his laser plumb bob to 
      measure the following at t = 0:
}        36.9 (deg) rad/deg * is theta \ pen tilt from vertical
         4.0 (in.) is H                \ height from Gyro to paper

\     Estimated pen diameter is:
         0.375 (in.) is d              \ pen diameter

{     Using these axes XYZ for the paper to establish an inertial ref-
      erence: 
         Z points up from the paper, parallel to the plumb bob gravity 
            vector
         X points to Doc Mano's right, such that it lies in a plane 
            containing the pen and the Z vector, and passes through the
            plumb bob point on the paper that is directly below Gyro
         Y follows so that XYZ form a right handed system
      Call this system a.

      For Gyro holding tightly to the pen, assume the following:
         His z lies along pen length, positive up from the pen point
         His x is fixed in the pen at t = 0 to lie in the plane con-
            taining inertial Z, X and his z
         y follows because xyz is a right handed system
      Call this system p.
 
      Create the initial attitude reference matrix for Gyro's xyz with 
      respect to the paper XYZ at t = 0; call this matrix Cap0:
}        vector: 1 0 0 ; dup is x0 \ a vector in plane of paper X and Z

\        Project Gyro's z axis onto inertial (paper) X and Z:
         vector: H theta tan *, 0, H ; (hZ)
         (x0 hZ) dircos is Cap0 \ pen (frame p) attitude with respect
                                \ to the paper (frame a)

{     The three columns of Cap0 are unit vectors that, in the order 
      1-2-3, represent the projection of pen-fixed axes x-y-z (where 
      Gyro is riding) onto the inertial axes XYZ.  Cap0 is only valid 
      at t = 0.  Use the following to view Cap0:
          Cap0 .m
}
\-----------------------------------------------------------------------
{
   Pen attitude and angular rate on Gyro's rate gyros:

      Plane XY of the paper reference system will be defined as plane
      a.  It is the one where the pen point moves as the curve is drawn.

      Define another plane offset and tilted from plane a where motion 
      of the aft end of the pen is projected, and call this plane b.
      
      Let a vector projected along the pen z define the origin of plane
      b:
}        Cap0 vector: 0 0 15 ; * makes B* \ vec between origins: a to b

\     and assume an arbitrary orientation of plane b with respect to 
\     plane a:
         vector: 0 1 0 ; vector: 0 0 1 ; dircos is Cab1 \ b to a
 
{     Paths (trajectories) on these two planes will determine the 
      tilts seen by the pen as one end follows the character path on 
      the first, and a projection of the pen length onto the second 
      plane follows an arbitrary path placed on it.
  
      The trajectory on plane a is curve XY with a zero component for 
      Z.  Create vector ra that is XY with a zero Z component:
}        XY, once those cows empty, pile onto ra

\     The trajectory on plane b is curve XYb with a zero component for 
\     Z.  Create vector rb that is XYb with a zero Z component:
         vector: 1 0 0 ; 
         vector: 0 0 1 ; dircos (Cxy) \ to flip upside down
         (Cxy) XYb once those cows empty pile star onto rb

{     Copy and drop the following to see the trajectories of planes a 
      and b:

         ra bend this 1st catch swap 2nd catch plot
         rb bend this 1st catch swap 2nd catch plot

      A vector containing the pen z axis is the vector connecting 
      time-matched points between ra and rb.  Call this zp:
                           zp = Cab*rb + B* - ra
      where 
         B* is the vector from origin a to origin b, resolved to 
            system a
         ra is the trajectory on plane a, resolved to axes of system a
         rb is the trajectory on plane b, resolved to axes of system b  

      Create the vector zp (resolved to system a):
}        Cab1 rb *, B* those cols clone +, ra - makes zp
{
      Viewing these vectors in system a:
         zp bend this 1st catch swap 2nd catch plot

         ra, zp, Cab1 rb * B* 
         those cows clone + -.2 +d, pile pile bend

         \ plane at z=0:
         this 1 catch that 2 catch plot
         
         \ plane at z=12:
         this 4 catch that 5 catch plot
         
         \ plane at z=11.8:
         this 7 catch that 8 catch plot

      Use zp to create an array of rotational transformation matrices 
      that define attitude of the pen, and then vectors of rotational 
      rates that, when solved, will reproduce pen attitude at each time
      step. 

      First, an additional vector xp, contained in the +x+z plane of 
      pen axes, is needed (for roll motion) to accompany zp into word 
      dircos: 
}        x0 zp cows clone (this makes xp always point along paper X)  

\     Create a block of direction cosine matrices, then run word tilts 
\     to obtain a series of rate vectors for unit time steps between 
\     each 3x3 matrix:
         (xp) zp dircos (hC), chain 9 fold into C, C tilts (hTheta)

\     Now divide Theta by actual steps to make rate vectors Omega that 
\     define pen body rates over the time the curve is being drawn:
         (hTheta) tsamp delta bend, those cows 2 swap items catch, 
         3 repeat /by, 3 1 null (IC) back park into Omega

{     Testing the integration of Omega by trapC:
         Cap0 Omega tsamp trapC into Cint
\        Displaying +z axis projected onto xy plane: 
\           column 3 of C3x3, or rows 7, 8 of C and Cint:
         C bend 8 catch 
         Cint bend 8 catch park
         C bend 7 catch plot

\     Now refine the steps:
         tsamp 8 refine into t2, Omega tsamp t2 lerp1 into Omega2  
         Cap0 Omega2 t2 trapC, t2 tsamp lerp1 into Cint2
\        Displaying +z axis projected onto xy plane: 
\           column 3 of C3x3, or rows 7, 8 of C and Cint2:
         C bend 8 catch 
         Cint2 bend 8 catch park
         C bend 7 catch plot
} 
\-----------------------------------------------------------------------

\  Acceleration on Gyro's accelerometers:
 
\     To compute Gyro's inertial acceleration, the rate of change of 
\     Omega is required.  Fit a spline to Omega and use its first 
\     derivative:
         Omega tsamp s3coef (hC) tsamp s3eval (x x' x'')
         (x x' x'') drop lop, bend into dOmega

{     Test dOmega by integrating it and comparing with original Omega 

         dOmega tsamp trap, Omega pile tsamp plot

      Looks pretty good: Omega(x), Omega(y), and Omega(z) are 
      overlays.
}
{     Gyro's acceleration is given by (see word acceleration):
         Ag = Ap + ddr + 2*Omega x dr + dOmega x r + Omega x (Omega x r)
      where Ap is the system b (pen) acceleration measured at the curve
            Omega and dOmega are system b angular rate and acceleration
            r is the vector from point p to Gyro
            dr, ddr are change and change rate of vector r (if Gyro 
            moves)
      and all vectors are resolved to system b axes.
   
      Ap is the acceleration as the pen follows the curve, transformed 
      from system a to b:
}        C, ddXY 
         one those cows null pile (ddXYZ) \ a null Z component
         three no empty those cows 1st \ compute Ap = Cab' * ddXYZ:
         DO other I catch, 3 fold bend (Cab'), 
            other I catch star park 
         LOOP lop lop (Ap)

\     Time varying vector from p to Gyro in system b:
         1 is rdot, 2.1 is tstart
         list:             0, tstart,    dup 1 + ;
         list: H theta cos /,    dup, dup rdot + ; park tsamp lerp
         list: 0 d 2 / ; bend those rows repeat back park into r 
          
         r tsamp s3coef (hC) tsamp s3eval (r r' r'') 
         bend into ddr, bend into dr, bend into r

\     Compute the acceleration seen by Gyro's accelerometers:
         (Ap) Omega, dOmega, r, dr, ddr acceleration into Ag

\     Done.  The problem has been defined.

\-----------------------------------------------------------------------
 
\  Save results needed to solve the problem:
      Ag, Omega deg/rad *f, pile bend, 1000 *f integer
      "%8.0f" 6 cats format "gyro.dat" save 
      " File gyro.dat written" nl . nl halt

{     Notes on saved data:

      Format and sample rate of data in file gyro.dat:

         The file of telemetered data is text formatted with six values
         per line.  Each line corresponds to data taken at a step in 
         time.

         The first three values in each line are the translational ac-
         celerations felt by accelerometers rigidly mounted to Gyro in 
         a reference frame where, as he walks down the street, z is 
         straight ahead, y is straight up and x points out his left.  
         These three acceleration values in each line are ordered x:y:z.

         The last three values in each line are the rotational velo-
         cities sensed by gyros rigidly mounted to Gyro in the same 
         body-fixed frame as the accelerometers, so the x gyro senses 
         rotational velocity about his x axis, and so on.  Like the 
         three accelerometer values, they are ordered x:y:z in each 
         line.

         The data rate is 32 samples per second, so the time between 
         each line of data is one thirty-second of a second.

      Units and scaling of data in file gyro.dat:

         Telemetered data range is 15 bits (about 4.5 digits); values 
         are integers with the following scaling and units: 

            accelerations 1000*in/sec/sec (items 1, 2, 3 in each line) 
            angular velocities 1000*deg/sec (items 4, 5, 6 in each line) 
         Figures 1 and 2 show the data after removing the 1000 scale 
         factor, where the each x curve is blue, y is green and z is 
         red.

      Other data from Gyro as he rides the side of the pen (the side 
      away from right handed Doc Mano's view), his body (z) pointed up 
      along the pen toward its end (away from its point:

         At t = 0, his x axis--out his left side--is generally pointing
         down, and the plane of his x and z axes contains a vertical, Z
         gravity vector, and the paper X axis, where Z is up and X is 
         to Doc Mano's right (see Figure 3).

         The tilt of his z axis away from vertical at t = 0 is 36.9 de-
         grees.

         His height directly above Doc Mano's table at t = 0 is 4.0 in.

         He estimates the pen diameter to be about 0.3 in. 

         At t = 2.1 seconds the mission was unexpectedly aborted, and 
         Gyro began running up the pen.  Figure 1 shows spikes in his 
         z accelerometer as he accelerates quickly to a speed of 1 
         in/sec (that's pretty fast for an ant carrying gyros and ac-
         celerometers).

\        Making plots of saved data:
         0.001 is com, 32 (Hz) is rate, "gyro.dat" 6 asciiread (hDat)
         (hDat) 1 those rows uniform, rate /f makes t
         (hDat) dup 1 3 items catch com *f t plot \ acceleration
         (hDat) 4 3 items catch, com *f t plot  \ omega
}
      THEN

\-----------------------------------------------------------------------
 
\  Here is a tops script that solves Gyro's attitude problem.

\     Include additional words in the library:
         "trap" missing IF mmath.v include THEN \ matrix math
         "plot" missing IF plot.v include THEN  \ graphics

\     Reading telemetered angular vel and translational accel:
         1000 is scale, 32 (Hz) is rate, "gyro.dat" filefound
         IF 6 (cols) asciiread (hDat) dup 4 3 items catch 
            rad/deg scale / *f bend into Omega
            (hDat) 1 3 items catch scale /f bend into Ag \ Gyro's accel
            1 rate /, Ag cols uniform makes t \ steps are 1/rate apart
         ELSE " file gyro.dat not found" . nl halt
         THEN

\     Other data sent by Gyro:
         36.9 (deg) rad/deg * is theta \ pen tilt from vertical at t=0
\        Gyro's height above table and offset from pen centerline:
         4.0 (in.) is H, 0.3 2 / is y (in.) 
         2.1 (sec) is t0, 1 (in/sec) is Rdot \ when Gyro runs up pen +z

{     Attitude matrix for Gyro's ref frame xyz (B) wrt the paper XYZ (A)
      at t=0.  Use the laser plumb bob tilt and height to project Gyro's
      tilted xz axes onto inertial XZ, define Y(0) component to be zero:
}        vector: 1 0 0 ; (hX) \ Gyro's x is a vector in XZ plane
         vector: H theta tan *, 0, H ; (hZ) \ project Gyro's z onto XYZ
         (hX hZ) dircos makes Cab \ frame B (Gyro) wrt frame A (paper)

{     History of attitude transformations starting from Cab.  Word trapC
      integrates Poisson's kinematical equations,
                         dCi + Omega x Ci = 0, i=1,3  
      where Ci and dCi are unit vectors and their rates from column i
      of Cab.  Refine by factor of four to gain accuracy in trapC:
}
         t 4 refine makes t1             \ refine t steps 
         Cab, Omega t t1 lerp1, t1 trapC \ refine Omega and integrate
         (hCab) t1 t lerp1 into Cab      \ fetch results at coarser t

{     The inertial velocity of the pen point is
                         Vp = Vg - Omega x R - dR
      where vectors are quoted in the frame of the pen (frame B), and:
         Vg is Gyro's inertial vel (from integrating telemetered Ag)
         Omega is pen angular velocity, same as Gyro's (from telemetry)
         R is vector from the pen point to Gyro (made below)
         dR is rate of change of vector R when Gyro runs (made below)
}
\     Time varying vector R, from pen point to Gyro, and its rate dR, 
\     using telemetered H, Rdot, theta, t0, and y:
         vector:             0, t0 , dup 1.0 +  ; (hT)
         vector: H theta cos /, dup, dup Rdot + ; (hZ) 
         park, (hTZ) t lerp (hRz)
         vector: 0 y ; bend those rows repeat (hRxy) 
         swap (hRxy hRz) park (hR)
\        Fitting 3rd order spline:
         (hR) t s3coef, (hC) t s3eval (R R' R'') 
         drop bend into dR, bend into R

\     Integrate Gyro's accelerometer data to get his inertial velocity,
\     Vg, then compute the velocity of the pen point, Vp, using the 
\     equation above:
         Ag t trap (hVg), Omega R *cross less, dR less, makes Vp

\     Transform pen velocity, Vp, to frame A, then integrate it to 
\     obtain the pen point path in frame A, Xp; display the path:
         3 0 null, Vp cols 1st \ compute Vp(a) = Cab * Vp(b):
         DO Cab I catch, 3 fold (hCab), Vp I catch star park LOOP
         (hVp) t trap (hXp) bend this 2nd catch swap 1st catch plot
         pause plotWCB winfree

\     Done.  The writing is now displayed in an adjacent window.
 
   end end

\-----------------------------------------------------------------------

;  Appendix

Note: these studies were done with express.

\  Look at motion of end:

         Vp, Omega, 
         list: 0 0 5 ; those cols clone (hR), 
         those dims null (dR) velocity
         makes Ve 
         3 no empty Ve cols 1st \ compute Ve(a) = Cab * Ve(b):
         DO Cab I catch, 3 fold (Cab), Ve I catch star park LOOP
         t trap makes Xe

         3 no empty Vp cols 1st \ compute Vp(a) = Cab * Vp(b):
         DO Cab I catch, 3 fold (Cab), Vp I catch star park LOOP
         (Vp) t trap, makes Xp 

    Ag t trap t trap list: 0 1 0 ; list: 0 0 1 ; 
    dircos swap star bend mplot3d

\   Approach 2.  Integrate Vp first, then transform to frame A 
\   and display the result:

         Vp t trap is Xp, 3 no empty Xp cols 1st \ Xp(a) = Cab * Xp(b):
         DO Cab I catch, 3 fold (Cab), Xp I catch star park LOOP
         (Xp) this 2 reach back 1 reach mplot mgrid

\-----------------------------------------------------------------------
{
   Testing integration by trapC, where the +z axis of the pen (pointing
   toward the aft end) follows an upside down image of the curve being 
   drawn at the point (the real problem won't be so easy):

      Planes where trajectories are defined:
         vector: 0 0 10 ; 
         makes B* \ vec between origins: plane a to plane b
         vector: 1 0 0 ; vector: 0 0 1 ; 
         dircos is Cab \ transformation b to a

      Vectors of pen trajectory at (X,Y,0) defined in plane a frame:
         XY, once those cows empty pile into ra

      Create a trajectory in plane b:
         vector: -1 0 0 ; vector: 0 0 1 ; 
         dircos ra * is rb \ ra upside down 

      Copy and drop the following to see the trajectories on planes a 
      and b:
         ra 2 reach, ra 1 reach mplot mgrid
         rb 2 reach, rb 1 reach mplot mgrid

      Create the vector zp:
         Cab rb *, B* those cols clone +, ra - makes zp

      Create rate vector:
         vector: 1 0 0 ; zp cows clone (xp),
         zp dircos, chain 9 fold makes C
         C tilts tsamp delta bend, those cows 2 swap items catch,
         3 repeat /f, 3 1 null swap (IC) park into Omega

      Integrate, starting with axes aligned:
         3 identity, Omega tsamp trapC into Cint

      Display values of last matrix in Cint:

            For 32 Hz sample rate, at last time point:

            [express@bach] ready > Cint these cows catch 3 fold .m
              Row 1:  .99980     1.08998E-02 3.93453E-03
              Row 2: 5.15297E-03  .94420      .33332
              Row 3:-1.93054E-02 -.32919      .94280
             [0] ok!
            [express@bach] ready >.32919      .94280 atan2 deg/rad * .m
              Row 1:  19.247
             [0] ok!

            For 64 Hz sample rate (change 32 above and rerun file),
            at last time point:

            [express@bach] ready > Cint these cows catch 3 fold .m
              Row 1:  .99996     5.60586E-03-1.28457E-02
              Row 2: 7.50339E-03  .94764      .32147
              Row 3: 4.34586E-03 -.31930      .94683
             [0] ok!
            [express@bach] ready >.31930      .94683 atan2 deg/rad * .m
              Row 1:  18.636
             [0] ok!

      Here's the result we're trying to achieve at last time point:

            [express@bach] ready > C these cows catch 3 fold .m
              Row 1:  .99955     0.00000E+00-2.99076E-02
              Row 2: 9.25041E-03  .95096      .30916
              Row 3: 2.84410E-02 -.30930      .95054
             [0] ok!
            [express@bach] ready >.30930      .95054 atan2 deg/rad * .m
              Row 1:  18.025
             [0] ok!
      
      Display unit vector of pen +z projected onto the paper xy axes.  
      Rows
      7 and 8 are elements (1,3) and (2,3) of pen +z (since C is 
      chained into a 9x1 this really makes fetching these components 
      easy):
         Cint 8 reach (Y), Cint 7 (X) reach mplot
}
\-----------------------------------------------------------------------
\  Here are the 100 lines of input file gyro.dat:
     111    -370      35       0       0       0
      33     -90      25      44      12       0
      13     -21      22      24       6       0
      18     -39      23       4       0       0
       8     -10      15     -15      -4       0
     -32      94     -22     -29      -8       0
     -68     179     -59     -23      -6       0
    -101     255     -96       3       1       0
     -50     112     -62      50      15       0
     113    -302      89      76      23       0
     255    -644     239      21       7       0
     387    -952     387    -116     -33       0
      52     -41     130    -324     -94       0
    -529    1397    -436    -393    -114       0
   -1044    2632    -994    -141     -40       0
   -1568    3805   -1552     437     128       0
   -1962    1571   -2032    1286     390       0
   -2344    -775   -2523    1875     731       0
   -2739   -2876   -3016    1926    1142       2
   -3129   -4971   -3505    1433    1622       4
   -2033   -3345   -2625     480    2137       7
   -1130   -2445   -1594    -437    2532       8
    -245   -1603    -559   -1165    2760       8
     644    -847     480   -1702    2820       6
    1525    -816    1513   -2085    2716       3
    2415    -582    2544   -2420    2448       0
    3282    -356    3579   -2725    2019      -2
    3561     -28    4091   -3001    1430      -4
    2666     373    3340   -3217     779      -3
    2072     605    2595   -3284     243      -1
    1449     831    1853   -3184    -157       1
    1066     870    1319   -2919    -425       4
     868     777    1010   -2521    -590       6
     620     738     699   -2028    -685       8
     396     675     389   -1439    -713       9
     687     268     542    -761    -677       9
    1113    -208     926     -50    -643       9
    1466    -424    1299     633    -654       9
    1775    -384    1660    1176    -729       9
     905     292     957    1558    -851      11
      84     893      68    1868    -893      10
    -703    1474    -819    2141    -805       8
   -1449    2067   -1665    2377    -587       5
    -778    2846   -1200    2584    -275       2
    -390    3576    -736    2786     -11       0
      -3    4301    -274    2988     172       0
     173    4463      22    3212     276       0
    -277    3315    -300    3483     323       0
    -601    2488    -631    3658     385       0
    -932    1573    -954    3713     471       1
   -1083    -508   -1112    3644     581       2
   -1029   -3841   -1035    3227     691       4
   -1029   -6787    -960    2172     769       5
   -1014   -9605    -893     461     812       6
    -883   -7895    -762   -1857     819       6
    -702   -4506    -524   -4026     772       4
    -542   -1762    -249   -5471     658       2
    -392    1076      53   -6189     481       0
    -511    1326     111   -6226     248       0
    -645    1619      67   -5972      -7       0
    -768    2073      15   -5615    -270       2
    -897    2472      -6   -5157    -540       6
   -1219     715    -376   -4660    -812      12
   -1518    -556    -450   -4408   -1068      18
   -1657   -1850   -1816   -4480   -1289      25
   -1533   -2797    1663   -4844   -1395      31
    -986   -1543  -12172   -5361   -1376      34
    -555    -812   40534   -5689   -1274      35
    -124     -15   -1370   -5772   -1097      34
      78     281    -341   -5612    -842      29
    -153      23   -1120   -5278    -468      17
    -281     -67   -1563   -4881      90      -3
    -359    -146   -2100   -4433     838     -35
     287    1052   -1658   -3938    1747     -78
    1248    3077    -271   -3285    2559    -120
    1983    4863    1136   -2313    3098    -150
    2721    6540    2552   -1016    3361    -166
    2579    4770    2855     554    3360    -166
    2279    2714    2616    1847    3199    -156
    2040    1053    2371    2526    2942    -140
    1778    -606    2140    2588    2590    -120
    1214     387    1854    2097    2151     -96
     776     711    1593    1437    1664     -73
     478     679    1340     848    1190     -51
     237     626    1122     372     748     -32
     585     531    1487       7     319     -13
     796     439    1849    -250    -157       6
     993     338    2209    -403    -698      30
     873     172    2278    -450   -1301      56
     -47    -135    1458    -406   -1915      83
    -757    -400     639    -295   -2433     106
   -1486    -631    -178    -124   -2844     125
   -1764    -779    -554      86   -3161     139
   -1599    -903    -349     332   -3454     151
   -1576   -1041    -146     620   -3803     166
   -1541   -1180      54     950   -4216     182
   -1651   -1330     126    1321   -4691     200
   -1809   -1483     118    1733   -5214     217
   -1956   -1639     107    2185   -5772     235
   -2116   -1798      92    2676   -6369     250
\-----------------------------------------------------------------------
