\ {{{1 GNU General Public License
{
Program Tops - a stack-based computing environment
Copyright (C) 1999-2010  Dale R. Williamson

Author: Dale R. Williamson <dale.williamson@prodigy.net>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
1}}}
}
{ File net.v  June 2003

   Copyright (c) 2003   D. R. Williamson

   Words for networking.

   This file works with compiled words from net.c.  File net.c is
   compiled with the -DNET switch in the program Makefile.

   Other network related files of high level words: 
      clu.v Processing on a cluster
      term.v Interactive terminal 

\-----------------------------------------------------------------------

   References:

      1. Stevens, W. R., "UNIX Network Programming Volume 1, Networking
         APIs: Sockets and XTI," second edition, Prentice Hall, 1998.

      2. Stevens, W. R., "UNIX Network Programming Volume 2, Inter-
         process Communications," second edition, Prentice Hall, 1999.

      3. Unix Socket FAQ: http://www.developerweb.net/forum
         Search on Maholski for comments on how to check for readable
         socket, and to determine how many bytes are waiting to be read.

      4. GNU Wget software package for retrieving files:
            http://www.gnu.org/software/wget/

      5. Port assignments:
         http://www.iana.org/numbers.html
         ftp://ftp.iana.org/assignments/port-numbers
         Author's machine: see file iana-port-numbers.txt
         Notes:
            The port numbers are divided into three ranges:
               the Well Known Ports, 0 through 1023
               the Registered Ports, 1024 through 49151
               the Dynamic and/or Private Ports, 49152 through 65535

            The Well Known Ports--0 through 1023-- are assigned by the
            IANA and on most systems can only be used by system (or
            root) processes or by programs executed by privileged users.

      6. Greenwich Mean Time (word NISTdelta):
         http://www.nist.gov/
         ftp://time-a.nist.gov/pub/daytime/
         http://physics.nist.gov/GenInt/Time/world.html
         http://tf.nist.gov/service/acts.htm (shows time code)
         http://tf.nist.gov/service/time-servers.html (server IP addr)

      7. HTTP Explanations:
         http://www.w3.org/Protocols/rfc2616/rfc2616-sec3.html
         http://www.jmarshall.com/easy/http/

------------------------------------------------------------------------

   Contents:

   Use this phrase to obtain the following list of contents:
      syspath "net.v" + asciiload this " inline:" grepr reach dot

   inline: +CLIENT_ALLOW (qS --- ) \ add S to CLIENT_ALLOW.clients
   inline: +SERVER_ALLOW (qS --- ) \ add S to SERVER_ALLOW.clients
   inline: ACK ( --- ) \ send acknowledgement to remotefd
   inline: ALLOW (qIP --- ) \ add IP address to allowed-client tables
   inline: BRIDGE (qCNAME --- ) \ connect remote machines
   inline: CLIENT (qIPaddr nPort --- nSocket) \ connect to this prog
   inline: CLIENT_ALLOW (qIP --- f) \ flag f true if IP can connect
   inline: CLIENT_F (qIPaddr nPort --- nSocket) \ connect to this prog
   inline: CONNECT_HOST (qHost nPort ptrRun --- nS) \ connect to Host
   inline: CONNECTIONS ( --- ) \ library of connections
   inline: CROSSLINK (nSocket1 nSocket2 qS --- ) \ link two machines
   inline: def_port ( --- nPort) \ default port number
   inline: def_server ( --- ) \ start server listening on default port
   inline: def_server1 ( --- ) \ start server listening on def port+1
   inline: fremoteget (qFile qFile_to nSocket --- f) \ File from Socket
   inline: fremoteput (qFile qFile_to nSocket --- f) \ File to Socket
   inline: IPhost (qHost --- qIP) \ the IP address for Host
   inline: IPhostr (qS --- qIP) \ randomly fetch IP from multihomed list
   inline: HTTPget (qHost hPathFile --- ... hT) \ files from Host
   inline: HTTPgetr (qHost qRequest --- hT) \ receive request from Host
   inline: HTTPput (qT nS --- ) \ service request T and put in S
   inline: IPloop ( --- qS) \ loopback IP address
   inline: localsockets ( --- hR) \ local clients connected to remote
   inline: MAXBLOCK ( --- sec) \ time to block a pending socket read
   inline: monkeyIP ( --- qIP) \ query ipmonkey.com for this IP addr
   inline: net_file_time (qDir --- nsec) \ file time latency on network
   inline: new_conn (nS --- ) \ runs when S has just connected
   inline: NIST_DELTA ( --- ) \ sync program time with NIST time
   inline: NIST_SYNC ( --- ) \ sync program time with NIST time
   inline: NISTdelta ( --- sec) \ NIST time minus the machine's time
   inline: PING (qIP --- f) \ f true if Unix ping returns 0% loss for IP
   inline: port_on (nPort --- f) \ f is true if Port is being used
   inline: port_listening (Port --- f) \ f is true if listening on Port
   inline: remoteack (hSockets --- f) \ remotes acknowledge
   inline: remoteclients (nSocket --- hT) \ run word clients on remote
   inline: REMOTEdelta (nSocket --- sec) \ time remote minus time local
   inline: remotehost (nSocket --- qS) \ name of host at end of Socket
   inline: remotekeys (hT nSocket --- ) \ run the keyboard at Socket
   inline: remoteputf1 (qT nS1 nS2 --- ) \ send T to S1, echoes to S2
   inline: remoteputmat1 \ (hA nSocket --- ); stack on remote: ( --- hA)
   inline: remoteprompt (nSocket --- ) \ run at a prompt on Socket
   inline: remoteprompt_run (qS --- ) \ phrase to run text at remote
   inline: remoteprompt_stk ( --- ) \ phrase to run remote stk display
   inline: remotercv (nS nSec nBytes --- qT) \ receive Bytes in Sec on S
   inline: remoterun1 (hT hSockets --- ...) \ run T on all Sockets
   inline: remotesockets ( --- hR) \ remotes connected to local
   inline: remotestack (nSocket --- hT) \ get stack display at Socket
   inline: remotetasks (nSocket --- hT) \ multitasker tasks at Socket
   inline: remotewhos (nSocket --- hT) \ run word whos on remote
   inline: SERVER-CYCLE ( --- ) \ close and open listening port
   inline: SERVE_F (hT nSocket --- ) \ process a foreign SERVER request
   inline: SERVE_F_TERM ( --- ) \ initialize SERVE_F as TERM type
   inline: SERVER_ALLOW (qIP --- f) \ flag f true if IP can connect
   inline: serverport ( --- nPort) \ port of local server listening
   inline: servershutdown ( --- ) \ close clients, shut down server
   inline: serverstart (nPort --- f) \ turn server on, listening on Port
   inline: SERVER_WAIT (nSec --- ) \ ignore new connections for Sec
   inline: SHSERVER (nSec --- nPort) \ shell server for Sec on Port
   inline: SNDSERVER ( --- nPORT) \ port of the sound file server
   inline: SNDSERVER_ON ( -- f) \ true if sound file server is listening
   inline: SNDSERVER_RATE (nHz --- ) \ set rate of sound file queuing
   inline: socket_ack (nSocket --- f) \ this program remote acknowledge
   inline: socket_ack1 (nSocket --- f) \ this program remote acknowledge
   inline: socket_check (nS --- ) \ display a check of socket S
   inline: socket_scan (n --- hA) \ scan of the first n sockets
   inline: sockets ( --- hR) \ all connected sockets
   inline: TASK_PORT (nWAIT qJ --- hA) \ perform task J, return item A
   inline: TIME_SYNC ( --- ) \ this machine in synch with remote
   inline: time_sync (nS --- f) \ this machine in synch with remote
   inline: wrapHTML (hT --- qT1) \ T wrapped with HTML
   inline: www_open ( --- f) \ f true if connected to the Internet

   Remote word substitutions.
   inline: remote_exit ( --- ) " use Esc-q to exit" . nl ;
   inline: remote_invalid ( --- ) " invalid word on remote" . nl halt ;

   Appendix.
   What an HTTP server receives from Netscape, Wget, and MS IE.
   HTTPget vs. WGET timing test, July 2004 (dial up).
   HTTPget vs. WGET timing test, April 2008 (DSL).
}
   "CONNECT" missing IF " Networking words required" . halt THEN
   "msgPeek" missing IF "dog.v" source THEN

\-----------------------------------------------------------------------

   inline: +CLIENT_ALLOW (qS --- ) \ add S to CLIENT_ALLOW.clients
{     Sun Mar  7 16:07:53 PST 2010
      Tables are updated only for the current session.

      Incoming S can be a VOL of IPs, one per row.  Each row can 
      have a second identifier string following the IP address.

      Example:
         "192.168.0.100 diego" (qS1)
         "192.168.0.101 kaffia" (qS1 qS2) pile (hT) +CLIENT_ALLOW
         "CLIENT_ALLOW" "clients" yank .
}
      0 STR stkok 1 VOL stkok or not
      IF "+CLIENT_ALLOW" stknot return THEN

      "CLIENT_ALLOW" "clients" yank any? IF swap pile THEN neat 
      "CLIENT_ALLOW" "clients" bank 
   end

   inline: +SERVER_ALLOW (qS --- ) \ add S to SERVER_ALLOW.clients
{     Sun Mar  7 16:07:53 PST 2010
      Tables are updated only for the current session.

      Incoming S can be a VOL of IPs, one per row.  Each row can 
      have a second identifier string following the IP address.

      Example:
         "192.168.0.100 diego" (qS1)
         "192.168.0.101 kaffia" (qS1 qS2) pile (hT) +SERVER_ALLOW
         "SERVER_ALLOW" "clients" yank .
}
      (qS) 0 STR stkok (qS f1) 1 VOL stkok (f1 f2) or not
      IF "+SERVER_ALLOW" stknot return THEN

      "SERVER_ALLOW" "clients" yank any? IF swap pile THEN neat 
      "SERVER_ALLOW" "clients" bank
   end

   inline: ACK ( --- ) \ send acknowledgement to remotefd
      yes remotefd remoteput ;

   inline: ALLOW (qIP --- ) \ add IP address to allowed-client tables
{     Tables are updated only for the current session.

      Incoming IP can be a space delimited list of IPs all in one 
      string.

      Example: IP can be a quoted list (string) of IP addresses:
         "192.168.1.254   192.168.1.249" ALLOW
         "SERVER_ALLOW" "clients" yank .
}
      0 STR stkok not IF "ALLOW" stknot return THEN \ must be STR

      (qS) words " ALLOW" tail (hT)
      (hT) dup +CLIENT_ALLOW +SERVER_ALLOW
   end

   inline: BRIDGE (qCNAME --- ) \ connect remote machines
{     Connect the first two machines that are remotely connected to
      this machine.  The sockets for the connection will be named
      CNAME on each of the remote machines.

      For an application of word BRIDGE, see word BRIDGING in file
      usr/uboot.v.
}
      "CNAME" book
      remotesockets these rows one >
      IF this 1st pry swap 2nd pry CNAME CROSSLINK
      ELSE drop " BRIDGE: need two remote connections" ersys
      THEN
   end

   inline: CLIENT (qIPaddr nPort --- nSocket) \ connect to this prog
{     Connect to another instance of this program running a SERVER on
      Port at IPaddr.

      SERVER determines the connection type on its end (LOSERV or 
      FOREIGN) by the first bytes received after connection (drainf(), 
      file net.c).

      SERVER expects the string LOGIN if CLIENT is also this program
      and type is to be LOSERV.

      When string received is LOGIN, SERVER sends it back as acknowl-
      edgment.  This word blocks for the expected read, then drops the 
      returned string.  The acknowledgment is important for stabilizing
      the connection before other transfers are attempted.
}
      [ "LOGIN " getlogin spaced host + + "LOGIN" book
        -1 "Sclosed" book
      ]
      (nPort) dup 0< 
      IF 2drop Sclosed return THEN \ require nonnegative nPort

      (qIPaddr nPort) -1 CONNECT (nSocket) this any
      IF "S" book
         depth push
         LOGIN S remoteputf \ will enter drainf on remote to match LOGIN
         S MAXBLOCK BLOCK (qLOGIN)
         depth pull less (n) 0>
         IF (hT)
          \ Update the LOGIN entry in the table displayed by word 
          \ clients using T just returned from server:
            (hT) S clientLOGIN_set

            S cop \ return a copy

         ELSE S sclose Sclosed 
         THEN
      THEN (nSocket) 
   end

   inline: CLIENT_ALLOW (qIP --- f) \ flag f true if IP can connect
{     Table "clients" in this local library contains the list of IP 
      addresses that can connect when the program's server is running.

      Given a prospective IP address, this word returns f true if it
      matches an entry in clients table.

      Only the first word in each line of the clients table is used
      to match against IP, so any arbitrary text can follow the first 
      word.

      If clients table is empty, as it is at start up, then f returned 
      is always true.

      When word SERVER or DSERVER is run with the incoming stack item
      IPaddr containing one or more IP addresses (rather than "" or 
      "*" denoting wildcard), that stack item is banked here as the 
      clients table.  

      If started with a wildcard, SERVER or DSERVER do nothing to the
      clients table here.

      See man CLIENT_ALLOW for ways to view and add to clients table.
}
      [ VOL tpurged "clients" book 
        no "APP_CLIENT_ALLOW" book
      ]
      APP_CLIENT_ALLOW 0<>
      IF (qIP) APP_CLIENT_ALLOW exe 
      ELSE \ default behavior:
         clients chars any
         IF clients 1st word drop swap (hT qIP) grepe (hA) rows any (f)
         ELSE (qIP) drop yes
         THEN
      THEN
   end

   inline: CLIENT_F (qIPaddr nPort --- nSocket) \ connect to this prog
{     Connect as a foreign client to another instance of this program
      running a SERVER on Port at IPaddr.

      The flag in this library called set_CONN is initially set to 0,
      meaning bytes from SERVER will go to the stack.  The ptr to a
      word to service bytes from SERVER can be banked here instead,
      before running CLIENT_F, as in:

         "myCLIENT" ptr "CLIENT_F" "set_CONN" bank

      For more about the ptr for set_CONN, see notes about ptrRun in
      man CONNECT.

      SERVER determines its connection type (LOSERV or FOREIGN) on the 
      first bytes received after connection (drainf(), file net.c).

      This connection will be type FOREIGN, and SERVER will close the 
      connection in NEW_CLIENT_TIMEOUT seconds if nothing is received.

      Word new_client_timeout can be used to modify the value of
      NEW_CLIENT_TIMEOUT.
}
      [ 0 "set_CONN" book \ bytes from SERVER will go to stack
        -1 "Sclosed" book
      ]
      (qIPaddr nPort) set_CONN CONNECT (nSocket) this 0<
      IF drop Sclosed THEN (nSocket)
   end

   inline: CONNECT_HOST (qHost nPort ptrRun --- nS) \ connect to Host
{     Resolve multi-homed Host to its IP addresses, then try making a
      connection to each until one succeeds.

      Incoming number ptrRun is the ptr to a catalog word that will be 
      run whenever bytes from the remote server are received in socket 
      S and the remote server is not this program running SERVER.

      Returns a valid socket number S if successful.

      Returns socket S equal to -1 if Host name resolution fails or if
      all connection attempts fail.

      The IP address of the connection (or the last attempt) is booked
      here as IP.

      This shows trying to connect to a nonexistent listening port.
      It show 4 seconds between tries in CONNECT (the connect_timeo
      closings) which is controlled by "sec" below, and a 3 second 
      idle by due to "WAIT" before trying again, so the third attempt
      starts 4+3 seconds after the second. 

         Mon Jun 9 05:06:56 PDT 2008
         [dale@plunger] /home/dale > tops
                  Tops 3.0.1
         Mon Jun  9 05:06:59 PDT 2008
         [tops@plunger] ready > IPloop 9871 0 CONNECT_HOST
          connect_timeo: errno 111  Mon Jun  9 05:07:03 PDT 2008
          connect_timeo: closing socket 3
          connect_timeo: errno 111  Mon Jun  9 05:07:07 PDT 2008
          connect_timeo: closing socket 3
          CONNECT: could not connect to 127.0.0.1:9871 in 2 attempts
          CONNECT_HOST: idling for 3 seconds before trying again
          connect_timeo: errno 111  Mon Jun  9 05:07:14 PDT 2008
          connect_timeo: closing socket 3
          connect_timeo: errno 111  Mon Jun  9 05:07:18 PDT 2008
          connect_timeo: closing socket 3
          CONNECT: could not connect to 127.0.0.1:9871 in 2 attempts

          stack elements:
                0 number: -1
          [1] ok!
         [tops@plunger] ready > 

      File /usr/include/asm/errno.h shows errno 111: 
         #define ECONNREFUSED    111     /* Connection refused */
}
      [ 4 "sec" book, 2 "TRIES" book, 3 "WAIT" book ]

      "ptrRun" book "nPort" book "Host" book
      "" "IP" book

      Host IPhost (hIPaddr) any?

      IF "IPlist" book CONNTO "SEC" book \ save current time out, SEC
         sec connto                      \ set time-out to sec

         true (nS)
         TRIES TIMES \ also tries twice in CONNECT, so total = 2*TRIES
         DO IPlist rows 1st \ loop over IP addresses:
            DO drop IPlist I quote chop (qIPaddr) this "IP" book

               (qIPaddr) nPort ptrRun CONNECT (nS)

               (nS) this any IF EXIT THEN
            LOOP
            (nS) this any IF EXIT THEN

            I qdx TRIES < 
            IF " CONNECT_HOST: idling for " WAIT intstr + 
               " seconds before trying again" + . nl
               WAIT idle \ delay between tries
            THEN
         LOOP

         SEC connto \ put time-out back to SEC
      ELSE true (-1)
      THEN (nS)
   end

   inline: CONNECTIONS ( --- ) \ library of connections
\  WORK IN PROGRESS.  A LIBRARY FOR CONNECTIONS.
{     Within C code, items from this library can be placed on the stack
      as follows:

         double *client;
         char *clientIP;

         extract1("CONNECTIONS","client"); /* sockets numbers to stk */
         client=tos->mat; /* address of client socket numbers */
         drop(); /* client is cat item, so drop will not deallocate */

         extract1("CONNECTIONS","clientIP"); /* clientIP to stk */
         clientIP=tos->tex; /* address of IP text */
         drop();
}
      [ 0 1 null "client" book \ descriptor (socket number)
        0 1 null "clport" book \ port
        0 1 null "contyp" book \ connection type
        0 1 null "cliptr" book \ ptr to run when receive in drainf()
        0 1 null "clitim" book \ time of connection
        0 1 blockofblanks "clientIP" book \ IP address
      ] 
   end

   inline: CROSSLINK (nSocket1 nSocket2 qS --- ) \ link two machines
{     Start the machine at Socket1 listening on its nextport and
      have the machine at Socket2 connect to it; then close the
      listening port at Socket1.
}
      "SOCKET_NAME" book
      "S2" book "S1" book

    \ Start a server on S1, or use the one already ON:
      "serverport remotefd remoteput" S1 remoterun1 (nPort) any?
      IF (nPort) yes
      ELSE "def_port tic nextport '*' that SERVER remotefd remoteput"
         S1 remoterun1 (nPort) no
      THEN
      (nP1port f) "ON" book "P1port" book \ listening at S1

    \ Connect the machine at S2 to SERVER at S1:
      clientIPs S1 clientindex quote (qIP)
      (qIP) quoted spaced P1port intstr + " CLIENT" +
      (qIP nP1port CLIENT) S2 remoterun

    \ The socket number connecting to S1 is on the stack of S2.  Have
    \ S2 give it SOCKET_NAME and book it into its main library:
      SOCKET_NAME quoted " book" + (qSOCKET) S2 remoterun

    \ Have S2 make S1 put the socket number of their connection on its
    \ stack:
      "'remotefd dup remoteput' "
      SOCKET_NAME +
      " remoterun1 (nPORT) remotefd remoteput" +
      S2 remoterun1 (nPORT) drop

    \ Now the socket number connecting to S2 is on the stack of S1.
    \ Have S1 give it SOCKET_NAME and book it into its main library:
      SOCKET_NAME quoted " book" + (qSOCKET) S1 remoterun

    \ Close server on S1 if it was not already on:
      ON not IF "serverclose" S1 remoterun THEN
   end

   inline: def_port ( --- nPort) \ default port number
      [ 9877 is PORT ] PORT ;

   inline: def_server ( --- ) \ start server listening on default port
\     If the server cannot be started, the default port is probably
\     being used by another program.
      def_port serverstart not
      IF " def_server: could not start default server" ersys THEN
   end

   inline: def_server1 ( --- ) \ start server listening on def port+1
\     If the server cannot be started, default port+1 is probably
\     being used by another program.
      def_port 1+ serverstart not
      IF " def_server1: could not start default server1" ersys THEN
   end

   inline: fremoteget (qFile qFile_to nSocket --- f) \ File from Socket
\     Fetch File from the remote tops machine connected on Socket and
\     copy to File_to on this machine.

      [ 
\     These phrases make the remote fetch its local file, put it on its
\     stack, and then send it to the stack here:
        {" ( --- )
         no "F" book
         "FILENAME" (qFile) filefound 
         IF (qFile) old binary "F" file 
            F this file.size pry (nbytes) fget (hT) 
            F fclose no "F" book
         ELSE "" \ empty T if file not found
         THEN remotefd (hT nS) remoteput \ send T to requestor
        "} chop textput "file_get" book

        no "F" book
        600 "SEC" book
      ]
      " fremoteget: begin " date + . nl \ entry for log file

      "remoterun1" "SEC" yank push
      SEC "remoterun1" "SEC" bank

      time "t0" book

    \ An old file must be deleted, because fput simply writes bytes to
    \ a file if it already exists:
      swap (qFile_to) dup deleteif push

      file_get (hT) "FILENAME" 3 roll strp (hT) swap

      (hT nSocket) remoterun1 (hT) any?

      IF (hT) F filetrue IF F fclose THEN
         peek (qFile_to) forn binary "F" file F rows any
         IF peek (qFile_to) fallow (f) \ check file permission
            IF (hT) dup sizeof push 

               (hT) F fput F fclose no "F" book

               time t0 - 
               " fremoteget: " peek intstr + " bytes at " +
               pull rot / rounded intstr + " bytes/sec" + . nl

               -1 (f)
            ELSE (hT) drop
               " fremoteget: write permission denied for " peek +
               . nl 0 (f)
            THEN
         ELSE " fremoteget: file handle error for " peek + . nl 0 (f) 
         THEN
      ELSE " fremoteget: file not found" . nl 0 (f) \ empty T
      THEN 
      pull (qFile_to) drop 
      pull (SEC) "remoterun1" "SEC" bank
      (f)
      " fremoteget: end " date + . nl
   end

   inline: fremoteput (qFile qFile_to nSocket --- f) \ File to Socket
{     Copy File from this machine to File_to on the remote tops machine
      that is connected on Socket.  This word uses fremoteget to trans-
      fer the file from the stack here to the remote stack, where it is
      then written to a file.
}     
      [     
    \ These phrases make the remote run its word fremoteget (just like
    \ the one above) and then send the success flag back to here:
        {" ( --- f) 
          "FROM" "TO" remotefd fremoteget (f) dup \ NUM success flag

        \ Message to local log:
          IF " fremoteget: success; sending true" 
          ELSE " fremoteget: failed; sending fail" 
          THEN " flag to socket " remotefd intstr + + . nl 

          (f) remotefd remoteput \ send success flag to remotefd
        "} chop textput "file_put" book
      ]
      depth three less "d0" book \ depth below incoming 3 stack items

      two roll (qFile) filefound (f)
      IF (qFileName)
         time "t0" book 

         "remoterun1" "SEC" yank push
         "fremoteget" "SEC" yank "remoterun1" "SEC" bank

         (qFilename) dup filesize push

         rev (qFile qFile_to nSocket) push push push 

       \ Replace the placeholder names in the text of file_put:
         file_put (hT)
         "FROM"  pull (qFile) strp (hT) 
         "TO" pull (qFile_to) strp (hT)

       \ Run T on the remote, which blocks until T returns f:
         pull (hT nSocket) remoterun1 (f) 

       \ Integrity checks on stack and f from running T on remote:
         depth 0= 
         IF fail (f)
         ELSE depth push
            (f) dup type NUM =   \ per file_put(), expect a NUM flag
            pull d0 1+ = and not \ and depth with (f) should be d0+1
            IF fail THEN         \ fail flag on stack if error
         THEN (f)

         time t0 - 
         " fremoteput: " peek intstr + " bytes at " +
         pull rot / rounded intstr + " bytes/sec" + . nl

         pull (SEC) "remoterun1" "SEC" bank

      ELSE " fremoteput: file not found" . nl 2drop false (f)
      THEN (f)
   end
   
   inline: IPhost (qHost --- qIP) \ the IP address for Host
\     High level driver for _IPhost in net.c.

      -path \ remove leftmost items like http://
      this "." chblank chpack numerate any?
      IF drop (qIP) \ nothing to do if already IP form
      ELSE
         dup host = \ does this machine host name match Host?
         IF drop IPloop \ use loopback addr for simulated cluster demo
                        \ and security on UMLs
         ELSE (qHost) "HOST" book
            HOST _IPhost noq_alike any? not
            IF "" THEN \ return empty string if not found
         THEN
      THEN
   end

   inline: IPhostr (qS --- qIP) \ randomly fetch IP from multihomed list
      IPhost these rows 1 = IF return THEN
      1st those rows dup 1 ranint 1st pry reach (qIP)
   end

   inline: HTTPget (qHost hPathFile --- ... hT) \ files from Host
{     Get the files listed in PathFile from HTTP (Hypertext Transfer
      Protocol) web server Host.

      Each file name in Pathfile is a separate substring or line.

      Each file will be a returned as a one-line volume T on the stack.
      Returned T is an empty string if there was an error.

      HTTP web servers usually listen on port 80, which is the default
      that this word assumes.  To connect to a server listening on a 
      different port, like port 9877, use a phrase like this beforehand:
         9877 "HTTPget" "PORT" bank
}
      [ 120 "TIMEOUT" book \ seconds to BLOCK for HTTP bytes each file
        TIMEOUT "timeout" book

\       To change timeout, say to 20, run this before HTTPget:

\          20 "HTTPget" "timeout" bank

\       After HTTPget runs, timeout is always set back to TIMEOUT.
\       Never change TIMEOUT.

        yes "CREDENTIALS" book

\       Various user-agents (the Appendix shows what some clients send
\       to HTTP servers):
         \ This program:
           progname "/" version + + "progUA" book 

         \ Wget:
           "Wget/1.7" "wgetUA" book  

         \ Netscape:
           "Mozilla/4.78 [en] (X11; U; Linux 2.4.7-10 i686)"
           "netscapeUA" book  

         \ MSIE
           "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; "
           "SV1; .NET CLR 1.1.4322)" +
           "msieUA" book

         \ Google:
           "Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US) " 
           "AppleWebKit/532.0 (KHTML, like Gecko) " + 
           "Chrome/3.0.195.32 Safari/532.0" + 
           "googleUA" book

        progUA "UA" book \ initial user-agent is this program

\       To change user-agent:
\          "my_user-agent_quote" "HTTPget" "UA" bank
\       or
\          "HTTPget" "googleUA" yank "HTTPget" "UA" bank

{       Examples.

        Fetching files from IWIN (Interactive Weather Information
        Network [2008: IWIN no longer works; www.weather.gov does]):

           Weather in California:
           \ This old address does not work:
             "iwin.nws.noaa.gov" "/iwin/ca/state.html" HTTPget

           \ This new address works:
             "http://www.weather.gov" 
             "/view/prodsByState.php?state=ca&prodtype=state"
             HTTPget

           Using Wget for weather in California (run this at the Unix
           prompt); Wget is smart enough to follow this old address:

             wget iwin.nws.noaa.gov/iwin/ca/state.html

           to the new one using when it sees:
              HTTP request sent, ... 301 Moved Permanently

           National weather (warning: this file has over 7 Mb):
              "http://www.weather.gov"
              "/view/national.php?prodtype=nationalsummary"
              HTTPget

        Also see "HTTPget vs. WGET timing test" in this file.
}
        "<html" "BEGINhttp" book
        "</htm" "ENDhttp"   book

        80 "PORT" book

        " " "FILES" book \ list of files to get
        " " "Host" book  \ connecting to host
{
        Some sites balk at an IP address, instead of site name, ap-
        pearing in the credentials.  Host_alias is a site name, bank-
        ed into into this library before calling this word, that will 
        be used in the credentials even though incoming Host is an IP 
        address string.

        Why use Host_alias?  For a multihomed host, it may be pref-
        erable to go to a specific IP address chosen ahead of time
        from its list of IP addresses, but the host returns an error 
        if that IP address is in the credentials--it wants to see its
        site name (and presumably choose the IP address itself).

        Host_alias allows HTTPget to connect to the desired IP ad-
        dress while sending the site name in the credentials.

        Example: A snippet for SITE, forcing the use of the Nth host:

          \ Put site name into HTTPget.Host_alias and it will go into
          \ the credentials, then use specified index N for the IP:
            SITE (qSite) dup (qSite) "HTTPget" "Host_alias" bank
            (qSite) IPhost (hList)             \ list of host IPs
            (hList) dup rows ndx N min (N)     \ N within bounds
            (hList N) quote (qIP)              \ Nth host IP from List
            (qIP) "/path/" FILE + HTTPget (hT) \ get FILE

         // Here is the example written in infix instead of postfix:
            HTTPget.Host_alias = SITE;
            List = IPhost(SITE);
            IP = quote(List, min(ndx(rows(List)), N)); // N is an index
            T = HTTPget(IP, "/path/"+FILE));

        Host_alias is used only if it is not an empty string (""), 
        and it is set back to an empty string after each use:  
}       "" "Host_alias" book \ site name in credentials to host

        " " "FILE" book  \ current file getting
        no "CHARS" book  \ count of characters received
        no "CLOSED" book \ flag, set to yes when done
        no "VOLS" book   \ count of received volumes on stack
        no "t0" book     \ initial time
      ]
      "HTTPget" ERRset
      -1 "S" book

      (hPathFile) "FILES" book
      (qHost) "HOST" book

      HOST -path "Host" book
      " HTTPget: host " . Host . nl

      FILES rows 1st
      DO S socket_open not
         IF HOST PORT ptr_receive CONNECT_HOST "S" book THEN
         S -1 >
         IF " HTTPget: connected to " . "CONNECT_HOST" "IP" yank 
            " on socket " + S intstr + . nl

            FILES I quote strchop any? not IF "/" THEN "FILE" book
            " HTTPget: " . FILE COLS out - .out nl

            no "CHARS" book  \ count of characters received
            no "CLOSED" book \ flag, set to yes when done
            no "VOLS" book   \ count of received volumes on stack

          \ Start request to server.  The program does not handle
          \ chunked encoding, so request HTTP/1.0 (see Reference 7):

            "GET " FILE " HTTP/1.0" + + (qT)
            CRLF + (qT) 

          \ Additional info sent if CREDENTIALS is yes:
            CREDENTIALS (f)
            IF "User-Agent: " UA + CRLF + +

               "Host: " (qS) Host_alias (qAlias) any? 
               IF 
                \ Use alias just banked to lib, removing path if any:
                  (qAlias) -path \ in case path http:// still there
               ELSE Host (qHost) \ use incoming string
               THEN 
               (qS qHost) + CRLF + +

               "Accept: */*" CRLF + +
              
               UA googleUA =
               IF "Connection: keep-alive"
               ELSE "Connection: Keep-Alive"
               THEN CRLF + +

            THEN
            CRLF +       \ end request to server
            S remoteputf \ send request to server

            yes HOLD        \ word receive will say no HOLD when done
            S timeout BLOCK \ until time out or receive says no HOLD

          \ Send closeout to word receive if BLOCK timed out:
            CLOSED not IF ENDhttp (qS) S receive THEN

            S socket_open not
            IF " HTTPget: connection closed by host" . nl
               S sclose \ clientclose() will delete S from lists
               -1 "S" book
            THEN

         ELSE " HTTPget: error connecting to " Host + ersys
            "" (hT)
         THEN
      LOOP
      "" "Host_alias" book \ set back to empty

      S socket_open
      IF " HTTPget: closing connection" . nl THEN
      S sclose \ deletes S from socket lists, even if S is closed

      TIMEOUT "timeout" book
      ERR

      [ \ Begin bracket mode (again).  Making local macro receive.

{     The local word called receive is made below.  Its ptr is given to
      CONNECT to be run by drainf() and receive bytes from an HTTP ser-
      ver.  The ptr to word receive is called ptr_receive, and it is
      used in the CONNECT phrase above.

      Function drainf() runs word receive while the program state is
      HOLD BLOCK and bytes are being received from a server.

      A local word like this one, located within another word, shares
      the library of that word--in this case, the library of word
      HTTPget.  Thus local variables in the library of HTTPget, like
      CHARS, CLOSED, t0, and VOLS, can be seen by this word, receive.

      This word tests one-line volumes on the top of stack, flowing
      through drainf(), and ignores them until one is received with
      text ENDhttp, signifying the end of data from an HTTP server.

      When the end-of-data text is detected, all the bytes received
      are concatenated into a single one-line volume on the stack,
      and HOLD is then set to "no."

      With HOLD set to "no," the event loop in terminal() will take 
      care of removing BLOCK and getting things back to normal.
}
      {" receive (... hT nSocket --- hT1) \ this is local word receive

         (nSocket) 
         "receive from socket " swap intstr + ERRset

         VOLS 0= 
         IF 
            " HTTPget: receiving bytes ..." . nl 
            time "t0" book \ initial time is now
         THEN
         one VOLS bump
         (hT) these chars CHARS bump

         (hT) this lowercase ENDhttp grepr rows any
         IF
            time " HTTPget: received" .
            (time) t0 less this 0>
            IF CHARS .i " bytes at" .
               CHARS swap slash rounded dup 1E6 <
               IF .i " bytes/sec" .
               ELSE 1E6 slash 
                  "%8.2f" format strchop sp . " Mbytes/sec" .
               THEN
            ELSE drop CHARS .i " bytes in under 1 second" .
            THEN nl

            depth VOLS >= 
            IF VOLS parkn (hT) \ concatenate volumes on the stack
            ELSE " HTTPget: insufficient number on stack for VOLS:" .
               VOLS .i nl
               "" \ return an empty STR
            THEN

            "_/" FILE -path + naming (hT1) \ T1 stack name is _/FILE

            yes "CLOSED" book
            no HOLD \ no more holding, so BLOCK will be removed

         THEN (hT1)

         ERR

      "} "receive" macro

    \ Using localref to get the full main library name needed for
    \ word ptr:
      "HTTPget" "receive" localref (qName) ptr "ptr_receive" book
      ]
   end

   inline: HTTPgetr (qHost qRequest --- hT) \ receive request from Host
{     Send HTTP (Hypertext Transfer Protocol) Request to web server
      Host, and receive response T.

      This word is similar to HTTPget.  Word HTTPget builds a request
      for HTTP procedure GET and sends it to Host.  This word expects 
      an HTTP procedure already built in string Request, and sends it 
      directly to Host.

      Note: HTTPget loop structure was changed in April 2008.  This 
      word still has the old loop structure.

      Word receive in this library operates identically to word receive
      in the library of HTTPget.

      The response is received as a one-line volume T on the stack.
      Returned T is an empty string if there was an error.

      HTTP web servers usually listen on port 80, which is the default
      that this word assumes.  To connect to a server listening on a
      different port, like port 9877, use a phrase like this beforehand:
         9877 "HTTPgetr" "PORT" bank
}
      [ 120 "TIMEOUT" book \ seconds to BLOCK for HTTP bytes each file
        TIMEOUT "timeout" book

\       To change timeout, say to 20, run this before HTTPgetr:

\          20 "HTTPgetr" "timeout" bank

\       After HTTPgetr runs, timeout is always set back to TIMEOUT.
\       Never change TIMEOUT.

        "<html" "BEGINhttp" book
        "</htm" "ENDhttp"   book

        80 "PORT" book

        " " "Host" book  \ connecting to host
        no "CHARS" book  \ count of characters received
        no "CLOSED" book \ flag, set to yes when done
        no "VOLS" book   \ count of received volumes on stack
        no "t0" book     \ initial time
      ]
      "HTTPgetr" ERRset

      (hRequest) any? not IF "/" THEN "REQUEST" book
      (qHost) this -path "Host" book
      " HTTPgetr: host " . Host . nl

      (qHost) PORT ptr_receive CONNECT_HOST any? \ socket to PORT
      IF (nSocket) "S" book
         " HTTPgetr: connected to " . "CONNECT_HOST" "IP" yank . nl

         no "CHARS" book  \ count of characters received
         no "CLOSED" book \ flag, set to yes when done
         no "VOLS" book   \ count of received volumes on stack

         REQUEST S remoteputf \ send request to server

         yes HOLD        \ word receive will say no HOLD when done
         S timeout BLOCK \ until time out or receive says no HOLD

       \ Send closeout to word receive if BLOCK timed out:
         CLOSED not IF ENDhttp (qS) S receive THEN

         S socket_open not
         IF " HTTPgetr: connection closed by host" . nl
            S sclose \ informs clientclose() to delete S from lists
         THEN

         S socket_open
         IF " HTTPgetr: closing connection" . nl THEN
         S sclose \ deletes S from socket lists, even if S is closed

      ELSE " HTTPgetr: error connecting to " Host + ersys
         "" (hT)
      THEN

      TIMEOUT "timeout" book
      ERR

      [ \ Begin bracket mode (again).  Making local macro receive.

      {" receive (... hT nsocket --- hT1) \ this is local word receive

         (nSocket) 
         "receive from socket " swap intstr + ERRset

         VOLS 0= 
         IF
            " HTTPgetr: receiving bytes ..." . nl
            time "t0" book \ initial time is now
         THEN
         one VOLS bump
         (hT) these chars CHARS bump

         (hT) this lowercase ENDhttp grepr rows any
         IF
            time " HTTPgetr: received" .
            (time) t0 less this 0>
            IF CHARS .i " bytes at" .
               CHARS swap slash rounded dup 1E6 <
               IF .i " bytes/sec" .
               ELSE 1E6 slash
                  "%8.2f" format strchop sp . " Mbytes/sec" .
               THEN
            ELSE drop CHARS .i " bytes in under 1 second" .
            THEN nl

            depth VOLS >= 
            IF VOLS parkn (hT) \ concatenate volumes on the stack
            ELSE " HTTPgetr: insufficient number on stack for VOLS:" .
               VOLS .i nl
               "" \ return an empty STR
            THEN
            
            "_" REQUEST asciify " " "_" strp +
            1st those chars 64 min items catch naming

            yes "CLOSED" book
            no HOLD \ no more holding, so BLOCK will be removed

         THEN (hT1)

         ERR

      "} "receive" macro

    \ Using localref to get the full main library name needed for
    \ word ptr:
      "HTTPgetr" "receive" localref (qName) ptr "ptr_receive" book
      ]
   end

   inline: HTTPput (qT nS --- ) \ service request T and put in S
{     HTTP request T for socket S may be serviced by a server (such as 
      Apache) or by a word in the program.  

      Use of a server or a word is controlled by PROVIDER as follows:

         A (PROVIDER, PORT) pair defining a server that is called
         below by running word HTTPgetr: 

            PROVIDER: a STR that is the IPaddress of the server 
               that will service the HTTP request 

            PORT: the listening port of the PROVIDER server
         
         or a word pointer NUM to be run below by exe (PORT is not 
         used in this case):

            PROVIDER: a ptr NUM to the word that will service 
            the HTTP request; the stack diagram for a PROVIDER 
            word is:

                  (qT nSocket --- qR) 

               where R is the response for request T

         Initial PROVIDER is a server defined by string "127.0.0.1" 
         and initial PORT is 80.

         The initial TIMEOUT for HTTPgetr when PROVIDER is a server 
         is 20 seconds.  A phrase like

             40 "HTTPput" "TIMEOUT" bank

         can be used to change it.

         REQUESTcheck and RESPONSEcheck in this library are ptrs to 
         words with stack diagrams given by 

            (qT nSocket --- qT1) 

         that check the request and response, respectively.  

         The initial ptr for these words is ptr(drop), which simply
         keeps original T.  See usr/tops_http.v for words HOSTcheck 
         and REQUESTcheck whose ptrs are banked here for a simple
         web server application.
}
      [ 
      \ Initial values:
           "127.0.0.1" "PROVIDER" book 
           80 "PORT" book
           20 "TIMEOUT" book \ wait time for HTTPgetr to perform request
           "drop" ptr "REQUESTcheck" book
           "drop" ptr "RESPONSEcheck" book

           yes "SCLOSE_ON_EXIT" book \ default
      ]
      "HTTPput" ERRset

      "S" book 

      S clientindex 0<

      nl \ Log the client:

      IF " HTTPput: client on socket" . S .i " is gone" .
         "unknown" "IP" book
      ELSE
         " HTTPput: client " . 
         clientIPs S clientindex over rows min quote 
         strchop this "IP" book .  " on socket " S intstr + . nl

         " HTTPput: " . 
         clientLOGINs S clientindex over rows min quote strchop any? 
         IF vol2str COLS out - .out
         ELSE "client LOGIN string is empty" .
         THEN
      THEN
      nl

    \ Turning on ntrace for xxxx.html:
    \ (qT) dup "xxxx.html" grepr rows any not
    \ IF ntrace ELSE nontrace THEN

      (qT) any? not IF "/" THEN textput (qT) \ single string with \n

    \ Debug.  Save the request: 
      (qT) this "REQUEST" book

    \ Check the request:
      (qT) S REQUESTcheck exe (qT)

    \ Perform the request:
      time push \ save initial time 

      PROVIDER (qHost) this type STR = \ IP address string?
      IF (qIP) \ HTTPgetr connects to server and gets the response:

       \ Bank this word's TIMEOUT into HTTPgetr:
         TIMEOUT "HTTPgetr" "timeout" bank

       \ Save the original PORT value from HTTPgetr and bank this one:
         "HTTPgetr" "PORT" yank (nPORT) push
         PORT "HTTPgetr" "PORT" bank

       \ Connect to server and get the response:
         (qT qIP) swap (qIP qT) HTTPgetr (qR)

       \ Restore the original PORT value in HTTPgetr (timeout is always
       \ restored in HTTPgetr when returns):
         pull (nPORT) "HTTPgetr" "PORT" bank

      ELSE (ptr) \ run the word that provides the response:
         (qT ptr) S swap (ptr) exe (qR)
      THEN

    \ Debug.  Save the response in local library: 
      (qR) this "RESPONSE" book

    \ Check the response:
      (qR) S RESPONSEcheck exe (qR)

    \ Send the response:
      S socket_open IF (qR) S remoteputf ELSE (qR) drop THEN

    \ Close socket S if flag is true:
      SCLOSE_ON_EXIT IF S sclose THEN

    \ Log the response time:
      " HTTPput: client " . IP . " socket " S intstr + 
      SCLOSE_ON_EXIT IF " closed " ELSE " kept open " THEN + .
      time pull less 1000 * intstr .  " msec " . date . nl

      yes "SCLOSE_ON_EXIT" book \ reset default

      ERR
   end

   inline: IPloop ( --- qS) \ loopback IP address
      [ "127.0.0.1" is L ] L ;

   inline: localsockets ( --- hR) \ local clients connected to remote
      clientsockets this 3rd catch rake drop 1st catch
      "_localsockets" naming
   end

   inline: MAXBLOCK ( --- sec) \ time to block a pending socket read
      [ 6 is sec ] sec ;

   inline: monkeyIP ( --- qIP) \ query ipmonkey.com for this IP addr
\     Query http://ipmonkey.com for this machine's IP address.
      [ "IP Address:" "IP" book ]

      "HTTPget" "UA" yank "UAsav" book

    \ Make us look like MS Internet Explorer:
      "HTTPget" "msieUA" yank "HTTPget" "UA" bank

    \ Save connection output on log file to show only if there is
    \ an error:
      SYSOUT "SYSOUTsav" book
      ftempsys (qLOG) dup "ERRLOG" book (qLOG) set_sysout

      "http://ipmonkey.com" "/" HTTPget (hHTML)

      SYSOUTsav set_sysout \ back to regular output

      (hHTML) any?
      IF (hHTML) html2text textget dup IP grepr any? (hR f)
         IF (hHTML hR) @ quote IP "" strp strchop (qIP) \ extract IP

         ELSE (hHTML) drop 
            " monkeyIP error: no IP address received" . nl 
            "" (qIP) \ return empty string

         THEN
      ELSE
         " monkeyIP connection error log:" . nl
         ERRLOG asciiload 2 indent . nl
         "" (qIP) \ return empty string
      THEN
      ERRLOG deleteif
      UAsav "HTTPget" "UA" bank

      (qIP)
   end

   inline: net_file_time (qDir --- nsec) \ file time latency on network
{     Returns current clock time less file time for a file just written
      in directory Dir.

      On a standalone machine, net_file_time should be zero.

      Requires write permission in Dir.

      Examples:

         Directory /tmp is local to the machine, so lag is zero:
            [tops@riggo] ready > "/tmp" net_file_time .i nl
             0

         Present working directory is on the network:
            [tops@riggo] ready > pwd net_file_time .i nl
             191 (time on file lags clock by 191 seconds)

         User's home directory is on the network:
            [tops@riggo] ready > "HOME" env net_file_time .i nl
             192 (time on file lags clock by 192 seconds)

      Word dir_watch (file dog.v) uses this word to adjust file time
      to clock time.
}
      (qDir) runid catpath ".net_file_time" + (qFile) push
      NLch peek (qFile) save
      time (t2) peek (qFile) filectime (t2 t1) less (nsec)
      pull (qFile) delete
   end

   inline: new_conn (nS --- ) \ runs when S has just connected
{     This word is run by drainf(), file net.c, when a new client 
      running this program connects.  

      A server can bank into PTR a ptr to a word to run whenever 
      this occurs.  

      PTR is to a word with the stack diagram (nS --- ).

}     [ 0 "PTR" book ] 
      (nS) PTR dup ptr? IF (nS ptr) exe ELSE 2drop THEN
   end

   inline: NIST_DELTA ( --- ) \ sync program time with NIST time
{     Mon May 10 13:35:31 PDT 2010

      Usage: One program must be running word NIST_SYNC, to periodi-
         cally write the machine time correction to the interprocess
         message file.

         All other programs can then run this word to fetch the time 
         correction from the interprocess message file.  

         This is more reliable than all programs trying to connect to 
         NIST at various time by running NIST_SYNC or by running 
         TIME_SYNC to connect over a socket to another program that 
         runs NIST_SYNC.

      Try first to retrieve the time correction from the interprocess
      message file, then run NIST_SYNC if there is nothing.

      After it first runs, this word will run again every SEC.

      Sometimes connecting to NIST with NIST_SYNC (using NISTdelta) can
      take a long time.

      For the sound file server, such a delay caused some clients to
      lose their connections and resulted in a loss of voice messages
      with no way to know there was even a problem.  

      The risk of such a problem is eliminated when this word used in 
      conjunction with another program that updates the time correction
      on the interprocess message file.
}
      [ 86400 "SEC" book ]

      "msgGet" exists?
      IF "NIST_DELTA" msgPeek any?
         IF numerate @ (sec) dup "DELTA" book GMTdelta
            " NIST_DELTA: time sync with NIST, " DELTA intstr + 
            " sec, " + date + . nl
            false
         ELSE true
         THEN
      ELSE true
      THEN (f)
      IF NIST_SYNC "NIST_SYNC" -ALARM THEN

      SEC "NIST_DELTA" ALARM \ run again in SEC
   end

   inline: NIST_SYNC ( --- ) \ sync program time with NIST time
    \ Mon May 10 13:35:31 PDT 2010 Write correction to interprocess 
    \    message file.

    \ After it first runs, this word will run again every SEC.

      [ 86400 "SEC" book ]

    \ Save output to a temp log file to show only if there is an error:
      SYSOUT push
      ftempsys (qFtemp) dup "FTEMP" book (qFtemp) set_sysout

      NISTdelta (sec) "DELTA" book

      pull set_sysout \ restore saved output unit
   
      DELTA UDEF <>
      IF DELTA (sec) GMTdelta

       \ Other programs can get the NIST correction from the inter-
       \ process message file:
         "msgGet" exists?
         IF "NIST_DELTA" msgGet drop
            DELTA (sec) intstr "NIST_DELTA" msgPut
         THEN

         " NIST_SYNC: time sync with NIST, " DELTA intstr + " sec, " + 
         date + (hT)
      ELSE
         " NIST_SYNC: error in time sync with NIST " date + ":" + . nl
         FTEMP asciiload (hT) 3 indent (hT)
      THEN
      (hT) . nl 
    \ keys? IF cprompt . THEN
      FTEMP deleteif

      SEC "NIST_SYNC" ALARM \ run again in SEC
   end

   inline: NISTdelta ( --- sec) \ NIST time minus the machine's time
{     Fetch GMT from the National Institute of Standards and Technol-
      ogy (NIST) web sites and return the difference from the machine's
      GMT.

      These sites are running so-called daytime servers, and they pro-
      vide date and time information on well-known port 13.

      This word fetches GMT from the first "samples" items in the list
      of daytime server IP addresses created below and called IPlist.

      Assumes the machine is connected to the Internet.

      Returns sec=UDEF if error.

      Here is a phrase for timing this word:
         time push NISTdelta time pull less .i nl .m
}
      [ 4 "wait" book       \ max seconds to block each read
        two "TIME_OUT" book \ time out seconds to connect
        no "VERBOSE" book

{       This macro, called receive, connects to the NIST TCP/IP socket 
        at IPaddr, daytime port 13, and returns the difference between 
        NIST GMT and the machine's GMT:
}       {" (qIPaddr --- delta_sec) \ delta_sec=UDEF if error

           (qIPaddr) strchop dup "IPaddr" book

           (qIPaddr) 13 (port) zero CONNECT (nSocket) "S" book
           S 0>
           IF "OK" "OK" \ we are connected!
              VERBOSE
              IF " NISTdelta: connected to " . IPaddr .
                  " on socket" . S .i nl
              THEN
{
              About 51 bytes from NIST come to function drainf() and
              arrive here on the stack.  The 51 bytes begin with 0Ah
              (newline) and end with 20h, 0Ah (blank, newline).

              Here is an example of the 49 visible bytes:

                 52909 03-09-27 23:09:52 50 0 0 199.7 UTC(NIST) *

              Then NIST sends zero bytes, and drainf() closes the con-
              nection.
}
            \ Receiving bytes from NIST:
              S wait BLOCK (qG)       \ receive remote GMT string G
              time1 (Gmach) "t1" book \ get machine's GMT seconds now

            \ If timed out, drainf() may not have closed S:
              S sclose \ does nothing if S is closed

            \ Is the stack still intact?  Expect (OK OK qG):
              (qG) depth three <
              IF (OK OK) depth dump UDEF return THEN (qG) rev (qG OK OK)

              (qG OK OK) that type STR = that type STR = and not
              IF three dump UDEF return THEN

              (qG OK OK) alike (qG f)
              IF (qG)

               { Extract GMT seconds from remote string on the stack.

                 Word ltime gives GMT seconds, which is the number of
                 seconds in Greenwich, England since 00:00:00 on Janu-
                 ary 1, 1970.
               }
               \ Make Year, month, day string into number YYYmmdd where
               \ YYY is 1900-based:
                 (qG) "1" that 2nd word drop + \ 03-09-27 to 103-09-27
                 (qDate) "-" " " strp chpack   \ 103-09-27 to 1030927
                 number drop (YYYmmdd)

               \ Make Hour, minutes, seconds string into number HHmmss:
                 swap 3rd word drop
                 (qTime) ":" " " strp chpack \ 23:09:52 to 230952
                 number drop (HHmmss)

               \ Compute the difference from the machine's GMT time:
                 (YYYmmdd HHmmss) ltime (GMTworld) \ remote GMT seconds
                 (GMTworld) t1 (Gmach) less (delta_sec)

              ELSE (qG) drop UDEF \ error; return undefined
              THEN

           ELSE UDEF \ error; return undefined
           THEN
        "} "receive" macro

        depth push

\       Entries with # were found to be unreliable, and are skipped.
\          IP address         Server name
        "192.43.244.18"   \ time.nist.gov
        "129.6.15.28"     \ time-a.nist.gov
        "129.6.15.29"     \ time-b.nist.gov

      # "131.107.1.10"    \ time-nw.nist.gov

        "132.163.4.101"   \ time-a.timefreq.bldrdoc.gov
        "132.163.4.102"   \ time-b.timefreq.bldrdoc.gov
        "132.163.4.103"   \ time-c.timefreq.bldrdoc.gov

        "128.138.140.44"  \ utcnist.colorado.edu

        "69.25.96.13"     \ nist1.symmetricom.com

        "216.200.93.8"    \ nist1-dc.glassey.com
        "208.184.49.9"    \ nist1-ny.glassey.com
        "207.126.98.204"  \ nist1-sj.glassey.com

        "207.200.81.113"  \ nist1.aol-ca.truetime.com
        "64.236.96.53"    \ nist1.aol-va.truetime.com

        depth pull less pilen
        chop "#" " " qreplace asciify noblanklines
        onto IPlist
{

To test manually for connection, use word CONNECT.  CONNECT returns
-1 for socket number if cannot connect.  Here is an example:

   [tops@clacker] ready > "205.188.185.33" 13 0 CONNECT
    connect_timeo: 10 sec alarm timeout
    connect_timeo: 10 sec alarm timeout
    CONNECT: could not connect to 205.188.185.33 in 2 attempts
    fault at word: CONNECT
    faulty phrase: "205.188.185.33" 13 0 CONNECT [Enter]

    stack elements:
          0 number: -1
    [1] ok!
   [tops@clacker] ready >


Information from: http://tf.nist.gov/service/time-servers.html
July 2, 2004

Name    IP Address      Location
time-a.nist.gov         129.6.15.28     NIST, Gaithersburg, Maryland
time-b.nist.gov         129.6.15.29     NIST, Gaithersburg, Maryland
time-a.timefreq.bldrdoc.gov     132.163.4.101   NIST, Boulder, Colorado
time-b.timefreq.bldrdoc.gov     132.163.4.102   NIST, Boulder, Colorado
time-c.timefreq.bldrdoc.gov     132.163.4.103   NIST, Boulder, Colorado
utcnist.colorado.edu    128.138.140.44  University of Colorado, Boulder
time.nist.gov   192.43.244.18   NCAR, Boulder, Colorado
time-nw.nist.gov        131.107.1.10    Microsoft, Redmond, Washington
nist1.symmetricom.com 69.25.96.13 Symmetricom, San Jose, California
nist1-dc.glassey.com    216.200.93.8    Abovenet, Virginia
nist1-ny.glassey.com    208.184.49.9    Abovenet, New York City
nist1-sj.glassey.com    207.126.98.204  Abovenet, San Jose, California
nist1.aol-ca.truetime.com       207.200.81.113  TrueTime, AOL facility, Sunnyvale, California
nist1.aol-va.truetime.com       64.236.96.53  TrueTime, AOL facility, Virginia
}
      \ Seven samples:
        7 IPlist rows min "samples" book \ quantity to fetch from IPlist
        86400 10 * "TOO_BIG" book \ too big to believe; ignore result

        UDEF "Tdelta" book
      ]
      depth "DEP0" book \ record the beginning stack depth

      CONNTO (sec_to) "sec_to" book \ save old connection time out
      TIME_OUT (sec) connto         \ set new connection time out

    \ Initialize samples undefined:
      UDEF samples one fill "DELTA" book

    \ Gather samples DELTA:
      samples 1st DO IPlist I quote receive DELTA I poke LOOP

    \ Remove undefined samples:
      DELTA these numbad rake trash

    \ Compute the sample mean:
      (hDELTA) any?
      IF (hDELTA)

       \ Remove the largest and smallest if there are more than four,
       \ then compute the mean:
         these rows four >
         IF (hDELTA) yes sort 2nd those rows two less items reach
         THEN (hDELTA) mean rounded ontop (sec)

      ELSE
         UDEF \ no samples

      THEN (sec) this abs TOO_BIG > IF drop UDEF THEN "Tdelta" book

      sec_to connto \ connection time out back to old

    \ Clean up the stack:
      depth DEP0 > IF depth DEP0 - 1st DO drop LOOP THEN

      Tdelta (sec)
   end

   inline: PING (qIP --- f) \ f true if Unix ping returns 0% loss for IP
{     Thu Feb 18 10:57:37 PST 2010

      The program is idled while this word runs.

      Examples:
         IPlocal PING \ test local Internet connection
         "google.com" PING \ test remote host
         "127.0.0.1" PING \ check loopback
}
      [ "_bin" "tmppath" yank (qTMP) runid + "_PING_" + ftemp (qFile)  
        (qFile) "LOG" book
        LOG deleteif

      \ Rate of packets sent is one per second.  Set up ping to send
      \ 4 packets and finish in no more than 10 seconds:
        SBIN "ping -c 4 -w 10 " + "XXX > " + LOG + " & " + (qS)
        (qS) "COMMAND" book

        "4 packets transmitted, 4 received, 0% loss" "OK" book
      ]
      (qIP) dup chars 0= IF drop fail return THEN \ empty string

      15 expectout
      COMMAND "XXX" rot strp (qS) running (f)
      IF 2 idle \ let ping finish LOG file
         LOG asciiload noblanklines (hT) any?
         IF (hT) OK grepr any?
            IF drop true ELSE fail THEN
         ELSE fail
         THEN
      ELSE " PING: word running failed on script" . nl
         fail
      THEN
      30 expectout \ back to default setting
      LOG deleteif
   end

   inline: port_on (nPort --- f) \ f is true if Port is being used
    \ Sat Aug  8 11:27:21 PDT 2009

    \ This word shows how to use nextport to see if a port is active.
    \ If active, any program may be using the port, not just this one.
      (nPort) dup -1 >
      IF (nPORT) dup nextport = not \ in use if nPORT!=nextport
      ELSE drop no
      THEN
   end

   inline: port_listening (Port --- f) \ f is true if listening on Port
{     Flag f is true if Port is a listening port.

      This program may or may not be the one doing the listening.

      Assumes a line in netstat display of one of these forms:
         tcp   0   0 *:9877      *:*         LISTEN (Linux)
         tcp4  0   0 *.9877      *.*         LISTEN (AIX)

      Accounts for AIX style where dot is used instead of colon.
}
      [ "netstat -a | grep PORT > FILE" "command" book ]
      [ "HOME" env "__port_listening.tmp" catpath "TMP" book ]

      0 STR stkok, 1 NUM stkok or not
      IF "port_listening" stknot return THEN

      dup type NUM = IF intstr THEN "Port" book

      command 
      "PORT" Port    strp
      "FILE" TMP strp (hT)
      (hT) vol2str strchop (qS)

      (qS) shell TMP asciiload TMP delete (hT)
      (hT) asciify noblanklines any?
      IF this "LISTEN" grepr any?     \ grep for LISTEN
         IF reach "." ":" strp        \ AIX . to Linux :
            ":" Port + grepr rows any \ grep for Port
         ELSE drop no
         THEN
      ELSE no
      THEN
   end

   inline: remoteack (hSockets --- f) \ remotes acknowledge
{     Waits for up to SEC seconds for acknowledgement from all remote
      connections to Sockets.

      This program is presumed to be running at the other end of all
      Sockets.
}
      [ 30 "SEC" book, no "FLAG" book
{
        This one-line macro is run by the multitasker during the wait
        period.  It is run by word WAITING, the multitasker assistant
        to word WAIT_INIT, and in this case returns true when all re-
        motes have acknowledged a connection as evidenced by the number
        of rows in local matrix ACK:
}          'SOCKETS rows "ACK" local rows = (f) dup "FLAG" book (f)'
           "ack" macro

      \ A remote makes the program here add the remote's socket number
      \ to the local list, ACK, by having it run this macro as its
      \ acknowledgement:
        {"
           remotefd
           "ACK" local pile
           "ACK" book

         \ Maybe all socket numbers are now piled in ACK, so do not
         \ wait for the next multitasker cycle for word WAITING to
         \ be run.  Run word WAITING now:
           WAITING \ runs word ack shown above

        "} "pile_ACK" macro

        no one null "ACK" book \ local list of acknowledged sockets
      ]
      hand zero MAT stkok not
      IF "remoteack" stknot return THEN

      no "FLAG" book

      (hSockets) any?
      IF "SOCKETS" book
         no one null "ACK" book \ initialize local list of sockets

         [ {" With this phrase, a remote makes the program run pile_ACK:
             "'remoteack' 'pile_ACK' localrun" remotefd remoterun
           "} strchop "JOB" book
         ]
         SEC                        \ seconds to wait
         "remoteack" "ack" localref \ full lib name of local word ack
         (nSEC qWORD) WAIT_INIT     \ initialize WAITING

         ercnt push
         JOB (qJOB) SOCKETS remoterun
         ercnt pull - 0=
         IF WAIT_BEGIN              \ WAITING until ack returns true
         ELSE " remoteack: remoterun failed" . nl no "FLAG" book
            "WAITING" -ALARM \ turn off WAITING, started by WAIT_INIT
         THEN
      THEN
      FLAG (f)
   end

   inline: remoteclients (nSocket --- hT) \ run word clients on remote
\     Get what the word clients would show at remote end of Socket.
      no NUM stkok not IF "remoteclients" stknot return THEN
      this 0> not IF drop "socket closed" hand return THEN
      (nSocket) "'clients' >stk" that remoterun (nSocket) remoteget
   end

   inline: REMOTEdelta (nSocket --- sec) \ time remote minus time local
\     Remote machine time minus local machine time.
\     If sec is positive, time on the remote machine is ahead of local.

      [ "date sysdate ltime remotefd remoteput" "GET_TIME" book ]
      GET_TIME swap (qS nSocket)

      (qS nSocket) remoterun1 (sec_remote)

      date sysdate ltime (sec_local)

      (sec_remote sec_local) less
   end

   inline: remotehost (nSocket --- qS) \ name of host at end of Socket
      no NUM stkok not IF "remotehost" stknot return THEN
      this 0> not IF drop "socket closed" hand return THEN
      (nSocket) "host" that remoterun (nSocket) remoteget
   end

   inline: remotekeys (hT nSocket --- ) \ run the keyboard at Socket
\     Assumes the remote has keyboard enabled; run word keys? remotely
\     to see, with a phrase like:
\        [tops@dobro] ready > "keys? remotefd remoteput" 6 remoterun1

      "S" book (hT) textput these chars 1st
      DO this I character S remoteput "key_in" S remoterun LOOP
      drop
   end

   inline: remoteputf1 (qT nS1 nS2 --- ) \ send T to S1, echoes to S2
\     Send T to S1 and send echoes received to S2.  Bytes of T are
\     sent one at a time.
      "S2" book "S1" book "T" book
      T chars 1st
      DO S1 T I catch that remoteputf MAXBLOCK BLOCK (qR)
         (qR) S2 remoteputf
      LOOP
   end

{  Below is an alternative version of remoteputmat (file net.c) that
   uses an indeterminate wait state to wait until the matrix is re-
   ceived on the remote.
}
   inline: remoteputmat1 \ (hA nSocket --- ); stack on remote: ( --- hA)
{     Sent matrix A to the remote on Socket.

      Begins an indeterminate wait state with word WAIT_BEGIN, and
      counts upon a WAIT_END command from the remote after the matrix
      is received.

      To be safer, an alarm could be set using WAIT_ALARM before saying
      WAIT_BEGIN (as in TASK_PORT).

      January 2008:
      USING WAIT_END IS A BAD IDEA BECAUSE IT DESTROYS THE SYNCHRONI-
      ZATION WITH A SIMULTANEOUS WORD ALSO USING WAIT_BEGIN.  SEE
      NOTE IN WORD WAIT_INIT, FILE sys.v.  WAIT_END HAS BEEN REMOVED 
      FROM TASK_PORT AND SHOULD ALSO NOT BE DEVELOPED HERE.

      This word is experimental.  Word remoteput will send a matrix to
      a remote.
}
      zero NUM stkok not
      IF "remoteputmat1" stknot return THEN

      swap this type MAT = that type NUM = or not
      IF swap "remoteputmat1" stknot return THEN (nSocket hA)

      (nSocket hA) that socket_open not
      IF " remoteputmat1: socket is not open" ersys return THEN

      (hA) export8n (hT) \ MAT to network endian VOL

    \ The following phrase run on the remote will send command WAIT_END
    \ to here after it gets the matrix from the stack.  Then the remote
    \ will run import8n to convert network endian to its endian:
      "remotefd remoteget 'WAIT_END' remotefd remoterun import8n" (qS)

      rot (hT qS nSocket) remoterun

      WAIT_BEGIN \ begin indeterminate wait until remote says WAIT_END
   end

   inline: remoteprompt (nSocket --- ) \ run at a prompt on Socket
{     Begin running interactively on a remote instance of the program
      on connected Socket.  Pressing Esc-q returns to the ready prompt
      of this program.  The remote program remains connected.

      Example: Connecting to server, which returns socket 6, then
      running remoteprompt on socket 6.  Word clients on the server
      shows four clients connected to it (S<C).  Running word remotefd
      on the server shows that our socket 6 is its socket 7.

         [tops@clacker] ready > IPloop 9877 CLIENT

          stack elements:
                0 number: 6
          [1] ok!
         [tops@clacker] ready > clients
          Server local is off
          Clients:
           socket 6, port  9877, conn C>S, 127.0.0.1 dale clacker

          stack elements:
                0 number: 6
          [1] ok!
         [tops@clacker] ready > remoteprompt
         tops@socket6 > clients
          Server local is listening on port 9877
          Clients:
           socket 3, port  9881, conn C>S, 127.0.0.1 dale clacker
           socket 5, port 32778, conn S<C, 127.0.0.1 LOGIN dale clacker
           socket 6, port 32779, conn S<C, 127.0.0.1 LOGIN dale clacker
           socket 7, port 32780, conn S<C, 127.0.0.1 LOGIN dale clacker
           socket 8, port 32781, conn S<C, 127.0.0.1 LOGIN dale clacker
           socket 9, port  9880, conn C>F, 127.0.0.1 dale clacker
         tops@socket6 > remotefd .i
          7
         tops@socket6 >

      WARNING: typing bye, exit, quit will close the remote program
      resulting in "broken pipe" and probable seg fault in the local
      program.  Words like these are caught using exe_remote to install
      substitutes.  See "Remote word substitutions" below in this file.
}
      no NUM stkok not IF "remoteprompt" stknot return THEN

      this socket_open
      IF (nSocket) pname "@socket" other intstr " > "
         + + + remoteprompter
      ELSE " remoteprompt: socket " swap intstr " is not open"
         + + ersys
      THEN
   end

   inline: remoteprompt_run (qS --- ) \ phrase to run text at remote
\     This inline runs the text at the remote prompt when running
\     word remoteprompt or word remoteprompter.
      >stk remotefd remoteput nullbyte remotefd remoteput
   end

   inline: remoteprompt_stk ( --- ) \ phrase to run remote stk display
\     This inline displays the remote stack when running word remote-
\     prompt or word remoteprompter.
      ok @ ".sf" >stk remotefd remoteput
   end

   inline: remotercv (nS nSec nBytes --- qT) \ receive Bytes in Sec on S
{     Block the program until pending reads from socket S return a total
      of Bytes or more, or until time out after Sec seconds.

      After Bytes have been received, the program resumes normal opera-
      tion.
}
      [ no "Bytes" book 
        no "ptrSav" book
        no "S" book

        {" rcv (qT1 qT2 nS --- qT) \ receive bytes from drainf()
           (nS) drop

           (qT1 qT2) +

           NTRACE
           IF " rcv: got:" . these chars .i " need:" . Bytes .i nl THEN

           these chars Bytes >=
           IF (qT) \ have Bytes or more:
              NTRACE IF " rcv: done; have" . these chars .i nl THEN

              ptrSav S ptrRun_upd \ put back saved ptrRun

            \ Run ptrRun(T), just as drainf() would for NATIVE client:
              (qT) ptrSav 0<> 
              IF { Mimic this code in drainf(): 
                     return(
                        pushint(sockfd) &&
                        pushd(ptrRun) &&
                        exeq() && /* stk: qT nSocket ptrRun */
                        drop() /* dropping flag left by exeq() */
                     );
                 }
                 (qT) S ptrSav exe? (f) drop 
            \ ELSE (qT) \ drainf() just returns with T on the stack
              THEN
              no HOLD \ break HOLD, and normal operation resumes
              yes "OK" book
           THEN
        "} "rcv" macro \ local macro to receive bytes from drainf()

        defname "rcv" localref ptr "ptr_rcv" book
      ] 
      "Bytes" book "Sec" book "S" book
      no "OK" book \ can be yanked later to see if OK=yes

      "" (qT) \ initial empty string

      S ptrRun "ptrSav" book
      ptr_rcv S ptrRun_upd

      yes HOLD
      (qT) S Sec BLOCK

    \ Put back saved ptrRun in case rcv did not, due to time out:
      OK not IF ptrSav S ptrRun_upd THEN
   end

   inline: remoterun1 (hT hSockets --- ...) \ run T on all Sockets
{     Words in T are run remotely on each connection in Sockets.  The
      program waits until every remote has sent back a stack item, or
      until SEC seconds have passed.

      T must contain a phrase that returns one (and only one) item to
      the program's stack.  This means that as many stack items are
      expected as there are rows in Sockets.

      If T has not been written to return a stack item, word ACK can
      be appended to it so a true flag will be sent when it finishes.

      If there are more sockets than returned stack items, the entire
      wait period will pass; i.e., if each remote does not return one
      stack item or causes the number of stack items to be reduced,
      the entire wait period will pass.

      Word remoterun1 is asynchronous, so each client must make the 
      server do exactly the same thing (if anything) regarding its 
      stack, and leave it with a single stack item when finished. 

      Examples:

         1. This grabs Done, a number, from each remote and returns it
            to the stack of this program (as a 1-by-1 MAT):
               "Done remotefd remoteput" (hT) sockets remoterun1

         2. Each remote makes the program place the remote's socket
            number on the program's stack (if you get this example,
            you understand remotefd):
               "'remotefd' remotefd remoterun" sockets remoterun1

         3. Placed inside of list: ... end to collect returned NUMs 
            into a column MAT:
               list: Text_run sockets remoterun1 end (hA)
}
      [ 30 "SEC" book

      { This macro called TOTAL is run in the multitasker by word
        WAITING, as this word waits for Nwait items to appear on the
        stack.  Word TOTAL returns f=true to stop WAITING when all
        sockets are done, or when any socket prematurely disconnects:
      } {" ( --- f)
           depth d0 - Nwait < not (f1)
           list: Nwait 1st DO Sockets I pry socket_open LOOP end 
           totals ontop abs Nwait <> (f2)
           (f1 f2) or dup "FLAG" book
        "} "TOTAL" macro
      ]
      depth two < IF "remoterun1" stknot return THEN

      hand (hA) swap (hT) textput (qS) swap
      true one MAT stkok and, two STR stkok and not
      IF "remoterun1" stknot return THEN

      (hSockets) any?
      IF (qS hSockets) "Sockets" book
         no "FLAG" book

         depth nit "d0" book       \ initial stack depth
         Sockets rows "Nwait" book \ number of stack items to wait for

         SEC                       \ sec to wait for remote responses
         "remoterun1" "TOTAL" localref \ full lib name of local TOTAL
         (nSEC qTOTAL) WAIT_INIT
{
         Add a line to T to have the remote cause this program to run
         word WAITING, which has been given the job to run local inline
         TOTAL defined above (see WAIT_INIT above).

         Word WAITING can be run as soon as FLAG from TOTAL might become
         true, and the time waiting for the next multitasker cycle to 
         run word WAITING can be saved: 
}        (qS)
         " 'WAITING' remotefd remoterun" (qS1) \ ending for S
         (qS qS1) + (qS)

         ercnt push
         (qS) Sockets remoterun \ run S on all remotes
         ercnt pull - 0=
         IF WAIT_BEGIN \ WAITING until word TOTAL returns true
            FLAG not \ flag from TOTAL was not true?
            IF " remoterun1: " SEC intstr + " second wait has passed" +
               . nl
            THEN
         ELSE " remoterun1: remoterun failed" . nl no "FLAG" book
            "WAITING" -ALARM \ turn off WAITING, started by WAIT_INIT
         THEN

         depth d0 less Nwait < \ make up stack shortage with false NUMs
         IF depth d0 less Nwait swap less 1st
            DO false LOOP
         THEN

      ELSE (qS) " remoterun1: no connections" + sp . nl
      THEN
   end

   inline: remotesockets ( --- hR) \ remotes connected to local
\     R is purged if no remotes are connected to local server.
      clientsockets this 3rd catch rake lop 1st catch
      "_remotesockets" naming
   end

   inline: remotestack (nSocket --- hT) \ get stack display at Socket
      no NUM stkok not IF "remotestack" stknot return THEN
      this 0> not IF drop "socket closed" hand return THEN
      (nSocket) "yes '.sf' >stk" that remoterun (nSocket) remoteget
   end

   inline: remotetasks (nSocket --- hT) \ multitasker tasks at Socket
      no NUM stkok not IF "remotetasks" stknot return THEN
      this 0> not IF drop "socket closed" hand return THEN
      (nSocket) "'tasks' >stk" that remoterun (nSocket) remoteget
   end

   inline: remotewhos (nSocket --- hT) \ run word whos on remote
\     Get what word whos would show at remote end of Socket.
      no NUM stkok not IF "remotewhos" stknot return THEN
      this 0> not IF drop "socket closed" hand return THEN
      (nSocket) "'whos' >stk" that remoterun (nSocket) remoteget
   end

   inline: SERVER-CYCLE ( --- ) \ close and open listening port
{     Cycle the server listening port off and on if there are no
      current clients and the last one disconnected more than TWAIT
      seconds ago.

      Purpose: cut off surreptitious connections that use a port but
      are not connected as clients (SYN_RECV).

      Example usage: 

         Running a server duty cycle, closing and opening listening 
         port 80 every 20 seconds.  Closing and opening will be de-
         layed for 70 (TWAIT) seconds after the last client has dis-
         connected to span the client's TIME_WAIT period.

         host "kaffia" =
         IF " Starting SERVER-CYCLE" . nl
            80 "SERVER-CYCLE" "PORT"  bank \ for port 80 server
            70 "SERVER-CYCLE" "TWAIT" bank \ delay after last client
            1 20 / "SERVER-CYCLE" PLAY     \ run in the multitasker
         THEN
}
      [ 9877 "PORT" book
        5 "SEC" book
        90 "TWAIT" book

      \ A macro to start the server again:
        "'*' PORT SERVER" "RESTART" macro
      ]
      remotesockets rows 0> IF return THEN

      time clienttimesoff any?
      IF bend   \ rows into cols for max1()
         max1 @ \ latest time of all rows
         less (dt)
      THEN (dt) TWAIT > \ if dt > TWAIT, restart server
      IF serverclose SEC "RESTART" ALARM THEN
   end

   inline: SERVE_F (hT nSocket --- ) \ process a foreign SERVER request
{     Process a SERVER request from a new client just connecting or an
      established foreign client.

      This word is central to the program running TCP/IP.  It is run by 
      drainf() in net.c and clientmake(), clientclose() and terminal()
      in term.c for these purposes:

         Function         Run by                    Purpose
         SERVE_F          drainf()                  receive client bytes
         SERVE_F.ADD      clientmake()              connection beginning
         SERVE_F.REM      clientclose(), drainf()   connection closing
         SERVE_F.TYPE     drainf()                  fetch SERVER type
         SERVE_F.CONNSHOW terminal()                show each connection
         SERVE_F.RFSEC    terminal()                delay when refuse

      SERVE_F provides the interface to new clients and establisned
      foreign clients when the program is running as a SERVER.  (For-
      eign clients are clients that are not this program.)  Here is the
      enumeration of foreign types in net.c:

         enum foreign_types {HTTP=0,TERM};

      Type HTTP disconnects when this word returns (drainf()).  Type 
      TERM is more general and the connection is maintained allowing 
      a dialog between this SERVER and connected foreign clients.

      SERVE_F is set up before SERVER is started by banking here the 
      appropriate items for TYPE, SERVICE (and local functions ADD and 
      REM if the defaults here are not adequate).

      Since there is only one TYPE and one SERVICE for all sockets, 
      the server is restricted to running the same foreign type of
      service for all that connect.

      Examples.

      1. To set up a simple server for testing foreign clients:

            "" 9877 SERVER
            1 "SERVE_F" "TYPE" bank              \ TERM type
            "2drop" ptr "SERVE_F" "SERVICE" bank \ drops (hT nSocket)
            300 new_client_timeout               \ runs 5 minutes

      2. Here is an example of an HTTP type:

         The word for processing a SERVER request must have its ptr
         and type banked here as in this example for an HTTP type:

            Banking the ptr to word do_HTTP for processing requests:
               "do_HTTP" ptr "SERVE_F" "SERVICE" bank
               0 (type HTTP) "SERVE_F" "TYPE"    bank

            where the stack diagram for do_HTTP must be the same as the 
            one for this word: (hT nSocket --- )

         For TYPE=HTTP, drainf() will close Socket when this word re-
         turns.  See usr/tops_http for this program as HTTP server.

      3. Here is an example of a TERM type for telnet:
         Configuring the program as a telnet server:
            "TELNET_CLIENT" ptr   "SERVE_F" "SERVICE" bank
            1 (TERM)              "SERVE_F" "TYPE"    bank
            "TELNETD_CONNECT" ptr "SERVE_F" "ADDptr" bank

         The stack diagram for the word being used for SERVICE must
         be (hT nSocket), as it is for TELNET_CLIENT used above.
}
      [ \ Begin the library of this word.

\        The default settings for TYPE and SERVICE are for getting 
\        bytes from HTTP servers (using HTTPget).

            0          "TYPE"     book \ HTTP server type
            zero (ptr) "SERVICE"  book \ zero ptr means to skip
            yes        "CONNSHOW" book \ show each connection
            5          "RFSEC"    book \ sec ignore connection refused

         0 1 null "SOCKS" book \ list of foreign sockets being served

\        Default functions to update SOCKS list; ADDdef adds incoming
\        nSocket to SOCKS and REMdef removes it from SOCKS:
         "(S) SOCKS pile 'SOCKS' book" "ADDdef" macro \ latest first
         "(S) SOCKS dup rot = rake drop 'SOCKS' book" "REMdef" macro
{
         Below are default ptrs to functions that update the local list
         of foreign sockets, SOCKS.  These are used by ADD and REM that
         are run by the program (see below):
}           "ADDdef" ptr "ADDptr" book \ SOCKS default to add
            "REMdef" ptr "REMptr" book \ SOCKS default to remove 
{
         Below are functions ADD and REM to update the local list of
         foreign sockets, SOCKS.  The stack diagram for ADD and REM 
         is (nSocket --- ).  These functions are run by the program 
         when clients connect and close (clientmake() and clientclose()
         in term.c, and drainf() in net.c): 
}           "ADDptr exe" "ADD" macro \ run local ptr ADDptr
            "REMptr exe" "REM" macro \ run local ptr REMptr

{        To know when clients connect or close, a ptr to a word can
         be banked here replacing ADDptr or REMptr so it will be run 
         instead.  

         For example, word TELNETD_CONNECT (file sys/term.v) does this 
         for ADDptr, so it can start a telnetd daemon when a client 
         first connects.  

         Either of these phrases will bank a new ptr here for ADDptr, 
         so word TELNETD_CONNECT will be used to add a new client:
            >> SERVE_F.ADDptr=ptr("TELNETD_CONNECT"); <<
            "TELNETD_CONNECT" ptr "SERVE_F" "ADDptr" bank

         Note that ADD and REM, with stack diagrams (nSocket --- ) are
         in addition to SERVICE with stack diagram (hT nSocket --- ).

         On connection, word SERVICE will be called after word ADD runs.
       
      Always comes here from drainf() when bytes arrive on SERVER from 
      a foreign client, and the word having ptr stored here in SERVICE 
      is executed:
}     ] SERVICE 0<> IF (hT nSocket) SERVICE exe return THEN

      TYPE 0 (HTTP) =
      IF \ Send something back so programs like wget quit retrying:
         CRLF swap remoteputf drop return
      THEN

      (hT nSocket) sclose drop \ nothing specified, so close Socket
   end

   inline: SERVE_F_TERM ( --- ) \ initialize SERVE_F as TERM type
      1 "SERVE_F" "TYPE" bank             \ TERM type
      "noop" ptr "SERVE_F" "SERVICE" bank \ (hT nSocket) from drainf()
      300 new_client_timeout              \ 5 minutes to log connect
   end

   inline: SERVER_ALLOW (qIP --- f) \ flag f true if IP can connect
{     Table "clients" in this local library contains the list of IP
      addresses where this program running can connect using word
      CLIENT.

      Given a prospective IP address, this word returns f true if it
      matches an entry in clients table.

      The program runs this word in drainf() after client type has
      been determined to be LOSERV.

      Only the first word in each line of the clients table is used
      to match against IP, so any arbitrary text can follow the first
      word.

      If clients table is empty, as it is at start up, then only the
      loopback IP address is allowed to connect.
}
      [ VOL tpurged "clients" book ]

      "127.0.0.1" that alike IF drop yes return THEN

      clients chars any
      IF clients 1st word drop swap (hT qIP) grepe (hA) rows any (f)
      ELSE (qIP) drop no
      THEN
   end

   inline: serverport ( --- nPort) \ port of local server listening
\     Returned number Port is 0 if server is not on.
      "clients" >stk its "listening" grepr any?
      IF reach numerate ontop ELSE drop false THEN
   end

   inline: servershutdown ( --- ) \ close clients, shut down server
      sockets any?
      IF these rows 1st DO this I pry sclose LOOP drop THEN
      serverclose
   end

   inline: serverstart (nPort --- f) \ turn server on, listening on Port
      no NUM stkok not IF "serverstart" stknot return THEN

      this port_listening

      IF \ Port is listening already; is it this server?:
         (nPort) serverport = (f)
      ELSE
         "*" that SERVER port_listening (f)
      THEN (f)
   end

   inline: SERVER_WAIT (nSec --- ) \ ignore new connections for Sec
      [ "yes READY" "SERVER_RESUME" macro ]
      no READY (nSec) "SERVER_WAIT" "SERVER_RESUME" localref ALARM 
   end

   inline: SHSERVER (nSec --- nPort) \ shell server for Sec on Port
\     Start a shell running this program as a server for up to nSec.
\     Listening Port being used is returned.

      [ 10 (seconds) "STARTUP" book \ server start up seconds
      ]
      no "PORT" book
      (nSec) "SEC" book

      "tserv" filefound
      IF (qScript)
         " -exit " SEC STARTUP plus intstr + +
         " -port " def_port nextport dup "PORT" book intstr + +
         " &" +
         (qS) shell STARTUP idle

      ELSE " SHSERVER: script usr/tserv not found" ersys
      THEN PORT cop
   end

   inline: SNDSERVER ( --- nPORT) \ port of the sound file server
{     Script tops_snd runs a daemon sound file server queue, listening
      on PORT.

      Clients can obtain PORT from this word, and connect to the sound 
      file server using:

         IPloop SNDSERVER CLIENT "S" book

      where S is nonnegative if the server is running and a valid con-
      nection has been made.

      Once connected to the sound file server, rather than running

         (qFile) wavPlayb

      to play a file named File (see sys/snd.v), a client submits File 
      name over socket S to the sound file server by running the phrase

         (qFile) " wavque_add" + S remoterun


      The file will be queued and played when its turn comes, and the
      client can disconnect any time from the server by running

         S sclose

      WARNING: files played by the sound file server are deleted; see
      wavPlayq in sys/snd.v.

      Note: interprocess communication word msgPeek from file sys/dog.v
      must be present: "dog.v" source.

}     [ -1 "OFF" book ] 
      "msgPeek" exists?
      IF "SNDSERVER" msgPeek any?
         IF (qPORT) number drop ELSE OFF THEN
      ELSE OFF
      THEN
   end

   inline: SNDSERVER_ON ( -- f) \ true if sound file server is listening
    \ Sat Aug  8 11:27:21 PDT 2009
      SNDSERVER port_on
   end

   inline: SNDSERVER_RATE (nHz --- ) \ set rate of sound file queuing
    \ Wed Mar 24 12:12:50 PDT 2010
    \ Set the rate of the wave file queuing system in tops_snd.

    \ The rate at start up is 0.2 Hz, or once every 5 seconds. 

    \ Example: 1 15 / SNDSERVER_RATE \ once every 15 seconds

      "Hz" book IPloop SNDSERVER CLIENT "S" book S -1 >
      IF Hz "%10.6f" format " 'wavque_play' RATE" + S remoterun
         " SNDSERVER_RATE: set queue rate to " Hz "%4.3f Hz" format +
         S sclose

      ELSE " SNDSERVER_RATE: unable to connect to SNDSERVER"

      THEN . nl
   end

   inline: socket_ack (nSocket --- f) \ this program remote acknowledge
{
      When a socket is not open and this word is running in the multi-
      tasker, conflict arises due to the necessary delay needed to see
      if the socket is open.

      This shows the problem when word offline_check runs this version
      of socket_ack (all messages execpt "busy task offline_check" are
      obtained by recompiling term.c with debug in tasker() turned on):

         tasker task: queue_run,0:CODE__ Mon Jul 13 11:28:57 PDT 2009

         tasker task: offline_check,0:CODE__ Mon Jul 13 11:29:06 PDT 200
         tasker: busy task offline_check,0:CODE__ interrupted Mon Jul 13
         tasker task: WAITING,0:CODE__ Mon Jul 13 11:29:06 PDT 2009
         tasker task: WAITING,0:CODE__ Mon Jul 13 11:29:07 PDT 2009
         tasker task: WAITING,0:CODE__ Mon Jul 13 11:29:08 PDT 2009
         tasker task: WAITING,0:CODE__ Mon Jul 13 11:29:08 PDT 2009
         tasker task: WAITING,0:CODE__ Mon Jul 13 11:29:09 PDT 2009

         tasker task: queue_run,0:CODE__ Mon Jul 13 11:29:19 PDT 2009
      
      The problem is not fatal and simply cause this line in the log 
      file:
         tasker: busy task offline_check,0:CODE__ interrupted Mon Jul 13

      A better approach is probably not to run periodic socket_ack at 
      all, but instead to have machines sent periodic messages that 
      they are connected.

      When this program is connected remotely on Socket, this word is 
      a reliable way to see it the connection is still open.  

      It makes this program send back an acknowledgement, resulting in
      true flag f arriving on the stack here.

      If a remote hangs up, word socket_open and related socket testing
      words will often return a false positive.

      Once a socket is found to be no longer connected, word sclose
      should be run so it can be removed from the list of clients.

}     [ MAXBLOCK "WAIT" book ]
      dup 0< IF drop false return THEN

      dup client_open \ must be a client that has connected
      IF "remoteack" "SEC" yank push
         WAIT "remoteack" "SEC" bank
         remoteack
         pull "remoteack" "SEC" bank
      ELSE drop false
      THEN
   end

   inline: socket_ack1 (nSocket --- f) \ this program remote acknowledge
{     
      Fri Nov 27 09:36:18 PST 2009
         Make time of BLOCK a local variable called SEC that can be
         set externally.  The initial value of SEC is MAXBLOCK.

      Thu Sep 24 05:19:54 PDT 2009
         Revised to test stack depth for returned item after BLOCK,
         and to close socket if nothing came back.

      When this program is connected remotely on Socket, this word is
      a reliable way to see it the connection is still open.

      It makes this program send back an acknowledgement, resulting in
      true flag f arriving on the stack here.

      If a remote hangs up, word socket_open and related socket testing
      words will often return a false positive.

      If the socket is not open, and this word is running in the multi-
      tasker, BLOCK will time out and probably cause an interruption
      message like the one discussed in word socket_ack.  

      If returned f is false, this word will already have closed Socket
      by running sclose, which removes it from the list of clients.

}    
      [ MAXBLOCK "SEC" book ]

       dup 0< IF drop false return THEN

      (nSocket) dup client_open \ must be a client that has connected
      IF "S" book 
         depth push
         "ACK" S remoterun S SEC BLOCK \ expect item from ACK in SEC
         depth pull - dup 0> \ has stack grown?
         IF dump true
         ELSE drop S sclose false
         THEN 
      ELSE sclose false
      THEN
   end

   inline: socket_check (nS --- ) \ display a check of socket S
      "S" book

      S socket_open
      IF S .i " is open" ELSE S .i " is not open" THEN . nl

      S socket_writable
      IF S .i " is writable" ELSE S .i " is not writable"
      THEN . nl

      S socket_readable dup 0<
      IF drop S .i " is not open or has pending read error" . nl
      ELSE dup 0=
         IF drop S .i " has" . " no bytes to read" . nl
         ELSE S .i " has" . .i " bytes to read" . nl
         THEN
      THEN
   end

   inline: socket_scan (n --- hA) \ scan of the first n sockets
\     Column 1 of A contains the socket number, and column 2 contains
\     true (-1) if the socket is open.
      depth nit push
      nit 0 DO I dup socket_open park LOOP
      depth pull less pilen
   end

   inline: sockets ( --- hR) \ all connected sockets
      clientsockets 1st catch "_sockets" naming ;

   inline: TASK_PORT (nWAIT qJ --- hA) \ perform task J, return item A
{     Runs task J remotely, over a port on the same machine.

      Starts this program remotely as a server, sends task J through
      the listening port, waits no longer than WAIT seconds for stack 
      item A to appear, then closes the port and kills the remote pro-
      gram.

      If J has not been written to return a stack item, word ACK can
      be appended to it so a true flag will be sent when it finishes,
      as in: (nWAIT qJ) " ACK" pile (nWAIT qJ) TASK_PORT.

      Through the -exit ARGV sent when the server script, dserv1, is
      started, the server will exit on its own in STARTUP+WAIT seconds
      if this word fails to kill it.
}
      [ 10 (sec) "STARTUP" book \ server start up seconds
        2  (sec) "ASEC" book    \ shut down alarm seconds

        {" ( --- f)
         { This indeterminate wait state task, WTASK, avoids waiting
           the entire STARTUP period before trying to connect to the
           server started.

           Typical connection times are now 0.8 seconds versus waiting 
           the entire 10 sec STARTUP.

           Initial CONNECT attempts will fail; send the cannot connect
           messages to scratch: 
         } SYSOUT push scratch set_sysout
           CONNTO push 0 connto \ no idle between CONNECT tries

           IPloop PORT -1 CONNECT any? 
           IF (S) sclose -1 ELSE 0 THEN 

           pull connto
           pull set_sysout \ restore SYSOUT
        "} "WTASK" macro

        10 (Hz) "CONRATE" book \ running WTASK ten times per second
      ]
      swap "WAIT" book
      (qJ) textput \ lines of VOL into string with new line chars

      "dserv1" filefound 
      IF (qServ) 
       \ Start a server.
         time "t0" book               \ timing the start up

       \ Initialize the indeterminate wait state task, WTASK, to watch 
       \ the connection and return as soon as the server is running:
         STARTUP (nSec)               \ max indeterminate wait
         "TASK_PORT" "WTASK" localref \ full lib name of WTASK
         (nSec qWord) WAIT_INIT       \ install WTASK and start WAITING
         CONRATE "WAITING" RATE       \ speed up rate of WAITING

       \ Make the script that starts the server (runs dserv1):
         (qServ) 

       \ Command line options for dserv1 server script:
          \ " -logsave " +         \ add this to save log
          \ " -logsave -ntrace " + \ add this to save log with net trace
            " -exit " + WAIT STARTUP + (nSec) intstr + \ exit time
          \ Port to use:
            " -port " + def_port nextport dup "PORT" book intstr + 
            " &" + (qS)

         (qS) shell \ run the start up script

         WAIT_BEGIN \ indeterminate wait state while script runs

       \ Connect to the server on loopback IP:

         IPloop PORT CLIENT (nSocket)

         (nSocket) this -1 >
         IF " TASK_PORT: server running, connected to socket " 
            over intstr + " in " + 
            time t0 less "%0.2f" format + " sec" + . nl 
         THEN
         (nSocket)

      ELSE " TASK_PORT: file " "dserv1" + " not found" + . nl 
         -1 (nSocket) 

      THEN (nSocket) "S" book

      S -1 <>
      IF 
       \ Get PID of server for killing it later:
       \ No longer done (see old listings).  Killing required an 
       \ ALARM, and rapid back-to-back calls to TASK_PORT caused
       \ timing problems.
       \ "getpid remotefd remoteput" S remoterun1 "PID" book

       \ Do task J:
         "remoterun1" "SEC" yank "WAITsave" book
         WAIT "remoterun1" "SEC" bank

         (qJ) " remotefd remoteput" pile (qJ) depth push

         (qJ) S remoterun1 (hA)
         WAITsave "remoterun1" "SEC" bank

       \ Check the stack:
         depth pull less 0<> \ expect no change (consume qJ, receive hA)

         IF " TASK_PORT: remote task failed" ersys
            VOL tpurged (hA) \ return an empty VOL
         THEN

{        Active close (both client and server closing) avoids the
         CLOSE_WAIT state on PORT.  CLOSE_WAIT means the server port 
         waits for this client to close, which could be hours if this 
         is a long running job.  

         Active close means a TIME_WAIT state is obtained which ex-
         pires after a small wait (seconds or minutes depending on 
         the system).

         Active socket close is run from server using the phrase made
         below and sent to the server.  

         The phrase sends sclose to here, then runs sclose there and 
         finally ALARM(sec,"exit") there to shut itself down:
}        "'remotefd sclose' remotefd remoterun " \ close client (here)
         " remotefd sclose" +                    \ close server (there)
         " 0.5 'exit' ALARM" + (qT)              \ shutdown (there)
         (qT) S remoterun \ run T on the server

         S sclose

         " TASK_PORT: remote task complete in " 
         time t0 less "%0.2f" format + " sec" + . nl 

      ELSE (qJ) drop " TASK_PORT: failed to connect" ersys
         STR tpurged (hA) \ return an empty STR
      THEN
   end

   inline: TIME_SYNC ( --- ) \ this machine in synch with remote
{     Tue Mar 30 09:11:16 PDT 2010

      This word works like NIST_SYNC.

      After it first runs, this word will run again every SEC.

      A valid socket number for S that is connected to the machine to
      be synchronized with must be banked here, as in:

         6 "TIME_SYNC" "S" bank
      or
         TIME_SYNC.S = 6;

      To invalidate socket S, run:

         UDEF "TIME_SYNC" "S" bank

      Socket S remains connected after this word runs.
}
      [ 86400 "SEC" book UDEF "S" book ]

      S UDEF =
      IF " TIME_SYNC: skipping, no socket defined " date + . nl
      ELSE
         S time_sync (f)
         IF "time_sync" "DT" yank "DELTA" book
            " TIME_SYNC: socket " S intstr + " time sync " +
            DELTA intstr + " sec " + date + (qS) . nl
         ELSE " TIME_SYNC: no response from socket " S intstr +
            spaced date + . nl
         THEN
      THEN
      SEC "TIME_SYNC" ALARM \ run again in SEC
   end

   inline: time_sync (nS --- f) \ this machine in synch with remote
{     Synchronize the program time on this machine with the program
      time on the machine connected on socket S.

      Returned flag f is true if the time change was successful.  The 
      time sync will fail if the remote does not respond within SEC 
      seconds, and f will be false.

      After time_sync, times on the two machines should be within
      one second.

      After running, the time difference applied can be recalled by:
         dt = time_sync.DT;
      and is positive when time on the remote machine is ahead.

      Adapted from cluster_timesync (the version that uses time) on
      file clu.v.
}
      [ 10 "SEC" book ] \ wait time in remoterun1

      "remoterun1" "SEC" yank push
      SEC "remoterun1" "SEC" bank 
      UDEF "DT" book

      "time remotefd remoteput ACK"
      swap (nS) remoterun1 (0 or nt -1) \ fetch head node time
      IF (nt) time1 less                \ less local machine time
         dup (deltaT) GMTdelta          \ set program time delta
         "DT" book
         true
      ELSE " time_sync: failed to obtain time from remote" . nl
         false
      THEN
      (f)
      pull "remoterun1" "SEC" bank 
   end

   inline: wrapHTML (hT --- qT1) \ T wrapped with HTML
{     Incoming bytes of T have <p> added at the end of each line and
      HTML header and footer added to top and bottom, for retrieval by 
      HTTPget.  Without HTML header and footer, retrieval can be very, 
      very slow (on the order of 100 bytes/sec).

      Returned T1 is a string with new line characters replacing the
      trailing blanks of VOL T.
}
      [ {"
           <HTML>
           <HEAD>
              <META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">
              <META NAME="GENERATOR" CONTENT="Mozilla/4.05 [en] (X11; U; AIX 4.3) [Netscape]">
           </HEAD>
        "} left justify "HTML" book

        "</HTML>" "/HTML" book
      ]
      (hT) "<p>" tail
      HTML swap /HTML pile pile textput (qT)
   end

   inline: www_open ( --- f) \ f true if connected to the Internet
{     Test for an active Internet connection by trying to connect to
      each of the IP addresses in the list of daytime servers located
      in the library of word NISTdelta.
}
      [ "NISTdelta" "IPlist" yank "IPtry" book ]

      "ppplog" exists?
      IF ppplog file?
\        For dial up or pppoe DSL:
         IF "_pppconnect" "log" yank (f1)
            "_pppconnect" "CONN" yank (f2) and (f)
           (f) dup "www" book return
         THEN
      THEN

\     Some CONNECT attempts may fail; send the cannot connect messages
\     to temp file:
      SYSOUT push
      ftempsys dup set_sysout (qFile)

      no "www" book
      depth push
      IPtry rows 3 min 1st
      DO IPtry I quote 13 (daytime port) 0
         CONNECT (nSocket) any?
         IF (nSocket) sclose
            depth peek - dump
            yes "www" book
            EXIT \ leave loop when a good connection is found
         THEN
      LOOP pull drop

      pull set_sysout \ restore SYSOUT
      (qFile) delete  \ delete temp file

      www (f)
   end

\-----------------------------------------------------------------------
{
   Remote word substitutions.

   This section makes word substitutions when running remotely, using
   word exe_remote.

   Words are running remotely during periods when remotefd is a valid
   socket descriptor.  At other times, remotefd equals -1 (invalid).

   Examples of running remotely:

      Sending a phrase down socket 5.  The program at socket 5 is
      running remotely:
         [tops@localhost] ready > "'widget1' Ksolve" 5 remoterun

      Using word remoteprompt so keyed input runs the program on the
      machine at socket 3:
         [tops@localhost] ready > 3 remoteprompt
         tops@socket3 > [Things keyed here are running remotely]
         tops@socket3 > 'widget1' Ksolve
}
\  Words that would cause the remote program to exit will simply display
\  a message:

   inline: remote_exit ( --- ) " use Esc-q to exit" . nl ;
   "remote_exit" (qW2)

   "abort" that exe_remote
   "bye"   that exe_remote
   "exit"  that exe_remote
   "quit"  that exe_remote
   (qW2) drop

   "killmy" "drop" exe_remote \ silently drop the input to killmy

{
   Example running word exit on remoteprompt:

      [tops@client] ready > 3 remoteprompt
      tops@socket3 > exit
       use Esc-q to exit
      tops@socket3 >
}

\  Block words that mimic Unix functions and that do not work over
\  remote.  Shown below on the right are words that can be substituted.

   inline: remote_invalid ( --- ) " invalid word on remote" . nl halt ;
   "remote_invalid" (qW2)
\                            Substitute
   "cd"    that exe_remote \ chdir: "/tmp" chdir
   "cp"    that exe_remote \ fcopy: "fname1" "fname2" fcopy
   "diff"  that exe_remote \ diff1: "fname1" "fname2" diff
   "grep"  that exe_remote \ grep2: "filename" "pattern" grep2
   "man"   that exe_remote \ where: "dup" where (only if keys?=yes)
   "rm"    that exe_remote \ delete: "core" delete
   "topic" that exe_remote \ none available
   "utail" that exe_remote \ tailf: "filename" 100 tailf
   "remoteprompt" that exe_remote
   (qW2) drop

\  Word HALT and return do not work correctly: 
   "HALT"    "remote_invalid" exe_remote 
   "return"  "remote_invalid" exe_remote 
   "return2" "remote_invalid" exe_remote 
{
   Example:
      Trying to use word rm on remoteprompt to socket 7:
         tops@socket7 > rm core
          invalid word on remote

      Using word delete instead:
         tops@socket7 > "core" delete
}
\  Words in the following list do not work for viewing remote files
\  (but see below, "Ways to view remote text files"):

   "remote_invalid" (qW2)
   "eview fview more _more vi _vi view vim _vim xterm xtermsb" (qW1)
   words these rows 1st DO this I quote other exe_remote LOOP 2drop
{
   Ways to view remote text files:

      To view a small remote file remotely, just load and display it:
         Go to remote:
            [tops@clacker] ready > 3 remoteprompt

         On remote:
            tops@socket3 > ".bashrc" asciiload .
            # .bashrc
            alias rm='rm -i'
            alias cp='cp -i -p'
            alias mv='mv -i'
            set -o vi
            tops@socket3 >

      To view a large remote file, bring it to local and view it there:

         Go to remote:
            [tops@clacker] ready > 3 remoteprompt

         On remote:
            tops@socket3 > ntrace \ shows network activity
            tops@socket3 > "savannah.log" asciiload remotefd remoteput
            netvolwrite: all 3421367 bytes to socket 6
            tops@socket3 > (Press Esc-q to return)

         Back from remote, run eview to view the sent stack item in
         the program's designated text viewer:
             stack elements:
                   0 volume: _Tsocket3  13009 by 263
             [1] ok!
            [tops@clacker] ready > eview
}
   private halt

\-----------------------------------------------------------------------
;

Appendix.

What an HTTP server receives from Netscape, Wget, MS IE, Google Chrome.

Starting this program as SERVER on port 80 (requires root):

   [root@clacker] /home/user # tops
            Tops 2.4.3
   Sun Sep 28 08:09:18 PDT 2003
   [tops@clacker] ready # '' 80 SERVER

For the command
   [user@clacker] /home/user > netscape http://127.0.0.1/index.html &
this is what Netscape (RH7.2 Linux) sends the HTTP server:

   GET /index.html HTTP/1.0
   Connection: Keep-Alive
   User-Agent: Mozilla/4.78 [en] (X11; U; Linux 2.4.7-10 i686)
   Host: 127.0.0.1
   Accept: image/gif, image/x-xbitmap, image/jpeg, image/pjpeg,
    image/png, */*
   Accept-Encoding: gzip
   Accept-Language: en
   Accept-Charset: iso-8859-1,*,utf-8

For this program listening on (non-priviledged) port 9877, for the
command
   [user@blake] /home/user > netscape http://blake:9877/index.html &
this is what Netscape (AIX 4.3) sends the HTTP server:

   GET /index.html HTTP/1.0
   Connection: Keep-Alive
   User-Agent: Mozilla/4.78 [en] (X11; U; AIX 4.3)
   Host: blake:9877
   Accept: image/gif, image/x-xbitmap, image/jpeg, image/pjpeg,
    image/png, */*
   Accept-Encoding: gzip
   Accept-Language: en
   Accept-Charset: iso-8859-1,*,utf-8

For the command
   [user@clacker] /home/user > wget clacker:80/index.html
this is what Wget sends the HTTP server:

   GET /index.html HTTP/1.0
   User-Agent: Wget/1.7
   Host: clacker
   Accept: */*
   Connection: Keep-Alive

For this program listening on (non-priviledged) port 9877, for the
command from MS Internet Explorer:
   http://blake:9877/index.html &
this is what is sent to an HTTP server:

   GET /index.html HTTP/1.1
   Accept: image/gif, image/x-xbitmap, image/jpeg, image/pjpeg,
    application/vnd.ms-powerpoint, application/vnd.ms-excel,
    application/msword, */*
   Accept-Language: en-us
   Accept-Encoding: gzip, deflate
   User-Agent: Mozilla/4.0 (compatible; MSIE 5.5; Windows NT 5.0;
      XYZ_Inc Custom Install; T999999)
   Host: blake:9877
   Connection: Keep-Alive

What an HTTP server receives from Google Chrome:

   Mon Mar 22 00:00:12 UTC 2010 SERVER: 127.0.0.1 connect
    0 bytes delta: memprobe socket 2 connect
    WBSVR: on mysite received from socket 2:
   GET /xxxxx.html HTTP/1.1
   Host: mysite.com
   Connection: keep-alive
   User-Agent: Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US) AppleWebKit/532.0 (KHTML, like Gecko) Chrome/3.0.195.32 Safari/532.0
   Accept: application/xml,application/xhtml+xml,text/html;q=0.9,text/plain;q=0.8,image/png,*/*;q=0.5
   Accept-Encoding: gzip,deflate,sdch
   Accept-Language: en-US,en;q=0.8
   Accept-Charset: ISO-8859-1,utf-8;q=0.7,*;q=0.3
   If-None-Match: W/"7861f-71a-571268aa"
   If-Modified-Since: Thu, 19 Nov 2009 16:20:08 GMT

------------------------------------------------------------------------

HTTPget vs. WGET timing test, July 2004 (dial up).

Timing word HTTPget and program Wget (Reference 4) to retrieve a text
file from the Interactive Weather Information Network:

For back-to-back runs, during the day, dial-up connection.

 Run       Elapsed sec  Bytes fetched   Stated Rate      Bytes/Elapsed
 Wget-1    14.351       85903           6.28 KB/s        5986 bytes/sec
 Wget-2    14.230       85903           6.34 KB/s        6037 bytes/sec

 HTTPget-1 14.777       86156           6004 bytes/sec   5830 bytes/sec
 HTTPget-2 14.762       86156           6013 bytes/sec   5836 bytes/sec

(Note: bytes fetched differ because HTTPget saves the header too.)

Comparing Bytes/Elapsed (bytes/sec):
      Wget average: 6011.5
   HTTPget average: 5833.0
shows that Wget was about 3% faster.

A note about times of day displayed:

   The times of day displayed by tops are corrected to "true GMT"
   obtained from NIST (word NISTdelta) whenever it logs on to the
   Internet, as it has for this test.

   Times of day displayed by Wget use the machine time, so there will
   be a discrepancy.

   This shows that the machine time was 63 seconds fast when the test
   was run:

      [tops@clacker] ready > time time1 -

       stack elements:
             0 number: -63.0000100136
       [1] ok!

   A negative result means the machine is fast, so times of day shown
   by Wget are fast by 63 seconds.

   For example, the corrected start time for Wget Run 1 would be the
   given time, 08:22:10, less 63 seconds, or about 08:21:07.

   The Wget runs were made before the tops runs, and applying the 63
   second correction to the Wget times of day shows this.

Here are the runs:

Run 1 Wget:
[user@clacker] /home/user > time wget iwin.nws.noaa.gov/iwin/ca/state.html
--08:22:10--  http://iwin.nws.noaa.gov/iwin/ca/state.html
           => `state.html'
Connecting to iwin.nws.noaa.gov:80... connected!
HTTP request sent, awaiting response... 200 OK
Length: 85,903 [text/html]

    0K .......... .......... .......... .......... .......... 59% @  10.92 KB/s
   50K .......... .......... .......... ...                  100% @   3.86 KB/s

08:22:25 (6.28 KB/s) - `state.html' saved [85903/85903]
real    0m14.351s
user    0m0.020s
sys     0m0.000s

Run 2 Wget:
[user@clacker] /home/user > time wget iwin.nws.noaa.gov/iwin/ca/state.html

--08:22:26--  http://iwin.nws.noaa.gov/iwin/ca/state.html
           => `state.html.1'
Connecting to iwin.nws.noaa.gov:80... connected!
HTTP request sent, awaiting response... 200 OK
Length: 85,903 [text/html]

    0K .......... .......... .......... .......... .......... 59% @  11.34 KB/s
   50K .......... .......... .......... ...                  100% @   3.84 KB/s

08:22:41 (6.34 KB/s) - `state.html.1' saved [85903/85903]
real    0m14.230s
user    0m0.010s
sys     0m0.010s

Run 1 tops:
[tops@clacker] ready > date . nl time push "iwin.nws.noaa.gov" "/iwin/ca/state.html" HTTPget time pull - .
Thu Jul 15 08:22:00 PDT 2004
 HTTPget: host iwin.nws.noaa.gov
 HTTPget: connected to 205.156.51.137
 HTTPget: getting /iwin/ca/state.html
 HTTPget: receiving bytes ...
 HTTPget: received 86156 bytes at 6004 bytes/sec
 HTTPget: closing connection
 1.4777E+01
 stack elements:
       0 volume: _state.html  1 by 86156
 [1] ok!

Run 2 tops:
[tops@clacker] ready > date . nl time push "iwin.nws.noaa.gov" "/iwin/ca/state.html" HTTPget time pull - .
Thu Jul 15 08:22:16 PDT 2004
 HTTPget: host iwin.nws.noaa.gov
 HTTPget: connected to 205.156.51.137
 HTTPget: getting /iwin/ca/state.html
 HTTPget: receiving bytes ...
 HTTPget: received 86156 bytes at 6013 bytes/sec
 HTTPget: closing connection
 1.4762E+01
 stack elements:
       0 volume: _state.html  1 by 86156
       1 volume: _state.html  1 by 86156
 [2] ok!
[tops@clacker] ready >

------------------------------------------------------------------------

HTTPget vs. WGET timing test, April 2008 (DSL).

The National weather summary has grown to over 7 Mb.  Here is fetching
it using Wget and this program's HTTPget on Verizon DSL.  

Wget is smart enough to figure out the new IP address from the old; 
HTTPget had to be given the new one.

Wget:
[dale@plunger] /home/dale > time wget "iwin.nws.noaa.gov/iwin/us/nationalsummary.html"
--12:36:09--  http://iwin.nws.noaa.gov/iwin/us/nationalsummary.html
           => `nationalsummary.html'
Resolving iwin.nws.noaa.gov... done.
Connecting to iwin.nws.noaa.gov[140.90.113.200]:80... connected.
HTTP request sent, awaiting response... 301 Moved Permanently
Location: http://www.weather.gov/view/national.php?prodtype=nationalsummary [following]
--12:36:09--  http://www.weather.gov/view/national.php?prodtype=nationalsummary
           => `national.php?prodtype=nationalsummary'
Resolving www.weather.gov... done.
Connecting to www.weather.gov[140.90.113.200]:80... connected.
HTTP request sent, awaiting response... 200 OK
Length: unspecified [text/html]

    [                                                   <=>       ] 7,749,142     89.83K/s             

12:37:34 (89.83 KB/s) - `national.php?prodtype=nationalsummary' saved [7749142]


real    1m25.555s
user    0m0.140s
sys     0m0.460s
[dale@plunger] /home/dale > 

Total Wget time: 1m25.555s = 85.555 seconds


HTTPget:

[tops@plunger] ready > date . nl time push "http://www.weather.gov" "/view/national.php?prodtype=nationalsummary" HTTPget time pull - .
Sat Apr  5 12:37:47 PDT 2008
 HTTPget: host www.weather.gov
 HTTPget: connected to 140.90.113.200
 HTTPget: /view/national.php?prodtype=nationalsummary
 HTTPget: receiving bytes ...
 HTTPget: received 7749451 bytes at 91899 bytes/sec
 HTTPget: connection closed by host
 8.5428E+01
 stack elements:
       0 volume: _national.php?prodtype=nationalsummary  1 by 7749451
 [1] ok!
[tops@plunger] ready > 

Total HTTPget time: 85.428 seconds

It looks like a draw.  HTTPget time is a shade faster, but Wget was
able to resolve the old address, something HTTPget cannot do.

In network tests, the time probably boils down to how fast the network 
is running and less on how well the two programs run.

\-----------------------------------------------------------------------

Obsolete.

   Word nextport is now a native word in term.c, as this shows:
      [dale@kaffia] /opt/tops/tops/src > grep 'nextport (' *.c
      term.c:int nextport()  /* nextport (nPORT --- nPORT1) */

   inline: nextport (nPort --- nPort1) \ next available port from nPort
\     Tries up to 20 ports, and returns Port1=-1 if no port found.
      [ 20 "max" book ]
      no NUM stkok not IF "nextport" stknot return THEN

      (nPort) "port" book
      port max + "port_max" book

      netstat these chars tic +trailing push
      peek this "LISTEN " grepr reach
      peek this "WAIT" grepr reach pile
      peek this "LAST" grepr reach pile
      peek this "ESTABLISHED" grepr reach pile

      pull drop any?
      IF "listen" book
      ELSE port return
      THEN

      BEGIN listen this port
         intstr grepr reach rows any
         port port_max < and
      WHILE one port bump
      REPEAT

      port port_max >=
      IF -1 (error)
      ELSE port (nPort1)
      THEN
   end

