\ {{{1 GNU General Public License
{
Program Tops - a stack-based computing environment
Copyright (C) 1999-2005  Dale R. Williamson

Author: Dale R. Williamson <dale.williamson@prodigy.net>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
1}}} 
}

{ File recurse.v  July 1999

   Reference: express file recurse.voc

   Some of these have run levels displayed, and they show recursion 
   telescoping out and back again.  

   Word fib1 is really weird; it oscillates up and down before re-
   turning.  Try 12 fib1 nl .i 

   Running 2 58 power nl . uses most of the 128 run levels.
}
   define: factorial (x --- x!)
      (x) dup 1 >                       \ is x > 1?
      IF (x) dup 1-                     \ put x-1 on stack
         (x x-1) factorial (x [x-1]!) * \ (i) x! = x * [x-1]!
\     ELSE (1)                          \ (ii) 1! is 1
      THEN (x!)
   end

\  An inline version of factorial.  Note "fact1" main because fact1
\  has not been created when inlining is being done (using -strict
\  will cause inline1() to create "fact1" main automatically--see
\  fib1 below):
   define: fact1 (x --- x!)
      [ {"
         runlevel .i out 60 > IF nl THEN
         (x) dup 1 >                          \ is x > 1?
         IF (x) dup 1-                        \ put x-1 on stack
            (x x-1) "fact1" main (x [x-1]!) * \ (i) x!=x * [x-1]!
\        ELSE (1)                             \ (ii) 1! is 1
         THEN (x!)
         runlevel negate .i out 60 > IF nl THEN
        "} "fact1" inline ] fact1 run
   end

   inline: fib (n --- Fn)
      dup 2 >
      IF (n) dup 2 - (n-2) fib (F[n-2])
         swap (n) 1- (n-1) fib (F[n-1]) +
      ELSE
         0 > abs
      THEN (Fn)
   end

\  Inline version of fib with display of run levels at top and bottom:
   define: fib1 (n --- Fn)
      [ {"
         runlevel .i out 60 > IF nl THEN
         dup 2 >
         IF (n) dup 2 - (n-2) fib1 (F[n-2])
            swap (n) 1- (n-1) fib1 (F[n-1]) +
         ELSE
            0 > abs
         THEN (Fn)
        runlevel negate .i out 60 > IF nl THEN
        "} "fibx" -strict inline strict ] fibx run
   end

\  Inline version of fib with display of different symbols for the
\  different paths taken during the recursion.
   define: fib2 (n --- Fn)
      [ {"
         dup .i out 60 > IF nl THEN
         dup 2 >
         IF (n) dup 2 - (n-2) fib2 (F[n-2])
            dup .i '*' . out 60 > IF nl THEN
            swap (n) 1- (n-1) fib2 (F[n-1]) +
            dup .i '#' . out 60 > IF nl THEN
         ELSE
            0 > abs
            dup .i '$' . out 60 > IF nl THEN
         THEN (Fn)
        "} "fibx" -strict inline strict ] fibx run
   end

   define: power (x n --- x**n)
      runlevel .i out 60 > IF nl THEN
      dup (n) 0 =            \ does n equal zero?
      IF (x 0) 2drop 1       \ (i) x**0 equals 1
      ELSE (x n) over swap
         (x x n) 1- power *  \ (ii) x**n = x*[x**(n-1)]
      THEN (x**n)
      runlevel negate .i out 60 > IF nl THEN
   end



