#include <stdlib.h>
#include <stdio.h>
#include "stk.h"
#include "main.h"
#include "inpo.h"
#include "tag.h"
int indexed_mat()
{

    int     r, c,
            rows = 4, cols = 5,
           *row_idx, *col_idx;
    char   *name = "A_idx";
    double *A;

    gprintf("-> putting %d x %d indexed matrix '%s' on the stack",
            rows, cols, name); nc();
    matstk_idx(rows, cols, name);
    dup1s();
    show_tag();

    /* populate the numeric terms */
    A = tos->mat;
    for (c = 0; c < cols; c++) 
        for (r = 0; r < rows; r++) 
            A[c*rows + r] = 1000.0 + 10.0*r + c;

    gprintf("the matrix contains: "); nc();
    dup1s();
    dotint(); nc();

    gprintf("-> now enabling the 'use index' tag"); nc();
    set_index_used(tos);
    dup1s();
    show_tag();

    row_idx = MAT_ROW_IDX(tos);
    col_idx = MAT_COL_IDX(tos);

    for (c = 0; c < cols; c++) 
        col_idx[c] = c;
    for (r = 0; r < rows; r++) 
        row_idx[r] = r;

    /* did writing into the index terms corrupt the matrix? */
    gprintf("the matrix contains: "); nc();
    dup1s();
    dotint(); nc();

    return 1;
}
