%{
#include <math.h>   /* For math functions: cos(), sin(), etc. */
%}

%union {
    char txt[200];   /* for returning strings; need to generalize size */
}

%token <txt>  TXT
%type  <txt>  exp

%right '='
%left  '-' '+'
%left  '*' '/'
%right '\''      /* transpose      */
%left  UNEGT     /* unary minus    */
%left  UPLUS     /* unary plus     */
%right '^'       /* exponentiation */

/* Grammar follows */

%%

input : /* empty */
        | input line
;

line : '\n'
       | exp '\n'   { printf( "%s\n", $1); }
       | error '\n' {yyerrok; }
;

/* generated code will claim "a *. b" is a syntax error
      | exp "*." exp         { sprintf($$, "%s %s *by",   $1, $3); }
      | exp "/." exp         { sprintf($$, "%s %s /by",   $1, $3); }
*/

exp : TXT                    { sprintf($$, "%s",          $1);     }
      | exp '='  exp         { sprintf($$, "%s %s is",    $1, $3); }
      | exp '+'  exp         { sprintf($$, "%s %s +",     $1, $3); }
      | exp '-'  exp         { sprintf($$, "%s %s -",     $1, $3); }
      | exp '*'  exp         { sprintf($$, "%s %s *",     $1, $3); }
      | exp '/'  exp         { sprintf($$, "%s %s /",     $1, $3); }
      | '-' exp %prec UNEGT  { sprintf($$, "%s negate",   $2);     }
      | '+' exp %prec UPLUS  { sprintf($$, "%s ",         $2);     }
      | exp '^' exp          { sprintf($$, "%s %s ^",     $1, $3); }
      | exp '\''             { sprintf($$, "%s bend",     $1);     }
      | '(' exp ')'          { sprintf($$, "%s",          $2);     }
;

/* End of Grammar */

%%

int main (void) {
  yyparse ();
}

int yyerror (char *s) {
  printf ("%s\n", s);
}
