#!../../../src/tops
"%22.12e" mformatset
"easy_io.v" source
"sparse.v"  source  # spsubmat

2 is n_partitions
             "../triangle/super7.db"               is model_db
n_partitions "../triangle/super7_P%03.f.db" format is partn_db

define: reduce_partition ( model_db partn_db partn_ID --- Part_<n> )
# man entry:  reduce_partition {{{2
# ( model_db partn_db partn_ID --- Part_<n> ) creates a library called Part_<n> containing matrices and index arrays useful for working with a finite element model partition subscript notation:
# i = interior,  b = boundary
# [ K_ii   | K_ib ]
# [ -------+----- ]
# [ K_ib^T | K_bb ]
# K_interior_LU = LU of K_ii
# K_boundary    = K_bb - K_ib^T * inv(K_ii) * K_ib
# Note:  inv(K_ii) is never explicitly computed.  The product of inv(K_ii) and K_ib is the solution X to the system LU(K_ii) X = K_ib  which can be found with forward and backward substitution
# category: FEA
# related:  fea_assemble
# 2}}}
    is partn_ID
    is partn_db
    is model_db
    model_db partn_db partn_ID fea_assemble is Kgg_L is Mgg_L
    model_db partn_db partn_ID int_ext_dof  is I_glob_ex is I_loc_ex is I_loc_in
    partn_ID "Part_%02.f" format is this_word_name
    this_word_name library

    Kgg_L spflip_sym is Kgg
    Mgg_L spflip_sym is Mgg
    Kgg I_loc_in I_loc_ex spsubmat is Kib
    Kgg I_loc_in I_loc_in spsubmat is Kii
    Kii splu is Kii_LU drop
    Kii_LU    this_word_name "K_interior_LU"  bank
    I_glob_ex this_word_name "I_glob_ex"      bank
    I_loc_ex  this_word_name "I_loc_ex"       bank
    Kii Kii_LU Kib dense spfbs lop lop ( inv(Kii)*Kib )
              dup
              this_word_name "inv_Kii_Kib" bank
    Kib bend swap * (Kib^T * inv(Kii) * Kib)
    Kgg I_loc_ex I_loc_ex spsubmat (Kbb) swap - (Kbb -  Kib^T * inv(Kii) * Kib)
              this_word_name "K_boundary" bank
    this_word_name
;

n_partitions 1 DO 
    # I "working on partition %1.f " format . nl 
    model_db partn_db I reduce_partition
LOOP
