{  File mfg.v  September 2011

   Copyright (c) 2011   D. R. Williamson

   Words for fetching data from MFGlobal Xpress quotes snapshot.

------------------------------------------------------------------------

   Process data from a snapshot of quotes displayed by MFGlobal Xpress 
   in a window on a machine running Windows 7.  

   The Windows machine connects as a client to an NFS (Network File
   System) server on a Linux machine, and periodically places into their
   shared NFS directory a snapshot of the data currently showing in the
   streaming quotes window.

   NFS allows user programs like the snapshot program on the Windows 
   machine, and this one here on a Linux machine, to write and read the
   shared file as if it resides on either local machine.  In reality,
   the shared file actually resides on the Linux machine from the moment
   it is written, because the Linux machine is acting as the NFS server.

   No file transfer between machines ever takes place in NFS.

   Word nfs_load in word mfg_process places the data file on the stack,
   where it is formatted into the standard form for collection output, 
   matching the tables produced by other collector programs like cme.v,
   tch1.v, ino.v and bch.v.

   The file placed on the Linux NFS server by the Windows NFS client,
   called /nfs/solano/mfgquotes.txt, holds a snapshot of price data
   taken in real time.

------------------------------------------------------------------------

   Words

   usrpath "mfg.v" + asciiload this " inline:" grepr reach dot

   Processing data
   inline: BEEP ( --- ) \ error alarm
   inline: BOND (hA qTIME qCON qSYM --- ) \ bond market prices
   inline: DECIMAL (hA qTIME qCON nFAC qSYM --- ) \ decimal prices
   inline: FILE_IN ( --- qFile) \ name of input file
   inline: FILE_OUT (qSYM --- qFile) \ name of output file
   inline: FILE_SEND (qFile --- ) \ send file to remote
   inline: logLAN1 ( --- f) \ report to the head machine over the LAN
   inline: mfg_process ( --- ) \ data from MFGlobal Xpress quotes
   inline: mrc_close ( --- ) \ close market data resources
   inline: mrc_open ( --- f) \ open market data resources on plunger
   inline: PROCESS (hA qTIME qCON qSYM --- ) \ market SYM to file
   inline: SYM_OUT (qFile --- qSYM) \ market symbol from File name

   Collecting data
   inline: COLLECT ( --- ) \ process file from NSF client on Windows
   inline: COLLECT_START ( --- ) \ start multitasker COLLECT
   inline: COLLECT_END ( --- ) \ end multitasker clickRefresh
   inline: START ( --- ) \ depending on time of day, set the start task
   Also see word ALARMmfg in uboot.v at mytops/usr.

------------------------------------------------------------------------
}
   CATMSG push no catmsg

   "scrape" missing IF "mat.v" source THEN
   "MOdo" missing IF "mrc.v" source fence THEN \ will source mfil.v too

\-----------------------------------------------------------------------

\  Processing data

   inline: BEEP ( --- ) \ error alarm
      3 1 DO beep .2 idle beep 1 idle LOOP ;

   inline: BOND (hA qTIME qCON qSYM --- ) \ bond market prices
    \ Sun Sep 18 10:21:10 PDT 2011

    \ Format bond and note prices and write collection file.

      "SYM" book "CON" book "TIME" book 

      SYM MOdo CON <>
      IF (hA) drop
         " BOND: wrong contract for " SYM + . nl return
      THEN

      SYM "US" =
      IF (hA) 10 / THEN \ US (30-year bonds) has one-too-many digits

    \ Sun Sep 25 17:02:07 PDT 2011.
    \ HGET in mfil.v removes entire rows that contain a nonpositive 
    \ price (not price change).  Zero values may now be in A due to
    \ N/A (see mfg_process).  Set zero values for Open and Settle to 
    \ one, to avoid removal if High, Low or Last is not zero.  If High,
    \ Low or Last is zero, then this fix will not help; it will remain
    \ zero and these prices will be rejected by HGET:
      [ list: 1 0 0 1 0 0 ; "R" book ] \ rake for Open, Settle
      (hA) R rake one scrape R tier (hA) 

      (hA) itext chop (hT) "T" book 

      T dup chars 2 + blpad "T" book   \ pad spaces for "c"
      "c" T 5 quote strchop + T 5 said \ c prefix to last price

      date " SESS " + time tsession - 0.5 + integer intstr + (qHEAD)

    \ Send last line of previous file too:
      SYM FILE_OUT (qFile) dup file?
      IF (qFile) asciiload 1 endmost (qPREV) \ previous data
         (qHEAD qPREV) pile
      ELSE drop
      THEN

      SYM CON +
      T
      "----- -----"
      TIME (qTIME)
      4 pilen vol2str neat (qS)

      (qHEAD qS) pile (hT) SYM FILE_OUT save

    \ " BOND: " SYM + " written to " + SYM FILE_OUT + spaced date +
    \ . nl

      SYM FILE_OUT (qFile) FILE_SEND
   end

   inline: DECIMAL (hA qTIME qCON nFAC qSYM --- ) \ decimal prices
    \ Sun Sep 18 10:57:42 PDT 2011

    \ Apply factor, FAC, to decimal data and write collection file.

      "SYM" book "FAC" book "CON" book "TIME" book

      SYM MOdo CON <>
      IF (hA) drop
         " DECIMAL: wrong contract for " SYM + . nl return 
      THEN

      (hA) FAC * integer (hA) 

    \ Sun Sep 25 17:02:07 PDT 2011.
    \ HGET in mfil.v removes entire rows that contain a nonpositive 
    \ price (not price change).  Zero values may now be in A due to
    \ N/A (see mfg_process).  Set zero values for Open and Settle to 
    \ one, to avoid removal if High, Low or Last is not zero.  If High,
    \ Low or Last is zero, then this fix will not help; it will remain
    \ zero and these prices will be rejected by HGET:
      [ list: 1 0 0 1 0 0 ; "R" book ] \ rake for Open, Settle
      (hA) R rake one scrape R tier (hA) 

      (hA) itext chop (hT)

      (hT) dup chars 2 + blpad "T" book \ pad spaces for "c"
      "c" T 5 quote strchop + T 5 said  \ c prefix to last price

      date " SESS " + time tsession - 0.5 + integer intstr + (qHEAD)

    \ Send last line of previous file too:
      SYM FILE_OUT (qFile) dup file? 
      IF (qFile) asciiload 1 endmost (qPREV) \ previous data
         (qHEAD qPREV) pile 
      ELSE drop
      THEN 

      SYM CON +
      T
      "----- -----"
      TIME (qTIME)
      4 pilen vol2str neat (qS) 

      (qHEAD qS) pile (hT) SYM FILE_OUT save

    \ " DECIMAL: " SYM + " written to " + SYM FILE_OUT + spaced date +
    \ . nl

      SYM FILE_OUT (qFile) FILE_SEND
   end

   inline: FILE_IN ( --- qFile) \ name of input file
    \ Mon Sep 19 08:17:46 PDT 2011
      [ "" dup "PATH" book "FILE" book

        host "plunger" =
        IF "/nfs/solano/" "PATH" book "mfgquotes.txt" "FILE" book THEN

        host "riggo" =
        IF "/nfs/solano/" "PATH" book "mfgquotes.txt" "FILE" book THEN

        PATH FILE + file? not
        IF " FILE_IN: file " FILE + " not found, halting" + . nl
           HALT
        THEN
      ]
      PATH FILE + dup (qFile) file? not
      IF " FILE_IN: file " swap + " not found " + date + . nl
         "" (qFile) \ file not found, return empty string
      THEN (qFile)
   end

   inline: FILE_LOG ( --- qFile) \ name of log file
    \ Mon Sep 19 08:25:05 PDT 2011

      [ "FILE_IN" "PATH" yank "mfg_process.log" + "LOG" book ]
      LOG
   end

   inline: FILE_OUT (qSYM --- qFile) \ name of output file
    \ Wed Sep  7 14:30:22 PDT 2011

    \ Make PATH_OUT equal to "/tmp1/" during testing; see "testing and 
    \ debugging" below.

      [ "/tmp/" "PATH_OUT" book ]
        PATH_OUT "MKT_MFG.eDAT" + "MKT" rot uppercase strp
   end

   inline: FILE_SEND (qFile --- ) \ send file to remote
    \ Wed Sep  7 15:13:14 PDT 2011

      (qFile) dup -filename "/tmp1/" = 
      IF " FILE_SEND: testing; file " swap + " not sent" + . nl
         return
      THEN
      
      "mrc_open" "REMOTE" yank "REMOTE" book

      "FILE" book

      FILE file? not
      IF " FILE_SEND: file " FILE + " not found" + . nl return THEN

      "mrc_open" "S" yank "S" book 
      "mrc_open" "S1" yank "S1" book 

    \ Tue Oct 11 06:12:43 PDT 2011.  Word COLLECT runs remoterun1; do
    \ not allow it to run since remoterun1 is also run below:
      "COLLECT" SLEEP \ don't want this to run during remoterun1()

      S -1 >
      IF host "plunger" <>
         IF SYSOUT "SYSOUTsav" book
            ftempsys (qLOG) dup "ERRLOG" book (qLOG) set_sysout

            FILE FILE S fremoteput (f) 

            (f) dup false =
            IF " FILE_SEND: error sending " FILE + 
               "; see ERRLOG below:" + . nl
               ERRLOG asciiload (hT) 3 indent . nl
            THEN (f)

            ERRLOG deleteif
            SYSOUTsav set_sysout \ back to regular output
            (f)
         ELSE true
         THEN (f)

         IF " FILE_SEND: OK " FILE + " to " + REMOTE + date + . nl
            S1 -1 >
            IF
{              Make a string to run on REMOTE that will add a job to 
               the collector queue that will update the history file 
               with the data just sent.  A typical string to do this 
               is: "eGC-COLLECT" "hist" localref ptr queue_add1 for 
               market symbol GC.

               Word queue_add1 on the remote will add a market's job 
               to the queue if there isn't another one already there.  
               Another job for a market would be one the collector 
               fetched.  When that queued job is run, the file just 
               written will be processed along with the ones made by 
               the collector.

               The collector job on REMOTE is presently on socket S1 
               connected to REMOTE.
}
               "eXX-COLLECT" "XX" FILE SYM_OUT strp quoted spaced
               "hist" quoted + " localref ptr queue_add1 ACK" + (hT)

               (hT) depth 1- push \ depth without T

               "remoterun1" "SEC" yank "SECsav" book

               SEC "remoterun1" "SEC" bank [ 10 "SEC" book ]
               (hT) S1 remoterun1 
               SECsav "remoterun1" "SEC" bank

               depth pull > \ has depth increased?
               IF (f)
                  IF " FILE_SEND: " FILE SYM_OUT + 
                     " update queued on " + REMOTE + date + . nl

                  ELSE " FILE_SEND: " FILE SYM_OUT + 
                     " update queue error on " + REMOTE + date + . nl
                     BEEP
                  THEN
               ELSE " FILE_SEND: " FILE SYM_OUT + 
                  " remoterun1 time out " + REMOTE + date + . nl
                  BEEP
               THEN
            THEN

         ELSE " FILE_SEND: error sending " FILE + " to " + 
            REMOTE + date + . nl BEEP
         THEN
      ELSE " FILE_SEND: not connected to " REMOTE + date + 
         . nl BEEP
      THEN 

      "COLLECT" WAKE
   end

   inline: logLAN1 ( --- f) \ report to the head machine over the LAN
      "mrc_open" "REMOTE" yank "mrc_open" "PORT" yank
      (qIP nPORT) logLAN (f)
      IF mrc_open (f)
      ELSE false
      THEN (f)
   end

   inline: mfg_process ( --- ) \ data from MFGlobal Xpress quotes
{     Sun Sep 18 08:08:36 PDT 2011

      Process data from MFGlobal quotes snapshot, and write files in 
      /tmp that match files from the regular collectors, so they will 
      be picked up when hist_add() runs to append latest data to each 
      market's history file.

      This word parallels word cme_process() in file cme.v, used as a 
      template.  Many other words in this file come from cme.v with
      few changes.
}
      [ list: \ Market symbols (this program's symbols shown on right):
           ZN \ TN 10-year Treasury Notes
           ZB \ US 30-year Treasury Bonds
           YC \ CL Crude Oil
           YH \ HG High Grade Copper
           YG \ GC Gold Comex
           Y2 \ EU Euros
           S2 \ SF Swiss Francs
           J2 \ JY Japanese Yen
           ZJ \ DJ Dow Jones Industrial Average
           ES \ SP Standard and Poors Stock Index
           NQ \ NQ Nasdaq Stock Index
        end words noq_alike "SYM_TABLE" book
{ 
      \ Put desired symbols and uncomment this segment for debugging:
        list: \ Market symbols (this program's symbols shown on right):
           S2 \ SF Swiss Francs
           ZB \ US 30-year Treasury Bonds
        end words noq_alike "SYM_TABLE" book
}       
      \ Fetch the price rows from U (see "rows of U" below) in the 
      \ order: Open, High, Low, Settle, Last, Change (since there is 
      \ no Settle, use Last):
        list: 5 4 3 2 2 1 ; \ open, high, low, settle, last, change
        (hA) ndx "Urake" book
      ]
    \ This word runs when newer FILE_IN is detected in COLLECT.
      " mfg_process: begin " date + . nl

      FILE_IN any?
      IF (qFile) nfs_load textget asciify chop noblanklines (hT)
         dup noblanklines rows 0> not
         IF drop " mfg_process: FILE_IN has no data " date + . nl
            mrc_close return
         THEN
      ELSE \ input file not found
         " mfg_process: FILE_IN not found " date + . nl
         mrc_close return 
      THEN
      (hT) "T" book

    \ Get the time.  FILE_IN is written as soon as a snapshot is taken.
    \ Take the time it is written as the time of the prices it contains
    \ and convert to LA time, the convention for all collected data:
      FILE_IN filetime (nt)
      (nt) time time1 - + (nUTC) \ add correction
      (nUTC) LAdiff + (nLA) time_breakdown (qHH:MM:SS) "TIME" book

    \ Loop over T for each symbol and extract its data:
      SYM_TABLE rows 1st
      DO SYM_TABLE I quote strchop "SYM" book

         T dup SYM grepr any? 
         IF (hT hR) @ 6 items reach "R" book
{
            When SYM = ZN, here are the rows of R (with notes added
            after the backslash); rows of U are rows 2 - 6 of R:

               ZN Z11
               +90    \ Change U(1)
               129245 \ Last   U(2)
               129060 \ Low    U(2)
               129255 \ High   U(4)
               129165 \ Open   U(5)

             Below is a case for YC after hours, when prices have been
             marked N/A:
               YC V11
               N/A 
               N/A
               N/A
               N/A
               N/A
}
            R "N/A" "0" strp numerate dup rows 1 >
            IF (hU) "U" book 
               U rows 5 = U 2nd pry (Last) 0> and
               IF \ have five rows of numbers

                \ Get the contract:
                  R 1st quote 2nd word (f)
                  IF (qS) "CON" book

                   \ Fetch the price rows from U in the order 
                   \   Open, High, Low, Settle, Last, Change
                     U Urake reach (hA) 
{
                     After fetching price rows in the order of Urake,
                     here is A on the stack for the example of ZN above:

                        [tops@plunger] ready > (hA) itext .
                          129165 \ Open
                          129255 \ High
                          129060 \ Low
                          129245 \ Settle
                          129245 \ Last
                          90     \ Change
}
                   \ Process this market and write its file:
                     (hA) TIME CON SYM PROCESS
                  ELSE " mfg_process: CON missing in R for " SYM + . nl
                  THEN
               ELSE " mfg_process: data missing in R for " SYM + . nl
               THEN
            ELSE (hU) drop 
               " mfg_process: data empty in R for " SYM + . nl
            THEN
         ELSE (hT) drop
            " mfg_process: no data in T for " SYM + . nl
         THEN
      LOOP

    \ Write the time of processing to a log file:
      time intstr (nt) FILE_LOG (qFile)
      (nt qFile) save \ time log for ALARMmfg

      mrc_close \ close resources
   end

   inline: mrc_close ( --- ) \ close market data resources
      "mrc_open" "S" yank sclose
      -1 "mrc_open" "S" bank

      "mrc_open" "S1" yank sclose
      -1 "mrc_open" "S1" bank

      " mrc_close: sockets closed " date + . nl
   end

   inline: mrc_open ( --- f) \ open market data resources on plunger
    \ Mon Sep 19 11:37:05 PDT 2011

      [ host "plunger" =
        IF IPloop ELSE plunger THEN spaced "REMOTE" book 
        "plunger" "p0" yank 80 + "PORT" book \ http on plunger

        -1 "S" book  \ socket to HTTP server
        -1 "S1" book \ socket to collector topse

        0 "E_PORT" book

        {" topse_port( -- f) \ fetch topse port on the collector machine

           REMOTE PORT CLIENT "S" book \ socket to HTTP server
           "TOPSE_SERVER" S msgPeekSocket (qPort) any?
           IF number (no || nPort yes)
              IF "E_PORT" book true
              ELSE " mrc_open: bad port number from " 
                 REMOTE + date + . nl false 
              THEN
           ELSE " mrc_open: error fetching port from " 
              REMOTE + date + . nl false
           THEN (f)
        "} "topse_port" macro

      \ Collector topse must already be running on the collector ma-
      \ chine when this file is sourced.  Fetch its port:
        topse_port (f) 
        IF S sclose -1 "S" book
        ELSE " mfg.v: failed to fetch topse port; HALTING" . nl HALT
        THEN
      ]
      sockets sclose \ close any connections (there should be none)

      REMOTE PORT CLIENT "S" book

      S -1 >
      IF host "plunger" <>
         IF SYSOUT "SYSOUTsav" book
            ftempsys (qLOG) dup "ERRLOG" book (qLOG) set_sysout

            "/mdat/latest.dat" mpath "latest.dat" + S fremoteget (f1)
            "/mdat/con.dat"    mpath "con.dat" + S fremoteget (f2)

            SYSOUTsav set_sysout \ back to regular output
         ELSE true true (f1 f2)
         THEN

         (f1 f2) and
         IF " mrc_open: OK files from " REMOTE + date + . nl

          \ Connect to the collector on REMOTE:
            -1 "S1" book
            E_PORT any?
            IF (nPort) REMOTE swap CLIENT "S1" book S1 -1 >
               IF true (f)
               ELSE " mrc_open: cannot connect to collector on " 
                  REMOTE + date + . nl 

                \ Maybe topse was restarted and it is on a different
                \ port now.  Force topse_port to run next time:
                  0 "E_PORT" book 

                  false (f)
               THEN
            ELSE " mrc_open: fetching E_port" . nl
               topse_port (f) 
               IF mrc_open (f)
               ELSE BEEP false (f)
               THEN
            THEN
         ELSE " mrc_open: error fetching files from " REMOTE + 
            date + . nl 
            ERRLOG asciiload 2 indent . nl 
            BEEP false (f) 
         THEN
      ELSE " mrc_open: cannot connect to " REMOTE + date + . nl
         BEEP false (f)
      THEN (f)

      ERRLOG deleteif
   end

   inline: PROCESS (hA qTIME qCON qSYM --- ) \ market SYM to file
    \ Sun Sep 18 10:11:08 PDT 2011

    \ Incoming SYM is the mfg symbol; file created will use the
    \ program's symbol.

      "SYM" book

      SYM "Y2" = IF (hA qTIME qCON) 0.1 "EU" DECIMAL return THEN
      SYM "S2" = IF (hA qTIME qCON) 0.1 "SF" DECIMAL return THEN
      SYM "J2" = IF (hA qTIME qCON) 0.1 "JY" DECIMAL return THEN

      SYM "ZJ" = IF (hA qTIME qCON) 1   "DJ" DECIMAL return THEN
      SYM "ES" = IF (hA qTIME qCON) 0.1 "SP" DECIMAL return THEN
      SYM "NQ" = IF (hA qTIME qCON) 0.1 "NQ" DECIMAL return THEN

      SYM "ZB" = IF (hA qTIME qCON) "US" BOND return THEN
      SYM "ZN" = IF (hA qTIME qCON) "TN" BOND return THEN

      SYM "YC" = IF (hA qTIME qCON) 1 "CL" DECIMAL return THEN
      SYM "YH" = IF (hA qTIME qCON) 1 "HG" DECIMAL return THEN
      SYM "YG" = IF (hA qTIME qCON) 1 "GC" DECIMAL return THEN
   end

   inline: SYM_OUT (qFile --- qSYM) \ market symbol from File name
      (qFile) "FILE_OUT" "PATH_OUT" yank "" strp (qSYM)
      (qSYM) "_MFG.eDAT" "" strp (qSYM)
   end

\-----------------------------------------------------------------------

\  Collecting data

   inline: COLLECT ( --- ) \ collect data from NSF client on Windows
    \ Mon Sep 19 08:19:33 PDT 2011

    \ Perform another collection if FILE is new.

      [ FILE_IN "FILE" book, -1 "FTIME" book ]
{
 After this incident, logLAN was modified to abort if the machine
 is LOCKED and the following phrases were removed from here:

    \ Tue Oct 11 06:12:43 PDT 2011.  Word logLAN1 will run logLAN which
    \ runs remoterun1.  Do not continue if program is locked:
      LOCKED IF " COLLECT: returning; program is LOCKED" . nl THEN

 COLLECT: returning; program is LOCKED
 COLLECT: returning; program is LOCKED
 COLLECT: returning; program is LOCKED
 COLLECT: returning; program is LOCKED
 exit: code 1 received on level 13, Thu Oct 13 05:55:44 PDT 2011
 Jmp table at lev 13
  lev   ret  typ  Lib:lib
  13     4    1     0:remoterun1
  12     2    1     0:remoterun1
  11     2    1     0:logLAN
  10     2    1     0:logLAN1
   9     2    1     0:COLLECT
   8     5    1     0:CLIENT
   7     2    1     0:CLIENT
   6     2    1     0:mrc_open
   5     2    1     0:logLAN1
   4     2    1     0:COLLECT
   3     9    1     0:console
   2     2    1     0:console
   1     1    2     0:DATA__
 exit: attempting to return to lower levels
 remoterun1: 30 second wait has passed
 logLAN: error sending log Thu Oct 13 05:55:30 PDT 2011
 COLLECT: LAN connection failed Thu Oct 13 05:55:30 PDT 2011
 mrc_close: sockets closed Thu Oct 13 05:55:30 PDT 2011
 COLLECT: returning; program is LOCKED
 COLLECT: returning; program is LOCKED
 COLLECT: returning; program is LOCKED
 COLLECT: returning; program is LOCKED
}

      soonest_task (f) \ true if in a collection period
      IF FILE filetime (nt) dup FTIME <>
	 IF (nt) "FTIME" book \ file time has changed

	    logLAN1 (f)       \ open the link to head machine
	    IF mfg_process    \ process data and send to head machine

	    ELSE \ connect to LAN failed; try again next time
	       " COLLECT: LAN connection failed " date + . nl
               mrc_close
{
 The program recovered from error fetching port number:

 logLAN: OK Mon Sep 19 11:36:02 PDT 2011
 mrc_open: OK files from 127.0.0.1 Mon Sep 19 11:36:03 PDT 2011
 mrc_open: error fetching port from 127.0.0.1 Mon Sep 19 11:36:03 PDT...
 COLLECT: LAN connection failed Mon Sep 19 11:36:07 PDT 2011

 logLAN: OK Mon Sep 19 11:37:01 PDT 2011
 mrc_open: OK files from 127.0.0.1 Mon Sep 19 11:37:03 PDT 2011
 mfg_process: begin Mon Sep 19 11:37:05 PDT 2011
 FILE_SEND: OK /tmp/TN_MFG.eDAT to 127.0.0.1 Mon Sep 19 11:37:05 PDT ...
...

 But mrc_open was revised to fetch port number once during start up to
 remove this potentially weak link of fetching every time.

}
	    THEN
	 ELSE (nt) drop
	 THEN
      THEN
   end
   
   inline: COLLECT_START ( --- ) \ start multitasker word COLLECT
    \ Fri Sep 16 14:47:26 PDT 2011
      [ 0 "SOONER" book 
        1 2 / "HZ" book ]

    \ Set an alarm to run COLLECT_END:
      time soonest_end SOONER - (sec)
      " COLLECT_START: collection ends in about "
      over 3600 / 0.5 + integer intstr + " hours" + . nl
      (sec) "COLLECT_END" ALARM

    \ Remove old files:
      " COLLECT_START: removing old *MFG.eDAT files from /tmp" . nl
      "/bin/rm /tmp/*MFG.eDAT" shell

    \ Start word COLLECT running at frequency HZ:
      " COLLECT_START: starting multitasker word COLLECT at " 
      HZ "%3.1f" format + " Hz" + . nl 
      "COLLECT" WAKE
   end
   "COLLECT_START" "HZ" yank "COLLECT" TASK

   inline: COLLECT_END ( --- ) \ end multitasker word COLLECT
      [ 60 "LATER" book ]

      "COLLECT" SLEEP

    \ Set an alarm to run COLLECT_START:
      time soonest_start LATER + (sec)
      " COLLECT_END: " date + ", collection begins in " +
      over 60 / 0.5 + integer intstr + " minutes" + . nl
      (sec) "COLLECT_START" ALARM
   end

   inline: START ( --- ) \ depending on time of day, set the start task
      " START: running NIST_SYNC ... " date + . nl
      NIST_SYNC \ sync the program time with NIST

    \ Next time, and every time thereafter, run NIST_SYNC in the lull
    \ between 14:45 and 15:00 (LA) time:
      "14:50:00" "todayat" >stk (n qT) chars 0>
      IF (n) drop "38:50:00" todayat THEN (n) "NIST_SYNC" ALARM

      soonest_task (f) IF COLLECT_START ELSE COLLECT_END THEN
   end

   pull catmsg

\  For testing and debugging, uncomment the following line:
\  "/tmp1/" "FILE_OUT" "PATH_OUT" bank " WORKING IN TEST MODE" . nl halt

\  Then set SYM_TABLE in mfg_process to the market to test, and run
\     "mfg.v" source mfg_process halt
\  with HALT placed at various locations to find the bug.

\-----------------------------------------------------------------------

   START nl tasks

   private halt
