\ File qconset.v in /opt/mytops/usr/ 

\ August 2009

\-----------------------------------------------------------------------

\ This file contains settings for clients that can be pasted at the qcon
\ prompt, or that can be run at the qcon prompt using word qconset.

\ Settings specific to selected clients are made to cause them to sound
\ alarms or perform tasks.

\ Word soundon in qcon.v sources this file.

   " qconset: setting clients" . nl
{
   General notes.

      Run "yes scq" to make voice alerts (like stops) and wcq commands 
      work even with sound turned off (see word scq in mobius.n).

      Note that "yes rngset" works only when sound is off and "yes scq"
      has been run.

      WARNING: Running word sleep (uboot.v) turns scq off, and relevant
      CQ items from this file that need to be on during sleep must be
      rerun, like "yes scq" and "yes rngset" (perhaps by sourcing this
      file).  For example, word sleep causes qcon to run "soundoff,
      scqoff" on all the clients.  Sound off might be ok--in fact this
      is the only way the phone alarm, word ringme, works--but "yes scq"
      must be run to reverse the effect of scqoff and allow wcq and
      ringme to work.

      Word rngset sets the flag for ringme, but will only phone if the
      sound is off.  See notes in word ringme, file mobius.n.

      Here are some of the names in word signal (file mobius.n) that 
      word wcq can respond to (lines below the first one may contain 
      words that are no longer used; see word signal in mobius.n):

         newlow newhigh +bstop -bstop +sstop -sstop 
         sierra102 sierra101 delta102 delta101 bravo102 bravo101

         Curve crossings:
         echo1 echo2 (Q1, dark dumpster green)
         lima1 lima2 (Q3, delft blue)
         midfielder1 midfielder2 (M, burnt sienna)
         belowtrmain abovetrmain (A, tank) 
         able1 able2 (R2, rust)
         baker1 baker2 (R1, coffee)
         foxtrot1 foxtrot2 (A1, cadmium orange)
         tango1 tango2 (A2, red)

------------------------------------------------------------------------
}
 \ Initialization:
   "wcqreset no rngset" setclients_all \ zero-out everyone
   "yes scq" setclients_all

   "no 'sigCQ' 'CQ' bank" setclients_all  \ sound a pulse
 \ "yes 'sigCQ' 'CQ' bank" setclients_all \ sound Morse code CQ

   "ALL_MKT" exists? 
   IF ALL_MKT ELSE "eu sf jy cl hg gc dj sp nq us tn" THEN
   "ALL_CLI" book

 \ General definitions (Wed Jan 25 15:55:40 PST 2012):

   " yes 'delta101' wcq " "DELTA101" book 

   " yes 'able1' wcq " "ABLE1" book 
   " yes 'able2' wcq " "ABLE2" book 

   " yes 'baker1' wcq " "BAKER1" book 
   " yes 'baker2' wcq " "BAKER2" book 

   " yes 'foxtrot1' wcq " "FOXTROT1" book 
   " yes 'foxtrot2' wcq " "FOXTROT2" book 

   " yes 'keeper1' wcq " "KEEPER1" book 
   " yes 'keeper2' wcq " "KEEPER2" book 

   " yes 'keystone1' wcq " "KEYSTONE1" book 
   " yes 'keystone2' wcq " "KEYSTONE2" book 

   " yes 'tango1' wcq " "TANGO1" book 
   " yes 'tango2' wcq " "TANGO2" book 

   " yes 'newlow' wcq, yes 'newhigh' wcq " "NEWHL" book

 \ Paste the following at the qcon % prompt to source this file:
 \    qconset

 \ Running soundon at the qcon % prompt will source this file,
 \ but should only be done if sound should be on; see note above
 \ about sleep.

\-----------------------------------------------------------------------

\  Fri Mar 16 08:34:53 PDT 2012
   KEYSTONE1 KEYSTONE2 + setclients_all

   halt

\-----------------------------------------------------------------------

\  Mon Feb  6 13:00:26 PST 2012
   ABLE1 BAKER1 + FOXTROT1 + TANGO1 + DELTA101 + setclients_all

   halt

\  Mon Jan 30 06:53:32 PST 2012
\  FOXTROT1 TANGO1 + setclients_all

\  Wed Jan 25 15:55:40 PST 2012
\  ABLE1 ABLE2 + BAKER1 + BAKER2 + FOXTROT1 + FOXTROT2 +
\  KEEPER1 + KEEPER2 + TANGO1 + TANGO2 + setclients_all

   halt

\  Mon Jan 23 10:29:53 PST 2012
   SIERRA101+DOT1 SIERRA101+DOT2 + setclients_all
   SIERRA102+DOT1 SIERRA102+DOT2 + setclients_all
   BRAVO101+DOT1 BRAVO101+DOT2 + setclients_all
   BRAVO102+DOT1 BRAVO102+DOT2 + setclients_all

\  TANGO1 FOXTROT1 + setclients_all \ Tue Jan 17 11:27:57 PST 2012

\  BRAVO101 SIERRA101 + setclients_all \ Thu Dec  8 16:51:14 PST 2011
\  BRAVO102 SIERRA102 + setclients_all \ Tue Dec 13 06:49:35 PST 2011
\  BRAVO103 SIERRA103 + setclients_all \ Tue Dec 13 06:49:35 PST 2011

\  DELTA101 DELTA102  + DELTA103 +     \ Wed Dec 28 21:40:36 PST 2011
\  BAKER101 + ABLE101 + setclients_all \ Mon Jan  2 20:00:03 PST 2012

 \ BRAVO101 SIERRA102 + setclients_all \ Sun Nov 27 10:19:07 PST 2011
 \ DELTA101 DELTA102 + setclients_all \ Mon Sep 26 09:32:09 PDT 2011
 \ BRAVO102 SIERRA101 + setclients_all \ Mon Sep 26 07:47:09 PDT 2011

 \ DOT1 DOT2 + FOXTROT1 + TANGO2 + setclients_all

halt

\-----------------------------------------------------------------------

   FOXTROT1 TANGO1 + setclients_all

   MIDFIELDER1 MIDFIELDER2 + setclients_all
   ECHO1 LIMA1 + setclients_all

   FOXTROT1 TANGO1 + setclients_all
   ECHO6 LIMA6 + setclients_all
   
   FOXTROT1 "eu sf cl hg gc" setclients 
   FOXTROT1 "us tn" setclients 

halt

   ECHO2 ALL_CLI setclients 
   LIMA1 ALL_CLI setclients 

   ALL_CLI "CLI" book
   BRAVO101 CLI setclients 
   SIERRA102 CLI setclients 

halt 

 \ ECHO3 "gc" setclients \ Thu Jun 10 14:19:46 PDT 2010
 \ ECHO7 "gc" setclients \ Sun Jun 13 16:37:48 PDT 2010

halt

   \ABLE BAKER + DELTA101 + setclients_all
   \DELTA101 setclients_all
   \BRAVO101 setclients_all
   \SIERRA102 setclients_all
   \ECHO LIMA + MID + setclients_all
   \MID setclients_all
   \ABLE BAKER + ECHO + LIMA + setclients_all
   ABLE BAKER + setclients_all

halt

\-----------------------------------------------------------------------

 \ Mon May 17 11:46:50 PDT 2010

   ABLE "eu sf" setclients

   BRAVO102 "eu sf" setclients

   BAKER "dj sp nq" setclients
   DOT1 "dj sp nq" setclients

   BRAVO102 "cl hg" setclients

halt

------------------------------------------------------------------------

 \ General definitions and initialization:
   "yes 'lima1' wcq yes 'lima2' wcq " "LIMA" book
   "yes 'echo1' wcq yes 'echo2' wcq " "ECHO" book

   "yes 'belowtrmain' wcq yes 'abovetrmain' wcq " "MAIN" book
   "yes 'tango1' wcq yes 'tango2' wcq " "TANGO" book


   "wcqreset no rngset" setclients_all \ zero-out everyone
   "yes scq" setclients_all

------------------------------------------------------------------------

halt

 \ Feb 18 15:59:17 PST 2010

   LIMA "eu sf jy us tn" setclients
   ECHO "dj sp nq" setclients

   MAIN TANGO + "gc" setclients

halt

 \ Tue Feb  2 06:59:33 PST 2010
   "wcqreset no rngset" setclients_all \ zero-out everyone
   "yes scq" setclients_all
   "yes 'lima2' wcq yes 'echo1' wcq" setclients_all

halt

 \ Sun Jan 31 18:46:03 PST 2010
   "wcqreset no rngset" setclients_all \ zero-out everyone
   "yes scq" setclients_all
   \"yes 'newlow' wcq yes 'newhigh' wcq " setclients_all
   "yes 'lima2' wcq" "cl hg gc sf" setclients
  

halt

 \ Tue Jan 26 18:35:09 PST 2010
   "wcqreset no rngset" setclients_all \ zero-out everyone
   "yes scq" setclients_all
   "yes 'newlow'  wcq " 
   "yes 'newhigh' wcq " + setclients_all

halt

 \ Dec 10 21:44:58 PST 2009

   "wcqreset no rngset" setclients_all \ zero-out everyone
   "yes scq" "cl hg gc" setclients
   "yes 'belowtrmain' wcq "
   "yes 'abovetrmain' wcq " + "cl hg gc" setclients

halt

 \ Dec 10 19:16:34 PST 2009
   "wcqreset no rngset" setclients_all \ zero-out everyone
   "yes scq yes rngset" setclients_all
   "yes 'belowtrmain' wcq "
   "yes 'abovetrmain' wcq " + setclients_all

halt
   
 \ Sun Dec  6 18:49:56 PST 2009
   "yes scq" "gc" setclients \ went off at 12:55 AM
   "no scq" "gc" setclients \ turn it off 

halt

 \ Wed Nov 18 09:26:01 PST 2009
   "wcqreset no rngset" setclients_all \ zero-out everyone
   "yes 'upcoming+tango1' wcq yes 'upcoming+tango2' wcq " 
   "yes 'tango1' wcq yes 'tango2' wcq " + setclients_all

halt

 \ Tue Nov 10 12:21:13 PST 2009
   "wcqreset no rngset" setclients_all \ zero-out everyone
   "yes 'newlow' wcq yes 'echo1' wcq" "us tn cl hg gc" setclients
halt

 \ Tue Nov  3 17:46:26 PST 2009
   "wcqreset no rngset" setclients_all \ zero-out everyone
   "yes scq yes rngset" setclients_all
   "yes dup 'newlow' wcq 'newhigh' wcq" "gc" setclients

halt

 \ Tue Sep 29 18:53:12 PDT 2009
   "wcqreset no rngset" setclients_all \ zero-out everyone
   "yes scq yes rngset" setclients_all
   "yes 'bravo101' wcq" "eu sf jy" setclients
   "yes 'bravo101' wcq" "dj sp nq" setclients
   "yes 'delta102' wcq" "dj sp nq" setclients
   "yes 'delta101' wcq" "us tn" setclients
   "yes 'delta101' wcq" "hg" setclients

halt

 \ Mon Sep 28 16:38:15 PDT 2009
   "wcqreset no rngset" setclients_all \ zero-out everyone
   "yes scq yes rngset" setclients_all

   "yes 'delta101' wcq" "jy" setclients
   "yes 'delta102' wcq" "hg" setclients
   "yes 'sierra101' wcq" "gc" setclients
   "yes 'delta101' wcq" "dj sp nq us tn cl" setclients

halt

 \ Sun Sep 27 20:39:46 PDT 2009
   "wcqreset no rngset" setclients_all \ zero-out everyone
   "yes scq yes rngset" setclients_all
   "yes 'delta102' wcq, yes 'sierra101' wcq" "eu sf" setclients
   "yes 'delta102' wcq, yes 'sierra101' wcq" "dj sp nq" setclients
   "yes 'delta101' wcq, yes 'bravo101' wcq" "jy us tn" setclients
   "yes 'delta102' wcq, yes 'sierra101' wcq" "cl hg gc" setclients

halt

 \ Thu Sep 24 19:43:00 PDT 2009
   "wcqreset no rngset" setclients_all \ zero-out everyone
   "yes scq yes rngset" setclients_all

   "yes 'sierra101' wcq, yes 'upcoming+sierra101' wcq " 
   "yes 'sierra102' wcq, yes 'upcoming+sierra102' wcq " + 
      "dj sp nq cl hg gc" setclients

halt

 \ Thu Sep 24 05:19:54 PDT 2009
   "wcqreset no rngset" setclients_all \ zero-out everyone
   "yes scq yes rngset" setclients_all

   "yes 'sierra103' wcq, yes 'bravo101' wcq" setclients_all
   "yes 'jammer' wcq, yes 'gainer' wcq" setclients_all

halt

 \ Tue Sep 22 07:45:59 PDT 2009
   "wcqreset no rngset" setclients_all \ zero-out everyone
   "yes scq yes rngset" setclients_all
   "yes 'jammer' wcq" setclients_all
   "yes 'gainer' wcq" setclients_all
   "yes 'delta101' wcq yes 'upcoming+delta101' wcq" "jy" setclients

halt

 \ Thu Sep 17 19:58:21 PDT 2009
   "wcqreset no rngset scqoff" setclients_all \ zero-out everyone
   "yes scq yes rngset" "eu sf jy dj sp nq us tn cl hg gc" setclients 
   "yes 'upcoming+sierra101' wcq" 
      "eu sf jy dj sp nq cl hg gc" setclients
   "yes 'upcoming+bravo101' wcq" "us tn" setclients

halt

 \ Thu Sep 17 07:26:37 PDT 2009
   "wcqreset no rngset scqoff" setclients_all \ zero-out everyone
   "yes scq yes rngset" "dj sp nq cl hg gc" setclients 
   "yes 'upcoming+bravo101' wcq" "eu sf dj sp nq cl hg gc" setclients
   "yes 'upcoming+sierra101' wcq" "us tn jy" setclients

halt

 \ This word used to be in file mobius.n:
   inline: wcq1 (f1 f2 qS --- ) \ set selected signals in signal.WCQ
{     This word can be run from the real time server (file qcon.v)
      using phrases like these:
         "no yes 'a' wcq1" "dj sp nq cl hg gc" setclient
         "yes dup 'f' wcq1" setclients_all

      Use wcq() for signals not in this word.

      Run "yes scq" to make these work even with sound turned off.
      Run .a1 to see ALERTFILE settings like scq, rng.
}
      (qS) strchop "S" book
      (f1 f2) "f2" book "f1" book

      S "B" = IF f1 "bravo101"  wcq f2 "bravo102"  wcq return THEN
      S "D" = IF f1 "delta101"  wcq f2 "delta102"  wcq return THEN
      S "S" = IF f1 "sierra101" wcq f2 "sierra102" wcq return THEN
   end

 \ Tue Sep 15 19:54:56 PDT 2009
   "yes yes 'B' wcq1" "eu sf dj sp nq cl hg gc" setclients
   "yes yes 'D' wcq1" "eu sf dj sp nq cl hg gc" setclients

halt

 \ Thu Sep 10 20:40:48 PDT 2009
   "wcqreset no rngset scqoff" setclients_all \ zero-out everyone
   "yes dup 'g' wcq1" "gc hg" setclients
   "yes scq yes rngset" "gc hg" setclients 

halt

 \ Thu Sep 10 16:32:14 PDT 2009
   "yes dup 'g' wcq1" setclients_all
   "yes yes 'b' wcq1" "us tn jy cl hg gc" setclients
   "yes yes 'a' wcq1" "us tn jy cl hg gc" setclients
   "yes scq yes rngset" "gc nq hg" setclients 

halt

 \ Fri Sep  4 08:14:43 PDT 2009
   "yes yes 'a' wcq1" "dj sp nq" setclients
   "yes yes 'b' wcq1" "us tn jy" setclients

 \ Thu Sep  3 10:59:36 PDT 2009
   "yes no 'l' wcq1" setclients_all
   "yes no 'e' wcq1" setclients_all
   "yes scq yes rngset" setclients_all \ works only when sound is off

halt

 \ Thu Aug 27 06:47:31 PDT 2009
   "yes yes 'l' wcq1" setclients_all
   "yes yes 'e' wcq1" setclients_all
   "yes scq" setclients_all

halt

 \ Mon Aug 24 18:21:54 PDT 2009
   "no yes 'a' wcq1" setclients_all \ yes able2
   "yes no 'b' wcq1" setclients_all \ yes baker1
   "yes scq" setclients_all

halt

 \ Thu Aug 13 18:13:16 PDT 2009
   "wcqreset" setclients_all \ zero-out everyone

 \ These focus on the compression region:
   "yes no 't' wcq1, yes yes 'd' wcq1, no yes 'f' wcq1" setclients_all 
   "yes 'midfielder1' wcq, yes 'midfielder2' wcq" setclients_all
   "yes 'compression' wcq" setclients_all

halt

 \ Thu Aug 13 05:28:13 PDT 2009
   "wcqreset" setclients_all \ zero-out everyone
   "yes no 'a' wcq1" setclients_all
   "yes no 't' wcq1" setclients_all
   "no yes 'f' wcq1" setclients_all
   "no yes 'b' wcq1" setclients_all

halt

 \ Tue Aug 11 19:28:38 PDT 2009
   "wcqreset" setclients_all \ zero-out everyone
   "yes dup 'a' wcq1" "eu" setclients
   "yes dup 't' wcq1" "eu" setclients
   "yes dup 'd' wcq1" "eu" setclients
   "yes dup 'f' wcq1" "eu" setclients
   "yes dup 'b' wcq1" "eu" setclients
   "yes dup 'newlow' wcq 'newhigh' wcq" "eu" setclients
   "yes scq" "eu" setclients

halt

 \ Tue Aug 11 10:34:38 PDT 2009

 \ Mon Aug 10 16:48:36 PDT 2009

   "wcqreset" setclients_all \ zero-out everyone

   "no dup 'newlow' wcq 'newhigh' wcq" setclients_all

   "yes dup 'a' wcq1" "us tn" setclients
   "yes dup 't' wcq1" "us tn" setclients
   "yes dup 'd' wcq1" "us tn" setclients
   "yes dup 'newlow' wcq 'newhigh' wcq" "us tn" setclients

   "yes dup 'd' wcq1" "cl" setclients
   "yes dup 'f' wcq1" "cl" setclients
   "yes dup 'b' wcq1" "cl" setclients

   "yes dup 'd' wcq1" "gc" setclients
   "yes dup 'b' wcq1" "gc" setclients
   "yes dup 'newhigh' wcq" "gc" setclients

   "yes dup 'd' wcq1" "eu sf" setclients
   "yes dup 'f' wcq1" "eu sf" setclients
   "yes dup 'b' wcq1" "eu sf" setclients
   "yes dup 'newhigh' wcq" "eu sf" setclients
   
   "yes dup 't' wcq1" "dj sp nq" setclients
   "yes dup 'b' wcq1" "dj sp nq" setclients

   "yes dup 'newhigh' wcq" "hg" setclients
   "yes dup 'd' wcq1" "hg" setclients
   "yes dup 'b' wcq1" "hg" setclients

halt

 \ Mon Aug 10 06:05:50 PDT 2009
   "yes dup 'newlow' wcq 'newhigh' wcq" setclients_all
   "no dup 'newlow' wcq 'newhigh' wcq" setclients_all

   "yes dup 'b' wcq1" "gc" setclients

   "yes dup 'd' wcq1" "cl" setclients
   "yes dup 't' wcq1" "cl" setclients
   "yes dup 'f' wcq1" "cl" setclients

   "yes dup 'd' wcq1" "sf eu" setclients
   "yes dup 'b' wcq1" "sf eu" setclients

   "yes dup 'a' wcq1" "hg" setclients
   "yes dup 'd' wcq1" "hg" setclients
   "yes dup 'f' wcq1" "hg" setclients

   "yes dup 'a' wcq1" "dj sp nq" setclients
   "yes dup 't' wcq1" "dj sp nq" setclients
   "yes dup 'f' wcq1" "dj sp nq" setclients
   "yes dup 'b' wcq1" "dj sp nq" setclients

   "yes dup 'd' wcq1" "us tn" setclients
   "yes dup 't' wcq1" "us tn" setclients
halt

   "'mfil.v' source" setclients_all
   "'mobius.n' 'DUH' msource" remotesockets remoterun
   "'mobius.n' 'DOY' msource" remotesockets remoterun
halt
