/* {{{1 GNU General Public License

Program Tops - a stack-based computing environment
Copyright (C) 1999-2005  Dale R. Williamson

Author and copyright holder of xdbfetch.c:  Al Danial <al.danial@gmail.com>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
1}}} */

#ifdef XDB
/* xdbfetch.c

   Albert Danial July 18 2001
  
   xdbfetch (qFile qTable nSC nID --- hA )

   Load data from a Nastran .xdb file.  

   Contact MacNeal-Schwendler Corporation for more information about 
   reading from xdb files made by MSC/Nastran.

   qFile  - name of an .xdb file
   qTable - xdb table name
   nSC    - subcase number for results data
            superelement number for model data [not implemented]
            0 = any/all subcase/superelement
   nID    - entity ID for which to return data
            0 = any/all rows of data for this table

 */

#include <stdio.h>
#include <stdlib.h>
#include "xdbfetch.h"
#include "xdb_sizes_c.h" /*Max_Grids_or_Elems Max_Freqs_or_Times Size_of_CSTM*/
#include "main.h"
#include "stk.h"

#include "ctrl.h"
#include "inpo.h"
#include "mem.h"
#include "tag.h"

#ifdef FORT_UDSC
#define DCOPY dcopy_
#else
#define DCOPY dcopy
#endif

int xdbfetch() { /* xdbfetch (qFile qTable nSC nID --- hA ) */
    int     Max_Result_Size;
    int     var_Max_Result_Size = Max_Result_Size;
    
    int     EqExIn[2*Max_Grids_or_Elems];
    float   CSTM[Size_of_CSTM]; /*  coordinate system xform matrices */
    int     var_Size_of_CSTM = Size_of_CSTM;
    
    double *Result, *temp_ptr;
    
    int     nFreq_or_Time;
    float   Freq_or_Time[Max_Freqs_or_Times];
    
    int     i, j, ptr, nRows, Subcase_Wanted, Subcase_Found,
            Ent_ID, Tabl_RelFact, EqEx_RelFact, Coord_Sys_ID,
            nEqExIn_pairs, Appr_Code, nCols_Result_row,
            Result_Format, offset, Size_of_EqExIn;
    int     ReadXDB, PrtTable, PrtDict, PrtContent,
            PrtColTitl, UseComFile, not_enough_mem, Sort1,
            Indexed_by_EqEx, done_printing, Raw, PrtDynInd, 
            PrtSubcase, save_to_memory;
    
    char    DBname[81], TablNm[9];
    int     int_1    = 1;
    int     nTerms;
    char   *Fname, *Tname;

    popint(&Ent_ID);

    popint(&Subcase_Wanted);

    if (tos->typ != STR) {
        stkerr(" xdbfetch: ",STRSNOT);
        return 0;
    }
    if ((Tname=(char *)memgetn(tos->tex,tos->col))==NULL) return 0;
    drop();  /* remove table name from tos */
    /* Make the table name string suitable for Fortran */
    for (i = 0; i <     8; i++) TablNm[i] = ' ';
    j = MIN(8, strlen(Tname));
    for (i = 0; i < j; i++)
      TablNm[i] = toupper(Tname[i]);

    if (tos->typ != STR) {
        stkerr(" xdbfetch: ",STRSNOT);
        return 0;
    }
    if ((Fname=(char *)memgetn(tos->tex,tos->col))==NULL) return 0;
    drop();  /* remove filename from tos */
    /* Make the file name string suitable for Fortran */
    for (i = 0; i < 80; i++) DBname[i] = ' ';
    j = MIN(80, strlen(Fname));
    for (i = 0; i < j; i++)
      DBname[i] = Fname[i];

/*
gprintf("DBname=[%s]  TablNm=[%s]\n", DBname, TablNm);
*/

    /*
     *  Need to ask for a lot of memory since there is no way (yet)
     *  of knowing how large the returned data set will be.  Will
     *  free up the unused amount later with a realloc().
     */
    Max_Result_Size = 8000000;
    if ((Result = malloc(Max_Result_Size*sizeof(double))) == NULL) {
        stkerr(" xdbfetch: ",MEMNOT);
        return 0;
    } 

    Coord_Sys_ID   = 0        ; /* for GRIDX table only; 0 = basic */
    save_to_memory =       1  ; /* T->data to Result();  F->data to STDOUT */
    Raw            =       0  ;
    PrtDynInd      =       0  ;
    PrtSubcase     =       0  ;
    Sort1          =       0  ;
    Result_Format  = 3        ; /* 1=RI, 2=RR, 3=DD */

    Size_of_EqExIn = 2*Max_Grids_or_Elems;

    data_from_xdb_(DBname,               /* in  */
                   TablNm,               /* in  */
                  &Subcase_Wanted,       /* in  */
                  &Ent_ID,               /* in  */
                  &Coord_Sys_ID,         /* in  */
                  &save_to_memory,       /* in  */
                  &Raw,                  /* in  */
                  &PrtDynInd,            /* in  */
                  &PrtSubcase,           /* in  */
                  &Sort1,                /* in/out (reset if incorrect) */
                  &var_Size_of_CSTM,     /* out */
                   CSTM,                 /* out */
                  &Subcase_Found,        /* out */
                  &nRows,                /* out */
                  &Indexed_by_EqEx,      /* out */
                  &Size_of_EqExIn,       /* in, size of EqExIn      */
                   EqExIn,               /* out if Indexed_by_EqEx  */
                  &nEqExIn_pairs,        /* out if Indexed_by_EqEx  */
                  &Max_Result_Size,      /* in, size of IntValu()   */
                  &Result_Format,        /* in  if save_to_memory   */
                   Result,               /* out if save_to_memory   */
                   Result,               /* out if save_to_memory   */
                   Result,               /* out if save_to_memory   */
                  &nCols_Result_row,     /* out */
                  &Appr_Code,            /* out */
                  &Tabl_RelFact,         /* out */
                  &EqEx_RelFact,         /* out */
                  &nFreq_or_Time,        /* out if Dynamics results */
                   Freq_or_Time,         /* out if Dynamics results */
                  &not_enough_mem);      /* out */
    if (not_enough_mem) {
        fprintf(stderr, "-> xdb results are incomplete because there was\n");
        fprintf(stderr, "-> not enough memory to store all requested data\n");
    }

    /*
     *  Release the memory that isn't being used by reallocating the
     *  space taken given to Result to the amount actually used. 
     */
    if ((temp_ptr=realloc(Result, nRows*nCols_Result_row*sizeof(double)))
         == NULL) {
        stkerr(" xdbfetch: ",MEMRESIZE);
        free(Result);
        return 0;
    } 
    Result = temp_ptr;

    push(MAT, (char *)memgetn(TablNm, strlen(TablNm)), NOTAG, 0, 
         Result, NULL, nCols_Result_row,  nRows, NULL);

    return 1;
}
#endif
