\ {{{1 GNU General Public License
{
Program Tops - a stack-based computing environment
Copyright (C) 1999-2005  Dale R. Williamson

Author: Dale R. Williamson <dale.williamson@prodigy.net>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
1}}} 
}

{ File lapack.v  November 2001

   D. R. Williamson

   Testing words that run lapack subroutines.

}
   private halt

\-----------------------------------------------------------------------

\  Real matrix multiplication and add.

   dgemm: D = A * B + C

\     Run this using: "lapack.v" "dgemm: D = A * B + C" msource

      seedget 
         seed0 seedset
         200 100 random into A
         100 200 random into B
      seedset

    \ This verifies that using purged for C is the same as using null:
      A no 1, B no, purged             (C) 1 dgemm
      A no 1, B no, A rows B cols null (C) 0 dgemm

      less null?
      IF " dgemm multiply: OK" 
      ELSE " dgemm multiply: ERROR" 
      THEN . nl

   private halt

\-----------------------------------------------------------------------

\  Real matrix inverse.

   dgesv: 500-by-500 inverse

\     Run this using: "lapack.v" "dgesv: 500-by-500 inverse" msource
 
      seedget seed0 seedset

      purged (hb), 500 500 random dup push (hA) 

      (hb hA) dgesv (hAinv)

      pull (hAinv hA) star 
      500 identity less abs maxfetch 2drop

      " dgesv 500-by-500 inverse: max error =" . . nl

      seedset

   private halt

\-----------------------------------------------------------------------

\  Real matrix singular inverse.

   dgesv: singular

\     Run this using: "lapack.v" "dgesv: singular" msource

      " Example decomposing singular matrix:" . nl nl
      list: 
         1 2 3 
         4 5 6 
         7 8 9
      end 3 foldr into A

      A rows 2 random into b

      b A dgesv 
      
     no .sf nl xx  

   private halt

\-----------------------------------------------------------------------

\  Complex matrix inverse.

   zgesv: 500-by-500 inverse

\     Run this using: "lapack.v" "zgesv: 500-by-500 inverse" msource

      "cmag" missing IF "mmath.v" source THEN

      seedget seed0 seedset

      500 into R

      R identity 0i complex (hb)
      R R random R R random complex (hA) dup push

      (hb hA) zgesv (hAinv)

      pull (hAinv hA) star
      R identity 0i complex less real-imag cmag maxfetch 2drop

      " zgesv 500-by-500 complex inverse: max error =" . . nl

      seedset

   private halt

\-----------------------------------------------------------------------

\  Real matrix complex eigenanalysis.

   dgeev: complex eigenanalysis

\     Run this using: "lapack.v" "dgeev: complex eigenanalysis" msource

      "eigchk" missing IF "mmath.v" source THEN

      seedget seed0 seedset

      200 200 random (hC) dup 

      (hC) trace dgeev \ trace shows work size

      (hC) dgeev (hLr hLi hAr hAi) 

      (hC hLr hLi hAr hAi) eigchk (hBr hBi)

      (hBr hBi) *conj sqrt maxfetch 2drop 

      " dgeev 200-by-200 complex eigenanalysis: max error =" . . nl

      seedset

   private halt 

\-----------------------------------------------------------------------

\  Real matrix complex eigenanalysis, left and right hand vectors.

\  Copy and drop the following line to run this example: 
      INFIX push << "lapack.v" "dgeev2: complex eigenanalysis" msource  

   dgeev2: complex eigenanalysis

   {" This infix text is gathered and parsed into postfix, and then run.

      t0 = time;

      S = seedget(); 
      seedset(seed0);

      N = 200;
      A = random(N, N);

      seedset(S);

      size = intstr(rows(A)) + "-by-" + intstr(cols(A));

      nl(dot(" dgeev2 complex eigenanalysis of real unsymmetric " + 
      size));

/*----

#     Approach 1:
      (Wr, Wi, Lr, Li, Rr, Ri) = dgeev2(A);

   /* Dgeev2() returns real and imaginary components as separate 
      matrices; function complex puts them together to make one
      complex matrix: */
      VR = complex(Rr, Ri); # right hand eigenvectors
      VL = complex(Lr, Li); # left hand eigenvectors
      W  = complex(Wr, Wi); # eigenvalues

   /* Freeing memory of intermediate component matrices now combined
      into complex matrices W, VL, and VR: */
      Wr = Wi = Lr = Li = Rr = Ri = purged;

----*/

#     This demo is running Approach 2 shown below.

#     Approach 2:
      (
       dgeev2(A),  
         book(complex, "VR"), # right hand eigenvectors
         book(complex, "VL"), # left hand eigenvectors
         book(complex, "W")   # eigenvalues
      );

/*    Approach 2 uses a paren list "( ... );" of expressions that end 
      without semicolons to carry items on the stack and directly book 
      (store into the catalog) complex matrices from the real and 
      imaginary components that dgeev2 placed on the stack. 

      This eliminates the need to explicitly name intermediate component
      matrices (Wr, Wi, Lr, Li, Rr, Ri) and then purge them (important
      when they are huge) as is done in Approach 1.  

      Instead, memory for each pair of real and imaginary components is 
      freed by the program when their complex matrix is defined and they
      are dropped from the stack. */

#     Checking results.

#     A * VR - VR * W = 0?
      (err, i, j) = maxfetch(abs(A * VR - VR *\ W));
      nl(dot(dot("      right vec error ="), err));
      
#     conj(VL)' * A - W * conj(VL)' = 0?
      (err, i, j) = maxfetch(abs(conj(VL)' * A - W \* conj(VL)'));
      nl(dot(dot("       left vec error ="), err));

#     Normalizing VL and VR so conj(VL)' * A * VR = W, and creating
#     normalized right and left eigenvectors, PSI and GAM:
      fac = (W ./ mpydg(conj(VL)', A * VR)).^0.5;
      PSI = VR *\ fac;          # right eigenvectors
      GAM = (conj(VL) *\ fac)'; # left eigenvectors

#     Normalizing made GAM the inverse of PSI, as this shows:
#     Identity(rows(PSI)) - PSI * GAM = 0?
      (err, i, j) = maxfetch(abs(eye(rows(PSI)) - PSI * GAM));
      nl(dot(dot("  normalization error ="), err));

      A = W = VL = VR = PSI = GAM = fac = purged;

      ET = time - t0;
      nl(dot(dot(" Elapsed seconds:"),ET)); 

   "} (hInfix) eval

   keys? IF tdepth any IF pull infix_set THEN THEN

   private halt

------------------------------------------------------------------------

   Below is the original postfix version of the dgeev2() demo

      seedget seed0 seedset

      200 200 random "A" book \ real unsymmetric matrix

      seedset

      " dgeev2 complex eigenanalysis of real unsymmetric 200-by-200:" 
      . nl

      A dgeev2 (hWr hWi hLr hLi hRr hRi) 
      complex "VR" book \ right hand eigenvectors
      complex "VL" book \ left hand eigenvectors
      complex "W"  book \ eigenvalues

\     A * VR - VR * sq(W) = 0?
      A VR * VR W diagpost - abs maxfetch 2drop
      "      right vec error =" . . nl

\     conj(VL)' * A - sq(W) * conj(VL)' = 0?
      VL conj bend A * W VL conj bend diagpre - abs maxfetch 2drop
      "       left vec error =" . . nl

\     Normalizing VL and VR so conj(VL)' * A * VR = sq(W):
      W VL conj bend A VR * mpydg /by 0.5 ^by (fac) push
      VR peek (fac) diagpost "PSI" book     \ right hand normalized eigs
      VL conj pull diagpost bend "GAM" book \ left hand normalized eigs

\     Normalizing makes GAM the inverse of PSI.
\     Identity(rows(PSI)) - PSI * GAM = 0? 
      PSI rows identity PSI GAM * - abs maxfetch 2drop
      "  normalization error =" . . nl

      "A = W = VL = VR = PSI = GAM = fac = purged;" parse main

   private halt

\-----------------------------------------------------------------------

\  Complex matrix multiplication and add.

   zgemm: D = A * B + C

\     Run this using: "lapack.v" "zgemm: D = A * B + C" msource

      seedget
         seed0 seedset
         200 100 random these dims random complex into A
         200 100 random these dims random complex into B
         200 200 random these dims random complex into C

         1 0 complex into alp
         0 0 complex into beta
      seedset

    \ This verifies that using purged for C is the same as using null:
      A no alp, B yes, purged (C)                  beta zgemm
      A no alp, B yes, A rows B rows null conj (C) beta zgemm

      less null?
      IF " zgemm multiply: OK"
      ELSE " zgemm multiply: ERROR"
      THEN . nl

    \ Using just the real parts of A, B, and C:
      A real-imag drop into A 
      B real-imag drop into B 
      C real-imag drop into C 
      3 into alp, 4 into beta

      A no alp, B yes, C beta dgemm
      A 0i complex no alp 0 complex, B 0i complex yes, 
      C 0i complex beta 0 complex zgemm real-imag drop
      (hD1 hD2) less abs maxfetch 2drop (error)
      " zgemm with 0i vs. dgemm real:" . .

   private halt

\-----------------------------------------------------------------------
