\ {{{1 GNU General Public License
{
Program Tops - a stack-based computing environment
Copyright (C) 1999-2005  Dale R. Williamson

Author: Dale R. Williamson <dale.williamson@prodigy.net>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
1}}} 
}

{  File matlab.v  April 2001

   Copyright (c) 2001  D. R. Williamson

   Utilities for Matlab

   References:
      1. "Matlab Application Program Interface Guide, Version 5,"
         The Math Works, Inc., 1997.
      2. "Matlab User's Guide," The Math Works, Inc., 1996.
      3. Express program file matlab.voc.

   Notes:
      Words for Matlab binary files--matF, matfile, matfile?, mget, 
      mheader, and mtoc--are in file.v, and are independent of this 
      file and the Matlab engine facility.

      Matlab command string: the default command string to run Matlab 
      is assumed to be "matlab."  If it is different for your machine, 
      set it in word MATLAB, file /sys/uboot.v.

\-----------------------------------------------------------------------

   The Matlab interprocess communication facility, called the Matlab
   engine, allows other programs to run Matlab.  Reference 1 describes
   the Matlab engine facility, and Reference 2 is the general guide to 
   Matlab.  Reference 3 is a file similar to this one for the Express
   program that also uses the Matlab engine.  Many of the high level
   words below were taken from Reference 3.

   Words of this file use primitive words _engXXX, defined in file mat-
   lab.c, to interface with Matlab through the engine facility.  They 
   allow commands to be executed in Matlab and matrices to be sent back
   and forth between Matlab and this program.  

   There are five primitive words _engXXX built into the program:

      _engClose, _engEval, _engGet, _engOpen, _engPut,

   and they are used below in various ways by words of this file to 
   perform tasks with Matlab.

   Word "engOn" defined below is run first to establish a link to Mat-
   lab, allowing other words to communicate with Matlab.  When Matlab 
   is no longer needed, word "engOff" is run to close the link.

   Word "engRun" sends a text matrix of commands to Matlab for execu-
   tion, to run just as they would if keyed at the Matlab prompt.  Rows
   of phrases for this program can be layered with rows of Matlab com-
   mands by starting each row meant for this program with a semicolon.

   Word engRun will fire rows preceded by ; in this program, and send 
   other rows to Matlab to be run.  All rows are run in sequence, so 
   text to Matlab and this program can interlaced and each step will 
   follow completion of the prior one.

   Matrices created in Matlab are retrieved by word "engGet," and ma-
   trices from this program are sent to Matlab using word "engPut."
   Full 64-bit (double) precision is maintained in the binary matrices 
   shared by Matlab and this program.  When the matrix returned from
   Matlab is complex, engGet will return two matrices on the stack--the
   real part followed (on top) by the imaginary part.

   To interface the keyboard directly with Matlab, word "_matlab" can 
   be fired to enter a command loop that mimics the Matlab prompt and 
   allows direct entry of commands to Matlab.  Since word _matlab uses 
   engRun to send commands to Matlab, phrases for this program can be 
   run merely by preceding them with semicolon as described above.  At 
   the simulated Matlab prompt, keying the less-than (<) symbol will 
   return control to the program ready prompt.

   To start Matlab, word matlab is fired.  Matlab is then running and
   ready to accept commands from the program using engRun, engPut and 
   engGet.  Firing word matlab again will run word _matlab discussed
   above, where commands are sent directly to Matlab from a simulated 
   Matlab prompt.

   Word matlab is not in this file.  It is located in file sys.v, where 
   it is available to source this file when "matlab" is keyed.
}
   "_engOpen" exists? not
   IF " Matlab engine facility is not present" . nl halt THEN

   CATMSG push no catmsg

\-----------------------------------------------------------------------

\  Definitions for Matlab engine facility.

   "_ep" exists?
   IF _ep @ 0<>
      IF _ep @ _engClose drop THEN \ close engine when sourcing again
   THEN

   inline: _ep ( --- hEp) [ scalar is ep ] ep ; \ scalar for engine id

   inline: _matlab ( --- ) \ Matlab command prompt and loop
      [ "<" is quitting, " [matlab@" host "] >>"
        cat cat spaced is MatlabPrompt, {"
        Running the Matlab engine
         Keyed commands go to Matlab
         Text preceded by ; is run by this program, as: >> ;3 pi * .
         Key < to return to the ready prompt
        "} -7 indent makes Header
        no is promptOn
      ]
      depth is d0
      yes promptOn = IF return THEN \ no recursion; return if running
      engOn, yes is promptOn, Header dot nl
      BEGIN nl MatlabPrompt query (qS)
         (qS) strchop these chars IF nl THEN
         quitting that alike
         IF drop true 
         ELSE (qS) engRun 
            depth d0 > IF ok @ .sf THEN false 
         THEN
      UNTIL
      engOn? IF " Type engOff to stop the Matlab engine" nl . nl THEN
      no is promptOn
   end

   inline: engGet (qB --- hB) \ retrieve Matlab matrix named B
\     If matrix named B does not exist in Matlab, the system can
\     hang.  This word first multiplies B by 1 so Matlab creates
\     an uninitialized variable when B does not exist.
      dup "=1*" over cat cat engRun, _ep @ _engGet drop 
   end

   inline: engOff ( --- ) \ closes the link to Matlab
      _ep @ 0<> IF _ep @ _engClose, (f) drop, 0 _ep ! THEN
      " Matlab engine is off" . nl
   end

   inline: engOn ( --- ) \ opens the link to Matlab
      [ "MATLAB" missing IF "matlab " makes MATLAB THEN ]
      _ep @ 0=
      IF MATLAB _engOpen, (ep) _ep !, _ep @ 0<>
         IF _ep engPut
            "client='" progname "@" host "'"
            cat cat cat cat engRun
         THEN
      THEN
   end

   inline: engOn? ( --- f) \ true if Matlab engine is running
      _ep @ 0<>
      IF "ep" _ep @ _engGet (f)
         IF false ELSE (hEp) @ _ep @ = THEN
      ELSE false
      THEN dup false = IF 0 _ep ! THEN
   end

   inline: engPut (hA --- ) \ put matrix A into Matlab
      _ep @ _engPut trash ;

   inline: engRun (hT --- ) \ run procedure of text matrix T in Matlab
{     Quotes (rows) within T that begin with ; are fired as phrases in
      this program; others are sent to Matlab.

      Implementation notes:
         A BEGIN ... UNTIL loop is used instead of a DO ... LOOP
         because it is more robust if a stack error occurs from
         incorrect keying in phrases sent here from word _matlab.

         Also, nothing in the loop is carried on the stack because
         it could be emptied at any time (as by keying ;xx).

}     [ ";" 1st byte says run_local ]

      (hT) into T, T rows makes goal, no is sum

      BEGIN one sum bump, T sum ndx quote (qS), strchop any?
         IF this 1st byte run_local =
            IF
               (qS) BL 1st strput main \ firing phrase in this program
            ELSE
               (qS) ";" cat _ep @ _engEval (f) drop \ running Matlab
            THEN
         THEN
         sum goal >= (f) \ running until sum equals goal

      UNTIL
   end

   inline: mreset ( --- ) \ close Matlab windows, free all memory
\     Closes Matlab, which gets rid of all plot windows, then starts 
\     Matlab again.
      engOff engOn engOn? IF " Matlab engine is on" . nl THEN ;

\-----------------------------------------------------------------------

\  Start the Matlab engine:
      engOn 

\-----------------------------------------------------------------------

\  Some words that use the Matlab engine are defined below.

\  Other words that use the Matlab engine are in signal.v. 

\  Words for accessing files from Matlab are in file.v; these do not
\  require the Matlab engine.

   inline: figure ( --- qS) \ default frame and menu bar
      [ "figure('Name',client,'NumberTitle','off','MenuBar','figure');"
        is figure ] figure
   end

   inline: matlab_available ( --- ) \ grab a seat when one is free
{     Beep and start Matlab when a license becomes available.

      Play this word in the multitasker.  The following will check
      every 4 seconds:
         0.25 "matlab_available" PLAY
}
      [ "/usr/local/bin/matlabcount" "COUNT_FILE" book ]
      
      COUNT_FILE file? not IF return THEN

      COUNT_FILE " > " cat scratch cat shell
      scratch asciiload scratch delete
      "/dev/pts" grepr rows three <
      IF beep two idle beep two idle beep
         "matlab_available" OMIT
         "engOn" missing IF matlab THEN
      THEN
   end

   inline: maxis_get ( --- hXY) \ get settings of current plot axes
      "XY=axis; XY=XY'" engRun, "XY" engGet
   end

   inline: maxis_set (hXY --- ) \ set range of current plot axes
\     Example: change X range to (0,100), leave Y range as-is:
\        maxis_get, 0 that 1st poke, 100 that 2nd poke, maxis_set
      "XY" naming engPut
      "axis([XY(1),XY(2),XY(3),XY(4)])" engRun
   end

   inline: meig (hC f --- hAr hAi) \ eigenanalysis of matrix C in Matlab
{     Structure of Ar and Ai matches output from Express word "eig," 
      where Ar and Ai are respectively real and imaginary modal 
      components stored by columns with the eigenvalue in the first 
      row and the corresponding eigenvector in the rows beneath.

      See word modes for separating eigenvalues and eigenvectors of A.

}     depth 2 - push, (f) push (C) "C" naming engPut

      pull (f) 0<>
      IF "[V,D]=eig(C)" 
      ELSE "[V,D]=eig(C,'nobalance')" 
      THEN engRun, "V" engGet, "D" engGet 

    \ Format results to match word eig:
      depth pull - 4 = \ complex?
      IF (Vr Vi Dr Di) >vector transpose (Fi), 2 roll (Vi), pile (Ai),
      ELSE (Vr Dr) over dup rows 1+, swap cols (r c) null (Ai)
      THEN (Ai) push, (Vr Dr) >vector transpose (Fr), swap (Vr) pile
      '_Ar' naming (Ar), pull '_Ai' naming (Ai)
   end

   inline: mfile_run (qFile --- ) \ execute a Matlab mfile
      dup file? not
      IF " mfile_run: file " swap " not found" cat cat ersys
      ELSE (qFile) asciiload (hT) engRun
      THEN
   end

   inline: mfont_size (n --- ) \ setting font size for graphs and labels
   \  To show properties of Matlab axes objects:
   \     >> h=axes; set(h);
      [ "set(gca,'FontSize',12)" "font" book \ initial setting 
      ] int$ "set(gca,'FontSize'," swap cat ')' cat "font" book
      font engRun
   end

   inline: mgrid ( --- ) \ put grid lines on the active plot
      "grid" engRun ; 

   inline: mlabel (qTitle qXlabel qYlabel --- ) \ write title and labels
\     Put title and labels on the active plot.
      1st quote strchop "ylabel('" swap "')" cat cat engRun
      1st quote strchop "xlabel('" swap "')" cat cat engRun
      1st quote strchop "title(['" swap "'])" cat cat engRun
      "mfont_size" "font" yank engRun
   end

   inline: mloglog (hY hX --- ) \ plot Y vs. X in Matlab, both axes log
      _ep @ 0<>
      IF into X, into Y, figure engRun
         X engPut, Y engPut, 'loglog(X,Y)' engRun
         "mfont_size" "font" yank engRun
      ELSE " Matlab engine is not on" . nl
      THEN
   end

   inline: mplot (hx ht --- ) \ plot x vs. t in Matlab with menu bar
\     Note: in Matlab, use
\        >> h=figure; set(h);
\     to see the possible values for figure properties.
      _ep @ 0<>
      IF chain swap, those rows those rows <>
         IF bend THEN park "P" naming engPut, figure engRun
         "plot(P(:,1),P(:,2:size(P,2)))" engRun
         "mfont_size" "font" yank engRun
      ELSE " Matlab engine is not on" . nl
      THEN
   end

   inline: mplot1 (hx ht --- ) \ plot x vs. t in Matlab, no menu bar
      [ "figure('Name',client,'NumberTitle','off','MenuBar','none');"
        is figure
      ] _ep @ 0<>
      IF chain swap, those rows those rows <>
         IF bend THEN park "P" naming engPut, figure engRun
         "plot(P(:,1),P(:,2:size(P,2)))" engRun
         "mfont_size" "font" yank engRun
      ELSE " Matlab engine is not on" . nl
      THEN
   end

   inline: mplot2 (hx1 ht1 hx2 ht2 --- ) \ plot x vs. t 
\     Size of x1 and x2 can be different.
      _ep @ 0<>
      IF "t2" naming engPut, "x2" naming engPut
         "t1" naming engPut, "x1" naming engPut
         figure
         "plot(t1,x1,'b')" pile
         "hold on" pile
         "plot(t2,x2,'r')" pile
         engRun
         "mfont_size" "font" yank engRun
      ELSE " Matlab engine is not on" . nl
      THEN
   end

   inline: mplot3 (hx1 ht1 hx2 ht2 hx3 ht3 --- ) \ plot x vs. t 
\     Sizes of x1, x2 and x3 can be different.
      _ep @ 0<>
      IF "t3" naming engPut, "x3" naming engPut
         "t2" naming engPut, "x2" naming engPut
         "t1" naming engPut, "x1" naming engPut
         figure
         "plot(t1,x1,'b')" pile
         "hold on" pile
         "plot(t2,x2,'r')" pile
         "hold on" pile
         "plot(t3,x3,'k')" pile
         engRun
         "mfont_size" "font" yank engRun
      ELSE " Matlab engine is not on" . nl
      THEN
   end

   inline: mplot3d (hXYZ --- ) \ plot triplets of 3d vectors in Matlab
      _ep @ 0<>
      IF figure engRun, "hold on" engRun, these cols 1st
         DO these I 3 items catch into P, P engPut,
            "plot3(P(:,1),P(:,2),P(:,3))" engRun 3
         +LOOP
         "mfont_size" "font" yank engRun
      ELSE " Matlab engine is not on" . nl
      THEN trash
   end

   inline: mprintf (qS --- ) \ append the current plot to print file S
      "print -dpsc -append " swap cat
      "orient landscape"
      engRun engRun
   end

   inline: mpsd (hx n m f1 qTitle --- Xmax fmax) \ display PSD for x
{     Example: given 9000 points in vector JIT1, and dt = .01:
         JIT1, 2 9000 log2 integer ^ (n), 1 .01 / (m) 
         5 (Hz) "Jitter 1" mpsd
}     [ {"  Matlab routine for PSD, from Bill Stock
            %  x = time sequence, constant time step
            %  n = number of FFT-points (2**n)
            %  m = sampling frequency (1/tstep)
            %  f1= maximum frequency (Hz) for plot
            %  qTitle = quote-string plot title
            %
            %n = input('Input number of FFT-points')
            %m = input('Input Sampling Frequency')
            %
            x=x - mean(x)
            X=fft(x,n);
            Pxx=X.*conj(X)/n;
            f=m*(0:n/2-1)/n;
            figure('Name',client,'NumberTitle','off','MenuBar','none')
            hold on
            title([Ptitle])
            axis([0 f1 0 max(Pxx)])
            xlabel('Frequency, Hz')
            ylabel('PSD')
            grid
            plot(f,Pxx(1:n/2))
            [Pxxmax,index]=max(Pxx);
            fmax=f(index)
        "} (hT) left justify into MatlabProc

        "'%8.4G' format 1st quote strchop" "real$" inlinex

      ] engOn
        "Ptitle = '" swap "'" cat cat engRun
        "f1 = " swap real$ cat engRun
        "m = " swap int$ cat engRun
        "n = " swap int$ cat engRun
        (hx) into x, x engPut, MatlabProc engRun,
        "Pxxmax" engGet, "fmax" engGet (Xmax fmax)
   end

   inline: mspy (hA --- ) \ visualize sparse matrix A
      _ep @ 0<>
      IF "Aspy" naming engPut, figure engRun, "spy(Aspy)" engRun
      ELSE " Matlab engine is not on" . nl
      THEN
   end

   inline: mXsemilog (hY hX --- ) \ plot Y vs. X, X axis is semilog
      _ep @ 0<>
      IF into X, into Y, figure engRun
         X engPut, Y engPut, 'semilogx(X,Y)' engRun
         "mfont_size" "font" yank engRun
      ELSE " Matlab engine is not on" . nl
      THEN
   end

   inline: myplot (hx ht --- ) \ plot x vs. t in Matlab with menu bar
      mplot ;

   inline: mYsemilog (hY hX --- ) \ plot Y vs. X, Y axis is semilog
      _ep @ 0<>
      IF "X" naming engPut, "Y" naming engPut
         figure engRun, "semilogy(X,Y)" engRun
         "mfont_size" "font" yank engRun
      ELSE " Matlab engine is not on" . nl
      THEN
   end

\-----------------------------------------------------------------------

   pull catmsg private halt
