{ {{{1 GNU General Public License
Program Tops - a stack-based computing environment
Copyright (C) 1999-2005  Dale R. Williamson

Author: Dale R. Williamson <dale.williamson@prodigy.net>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
1}}} }

{ File easy_io.v  August 2004

   Copyright (c) 2004-2005   A. Danial

}
#-----------------------------------------------------------------------

CATMSG push no catmsg

inline: to_file (X qFile --- ) # {{{1
# man entry:  to_file {{{2
# (X qFile --- ) Writes stack item X in binary form to the file whose name is given by qFile.  If the file exists it is overwritten.  For example,
# > 4 5 random "4x5.mat" to_file (creates file "4x5.mat")
# > "4x5.mat" from_file          (loads matrix back from file "4x5.mat")
# category: file
# related:  putn, getn, from_file, to_file_N, from_file_N
# 2}}}
    dup deleteif new binary "FileHandle" this closeif file
    (X) 1 FileHandle putn
    FileHandle close
end
# 1}}}
inline: from_file (qFile --- X) # {{{1
# man entry:  from_file {{{2
# (qFile --- X ) Place on the stack the (first) item contained in the binary file named qFile.  For example,
# > 4 5 random "4x5.mat" to_file (creates file "4x5.mat")
# > "4x5.mat" from_file          (loads matrix back from file "4x5.mat")
# category: file
# related:  to_file, putn, getn
# related:  putn, getn, to_file, to_file_N, from_file_N
# 2}}}
    old binary "FileHandle" open
    1 FileHandle getn
    FileHandle close
end
# 1}}}
inline: to_file_N (x .. z N qFile --- ) # {{{1
# man entry:  to_file_N {{{2
# (x .. z N qFile --- ) Writes the N stack items x..z in binary form to the file whose name is given by qFile.  If the file exists it is overwritten.  For example,
# > 4 5 random 3 eye 2 "x.mat" to_file (creates file "x.mat")
# > "x.mat" 2 from_file_N      (loads the two matrices back from file "4x5.mat")
# category: file
# related:  putn, getn, to_file, from_file, from_file_N
# 2}}}
    dup deleteif new binary "FileHandle" this closeif file
    (N) FileHandle putn
    FileHandle close
end
# 1}}}
inline: from_file_N (qFile N --- x .. z) # {{{1
# man entry:  from_file_N {{{2
# (qFile N --- x .. z ) Place on the stack the first N items contained in the binary file named qFile.  For example,
# > 4 5 random "4x5.mat" to_file (creates file "4x5.mat")
# > "4x5.mat" from_file          (loads matrix back from file "4x5.mat")
# category: file
# related:  to_file, putn, getn
# related:  putn, getn, to_file, to_file_N, from_file
# 2}}}
    swap 
    old binary "FileHandle" open
    (N) FileHandle getn
    FileHandle close
end
# 1}}}

(CATMSG) pull catmsg # restore former
