{  File bch.v  August 2004

   Copyright (c) 2004-2013   D. R. Williamson

   Words for fetching data from barchart.com

------------------------------------------------------------------------

   Wed Aug 28 14:59:38 PDT 2013.  Highlight with "max" the row of the
      contract with highest open interest.

   Wed Aug 21 20:14:48 PDT 2013.  Highlight the row of the contract 
      being followed (MOdo) with ***.

   Fri Jul 13 15:00:02 PDT 2012.  Use netscapeUA user agent in HTTPget.

   Tue Dec 13 16:04:36 PST 2011.  Modifications to bcPROCESS1 and
      bcPROCESS2 for html changes.

   Update July 2011
      Intraday bcPROCESS1 was updated to make it work again to replace
      tch.v which no longer can be used.
      
   Update September 2010
      End of day, bcPROCESS2, changed to reflect different site output.
      Word bcPROCESS1 for intraday fails getting data, but it currently
      is being replaced by tch.v.

   Update January 2009 
      Update (word bc64ths_tmp) to output US as 32nds rounded from 
      64ths (actually 32nds and one-half), doing a task that has been 
      done manually for months on the daily output file.  Eventually, 
      US should be switched to 64ths to be like TN.

   Update January 2008 
      Make provision for electronic markets, although this site
      does not collect them yet.

   Note October 2007
      Data for MP is missing the last digit (the one-half), and 
      values appear to be rounded.

------------------------------------------------------------------------
}
   "tracklist" missing IF " bch.v: require tracklist " . nl halt THEN

   inline: bc8ths (qS --- hT) \ process S
      [ {"
        (hT) spaced
        "- "  "0" replace$
        "-0 " "0" replace$
        "-2 " "2" replace$
        "-4 " "4" replace$
        "-6 " "6" replace$
        (hT)
        "} "bcGRAIN" macro
      ]
      1 "bcPROCESS" "FAC" bank
      "bc8ths" "bcGRAIN" localref ptr "bcPROCESS" "SPECIAL" bank
      (qS) bcPROCESS
   end

   inline: bc32nds (qS --- hT) \ process S
      [ "%02.0f" "FORM" book
        {"
        spaced
        (hT) 64 0
         DO I FORM format '-' that cat spaced swap replace$ LOOP
        (hT)
        "} "bcBOND" macro
      ]
      1 "bcPROCESS" "FAC" bank
      "bc32nds" "bcBOND" localref ptr "bcPROCESS" "SPECIAL" bank
      (qS) bcPROCESS
   end

   inline: bc64ths (qS --- hT) \ process S
      [ "%02.0f" "FORM" book
        {"
           spaced
           64 0
           DO I FORM format "0" cat '-' that cat spaced swap replace$
              I FORM format "5" cat '-' that cat spaced swap replace$
           LOOP
        "}
        "bcBOND" macro
      ]
      1 "bcPROCESS" "FAC" bank
      "bc64ths" "bcBOND" localref ptr "bcPROCESS" "SPECIAL" bank
      (qS) bcPROCESS
   end

   inline: bc64ths_tmp (qS --- hT) \ process S
      [ "%02.0f" "FORM" book
        {"
"top of bc64ths_tmp" . nl dup . nl
           spaced
           64 0
           DO I FORM format "0" cat '-' that cat spaced swap replace$
              I FORM format "5" cat '-' that cat spaced swap replace$
           LOOP
"exit bc64ths_tmp" . nl dup . nl
        "}
        "bcBOND" macro
      ]
      1 "bcPROCESS" "FAC" bank
      "bc64ths_tmp" "bcBOND" localref ptr "bcPROCESS" "SPECIAL" bank
      (qS) bcPROCESS (hT)
{
      January 2009

      At this point, T on the stack is a formatted US output table like 
      this one, with 32nds and one-half like TN (called 64ths):
         USH09 129270 131080 129180 131065 c131065 1310 185652 724560
         USM09 128215 129300 128215 129300 c129300 1310 675    2136
         USU09      0 128230 126240 128230 c128230 1310 0      37
         USZ09      0 127210 125220 127210 c127210 1310 0      26
         USH10      0 126210 124220 126210 c126210 1310 0      0

      This is a brute force fix up to remove the 64ths place from prices
      in T and produce rounded 32nds.  Prices ending in 5 (one-half 
      32nd) are rounded up, like 128215 in the second row (21.5 32nds) 
      becoming 12822 (ending in 22/32).

      Here is how the table above looks after processing:
         USH09 12927 13108 12918 13107 c13107 131 185652 724560
         USM09 12822 12930 12822 12930 c12930 131 675    2136
         USU09 0     12823 12624 12823 c12823 131 0      37
         USZ09 0     12721 12522 12721 c12721 131 0      26
         USH10 0     12621 12422 12621 c12621 131 0      0
}
      "T" book

    \ Fix up columns 2 - 7 (matread will skip non-numerical column 1): 
      T "c" chblank (hT) 6 matread 10 / 0.5 + integer 
      "%0.0f " 6 cats format "U" book

    \ Build a new table from T and U:
      T 1st word drop spaced 
      U 1st word drop spaced +
      U 2nd word drop spaced +
      U 3rd word drop spaced +
      U 4th word drop spaced +
      U 5 ndx word drop "c" nose spaced +
      U 6 ndx word drop spaced +
      T 8 ndx word drop spaced +
      T 9 ndx word drop spaced + (hT)
   end

   inline: bcCOLLECT ( --- hT) \ data from bch
      tracklist "TRACK" book
      no "bcPROCESS" "EOD" bank

      time push
      depth push
      "From bcCOLLECT, file bch.v"
      date neat

      "Showing: Open High Low Settle Close Chg Vol OpenInt"
      " "
      TRACK rows 1st
      DO
         TRACK I quote bcDATA any? not
         IF TRACK I quote spaced date cat " no data" cat THEN
         " "
      LOOP
      depth pull less pilen

      "ET: " time pull less 60 slash "%0.1f" format cat
      " minutes" cat pile

      "_bcCOLLECT" naming
   end

   inline: bcDATA (qS --- hT) \ data for S
      [ true "PIT" book

        "'w'  bcSYM        bc8ths" "w"  macro
        "'c'  bcSYM        bc8ths" "c"  macro
        "'s'  bcSYM        bc8ths" "s"  macro
        "'sm' bcSYM  10 bcDECIMAL" "sm" macro
        "'bo' bcSYM 100 bcDECIMAL" "bo" macro

	"'lc' bcSYM 100 bcDECIMAL" "lc" macro
        "'lh' bcSYM 100 bcDECIMAL" "lh" macro
        "'pb' bcSYM 100 bcDECIMAL" "pb" macro

        "'cc' bcSYM   1 bcDECIMAL" "cc" macro
        "'kc' bcSYM 100 bcDECIMAL" "kc" macro
        "'sb' bcSYM 100 bcDECIMAL" "sb" macro
        "'jo' bcSYM 100 bcDECIMAL" "jo" macro

        "'hg' bcSYM 10000 bcDECIMAL" "hg" macro \ 5-08-2008 for EOD
       \"'hg' bcSYM 100 bcDECIMAL" "hg" macro
        "'gc' bcSYM  10 bcDECIMAL" "gc" macro
        "'pl' bcSYM  10 bcDECIMAL" "pl" macro
        "'si' bcSYM  1000 bcDECIMAL" "si" macro \ 5-08-2008 for EOD
       \"'si' bcSYM  10 bcDECIMAL" "si" macro

        "'ct' bcSYM 100 bcDECIMAL" "ct" macro
        "'cl' bcSYM 100 bcDECIMAL" "cl" macro
        "'ho' bcSYM 1E4 bcDECIMAL" "ho" macro
        "'hu' bcSYM 1E4 bcDECIMAL" "hu" macro
        "'ng' bcSYM 1E3 bcDECIMAL" "ng" macro

        "'sf' bcSYM 1E4 bcDECIMAL" "sf" macro
        "'eu' bcSYM 1E4 bcDECIMAL" "eu" macro
        "'jy' bcSYM 1E4 bcDECIMAL" "jy" macro
        "'mp' bcSYM 1E6 bcDECIMAL" "mp" macro
        "'bp' bcSYM 1E4 bcDECIMAL" "bp" macro

        "'us' bcSYM       bc32nds" "us" macro
       \"'us' bcSYM   bc64ths_tmp" "us" macro \ TEMP 
       \"'us' bcSYM       bc64ths" "us" macro
        "'tn' bcSYM       bc64ths" "tn" macro
        "'ff' bcSYM 1E3 bcDECIMAL" "ff" macro
        "'ed' bcSYM 1E3 bcDECIMAL" "ed" macro

        "'dj' bcSYM 1  bcDECIMAL" "dj" macro
        "'sp' bcSYM 10 bcDECIMAL" "sp" macro
        "'nq' bcSYM 10 bcDECIMAL" "nq" macro
        "'yx' bcSYM 10 bcDECIMAL" "yx" macro
        "'nk' bcSYM 1  bcDECIMAL" "nk" macro
      ]
      strchop uppercase "S1" book \ tops symbol
      S1 bcSYM any?
      IF "S2" book \ bch symbol
         S1 lowercase (qS) local (hT) \ run local word

       \ Fri Nov 30 15:11:38 PST 2012.  Test for purged T: 
         (hT) any?
         IF (hT) S2 S1 strp (hT) \ substitute the tops symbol

          \ Wed Aug 21 20:14:48 PDT 2013.  Highlight with "***" the row
          \ of the contract being followed (MOdo):
            (hT) dup S1 MOdo grepr any? (hT 0 | hT hR -1)
            IF (hT hR) 1st pry "n" book
               (hT) dup chars 4 + blpad dup 
               n reach (qS) notrailing " ***" tail (qS)
               (hT qS) over n (qS hT n) said (hT)

             \ Wed Aug 28 14:59:38 PDT 2013.  Highlight with "max" the
             \ row of the contract with highest open interest:
               (hT) dup 9 word (0 | hT1 -1)
               IF (hT hT1) numerate maxfetch (x i j) drop lop "i" book
                  i n <>
                  IF (hT) dup i reach (qS) notrailing " max" tail (qS)
                     (hT qS) over i (qS hT n) said (hT)
                  THEN (hT)
               ELSE " bcDATA: open interest not found" nl (hT)
               THEN (hT)
            ELSE 
               " bcDATA: contract " S1 MOdo + " not found" + . nl (hT)
            THEN (hT)

         ELSE VOL tpurged (hT)
         THEN (hT)

      ELSE VOL tpurged (hT)
      THEN
      "_" S1 lowercase (qS) + naming
   end

   inline: bcDECIMAL (qS n --- hT) \ process S
      (n) "bcPROCESS" "FAC" bank
      (qS) bcPROCESS
   end

   inline: bcEDATA (qS --- hT) \ electronic data for S
      "bcDATA" "PIT" yank "pit" book
      no "bcDATA" "PIT" bank
      bcDATA
      pit "bcDATA" "PIT" bank
   end

   inline: bcEOD ( --- hT) \ data from bch at end of day
      [ 6 "KEEP" book ]
      tracklist "TRACK" book

      yes "bcPROCESS" "EOD" bank

      time push
      depth push
      "From bcEOD, file bch.v"

      time GMT>LA ctime 1st quote strchop neat

      "Showing: Open High Low Settle Close Chg Vol OpenInt"
      " "
      TRACK rows 1st
      DO
         TRACK I quote bcDATA any?
         IF (hT) 1st over rows KEEP min items reach (hT)

            this 8 ndx word drop
            numerate totals ontop @ 1 max int$ "V" book
            this 9 ndx word drop
            numerate totals ontop @ 1 max int$ "OI" book

            TRACK I quote spaced
            " VOL and OI totals: " cat V cat spaced OI cat neat

            swap

         ELSE TRACK I quote spaced date cat " no data" cat
         THEN
         " "
      LOOP
      depth pull less pilen

      "ET: " time pull less 60 slash "%0.1f" format cat
      " minutes" cat pile
      "_bcEOD" naming

      no "bcPROCESS" "EOD" bank
   end
 
   inline: bcGET (qS --- hT) \ data from barchart.com
      [ 
      \ "http://www2.barchart.com" "IP" book

      \ Fri Apr  5 17:04:49 PDT 2013.  DNS is not working, and _IPhost
      \ hangs.  This is the IP for www.insidestocks.com:
        "http://8.18.161.81" "IP" book 
      \ "http://www.insidestocks.com" "IP" book \ May 3, 2010

       \ Here is a typical string made below for HTTPget:
       \    "http://www2.barchart.com/dfutpage.asp?sym=HG&code=BSTK" 
      ]
    \ Fri Jul 13 15:09:21 PDT 2012
      "HTTPget" "netscapeUA" yank "HTTPget" "UA" bank

      "bcPROCESS" "EOD" yank
      IF (qS) IP (qHost)

       \ Put the site name into HTTPget.Host_alias and it will
       \ go into the credentials, then use IPhostr to get an IP:
         (qHost) dup "HTTPget" "Host_alias" bank

         (qHost) IPhostr (qIPaddr) any? \ get IP 
         IF one endmost "/dfutpage.asp?sym="
            rot uppercase + "&code=BSTK" + HTTPget (hT)
         ELSE "" "HTTPget" "Host_alias" bank 
            "" \ return an empty string
         THEN
      ELSE (qS) IP (qHost)

       \ Put the site name into HTTPget.Host_alias and it will
       \ go into the credentials, then use IPhostr to get an IP:
         (qHost) dup "HTTPget" "Host_alias" bank

         (qHost) IPhostr (qIPaddr) any? \ get IP 
         IF time push that (qS) push

            one endmost "/ifutpage.asp?sym="
            rot uppercase + "&code=BSTK" + HTTPget (hT)

            pull (qS) spaced "bcGET" + spaced
            those textput chars (bytes) time pull less 
            (qS bytes delta) msgSPEED

         ELSE "" "HTTPget" "Host_alias" bank 
            "" \ return an empty string
         THEN
      THEN
      dup "T" book \ saved for debugging
   end

   inline: bcNUMS (hT --- hT1) \ T1 has only number-related characters
      [ "0123456789-+." "NUMS" book ]
      NUMS chkeep
   end

   inline: bcPROCESS (qS --- hT) \ get and process S
      [ no "EOD" book
      \ Defaults:
          no "SPECIAL" book
          one "FAC" book
      ]
      EOD
      IF SPECIAL "bcPROCESS2" "SPECIAL" bank
         FAC "bcPROCESS2" "FAC" bank
         bcPROCESS2
      ELSE
         SPECIAL "bcPROCESS1" "SPECIAL" bank
         FAC "bcPROCESS1" "FAC" bank
         bcPROCESS1
      THEN

    \ Reset the defaults:
      no "SPECIAL" book
      one "FAC" book
   end

   inline: bcPROCESS1 (qS --- hT) \ intraday, get and process S
   {  Revised July 2011.

       Debugging:
       Set:
          no "bcPROCESS" "EOD" bank
       run this to set FAC and SPECIAL:
          "us" bcDATA

       and use "HALTING" . nl HALT in various places and source this
       word using these phrases in work.v:

          'bch.v' 'DUH' msource
          no 'bcPROCESS' 'EOD' bank
          'us' bcDATA drop
          'us' bcPROCESS
          'bcPROCESS1' 'T' yank "T" book
          'bcPROCESS1' 'FAC' yank "FAC" book

      Order of intraday data:
         Contract
         Last or Settle
         Change
         Open
         High
         Low
         Previous day Settle
         Time of day
   }
      no "bcPROCESS" "EOD" bank

      (qS) uppercase (qS) dup "SYM" book
      (qS) bcGET (hT) any? not IF "" return THEN

      (hT) textget (hT) dup "TSAVE" book
      (hT) dup 1st 16 items catch (hC) 
      (hC) dup '<tr class="even"' grepr swap
      (hC) '<tr class="odd">' grepr pile yes sort (hR)

      (hT hR) dup rows 0= 
      IF "bcPROCESS1: no prices found" . nl 
         (hT hR) 2drop no no blockofblanks return 
      THEN

      (hT hR) reach (hT)
      "Y00" "" qreplace \ remove cash price
      " (" tug \ shift right
      "</td><td" " " strp 
      "()>" chblank (hT)
      "</a" " " strp

    \ Tue Dec 13 16:04:36 PST 2011.  Modifications:
      "class=" " " strp
      '"up"' " " strp
      '"down"' " " strp
      '"unch"' " " strp

      "unch"   "0" strp
      "&nbsp;" "0" strp
      "s"      " " strp \ remove char on Settle
      noblanklines

      (hT) any?
      IF SPECIAL 0<> IF (hT) SPECIAL exe THEN (hT) "T" book
         T 
         T 2nd word drop numbers numbad
         T 3rd word drop numbers numbad or
         T 4th word drop numbers numbad or
         T 5 ndx word drop numbers numbad or 
         T 6 ndx word drop numbers numbad or 

         (hT hR) rake drop "T" book

         T rows 1 <
         IF "bcPROCESS1: price matrix is empty after rake" . nl
            no no blockofblanks return
         THEN

         depth push
            T 1st word drop
            SYM dup bcSYM' replace$ Mo_fix spaced           \ SymMo

            T 4th word drop numerate FAC star int$ spaced   \ open
            T 5 ndx word drop numerate FAC star int$ spaced \ high
            T 6 ndx word drop numerate FAC star int$ spaced \ low
            T 2nd word drop numerate FAC star int$ spaced   \ settle
            this chop "c" nose spaced                       \ close
            T 3rd word drop numerate FAC star int$ spaced   \ chg
         depth pull less parkn

         " 0 0 00:00:00" tail \ dummy vol, opint and time

      ELSE "bcPROCESS1: price matrix is empty" . nl
         no no blockofblanks
      THEN
   end

   inline: bcPROCESS2 (qS --- hT) \ end of day, get and process S
      { Revised September 2010.  Old version is in the Appendix.

        Debugging:
        Set:
           yes "bcPROCESS" "EOD" bank 
        run this to set FAC and SPECIAL:
           "us" bcDATA

        and use "HALTING" . nl HALT in various places and source this
        word using these phrases in work.v:

           'bch.v' 'DUH' msource
           yes 'bcPROCESS' 'EOD' bank
           'us' bcDATA drop
           'us' bcPROCESS
           'bcPROCESS2' 'T' yank "T" book
           'bcPROCESS2' 'FAC' yank "FAC" book
      }
      yes "bcPROCESS" "EOD" bank

      (qS) uppercase (qS) dup "SYM" book
      (qS) bcGET (hT) any? not IF "" return THEN

      (hT) textget (hT) dup "TSAVE" book
      (hT) dup 1st 16 items catch (hC) 
      (hC) dup '<tr class="even"' grepr swap
      (hC) '<tr class="odd">' grepr pile yes sort (hR)

      (hT hR) dup rows 0= 
      IF "bcPROCESS2: no prices found" . nl 
         (hT hR) 2drop no no blockofblanks return 
      THEN

      (hT hR) reach (hT)
      "Y00" "" qreplace \ remove cash price
      " (" tug \ shift right
      "</td><td" " " strp 
      "()>" chblank (hT)
      "</a" " " strp

    \ Tue Dec 13 16:04:36 PST 2011.  Modifications:
      "class=" " " strp
      '"up"' " " strp
      '"down"' " " strp
      '"unch"' " " strp

      "unch"   "0" strp
      "&nbsp;" "0" strp
      noblanklines

      (hT) any?
      IF SPECIAL 0<> IF (hT) SPECIAL exe THEN (hT) "T" book
         T
         T 2nd word drop numbers numbad
         T 3rd word drop numbers numbad or
         T 4th word drop numbers numbad or
         T 5 ndx word drop numbers numbad or 
         T 6 ndx word drop numbers numbad or 
         T 7 ndx word drop numbers numbad or 
         T 8 ndx word drop numbers numbad or 

         (hT hR) rake drop "T" book

         depth push
            T 1st word drop
            SYM dup bcSYM' replace$ Mo_fix spaced           \ SymMo

            T 4th word drop numerate FAC star int$ spaced   \ open
            T 5 ndx word drop numerate FAC star int$ spaced \ high
            T 6 ndx word drop numerate FAC star int$ spaced \ low
            T 2nd word drop numerate FAC star int$ spaced   \ settle
            this chop "c" nose spaced                       \ close
            T 3rd word drop numerate FAC star int$ spaced   \ chg
            T 7 ndx word drop spaced                        \ vol
            T 8 ndx word drop spaced                        \ opint
         depth pull less parkn

      ELSE "bcPROCESS2: price matrix is empty" . nl
         no no blockofblanks
      THEN
   end

   inline: bcSYM (qS --- qS1) \ bc symbol
      [ "w c s sm bo lc lh pb cc kc sb jo hg gc pl si "
        "ct cl ho hu ng sf eu jy mp bp us tn ff ed " pile
        "dj sp nq yx nk" pile lowercase words (hKeys)

        "w c s sm bo lc lh pb cc kc sb oj hg gc pl si "
        "ct cl ho rb ng sf ec jy mq bp us ty ff ed " pile
        "dj sp nd yv nk" pile lowercase words (hVals)

        (hKeys hVals) 100 defname "SYM" localref hash_make
      ]
      "bcDATA" "PIT" yank
      IF (qS) lowercase SYM swap hash_lookup drop any?
         IF 1st quote uppercase ELSE "" THEN 
      ELSE (qS) drop "" \ bc does not do electronic
      THEN
   end

   inline: bcSYM' (qS1 --- qS) \ bc inverse symbol
      [ "bcSYM" "SYM" yank (hHASH)
        dup hash_Vals swap hash_Keys
        (hKeys hVals) 100 defname "SYM" localref hash_make
      ]
      "bcDATA" "PIT" yank
      IF (qS1) lowercase SYM swap hash_lookup drop any?
         IF 1st quote uppercase ELSE "" THEN 
      ELSE (qS) drop "" \ bc does not do electronic
      THEN
   end

   inline: bcTIME (qMkt --- qTIME) \ word to run to convert time string
   \ Thu May  6 16:30:21 PDT 2010 Revised to use internal string MKT
      [ {"
           CH>LA W
           CH>LA C
           CH>LA S
           CH>LA SM
           CH>LA BO

           CH>LA LC
           CH>LA LH
           CH>LA PB

           CH>LA CC
           CH>LA KC
           CH>LA SB
           CH>LA JO

           CH>LA HG
           CH>LA GC
           CH>LA SI
           CH>LA PL

           CH>LA CT
           CH>LA CL
           CH>LA HO
           CH>LA HU
           CH>LA NG

           CH>LA SF
           CH>LA EU
           CH>LA JY
           CH>LA MP
           CH>LA BP

           CH>LA US
           CH>LA TN
           CH>LA FF
           CH>LA ED

           CH>LA DJ
           CH>LA SP
           CH>LA NQ
           CH>LA YX
           CH>LA NK
        "} asciify noblanklines chop
        dup 1st word drop "qTIME" book
        2nd word drop "MKT" book
      ]
      strchop "N" book
      MKT N uppercase grepe any? not
      IF "  bcTIME: market " N + " not found" + ersys return THEN
      qTIME swap reach chop
   end

   private halt

\-----------------------------------------------------------------------

   Appendix

These have VOL and OI, 30000 byte files:

"http://www2.barchart.com" "/dfutpage.asp?sym=W" HTTPget eview
"http://www2.barchart.com" "/dfutpage.asp?sym=C" HTTPget eview
"http://www2.barchart.com" "/dfutpage.asp?sym=S" HTTPget eview
"http://www2.barchart.com" "/dfutpage.asp?sym=SM" HTTPget eview
"http://www2.barchart.com" "/dfutpage.asp?sym=BO" HTTPget eview
"http://www2.barchart.com" "/dfutpage.asp?sym=TY" HTTPget eview


<TR BGCOLOR=#666699 class=bcMTitle>
  <TD ALIGN="CENTER" VALIGN="TOP" class=bcMTitle> Contract </TD>
  <TD ALIGN="CENTER" VALIGN="TOP" class=bcMTitle> Last </TD>
  <TD ALIGN="CENTER" VALIGN="TOP" class=bcMTitle> Change </TD>
  <TD ALIGN="CENTER" VALIGN="TOP" class=bcMTitle> Open </TD>
  <TD ALIGN="CENTER" VALIGN="TOP" class=bcMTitle> High </TD>
  <TD ALIGN="CENTER" VALIGN="TOP" class=bcMTitle> Low </TD>
  <TD ALIGN="CENTER" VALIGN="TOP" class=bcMTitle> Volume </TD>
  <TD ALIGN="CENTER" VALIGN="TOP" class=bcMTitle> Open Int </TD>
</TR>

\-----------------------------------------------------------------------

   Old version of bcPROCESS2 before July 2011 revision:
   inline: bcPROCESS1 (qS --- hT) \ intraday, get and process S
   {  
      Order of intraday data:
         Contract
         Last or Settle
         Change
         Open
         High
         Low
         Previous day Settle
         Time of day
   }
      [
        {"
        noblanklines any?
        IF bcNUMS SPECIAL exe? drop
           numerate FAC star int$ chop spaced
        ELSE "0 "
        THEN hand
        "} "SCALE" macro
      ]
      (qS) uppercase
      no "bcPROCESS" "EOD" bank

      (qS) dup bcSYM' bcTIME "qTIME" book
      (qS) dup "SYM" book bcGET (hT) any? not IF "" return THEN
      (hT) these rows 1 = IF textget THEN (hT)

    \ Return empty if no "Date:" string:
      (hT) dup dup "Date:" grepr any? not IF drop "" return THEN

      (hT hRow) 1st pry (hT row) reach words 6 ndx quote "TIME" book

    \ Return empty if no "<tr class=" strings:
      (hT) these "<tr class=" grepr (hRows) any? not

      IF (hT) drop "" return THEN

      (hT hRows) reach "T" book

      T '<td align="left" class="bcText"' grepr
      T rows pile "FROM" book \ dummy last row
      FROM delta "LEN" book, LEN 2nd pry LEN 1st poke

      depth push
      FROM rows nit 1st
      DO T FROM I pry LEN I pry items reach notrailing
         (hT) '">' "</" between any?
         IF (hT) "&nbsp;" "0" replace$ (hT) push
            
            peek 1st quote "sym=" "&code" between chop spaced
            SYM dup bcSYM' replace$ Mo_fix spaced hand \ SymMo
            peek 4 ndx quote SCALE       \ open
            peek 5 ndx quote SCALE       \ high
            peek 6 ndx quote SCALE       \ low
            peek 2 ndx quote SCALE       \ settle
            "c" over cat hand            \ close
            peek 3 ndx quote strchop any?
            IF "unch" " 0 " replace$ SCALE \ change
            ELSE " 0 " hand
            THEN
            " ----- " hand               \ vol
            dup                          \ open int

            pull 8 ndx quote (14:43 or 10/28/04)
            "bcNUMS" "NUMS" yank
            ":/" cat chkeep chop hand

            dup ":" grepr rows any
            those chars 1 > and          \ not just :

            IF ":00" cat qTIME main      \ to local time
            ELSE drop "00:00:00"         \ date becomes 00:00:00
            THEN hand                    \ time

            ten parkn
         THEN
      LOOP
      depth pull less any? IF (n) pilen neat ELSE "" THEN
   end

   Old version of bcPROCESS2 before September 2010 revision:
   inline: bcPROCESS2 (qS --- hT) \ end of day, get and process S
      {
         Debugging:
         Set:

            yes "bcPROCESS" "EOD" bank

          run this to set SPECIAL:
            "us" bcDATA

         and use "HALTING" . nl HALT in various places and source this
         word using these phrases in work.v:

            'bch.v' 'DUH' msource
            yes 'bcPROCESS' 'EOD' bank
            'us' bcDATA drop
            'us' bcPROCESS
            'bcPROCESS2' 'T' yank "T" book
            'bcPROCESS2' 'FAC' yank "FAC" book
      }
      yes "bcPROCESS" "EOD" bank

      (qS) uppercase (qS) dup "SYM" book
      (qS) bcGET (hT) any? not IF "" return THEN

      (hT) html2text asciify (hT) "(" SYM + NLch SYM + strp textget
      dup "T0" book
      "HTTP"  "" qreplace
      "Win32" "" qreplace \ gets caught when doing "W" (wheat)
      "Y00"   "" qreplace

      "unch"   "0" strp
      "&nbsp;" "0" strp \ not into blanks; need for zeroes left blank
      ")"      ""  strp

      {  September 3, 2009
         Error processing US.  Thinking is was the ending garbage
         text, this test to truncate T to 200 chars was added.

         Later it was learned that the error is somehow related to
         32nds processing but this test has been left in.

         Switched US back to "bc32nds" from "bc64ths_tmp" and it runs
         ok.  Why?  Has received data reverted to 2 digits?  The note
         in bc64ths_tmp, January 2009, shows 3 digits.
      }
      dup chars 200 > IF 1st 200 items catch  THEN
      noblanklines any?

      IF SPECIAL 0<> IF (hT) SPECIAL exe THEN (hT)
         "T" book
      {
       { December 2007
         Sometimes commentary accompanies T; want only the rows with
         the requisite number of purely numerical columns, which is 7.

         Since it is unlikely that a commentary row would have 7 or
         more columns of numbers, the following imperfect strategy
         is used to strip out commentary:
       } T (hT)
         T rows columnofints spaced T park (hT1) \ 8 columns of nums
         8 matread 1st catch (hRows) \ a vector with valid rows to use
         (hT hRows) reach "T" book

         January 2008
         Well, that doesn't work.  On January 11, hit a bad last row
         that did contain at least 8 numbers, so it got included.
         Here is another strategy, looking at columns 2, 3, 4 and 5
         and flagging rows with bad numbers, then raking just the
         ones with good numbers:

       }
         T
         T 2nd word drop numbers numbad
         T 3rd word drop numbers numbad or
         T 4th word drop numbers numbad or
         T 5 ndx word drop numbers numbad or (hT hR)
         (hT hR) rake drop "T" book

         depth push
            T 1st word drop
            SYM dup bcSYM' replace$ Mo_fix spaced           \ SymMo

            T 4th word drop numerate FAC star int$ spaced   \ open
            T 5 ndx word drop numerate FAC star int$ spaced \ high
            T 6 ndx word drop numerate FAC star int$ spaced \ low
            T 2nd word drop numerate FAC star int$ spaced   \ settle
            this chop "c" nose spaced                       \ close
            T 3rd word drop numerate FAC star int$ spaced   \ chg
            T 7 ndx word drop spaced                        \ vol
            T 8 ndx word drop spaced                        \ opint
         depth pull less parkn

      ELSE no no blockofblanks
      THEN
   end

