{  File cme.v  September 2011

   Copyright (c) 2011   D. R. Williamson

   Words for fetching data from CME E-quotes table.

------------------------------------------------------------------------

   CME E-quotes data is displayed and continuously updated in a window 
   on a Windows machine.  

   The Windows machine connects as a client to an NFS (Network File
   System) server on a Linux machine, and periodically places into their
   shared NFS directory a snapshot of the data currently showing in the
   E-quotes window.

   NFS allows user programs like the snapshot program on the Windows 
   machine, and this one here on a Linux machine, to write and read the
   shared file as if it resides on either local machine.  In reality,
   the shared file actually resides on the Linux machine from the moment
   it is written, because the Linux machine is acting as the NFS server.

   No file transfer between machines ever takes place in NFS.

   Word nfs_load in word cme_process places the data file on the stack,
   where it is formatted into the standard form for collection output, 
   matching the tables produced by other collector programs like tch1.v,
   ino.v and bch.v.

   The table below shows the data as it is formatted in the displayed
   table on the Windows machine.  Columns shown have been chosen for
   this application from the menu choices available to users of the 
   Windows CME E-quotes program, and so are unique to this application:

      Contract     High     Low      Last       Change  Timestamp       Open     Vol   Opn Int Prev Settle
      6EU11 (D10)  1.4007   1.3991   1.4004 D   0.0018  6:33:56 PM CDT  1.4000   2058  177942  1.3986
      6SU11 (D10)  1.1614   1.1599   1.1609 D   -0.0003 6:33:08 PM CDT  1.1602   354   41895   1.1612
      6JU11 (D10)  1.2897   1.2867   1.2891 D   0.0009  6:31:13 PM CDT  1.2893   1401  127491  1.2882

      CLV11 (D10)  86.56    86.32    86.51 D    0.49    7:33:51 PM EDT  86.50    766   277716  86.02
      HGZ11 (D10)  4.0755   4.0605   4.0740 D   0.0180  7:32:27 PM EDT  4.0615   208   76490   4.0560
      GCZ11 (D10)  1878.0   1870.0   1877.0 D   3.7     7:33:51 PM EDT  1876.0   2886  345902  1873.3

      YMU11 (D10)  11158.00 11122.00 11155.00 D 27.00   6:33:59 PM CDT  11126.00 948   72299   11128.00
      ESU11 (D10)  1168.00  1163.75  1167.75 D  3.25    6:33:58 PM CDT  1164.50  18837 3528629 1164.50
      NQU11 (D10)  2172.75  2164.75  2170.75 D  5.50    6:33:33 PM CDT  2165.50  1245  371677  2165.25

      ZBZ11 (D10)  140^22   140^18   140^19 D   -0^7    6:30:29 PM CDT  140^21   655   608206  140^26
      ZNZ11 (D10)  130^08.5 130^06.5 130^06.5 D -0^03.0 6:30:37 PM CDT  130^08.5 2888  1725046 130^09.5

   The file placed on the Linux NFS server by the Windows NFS client,
   called /nfs/solano/equotes.txt, contains the table above and some 
   additional lines that hold each row of the table.  

   The phrases immediately below skip the table and fetch just the ad-
   ditional row data from the file:

      "/nfs/solano/equotes.txt" nfs_load textget 
      "<td>" "</td>" between noblanklines (hT)

   This shows data for the first two rows (6EU11 and 6SU11, with a blank
   line between added for clarity) that are in VOL T now on the stack:

      6EU11 (D10)
      1.4007
      1.3991
      1.4004 D
      0.0018
      6:33:56 PM CDT
      1.4000
      2058
      177942
      1.3986

      6SU11 (D10)
      1.1614
      1.1599
      1.1609 D
      -0.0003
      6:33:08 PM CDT
      1.1602
      354
      41895
      1.1612

------------------------------------------------------------------------

   Words

   usrpath "cme.v" + asciiload this " inline:" grepr reach dot

   Processing data
   inline: BEEP ( --- ) \ error alarm
   inline: BOND (hT qTIME qCON qSYM --- ) \ process bond market prices
   inline: cme_process ( --- ) \ process market data from CME E-quotes
   inline: DECIMAL (hT qTIME qCON nFAC qSYM --- ) \ decimal prices
   inline: FILE_IN ( --- qFile) \ name of input file
   inline: FILE_OUT (qSYM --- qFile) \ name of output file
   inline: FILE_SEND (qFile --- ) \ send file to remote
   inline: logLAN1 ( --- f) \ report to the head machine over the LAN
   inline: mrc_close ( --- ) \ close market data resources
   inline: mrc_open ( --- f) \ open market data resources on plunger
   inline: PROCESS (hA qTIME qCON qSYM --- ) \ market SYM to file
   inline: SYM_OUT (qFile --- qSYM) \ market symbol from File name

   Collecting data
   inline: COLLECT ( --- ) \ process file from NSF client on Windows
   inline: COLLECT_START ( --- ) \ start multitasker COLLECT
   inline: COLLECT_END ( --- ) \ end multitasker clickRefresh
   inline: START ( --- ) \ depending on time of day, set the start task
   Also see word ALARMcme in uboot.v at mytops/usr.

------------------------------------------------------------------------
}

   CATMSG push no catmsg

   "MOdo" missing IF "mrc.v" source THEN

\-----------------------------------------------------------------------

\  Words for processing data:

   inline: BEEP ( --- ) \ error alarm
      3 1 DO beep .2 idle beep 1 idle LOOP ;

   inline: BOND (hT qTIME qCON qSYM --- ) \ process bond market prices
    \ Wed Sep  7 14:50:19 PDT 2011

    \ Format bond and note prices and write collection file.

      [ list: 0 0 0 0 0 0 1 1 ; "R" book ]

      "SYM" book "CON" book "TIME" book 

    \ Separate prices from volume and open interest:
      (hT) R rake (hT hV) push (hT) \ push V to temp stack 

      (hT) ".^" chblank push
      peek 1st word drop right justify (hA)

    \ Warning: There is no leading zero for US 32nds less than 10. 
    \ For example, get 141^8 instead of 141^08.  Add a leading zero 
    \ to B in cases like this.  Treasury Notes, TN, are ok but can 
    \ just go along for the ride.

      peek 2nd word drop (hB)
      SYM "TN" = IF peek 3rd word drop cat THEN pull drop (hB)

      (hB) numerate "no format" (hB qFormat)
      SYM "US" = IF drop "%02.f" THEN
      SYM "TN" = IF drop "%03.f" THEN 
      (qFormat)

      (qFormat) dup "no format" = \ error if no format is on the stack
      IF " BOND: market is not US or TN" . nl drop "%02.f" THEN
      (hB qFormat) format (hB)

      (hA hB) park \ no blanks

      pull (hV) pile "T" book \ append V (volume and open interest)

      SYM MOdo CON <>
      IF " BOND: wrong contract for " SYM + . nl return THEN

      T dup chars 2 + blpad "T" book \ pad spaces for "c"

      "c" T 5 quote strchop + T 5 said \ c prefix to last price
      date " SESS " + time tsession - 0.5 + integer intstr + (qHEAD)

    \ Send last line of previous file too:
      SYM FILE_OUT (qFile) dup file?
      IF (qFile) asciiload 1 endmost (qPREV) \ previous data
         (qHEAD qPREV) pile
      ELSE drop
      THEN

      SYM CON +
      T
      TIME (qTIME)
      3 pilen vol2str neat (qS)

      (qHEAD qS) pile (hT) SYM FILE_OUT save

    \ " BOND: " SYM + " written to " + SYM FILE_OUT + spaced date +
    \ . nl

      SYM FILE_OUT (qFile) FILE_SEND
   end
      
   inline: cme_process ( --- ) \ process market data from CME E-quotes
{     Wed Sep  7 12:17:38 PDT 2011

      Process data from CME E-quotes table, and write files in /tmp 
      that match files from the regular collectors, so they will be 
      picked up when hist_add() runs to append latest data to each 
      market's history file.

      This word parallels word cache_process() in file tch1.v used as
      a template.  Many other words in this file come from tch1.v with
      few changes.
}
      [ list: \ Market symbols (this program's symbols shown on right):
           ZN \ TN 10-year Treasury Notes
           ZB \ US 30-year Treasury Bonds
           CL \ CL Crude Oil
           HG \ HG High Grade Copper
           GC \ GC Gold Comex
           6E \ EU Euros
           6S \ SF Swiss Francs
           6J \ JY Japanese Yen
           YM \ DJ Dow Jones Industrial Average
           ES \ SP Standard and Poors Stock Index
           NQ \ NQ Nasdaq Stock Index
        end words noq_alike "SYM_TABLE" book
{   
      \ Put desired symbols and uncomment this segment for debugging:
        list: \ Market symbols (this program's symbols shown on right):
           CL \ SP Standard and Poors Stock Index
        end words noq_alike "SYM_TABLE" book
}
{       Settle is for the previous session, which is the way it should
        be.  Collections from other sources do not handle Settle cor-
        rectly (probably due to my collectors as opposed to the sites)
        and Settle is usually the same as Last.  This collection will 
        have it right. 

        Fetch the price rows from U (see "rows of U" below) in the 
        order: 
           Open, High, Low, Settle, Last, Change, Volume, Open Interest:
}          7     2     3    10      4     5       8       9 
        8 listn (hA) ndx "Urake" book
      ]
    \ Running on an ALARM set in COLLECT.
      " cme_process: begin " date + . nl

      FILE_IN any?
      IF (qFile) nfs_load textget
         "<td>" "</td>" between (hT) "T" book \ keep blank lines in T
         T noblanklines rows 0> not
         IF " cme_process: no data found " date + . nl
            mrc_close return
         THEN
      ELSE \ input file not found or has not changed
         " cme_process: file not found or unchanged " date + . nl
         mrc_close return 
      THEN

    \ Loop over T for each symbol and extract its data:
      SYM_TABLE rows 1st
      DO SYM_TABLE I quote strchop "SYM" book
{
         Sun Nov  6 15:34:01 PST 2011.  Today is the first day of 
         standard time, and east coast time EDT changed to EST.  Now 
         EST conflicts with search for symbol ES and the program fails
         to detect ES data because string EST is all over the place.  

         Market symbols are upper case.  Make time symbols in T lower 
         case and revise word TIME>LA (file cal.v) to work with lower
         or upper case.
}        T 
         "EST" "est" strp "CST" "cst" strp 
         "EDT" "edt" strp "CDT" "cdt" strp (hT)

         (hT) dup SYM grepr any? 
         IF (hT hR) 1 endmost @ 10 items reach "U" book
{
            When SYM = ZN, here are rows of U (with notes added after 
            the backslash):

               ZNZ11 (D10)      \ D10 means 10 minute delay
               130^08.5         \ High
               130^06.5         \ Low
               130^06.5 D       \ Last (D means delayed**)
               -0^03.0          \ Change
               6:30:37 PM CDT   \ Timestamp (about 10 minutes ago)
               130^08.5         \ Open
               2888             \ Volume
               1725046          \ Open Interest
               130^09.5         \ Previous Settle

         ** Symbols observed to accompany Last have been D (delayed),
            S (settle) and P (previous).  

            Fractional parts for ZN (10-year Treasury Notes) are quoted 
            in 32nds.  In the data above, ^03.0 is 3 32nds, and ^09.5 
            is 9.5 32nds or 19 64ths (but Bond guys don't speak in
            64ths).

            Here is an example for HG that has a range for Open that
            the code must accommodate:

               HGZ11 (D10)
               4.1420
               4.0385
               4.0385 D
               -0.1050
               9:10:35 AM EDT
               4.1295 - 4.0500  \ Open
               14159
               78889
               4.1435
}
            U 8 ndx quote number (0 or nV -1) \ fetch Volume
            IF (n) 0> 
            ELSE " cme_process: volume is zero for " SYM + . nl false 
            THEN (f)

            IF \ Volume is greater than zero
             \ Get the time.  Times in the output data are quoted as LA:
               U 6 ndx quote TIME>LA (qHH:MM:SS) "TIME" book

             \ Get the contract:
               U 1st quote 1st word drop SYM chars negate indent (qS)
               (qS) "CON" book

             \ Fetch the price rows from U in the order 
             \   Open, High, Low, Settle, Last, Change
             \ and take just the first word in any row (this ignores
             \ ranges like HG Open above):
               U Urake reach "DPS" chblank (hT) 
               (hT) 1st word (hT f) drop (hT) 
{
            After fetching price rows in the order of Urake, here is T
            on the stack for the example of HG above.  Just the first
            value of the Open range is used:

               4.1295  \ Open
               4.1420  \ High
               4.0440  \ Low
               4.1435  \ Settle
               4.0480  \ Last
               -0.0955 \ Change

            Fri Sep 23 08:26:53 PDT 2011.  Volume and open interest are
            being collected too.  Here is T on the stack for HG after 
            Urake:
               3.4500  \ Open
               3.4950  \ High
               3.2150  \ Low
               3.4885  \ Settle
               3.3835  \ Last
               -0.1050 \ Change
               63968   \ Volume
               81762   \ Open Interest
}
             \ Process this market and write its file:
               (hT) TIME CON SYM PROCESS

            ELSE " cme_process: no data in U for " SYM + . nl
            THEN
         ELSE (hT) drop
            " cme_process: no data in T for " SYM + . nl
         THEN
      LOOP

    \ Write the time of processing to a log at FILE_IN.PATH:
      time intstr (nt) "FILE_IN" "PATH" yank "cme_process.log" + (qFile)
      (nt qFile) save \ time log for ALARMcme

      mrc_close \ close resources
   end

   inline: DECIMAL (hT qTIME qCON nFAC qSYM --- ) \ decimal prices
    \ Wed Sep  7 16:56:44 PDT 2011

    \ Apply factor, FAC, to decimal data and write collection file.

      "SYM" book "FAC" book "CON" book "TIME" book "T" book

      SYM MOdo CON <>
      IF " DECIMAL: wrong contract for " SYM + . nl return THEN
{
      These are eight typical rows of incoming T for decimal processing
      of HG, where FAC is 10000 and will scale the first six rows, and
      just a factor of one will scale the last two rows:

         3.4500  \ Open
         3.4950  \ High
         3.2150  \ Low
         3.4885  \ Settle
         3.3445  \ Last
         -0.1440 \ Change
         65424   \ Volume
         81762   \ Open Interest

      For the HG data above, this is what the output file looks like:
         Fri Sep 23 08:52:15 PDT 2011 SESS 1316728800
         HGZ11 34500 34950 32150 34885 c33445 -1440 65424 81762 08:41:55
}
    \ Scale prices by FAC, volume and open interest by one:
      T numerate FAC 6 1 fill, one 2 1 fill pile *by integer

      "%0.0f" format dup chars 2 + blpad "T" book \ pad for "c"
      "c" T 5 quote strchop + T 5 said \ c prefix to last price

      date " SESS " + time tsession - 0.5 + integer intstr + (qHEAD)

    \ Send last line of previous file too:
      SYM FILE_OUT (qFile) dup file? 
      IF (qFile) asciiload 1 endmost (qPREV) \ previous data
         (qHEAD qPREV) pile 
      ELSE drop
      THEN 

      SYM CON +
      T
      TIME (qTIME)
      3 pilen vol2str neat (qS) 

      (qHEAD qS) pile (hT) SYM FILE_OUT save

    \ " DECIMAL: " SYM + " written to " + SYM FILE_OUT + spaced date +
    \ . nl

      SYM FILE_OUT (qFile) FILE_SEND
   end

   inline: FILE_IN ( --- qFile) \ name of input file
    \ Wed Sep  7 14:30:22 PDT 2011
      [ "" dup "PATH" book "FILE" book

        host "plunger" =
        IF "/nfs/solano/" "PATH" book "equotes.txt" "FILE" book THEN

        host "riggo" =
        IF "/nfs/solano/" "PATH" book "equotes.txt" "FILE" book THEN

        PATH FILE + file? not
        IF " FILE_IN: file " FILE + " not found, halting" + . nl
           HALT
        THEN

        0 "prevtime" book
{
------------------------------------------------------------------------

 New logic in FILE_IN: A case where file was unchanged, and ALARM 
 period was reduced to pick up next file sooner under the assumption 
 that it will be written momentarily:

 logLAN: OK Thu Sep 15 06:15:57 PDT 2011
 mrc_open: OK files from 127.0.0.1 Thu Sep 15 06:15:58 PDT 2011
 cme_process: begin Thu Sep 15 06:16:03 PDT 2011
 FILE_IN: file equotes.txt is unchanged Thu Sep 15 06:16:03 PDT 2011
 FILE_IN: adjusting ALARM for next COLLECT
 cme_process: file not found or unchanged Thu Sep 15 06:16:03 PDT 2011
 mrc_close: sockets closed Thu Sep 15 06:16:03 PDT 2011

 Processing resumed about 30 seconds later, not 60:

 logLAN: OK Thu Sep 15 06:16:33 PDT 2011
 mrc_open: OK files from 127.0.0.1 Thu Sep 15 06:16:34 PDT 2011
 cme_process: begin Thu Sep 15 06:16:39 PDT 2011
 FILE_SEND: OK /tmp/TN_CME.eDAT to 127.0.0.1 Thu Sep 15 06:16:39 ...
 ...

------------------------------------------------------------------------

 Old logic in FILE_IN: A case where file was unchanged:

 logLAN: OK Tue Sep 13 17:11:56 PDT 2011
 mrc_open: OK files from 127.0.0.1 Tue Sep 13 17:11:57 PDT 2011
 cme_process: begin Tue Sep 13 17:12:02 PDT 2011
 cme_process: file not found or unchanged Tue Sep 13 17:12:02 PDT 2011
 mrc_close: sockets closed Tue Sep 13 17:12:02 PDT 2011

 Processing resumed about 60 seconds later:

 logLAN: OK Tue Sep 13 17:12:58 PDT 2011
 mrc_open: OK files from 127.0.0.1 Tue Sep 13 17:12:59 PDT 2011
 cme_process: begin Tue Sep 13 17:13:04 PDT 2011
 FILE_SEND: OK /tmp/TN_CME.eDAT to 127.0.0.1 Tue Sep 13 17:13:04 ...
 ...

------------------------------------------------------------------------
}
      ]
      PATH FILE + file? not
      IF " FILE_IN: file " FILE + " not found " + date + . nl
         "" (qFile) \ file not found, return empty string
{
         FILE may have been being written, and therefore was busy and 
         not found.  Assuming this to be the case, modify the ALARM
         just set by COLLECT to put it out of phase with the writing
         of FILE (just halve the period because COLLECT.COLLECT_SEC
         matches the period that Windows writes FILE to the nfs direc-
         tory--see word COLLECT):
}        " FILE_IN: adjusting ALARM for next COLLECT" . nl
         "COLLECT" "COLLECT_SEC" yank 2 / "COLLECT" ALARM

      ELSE PATH FILE + filetime dup prevtime >
         IF (ntime) "prevtime" book PATH FILE + (qFile)
         ELSE drop 
            " FILE_IN: file " FILE + " is unchanged " + date + . nl
            "" (qFile) \ file unchanged, return empty string

          \ FILE with new info is probably about to be written.  Like
          \ the case above, modify the COLLECT alarm to grab it sooner:
            " FILE_IN: adjusting ALARM for next COLLECT" . nl
            "COLLECT" "COLLECT_SEC" yank 2 / "COLLECT" ALARM
         THEN
      THEN
   end

   inline: FILE_OUT (qSYM --- qFile) \ name of output file
    \ Wed Sep  7 14:30:22 PDT 2011

    \ Make PATH_OUT equal to "/tmp1/" during testing; see 
    \ "testing and debugging" below.

      [ "/tmp/" "PATH_OUT" book ]
        PATH_OUT "MKT_CME.eDAT" + "MKT" rot uppercase strp
   end

   inline: FILE_SEND (qFile --- ) \ send file to remote
    \ Wed Sep  7 15:13:14 PDT 2011

      (qFile) dup -filename "/tmp1/" = 
      IF " FILE_SEND: testing; file " swap + " not sent" + . nl
         return
      THEN

      "mrc_open" "REMOTE" yank "REMOTE" book

      "FILE" book

      FILE file? not
      IF " FILE_SEND: file " FILE + " not found" + . nl return THEN

      "mrc_open" "S" yank "S" book 
      "mrc_open" "S1" yank "S1" book 

      S -1 >
      IF host "plunger" <>
         IF SYSOUT "SYSOUTsav" book
            ftempsys (qLOG) dup "ERRLOG" book (qLOG) set_sysout

            FILE FILE S fremoteput (f) 

            (f) dup false =
            IF " FILE_SEND: error sending " FILE + 
               "; see ERRLOG below:" + . nl
               ERRLOG asciiload (hT) 3 indent . nl
            THEN (f)

            ERRLOG deleteif
            SYSOUTsav set_sysout \ back to regular output
            (f)
         ELSE true
         THEN (f)

         IF " FILE_SEND: OK " FILE + " to " + REMOTE + date + . nl
            S1 -1 >
            IF
{              Make a string to run on REMOTE that will add a job to 
               the collector queue that will update the history file 
               with the data just sent.  A typical string to do this 
               is: "eGC-COLLECT" "hist" localref ptr queue_add1.

               Word queue_add1 will add a job to the queue if there
               isn't a matching one already.  A matching job would
               be one from the collector, and when it runs the file
               just written will be processed along with the ones made 
               by the collector, so there is no need to add another
               one to the queue.

               The collector job on REMOTE is presently on socket S1 
               connected to REMOTE.
}
               "eXX-COLLECT" "XX" FILE SYM_OUT strp quoted spaced
               "hist" quoted + " localref ptr queue_add1 ACK" + (hT)

               (hT) S1 remoterun1 (f)

               IF " FILE_SEND: " FILE SYM_OUT + 
                  " update queued on " + REMOTE + date + . nl

               ELSE " FILE_SEND: " FILE SYM_OUT + 
                  " update queue error on " + REMOTE + date + . nl
                  BEEP
               THEN
            THEN

         ELSE " FILE_SEND: error sending " FILE + " to " + 
            REMOTE + date + . nl BEEP
         THEN
      ELSE " FILE_SEND: not connected to " REMOTE + date + 
         . nl BEEP
      THEN 
   end

   inline: logLAN1 ( --- f) \ report to the head machine over the LAN
      "mrc_open" "REMOTE" yank "mrc_open" "PORT" yank
      (qIP nPORT) logLAN (f)
      IF mrc_open (f)
      ELSE false
      THEN (f)
   end

   inline: mrc_close ( --- ) \ close market data resources
      "mrc_open" "S" yank sclose
      -1 "mrc_open" "S" bank

      "mrc_open" "S1" yank sclose
      -1 "mrc_open" "S1" bank

      " mrc_close: sockets closed " date + . nl
   end

   inline: mrc_open ( --- f) \ open market data resources on plunger
    \ Mon Sep 19 11:37:05 PDT 2011

      [ host "plunger" =
        IF IPloop ELSE plunger THEN spaced "REMOTE" book 
        "plunger" "p0" yank 80 + "PORT" book \ http on plunger

        -1 "S" book  \ socket to HTTP server
        -1 "S1" book \ socket to collector topse

        0 "E_PORT" book

        {" topse_port( -- f) \ fetch topse port on the collector machine

           REMOTE PORT CLIENT "S" book \ socket to HTTP server
           "TOPSE_SERVER" S msgPeekSocket (qPort) any?
           IF number (no || nPort yes)
              IF "E_PORT" book true
              ELSE " mrc_open: bad port number from " 
                 REMOTE + date + . nl false 
              THEN
           ELSE " mrc_open: error fetching port from " 
              REMOTE + date + . nl false
           THEN (f)
        "} "topse_port" macro

      \ Collector topse must already be running on the collector ma-
      \ chine when this file is sourced.  Fetch its port:
        topse_port (f) 
        IF S sclose -1 "S" book
        ELSE " cme.v: failed to fetch topse port; HALTING" . nl HALT
        THEN
      ]
      sockets sclose \ close any connections (there should be none)

      REMOTE PORT CLIENT "S" book

      S -1 >
      IF host "plunger" <>
         IF SYSOUT "SYSOUTsav" book
            ftempsys (qLOG) dup "ERRLOG" book (qLOG) set_sysout

            "/mdat/latest.dat" mpath "latest.dat" + S fremoteget (f1)
            "/mdat/con.dat"    mpath "con.dat" + S fremoteget (f2)

            SYSOUTsav set_sysout \ back to regular output
         ELSE true true (f1 f2)
         THEN

         (f1 f2) and
         IF " mrc_open: OK files from " REMOTE + date + . nl

          \ Connect to the collector on REMOTE:
            -1 "S1" book
            E_PORT any?
            IF (nPort) REMOTE swap CLIENT "S1" book S1 -1 >
               IF true (f)
               ELSE " mrc_open: cannot connect to collector on " 
                  REMOTE + date + . nl 

                \ Maybe topse was restarted and it is on a different
                \ port now.  Force topse_port to run next time:
                  0 "E_PORT" book 

                  false (f)
               THEN
            ELSE " mrc_open: fetching E_port" . nl
               topse_port (f) 
               IF mrc_open (f)
               ELSE BEEP false (f)
               THEN
            THEN
         ELSE " mrc_open: error fetching files from " REMOTE + 
            date + . nl 
            ERRLOG asciiload 2 indent . nl 
            BEEP false (f) 
         THEN
      ELSE " mrc_open: cannot connect to " REMOTE + date + . nl
         BEEP false (f)
      THEN (f)

      ERRLOG deleteif
   end

   inline: PROCESS (hA qTIME qCON qSYM --- ) \ market SYM to file
    \ Wed Sep  7 14:30:22 PDT 2011

    \ Incoming SYM is the cme symbol; file created will use the
    \ program's symbol.

      "SYM" book

      SYM "6E" = IF (hA qTIME qCON) 10000 "EU" DECIMAL return THEN
      SYM "6S" = IF (hA qTIME qCON) 10000 "SF" DECIMAL return THEN
      SYM "6J" = IF (hA qTIME qCON) 10000 "JY" DECIMAL return THEN

      SYM "YM" = IF (hA qTIME qCON) 1  "DJ" DECIMAL return THEN
      SYM "ES" = IF (hA qTIME qCON) 10 "SP" DECIMAL return THEN
      SYM "NQ" = IF (hA qTIME qCON) 10 "NQ" DECIMAL return THEN

      SYM "ZB" = IF (hA qTIME qCON) "US" BOND return THEN
      SYM "ZN" = IF (hA qTIME qCON) "TN" BOND return THEN

      SYM "CL" = IF (hA qTIME qCON) 100   "CL" DECIMAL return THEN
      SYM "HG" = IF (hA qTIME qCON) 10000 "HG" DECIMAL return THEN
      SYM "GC" = IF (hA qTIME qCON) 10    "GC" DECIMAL return THEN
   end

   inline: SYM_OUT (qFile --- qSYM) \ market symbol from File name
      (qFile) "FILE_OUT" "PATH_OUT" yank "" strp (qSYM)
      (qSYM) "_CME.eDAT" "" strp (qSYM)
   end

   pull catmsg

\  For testing and debugging, uncomment the following line:
\  "/tmp1/" "FILE_OUT" "PATH_OUT" bank " WORKING IN TEST MODE" . nl halt

\  Then set SYM_TABLE in cme_process to the market to test, and run
\     "cme.v" source cme_process halt
\  with HALT placed at various locations to find the bug.

\-----------------------------------------------------------------------

\  Remove old files:
   " Removing old *CME.eDAT files from /tmp " . nl
   "/bin/rm /tmp/*CME.eDAT" shell

   CATMSG push no catmsg

   inline: COLLECT ( --- ) \ process file from NSF client on Windows
      [ 5 "SEC" book, 0 "TRIES" book, 2 "MAX_TRIES" book

      \ This span matches the period that Windows writes the file to
      \ the nfs directory, FILE_IN.PATH (see Task Scheduler, task
      \ equotes on Windows machine solano):
        60 "COLLECT_SEC" book \ collect every COLLECT_SEC
{
 Good show.  Failed, set the alarm to try again, and succeeded:

 logLAN: OK Thu Sep 15 08:25:09 PDT 2011
 mrc_open: OK files from 127.0.0.1 Thu Sep 15 08:25:10 PDT 2011
 mrc_open: error fetching collector port from 127.0.0.1 Thu Sep 15 ...
 COLLECT: failed connection; trying again
 logLAN: OK Thu Sep 15 08:25:19 PDT 2011
 mrc_open: OK files from 127.0.0.1 Thu Sep 15 08:25:22 PDT 2011
 cme_process: begin Thu Sep 15 08:25:26 PDT 2011
 FILE_SEND: OK /tmp/TN_CME.eDAT to 127.0.0.1 Thu Sep 15 08:25:27 PDT ...
 FILE_SEND: TN update queued on 127.0.0.1 Thu Sep 15 08:25:27 PDT 2011
 FILE_SEND: OK /tmp/US_CME.eDAT to 127.0.0.1 Thu Sep 15 08:25:27 PDT ...
 ...
 FILE_SEND: OK /tmp/NQ_CME.eDAT to 127.0.0.1 Thu Sep 15 08:25:29 PDT ...
 FILE_SEND: NQ update queued on 127.0.0.1 Thu Sep 15 08:25:29 PDT 2011
 mrc_close: sockets closed Thu Sep 15 08:25:29 PDT 2011
}
      ]

    \ Tue Oct 11 06:12:43 PDT 2011.  Word logLAN1 will run logLAN which
    \ runs remoterun1.  Do not continue if program is locked:
      LOCKED IF " COLLECT: returning; program is LOCKED" . nl THEN

      logLAN1 (f)
      IF SEC "cme_process" ALARM \ begin processing in SEC
       \ beep
      ELSE 1 TRIES incr TRIES MAX_TRIES <
         IF " COLLECT: failed connection; trying again" . nl
            SEC "COLLECT" ALARM \ set an ALARM to try again
            return
         ELSE " COLLECT: failed connection; giving up" . nl
            0 "TRIES" book
         THEN
      THEN
      COLLECT_SEC "COLLECT" ALARM
   end

   inline: COLLECT_START ( --- ) \ start multitasker COLLECT
    \ Fri Sep 16 14:47:26 PDT 2011
      [ 0 "SOONER" book ]

    \ Set an alarm to run COLLECT_END:
      time soonest_end SOONER - (sec)
      " COLLECT_START: collection ends in about "
      over 3600 / 0.5 + integer intstr + " hours" + . nl
      (sec) "COLLECT_END" ALARM
      COLLECT 
   end

   inline: COLLECT_END ( --- ) \ end multitasker job COLLECT
      [ 600 "LATER" book ]

      soonest_task
      IF COLLECT THEN \ queue the last cme_process this session

    \ End the multitasker job just started by COLLECT:
      "COLLECT" -ALARM

    \ Set an alarm to run COLLECT_START:
      time soonest_start LATER + (sec)
      " COLLECT_END: " date + ", collection begins in " +
      over 60 / 0.5 + integer intstr + " minutes" + . nl
      (sec) "COLLECT_START" ALARM
{ 
 This shows COLLECT_END in action:
 logLAN: OK Thu Sep 15 14:40:00 PDT 2011
 mrc_open: OK files from 127.0.0.1 Thu Sep 15 14:40:01 PDT 2011
 COLLECT_END: Thu Sep 15 14:40:01 PDT 2011, collection begins in 
   30 minutes
 This is the last go with cme_process:
 cme_process: begin Thu Sep 15 14:40:06 PDT 2011
 FILE_SEND: OK /tmp/TN_CME.eDAT to 127.0.0.1 Thu Sep 15 14:40:06 PDT ...
 FILE_SEND: TN update queued on 127.0.0.1 Thu Sep 15 14:40:06 PDT 2011
 FILE_SEND: OK /tmp/US_CME.eDAT to 127.0.0.1 Thu Sep 15 14:40:06 PDT ...
 ...
 FILE_SEND: OK /tmp/NQ_CME.eDAT to 127.0.0.1 Thu Sep 15 14:40:09 PDT ...
 FILE_SEND: NQ update queued on 127.0.0.1 Thu Sep 15 14:40:09 PDT 2011
 mrc_close: sockets closed Thu Sep 15 14:40:09 PDT 2011

 Here is the COLLECT_START alarm that will go in about 30 minutes; 
 NIST_SYNC has been waiting a long time, and will finally run in 43 
 seconds:
[tops@plunger] ready > tasks
 Multitasker tasks:
  COLLECT_START,0:CODE__ alarm period 1798.2 seconds; remaining 1242
  NIST_SYNC,0:CODE__ alarm period 77603 seconds; remaining 43
}
   end

   inline: START ( --- ) \ depending on time of day, set the start task
      " START: running NIST_SYNC ... " date + . nl
      NIST_SYNC \ sync the program time with NIST

    \ Next time, and every time thereafter, run NIST_SYNC in the lull
    \ between 14:45 and 15:00 (LA) time:
      "14:50:00" "todayat" >stk (n qT) chars 0>
      IF drop "38:50:00" todayat THEN "NIST_SYNC" ALARM

      soonest_task (f) IF COLLECT_START ELSE COLLECT_END THEN
   end

   pull catmsg

   START nl tasks

   private halt
