{  File eod.v  January 2008

   Copyright (c) 2008-2014   D. R. Williamson

   This file runs end of day processing of pit and electronic market 
   data and appends the results to the current quarterly ascii file.

   If you make a mistake and need to start over, search for:
      Fri Jun 13 09:25:55 PDT 2014.  If you screw up

------------------------------------------------------------------------

   New quarterly ascii files contain electronic market prices in addi-
   tion to pit prices.  They do not contain the pit volume and open 
   interest that is in the old ascii files dating back to 1988.  File 
   jan-mar.08 is the first quarterly file with these changes.

   The electronic market data actually starts on Friday, January 11, 
   2008, so earlier days in file jan-mar.08 have pit data values where
   the electronic ones would go.

   These are the fields of a line of new ascii data for a market:
      ID+CON DATE Open High Low Close Chg Eopen Ehigh Elow Eclose

   The first 7 items match the old fields for pit data except that vol-
   ume and open interest are missing between the Close and Chg fields.
   Fields 8 through 11 contain the electronic market data.

   This file does the work of file mdat.v that was used to copy and 
   paste pit data manually every day.  That process allowed a view of 
   growing open interest to judge when to roll a contract to a new 
   future month.

   Now a new method to decide rollover needs to be developed.  For 
   this, open interest is still available in the downloaded daily pit 
   data files.  

   Once the date and new contract for rollover is decided, file con.dat
   (at mpath) must be edited manually to define new contract months.
   See file conupd for current rollover approach.

   The code here reads con.dat and selects the new contract from the 
   downloaded files of pit and electronic market data.

------------------------------------------------------------------------

   Updates.

   Sat May 21 13:27:33 PDT 2011.  
      Pit volume and open interest discontinued after January 1, 2008 
      are being saved again.  They are now in the last two fields, 12 
      and 13, following Eclose:
         ID+CON DATE Open High Low Close Chg Eopen Ehigh ...
         ... Elow Eclose VOL OI

      Look for FIXUP1 at the bottom of this file for the procedure to 
      add pit volume and open interest to the quarterly files of 2011.
      The same approach could be used for earlier files if desired.
  
------------------------------------------------------------------------

   Notes.

   Fri Apr 20 12:34:13 PDT 2012.  This shows files to remove when a new
   quarter starts to avoid problems discussed elsewhere in this file.

   The problem is not handled automatically, and manual removal as in
   this example below is required.
   
      Files to remove when switch to 2nd quarter after Mar 30, 2012:

      [dale@plunger] /mdat > llr jan-mar*
      -rw-r--r--    1 dale  comm    162327 Apr  5  2010 jan-mar.10
      -rw-r--r--    1 dale  comm    227896 May 23  2011 jan-mar.11
      -rw-r--r--    1 dale  comm    182667 Mar 29 14:52 jan-mar.12.rev
      -rw-r--r--    1 dale  comm    185340 Mar 29 14:53 jan-mar.12.sav
      -rw-r--r--    1 dale  comm    185646 Mar 29 17:19 jan-mar.12.bak
      -rw-r--r--    1 dale  comm    188625 Mar 30 16:03 jan-mar.12
      [dale@plunger] /mdat > rm jan-mar.12.rev jan-mar.12.sav \
                                jan-mar.12.bak
      rm: remove `jan-mar.12.rev'? y
      rm: remove `jan-mar.12.sav'? y
      rm: remove `jan-mar.12.bak'? y
      [dale@plunger] /mdat >

      File jan-mar.12 contains data for Friday March 30, 2012: 33012.

   Fri Jun 13 09:25:55 PDT 2014.  If you screw up and need to start 
   over, copy these .sav files to versions without .sav (with the 
   appropriate quarterly file used in place of apr-jun.14 shown):

      [dale@diego] /mdat > ll *sav*
      -rw-r--r--   1 dale   comm  153199 Jun 12 14:54 apr-jun.14.sav
      -rw-r--r--   1 dale   comm    6726 Jun 12 14:54 con.dat.sav
      -rw-r--r--   1 dale   comm    2670 Jun 12 14:54 latest.dat.sav

      [dale@diego] /mdat > cp apr-jun.14.sav apr-jun.14
      [dale@diego] /mdat > cp con.dat.sav con.dat
      [dale@diego] /mdat > cp latest.dat.sav latest.dat

------------------------------------------------------------------------

   Contents:

   Use this phrase to obtain the following list of contents:
      usrpath "eod.v" + asciiload this " inline:" grepr reach dot

   inline: Market (qM --- ) \ run this first to do set up for market M

   inline: Digits ( --- digits) [ -1 "d" book ] d ;
   inline: KomID ( --- id) [ -1 "id" book ] id ;
   inline: Rescale ( --- qFr) [ "UNDEF" "r" book ] r ;
   inline: Scale ( --- qFs) [ "UNDEF" "s" book ] s ;
   inline: Symbol ( --- qM) [ "UNDEF" "m" book ] m ;

   inline: dtarout ( --- )
   inline: dtarout_betsa ( --- )
   inline: dtarout_fortycoupe ( --- )
   inline: dtarout_plunger ( --- )
   inline: dtarout_riggo ( --- )
   inline: dtarout_rilefile ( --- )
   inline: dtarout_topsdog ( --- )
   inline: EOD ( --- ) \ fetch EOD file from fortycoupe.com
   inline: EOD-GET (  ---  ) \ download the end of day files
   inline: flag_quarter ( --- f) \ true flag if today is new quarter
   inline: pit_open (qS --- f)
   inline: revert ( --- ) \ regular files revert to previous session
   inline: newday_run ( --- ) \ run newday to update mdataXX.bin
}
\-----------------------------------------------------------------------

\  Warning: when using SKIP-REVERT=yes, do not run until after the 4 PM
\  collection of pit end-of-day data (but see OK_BEFORE_4 below).

\  Switch default to first seen to temporarily run without it:
   yes "SKIP-REVERT" book \ do not run revert and run pit eod
   no  "SKIP-REVERT" book \ default: run revert

\  Switch default to first seen to temporarily run without it:
   yes "OK_BEFORE_4" book \ ok to run pit eod before 4 PM
   no  "OK_BEFORE_4" book \ default: do not run pit eod until after 4 PM

\  If you screw up, see Notes Fri Nov 26 08:48:47 PST 2010.

\-----------------------------------------------------------------------

   CATMSG push no catmsg 

   'mpath' missing IF " Require path definition: mpath" . halt THEN

   'datespinner' exists? not IF 'cal.v' source THEN
   'choose'      exists? not IF 'tex.v' source THEN

   "reffile" missing IF "mrc.v" source THEN
   "newday" missing IF "mday.v" source THEN

\  Wed Sep  7 15:22:30 PDT 2011.  Skip this test:
\  www_open not IF " EOD: must be connected to Internet" . nl halt THEN

\-----------------------------------------------------------------------

\  Old words from file mdat.v, revamped somewhat:

   inline: Market (qM --- ) \ run this first to do set up for market M
{     This word stores scaling data items for the current market M into
      words that allow retrieval of each item (as mdat.v was written 
      in 1999, but now the use of "public" has been avoided; see notes
      in the top of mdat.v written in 2004).

      Notes on redundancy, January 2008.

         The qM column here must match the symbols from word 
         tracklist, and the id column here must match IDs in 
         the library of word tracklist.  Word tracklist is 
         defined in uboot.v at startup.  

         Symbols and ids are also redundantly defined in file
         mrc.v, table _mKey and word kID; they too must match
         tracklist and the ones here.

         An ideal system built from scratch would not have 
         things defined in more than one place.  This is not
         an ideal system, and redundancy requires more aware-
         ness when changes need to be made.

         This is an evolving system, where new steps are made 
         to work in concert with old ones rather than starting 
         all over.  Probably never-changing tops, able to run 
         old and new, helps in this form of evolution.
      
      Markets:
          qM   qFs      qFr   digits lim id)
}     [ '"W"  "Oct"    "-Oct"    2   20  11' "w"  macro
        '"C"  "Oct"    "-Oct"    2   12  12' "c"  macro
        '"S"  "Oct"    "-Oct"    2   30  13' "s"  macro
        '"SM" "Dec"    "-Dec"    2   10  14' "sm" macro
        '"BO" "Cen"    "-Cen"    2    1  15' "bo" macro

        '"LC" "2score" "-2score" 2   1.5 21' "lc" macro
        '"LH" "2score" "-2score" 2   1.5 22' "lh" macro

      \ On November 17, 2010, market PB was discontinued.
      \ The following is commented out; a similar line in
      \ file mdat.v remains, but mdat.v is no longer used.
      \ '"PB" "2score" "-2score" 2   3.0 23' "pb" macro

        '"SB" "Cen"    "-Cen"    2   0.5 32' "sb" macro
        '"KC" "Score"  "-Score"  2   6   33' "kc" macro
        '"JO" "Score"  "-Score"  2   7.5 34' "jo" macro
        '"CC" "Unit"   "-Unit"   2   88  35' "cc" macro

        '"HG" "Score"  "-Score"  2   5   41' "hg" macro
        '"SI" "Dec"    "-Dec"    2   50  42' "si" macro
        '"PL" "Dec"    "-Dec"    2   25  43' "pl" macro
        '"GC" "Dec"    "-Dec"    2   25  44' "gc" macro

        '"CT" "Cen"    "-Cen"    2   2   53' "ct" macro
        '"HO" "Cen"    "-Cen"    2   2   54' "ho" macro
        '"CL" "Cen"    "-Cen"    2   1   55' "cl" macro
        '"HU" "Cen"    "-Cen"    2   2   56' "hu" macro
        '"NG" "Dec"    "-Dec"    2   20  57' "ng" macro

        '"SF" "Cen"    "-Cen"    2   1.5 61' "sf" macro
        '"BP" "4bits"  "-4bits"  2   5   62' "bp" macro
     \  '"DM" "Cen"    "-Cen"    2   1   63 ; (discontinued Dec 18, 01)
        '"JY" "Cen"    "-Cen"    2   1   64' "jy" macro
     \  '"MP" "Cen"    "-Cen"    2   1   66'
        '"MP" "Mil"    "-Mil"    3   1   66' "mp" macro
     \  '"RE" "Score"  "-Score"  2   0.5 67 ; (discontinued 990601)
        '"EU" "Cen"    "-Cen"    2   1   68' "eu" macro

        '"ED" "Mil"    "-Mil"    3   1   65' "ed" macro
        '"TN" "64m"    "-64m"    3   2   71' "tn" macro \ start 4-25-00
     \  '"TB" "Cen"    "-Cen"    2   0.6 72 ; \ discontinued Apr 2, 04
        '"FF" "Mil"    "-Mil"    3   0.6 79' "ff" macro \ add Apr 2, 04
     \  Sep 1, 2009: US digits set from 2 to 3 in prep for 64ths:
        '"US" "32m"    "-32m"    3   2   73' "us" macro

        '"SP" "Dec"    "-Dec"    2   5   74' "sp" macro
     \  '"YX" "Score"  "-Score"  2   2.5 75' ; (discontinued Jan 11, 08)
        '"DJ" "Unit"   "-Unit"   2   100 76' "dj" macro
        '"NK" "Cen"    "-Cen"    2   100 77' "nk" macro
        '"NQ" "Dec"    "-Dec"    2   100 78' "nq" macro

\       The digits column was added in August 2004.
      ]
      strchop lowercase (qM) local \ run the market local macro 

    \ Distribute the stack items to the libraries of various words:
      (qM qFs qFr digits lim id) "KomID" "id" bank
      (qM qFs qFr digits lim) drop
      (qM qFs qFr digits) "Digits" "d" bank
      (qM qFs qFr) "Rescale" "r" bank
      (qM qFs) "Scale" "s" bank
      (qM) "Symbol" "m" bank
   end

   inline: Digits ( --- digits) [ -1 "d" book ] d ;

   define: fix ( --- ) \ display today's database file to fix
      mpath "thisday" main qfilename cat _vi ;

   define: fixlatest ( --- ) \ display latest data to fix
      mpath 'latest.dat' cat _vi
   end

   inline: KomID ( --- id) [ -1 "id" book ] id ;

   define: precision (hC --- hC1) \ adding precision to database values
      quoting unquoting ;

   define: quoting (P --- qP) \ converting numbers P to quote-string P
      [ {"
        hand push, no no blockofblanks
        peek rows 1st
        DO peek I pry
           "Scale" main (qS) main (hP) run pile
        LOOP pull drop
        "} "quoting" inline
      ] quoting run
   end

   inline: Rescale ( --- qFr) [ "UNDEF" "r" book ] r ;

   inline: Scale ( --- qFs) [ "UNDEF" "s" book ] s ;

   inline: Symbol ( --- qM) [ "UNDEF" "m" book ] m ;

   define: unquote (qP --- P) \ quoted price string into a number
      Rescale (qS) main (hP) run ;

{  This word from mdat.v was written before "inline:" was invented; it 
   uses "inline" to make the list of addresses during bracket mode, and
   "run" to later run them (word quoting above is another like this;
   the original idea of inline was to use it for time consuming DO 
   loops):
}  define: unquoting (qP --- P) \ column of quoted prices into numbers
      [ {"
      hand again push rows 1st
      DO peek I quote unquote LOOP pull rows listn
      "} "unquoting" inline ] unquoting run
   end
{
   Scaling example (Jan 2008):

      [tops@plunger] ready > "W" Market \ sets up Wheat scaling data

      [tops@plunger] ready > "9040 9124 8850 9092 266" words

       stack elements:
             0 volume: _words  5 by 4
       [1] ok!
      [tops@plunger] ready > dup .
      9040
      9124
      8850
      9092
      266
       stack elements:
             0 volume: _words  5 by 4
       [1] ok!
      [tops@plunger] ready > unquoting dup .m
       Row 1: 904.0000
       Row 2: 912.5000
       Row 3: 885.0000
       Row 4: 909.2500
       Row 5:  26.7500
       stack elements:
             0 matrix: _list  5 by 1
       [1] ok!
      [tops@plunger] ready > quoting .
      9040
      9124
      8850
      9092
      266
      [tops@plunger] ready >

   Notes from mdat.v:

   Scaling functions for quotations in various markets:
    2score - 40 (every .025)
    32m - 32 (every 1/32 = .03125)
    4bits - 50 (every .02)
    Cen - 100 (every .01)
    Dec - 10 (every .1)
    Oct - 8 (every .125)
    Score - 20 (every .05)
    Unit - 1 (every 1.0)

   Scaling examples:
      Oct (for octal) converts a number from the database to a string
      with remainder in eights, like 263.75 to 2636 (263 and 6 eights),
      while -Oct converts the eights-string back to a decimal number.

      This latter number has accuracy equal to, and in some cases
      greater than, the one from the database.  For example, 2score
      converts database number 63.03 to string 6302--the way these
      are quoted--and -2score converts string 6302 to 63.025, the
      true digits for a quote of 63.03 or 6302 in this market:

         [tops@gutter] ready > 63.03 2score run "6302" -2score run

          stack elements:
                0 number: 6.3025E+01
                1 string: 6302  1 by 4
          [2] ok!
         [tops@gutter] ready >

      To convert a vector read from the database--say C--to its full
      digits, run

           C quoting unquoting (C numbers with full digits)

      or for an individual number, say c, run

           c quoting unquoting ontop (does what the example above did)

      All values from the database are adjusted in this way as they 
      are loaded by word latest (note: this refers to reading ascii
      data in mdat.v; it is not done here in eod.v).
}
\-----------------------------------------------------------------------

\  Words for collection sites (based on words from script file EOD):

   inline: dtarout ( --- )
   \  dtarout_topsdog 
      dtarout_fortycoupe 
      dtarout_rilefile 
      dtarout_plunger
      dtarout_riggo 
   \  dtarout_betsa
   end

   inline: dtarout_betsa ( --- )
\     Unlike topsdog and fortycoupe, betsa's tar file is in /mdat
\     instead of /home/dale/mdat, and betsa's dtarin file is in
\     /opt/mytops/usr instead of /home/dale/mytops/usr.

      [ date sysdate drop "DATE" book ]
      mpath chdir

      "tar -zcvf " mpath + "mdat.tgz latest.dat con.dat " +
      DATE qfilename + shell
      nl
      betsamillion.com REMOTE_CONNECT (nSocket) any?
      IF "S" book mpath "mdat.tgz" + "/mdat/mdat.tgz"
         S fremoteput (f)
         IF " OK" ELSE " Error" THEN " mdat.tgz to betsa" + . nl
         "'/opt/mytops/usr/dtarin &' shell" S remoterun
         S sclose
      ELSE " dtarout_betsa: failed to connect to betsa" . nl
      THEN
   end

   inline: dtarout_fortycoupe ( --- )
      [ date sysdate drop "DATE" book ]
      mpath chdir

      "tar -zcvf " mpath + "mdat.tgz latest.dat con.dat " +
      DATE qfilename + shell

      "Copying to fortycoupe.com:" . nl
      "scp -P 9823 mdat.tgz dale@" fortycoupe.com +
      ":/home/dale/mdat/." + shell
{
      nl
      fortycoupe.com REMOTE_CONNECT (nSocket) any?
      IF "S" book mpath "mdat.tgz" + "/home/dale/mdat/mdat.tgz"
         S fremoteput (f)
         IF " OK" ELSE " Error" THEN " mdat.tgz to fortycoupe" + . nl
         "'/home/dale/mytops/usr/dtarin &' shell" S remoterun
         S sclose
      ELSE " dtarout_fortycoupe: failed to connect to fortycoupe" . nl
      THEN
}
   end

   inline: dtarout_plunger ( --- )
    \ Thu Jun 28 14:45:05 PDT 2012

      [ date sysdate drop "DATE" book,
        mpath "mdat.tgz" + "FILE" book ]

      host "plunger" = IF return THEN

      "latest.dat con.dat " DATE qfilename + \ File names to send
      mpath FILE (hList qDir qFile) ctar

      "Copying to plunger:" . nl

      plunger "plunger" p_http_for CLIENT (nS) dup 0>
      IF "S" book
         FILE \ file
         FILE \ file_to
         S fremoteput (f)
         IF "mpath " FILE quoted + " xtar " + \ extract files on remote
            (hT) S remoterun 

            " dtarout_plunger: idling before checking remote extraction"
            . nl 5 idle

          \ Have the remote return untarred file latest.dat:
            "mpath 'latest.dat' + asciiload remotefd remoteput"
            (hT) S remoterun1 (hL1)

          \ Check that remote file latest.dat matches the one here:
            mpath "latest.dat" + asciiload (hL1 hL2) strmatch 0=
            IF "dtarout_plunger: OK file untarred on remote"
            ELSE "dtarout_plunger: untar on remote failed"
            THEN . nl

         ELSE
            " dtarout_plunger: fremoteput failed" . nl
         THEN
         S sclose
      ELSE " dtarout_plunger: failed to connect to plunger" . nl
      THEN
   end

   inline: dtarout_riggo ( --- )
    \ Sun Dec  4 10:51:18 PST 2011

      [ date sysdate drop "DATE" book,
        mpath "mdat.tgz" + "FILE" book ]

      host "riggo" = IF return THEN

      "latest.dat con.dat " DATE qfilename + \ File names to send
      mpath FILE (hList qDir qFile) ctar

      "Copying to riggo:" . nl

      riggo "riggo" p_http_for CLIENT (nS) dup 0>
      IF "S" book
         FILE \ file
         FILE \ file_to
         S fremoteput (f)
         IF "mpath " FILE quoted + " xtar " + \ extract files on remote

          \ Have the remote return untarred file latest.dat:
            "mpath 'latest.dat' + asciiload remotefd remoteput" +

            (hT) S remoterun1 (hL1)

          \ Check that remote file latest.dat matches the one here:
            mpath "latest.dat" + asciiload (hL1 hL2) strmatch 0=
            IF "dtarout_riggo: OK file untarred on remote"
            ELSE "dtarout_riggo: untar on remote failed"
            THEN . nl

         ELSE
            " dtarout_riggo: fremoteput failed" . nl
         THEN
         S sclose
      ELSE " dtarout_riggo: failed to connect to riggo" . nl
      THEN
   end

   inline: dtarout_rilefile ( --- )
\     Unlike topsdog and fortycoupe, rilefile's tar file is in /mdat
\     instead of /home/dale/mdat, and rilefile's dtarin file is in
\     /opt/mytops/usr instead of /home/dale/mytops/usr.

      [ date sysdate drop "DATE" book ]
      mpath chdir

      "tar -zcvf " mpath + "mdat.tgz latest.dat con.dat " +
      DATE qfilename + shell

      "Copying to rilefile.com:" . nl
      "scp -P 9823 mdat.tgz dale@" rilefile.com +
      ":/mdat/." + shell
{
      nl
      rilefile.com REMOTE_CONNECT (nSocket) any?
      IF "S" book mpath "mdat.tgz" + "/mdat/mdat.tgz"
         S fremoteput (f)
         IF " OK" ELSE " Error" THEN " mdat.tgz to rilefile" + . nl
         "'/opt/mytops/usr/dtarin &' shell" S remoterun
         S sclose
      ELSE " dtarout_rilefile: failed to connect to rilefile" . nl
      THEN
}
   end

   inline: dtarout_topsdog ( --- )
      [ date sysdate drop "DATE" book ]
      mpath chdir

      "tar -zcvf " mpath + "mdat.tgz latest.dat con.dat " +
      DATE qfilename + shell
      nl
      topsdog.com REMOTE_CONNECT (nSocket) any?
      IF "S" book mpath "mdat.tgz" + "/home/dale/mdat/mdat.tgz"
         S fremoteput (f)
         IF " OK" ELSE " Error" THEN " mdat.tgz to topsdog" + . nl
         "'/home/dale/mytops/usr/dtarin &' shell" S remoterun
         S sclose
      ELSE " dtarout_topsdog: failed to connect to topsdog" . nl
      THEN
   end

   inline: EOD ( --- ) \ fetch EOD file from fortycoupe.com
    \ September 2009; fetching file placed by clacker for eod from tch.
      fortycoupe.com REMOTE_CONNECT "S" book
      S -1 >
      IF date sysdate drop intstr ".dat" + "FILE" book
         "/home/dale/mdat/" FILE + \ remote file
         mpath FILE + \ local file
         S fremoteget (f)
         IF " EOD: OK, file " mpath FILE + + " saved" +
         ELSE " EOD: failed to get file from fortycoupe.com"
         THEN
         S sclose
      ELSE " EOD: failed to connect to fortycoupe.com"
      THEN . nl
   end

   inline: EOD-GET (  ---  ) \ download the end of day files
\     Download files of pit and electronic trading for DATE.

      [ date sysdate drop "DATE" book ]

\     First look on this machine for the files:
      mpath DATE intstr ".dat"  + + dup "FILE_LOCAL1" book file?
      mpath DATE intstr "E.dat" + + dup "FILE_LOCAL2" book file?
      and 
      IF return 
      ELSE 
         " EOD-GET: halting; no longer set up to retrieve remote files"
         . nl HALT
      THEN
     
\     Directory and file names on remote:
\     NOTE: These will not work for rilefile.com if it is ever used;
\     its files are in /mdat, not /home/dale/mdat/.
      "/home/dale/mdat/" DATE intstr ".dat"  + + "FILE_REMOTE1" book
      "/home/dale/mdat/" DATE intstr "E.dat" + + "FILE_REMOTE2" book

\     Try one site and then the other if REMOTE_CONNECT fails:
      fortycoupe.com "SITE" book
      SITE REMOTE_CONNECT "S" book

      S any not
      IF " failed to connect to " SITE + . nl
         " EOD-GET: halting" . nl HALT

       \ August 31, 2009: topsdog.com is retired.
       \ topsdog.com "SITE" book
       \ SITE REMOTE_CONNECT "S" book

      THEN

      S any
      IF FILE_REMOTE1 \ file 1 from remote (pit trading)
         FILE_LOCAL1  \ file 1 to local
         S fremoteget (f)
         IF " OK" ELSE " ERROR" THEN
         spaced FILE_LOCAL1 " from " SITE + + + . nl

         FILE_REMOTE2 \ file 2 from remote (electronic trading)
         FILE_LOCAL2  \ file 2 to local
         S fremoteget (f)
         IF " OK" ELSE " ERROR" THEN
         spaced FILE_LOCAL2 " from " SITE + + + . nl

         S sclose

      ELSE " failed to connect to " SITE + . nl
      THEN
   end

   inline: flag_quarter ( --- f) \ true flag if today is new quarter
      date sysdate drop (nYYYMMDD) qfilename (qF1)
      date sysdate drop dup greg swap weekday 2 (Monday?) = 
      IF 3 ELSE 1 THEN - gdate (nYYYMMDD) qfilename (qF2)
      (qF1 qF2) <>
      IF " flag_quarter: this is the first day of a new quarter" . nl
         true
      ELSE false
      THEN
   end

   inline: pit_open (qS --- f) 
{     Read a line like this from FILE1 for symbol S:
         SM VOL and OI totals: 27176 202556
      and if VOL is zero, pit was not open.

      The current procedure (May 26, 2008) is to manually change VOL 
      to zero on holidays like Memorial Day.  Electronic trading is 
      left alone, so FILE2 is in error and will repeat the previous
      day's data for markets closed.  But electronic analysis really
      uses the collected history data, not this end of day data. 

      Wed Sep  1 15:35:01 PDT 2010.  PB looks like it is in its last
      days.  Sometimes VOL is zero when all the other pits are open.
      Use LH VOL for testing if PB pit is open.
}
      strchop uppercase
      dup "PB" = IF drop "LH" THEN (qS) 2 blpad "S" book

      "FILE1" main dup "VOL and OI totals:" grepr reach (hT)
      (hT) dup 1st S chars items catch S grepe reach

      numerate 1st pry 0<> 
   end

   inline: revert ( --- ) \ regular files revert to previous session
{
      This word lets this script run a pre-eod job that allows files
      to be updated using electronic eod data that is available at
      2:45 PM (LA), before pit eod data arrives after 4 PM and before 
      the next session starts at 3 PM.

      When pit eod data is available, this script can be run again to 
      replace the temporary electronic data, and any real time jobs 
      running for the next session will absorb the updated pit data.

      Answering "yes" to the query below, the files updated earlier by 
      the pre-eod run (when the answer was "no") will be reverted to 
      the previous session, wiping out the temporary use of electronic
      data and allowing the pit data to be incorporated.

      These are the .rev files to which regular files (ones without the
      .rev extension) are reverted:
         [dale@plunger] /mdat > ll *bak
         -rw-r--r--  1 dale   comm   6608 Jan 29 16:03 con.dat.rev
         -rw-r--r--  1 dale   comm  50496 Jan 29 16:03 jan-mar.09.rev
         -rw-r--r--  1 dale   comm   7606 Jan 29 16:03 latest.dat.rev

      For safety, regular files are copied to .sav before they are re-
      placed by the .rev versions.

      Examples:

         Running pre-eod, for temporary update before receiving pit
         data:
            [tops@plunger] ready > revert
             eod: reverting to files before pre-eod?
             eod: say yes for pit eod and no for pre-eod. > no
             eod: files not reverted

         Running eod, for permanent update using pit data:
            [tops@plunger] ready > revert
             eod: reverting to files before pre-eod?
             eod: say yes for pit eod and no for pre-eod. > yes
               /bin/cp -p con.dat    con.dat.sav [regular file to .sav]
               /bin/cp -p con.dat.rev    con.dat [.rev file to regular]
               /bin/cp -p latest.dat latest.dat.sav
               /bin/cp -p latest.dat.rev latest.dat
               /bin/cp -p jan-mar.09 jan-mar.09.sav
               /bin/cp -p jan-mar.09.rev jan-mar.09
             eod: files reverted
}
      [ no "pit" book ]
      no "H" book

      pwd push
      mpath chdir
      pwd dirnames spaced dup ".rev " grepr any?
      IF " eod: reverting to files before pre-eod?" . nl
         " eod: say yes for pit eod and no for pre-eod. > " (qS)
         (qS) query nl "yes" =
         IF " THIS IS PIT EOD.  FILES WILL BE REVERTED." . nl
            " ARE YOU SURE?  Say yes. > " (qS) query nl 
            "yes" <> IF " HALTING" . nl HALT THEN

            (hT hR) reach chop (hT) dup rows 1st
            DO (hT)
             \ To be safe, copy the regular file to .sav version first:
               "/bin/cp -p " over I quote ".rev" "" strp + spaced
               over I quote ".rev" ".sav" strp +
               (qS) 3 spaces . dup . nl shell

             \ Now copy .rev version to the regular file:
               "/bin/cp -p " over I quote + spaced
               over I quote ".rev" "" strp +
               (qS) 3 spaces . dup . nl shell
            LOOP
            (hT) drop
            " eod: files reverted" . nl
            yes "pit" book
         ELSE (hT hR) 2drop 
          \ Sun Apr  6 12:35:20 PDT 2014.  File con.dat must be newest:
            mpath "con.dat" + "NEW" book
            mpath "con_update.dat" + "OLD" book
            NEW filetime OLD filetime <
            IF \ must wait until COLLECT_END() or COLLECT_START() (in 
               \ file mget.v, currently being run by topse) have updated
               \ con.dat:
               " eod: pre-eod: con.dat is waiting for updates" . nl
               " HALTING" . nl HALT 
            THEN
          { The following is replaced by the test above:
            " eod: pre-eod: do not continue if con_update.dat has" . nl
            "    rollover changes and COLLECTOR has not made new" . nl
            "    con.dat file; WAIT UNTIL AFTER 3 PM" . nl 
            " CONTINUE?  Say yes. > " (qS) query nl 
            "yes" <> IF " HALTING" . nl HALT THEN
          }
            " eod: pre-eod, saving files for reverting:" . nl

            "con.dat" filefound
            IF dup asciiload swap ".rev" + 3 spaces . dup . nl save 
            ELSE " eod: file con.dat not found; halting" . nl HALT
            THEN

            "latest.dat" filefound
            IF dup asciiload swap ".rev" + 3 spaces . dup . nl save 
            ELSE " eod: file latest.dat not found; halting" . nl HALT
            THEN

{           Yesterday's quarterly file name.

            Example: on Jan 1, 2009, the file is for last quarter:
               ready > 1090101 greg 1- gdate qfilename . nl
               oct-dec.08
}
            date sysdate drop 
            dup greg 
            swap weekday 2 (Monday?) = IF 3 ELSE 1 THEN -
            gdate qfilename filefound \ quarterly file
            IF dup "Q1" book 
               dup asciiload swap ".rev" + 3 spaces . dup . nl save 

               date sysdate drop greg gdate qfilename "Q2" book
               Q1 Q2 <> 
               IF \ cannot have dummy new quarter file about to be made
                  \ hanging around.
                  " eod: WARNING: YOU MUST DELETE NEW QUARTER FILE"
                  " BEFORE RUNNING PIT EOD LATER TODAY" + . nl
               THEN

            ELSE " eod: quarterly file not found; halting" . nl HALT
            THEN

            no "pit" book
         THEN
      ELSE (hT) drop " eod: no .rev files found" . nl
         " eod: halting" . nl yes "H" book
      THEN
      pull chdir

      H IF HALT THEN
   end

   inline: newday_run ( --- ) \ run newday to update mdataXX.bin
    \ Mon Jul 23 18:18:58 PDT 2012

    \ If files have changed, a new binary mdataXX.bin will be written
    \ and lock file newday.lock will be updated.

      RTSERVER dup 0>
      IF (nPort) IPloop swap CLIENT (nS)
         (nS) "CLIENT_SKT rows remotefd remoteput" over (nS) remoterun1
         (nS nClients) swap (nS) sclose
         (nClients) 0>
         IF " EOD: stopping RTSERVER queue" . nl 
            "'queue_run' SLEEP" RTcommand
            " EOD: waiting 10 seconds for busy clients to clear" . 
            10 idle nl

            " EOD: running newday" . nl newday 

            " EOD: starting RTSERVER queue" . nl 
            "'queue_run' WAKE" RTcommand
         ELSE " EOD: running newday" . nl newday
         THEN
      ELSE (0) drop " EOD: running newday" . nl newday
      THEN
   end
 
   pull catmsg

\-----------------------------------------------------------------------

 \ Fri Mar  7 10:14:22 PST 2014.  Use file eod_params to see who should
 \ be running this file:
   usrpath "eod_params" + "host" param_find "HOST" book
   host HOST <> IF " EOD: only on " . HOST . nl exit THEN
{
\  This doesn't work unless this is running on plunger.  And if this
\  is running on plunger, then HOST=plunger and it won't work either.
\  The console windows on plunger run newday.
   host "plunger" = 
   HOST "plunger" <> and
   IF " plunger runs newday_run and halts" . nl
      newday_run halt
   THEN
}

{  All words are now defined.  The rest is a giant script.

   Using word revert, January 2009.

   The next session starts at 3 PM (LA) but pit eod data is not avail-
   able until after 4 PM.  

   A pit pre-eod run can be made with this script using electronic eod 
   data (*E.dat) available at 2:45 PM.  At that time, script eod_elec 
   wrote a phony *.dat file for this script to use, that looks just 
   like the one that will be made when pit eod, using script eod1, runs
   after 4 PM.

   The pit pre-eod run made with this script will look exactly like a 
   true pit eod run, even saving the prior day's files on .rev versions.

   This means that when the regular pit eod run is made after 4 PM, it 
   is necessary to revert back to the prior day's files using the .rev
   versions, wiping out the temporary pre-eod results.

   Word revert is used to carry out these steps, and so it is the very
   first word run by this script to make the switch between a pre-eod
   run and a permanent pit eod run.
}  

   flag_quarter (f) 
   IF SKIP-REVERT not (f)
{
   [dale@plunger] /mdat > tops
            Tops 3.2.0
   Thu Apr  1 15:06:27 PDT 2010
   [tops@plunger] ready > eod
    flag_quarter: this is the first day of a new quarter
    eod: modify eod.v to skip revert and run eod after 4 PM
    eod: temporarily set: yes "SKIP-REVERT" book, and run after 4 PM

   [tops@plunger] ready > 

   What a surprise.  The machine continues to do things even when we 
   forget about them.  Which is not a surprise.

   Ok, I'll wait until after 4 PM, and temporarily set
      yes "SKIP-REVERT" book
   when running eod.
}
      (f)
      IF " eod: modify eod.v to skip revert and run eod after 4 PM" . nl
         ' eod: temporarily set: yes "SKIP-REVERT" book,'
         " and run after 4 PM" + . nl
         HALT
      THEN
    \ " eod: warning: there may be a bug in revert; for the next" . nl
      " eod: warning: THERE IS A BUG IN REVERT; for the next" . nl
      "   few days, watch that the quarterly file does not get" . nl
      "   replaced by one missing the last day of the quarter;" . nl
      "   the good one should have been saved in /mdat/archive" . nl
      "   SEE NOTES DATED July 5, 2010 IN eod.v" . nl
{
Noted on October 4, 2010: Below are the contents of file eod_watch.txt
that tracks the bug and tells how to fix it:

File /mdat/eod_watch.txt October 2010

Tracing the mixup in eod.v that reverts to the wrong previous quarterly
file.

Today is the first day of a new quarter.

This test may be different because today is Friday, so there is no
pre-eod run.

Here are the files for the quarter just ended before running eod.
[dale@plunger] /mdat > date; ll jul-sep.10*
Fri Oct  1 12:34:56 PDT 2010
-rw-r--r--    1 dale     comm       170093 Sep 30 16:02 jul-sep.10
-rw-r--r--    1 dale     comm       167492 Sep 30 15:44 jul-sep.10.bak
-rw-r--r--    1 dale     comm       167492 Sep 30 15:44 jul-sep.10.rev
-rw-r--r--    1 dale     comm       170094 Sep 30 15:44 jul-sep.10.sav
[dale@plunger] /mdat >

Here are the files after running pre-eod on Monday; no changes:
[dale@plunger] /mdat > date; ll jul-sep.10*
Mon Oct  4 16:06:09 PDT 2010
-rw-r--r--    1 dale     comm       170093 Sep 30 16:02 jul-sep.10
-rw-r--r--    1 dale     comm       167492 Sep 30 15:44 jul-sep.10.bak
-rw-r--r--    1 dale     comm       167492 Sep 30 15:44 jul-sep.10.rev
-rw-r--r--    1 dale     comm       170094 Sep 30 15:44 jul-sep.10.sav
[dale@plunger] /mdat >

and here are the .rev files after running pre-eod on Monday:
[dale@plunger] /mdat > date; ll *rev
Mon Oct  4 16:07:09 PDT 2010
-rw-r--r--    1 dale     comm         6757 Oct  4 15:06 con.dat.rev
-rw-r--r--    1 dale     comm       167492 Sep 30 15:44 jul-sep.10.rev
-rw-r--r--    1 dale     comm         2639 Oct  4 15:06 latest.dat.rev
-rw-r--r--    1 dale     comm         2639 Oct  4 15:06 oct-dec.10.rev
[dale@plunger] /mdat >

[dale@plunger] /mdat > tops
         Tops 3.2.0
Mon Oct  4 16:08:17 PDT 2010
[tops@plunger] ready > eod
 eod: reverting to files before pre-eod?
 eod: say yes for pit eod and no for pre-eod. > yes
 THIS IS PIT EOD.  FILES WILL BE REVERTED.
 ARE YOU SURE?  Say yes. > yes
   /bin/cp -p con.dat    con.dat.sav
   /bin/cp -p con.dat.rev    con.dat
   /bin/cp -p jul-sep.10 jul-sep.10.sav <<<<< should not do this
   /bin/cp -p jul-sep.10.rev jul-sep.10 <<<<< should not do this
   /bin/cp -p oct-dec.10 oct-dec.10.sav
   /bin/cp -p oct-dec.10.rev oct-dec.10
   /bin/cp -p latest.dat latest.dat.sav
   /bin/cp -p latest.dat.rev latest.dat
 eod: files reverted

and this shows the screw up:

[dale@plunger] /mdat > date; ll jul-sep.10*
Mon Oct  4 16:09:15 PDT 2010
-rw-r--r--    1 dale     comm       167492 Sep 30 15:44 jul-sep.10
-rw-r--r--    1 dale     comm       167492 Sep 30 15:44 jul-sep.10.bak
-rw-r--r--    1 dale     comm       167492 Sep 30 15:44 jul-sep.10.rev
-rw-r--r--    1 dale     comm       170093 Sep 30 16:02 jul-sep.10.sav
[dale@plunger] /mdat >

File jul-sep.10.rev (167492 bytes) has been copied to jul-sep.10.  This
causes the older, correct file, to be replaced by the earlier .rev
file which does not include Friday's data.

The mistake is copying two quarterly files.  Only the current quarterly
file should be operated upon, and that file is oct-dec.10, not the
previous one, jul-sep.10.

The fix is to allow only a .rev file for the current quarter.

To fix things manually, file jul-sep.10.sav is moved to jul-sep.10
and file jul-sep.10.rev is deleted.


Noted on July 5, 2010:

There is a bug.  This shows the supposed good file apr-jun.10 having 
fewer bytes than apr-jun.10.sav because it is missing June 30 prices:

-rw-r--r--    1 dale     comm       165156 Jun 30 15:45 apr-jun.10.rev
-rw-r--r--    1 dale     comm       165156 Jun 30 15:45 apr-jun.10.bak
-rw-r--r--    1 dale     comm       165156 Jun 30 15:45 apr-jun.10
-rw-r--r--    1 dale     comm       167726 Jun 30 16:02 apr-jun.10.sav

It is likely that apr-jun.10.sav will get deleted, and it is the 
good one.

Is this mixup because there is a .rev file for it, even though we are 
now into July, and because all .rev files get this treatment?

There is a good one in archive, which is heartening:

[dale@plunger] /mdat > ll archive/apr-jun.10
-rw-r--r--    1 dale     comm     167726 Jun 30 16:02 archive/apr-jun.10
[dale@plunger] /mdat > 

Here is making things right:

[dale@plunger] /mdat > cp apr-jun.10.sav apr-jun.10 
cp: overwrite `apr-jun.10'? y
[dale@plunger] /mdat > 
-rw-r--r--    1 dale     comm       165156 Jun 30 15:45 apr-jun.10.rev
-rw-r--r--    1 dale     comm       165156 Jun 30 15:45 apr-jun.10.bak
-rw-r--r--    1 dale     comm       167726 Jun 30 16:02 apr-jun.10.sav
-rw-r--r--    1 dale     comm       167726 Jun 30 16:02 apr-jun.10

[dale@plunger] /mdat > rm apr-jun.10.rev apr-jun.10.bak apr-jun.10.sav
rm: remove `apr-jun.10.rev'? y
rm: remove `apr-jun.10.bak'? y
rm: remove `apr-jun.10.sav'? y
[dale@plunger] /mdat > 

}
   THEN

   date sysdate drop weekday 6 <> SKIP-REVERT not and
   IF revert \ set the files for a pre-eod or a pit eod run
   ELSE OK_BEFORE_4 not
      IF date sysdate lop 160000 < \ before 4 PM on Friday?
         IF " On Friday, run pit eod after 4 PM" . nl HALT 
         ELSE yes "revert" "pit" bank
         THEN
      THEN
   THEN

\-----------------------------------------------------------------------

\  To get the previous date, read the last line from latest.dat written 
\  last time:
   mpath "latest.dat" + asciiload dup "ldata" book 1 endmost

\  From the previous date, jump to the next workday, but run word
\  datespinner to manually set the date in case there was a holiday:
   2nd word drop numerate revdate ontop workday datespinner nl
   (n) dup makes thisday \ for old mdat.v words
   (n) "EOD-GET" "DATE" bank \ files for this date will be downloaded

{  Make it somewhat difficult to continue, since if the date is not
   right the wrong files will be downloaded and the new files will 
   be screwed up (old ones are backed up, so it is possible to go to 
   directory mpath and put them back).

   Forgetting to skip a weekday holiday date is a common mistake.
}
   " Ready to go?  Say yes. > " (qS)

   (qS) query nl "yes" = not IF " Try again later." . halt THEN

   " Downloading and updating end of day data." . nl

{  Everything below is automatic.  

   The former manual job of six to ten minutes has been reduced to less 
   than one second; and electronic market data is obtained in addition
   to pit data.  (But there still is the issue of deciding rollover.)
}
   EOD-GET \ download the data for DATE

   mpath chdir \ where things were downloaded

   "EOD-GET" "FILE_LOCAL1" yank dup file? not
   IF " EOD: file not found: " . . nl HALT THEN
   (qFile) asciiload "FILE1" book \ read the pit data

   "EOD-GET" "FILE_LOCAL2" yank dup file? not
   IF " EOD: file not found: " . . nl HALT THEN
   (qFile) asciiload "FILE2" book \ read the electronic market data

\  Read the contract definition file (warning: do nothing here to change
\  text column justification, like running chop or justify):
   mpath "con.dat" + asciiload "CONFILE" book (do not chop)

\  Fetch the contract that was processed today from the lines of 
\  CONFILE that begin with a pair of minus signs:
   CONFILE (hT) dup 1st 2 items catch "--" grepr (hT hRows)
   (hRows) dup "--rows" book
   (hT hRows) reach -2 indent chop (hT) "SYMS" book

\  Fetch the contract that will be processed tomorrow from the lines
\  of CONFILE that begin with a pair of plus signs (note that none of
\  this is used for processing right now; ++SYMS will be swapped to
\  --SYMS after processing to ready file con.dat for tomorrow):
   CONFILE (hT) dup 1st 2 items catch "++" grepr (hT hRows)
   (hT hRows) reach -2 indent chop (hT) "++SYMS" book

   ++SYMS rows --rows rows <>
   IF " eod: rows of old and new con.dat symbols do not match" . nl 
      HALT 
   THEN

\  Fields to keep from FILE1 that contain Open, High, Low, Close, Chg:
   list: 2 3 4 6 7 ; ndx "1FIELDS" book
   7 "FIELD_CHG" ndx book \ the field containing Chg
   8 "FIELD_VOL" ndx book \ the field containing Volume

\  Fields to keep from FILE2 that contain Open, High, Low, Close:
   list: 2 3 4 6 ; ndx "2FIELDS" book

\  Define formats for the output (from mdat.v):
   "%d" makes INT, "%9.2f" makes 2FP, "%9.3f" makes 3FP

\  Build rows of ascii data for all markets:
   depth push
   tracklist rows 1st
   DO tracklist I quote strchop uppercase "SYM" book

      SYM Market \ set up old style words
      Digits 3 = IF 3FP ELSE 2FP THEN "FP" book

    \ Fetch the contract that that was processed today:
      SYMS dup SYM 2 blpad grepr 1st pry (hT nRow) quote
      2nd word drop (qS) uppercase "CON" book \ like K08 (May 2008)
      SYM CON + chars "NSYM" book

    \ Fetch the contract that was processed yesterday from file
    \ latest.dat created by this run yesterday:
      SYM MO "CONprev" book \ like H08 (March 2008) 

\ For debugging, place lines like these at where needed.
\ SYM "HG" = IF "HG HALT " . nl HALT THEN
\ SYM "GC" = IF "GC HALT " . nl HALT THEN

      CONprev CON strmatch 0<>

      IF yes "ROLL" book \ contract changed, doing rollover
         SYM " rollover from " + CONprev + " to " + CON +
         sp sp . nl
      ELSE no "ROLL" book
      THEN

    \ Make the first field for output ascii file (ID+MM+YY):
      KomID intstr (ID)
      CON 1st catch Mnum + (MM)
      CON 2nd 2 items catch (YY) + spaced (IDMMYY, like 410308)

    \ Add the second field, the date in the form 11608 (Jan 16, 2008):
      (hT) "EOD-GET" "DATE" yank unrevdate intstr + spaced (hT)

    \ Fetch the downloaded pit record:
      FILE1 dup 1st NSYM items catch SYM CON + grepr 
      1st pry reach " c" " " strp (qS)

      SYM CON + " for " + "EOD-GET" "DATE" yank intstr + sp . nl
    \ Fetch the downloaded pit volume, and if it is nonzero the
    \ pit was open:
      (qS) SYM pit_open
      IF \ pit was open
       \ Fetch the pit prices:
         (qS) words 1FIELDS reach (hP) \ Open, High, Low, Close, Chg
   
         (hP) ROLL (f)
         IF
          \ Fetch the change in the former contract:
            FILE1 dup 1st NSYM items catch SYM CONprev + grepr any?
            IF (hT nRow) 1st pry reach FIELD_CHG word drop "RCHG" book
             \ Replace Chg with RCHG:
               (hP) 1st 4 items reach RCHG pile (hP)
            ELSE (hT) drop \ unavailable; use Chg now
            THEN
         THEN (hP)

       \ Append pit prices to the first two fields now on the stack:
         (hP) numerate (hA) ints INT format unquoting FP format 
         vol2str (hT "O H L C Chg") + spaced (hT)

      ELSE \ pit was closed
         ROLL 
         IF " eod error: cannot do rollover if pit was closed"
            . nl HALT
         THEN

         SYM " pit was closed on " + "EOD-GET" "DATE" yank intstr + 
         sp . nl (hT qS) 
 
       \ May 2009:

       \ Use the data from FILE1 now in S on the stack, which is for
       \ the previous session, not this one; make change equal to 0.

       \ On a holiday when the pits are closed, electronic markets use 
       \ the pit close on the day before the holiday, so this will give
       \ a closing price that is consistent:
         numerate 
         list: 1 2 3 5 ; reach \ Open, High, Low, Close
         ints INT format unquoting FP format 
         vol2str " 0 " + + (hT) 

{        Before May 2009:
       \ Use session close from FILE1 (which is for previous, not this
       \ closed one) in all price fields, and zero Chg:
         (hT) 6 ndx word drop \ word 6 from T of FILE1
         numerate ints INT format unquoting FP format 4 cats " 0 " +
         (hT "C C C C 0 ") + (hT)
}
      THEN

      (hT)
    \ Fetch the downloaded electronic market prices:
      FILE2 dup 1st NSYM items catch SYM CON + grepr any?
      IF 1st pry reach " c" " " strp (qS)
         (qS) words 2FIELDS reach (hP) \ Open, High, Low, Close
      ELSE 
         (hT)
         SYM " electronic market was closed on " + 
         "EOD-GET" "DATE" yank intstr + sp . nl
         drop 2FIELDS rows 1 null int$ (hP) \ 0, 0, 0, 0

       \ May 2009:
         (hT hP) SYM pit_open not
         IF
          \ Zero the pit prices in T on the stack because electronic
          \ market was also closed:
            (hT hP) swap
            (hT) words 1st 2 items reach vol2str 
            " 0.00 0.00 0.00 0.00 0 " + (hT)
            swap (hT hP)
         ELSE " eod warning: data says pit was open"
              " but electronic was closed" + . nl 
         THEN (hT hP)
      THEN (hT hP)

    \ Add electronic market prices to the data on the stack:
      (hT hP) 
      (hP) numerate (hA) ints INT format unquoting FP format (hP)

    \ May 2009: When pit is closed, use previous open pit prices now
    \ in T:
      (hT hP) vol2str (hT "O H L C") + spaced neat (hT)
{
    \ Before May 2009: Electronic H L can be zero erroneously, giving
    \ bad data.
      (hT hP) SYM pit_open
      IF (hT hP) vol2str (hT "O H L C") + spaced neat (hT)
      ELSE (hT hP) push 
       \ If pit was closed and electronic market open, put electronic
       \ market prices in the pit so H, L, C will be used for previous
       \ in graphed curves:
         (hT) words 1st 2 items reach (ID and date)
         peek pile  \ elec O H L C
         " 0 " pile \ zero change
         pull pile  \ elec O H L C
      THEN
}
      (hT) vol2str spaced (hT)
\ SYM "HG" = IF "HG HALT " . nl HALT THEN
{
      Here is a string for LC, similar to one on the stack right now:
      ID+CON DATE  Open  High  Low   Close  Chg  Eopen Ehigh Elow Eclose
      210408 11108 95.50 95.60 94.50 95.50 -0.47 96.15 96.28 94.53 95.50
}
    \ Mon May 23 14:17:57 PDT 2011.  Add pit volume and open interest
    \ to string T on the stack:
      (hT) FILE1 dup "VOL and OI totals:" grepr reach (hT)
      (hT) dup 1st 2 items catch SYM 2 blpad grepe reach (qS)
      (qS) strchop ":" tug ":" " " strp (hT qS) + (hT) neat (hT)

   LOOP

\  Pile the price data for all markets:
   depth pull less pilen 1 indent "new1" book

\ *** HALT HERE TO CHECK THINGS BEFORE FILES ARE WRITTEN:
\ "HALTING" . nl new1 eview HALT \ halt for debugging

\  Make a backup of file con.dat:
   mpath "con.dat" + push
   "/bin/cp -p " peek + spaced pull + ".bak" + shell

\  Save new con.dat with contract ++SYMS in the previous --rows:
   ++SYMS "--" nose CONFILE chars blpad (qSYM)
   dup rows 1st DO dup I quote CONFILE --rows I pry said LOOP drop

   CONFILE mpath "con.dat" + dup push save
   " EOD: writing new file " . pull . nl
{
   Example when there are --rows:

   When COLLECT-END runs after the session currently underway, which 
   will be tomorrow, these lines will appear in COLLECT.LOG as it
   reads the new con.dat file just written:
      COLLECT-END: Tue Aug 12 14:45:03 PDT 2008
      COLLECT-END: updates to /mdat/con.dat:
          ++FF    X08
          ++CL    V08
          ++HO    V08
          ++HU    V08
          ++NG    V08
          ++JO    X08
          ++HG    Z08
          ++PB    G09
          ++CC    Z08
          ++KC    Z08
      COLLECT-END: /mdat/con_update.dat copied to /mdat/con.dat 
         Tue Aug 12 14:45:03 PDT 2008
}
\  Display information about upcoming changes for rollover, inferred
\  from changes to the ++ data in con_update.dat (these lines are 
\  adapted from the ones in mget.v, word COLLECT-START):
   mpath "con.dat.bak" + file?
   IF mpath "con.dat" + "NEW" book
      mpath "con.dat.bak" + "OLD" book
      OLD NEW diff1 (hT) any?
      IF (hT) dup "--" grepr any?
         IF (hT hRows) reach (hT1)
            " EOD: upcoming rollover changes in " NEW + ":" + . nl
            (hT1) 5 indent . nl
            " EOD: these new contracts will be in tomorrow's data"
            . nl
         ELSE (hT) drop
            " EOD: no rollover changes for tomorrow's session" . nl
         THEN
      ELSE 
         " EOD: no rollover changes for tomorrow's session" . nl
      THEN
   THEN

\ *** HALT HERE TO CHECK con.dat CHANGES:
\"HALTING to review con.dat changes" . nl HALT \ halt for debugging

\  Make a backup of the quarterly file:
   mpath "EOD-GET" "DATE" yank qfilename + dup file?
   IF push "/bin/cp -p " peek + spaced pull + ".bak" + shell
   ELSE drop
   THEN

\  Append new1 to the quarterly file:
   mpath "EOD-GET" "DATE" yank qfilename + push
   " EOD: appending to file " . peek . nl
   new1 peek append
\  and copy this latest quarterly file to safety in archive (I just 
\  spent an hour manually adding the last day to a months-old quarterly
\  file that accidently got replaced by its day-earlier .bak file):
   "/bin/cp -p " pull + " archive/." + shell

\  Run newday to add another day to the yearly binary file:
{
   Running newday deactivated Aug 6, 2009.  One of the running elec-
   tronic consoles should notice that newday needs to be run and 
   should run it.

   Here is an example:
      EUU09 14364 14350 14362 019 17:54 CDT Thu Aug 6, 2009 (16:05:46 PDT, 12 min ago)
      EUU09 14367 14350 14362 019 17:57 CDT Thu Aug 6, 2009 (16:07:17 PDT, 10 min ago)
      ... ycreate: making /mdat/mdata09.bin
      EUU09 14367 14350 14362 019 17:57 CDT Thu Aug 6, 2009 (16:09:29 PDT, 12 min ago)
      EUU09 14367 14350 14362 019 17:57 CDT Thu Aug 6, 2009 (16:09:56 PDT, 13 min ago)
}
{  Reactivated Oct 1, 2009.  
      There is some doubt that the electronic console updates its curves
      even though it ran newday.  

   December 23, 2009.  
      Stop the RTSERVER queue while newday is being run and file
      /mdat/mdataXX.bin is being rewritten.  This should ensure that
      no console windows are getting data to cause them to update.

      When newday is done, start the RTSERVER queue.
}  
\  Run newday to add another day to the yearly binary file:
   newday_run \ running newday to update mdataXX.bin
 
\  Make a backup of file latest.dat:
   mpath "latest.dat" + push
   "/bin/cp -p " peek + spaced pull + ".bak" + shell

\  Remove earliest day and append new1 to make new file latest.dat:
   ldata dup 9 (char offset to 2nd field) 
   over 1st quote 
   2nd word drop
   cite rake lop, new1 pile, mpath "latest.dat" + dup push save
   " EOD: writing new file " . pull . nl

   "revert" "pit" yank
   IF
   \  Send data to collection sites:
      " Send tar file to collection sites?  Say yes. > " 
      query nl "yes" = 
      IF nl " EOD: sending tar file to collection sites" . nl
         dtarout
      THEN
   THEN

   " EOD: done" . nl

   halt

\-----------------------------------------------------------------------

   Appendix.

   To get this new process underway for the first time in January 2008, 
   here is a procedure to remove volume and open interest, and repeat 
   pit data for electronic market O, H, L, C on the latest quarterly 
   file and latest latest.dat:

   FIXUP \ to source this region, run: "eod.v" "FIXUP" msource

   list: 1 2 3 4 5 6 9 ; "FIELDS" book \ keeping these fields
   list: 3 4 5 6 ; "PIT" book 

   mpath "jan-mar.08.new" + asciiload asciify noblanklines "T" book

   FIELDS rows 1st 
   DO T FIELDS I pry word drop spaced LOOP
   FIELDS rows parkn spaced (hT1)

   PIT rows 1st 
   DO T PIT I pry word drop spaced LOOP
   PIT rows parkn (hT2)

   (hT1 hT2) park "T" book

   T rows 1st 
   DO T I quote neat LOOP
   T rows pilen 1 indent mpath "jan-mar.08" + save
   " Wrote jan-mar.08" . nl

   mpath "latest.dat.new" + asciiload asciify noblanklines "T" book

   FIELDS rows 1st
   DO T FIELDS I pry word drop spaced LOOP
   FIELDS rows parkn spaced (hT1)

   PIT rows 1st   
   DO T PIT I pry word drop spaced LOOP
   PIT rows parkn (hT2)

   (hT1 hT2) park "T" book

   T rows 1st
   DO T I quote neat LOOP
   T rows pilen 1 indent mpath "latest.dat" + save
   " Wrote latest.dat" . nl

\-----------------------------------------------------------------------

   Sat May 21 13:27:33 PDT 2011.  Saving pit volume and open interest 
   again.

   The following lines read volume and open interest from daily files
   for 2011 and append pit volume and open interest to quarterly files
   of 2011, jan-mar.11 and apr-jun.11.  The same procedure could be 
   used to save earlier data since January 2008 when volume and open 
   interest were first dropped.

   To run the region below, use: "eod.v" "FIXUP1" msource

   FIXUP1
 
   mpath chdir

 \ First quarter of 2011:

   mpath "jan-mar.11.savold" catpath asciiload (hT1) \ read old
   asciify noblanklines (hT1)

   mpath dirnames dup 1st 7 items catch "11101" grepr reach
   mpath dirnames dup 1st 7 items catch "11102" grepr reach pile
   mpath dirnames dup 1st 7 items catch "11103" grepr reach pile
   "E" "" qreplace noblanklines
   "old" "" qreplace noblanklines asciify
   yes sort "FILES" book

   FILES rows 1st 
   DO FILES I quote asciiload dup "VOL and OI totals:" grepr reach (hT)
    \ (hT) dup tracklist swap park eview halt \ verifies order
      (hT) 2 matread itext 
   LOOP FILES rows pilen (hT2) 

   (hT1 hT2) park neat mpath "jan-mar.11" catpath save \ save new
 
 \ Second quarter of 2011:

   mpath "apr-jun.11.savold" catpath asciiload (hT1) \ read old
   asciify noblanklines (hT1)

   mpath dirnames dup 1st 7 items catch "11104" grepr reach
   mpath dirnames dup 1st 7 items catch "11105" grepr reach pile
   mpath dirnames dup 1st 7 items catch "11106" grepr reach pile
   "E" "" qreplace noblanklines
   "old" "" qreplace noblanklines asciify
   yes sort "FILES" book

   FILES rows 1st
   DO FILES I quote asciiload dup "VOL and OI totals:" grepr reach (hT)
    \ (hT) dup tracklist swap park eview halt \ verifies order
      (hT) 2 matread itext
   LOOP FILES rows pilen (hT2)

   (hT1 hT2) park neat mpath "apr-jun.11" catpath save \ save new

 \ Latest day file (yesterday, Friday 5-20-2011): 

   mpath "latest.dat.savold" catpath asciiload (hT1) \ read old
   asciify noblanklines (hT1)

   mpath "1110520.dat" catpath 
   asciiload dup "VOL and OI totals:" grepr reach 2 matread itext (hT2)

   (hT1 hT2) park neat mpath "latest.dat" catpath save \ save new

   halt

\-----------------------------------------------------------------------

