{  File mdat.v  July 1999

   Copyright (c) 1999   D. R. Williamson

   Revisions August 2004:

      Using new words -Mil and Mil (mrc.v) for an extra digit in ED 
      and FF.

      Using new words -64m and 64m (mrc.v) for "pseudo" 64ths in TN.

      A digits flag added to a market's definition, so ED, FF, and TN
      can have 3 digits on the ascii file.

      The style of this file certainly is strange to see five years 
      later.  I find it very difficult to follow, although things
      started coming to me as I studied it.

      It was written when the program was being developed, and uses 
      inlines that require 'run' to make them go.  Here is an inline
      made in the middle of word keys, just for a DO loop:

         no no blockofblanks, Prices cows 1st 
         [ "DO I MAKE-RECORD pile LOOP" "recs" -strict inline strict ] 
         recs run "new1" book

      Also in the above is the origin of cows, a synonym for cols re-
      sulting from mistyping rows, and appropriate for these markets 
      with live cattle and hogs. 

      Public is used a lot to bring things into view globally.  My style
      now is to hide things in libraries of words; bank and yank were 
      not invented yet.

      Each market has a word, like DJ, that puts its relevant constants
      on the stack, and then word header puts the stack data into pub-
      lic variables for words to see.  

      That is quite a contrast to recent word bcDATA in file bch.v, 
      where a string for the market, like "dj," is incoming on the stack
      and all the constants are set within word bcDATA and a local in-
      line within it is created; and where a processing word like bc8ths
      banks ptrs specific to the solution into the general processing 
      word, bcPROCESS, and then runs it.

\-----------------------------------------------------------------------

   To key all quotes:
      "mdat.v" source keys

   To load the file of five latest days:
      mpath "latest.dat" cat asciiload into fdata

   Then, to initialize for a market, say CL:
      CL latest

   To just initialize scaling functions:
      CL header

   To edit the database file just updated (using word keys):
      fix

   Displaying 32nds:
      32 1 DO I 32 / " %5.3f" format I .i . nl LOOP

   Displaying 64ths:
      64 1 DO I 64 / " %5.3f" format I .i . nl LOOP
}
\-----------------------------------------------------------------------

   'mpath' missing IF " Require path definition: mpath" . halt THEN

   'datespinner' exists? not IF 'cal.v' source THEN
   'choose'      exists? not IF 'tex.v' source THEN

   date sysdate drop 10000 / integer (YYY) is this_year

   "reffile" missing
   IF 'mrc.v' '\  Latest data from web.' msource THEN

\-----------------------------------------------------------------------

   1based private

{  Scaling functions for quotations in various markets:
    2score - 40 (every .025)
    32m - 32 (every 1/32 = .03125)
    4bits - 50 (every .02)
    Cen - 100 (every .01)
    Dec - 10 (every .1)
    Oct - 8 (every .125)
    Score - 20 (every .05)
    Unit - 1 (every 1.0)

   Scaling examples:
      Oct (for octal) converts a number from the database to a string 
      with remainder in eights, like 263.75 to 2636 (263 and 6 eights),
      while -Oct converts the eights-string back to a decimal number.
      
      This latter number has accuracy equal to, and in some cases 
      greater than, the one from the database.  For example, 2score
      converts database number 63.03 to string 6302--the way these
      are quoted--and -2score converts string 6302 to 63.025, the 
      true digits for a quote of 63.03 or 6302 in this market:

         [tops@gutter] ready > 63.03 2score run "6302" -2score run

          stack elements:
                0 number: 6.3025E+01
                1 string: 6302  1 by 4
          [2] ok!
         [tops@gutter] ready > 

      To convert a vector read from the database--say C--to its full 
      digits, run

           C quoting unquoting(C numbers with full digits)

      or for an individual number, say c, run

           c quoting unquoting ontop (does what the example above did)

      All values from the database are adjusted in this way by word
      precision as they are loaded by word latest.
}
\  Markets: 
\     The digits column was added in August 2004.
   ( ---       qS   qFs       qFr  digits lim  k)
   define: W  "W"  "Oct"    "-Oct"    2   20  11 ;
   define: CO  "C"  "Oct"   "-Oct"    2   12  12 ;
   define: S  "S"  "Oct"    "-Oct"    2   30  13 ;
   define: SM "SM" "Dec"    "-Dec"    2   10  14 ;
   define: BO "BO" "Cen"    "-Cen"    2    1  15 ;

   define: LC "LC" "2score" "-2score" 2   1.5 21 ;
   define: LH "LH" "2score" "-2score" 2   1.5 22 ;
   define: PB "PB" "2score" "-2score" 2   3.0 23 ;

   define: SB "SB" "Cen"    "-Cen"    2   0.5 32 ;
   define: KC "KC" "Score"  "-Score"  2   6   33 ;
   define: JO "JO" "Score"  "-Score"  2   7.5 34 ;
   define: CC "CC" "Unit"   "-Unit"   2   88  35 ;

   define: HG "HG" "Score"  "-Score"  2   5   41 ;
   define: SI "SI" "Dec"    "-Dec"    2   50  42 ;
   define: PL "PL" "Dec"    "-Dec"    2   25  43 ;
   define: GC "GC" "Dec"    "-Dec"    2   25  44 ;

   define: CT "CT" "Cen"    "-Cen"    2   2   53 ;
   define: HO "HO" "Cen"    "-Cen"    2   2   54 ;
   define: CL "CL" "Cen"    "-Cen"    2   1   55 ;
   define: HU "HU" "Cen"    "-Cen"    2   2   56 ;
   define: NG "NG" "Dec"    "-Dec"    2   20  57 ;

   define: SF "SF" "Cen"    "-Cen"    2   1.5 61 ;
   define: BP "BP" "4bits"  "-4bits"  2   5   62 ;
\  define: DM "DM" "Cen"    "-Cen"    2   1   63 ; (discon. Dec 18, 01)
   define: JY "JY" "Cen"    "-Cen"    2   1   64 ;
   define: MP "MP" "Cen"    "-Cen"    2   1   66 ;
   define: MP "MP" "Mil"    "-Mil"    3   1   66 ;
\  define: RE "RE" "Score"  "-Score"  2   0.5 67 ; (discontinued 990601)
   define: EU "EU" "Cen"    "-Cen"    2   1   68 ;

   define: ED "ED" "Mil"    "-Mil"    3   1   65 ;
   define: TN "TN" "64m"    "-64m"    3   2   71 ; \ started 4-25-0
\  define: TB "TB" "Cen"    "-Cen"    2   0.6 72 ; \ discon. Apr 2, 04
   define: FF "FF" "Mil"    "-Mil"    3   0.6 79 ; \ started Apr 2, 04
   define: US "US" "32m"    "-32m"    2   2   73 ;
   define: SP "SP" "Dec"    "-Dec"    2   5   74 ;
   define: YX "YX" "Score"  "-Score"  2   2.5 75 ;
   define: DJ "DJ" "Unit"   "-Unit"   2   100 76 ;
   define: NK "NK" "Cen"    "-Cen"    2   100 77 ;
   define: NQ "NQ" "Dec"    "-Dec"    2   100 78 ;
      
   "allOrder" 
   {" order of items to enter:
      w co s sm bo
      lc lh pb
      cc kc sb jo
      hg gc pl si
      ct cl ho hu ng
      sf eu jy mp bp
      us tn ff ed
      dj sp nq yx nk
   "} uppercase words swap book
   allOrder "Order" book

\-----------------------------------------------------------------------

   no "ESC?" book \ quit
   yes "EZ" book \ easy ok
   no "REP" book \ repeat

   define: %new (hVI --- n) \ percentage of contracts that are new
{     Ignores day traders 

         n = 100*[V + (I-Io)]/(2*V) = 50*[V + (I-Io)]/V

      Yesterday's open interest is in OI, latest is on stack in VI

}     this 1st pry, back 2nd pry (V I)
      2dup star 0= IF 2drop 0 return THEN 
      "OI" main, these rows pry (Io) less (I-Io)
      that (V) plus back slash 50 star
   end

   define: fix ( --- ) \ display today's database file to fix
      mpath "thisday" main qfilename cat _vi ;

   define: fixlatest ( --- ) \ display latest data to fix
      mpath 'latest.dat' cat _vi
   end

   public
   define: header (qS qFs qFr dig lim k --- ) \ constants for market k
\     Usage: US header
      [ {"
      (k) into KomID,
      (lim) into Limit,
      (dig) into Digits
      (qFr) into Rescale,
      (qFs) into Scale,
      (qS) into Symbol
      "} "_header" -strict inline strict ] _header run
   end
   private

   define: intvec (hV --- hT) \ vector V numbers into integer strings
      [ {"
      push list: peek rows 1st DO peek I pry int$ LOOP ; 
      words pull drop 
      "} "intvec" inline ] intvec run 
   end

   public
   define: keys ( --- ) \ data entry loop
      [
      {"
      allOrder "Order" book 

      BEGIN 
         ESC? IF return THEN no "REP" book

         Order Prices cows 1st plus reach 
         main latest quoteline (hP)

         Prices cows no = 
         IF (hP) its these rows quote 1st word drop
            number drop workday datespinner makes thisday 
         THEN
         Months again " " tail
            Con these rows pry 100 /mod (yr mo)
            again rot (mo yr) push push
            " " Symbol " contract month " cat cat
            (Months mo qS) nl dot choose (mo1)
            again pull (mo1 mo) 2dup <> says newDelmo
            < (f, says the following year)
            over (f mo1) 100 star pull (yr) rot (f)
            IF tic THEN its 99 > IF 100 less THEN plus
            (mo1yr) Delmo swap pile onto Delmo
         (Months n) quote makes month
 
         Symbol nl sp . (hP) these rows reach sp crowd . nl

         " " Symbol spaced cat, thisday int$ cat spaced
         month cat spaced makes prompt

         prices 
         volume 

         Prices cows Order rows = REP no = and 
         ESC? or

      UNTIL 
      "} -strict "_keys" inline strict
      ] 
      no "ESC?" book, 5 no empty "Prices" book, 
      no one empty "KomIDs" book, 2 no empty "Volume" book, 
      no one empty "Delmo" book  

      mpath "latest.dat" cat asciiload into ldata

      time "t0" book, _keys run, ESC? IF return THEN 

      " minutes;" time t0 less 60 slash " ET%5.1f" format nl dot dot 
      " standby ..." dot

      no no blockofblanks, Prices cows 1st 
      [ "DO I MAKE-RECORD pile LOOP" "recs" -strict inline strict ] 
      recs run "new1" book

    \ reffile wstrip (removed 8-14-2007)
      thisday qfilename " appending to file " dot dot nl
      new1 mpath thisday qfilename cat append  

      ldata again 9 over, 1st quote, 2nd word drop, 
      cite rake lop, new1 pile, mpath "latest.dat" cat save
   end 
   private

   public
   define: latest (qS qFs qFr dig lim k --- ) \ data for k from database
{    Usage: LC latest
     Typical line of data (this one is for LC and lacks digits because
     63.33, for example, is really 63.325; word precision is used to
     adjust this):
        210699 42699 62.95 63.73 62.95 63.33 12791 99249 .60
}     [ " stack not set up" "notset" book
      {" 
      depth 5 < IF notset dot return THEN
      header ldata 2nd KomID int$ cite, ldata back rake trash
      these rows swap numerate, swap matrix
      this 1 catch dup 10000 /f integer 10000 *f less, into Con  
      this 2 catch revdate into Date 
      this 3 catch precision into O, this 4 catch precision into H
      this 5 catch precision into L, this 6 catch precision into Clo 
      this 7 catch into V, this 8 catch into OI
      9 catch precision into Chg 
      "} -strict "_latest" -strict inline strict ] _latest run
   end
   private

   public
   define: leaving ( --- f) \ flag to abort or re-enter
\     This replaces phrase "ESC? REP or" in a number of places 
      [ "ESC? REP or" "_leaving" inline ] _leaving run ;
   private

   public 
   define: limcheck (hA --- delta) \ price limit check, return change

      newDelmo 
      IF drop " Chg: " numinp (delta) int$ unquoting return THEN

      Clo these rows pry (C) push \ former C onto local stk

      this 4 pry (C) int$ unquote peek (C) less (delta) 
      dup quoting . swap (delta hA) 

      this 2 pry (H) int$ unquote peek (C) less abs Limit > 
      IF " High is outside limit " nl . THEN
      
      (delta hA) 3 pry (L) int$ unquote pull (C) less abs Limit > 
      IF " Low is outside limit " nl . THEN
      
   end
   private

   public
   define: MAKE-RECORD \ same format as BASIC and Forth progs (k --- qS)
{    Typical lines of data (these are for LC):

         From Forth program MAKE-RECORD:
            210699 42699 62.95 63.73 62.95 63.33 12791 99249 .60

         From this version of MAKE-RECORD, used the next day:
            210699 42799 63.60 63.83 63.50 63.67 12325 99185 0.35

         Aug 8, 2004: Intorduce Digits, to allow 9.2 or 9.3 formats.
}     [ "%d" makes INT, "%9.2f" makes 2FP, "%9.3f" makes 3FP {"

      "k" book, Order k quote main header
      KomIDs k pry 10000 star, Delmo k pry plus int$ spaced

      Digits 3 = IF 3FP ELSE 2FP THEN "FP" book

      thisday unrevdate ontop int$ park spaced

      Prices k catch, 1st 4 items reach, ints INT format unquoting
      bend FP those cols cats format ('O H L C') cat spaced

      Volume k catch ints INT format these
      1st quote ('V') spaced swap, 2nd quote cat ('V OI') cat spaced

      Prices 5 k fetch FP format cat 

      crowd once indent

      "} "maker" -strict inline strict
      ] maker run
   end
   private

{
   This now comes from mrv.c:
   "Months" "F-Jan G-Feb H-Mar J-Apr K-May M-Jun " 
            "N-Jul Q-Aug U-Sep V-Oct X-Nov Z-Dec" cat words, swap book
}

   public
   define: OK? ( --- f) \ response; x to abort, r to re-enter
      [ {" 
      " ok? " query lowercase "EZ" main
      IF dup " " strmatch 0= IF drop yes return THEN
      THEN
      dup "y" strcmp 0= IF drop yes return THEN
      dup "*" strcmp 0= IF drop yes return THEN
      dup "x" strcmp 0= IF drop yes dup "ESC?" book return THEN
      dup "r" strcmp 0= IF drop yes dup "REP" book return THEN
      drop no nl
      "} "_OK?" inline ] _OK? run
   end
   private

   define: precision (hC --- hC1) \ adding precision to database values
{     Note: Relevant "Scale" and "Rescale" must have been set up.  One
      way to do this is with phrase "XX header" for market XX, like
      "LC header" for LC.  Another is with latest, as in "LC latest."
}     quoting unquoting ;

   public
   define: prices ( --- ) \ entering prices 
      BEGIN prompt . kon accept drop koff 1 verify leaving
         IF  
            IF drop yes THEN 
         THEN 
      UNTIL leaving 
      IF Delmo 1st those rows nit items reach "Delmo" book
      ELSE Prices swap park, "Prices" book 
         KomIDs KomID pile "KomIDs" book
      THEN
   end
   private

   define: quoting (P --- qP) \ converting numbers P to quote-string P
      [ {"
        hand push, no no blockofblanks
        peek rows 1st 
        DO peek I pry 
           "Scale" main (qS) main (hP) run pile 
        LOOP pull drop 
        "} "quoting" inline 
      ] quoting run 
   end

   public
   define: quoteline ( --- hT) \ lines of quotes from word latest
      [ {"
        Date intvec
        Months, Con 100 /f integer reach, 
        one indent park (hM)

        O quoting, H quoting one indent park,
        L quoting one indent park,
        Clo quoting one indent park, 
        Chg quoting right justify one indent park (hQ)

        (hM hQ) one indent park 
        V intvec, OI intvec 
        one indent park, one indent park
        "} "_quoteline" -strict inline strict ] _quoteline run 
   end 
   private

   define: unquote (qP --- P) \ quoted price string into a number
      "Rescale" main (qS) main (hP) run ;

   define: unquoting (qP --- P) \ column of quoted prices into numbers
      [ {"
      hand again push rows 1st
      DO peek I quote unquote LOOP pull rows listn
      "} "unquoting" inline ] unquoting run
   end

   define: verify (hV case --- no | hV1 yes) \ sanity checks
\     Incoming V is O,H,L,C; outgoing V1 is O,H,L,C,chg
      [ " high not highest" "highNot"
        " low not lowest" "lowNot"
        " need 4 prices" "need4"
        " need vol and open int" "needVI"
        book book book book
      {"
      1 (case) =
      IF (hV prices:) numerate these rows 4 = (need 4 rows)
         IF this minfetch 2drop, that 3 pry = (3rd is min)
            IF this maxfetch 2drop, that 2 pry = (2nd is max)
               IF dup limcheck (chg) pile yes
               ELSE highNot . nl drop no
               THEN
            ELSE lowNot . nl drop no
            THEN
         ELSE need4 . nl drop no
         THEN

      ELSE (2 case =)
         (vol, open int:) numerate these rows 2 =
         IF dup volcheck (hV f) dup no = IF lop THEN 
         ELSE needVI . nl drop no
         THEN
      THEN 

      IF OK? 
         its not IF 2drop no THEN
      ELSE no
      THEN 
      "} "verify" -strict inline strict ] verify run
   end

   define: volcheck (hV --- f) \ volume and open interest sanity check
      [ 3 is ave ]
      this 2 pry, "OI" main its rows pry less int$ sp .

      "V" main its rows tic ave less, ave items reach
      totals ontop ave slash into Vbar
      "  Vbar: " Vbar int$ cat . 

      Vbar 1.5 star is big, Vbar 0.50 star is small
      this 1st pry big > IF " HIGH VOL " . beep THEN
      this 1st pry small < IF " LOW VOL " . beep THEN
 
      %new this 0 < that 100 > or
      IF drop " VOL or INT bad " . beep getch drop no
      ELSE this 40 < that 60 > or
         IF int$ "  %new: " swap cat . ELSE drop THEN yes
      THEN
   end

   public
   define: volume ( --- ) \ entering volume and open interest
      [ {"
      leaving IF return THEN nl "    V I " dot tout says prompt
      BEGIN prompt out spaces cr dot, cr dot
         kon accept drop koff 2 verify leaving
         IF  
            IF drop yes THEN 
         THEN 
      UNTIL leaving not 
      IF Volume swap park "Volume" book 
      ELSE REP \ if repeating, remove latest price column, KomID row, 
\        and Delmo row:
         IF Prices 1st those cows nit items catch "Prices" book
            KomIDs 1st those rows nit items reach "KomIDs" book
            Delmo 1st those rows nit items reach "Delmo" book
         THEN
      THEN
      "} "_volume" -strict inline strict ] _volume run 
   end
   private

   end end end

\-----------------------------------------------------------------------
; Appendix.
\-----------------------------------------------------------------------

{ Scaling most of NQ ascii data by factor of 10 if value < 1000.

      Typical data to factor by 10:

         781298 121698 168.50 169.80 166.10 168.06 7290 12711 1.60
         780399 121798 167.00 171.30 167.00 171.20 6512 12772 3.20

         780399 122198 175.22 181.60 175.20 180.30 3222 13907 4.80
         780399 122998 184.00 184.80 181.60 184.70 2353 8926 1.04
         780399 123198 182.50 186.90 182.50 185.40 3234 9113 -.80
}

   "partition" missing IF mat.v source THEN

   define: fixnq (qFile --- )
      [ list: 0 0 1 1 1 1 0 0 1 ; makes C
        " %d " makes INT, "%9.1f" 4 cats makes 4FP
      ]
      mpath swap cat dup 9 asciiread into A,
      dup asciiload dup 1 " 78" cite makes R
      R rip into Atext drop

      A R rip drop, C claw (hCorrect)
      dup 1st catch 1000 those rows 1 fill < (-1 if 10, 0 if 1)
      -9 *f 1 +d those cols clone \ matrix of ones and tens to scale by
      *by C mesh (hCorrected) \ scaled and put back together
      push \ formatting:
      peek 1 catch ints INT format
      peek 2 catch ints INT format park
      peek 3 4 items catch 4FP format park
      peek 7 catch ints INT format park
      peek 8 catch ints INT format park
      pull 9 catch "%9.2f" format park

      push 0 0 blockofblanks peek rows 1st
      DO peek I quote crowd pile LOOP pull drop
      1 indent Atext chars +trailing

      Atext R tier
      swap " Saving new " over cat . nl save

   end

   {"
      jan-mar.99
      apr-jun.99
      jul-sep.99
      oct-dec.99
      jan-mar.00
   "} chop into files

   files rows 1st DO files I quote fixnq LOOP

   private halt

\-----------------------------------------------------------------------

With keys set up to just read latest and display it, this shows correct
operation of scaling functions for all markets:

[tops@gutter] ready > date .
Sun Aug  1 13:51:09 PDT 1999
[tops@gutter] ready > keys
C 990426 N-Jul 2254 2254 2210 2214 -42 49878 343375
S 990426 N-Jul 4946 4946 4874 4904  -40 36015 169135
SM 990426 N-Jul 1321 1321 1300 1318 -10 24348 112546
BO 990426 N-Jul 2017 2040 1990 2005 -012 13664 136795
W 990426 N-Jul 2650 2654 2620 2630 -26 19713 117112
LC 990426 M-Jun 6295 6372 6295 6332  060 12791 99249 
LH 990426 M-Jun 5770 5825 5715 5817  057 10993 48963
PB 990426 K-May 5640 5640 5455 5507 -157 1677 5083
CC 990426 N-Jul 1032 1038 992  994  -32 5007  63587
KC 990426 N-Jul 9850  10150 9850  9995   140 9488  44994
SB 990426 N-Jul 445 451 433 435 -009 36602 195549
CT 990426 N-Jul 5922 5985 5900 5901 -063 23529 60644
JO 990426 N-Jul 8700 8800 8660 8770  090 4159 30903
HG 990426 N-Jul 6965 7045 6940 7030 -035 11028 72991
GC 990426 M-Jun 2853 2853 2817 2826 -23 14763 198094
PL 990426 N-Jul 3555 3590 3540 3552 -09 880  11313
SI 990426 N-Jul 5160 5165 5070 5118 -48 12386 84081
CL 990426 M-Jun 1791 1799 1745 1766 -028 98527  588940
HO 990426 M-Jun 4360 4370 4260 4307 -075 44406 176581
HU 990426 M-Jun 5350 5350 5145 5263 -055 33458 112357
NG 990426 M-Jun 2225 2330 2210 2325  72 65583 335567
US 990426 M-Jun 12022 12115 12008 12113  014 281799 621852
TB 990426 M-Jun 9563 9565 9562 9565  000 461 1480
ED 990426 U-Sep 9489 9490 9486 9489  000 237621 2938039
DJ 990426 M-Jun 10760 10780 10690 10775  25 12462 22934
SP 990426 M-Jun 13638 13720 13605 13715  65 70176  382639
NK 990426 M-Jun 17010 17050 16925 17030  070 1113 24652
NQ 990426 M-Jun 22230 22970 22230 22716  450 11027 21494
JY 990426 M-Jun 8434 8483 8417 8439  006 10361 89457
DM 990426 M-Jun 5439 5450 5425 5430 -013 6856  36059
BP 990426 M-Jun 16128 16168 16094 16112 -024 6978  64880
SF 990426 M-Jun 6653 6667 6632 6640 -014 21327 68497
MP 990426 M-Jun 10520 10530 10470 10498 -006 5524 23237
RE 990426 M-Jun 5750 5765 5750 5765 -035 229 3164
EU 990426 M-Jun 10644 10656 10612 10620 -026 8273  41316
YX 990426 M-Jun 64200 64475 63979 64315  040 1509 4155

[tops@gutter] ready > 

Theses are special words for entering TN data for a year or so to 
get it started.

   define: keysnew ( --- ) 
      BEGIN keys1 nl " more? " query lowercase 'n' alike erp UNTIL
   end

   public
   define: keys1 ( --- ) \ special data entry loop, driven by keysnew
   \  Used to enter T-Notes for 1999, 2000.
      [
      {"
      "TN" "Order" book \ set special ones to do here.
      \ latest1.dat is the latest file name for this word
      \ names like jan-mar.99.add are saved

      BEGIN
         ESC? IF return THEN no "REP" book

         Order Prices cows 1st plus reach
         main latest quoteline (hP)

         Prices cows no =
         IF (hP) its these rows quote 1st word drop
            number drop workday datespinner makes thisday
         THEN
         Months again " " tail
            Con these rows pry 100 /mod (yr mo)
            again rot (mo yr) push push
            " " Symbol " contract month " cat cat
            (Months mo qS) nl dot choose (mo1)
            again pull (mo1 mo) 2dup <> says newDelmo
            < (f, says the following year)
            over (f mo1) 100 star pull (yr) rot (f)
            IF tic THEN its 99 > IF 100 less THEN plus
            (mo1yr) Delmo swap pile onto Delmo
         (Months n) quote makes month

         Symbol nl sp . (hP) these rows reach sp crowd . nl

         " " Symbol spaced cat, thisday int$ cat spaced
         month cat spaced makes prompt

         prices
         volume

         Prices cows Order rows = REP no = and
         ESC? or

      UNTIL
      "} -strict "_keys1" inline strict
      ]
      no "ESC?" book, 5 no empty "Prices" book,
      no one empty "KomIDs" book, 2 no empty "Volume" book,
      no one empty "Delmo" book

      mpath "latest1.dat" cat asciiload into ldata

      time "t0" book, _keys1 run, ESC? IF return THEN

      " minutes;" time t0 less 60 slash " ET%5.1f" format nl dot dot
      " standby ..." dot

      no no blockofblanks, Prices cows 1st
      [ "DO I MAKE-RECORD pile LOOP" "recs" -strict inline strict ]
      recs run "new1" book

      thisday qfilename ".add" cat " appending to file " dot dot nl
      new1 mpath thisday qfilename ".add" cat cat append

      ldata again 9 over, 1st quote, 2nd word drop,
      cite rake lop, new1 pile, mpath "latest1.dat" cat save

   end
   private

