{  File mget.v  August 2004 

   Copyright (c) 2004-2012   D. R. Williamson

------------------------------------------------------------------------

   Contents:

      How to gather names for contents:
         "mget.v" asciiload this " inline:" grepr reach dot
         "mget.v" asciiload this " function " grepr reach dot

   Notes

   inline: close_all ( --- ) \ close all electronic collections
   inline: _holiday_close (qHoliday hMkts --- )
   inline: holiday (nYYYMMDD--- f)
   inline: Holidays ( --- )
   inline: Christmas_Day ( --- ) \ or Christmas Eve day
   inline: Good_Friday ( --- )
   inline: Independence_Day ( --- )
   inline: Labor_Day ( --- )
   inline: Martin_Luther_King_Day ( --- )
   inline: Memorial_Day ( --- )
   inline: New_Years_Day ( --- )
   inline: Presidents_Day ( --- )
   inline: Thanksgiving_Day ( --- )

   inline: collect (qMkt --- hT) \ collect latest data for Mkt
   inline: COLLECT_END ( --- ) \ end a collection session
   inline: COLLECT_MAKE (qMKT qTASK f --- ) \ make a collection word
   inline: COLLECT_START ( --- ) \ prepare for and start collections
   inline: eCOLLECT (qMKT --- ) \ collect data
   inline: ecollect (qMkt --- hT) \ collect electronic market data
   inline: ecollect_r (qMkt --- hT) \ collect electronic market data
   inline: elec_now (qMkt --- hT) \ current electronic data for Mkt
   inline: elec_times ( --- hA) \ electronic collection times
   inline: HIST_ADD (qMKT --- ) \ append latest data to MKT hist file
   function hist_add(MKT) /* append latest data to MKT history file.*/
   inline: hist_gmt (hT hLA --- hGMT nZ0) \ LA time into machine time
   inline: hist_rm ( --- ) \ remove old history files at session start
   inline: _now (qMkt --- hT) \ current data for Mkt
   inline: pcollect (qMkt --- hT) \ collect market pit data
   inline: pcollect_r (qMkt --- hT) \ collect market pit data
   inline: pidtable_tops ( --- hT) \ table of process ids and commands
   inline: pit_now (qMkt --- hT) \ current pit data for Mkt
   inline: pit_times ( --- hA) \ pit collection times
   inline: skipINO (qMKT --- f) \ flag true to skip INO collection
   inline: skipTC (qMKT --- f) \ flag true to skip TC collection
   inline: soonest (hTimes -- nSec) \ next alarm is at nSec from now
   inline: soonest_task ( --- f) \ true to do COLLECT_START
   inline: soonest_taskd (nD --- f) \ delayed true to do COLLECT_START
   inline: timeline (qS --- hTimes) \ return timeline times for S
   inline: timeline_add (qS hA --- ) \ add timeline A called S
   inline: tline (qStart qEnd nDT --- hA) \ timeline from Start to End
   inline: tline_sec (qHH:MM:SS --- sec) \ sec in timeline for HHMMSS
   inline: TM ( --- ) \ process time markers for history files
   inline: TMstart ( --- ) \ write the starting time markers, all files
   inline: TMwrite (qMKT nt --- ) \ time marker on MKT history file
   inline: CH>LA (qHH:MM:SS --- qHH1:MM:SS)
   inline: COLLECT (qMKT --- ) \ collect data
   inline: EOD-eCOLLECT ( --- ) \ end of day electronic collection
   inline: EOD-pCOLLECT ( --- ) \ end of day pit collection
   inline: KILL.V ( --- ) \ kill extraneous jobs that should have died
   inline: kill_S (qS --- ) \ kill job with S in name
   inline: KILL_PID ( --- ) \ kill long running PIDs from msg COLLECT
   inline: LAdate ( --- qDate) \ date in LA
   inline: LOG-FILE ( --- qFile) \ name of this script's log file
   inline: LOG-TOUCH ( --- ) \ touch the log file
   inline: make_times (starts closes every --- hT) \ T holds GMT
   inline: Mo_fix (qSymMoYY --- qSymMoYY1) \ fix contract month symbol
   inline: Mo_fix1 (qSymMoYY --- qSymMoYY1) \ fix contract month symbol
   inline: msgSPEED (qS bytes delta --- ) \ net speed message
   inline: next_at (hTimes --- nSec) \ next alarm today at nSec from now
   inline: NY>LA (qHH:MM:SS --- qHH1:MM:SS)
   inline: TEXT>TABLE (hT f n% --- hT1) \ text into HTML table
   inline: times (qS --- hGMT) \ times (GMT) today to run S
   inline: DT ( --- DT) \ step in minutes
   inline: dt ( --- dt) \ time shift in seconds
   inline: _COLLECT_MAKE (qMKT qTASK f --- ) \ make a collection word

   Appendix
      Notes

------------------------------------------------------------------------

   Notes

   Fri Nov 30 10:55:21 PST 2012.  Times in this note are Central.
   Electronic markets of stock indices (DJ, SP, NQ) have always had a 
   quirky one hour opening session from 15:30 to 16:30, followed by a
   break until 17:00 when trading for the earlier opening resumed.  All
   other electronic markets never opened before 17:00 (and a number of
   them much later).

   Now these stock index markets appear to work as follows (based upon
   real time data from CME E-quotes):

      After a 15 minute break from 15:15 to 15:30, these markets resume
      the same session until 16:15.  Then a new session opens at 17:00
      just like other ones, such as bonds (US and TN).

   The odd ball one hour opening session disappeared sometime during the
   week of Thanksgiving 2012.  In TIMELINES below, electronic DJ, SP and
   NQ now end at 16:15 CT, not 16:30 (The quirky one hour earlier open
   was never recognized by this program; now there is nothing to fix).

   May 2009 
   Early opening of currency markets has not been done for months, and 
   any effort for handling outside hours as discussed in the September 
   2008 note below, is on hold.

   February 8, 2009
   It is Sunday, and the currency markets for EU, JY, SF and BP do not
   appear to have opened two hours early, at 15:00 (Central).  Has the
   early opening, written about below, been curtailed?

   September 2008
   Ideas on what to do for sessions that are outside of the built-in 
   ones from 17:00 to 16:45 (Central), Sunday through Thursday.

   Since designing and deploying this system, sessions outside of its 
   built-in times have come to light.  For example:

      currencies open two hours earlier only on Sunday, at 15:00;

      on Sunday, September 14, 2008, energy electronic markets opened 
      at 10:00 (Eastern) for special trading related to hurricane Ike.

   The common thing about these cases is that they apply only to a few 
   markets.  The case of currencies opening earlier on Sunday has prob-
   ably become a regular schedule, but applies only to currencies; and 
   the special energy market session for hurricane Ike is an example of
   a random event.  

   Perhaps both of these cases should be handled by a new type of pro-
   gram that works for special events, rather than trying to modify the
   current one.  

   Some of the words already in this file can probably be assembled 
   into a "special event" collection program that can be fired up when-
   ever there is trading outside of the built-in times.

   As evidence of this capability, the following was run interactively 
   during the special session for hurricane Ike on Sunday, September 14,
   2008, and showed that words eCOLLECT and HIST_ADD work fine:

      "cl" eCOLLECT \ collect electronic crude oil quotes
      "cl" HIST_ADD \ add to binary history file

   These files, updated from Friday, September 12, appeared in /tmp 
   due to the above commands (dates are PDT on machine plunger):

      Files from eCOLLECT:
         -rw-rw-rw-    1 dale  comm      3529 Sep 14 11:16 CL_TC.eDAT
         -rw-rw-rw-    1 dale  comm      8739 Sep 14 11:16 CL_IN.eDAT
         -rw-rw-rw-    1 dale  comm     89441 Sep 14 11:16 CL.eLOG

      File from HIST_ADD:
         -rw-rw-rw-    1 dale  comm     38995 Sep 14 11:18 CL.hLOG

   Data collected was also saved by HIST_ADD into the binary history 
   file /mkt/edat0/1080915_CL.bin, used by market analysis and graphics
   programs; this new file is correctly dated for tomorrow, Monday.  

   When the regular session collection begins later today (Sunday), it 
   can be expected to append data to this new file until the session 
   ends on Monday at 16:45 (Central).  (However, this is just an exper-
   iment, so file /mkt/edat0/1080915_CL.bin will be deleted prior to 
   regular session start up later today.)

   Viewing CL_IN.eDAT showed current data reflecting the special ses-
   sion, while CL_TC.eDAT did not.  Viewing the times in CL.hLOG con-
   firmed that the data of CL_IN.eDAT is current while the data of
   CL_TC.eDAT is for last Friday.  Apparently, tradingcharts.com is
   not set up to collect this special data, but quotes.ino.com is.

   This shows the summary in the "daily" window working correctly (file
   mrc.v, word summary_rt_show), indicating use of special session data
   for CL saved in /mkt/edat0/1080915_CL.bin (and the fact that crude 
   oil has fallen below $100 to $99.93):

      Sun Sep 14 12:38:59 PDT 2008
      WZ08  7390   7436   7150   7192   -70   closed
      CZ08  5510   5632   5316   5632   300   closed
      ...
      SIZ08 10660  10990  10585  10795  240   closed
      PLV08 11560  12180  11510  12105  583   closed
      CLZ08 10050  10050  9928   9993   -169  12:27
      HOV08 29338  29774  29154  29391  236   closed
      HUV08 27550  28793  27330  27696  208   closed
      ...

   Conclusions 

   One of the two collection sources recognizes special sessions and so
   data is available.

   It has been demonstrated that collection outside of the regular pro-
   gram will transparently update time history files, and is probably a
   better way to approach special trading sessions by leaving the cur-
   rent program timelines and operation unchanged.  

   Special session programs should be able to be run for a particular
   market or for a subset of markets, and should only be run outside of
   regular collection hours covered by the current collection program.

   Running a special session program whenever random sessions are cal-
   led (as for hurricanes) should be straightforward, and it could also
   be run on a regular basis, like every Sunday for the currency mar-
   kets that open two hours early.

   Handling the new data in real time graphics may require some changes
   as times of data fall outside of the built-in ones.
}
\-----------------------------------------------------------------------

\  Load resource files.

   CATMSG push no catmsg

   "loadref" missing IF "mrc.v" source THEN
   "hist_fname" missing IF "mfil.v" source THEN

   "msgComm" missing IF "dog.v"  source THEN
   "ranreal" missing IF "math.v" source THEN
   "weekday" missing IF "cal.v"  source THEN
   "queue_run" missing IF "task.v" source THEN

   "bcDATA"  missing IF "bch.v" source THEN
   "fsDATA"  missing IF "fs.v"  source THEN
   "tcDATA"  missing IF "tch.v" source THEN
   "inoDATA" missing IF "ino.v" source THEN

   ontheweb not IF "snd.v" source THEN \ for BONG

\-----------------------------------------------------------------------

{  Holidays:

\  This section is sourced every time COLLECT_START runs to begin a new
\  session, to make sure the latest dates are included.
 
   HOLIDAYS

   CATMSG push no catmsg

   inline: close_all ( --- ) \ close all electronic collections
      " close_all:" tracklist _holiday_close
   end

   inline: _holiday_close (qHoliday hMkts --- )
\     For Holiday, turn off collection ALARMs for the words listed in 
\     Mkts.

      swap (qHoliday) strchop " " nose
      " sessions closed starting " + date + . nl
      
      (hMkts)
      left justify "e" nose
      right justify "-COLLECT" tail
      dup rows 1st
      DO "  closing: " . dup I quote strchop
         dup . nl -ALARM 
      LOOP drop
   end

   inline: holiday (nYYYMMDD--- f)
    \ Return true if session ends on a holiday, which means it should
    \ not open on the day before.
    \ Valid only in real time.
      (nYYYMMDD)
      time dup soonest_end + ctime sysdate drop (nHoliday)
      (nYYYMMDD nHoliday) =
   end

   inline: Holidays ( --- )
\     Check for a holiday, and turn off certain collections.
      Christmas_Day
      Independence_Day 
      Good_Friday
      Labor_Day
      Martin_Luther_King_Day
      Memorial_Day
      New_Years_Day 
      Presidents_Day
      Thanksgiving_Day
   end

{
   BIG NOTE.
   BIG NOTE.
   BIG NOTE.
   BIG NOTE.
   BIG NOTE.
   BIG NOTE.
   BIG NOTE.

   April 2009.

   Holiday words now use the actual YYYMMDD of the day that is closed,
   not the previous-day session start, by calling word holiday.

   See Good_Friday for the way they now must be set up.
}
 \ Discontinued PB, 11-17-2010; PB removed from all lists.

   inline: Christmas_Day ( --- ) \ or Christmas Eve day
    \ Not open on Thursday, Dec 25, 2014
      1141225 holiday
      IF " Christmas_Day"
       \ Halt these collections:
         tracklist _holiday_close \ close all of them
      THEN
   end

   inline: Good_Friday ( --- )
    \ Not open on Friday, Apr 18, 2014
      1140418 holiday
      IF " Good_Friday"
       \ Halt these collections:
         tracklist _holiday_close \ close all of them
      THEN
   end

   inline: Independence_Day ( --- )
    \ Some markets closed Friday, July 4, 2014
      1140704 holiday
      IF " Independence_Day"
       \ Halt these collections:
         "W C S SM BO LC LH CC KC SB JO CT" words _holiday_close
      THEN
   end

   inline: Labor_Day ( --- )
    \ Some markets closed Monday, Sep 1, 2014
      1140901 holiday
      IF " Labor_Day"
       \ Halt these collections:
         "W C S SM BO LC LH CC KC SB JO CT" words _holiday_close
      THEN
   end

   inline: Martin_Luther_King_Day ( --- )
    \ Not open on Monday, Jan 20, 2014
      1140120 holiday
      IF " Martin_Luther_King_Day"
       \ All pit markets closed.
       \ Halt these electronic collections:
         "W C S SM BO LC LH CC KC SB JO CT" words _holiday_close
      THEN
   end

   inline: Memorial_Day ( --- )
    \ Not open on Monday, May 26, 2014
      1140526 holiday
      IF " Memorial_Day"
       \ Halt these collections:
         "W C S SM BO LC LH CC KC SB JO CT" words _holiday_close
      THEN
   end

   inline: New_Years_Day ( --- )
    \ Not open on Wednesday, Jan 1, 2014
      1140101 holiday
      IF " New_Years_Day"
       \ Halt these collections:
         tracklist _holiday_close \ close all of them
      THEN
   end

   inline: Presidents_Day ( --- )
    \ Not open on Monday, Feb 17, 2014
      1140217 holiday
      IF " Presidents_Day"
       \ Halt these collections:
         "W C S SM BO LC LH CC KC SB JO CT" words _holiday_close
      THEN
   end

   inline: Thanksgiving_Day ( --- )
    \ Not open on Thursday, November 27, 2014
      1141127 holiday
      IF " Thanksgiving_Day"
       \ Halt these collections:
         "W C S SM BO LC LH CC KC SB JO CT" words _holiday_close
      THEN
   end

   pull catmsg

   Holidays

   halt \ end sourcing HOLIDAYS section
}
\-----------------------------------------------------------------------

\  Words for pit and electronic markets (January 2008).

\  Times are Central (Chicago) unless noted otherwise.

   inline: collect (qMkt --- hT) \ collect latest data for Mkt
      [ \ These default words are for collecting pit data:
          "bcDATA fsDATA inoDATA tcDATA" words "SITES" book
      ]
      push VOL tpurged SITES rows 1st
      DO peek SITES I quote main (hT)
         (hT) dup chars 5 >
         IF (hT) SITES I quote spaced nose pile
         ELSE (hT) drop " collect: no " SITES I quote + . nl
         THEN
      LOOP pull (qMkt) drop (hT)
   end

   inline: COLLECT_END ( --- ) \ end a collection session
\     End this session and set ALARM for COLLECT_START to start the
\     next one.

      "BONG" exists? IF 2 BONG dup remote_wavPlayq deleteif THEN

      SYSOUT push LOG-FILE set_sysout
      "-" 72 cats nl . nl
      " COLLECT_END: " date + . nl

      host collector
      IF NIST_DELTA
      ELSE
         NIST_SYNC 
       \ If this is Friday, allow the now-running NIST_SYNC alarm to
       \ run over the weekend; otherwise, turn it off:
         time GMT>LA ctime sysdate drop weekday 6 <>
         IF "NIST_SYNC" -ALARM THEN
      THEN
{
      Keeping WORKLOAD running during the week eliminates the 3 PM
      problem with SITE check, where the alarm sounds if the check
      is made right at 3 PM and both files WORK.LOG and COLLECT.LOG 
      haven't been updated (but are about to be) and are more than 
      15 minutes old:
}     time GMT>LA ctime sysdate drop weekday 6 =
      IF "WORKLOAD" -ALARM THEN \ only kill this on Friday

      "KILL_ePID" -ALARM KILL_ePID 
      KILL.V \ kill extraneous scripts that should have died

{     Times are Central (Chicago).

      Set the ALARM to start the next 23.75 hour collection session,  
      in about 15 minutes (if this is Friday, next start will be in
      about 48 hours at 15:00 on Sunday).

      Warning: If COLLECT_START begins before 15:00, collection ALARMs 
      will not be queued up; add a 30 second pad (machines on the web
      generally keep good time, but running NIST_SYNC over the weekend
      (see above) helps when they do not):
}     time soonest_start 30 (sec) + 30 max (d) "COLLECT_START" ALARM

{     If this is Friday, set pit end of day collection to be at 18:00
      for the pits that closed earlier today.  If this is not Friday, 
      then the pit end of day collection will be set by upcoming COL-
      LECT_START.
}     time GMT>LA ctime sysdate drop weekday 6 = 
      IF "18:00:00" >SEC (t2)
         time CHdiff + time_breakdown >SEC (t1) - (tPIT) dup 0>
         IF (tPIT) dup
            push (tPIT) "EOD-pCOLLECT" ALARM \ default

            host "fortycoupe" =
            IF peek (tPIT) 120 (sec) + "EOD-pCOLLECT" ALARM THEN

            host "topsdog" =
            IF peek (tPIT) 240 (sec) + "EOD-pCOLLECT" ALARM THEN
   
            host "rilefile" =
            IF peek (tPIT) 360 (sec) + "EOD-pCOLLECT" ALARM THEN

            pull (tPIT) drop
         ELSE (tPIT) drop \ time has past
            " COLLECT_END: time for pit end of day"
            " collection is past" + . nl
         THEN
      THEN
{
      Update con.dat for rollover changes.

      These phrases are also in COLLECT_START, in case it runs before
      this word--which is the case on Sunday start up.

      If there is a file con_update.dat and it has ++MKT differences
      from con.dat, copy con.dat to con.dat.bak and copy con_update.dat
      to con.dat:
}     mpath "con_update.dat" + file?
      IF mpath "con.dat" + "OLD" book
         mpath "con_update.dat" + "NEW" book

       \ Sun Apr  6 12:03:01 PDT 2014.  Perform the following diff1 test
       \ only if file con_update.dat (NEW) is newer than file con.dat 
       \ (OLD); newer con_update.dat is written by script /mdat/conupd
       \ when there are contracts to be rolled:
         NEW filetime OLD filetime >
drop yes \ NEW/OLD test is erroneous; skip it and find out why
         IF OLD NEW diff1 (hT) any?
            IF (hT) dup "++" grepr any?
               IF (hT hRows) reach (hT1)
                  " COLLECT_END: updates to " OLD + ":" + . nl
                  (hT) 5 indent . nl
                  "/bin/cp -p " OLD + spaced OLD ".bak" + + shell
                  "/bin/cp -p " NEW + spaced OLD + shell
                  " COLLECT_END: " NEW + " copied to " + . nl
                  "   " OLD + spaced date + . nl
               ELSE (hT) drop
               THEN
            THEN
         ELSE " COLLECT_END: con_update.dat is too old,"
              " update test skipped" + . nl
         THEN
      THEN

      hist_rm \ removing now means the LAN check works ok first time

    \ The log file can get to be more than 15 minutes old during the
    \ end-of-session interval, causing the SITE checker to sound an
    \ alarm.  Set an alarm to touch the log file in 10 minutes so it 
    \ does not get too old:
      time GMT>LA ctime sysdate drop weekday 6 <> \ not Friday
      IF 600 "LOG-TOUCH" ALARM THEN \ touch log file in 10 minutes

      tasks

      pull set_sysout
   end

   inline: COLLECT_MAKE (qMKT qTASK f --- ) \ make a collection word
{     This word makes a word called MKT-COLLECT to do collection for
      MKT using word TASK.  This word also sets the first ALARM to 
      start the collection for MKT according to its timeline.

      Incoming flag f is true if MKT is an open outcry (pit) market,
      and false if MKT is an electronic market.

      Collecting is done by word TASK with this stack diagram:
         TASK (qMKT --- )

      For open outcry markets, TASK is probably word COLLECT, and for 
      electronic markets it is probably word eCOLLECT.

      Enclosed below in {" ... "} is TEXT for the word being created.  

      It will be a word like like W-COLLECT or eSF-COLLECT, and have
      a stack diagram given by ( --- ) so it can be run in the multi-
      tasker either as a TASK or as an ALARM.

}     [ 
      {" MKT-COLLECT ( --- )
         [ \ begin bracket region for TEXT

         defname "NAME" book \ name of word being created

       \ This is the macro to start the collection job and schedule
       \ the next one; if market is electronic, also schedule a his-
       \ tory file update in about 30 seconds:
         "MKT (qMKT) pTASK exe "           \ start the collection
         "TMKT timeline soonest (nSec) " + \ get the next time
         "NAME ALARM " + (qS)              \ and set next ALARM

       \ Collection will be complete in less than 30 seconds.  
       \ Set an alarm to queue the history file update if electronic:
         (qS) "PIT not IF " +
         '30 NAME "qhist" localref ALARM ' + \ queue history update
         "THEN " + (qS)

         (qS) "QTASK" (hT qS) macro
{
         Queuing the history file update is done in the spirit of 
         using the queue to smooth out the effect of a number of 
         ALARMs going off at about the same time, since it is work-
         ing so well for the collection jobs.

         The history update runs very quickly, so queuing may not 
         be necessary; and queuing will delay the update by the 
         queuing period (about 5 seconds) times the number of jobs 
         in the queue (or about 2.5 seconds if no other jobs are 
         waiting).

         Also, having more jobs in the queue slows everything down
         a bit--which might not be so bad.
} 
       \ Below is the macro that queues the history file update by 
       \ adding to the queue a ptr to local word hist.  This macro
       \ is run on an ALARM set by word QTASK above:
            'NAME "hist" localref ptr queue_add1' "qhist" macro
{
         June 2009: use new queue_add1 in qhist above, to add to the
         queue only if not already in queue, so others can also queue 
         up hist by running something like:
            "eGC-COLLECT" "hist" localref ptr queue_add1
         and there never will be duplicates.
}
       \ This is the macro that gets queued and actually runs the 
       \ history file update:
            "MKT HIST_ADD" "hist" (hT qS) macro
{
         Why schedule a separate history file update with macro hist() 
         instead of having the collection job pTASK() run the update 
         when it finishes?  

         Because a collection job is not very reliable.  That's why it
         is run outside of this program with tserv, where it can fail
         with no consequence.  Several sites are visited, and any one 
         of them can cause the job to time out trying to connect or 
         waiting for data.

         Running a separate history update ensures that the collections
         that did finish (and therefore produced files) get counted as 
         soon as possible.

         Originally, the history update was run in this word just be-
         fore the next collection was queued, since the file of data 
         was about to be overwritten.  But that meant the history up-
         date was for the prior collection, probably more than 10 min-
         utes ago.  

         By queuing the history update 30 seconds after collection, 
         the history file is available much sooner for other jobs that 
         scoop up the collected histories. 

         Example operations from the log file (LOG-FILE):

         Queue electronic BP collection (word eBP-COLLECT):
            eBP-COLLECT eBP queued Tue Jan 22 10:18:17 PST 2008

         Run electronic BP collection (pTASK = ptr(eCOLLECT)):
            eCOLLECT: BP Tue Jan 22 10:18:22 PST 2008

         Queue and run pit BP collection happens to fall between
         running electronic BP collection and adding electronic
         BP to its history file:
            BP-COLLECT BP queued Tue Jan 22 10:18:35 PST 2008
            COLLECT: BP Tue Jan 22 10:18:36 PST 2008

         Add electronic BP to history file (at about 30 seconds 
         past 10:18:22, the time of electronic BP collection):
            hist_add: eBP Tue Jan 22 10:18:51 PST 2008

         This shows part of the multitasker task list.  The last entry 
         is the queuing system's queue_run(), running at 0.2 Hz to 
         queue a task every 5 seconds; and above that is a task to 
         queue the history update for word eLH-COLLECT(), with 11 sec-
         onds remaining on its 30 second ALARM (that job will run macro
         qhist(), defined above, as it exists in word eLH-COLLECT()):

            [tops@plunger] ready > tasks
             Multitasker tasks:
            ...
              eUS-COLLECT,0:CODE__ alarm period 3585.74 seconds; rem...
              eW-COLLECT,0:CODE__ alarm period 3585.84 seconds; rema...
              qhist,0:eLH-COLLECT alarm period 30 seconds; remaining 11
              queue_run,0:CODE__ task running at 0.2 Hz; tics remain...
            [tops@plunger] ready > 

}
         ] \ end bracket region of the collection word

       \ Begin phrases that run whenever the collection word runs.
{
       SKIP MAKING ENTRY IN LOG FILE.  THIS WAS GOOD FOR DEBUGGING,
       BUT NOW THE QUEUING SYSTEM IS WELL CHECKED OUT.
       \ Make an entry in the log file:
         SYSOUT push LOG-FILE set_sysout
            sp NAME spaced PIT IF MKT ELSE "e" MKT + THEN + 
            " queued " + date + . nl
         pull set_sysout
}
       \ Queue up another collection:
         NAME "QTASK" localref ptr queue_add 

      "} "TEXT" book \ text for word to be created (by word macro)
      ]

    \ These lines are run by this word, COLLECT_MAKE, to make a
    \ collection word based upon TEXT above:

      (f) "PIT" book
      (qTASK) "TASK" book
      (qMKT) strchop uppercase "MKT" book

    \ Name of word being made:
      PIT IF MKT ELSE "e" MKT + THEN "-COLLECT" + "WORD" book 

    \ Name of the timeline to use with MKT:
      MKT lowercase PIT IF "_pit" ELSE "_ele" THEN + "TMKT" book

      CATMSG (f) push no catmsg \ hide catalog message when make word

{     Make the new word from TEXT; it goes into the main library 
      because the macro is being made while this word runs, not 
      while this word is being created (in which case the macro 
      would go into its library):
}     TEXT WORD macro 

      pull (f) catmsg \ restore catalog message flag

    \ Bank values into the new word:
      MKT WORD "MKT"  bank       \ banking MKT name
      PIT WORD "PIT" bank        \ word knows if it is doing PIT
      TASK ptr WORD "pTASK" bank \ banking ptr to TASK word
      TMKT WORD "TMKT" bank      \ banking timeline name for MKT

    \ Set the first ALARM (this phrase is like the phrase in macro 
    \ QTASK above in new WORD, that sets ALARM to go again):
      TMKT timeline soonest WORD ALARM
{
      Below is the library of word eW-COLLECT, one of the words that 
      is created by this word.  It shows macro QTASK that gets queued
      up and pTASK (a ptr to word eCOLLECT) that runs to collect data
      (this library table will not reflect recent changes).
 
         [tops@plunger] ready > 'eW-COLLECT' wholib
          Stack items and words in the library of word eW-COLLECT:
           Name    Rows Cols Bytes Type  Description
           QTASK   13   1    52    PTR   inline
           "MKT"   1    3    5     STR   string
           "pTASK" 1    5    7     STR   string
           "QTASK" 1    5    7     STR   string
           "TMKT"  1    4    6     STR   string
           MKT     1    1    1     STR   string
           NAME    1    10   10    STR   string
           TMKT    1    5    5     STR   string
           pTASK   0    0    8     NUM   ptr->eCOLLECT
                             101   total
}
   end

   inline: COLLECT_START ( --- ) \ prepare for and start collections
\     Times are Central (Chicago).

      "BONG" exists? IF 2 BONG dup remote_wavPlayq deleteif THEN

      SYSOUT push LOG-FILE set_sysout
      "-" 72 cats nl . nl
      " COLLECT_START: " date + . nl

      "/tmp" chdir

    \ Start collections for the day:
{
      Update con.dat for rollover changes.

      NOTE: If topse must be restarted and con_update.dat should not
      be used until the next session, use argv -r when restarting:
         % topse -r

      If there is a file con_update.dat and it has ++MKT differences
      from con.dat, copy con.dat to con.dat.bak and copy con_update.dat
      to con.dat:
}     [ no "conskip" book ] 
      mpath "con_update.dat" + file?
      IF "-r" argv chars any, conskip no = and
         IF " COLLECT-START: this is a -r restart;"
            " skipping con.dat updates" + . nl

          \ Wed Dec  9 14:55:58 PST 2009
          \ If con.dat matches con_update.dat, revert to con.dat.bak
          \ for con.dat:
            mpath "con.dat" + mpath "con_update.dat" + diff1 chars 0=
            IF " COLLECT-START: reverting to con.dat.bak on -r restart" 
               . nl
               mpath "con.dat.bak" + mpath "con.dat" + fcopy 
            THEN

            yes "conskip" book \ do this only once

         ELSE mpath "con.dat" + "OLD" book
            mpath "con_update.dat" + "NEW" book
          \ Sun Apr  6 12:03:01 PDT 2014.  Perform the following diff1
          \ test only if file con_update.dat (NEW) is newer than file
          \ con.dat (OLD); newer con_update.dat is written by script
          \ /mdat/conupd when there are contracts to be rolled:
            NEW filetime OLD filetime >
drop yes \ NEW/OLD test is erroneous; skip it and find out why
            IF OLD NEW diff1 (hT) any?
               IF (hT) dup "++" grepr any?
                  IF (hT hRows) reach (hT1)
                     " COLLECT-START: updates to " OLD + ":" + . nl
                     (hT) 5 indent . nl
                     "/bin/cp -p " OLD + spaced OLD ".bak" + + shell
                     "/bin/cp -p " NEW + spaced OLD + shell
                     " COLLECT_START: " NEW + " copied to " + . nl
                     "   " OLD + spaced date + . nl
                  ELSE (hT) drop
                  THEN
               THEN
            ELSE " COLLECT_START: con_update.dat is too old,"
                 " update test skipped" + . nl
            THEN
         THEN
      THEN
 
      " COLLECT_START: starting WORKLOAD" . nl

      1.05 60 slash "WORKLOAD"  PLAY \ once a minute

      1.00 60 slash "KILL_ePID" PLAY \ once a minute
      " COLLECT_START: starting KILL_ePID" . nl

      "eCOLLECT" msgDel \ delete old eCOLLECT messages 
      "HIST_ADD" msgDel \ delete old HIST_ADD messages

    \ Fri Aug 12 09:06:52 PDT 2011.  A machine not on the web, like
    \ plunger, receives INO and TC data from machines that are on the 
    \ web, so it has no reason to collect such data itself:
      ontheweb not \ see word skipINO to override this default:
      IF "skipINO" msgGet drop "yes" "skipINO" msgPut THEN
      ontheweb not \ see word skipTC to override this default:
      IF "skipTC" msgGet drop "yes" "skipTC" msgPut THEN
 
    \ Load market timelines:
      usrpath "mget.v" + "#def TIMELINES" msource

      hist_rm

    \ List tracklist1 is a reduced list for collecting electronic:
      tracklist1 rows dup "nJOBS" book 1st
      DO tracklist1 I quote "eCOLLECT" false COLLECT_MAKE LOOP
      " COLLECT_START: making collection words done" . nl

\     Check holiday schedules:
      usrpath "mget.v" + "HOLIDAYS" msource \ run latest holiday words

      queue_clr

    { Calculation of queuing system rate:

         There are nJOBS collection jobs, each submitting two jobs to
         the queue every DT1 minutes (each collection job submits 
         another job to do its history file).

         The queuing system must release a job every
            (60*DT1)/(2*nJOBS) seconds 
         to maintain the period DT1, and the queuing system rate, or
         frequency, would be one divided by this period.

         Full: 34 rows in tracklist, DT = 11 minutes:
            Rate = 1/((60*11)/(2*34)) = 0.1030 Hz (1 job every 9.7 sec)
         This rate for full collection, 0.1030 Hz, works very well.

         Reduced: 11 rows in tracklist1, DT = 7 minutes:
            Rate = 1/((60*7)/(2*11)) = 0.0524 Hz (1 job every 19.1 sec) 
         Using the rate for reduced collection, about 8 jobs built up
         in the queue (verified on four machines running collections).
         The above assumes the collection jobs are submitted uniformly,
         which surely is not the case. 

         Switching to the higher full collection rate for reduced col-
         lection meant the queue was always empty.  The higher full col-
         lection rate will be used indefinitely since it works fine for
         full collection and should be fine for reduced collection since
         there are fewer total jobs, even accounting for the increased 
         duty cycle from 11 minutes to 7 minutes. 

         Fri Nov 13 10:04:13 PST 2009

         On plunger, data from tch members collection is being added
         every 90 seconds (from previous 180 seconds), for history pro-
         cessing.  Only on plunger, double the rate to .206 Hz.  

         Primarily, this speeds up history processing but should not 
         affect collection significantly since each market is on a 7 
         minute alarm.  There could be a problem if too many collection
         jobs get submitted at the higher rate, so the log and system
         load level should be watched initially.

         Mon Nov 16 06:57:11 PST 2009
         Data from tch members collection reverted back to every 180
         seconds, but the higher rate of .206 Hz is being kept.

   }    
    \ host "plunger" = \ Thu Jun 28 18:36:30 PDT 2012.  Not just
    \ plunger, but any LAN machine (a machine not on the web) that 
    \ collects:
      host collector
      IF 0.2060 ELSE 0.1030 THEN (rate) "queue_run" PLAY

      " COLLECT_START: queuing system started" . nl

    \ Set pit end of day collection for 18:00 for the pits that closed 
    \ earlier today:
      time GMT>LA ctime sysdate drop weekday push
      peek 0= peek 1 = or pull 6 = or not \ not Fri, Sat or Sun
      IF "18:00:00" >SEC (t2) 
         time CHdiff + time_breakdown >SEC (t1) - (tPIT) dup 0>
         IF (tPIT) dup 
            push (tPIT) "EOD-pCOLLECT" ALARM \ default

            host "fortycoupe" =
            IF peek (tPIT) 120 (sec) + "EOD-pCOLLECT" ALARM THEN

            host "topsdog" =
            IF peek (tPIT) 240 (sec) + "EOD-pCOLLECT" ALARM THEN

            host "rilefile" =
            IF peek (tPIT) 360 (sec) + "EOD-pCOLLECT" ALARM THEN

            pull (tPIT) drop
         ELSE (tPIT) drop \ time has past
            " COLLECT_START: time for pit end of day"
            " collection is past" + . nl
         THEN
      THEN

    \ Time tEOD is the time when the 15 minute end of day period begins,
    \ just before start up of the next session:
      time soonest_end dup (tEOD) push "COLLECT_END" ALARM
      " COLLECT_START: COLLECT_END ALARM set" . nl

    \ Set electronic end of day collection to be during the COLLECT_END
    \ period after this session ends:

{     March 18, 2009.  EOD electronic data for some markets has gotten
      lousy, like 0 for high and low perhaps because they are getting
      ready for the next session.  Run electronic EOD earlier, even if
      markets are still open, to get good data. 
}   \ peek (tEOD) 3600 - "EOD-eCOLLECT" ALARM \ tEOD one hour eariler

    \ Mon Sep 17 14:13:34 PDT 2012.  No LC dat.  Make that 1/2 hour
    \ earlier:
    \ peek (tEOD) 1800 - "EOD-eCOLLECT" ALARM \ tEOD 1/2 hour eariler

    \ Wed Sep 19 14:46:17 PDT 2012.  Still missing data.  Run at tEOD
    \ plus 60 seconds.  The problem about lousy data noted in March 18,
    \ 2009 appears to have gone away:
      peek (tEOD) 60 + "EOD-eCOLLECT" ALARM \ default

{     Fri Jun 22 14:45:01 PDT 2012.  EOD electronic data site has begun
      failing.  Switching to pit site just to get data does not fail and
      is fine for now.  But running earlier gets yesterday's data.  Re-
      move the one hour shift and see if today's data is obtained:
}   \ peek (tEOD) 60 + "EOD-eCOLLECT" ALARM \ default

{     Sun Sep 16 12:30:50 PDT 2012.  EOD electronic data site appears to
      be reliable again.  Revert to March 18, 2009 above.
}
      pull (tEOD) drop

      tasks

      pull set_sysout
   end

   inline: eCOLLECT (qMKT --- ) \ collect data
\     This word collects data by running another instance of the pro-
\     gram using file usr/tserv to run the following program script.

\     The program exits before SERVER in tserv is ever started.
      [
      {" Program script to be run (quoted MKT replaces STRING):

       \ Fetching data is limited to 15 seconds per site, and all col-
       \ lection must end before this script exits in 25 seconds.

         STRING chop "MKT" book
         "/tmp/" MKT + ".eLOG" + set_sysout
         "-" 72 cats . nl

         "msgPeek" missing IF "dog.v" source THEN

         "NIST_DELTA" msgPeek any? \ Tue Nov  9 18:24:59 PST 2010
         IF numerate @ (sec) dup "DELTA" book GMTdelta
            " eCOLLECT: time sync with NIST, " DELTA intstr +
            " sec, " + date + . nl
         THEN

         " eCOLLECT begin: " MKT + " PID " + getpid intstr spaced + 
         date + . nl

         MKT spaced date spaced + time intstr spaced + getpid intstr +
         "eCOLLECT" msgPut

         no catmsg "mget.v" source

         15 "HTTPget" "timeout" bank \ HTTPget limitation per site
         " HTTPget timeout per site (sec):" .
         "HTTPget" "timeout" yank .i nl

       \ Because this is always a job just started, the random seed
       \ is probably always the same.  This resets it based on time:
         seedt

         "HTTPget" urn 0.3333 >
         IF flip IF "netscapeUA" ELSE "msieUA" THEN
         ELSE "googleUA" 
         THEN yank "HTTPget" "UA" bank

         date " SESS " + SESSION intstr + "D" book

       \ Collect from sites.

         " eCOLLECT collecting: " date + . nl

         MKT skipTC (f)
         IF " eCOLLECT: " "skipping TC collection" + . nl
         ELSE time "t0" book
            "HTTPget" "msieUA" yank "HTTPget" "UA" bank
            MKT tcEDATA (hT) any?
            IF D swap pile "/tmp/" MKT "_TC.eDAT" + + save
            ELSE " eCOLLECT: no TC data" . nl
            THEN
            " Elapsed msec: " time t0 - 1000 * integer intstr + . nl
         THEN

         MKT skipINO (f) \ Mon Nov  8 19:57:40 PST 2010
         IF " eCOLLECT: " "skipping INO collection" + . nl
         ELSE time "t0" book
            MKT inoEDATA (hT) any?
            IF D swap pile "/tmp/" MKT "_IN.eDAT" + + save
            ELSE " eCOLLECT: no INO data" . nl
            THEN
            " Elapsed msec: " time t0 - 1000 * integer intstr + . nl
         THEN

{  Sunday, September 13, 2009: On FS, US Bonds have switched to pit,
   and are not coming up on Sunday.  Discontinue FS as unreliable.
         ontheweb not
         IF time "t0" book
            MKT fsDATA (hT) any?
            IF D swap pile "/tmp/" MKT "_FS.eDAT" + + save
            ELSE " eCOLLECT: no FS data" . nl
            THEN
            " Elapsed msec: " time t0 - 1000 * integer intstr + . nl
         THEN
}
         "/tmp/" MKT ".eV" + + deleteif
         " eCOLLECT end: " . MKT . sp date . nl
         exit \ using tserv script, but exiting before SERVER start

      "} chop noblanklines "SCRIPT" book

    \ Wed Nov 10 12:51:26 PST 2010.  Double this time for CL on plunger
    \ due to new large file from ino.com (they mindlessly added spreads
    \ without considering N-squared--see ino.v) and because home DSL is
    \ about 6 times slower than the web machines:
      25 "tEXIT" book 

      ]
    \ Mon Sep 19 12:55:20 PDT 2011.  Collection on machine plunger is
    \ not being done, as it has become a receiver of data collected from
    \ Windows machine solano and Linux machine riggo, which transfer
    \ arrays to this program's stack to be placed on history files.

    \ Skip this word for machine plunger;
    \ (Thu Jun 28 18:36:30 PDT 2012) and other LAN machines (like diego)
    \ that receive collected data:
      host collector IF (qMKT) drop return THEN
    
      SYSOUT push LOG-FILE set_sysout
      (qMKT) uppercase "mkt" book

    \ Line to log file:
      " eCOLLECT: " mkt + " queue_len: " + queue_len intstr + spaced
      date + . nl

    \ Name of script file:
      "/tmp/" mkt ".eV" + + "Fname" book \ script file deletes itself

      SCRIPT (qS) "STRING" mkt quoted replace$ (qS)
      (qS) "SESSION" 
      time tsession - 0.5 + integer intstr \ GMT when session started
      (qS) strp (qS) Fname save

      usrpath "tserv" catpath
    \ Thu Jun 28 18:36:30 PDT 2012.  Replace 'host "plunger"' with
    \ 'host collector:'
      " -exit " tEXIT mkt "CL" = host collector and
      IF 2 * THEN (tEXIT) intstr + +
      " -source " Fname + + \ exit time, file to source
      " &" + (qS) shell

      pull set_sysout
   end

   inline: ecollect (qMkt --- hT) \ collect electronic market data
      [ "inoEDATA tcEDATA" words "ESITES" book ]
      "collect" "SITES" yank push ESITES "collect" "SITES" bank
      (qMkt) collect (hT) 
      pull "collect" "SITES" bank

      (hT) "inoEDATA" "IN" strp "tcEDATA" "TC" strp (hT)
      (hT) "_ecollect" naming
   end

   inline: ecollect_r (qMkt --- hT) \ collect electronic market data
    \ Runs TASK_PORT to make a remote server do the dirty work.
      [ 60 "WAIT" book ]
      WAIT "'mget.v' source " rot quoted + " ecollect" + TASK_PORT
      (hT) "_ecollect_r" naming
   end

   inline: elec_now (qMkt --- hT) \ current electronic data for Mkt
      SYSOUT push 
      ftempsys dup set_sysout (qFile)

      swap (qFile qMkt)
      "_now" "PIT" yank push no "_now" "PIT" bank
      (qMkt) _now (hT) "_elec_now" naming
      pull "_now" "PIT" bank

      pull set_sysout     \ restore SYSOUT
      swap (qFile) delete \ delete temp file
   end

   inline: elec_times ( --- hA) \ electronic collection times
      no 1 null tracklist rows 1st
      DO tracklist I quote strchop "_ele" + lowercase timeline pile
      LOOP yes sort
   end

   inline: HIST_ADD (qMKT --- ) \ append latest data to MKT hist file
{     This word appends data to the history file of MKT by running 
      another instance of the program using file usr/tserv to run 
      the following program script that runs hist_add().

      Word hist_add() and some related ones are written in infix, and 
      errors in infix words cause word HALT() to be run.  Running word
      HALT() causes the queuing system to stop.  ALARMS already queued
      will run, but when there are no more the collection program just 
      sits.

      Running hist_add() separately with tserv avoids stopping the
      collection because of errors in hist_add().  Error output can 
      be seen in the log file that this script saves, so they can be 
      fixed offline while the collection continues.

      Using this word instead of hist_add() was as simple as changing

            "MKT hist_add" "hist" (hT qS) macro
      to
            "MKT HIST_ADD" "hist" (hT qS) macro

      in word COLLECT_MAKE().
}
      [
      {" Program script to be run (quoted MKT replaces STRING):

         STRING "MKT" book
         no catmsg

         "/tmp/" MKT + ".hLOG" + set_sysout
         "-" 72 cats . nl

         "msgPeek" missing IF "dog.v" source THEN

         " HIST_ADD begin: " . 
         MKT spaced date spaced +
         time intstr spaced + getpid intstr + (hM) dup . nl

         (hM) "HIST_ADD" msgPut

         "mget.v" source

         MKT hist_add

         "/tmp/" MKT + ".hV" + deleteif

         " HIST_ADD end: " . MKT . sp date . nl

         exit \ using tserv script, but exiting before SERVER start

      "} chop noblanklines "SCRIPT" book
      ]
      SYSOUT push LOG-FILE set_sysout
      (qMKT) uppercase "mkt" book

    \ Line to log file:
      " HIST_ADD: " mkt + " queue_len: " + queue_len intstr + spaced
      date + . nl

    \ Make the script to run (it will delete itself):
      "/tmp/" mkt ".hV" + + "Fname" book

      SCRIPT (qS) "STRING" mkt strchop quoted replace$ (qS)
      (qS) Fname save

      usrpath "tserv" catpath
      " -exit 15 -source " Fname + + \ exit time, file to source
      " &" + (qS) shell

      pull set_sysout
   end

{"
   function hist_add(MKT1) /* append latest data to MKT history file.*/
   /* History files contain electronic data. */
   {
      { q_t = 10; // field in data for the time of quote 
        LATEST = 10; // latest steps to process

        FILE_TEMPLATE = ["/tmp/" + "MKT" + "_CME1.eDAT";// real time CME
                         "/tmp/" + "MKT" + "_CME.eDAT"; // delayed CME
                         "/tmp/" + "MKT" + "_TC1.eDAT"; // delayed
                         "/tmp/" + "MKT" + "_IN.eDAT"]; // most delayed

                    //   "/tmp/" + "MKT" + "_MFG.eDAT"];

        BIN = no;
      }
      MKT = uppercase(MKT1);
      SYM = MKT + MOdo(MKT); // like PLJ08
      ERCNT = ercnt;

      << " hist_add: " SYM + spaced date + . nl >>

   /* Read data from the files saved by word eCOLLECT for MKT: */
      FILE = strp(FILE_TEMPLATE, "MKT", MKT);

      F = file?(FILE);
      if(!totals(F)) return; // return if no files

      D = tpurged(VOL);
      G = null(0, 1);
      
      DO(rows(FILE), 1);
         if(F[I]) (T = asciiload(FILE[I]));
         else T = tpurged(VOL);

         IF(rows(T))
            R = grepr(T, SYM);

            IF(rows(R))
            /* Data in rows R: */

            /* Mon Jun 18 06:38:41 PDT 2012.  Process LATEST rows: */
               d = endmost(reach(T, R), min(LATEST, rows(R))); 

            /* Mon Jun 18 06:52:52 PDT 2012.  Remove lines that do not
               have q_t words: */
            << d q_t word (0 or hw -1)
               IF (hw) strlen "R" book \ R=0 at lines without q_t words
                  d R rake lop (hd)
               ELSE VOL tpurged (hd)
               THEN (hd) "d" book
            >>
               IF(rows(d)>0)
               // Time of quotes in field q_t (LA times like 23:31:00):
                  tLA = (<< d q_t word drop >>);

               /* Compute GMT of quotes: */
                  (g, Z) = hist_gmt(T[1], tLA); // Z is session start
                  IF(!rows(g))
                     d = tpurged(VOL);
                     g = null(0, 1);
                  THEN;
               ELSE 
                  d = tpurged(VOL);
                  g = null(0, 1);
               THEN;
            ELSE 
               d = tpurged(VOL);
               g = null(0, 1);
            THEN;

         ELSE 
            d = tpurged(VOL);
            g = null(0, 1);
         THEN;

      /* Session start GMT, Z, is the same in any loop */
         D = pile(D, d); // VOL of data 
         G = pile(G, g); // MAT column of GMT numbers
      LOOP;
      if(!rows(G)) return;

   /* R(i) is true if time G(i) is in the future or if G(i) is before
      the session began at time Z: */
      R = [(G > fill(time, rows(G), 1)) || (G < fill(Z, rows(G), 1))];

      G = (<< G R rake drop >>);
      if(!rows(G)) return; // all times are future or past

      D = (<< D R rake drop >>);

   /* Fetch numerical data from fields of D and append G (GMT), to 
      make output matrix D: */
/* 
      From bch.v, this is the order of things from way back when:

         "Showing: Open High Low Settle Close Chg Vol OpenInt"
      
      and here is some code showing that close follows settle and is
      preceded with character c:
            peek 4 ndx quote SCALE       \ open
            peek 5 ndx quote SCALE       \ high
            peek 6 ndx quote SCALE       \ low
            peek 2 ndx quote SCALE       \ settle
            "c" over cat hand            \ close

       So here, grab the fifth item (actually the sixth because open
       is the second item) and expect that collectors place the settle
       fourth and the close fifth as above.

       Tue Nov 29 07:34:12 PST 2011.  Volume (electronic), Open In-
       terest (electronic) and Previous Settle (pit) are being added 
       to returned D.  These items are only available on CME1.eDAT 
       files of real time data (CME1.eDAT files are made by cme1.v).

       Here is some typical data in D at this point.  The first two rows
       are from GC_CME1.eDAT, and the last two are from GC_TC1.eDAT that
       does not collect volume or open interest (and settle is just the
       last price; only CME and CME1 get the settle right):

           stack elements:
                 0 volume: D  4 by 80
           [1] ok!
          [tops@plunger] ready > dup .m
                Open  High  Low   Settle Last Chg Vol   Op Int Time
          GCG12 17153 17217 17072 17145 c17196 51 89651 229531 07:40:49
          GCG12 17153 17217 17072 17145 c17192 47 89905 229531 07:41:50
          GCG12 17153 17217 17072 17196 c17196 51 ----- -----  07:28:00
          GCG12 17153 17217 17072 17204 c17204 59 ----- -----  07:31:00
*/
   <<
    \ After November 29, 2011, D will have 9 columns instead of 6:
      MKT hist_fname "_" chblank 1st string drop number drop 1111130 <
      IF 6 ELSE 9 THEN "Dcols" book
   >>

   // Tue Nov 29 07:34:12 PST 2011.  Adding Vol, Op Int and Settle to D:
      D = (<< \ nine columns: O, H, L, C, Chg, Vol, Op Int, Settle, GMT
         D 2 word drop numerate             \ Open
         D 3 word drop numerate             \ High
         D 4 word drop numerate             \ Low
         D 6 word drop "c" chblank numerate \ Last
         D 7 word drop numerate             \ Chg
 
         Dcols 9 = 
         IF D 8 word drop numbers (hA)      \ Vol (----- becomes inf)
               dup INF = "R" book (hA) R rake 
               (hA hInf) dims null R tier   \ replace inf with 0

            D 9 word drop numbers           \ Op Int (----- becomes inf)
            dup INF = "R" book (hA) R rake 
            (hA hInf) dims null R tier      \ replace inf with 0

            D 5 word drop numerate          \ Settle
         THEN
         G                                  \ GMT always last
         Dcols parkn >>); 

   /* From CME, G is machine time in seconds to the nearest second; 
      from other sources, G is machine time to the nearest minute.

      Sorting rows when there are duplicates in sort vector G means
      that sometimes rows at equal G values will be exchanged and 
      other times they will not, as the length of G changes with 
      time.  For this reason, returned D is no longer sorted in the
      expression above, and handling duplicate times is posponed
      until data from collected files is gathered on the analysis
      machine. */

    /* Remove identical rows from D (G is used for dummy): */
      (G, R) = noq_alike1(itext(D));
      (G, D) = rake(D, R);
      G = purged;

   /* Append the latest matrix D to the history file.  

      The number of rows of D varies, but D always has nine columns  
      (files earlier than 11-30-2011 have six columns).  Therefore, 
      D will be written by rows to make it easy to read later.  

      Matrices are stored in the program by columns, meaning that
      adjacent terms are in the same column.  To write D by rows, 
      take its transpose before writing.  Then adjacent terms writ-
      ten will be in the same row. 

      Since adjacent terms from the file will be in the same row,
      word matrix() is used later to make D again.  An example is 
      given below. */

   << 
      " hist_add: adding matrix D: " . nl 
      D 1 endmost itext neat 4 indent .m nl 
   >>


   /* June 2009.  Collecting often can produce too many duplicate re-
      cords and the history file can become three times bigger than it
      needs to be.

      Read the matrix from the history file, append D to it and take 
      only the first of rows with duplicate times.  This is what the 
      program that reads this data does (see hget1() in mfil.v), so 
      that task has simply been moved to here.

      By removing rows that are duplicates on time, the fact that other
      data in the rows may be different is being ignored.  But there
      really is no way to choose between two rows that quote different 
      prices but claim the same time of quote.

      After removing rows with duplicate times, write the entire matrix
      to the file. */

   << BIN filetrue IF BIN fclose THEN

      epath0 MKT hist_fname + "FILE_OUT" book

      FILE_OUT file?
      IF FILE_OUT (qFile) old binary "BIN" file

{        Wed Dec  7 11:20:03 PST 2011.  With real time data being col-
         lected every minute, there appears to be a problem deleting
         FILE_OUT before the new one is written.  Electronic consoles
         trying to read the file are finding it missing.

         Do not delete FILE_OUT before writing new file.  Rewind BIN 
         so new data will start at the beginning of the existing file.
         Since the new file is always longer, there will be no garbage 
         bytes at the end.

         But do not rely on the file getting longer.  Always write a 
         trailer to FILE_OUT that is the proper data length in bytes.
         When the file is read in hget1() (file mfile.v), the trailer
         should be read to ensure the proper number of bytes are read.
}
         BIN dup dup fsize 4 - fseek 
         (nBIN) 4 fget PDP_ENDIAN import4 @ (nSize)

         (nSize) BIN rewind BIN swap fget (hT)
         (hT) PDP_ENDIAN import4 (hA)

         (hA) dup rows Dcols / matrix (hA) \ a matrix with Dcols columns
         D (hA hD) pile 

         dup Dcols ndx catch swap park nodupes \ time in col 1 to sort

         2nd Dcols items catch (hD)

      ELSE FILE_OUT (qFile) new binary "BIN" file D (hD)
      THEN (hD)

      ERCNT ercnt =
      IF (hD) bend (hD') PDP_ENDIAN export4 (hT) dup sizeof (nSize) swap
         (hT) BIN rewind (hT) BIN fput

         BIN dup fsize fseek              \ position file pointer to end
         (nSize) PDP_ENDIAN export4 BIN fput \ write size trailer

      ELSE (hD) drop
       \ Tue Mar 27 18:23:02 PDT 2012.  Do not write file if change in
       \ ercnt is not zero, and write error message to logs:

         " hist_add: ercnt has changed; file " FILE_OUT + 
         " not written" + "MSG" book

       \ Write locally:
         MSG . nl 

       \ Write to log file:
         SYSOUT push LOG-FILE set_sysout MSG . nl pull set_sysout
      THEN

      BIN fclose (hA)
   >>
      shell("touch " + epath0); // change time for dir watchers

   /* Here is the old way:

      This appends to the file, but in doing that a lot of duplicates
      may be saved: 
      file(binary, forn(epath0 + hist_fname(MKT)), "BIN");
      fseek(BIN, fsize(BIN));
      fput(export4(D', PDP_ENDIAN), BIN); // write four byte ints
      fclose(BIN); */
/*
   /* How to read a history file and make six-column matrix D (file
      mfil.v has word hget() that reads a history file). */

   /* Read file and convert back to IEEE floating point numbers: */
      file(binary, old(NFILE), "BIN");
      D = import4(fget(BIN, fsize(BIN)), PDP_ENDIAN);
      fclose(BIN);

   /* The number of rows of D after running matrix() will be the number 
      of time points in the history: */
      D = matrix(D, rows(D)/6);
*/
   }
"} eval

   inline: hist_gmt (hT hLA --- hGMT nZ0) \ LA time into machine time
{     This function converts times of quotes, given as LA local, into
      GMT (what is being called GMT is not the time in Greenwich, Eng-
      land, but is related to machine seconds, and is the the number of
      seconds since midnight, January 1, 1970 in Greenwich, England to 
      the time of the quote).

      Quote times are the times stated in the collected data, not to
      be confused with collection times which must occur later, after
      the quotes have been made.

      Incoming T holds SESS that is the GMT (machine time) when the
      market session started.  Here is a typical T string:

         Fri Jan 18 11:41:04 PST 2008 SESS 1200858064

      and incoming LA is a vector of LA times when the quote was made,
      with each row string like 09:41:00.
}
      0 "Z0" book

      swap (hT) any?
      IF 1st quote "SESS" tug numerate any?
         IF @ "Z0" book ELSE (hLA) drop purged 0 return THEN
      ELSE (hLA) drop purged 0 return 
      THEN

      (hLA) dup rows 0> not 
      Z0 0> not or
      IF (hLA) drop purged 0 return THEN

      (hLA) >SEC 7200 + dup 86400 >= 86400 * + >OCLOCK (hCH)
      (hCH) dup rows 0> not IF drop purged Z0 return THEN (hCH)

      (hCH) push
      list: peek rows 1st
         DO peek I quote tline_sec Z0 + LOOP \ adding Z0 gives quote GMT
      end pull drop (hGMT) Z0
   end

{ The postfix version of hist_gmt() above is used, and not this infix 
  version.  The postfix version has more tests on incoming stack items,
  and when it fails it does not run HALT() like all infix functions do.
{"
   function (GMT, Z0) = hist_gmt(T, LA) { // GMT of quote times
   /* This function converts times of quotes, given as LA local, into 
      GMT (what is being called GMT is related to machine seconds, and
      is the the number of seconds since midnight, January 1, 1970 in 
      Greenwich, England to the time of the quote).  

      Quote times are the times stated in the collected data, not to 
      be confused with collection times which always occur later.

      Incoming T holds SESS that is the GMT (machine time) when the 
      market session started.  Here is a typical T string:

         Fri Jan 18 11:41:04 PST 2008 SESS 1200858064

      and incoming LA is a vector of LA times when the quote was made,
      with each row string like 09:41:00. */

   /* Fetch session start GMT (machine time) from SESS in T: */
      Z0 = @numerate(tug(T, "SESS"))[1,1];

   /* Convert LA time of quote to Chicago time (example: 23:31:00 in
      LA is 01:31:00 in Chicago): */
      CH = (<< LA >SEC 7200 + dup 86400 >= 86400 * + >OCLOCK >>);
   /* The phrase above uses >= flags of 0 and -1 to multiply 86400
      and get the offset that is added to the vector on the stack. */

      if(!rows(CH)) return(purged(), Z0);

   /* Function tline_sec() converts Chicago times, like 01:31:00, into
      seconds relative to the session start: */
      DO(rows(CH), 1) GMT[I] = tline_sec(quote(CH, I)); LOOP;

   /* Adding session start GMT to session seconds gives the GMT of
      the quote (i.e., the machine time of the quote): */
      GMT = Z0 + GMT;
   }
"} eval 
}
   inline: hist_rm ( --- ) \ remove old history files at session start
      [ "hist_add" "FILE_TEMPLATE" yank "FILE_TEMPLATE" book ]

\     Cleaning up /tmp.

\     Remove old collected electronic files.
\     Names are like /tmp/NQ_IN.eDAT and /tmp/CL_TC.eDAT.
      VOL tpurged tracklist rows 1st
      DO FILE_TEMPLATE "MKT" tracklist I quote
         strchop uppercase strp pile
      LOOP

      (hFileNames) dup file? rake lop any?
      IF (hFileNames) host collector
         IF (hFileNames) dup

          \ Sun Jun 17 10:56:14 PDT 2012.  On collector (like plunger
          \ and diego (Thu Jun 28 18:36:30 PDT 2012)), first create tar
          \ file archive in /tmp1 and then delete the files; the archive
          \ has a name with date like /tmp1/collection_1120618.tgz.

            (hFileNames) dup -path (hList) swap
            (hFileNames) 1st quote -filename (qDir) \ take Dir from 1st
            (hList qDir) "/tmp1/collection_" date sysdate drop intstr +
            (qF) ".tgz" + (hList qDir qFile) ctar
         THEN 
         (hFileNames) dup rows 1st DO dup I quote deleteif LOOP drop
      THEN

\     Remove LOG files:
      "/bin/rm /tmp/*eLOG" shell
      "/bin/rm /tmp/*hLOG" shell
   end

   inline: _now (qMkt --- hT) \ current data for Mkt
      [ yes "PIT" book list: 2 3 4 5 7 8 11 ; ndx "KEEP" book ]

      dup PIT IF pcollect ELSE ecollect THEN any?
      IF swap (qMkt) LATEST1 any? \ return just the line for latest
         IF 1st word drop over swap grepr reach (hT) "T0" book

          { The following is taken from word SUMMARY_REDUCE(), to
            extract just the line with the latest time:

            Times of data in word 11 are LA time.  Pick the row with
            the latest time not greater than current LA time (yester-
            day's times will be greater):
          } T0 11 ndx word drop >SEC
            this LAdate 4th word drop >SEC those rows repeat <
            abs *by bend max1 (hM)
            this 1st pry 0= \ are all times greater?
            IF (hM) drop VOL tpurged (hT) \ no data
            ELSE 2nd pry (row) \ 2nd gives row of max
               T0 swap (row) reach (hT)
            THEN dup (hT) chars any
            IF (hT) "T" book
               depth push \ keep just the items in list KEEP
               KEEP rows 1st
               DO T KEEP I pry word IF spaced THEN LOOP
               depth pull less parkn
               (hT) chop spaced T 1st word drop park
            ELSE (hT) drop VOL tpurged
            THEN
         ELSE VOL tpurged
         THEN
      ELSE (qMkt) drop VOL tpurged
      THEN
   end

   inline: pcollect (qMkt --- hT) \ collect market pit data
      [ "bcDATA fsDATA inoDATA tcDATA" words "PSITES" book ]
      "collect" "SITES" yank push PSITES "collect" "SITES" bank
      (qMkt) collect (hT) "_pcollect" naming
      pull "collect" "SITES" bank
   end

   inline: pcollect_r (qMkt --- hT) \ collect market pit data
    \ Runs TASK_PORT to make a remote server do the dirty work.
      [ 60 "WAIT" book ]
      WAIT "'mget.v' source " rot quoted + " pcollect" + TASK_PORT
      (hT) "_pcollect_r" naming
   end

   inline: pidtable_tops ( --- hT) \ table of process ids and commands
\     Entries in pidtable that contain string "tops."
      [ os "linux" =
        IF SBIN "ps -Af --cols 512 | grep tops >"
        ELSE SBIN "ps -Af | grep tops >"
        THEN + "PS" book
      ] PS scratch + minshell
      scratch asciiload scratch delete notrailing
      "_pidtable_tops" naming
   end

   inline: pit_now (qMkt --- hT) \ current pit data for Mkt
      SYSOUT push
      ftempsys dup set_sysout (qFile)

      swap (qFile qMkt)
      "_now" "PIT" yank push yes "_now" "PIT" bank
      (qMkt) _now (hT) "_pit_now" naming
      pull "_now" "PIT" bank

      pull set_sysout     \ restore SYSOUT
      swap (qFile) delete \ delete temp file
   end

   inline: pit_times ( --- hA) \ pit collection times
      no 1 null tracklist rows 1st
      DO tracklist I quote strchop "_pit" + lowercase timeline pile
      LOOP yes sort 
   end

   inline: skipINO (qMKT --- f) \ flag true to skip INO collection
      \ Mon Nov  8 19:57:40 PST 2010
      [
      { Use the interprocess message file to limit INO collection.

        The default is skipINO = no.  Unless there is a message skipINO
        that equals yes, INO collection will not be skipped.

        To skip INO collection in word eCOLLECT, run the following:

           [dale@plunger] /home/dale > tops
                    Tops 3.2.0
           Mon Nov  8 19:37:38 PST 2010
           [tops@plunger] ready > "skipINO" msgGet drop \
                                  "yes" "skipINO" msgPut

        Run the following to have word eCOLLECT start INO collection:

           [tops@plunger] ready > "skipINO" msgGet drop \
                                  "no" "skipINO" msgPut
      }
      ]
      "skipINO" msgPeek any? IF (qM) main (f) ELSE no THEN (f)
      (f) IF (qMKT) drop yes return THEN

      (qMKT) drop no return
   end

   inline: skipTC (qMKT --- f) \ flag true to skip TC collection
      [ 
      { Use the interprocess message file to limit TC collection to 
        times when member's TC data from diego is not available.

        The default is skipTC = yes.

        To start TC collection in word eCOLLECT, run the following:

           [dale@plunger] /home/dale > tops
                    Tops 3.2.0
           Sun May 30 18:50:45 PDT 2010
           [tops@plunger] ready > "skipTC" msgGet drop \
                                  "no" "skipTC" msgPut

        Run the following to have word eCOLLECT skip TC collection:

           [tops@plunger] ready > "skipTC" msgGet drop \
                                  "yes" "skipTC" msgPut
      }
      ]
      ontheweb \ web IPs are on the blacklist; always skip 
      IF (qMKT) drop yes return THEN 

      "skipTC" msgPeek any?
      IF main ELSE yes THEN (f)
      (f) IF (qMKT) drop yes return THEN

      lowercase push
      0
    \ Uncomment markets to do if skipTC equals no:
    \ peek "eu" = or
    \ peek "jy" = or
    \ peek "sf" = or
    \ peek "dj" = or
    \ peek "sp" = or
    \ peek "nq" = or
    \ peek "hg" = or
    \ peek "cl" = or
      peek "gc" = or
    \ peek "us" = or
    \ peek "tn" = or
      (f)
      IF no ELSE yes THEN (f)
      pull drop 
   end

   inline: soonest (hTimes -- nSec) \ next alarm is at nSec from now
{     Incoming Times is a column vector containing times within the 
      program's market trading timeline (see word timeline()).

      Returned number nSec is the number of seconds from now to the 
      soonest entry in Times.  Number nSec is never more than the      
      number of seconds in one day since the trading timeline is not
      longer than one day (it is about 23 hours long).

      Returns -1 if the current time is beyond any of Times.

      Future time offset, nSec from right now, is valid right now in
      any time zone (for traders all over the globe).

      Assumes Times are in ascending order.

      Time NOT_BEFORE is used to avoid immediate requeuing; see note
      in Appendix, "Testing shows the need for a little balancing."
}     
      [ 30 (seconds) "NOT_BEFORE" book, -1 "closed" book ]

      (hTimes) \ incoming list of times today for alarms
      tsession \ session seconds elapsed so far today (i.e., up to now)

    \ Look at future times that are NOT_BEFORE:
      (hTimes sec) less (hDt) these NOT_BEFORE > rake lop (hAsec)

      (hAsec) any?
      IF 1st pry  \ fetch the earliest time 
      ELSE closed \ no more to do today
      THEN
   end

\  File mfil.v and mobius.n use the following set of timeline words, 
\  and source them with msource1 looking for the following phrase:
#def timeline

   inline: soonest_task ( --- f) \ true to do COLLECT_START
{     Deciding to do COLLECT_START or COLLECT_END when beginning a
      collection script.

      Tue Nov 27 11:15:56 PST 2012.  Latest market end is 16:15, not
      16:30, on all days and not just Friday.  Revise expressions for
      Monday, Tuesday, Wednesday, Thursday.

      Times are Central (Chicago).

      The next task is COLLECT_END if
         today is one of the days Monday through Thursday and time is 
            between 16:30 and 17:00;
         today is Friday after 16:15;
         today is Saturday;
         today is Sunday before 17:00.

      Otherwise, the next task is COLLECT_START, probably to resume a 
      collection unexpectedly interrupted.

      Wed Dec  7 20:35:05 PST 2011.  Latest market end is 16:30.  Now
      that data is real time and not delayed, remove the 15 minute
      cushion and change all 16:45 to 16:30.  But on Friday, the latest
      market end is 16:15, so set Friday accordingly.
}
      [ no "END" book yes "START" book ]

      time (sec) CHdiff + gmtime (nsec) \ machine time in Chicago
      sysdate (nYYYMMDD nHHMMSS)
      (nHHMMSS) clocko >SEC "SEC" book
      (nYYYMMDD) weekday "DAY" book

    \ Friday:
      DAY 6 = IF SEC "16:15:00" >SEC >
                 IF END ELSE START THEN return
              THEN
    \ Saturday:
      DAY 0 = IF END return THEN

    \ Sunday:
      DAY 1 = IF SEC "17:00:00" >SEC <
                 IF END ELSE START THEN return
              THEN

    \ Monday, Tuesday, Wednesday, Thursday:
      SEC "16:15:00" >SEC "17:00:00" >SEC within
      IF END ELSE START THEN
   end

   inline: soonest_taskd (nD --- f) \ delayed true to do COLLECT_START
{     Thu Sep 22 15:11:51 PDT 2011
      Deciding to do COLLECT_START or COLLECT_END when beginning a
      collection script.

      Tue Nov 27 11:15:56 PST 2012.  Latest market end is 16:15, not
      16:30, on all days and not just Friday.  Revise expressions for
      Monday, Tuesday, Wednesday, Thursday.

      Incoming D is number of seconds to delay doing COLLECT_START.

      Delay D is used by watchdogs to give collecting a chance to
      start before testing alarm.  See ALARMcme in usr/uboot.v.

      Times are Central (Chicago).

      The next task is COLLECT_END if
         today is one of the days Monday through Thursday and time is 
            between 16:30 and 17:00 + D;
         today is Friday after 16:15;
         today is Saturday;
         today is Sunday before 17:00 + D.

      Otherwise, the next task is COLLECT_START, probably to resume a 
      collection unexpectedly interrupted.

      Wed Dec  7 20:35:05 PST 2011.  Latest market end is 16:30.  Now
      that data is real time and not delayed, remove the 15 minute
      cushion and change all 16:45 to 16:30.  But on Friday, the latest
      market end is 16:15, so set Friday accordingly.
}
      [ no "END" book yes "START" book ]

      (nD) "D" book

      time (sec) CHdiff + gmtime (nsec) \ machine time in Chicago
      sysdate (nYYYMMDD nHHMMSS)
      (nHHMMSS) clocko >SEC "SEC" book
      (nYYYMMDD) weekday "DAY" book

    \ Friday:
      DAY 6 = IF SEC "16:15:00" >SEC >
                 IF END ELSE START THEN return
              THEN
    \ Saturday:
      DAY 0 = IF END return THEN

    \ Sunday:
      DAY 1 = IF SEC "17:00:00" >SEC D + <
                 IF END ELSE START THEN return
              THEN

    \ Monday, Tuesday, Wednesday, Thursday:
      SEC "16:15:00" >SEC "17:00:00" >SEC D + within
      IF END ELSE START THEN
   end

   inline: timeline (qS --- hTimes) \ return timeline times for S
{     The library of this word contains lists of timeline times
      stored by word timeline_add().  

      For incoming S, the vector of Times called S is returned; name 
      S looks like c_pit or gc_ele (see library listing below).

      Returned Times is purged if there is no S in the library.

}     dup local?
      IF (qS) local      \ put local library item on the stack
      ELSE drop 0 1 null \ no such S (has 1 column for piling)
      THEN
   end

   inline: timeline_add (qS hA --- ) \ add timeline A called S
{     Store vector A named S into the library of word timeline.

      Timeline A is later fetched by running:
         S timeline (hA)
      or
         A = timeline(S);

      To see the library of timelines (this shows some of them; 
      there are over sixty):
         [tops@plunger] ready > "timeline" wholib
          Stack items in the library of word timeline:
           bo_ele 93   1    744   MAT   dense
           bo_pit 24   1    192   MAT   dense
           c_ele  93   1    744   MAT   dense
           c_pit  24   1    192   MAT   dense
           s_ele  93   1    744   MAT   dense
           s_pit  24   1    192   MAT   dense
           sm_ele 93   1    744   MAT   dense
           sm_pit 24   1    192   MAT   dense
           w_ele  93   1    744   MAT   dense
           w_pit  24   1    192   MAT   dense
                            4680  total
}
      (hA)
    \ Offsets on machines to avoid hitting sites at the same time:

    \ For 4 machines, space between machines is:
      "DT1" main 60 * 4 / "DM" book

    \ No offset for fortycoupe
      0
      host "topsdog"  = IF drop DM     THEN
      host "rilefile" = IF drop DM 2 * THEN
      host "plunger"  = IF drop DM 3 * THEN
      "OFFSET" book

      (hA) OFFSET + (hA)

      yes sort (hA) \ times in ascending order
      (hA) nodupes  \ no duplicates

    \ No time larger than TMAX minus 60 seconds:
      (hA) dup 0> over "tline" "TMAX" yank 60 - < and rake lop

      (qS hA) "timeline" rot (hA qW qS) bank
   end

   inline: tline (qStart qEnd nDT --- hA) \ timeline from Start to End
{     Create a timeline from Start to End, with step DT.

      Incoming Start and End are Chicago time strings HH:MM:SS, and
      incoming DT is the number of minutes between collections.

      Returned column vector A contains times in the session timeline
      that correspond to steps DT from Start to End.

      Quotes are assumed to be delayed by tDELAY.  Assuming the quote 
      for End won't arrive until End + tDELAY, End time is extended by 
      tDELAY, but not past time TMAX (about 15 minutes before session
      end).

}     [ 40 (minutes) 60 * "tDELAY" book, 86400 15 60 * - "TMAX" book ]

      60 * (sec) "DT" book
      (qEnd) tline_sec tDELAY + TMAX min "closes" book
      (qStart) tline_sec "starts" book

      DT closes starts - DT slash rounded
      (dt n) uniform (hUsec) starts + (hA)
   end

   inline: tline_sec (qHH:MM:SS --- sec) \ sec in timeline for HHMMSS
{     Incoming HH:MM:SS is the time in Chicago.

      Convert Chicago trading time (either electronic or pit) into a 
      time (number of seconds) in the program's timeline for a market
      session that ranges from zero to 24 hours.

      The following XY table defines the program's market session 
      timeline in terms of Chicago hours.  Zero in the timeline is 
      5pm (17:00), and 23 hours is the next day at 4pm (16:00). 

      Since the timeline is zero-based, it can be used directly with 
      the machine's GMT to figure out alarm start times.

}     [ list: 17 24 1 16 ; (X) \ Chicago hour
        list: 0  7  8 23 ; (Y) \ Timeline hour (Y, 24 hour period)
        (X Y) park yes sort "XY" book \ X in ascending order for lerp()
      ]
{     Testing:
         [tops@plunger] ready > "17:00:00" tline_sec .i
          0 \ start of market day, 5pm in Chicago.

         [tops@plunger] ready > "9:30:00" tline_sec 3600 / .  
          1.6500E+01 \ wheat pit opens after 16.5 hours, at 9:30am
         
         [tops@plunger] ready > "16:15:00" tline_sec 3600 / .
          2.3250E+01 \ copper electronic closes in 23.25 hours at 4:15pm

         [tops@plunger] ready > "18:00:00" tline_sec 3600 / .i
          1 \ wheat electronic opens after 1 hour at 6:00pm

      Something is wrong if time is negative.  Table XY is built for,
      and should only receive, positive times, ranging from 0 to the
      end of the session.
}
      (qHH:MM:SS) dup "H" book >SEC (sec) dup 0<
      IF " tline_sec: time is negative: " H + . nl (nSec) return THEN
      (nSec) 3600 /mod (nSec nHour)
      XY swap (hXY nHour) lerp @ (hour) 3600 * (sec hour) + (sec)
   end

#end timeline

\-----------------------------------------------------------------------

   inline: CH>LA (qHH:MM:SS --- qHH1:MM:SS)
{     Example:
         [tops@plunger] ready > "00:28:00" "13:38:00" pile CH>LA .
         22:28:00
         11:38:00
}     this type push
      >SEC (2 3600 *) 7200 - dup 0< 86400 * - >OCLOCK
      pull STR = IF 1st quote strchop THEN
   end

   inline: COLLECT (qMKT --- ) \ collect data
\     This word collects data by running another instance of the pro-
\     gram using file usr/tserv to run the following program script.
      [
      {" Program script to be run (quoted MKT replaces STRING):

       \ Fetching data is limited to 60 seconds per site, and all col-
       \ lection must end before this script exits in 25 seconds.

         "msgPeek" missing IF "dog.v" source THEN

         STRING
         chop "MKT" book

         MKT spaced date spaced cat
         time intstr spaced cat getpid intstr cat
         "COLLECT" msgPut

         "/tmp/" MKT ".LOG" cat cat set_sysout

         no catmsg "mget.v" source

         "-" 72 cats . nl
         " COLLECT begin: " . MKT . sp date . nl
         \ tasks REMOVED BECAUSE IT MAY CAUSE DELAY IF BUSY
         25 "HTTPget" "timeout" bank \ HTTPget limitation per site
         " HTTPget timeout per site (seconds):" .
         "HTTPget" "timeout" yank .i nl

         "HTTPget" flip IF "netscapeUA" ELSE "msieUA" THEN
         yank "HTTPget" "UA" bank
       
         date " SESS " + SESSION intstr + "D" book

       \ Collect from sites (slow pokes last):
         D MKT inoDATA (hT) pile "/tmp/" MKT "_IN.DAT" cat cat save
         D MKT tcDATA  (hT) pile "/tmp/" MKT "_TC.DAT" cat cat save
         D MKT fsDATA  (hT) pile "/tmp/" MKT "_FS.DAT" cat cat save
       \ D MKT bcDATA  (hT) pile "/tmp/" MKT "_BC.DAT" cat cat save

         \ tasks REMOVED BECAUSE IT MAY CAUSE DELAY IF BUSY

         "/tmp/" MKT ".V" cat cat "Fname" book Fname deleteif

         " COLLECT kill: " . Fname . nl Fname kill_S

         " COLLECT end: " . MKT . sp date . nl

      "} chop noblanklines "SCRIPT" book
      ]
      SYSOUT push LOG-FILE set_sysout
      (qMKT) uppercase "mkt" book

      " COLLECT: " . mkt . sp date . nl     \ a line to system LOG file
      "/tmp/" mkt ".V" cat cat "Fname" book \ script will delete this

      SCRIPT (qS) "STRING" mkt quoted replace$ (qS)
      (qS) "SESSION"
      time tsession - 0.5 + integer intstr \ GMT when session started
      (qS) strp (qS) Fname save

      usrpath "tserv" catpath
      " -exit 30 -source " + \ exit time
      Fname +                \ file to source
      " &" +
      (qS) shell

      pull set_sysout
   end

   inline: EOD-eCOLLECT ( --- ) \ end of day electronic collection
{     Make final collection of market electronic data.

      This word is timed to run in the small window of time following 
      the end of the last electronic closing and the opening of the 
      first electronic market to open.

      For the markets being followed, the window appears to be from 
      4:15 pm (central) when NY metals close to 5:00 pm (central)
      when many electronic markets open for the next day's trading.
}
    \ Faking out word gmtime() to give equivalent date and time in
    \ Chicago, so checking weekday is valid after 4PM (when it is 
    \ the next day in Greenwich, England):
      time CHdiff + gmtime (qS) \ machine date and time in Chicago
      (qS) sysdate drop weekday
      its 0 = swap 1 = or not \ not on Sat or Sun
      IF " EOD-eCOLLECT: starting shell script eod_elec " . date . nl
         "eod_elec &" shell 
      THEN
   end

   inline: EOD-pCOLLECT ( --- ) \ end of day pit collection
{     Make the day's final collection of market pit data.

      This word is timed to run about an hour after a session begins.

      Sessions begin at 15:00 Chicago time.  By 16:00 when this word 
      runs, pit trading for the day has settled.
}
    \ Faking out word gmtime() to give equivalent date and time in
    \ Chicago, so checking weekday is valid after 4PM (when it is 
    \ the next day in Greenwich, England):
      time CHdiff + gmtime (qS) \ machine date and time in Chicago
      (qS) sysdate drop weekday
      its 0 = swap 1 = or not \ not on Sat or Sun
      IF " EOD-pCOLLECT: starting shell script eod1 " . date . nl
         "eod1 &" shell 
       \ Run loadref in an hour, when eod data should be available 
       \ (from manually running eod.v and distributing results to
       \ sites (dtarin)):
         3600 "loadref" ALARM \ load new pit reference data
      THEN
   end

   inline: KILL.V ( --- ) \ kill extraneous jobs that should have died
\     Kill jobs that have .V in their command.
      pidtable_tops dup ".V" grepr any?
      IF (hT) reach 2nd word drop these rows 1st
         DO this I quote number (f)
            IF " KILL.V: kill " . dup intstr . nl killmy THEN
         LOOP drop
      ELSE drop
      THEN
   end

   inline: kill_S (qS --- ) \ kill job with S in name
\     Takes the first job that contains string S in pidtable_tops.
      strchop
      pidtable_tops dup rot grepr any?
      IF ontop quote notrailing (qKILL) " kill_S: " . this . nl
         2nd word drop number IF killmy THEN
      ELSE drop
      THEN
   end

{ ---

   inline: KILL_PID ( --- ) \ kill long running PIDs from msg COLLECT
{     Reads "COLLECT" messages from /tmp/msgcomm and kills jobs that
      were started more than OLD seconds ago if they are still running.

      Each time a collection word runs, it writes an entry to msgcomm
      using word msgPut--see word COLLECT.

      This word reads msgcomm and kills collection jobs that were
      started more than OLD seconds ago.

This is the vexing problem that refuses to get fixed.  The popd and
grepr are probably in killmy, not this word:
 KILL_PID: top Wed Apr 26 15:31:24 UTC 2006
 KILL_PID: start loop Wed Apr 26 15:31:26 UTC 2006 for 1 rows
 popd: expect number on stack
 grepr: expect string or volume on stack
 cat: volumes are not compatible
 KILL_PID: end loop Wed Apr 26 15:31:34 UTC 2006
 KILL_PID: top Wed Apr 26 15:32:25 UTC 2006

February 2008: The problem is due to using any? instead of any in the
statement: 
   IF TABLE PID I quote strchop grepr any?
which leaves an unwanted matrix on the stack.

This word appears only in words no longer used. 

Newer word KILL_ePID has it right.

There are no ghosts.

}
      [ 30 "OLD" book "" "PID" book ]

      "COLLECT" msgGet \ removes all COLLECT messages from /tmp/msgcomm
      any? not IF return THEN "MSG" book

      pidtable 2nd word drop "TABLE" book

      MSG 8 word drop numerate time less abs hand "ET" book
      MSG 9 word drop "PID" book

      PID chars 0>
      TABLE chars 0> and
      IF PID rows 1st
\" KILL_PID: start loop " date + " for" + . dup .i " rows" . nl
         DO ET I pry OLD >
            IF TABLE PID I quote strchop grepr any?
               IF PID I quote numerate negate killmy THEN \ kill old job
            ELSE MSG I quote "COLLECT" msgPut      \ put recent MSG back
            THEN
         LOOP
\" KILL_PID: end loop " date + . nl
         "" "PID" book
      THEN 
   end

--- }

   inline: LAdate ( --- qDate) \ date in LA
\     Add fortycoupe on 10-03-2008.
      host "topsdog" = host "rilefile" = or host "fortycoupe" = or
      IF time GMT>LA ctime 1st quote strchop
      ELSE date
      THEN
   end

   inline: LOG-FILE ( --- qFile) \ name of this script's log file
      [ "HOME" env "COLLECT.LOG" catpath "log" book ] log
   end

   inline: LOG-TOUCH ( --- ) \ touch the log file
      LOG-FILE ftouch
   end

   inline: make_times (starts closes every --- hT) \ T holds GMT
{     Incoming starts and closes are LA times.
      Incoming every is the number of minutes between collections.

      Outgoing VOL T contains GMT in the form, HH:MM:SS.

      The first (and every) collection is delayed by DELAY seconds.

}     [ 120 (sec) "DELAY" book ]
      60 * (sec) "every" book "closes" book "starts" book

      every starts closes elapsed every slash rounded three plus
      (dt n) uniform (hUsec)

      starts >SEC DELAY plus (nSTART) \ add DELAY to start time
      (hUsec nSTART) plus \ add start time to uniform every times
      LA>GMT >OCLOCK (hT) \ convert to GMT and make clock strings
   end

#def Mo_fix

   inline: Mo_fix (qSymMoYY --- qSymMoYY1) \ fix contract month symbol
{     Outgoing SymMoYY1 has the form:
         XMYY
      where
         X is market symbol, Sym
         M is month symbol (one of F,G,H,J,K,M,N,Q,U,V,X,Z)
         YY is two digit year

      Sometimes the year in incoming SymMoYY has only one digit, such
      as 7 for 2007.  This word will replace 7 by 07 so uniform Mo
      patterns can be matched.

      Used by bch.v, fs.v, ino.v, tch.v.
}
      chop "S" book S rows 1st
      DO S I quote strchop "s" book
         s s chars 1- ndx character number
         IF drop s \ ok, next-to-last symbol is a number
         ELSE s 1st s chars 1- items catch (qSym)
          \ August 2009: bch is putting out PB0 for PB10, so the code
          \ here is wrong; it makes PB00:
          \ "0" s s chars ndx character + +
          \ Here is a fix: if YY is 0, append it to 1 instead of 0:
            "0" s s chars ndx character dup number drop (YY) 0=
            IF lop "1" swap THEN + +
         THEN
      LOOP
      S rows pilen hand
      dup rows 1 = IF 1st quote THEN
      Mo_fix1
   end

   inline: Mo_fix1 (qSymMoYY --- qSymMoYY1) \ fix contract month symbol
{     Wed Aug 25 16:38:25 PDT 2010

      Outgoing SymMoYY1 has the form:
         XMYY
      where
         X is market symbol, Sym
         M is month symbol (one of F,G,H,J,K,M,N,Q,U,V,X,Z)
         YY is two digit year

      This fixes a case like PBG01 that should be PBG11.

      Incoming YY must have two digits, so run this after Mo_fix has 
      made two.
}
    \ It is now August 2010.  Assuming PBG12 will read as PBG02, this
    \ Ybase gets us to 2020:
      [ 10 "Ybase" book ] 

      chop "___" nose "S" book S rows 1st
      DO S I quote strchop dup chars 2 - split
         (qSymMo qYY) number \ these 2 digits must be a number
         IF (nYY) dup Ybase < IF Ybase + THEN intstr (qSymMo qYY) + 
         ELSE " Mo_fix1 halting: YY is not a number" . nl HALT 
         THEN
         "___" chblank
      LOOP
      S rows pilen hand chop
      dup rows 1 = IF 1st quote THEN
   end

#end Mo_fix
      
   inline: msgSPEED (qS bytes delta --- ) \ net speed message
\     Computes overall byte rate, including the time to connect.
\     For wget, rate also includes the time to start wget.

\     This word, called by collection words in bch.v, fs.v, ino.v
\     and tch.v, has been deactivated with the following phrase:

      drop 2drop return
      
      (qS bytes delta) over intstr spaced (bytes) rev 
      / intstr spaced (bytes/sec)
      " Bytes/sec: " . dup .i nl \ overall rate to log
      date (qS rate date) + + + spaced
      time intstr +
      "NETSPEED" msgPut
   end

   inline: next_at (hTimes --- nSec) \ next alarm today at nSec from now
{     Incoming Times is a STR or VOL list containing GMT on today, 
      HH:MM:SS.  

      Returned number nSec is the number of seconds to the soonest of 
      entries in Times.  Number nSec is never more than the number of
      seconds in one day.

      Future time offset, nSec from right now, is valid right now in 
      any time zone (think about it).

      Assumes Times are in ascending order.
}
      (hTimes) >SEC              \ list of times today for alarms
      time 86400 /mod drop (sec) \ seconds elapsed so far today

    \ Rake and keep the times that have not passed:
      (hTimes sec) less these 0> rake lop (hAsec)

      (hAsec) any?
      IF 1st pry \ fetch the earliest time for next alarm
      ELSE zero  \ no more to do today
      THEN
   end

   inline: NY>LA (qHH:MM:SS --- qHH1:MM:SS)
{     Example:
         [tops@plunger] ready > "00:28:00" "13:38:00" pile NY>LA .
         21:28:00
         10:38:00
}     this type push
      >SEC (3 3600 *) 10800 - dup 0< 86400 * - >OCLOCK
      pull STR = IF 1st quote strchop THEN
   end

   inline: TEXT>TABLE (hT f n% --- hT1) \ text into HTML table
{     Table for T that has the same number of columns in all rows.
      Number n% is the percentage of window width occupied by the
      table; if n%=0, entries are minimally spaced.
      Flag f is yes to include table borders.
}
      100 min one max "n" book
      "f" book

      these cols any not IF return THEN
      "T" book

      depth push f
      IF "<TABLE BORDER COLS="
      ELSE "<TABLE COLS="
      THEN
      T 1st quote words rows intstr cat
      ' WIDTH="' n intstr cat '%" NOSAVE >' cat (hT1)

      T rows 1st
      DO "<TR>"

         T I quote words
         "<TD>" nose
         "</TD>" tail

         "</TR>"

         (hT2a hT2b hT2c)
      LOOP

      "</TABLE>" (hT3)

      (hT1 hT2 hT3)
      depth pull less pilen (hT2)
   end

   inline: times (qS --- hGMT) \ times (GMT) today to run S
\     Times stored in the library of this word are GMT.
      uppercase dup local?
      IF (qS) local \ put local library item on the stack
      ELSE drop VOL tpurged \ no such S; return purged VOL
      THEN
   end

   "DT1" missing
   IF "mget.v" "#def TIMELINES" msource THEN \ load market timelines

   pull catmsg
   private halt

\-----------------------------------------------------------------------
 
\  Word COLLECT_START sources this region of the file every day, in 
\  case something has been revised.
 
#def TIMELINES

   CATMSG push no catmsg

\  11 "DT1" book \ minutes not exactly divisible into 30 or 60

\  With  a reduced number to collect in tracklist1 (see COLLECT_START),
\  cut DT1:
   7 "DT1" book \ minutes not exactly divisible into 30 or 60
   "(htimeline nsec) + " "del" macro \ seconds delay

\  Note: All times are in Chicago (Central).  When a closing hour
\  is less than the start hour, it is on the next day.  Word tline()
\  accounts for this.

\  Warning: the program session starts at 17:00, and start times before
\  this will not work.  

\  Word tline extends the Close times below by 40 minutes due to the
\  data delay.

\  Agriculture

\  Mkt      Start (CH)  Close (CH)  Every
   "w_pit"  "09:30:00"  "13:15:00"  DT1   tline timeline_add

\  THIS BREAKS ELECTRONIC TRADING INTO TWO PERIODS TO REFLECT THE
\  CLOSE OF TRADING FROM 6AM TO 9:30AM WHEN THE PITS OPEN:
\  
\  "w_ele"  "18:01:00"  "06:00:00"  DT1   tline
\           "09:30:00"  "13:15:00"  DT1   tline pile timeline_add

\  THIS IS AN EXPERIMENT TO SEE IF THESE TRADE FROM 6AM TO 9:30AM:
   "w_ele"  "18:01:00"  "13:15:00"  DT1   tline timeline_add
\  RESULT: graphs are flat from 6AM to 9:30AM, indicating that they are
\  not trading.  But there is little need to break up data collection,
\  so this single interval from 18:00 to 13:15 will continue to be used.

   "c_pit"  "w_pit" timeline 11 del       timeline_add
   "c_ele"  "w_ele" timeline 11 del       timeline_add

   "s_pit"  "w_pit" timeline 22 del       timeline_add
   "s_ele"  "w_ele" timeline 22 del       timeline_add

   "sm_pit" "w_pit" timeline 33 del       timeline_add
   "sm_ele" "w_ele" timeline 33 del       timeline_add

   "bo_pit" "w_pit" timeline 44 del       timeline_add
   "bo_ele" "w_ele" timeline 44 del       timeline_add

   "ct_pit" "w_pit" timeline 55 del       timeline_add
   "ct_ele" "00:00:00" "14:15:00"   DT1   tline timeline_add

\  Meat
\  Mkt      Start (CH)  Close (CH)  Every
   "lc_pit" "09:05:00"  "13:00:00"  DT1   tline timeline_add
   "lc_ele" "17:01:00"  "16:00:00"  DT1   tline timeline_add

   "lh_pit" "09:10:00"  "13:00:00"  DT1   tline timeline_add
   "lh_ele" "lc_ele" timeline 11 del      timeline_add

\ Discontinued pb, 11-17-2010
\  "pb_pit" "lh_pit" timeline 11 del      timeline_add
\  "pb_ele" "lc_ele" timeline 22 del      timeline_add

\  Food
\  Mkt      Start (CH)  Close (CH)  Every
   "cc_pit" "07:00:00"  "10:50:00"  DT1   tline timeline_add
   "cc_ele" "ct_ele" timeline 11 del      timeline_add

   "sb_pit" "07:10:00"  "11:30:00"  DT1   tline timeline_add
   "sb_ele" "cc_ele" timeline 11 del      timeline_add

   "kc_pit" "07:30:00"  "11:30:00"  DT1   tline timeline_add
   "kc_ele" "cc_ele" timeline 22 del      timeline_add

   "jo_pit" "09:30:00"  "12:30:00"  DT1   tline timeline_add
   "jo_ele" "06:00:00"  "14:15:00"  DT1   tline timeline_add

\  Metal
\  Mkt      Start (CH)  Close (CH)  Every
   "hg_pit" "07:10:00"  "12:00:00"  DT1   tline timeline_add
   "hg_ele" "17:02:00"  "16:15:00"  DT1   tline timeline_add

   "gc_pit" "07:20:00"  "12:30:00"  DT1   tline timeline_add
   "gc_ele" "hg_ele" timeline 11 del      timeline_add

   "si_pit" "07:25:00"  "12:25:00"  DT1   tline timeline_add
   "si_ele" "hg_ele" timeline 22 del      timeline_add

   "pl_pit" "07:20:00"  "12:05:00"  DT1   tline timeline_add
   "pl_ele" "hg_ele" timeline 33 del      timeline_add

\  Energy

\  Collection of CL, HO, HU and NG take a long time from ino
\  apparently because it takes a long time to connect.  This
\  causes a kind of traffic jam, so they are spaced apart 
\  uniformly in the DT1 space from one CL to the next CL:
   DT1 60 * 4 / "Esec" book

\  Mkt      Start (CH)  Close (CH)  Every
   "cl_pit" "08:00:00"  "13:30:00"  DT1   tline timeline_add
   "cl_ele" "17:03:00"  "16:15:00"  DT1   tline timeline_add

   "ho_pit" "cl_pit" timeline Esec del    timeline_add
   "ho_ele" "cl_ele" timeline Esec del    timeline_add

   "hu_pit" "cl_pit" timeline Esec 2 * del timeline_add
   "hu_ele" "cl_ele" timeline Esec 2 * del timeline_add

   "ng_pit" "07:20:00" "14:00:00"   DT1    tline timeline_add
   "ng_ele" "cl_ele" timeline Esec 3 * del timeline_add

\  Currency
\  Mkt      Start (CH)  Close (CH)  Every
   "sf_pit" "07:20:00"  "14:00:00"  DT1   tline timeline_add
   "sf_ele" "17:04:00"  "16:15:00"  DT1   tline timeline_add

   "eu_pit" "sf_pit" timeline 11 del      timeline_add
   "eu_ele" "sf_ele" timeline 11 del      timeline_add

   "jy_pit" "sf_pit" timeline 22 del      timeline_add
   "jy_ele" "sf_ele" timeline 22 del      timeline_add

   "mp_pit" "sf_pit" timeline 33 del      timeline_add
   "mp_ele" "sf_ele" timeline 33 del      timeline_add

   "bp_pit" "sf_pit" timeline 44 del      timeline_add
   "bp_ele" "sf_ele" timeline 44 del      timeline_add

\  Interest
\  Mkt      Start (CH)  Close (CH)  Every
   "us_pit" "07:20:00"  "14:00:00"  DT1   tline timeline_add

 \ Sun Oct  2 15:01:44 PDT 2011.  Electronic US and TN now begin at 
 \ 17:00 CT:
   "us_ele" "17:00:00"  "16:00:00"  DT1   tline timeline_add

   "tn_pit" "us_pit" timeline 11 del      timeline_add
   "tn_ele" "us_ele" timeline 11 del      timeline_add

   "ff_pit" "07:20:00" "14:00:00" DT1 2 * tline timeline_add
   "ff_ele" "18:01:00" "16:00:00" DT1 2 * tline timeline_add

   "ed_pit" "07:20:00" "14:00:00" DT1 2 * tline timeline_add
   "ed_ele" "17:01:00" "16:00:00" DT1 2 * tline timeline_add

\  Index
\  Mkt      Start (CH)  Close (CH)  Every
   "dj_pit" "08:30:00"  "15:15:00"  DT1   tline timeline_add

 \ Tue Nov 27 12:11:17 PST 2012.  Electronic DJ, SP and NQ now end at
 \ 16:15 CT, not 16:30:
   "dj_ele" "17:00:00"  "16:15:00"  DT1   tline timeline_add

   "sp_pit" "08:30:00"  "15:15:00"  DT1   tline timeline_add
   "sp_ele" "dj_ele" timeline 11 del      timeline_add

   "nq_pit" "sp_pit" timeline 11 del      timeline_add
   "nq_ele" "dj_ele" timeline 22 del      timeline_add

   "nk_pit" "08:00:11"  "15:15:00"  DT1   tline timeline_add
   "nk_ele" "01:00:00"  "15:15:00"  DT1   tline timeline_add

   pull catmsg
   private halt

#end TIMELINES

\-----------------------------------------------------------------------

   Making TIMELINES that vary randomly to avoid collisions.

   The version above, with collisions, is being tried to see if the
   new queuing system takes care of them.

   Below is an earlier version where it was attempted to manually
   spread out the starting times to minimize collisions.  It was
   a lot of work, and can be avoided if the queuing system can be
   shown to smooth out collisions.

{
   Word COLLECT_START sources this region of the file every day, in 
   case something has been revised.
}

{  Note: simultaneous start times are offset different amounts to avoid
   loading the servers.  Words DT and dt are adhoc attempts to aid in 
   this.  

   The following phrases can be used to view the worst clashes and 
   tweek start times to improve things:
      xx ww pit_times delta .01 filter "D" book
      xx ww elec_times delta .01 filter "D" book
      xx ww pit_times elec_times pile yes sort delta .01 filter "D" book
      D 2nd those rows 1- items reach yes sort 1st 40 items reach .m

   Even with clashes, using the queuing system will not allow simulta-
   neous jobs to start, and viewing the regions of clashes shows they
   are not usually back-to-back, so there is time after one to recover.

   For example, this shows about 16 seconds between a clash at row
   531 and the next collection at row 532; and at row 535 there is 
   over 2 minutes for the queue to discharge:
      Row 531:        0
      Row 532:    16.57
      Row 533:    10.44
      Row 534:    27.86
      Row 535:    130.7
      Row 536:    30.83
      Row 537:        0
      Row 538:    16.57
      Row 539:    10.44
      Row 540:    27.86
      Row 541:    130.7

   This looks like a rougher stretch than the one above; three are 
   back-to-back, followed by a 37 second stretch (three because there
   are two deltas: 109 is diff of 108 and 109, and 110 is diff of
   109 and 110; so 108, 109 and 110 are more or less coincident:
      Row 106:     38.8
      Row 107:    37.44
      Row 108:    35.75
      Row 109:        0
      Row 110:   0.7299
      Row 111:    37.61
      Row 112:   0.6299
      Row 113:    35.32
}
   "tline" missing IF "mget.v" source THEN

   seed0 seedset

   CATMSG push no catmsg

   inline: DT ( --- DT) \ step in minutes
      [ 10 "t1" book 11 "t2" book ] 
      t1 t2 1 1 ranreal @ ; \ random minutes between t1 and t2

   inline: dt ( --- dt) \ time shift in seconds
      [ 6 "N" book ] DT 60 * N / ; \ random seconds spread among N items

   pull catmsg

\  Note: All times are for Chicago (central).  When a closing hour
\  is less than the start hour, it is on the next day.  Word tline() 
\  accounts for this.
 
\  Agriculture
   6 "dt" "N" bank

\  Mkt      Start (CH)  Close (CH)  Every
   "w_pit"  "09:30:00"  "13:15:00"  DT    tline timeline_add
   "w_ele"  "18:00:00"  "07:15:00"  DT    tline 
            "09:31:00"  "13:15:00"  DT    tline pile timeline_add

   "c_pit"  "w_pit" timeline dt +         timeline_add
   "c_ele"  "w_ele" timeline dt +         timeline_add

   "s_pit"  "c_pit" timeline dt +         timeline_add
   "s_ele"  "c_ele" timeline dt +         timeline_add

   "sm_pit" "s_pit" timeline dt +         timeline_add
   "sm_ele" "s_ele" timeline dt +         timeline_add

   "bo_pit" "sm_pit" timeline dt +        timeline_add
   "bo_ele" "sm_ele" timeline dt +        timeline_add

   "ct_pit" "bo_pit" timeline dt +        timeline_add
   "ct_ele" "00:30:20" "14:15:00"   DT    tline timeline_add
 
\  These electronic markets all start at the same time (5pm):
\ Discontinued pb, 11-17-2010
\     lc, lh, pb, hg, gc, si, pl, cl, ho, hu, 
\     ng, sf, eu, jy, mp, bp, ed
   17 "dt" "N" bank 

\  Meat
\  Mkt      Start (CH)  Close (CH)  Every
   "lc_pit" "09:03:00"  "13:00:00"  DT    tline timeline_add
   "lc_ele" "17:01:11"  "16:00:00"  DT    tline timeline_add

   "lh_pit" "09:10:00"  "13:00:00"  DT    tline timeline_add
   "lh_ele" "lc_ele" timeline dt +        timeline_add

\ Discontinued pb, 11-17-2010
\  "pb_pit" "lh_pit" timeline dt +        timeline_add
\  "pb_ele" "lh_ele" timeline dt +        timeline_add

\  Food
\  Mkt      Start (CH)  Close (CH)  Every
   "cc_pit" "07:05:00"  "10:50:00"  DT    tline timeline_add
   "cc_ele" "ct_ele" timeline dt +        timeline_add

   "sb_pit" "07:10:00"  "11:30:00"  DT    tline timeline_add
   "sb_ele" "cc_ele" timeline dt +        timeline_add

   "kc_pit" "07:30:00"  "11:30:00"  DT    tline timeline_add
   "kc_ele" "sb_ele" timeline dt +        timeline_add

   "jo_pit" "09:30:11"  "12:30:00"  DT    tline timeline_add
   "jo_ele" "06:03:00"  "14:15:00"  DT    tline timeline_add

\  Metal
\  Mkt      Start (CH)  Close (CH)  Every
   "hg_pit" "07:10:30"  "12:00:00"  DT    tline timeline_add
   "hg_ele" "17:03:00"  "16:15:00"  DT    tline timeline_add

   "gc_pit" "07:20:00"  "12:30:00"  DT    tline timeline_add
   "gc_ele" "hg_ele" timeline dt +        timeline_add

   "si_pit" "07:25:00"  "12:25:00"  DT    tline timeline_add
   "si_ele" "gc_ele" timeline dt +        timeline_add

   "pl_pit" "07:20:00"  "12:05:00"  DT    tline timeline_add
   "pl_ele" "si_ele" timeline dt +        timeline_add

\  Energy
\  Mkt      Start (CH)  Close (CH)  Every
   "cl_pit" "08:00:00"  "13:30:00"  DT    tline timeline_add
   "cl_ele" "pl_ele" timeline dt +        timeline_add

   "ho_pit" "cl_pit" timeline dt +        timeline_add
   "ho_ele" "cl_ele" timeline dt +        timeline_add

   "hu_pit" "ho_pit" timeline dt +        timeline_add
   "hu_ele" "ho_ele" timeline dt +        timeline_add

   "ng_pit" "hu_pit" timeline dt +        timeline_add
   "ng_ele" "hu_ele" timeline dt +        timeline_add

\  Currency
\  Mkt      Start (CH)  Close (CH)  Every
   "sf_pit" "07:20:00"  "14:00:00"  DT    tline timeline_add
   "sf_ele" "ng_ele" timeline dt +        timeline_add

   "eu_pit" "sf_pit" timeline dt +        timeline_add
   "eu_ele" "sf_ele" timeline dt +        timeline_add

   "jy_pit" "eu_pit" timeline dt +        timeline_add
   "jy_ele" "eu_ele" timeline dt +        timeline_add

   "mp_pit" "jy_pit" timeline dt +        timeline_add
   "mp_ele" "jy_ele" timeline dt +        timeline_add

   "bp_pit" "mp_pit" timeline dt +        timeline_add
   "bp_ele" "mp_ele" timeline dt +        timeline_add

\  Interest
\  Mkt      Start (CH)  Close (CH)  Every
   "us_pit" "07:20:11"  "14:00:00"  DT    tline timeline_add
   "us_ele" "18:00:00"  "16:00:00"  DT    tline timeline_add

   "tn_pit" "us_pit" timeline dt +        timeline_add
   "tn_ele" "us_ele" timeline dt +        timeline_add

   "ff_pit" "tn_pit" timeline dt 2 * +    timeline_add
   "ff_ele" "tn_ele" timeline dt 2 * +    timeline_add

   "ed_pit" "ff_pit" timeline dt 2 * +    timeline_add
   "ed_ele" "bp_ele" timeline dt 2 * +    timeline_add

\  Index
\  Mkt      Start (CH)  Close (CH)  Every
   "dj_pit" "07:20:21"  "15:15:00"  DT    tline timeline_add
   "dj_ele" "18:15:00"  "16:00:00"  DT    tline timeline_add

   "sp_pit" "08:30:00"  "15:15:00"  DT    tline timeline_add
   "sp_ele" "17:00:00"  "15:15:00"  DT    tline timeline_add

   "nq_pit" "sp_pit" timeline dt +        timeline_add
   "nq_ele" "sp_ele" timeline dt +        timeline_add

   "nk_pit" "08:00:00"  "15:15:00"  DT    tline timeline_add
   "nk_ele" "01:00:00"  "15:15:00"  DT    tline timeline_add

   private halt

\-----------------------------------------------------------------------

;  Appendix

   Notes

   Words with "kill" in their names were inspired after seeing many
   jobs unleashed by the collection driver and running long after 
   they should have ended due to errors of one kind or another.

   Testing the queuing system, January 2008.

      Testing shows the need for a little balancing.

      This shows eBO being queued, immediately running, and then
      being queued again:

         eBO queued at Mon Jan 21 08:08:09 PST 2008
         eBO running at Mon Jan 21 08:08:09 PST 2008
         eBO queued at Mon Jan 21 08:08:09 PST 2008

      The queue sends a job off every 5 seconds so this second eBO
      job will be run at about 08:08:14.

      Meanwhile, these two popped in, making queue_len equal to 3
      (but this is shown just for interest, and is not related to
      this discussion of eBO queuing):

         eCC queued at Mon Jan 21 08:08:11 PST 2008
         eHU queued at Mon Jan 21 08:08:13 PST 2008

      The reason eBO was queued a second time is probably because the 
      first time it entered the queue was just when it was time to run
      a job, so it never really waited.  When the job ran, QTASK was 
      run and queued it up again.

      It is believed the run happened so quickly that not enough ses-
      sion time had passed, and word soonest() came up with nearly the 
      same time to run again, instead of a time 10 or 11 minutes in the
      future.  Word soonest() has been modified to return times that 
      are "soonest," but not too soon.

\-----------------------------------------------------------------------

   This earlier version of COLLECT_MAKE has some notes on how things
   evolved:

   inline: _COLLECT_MAKE (qMKT qTASK f --- ) \ make a collection word
{     This word makes a word called MKT-COLLECT to do collection for
      MKT using word TASK.  This word also sets the first ALARM to 
      start the collection for MKT according to its timeline.

      Incoming flag f is true if MKT is an open outcry (pit) market,
      and false if MKT is an electronic market.

      Collecting is done by word TASK with this stack diagram:
         TASK (qMKT --- )

      For open outcry markets, TASK is probably word COLLECT, and for 
      electronic markets it is probably word eCOLLECT.

      Enclosed below in {" ... "} is TEXT for the word being created.  
      It will be a word like like W-COLLECT or eSF-COLLECT, and have
      a stack diagram given by ( --- ) so it can be run in the multi-
      tasker either as a TASK or as an ALARM.

      These phrases in TEXT look simple now (just three lines in 
      QTASK), but they took a couple of days to write; the problem 
      was figuring out how to make the collection word run with the 
      new queuing system.

      In a nutshell, whenever the collection word runs, all it does 
      is queue up the collection task called QTASK.  It does not run 
      QTASK and it sets no ALARMs.

      Macro QTASK happens to live in the collection word, which is 
      handy since the local library holds variables it can use.

      But the running of QTASK is now beyond the collection word's
      field of operation.  Macro QTASK is run by the queuing system 
      in turn with other queued jobs.
}     [ 

      {" MKT-COLLECT ( --- )
         [ \ begin bracket region for TEXT

         defname "NAME" book \ name of word being created

{        Formerly, this word ran on an ALARM to execute these phrases, 
         running pTASK (ptr to TASK) and then setting an ALARM to run 
         the next time:

            MKT (qMKT) pTASK exe         \ doing the assigned task
            MKT times next_at NAME ALARM \ setting the next alarm

         A problem with that approach occurred when a number of 
         ALARMs happened to go off at nearly the same time, loading 
         the machine with a lot of collection jobs all running at 
         once.

         Words for a simple queuing system have been been written
         (file task.v) where jobs to be run immediately can be put
         into a queue and run at a periodic rate by the multitasker.

         To use the queuing system for collection, when ALARM goes 
         off the job of this word is not to execute the phrases above,
         but to put a task, called QTASK, into the queue where it will
         be run, in turn with others, as soon as possible.
 
         Below is QTASK, a macro in this word's local library that 
         will be queued up and run by queue_run():
}
            "MKT (qMKT) pTASK exe "           \ do the assigned task
            "TMKT timeline soonest (nSec) " + \ get the next time
            "NAME ALARM" +                    \ and set next ALARM

            "QTASK" (hT qS) macro
 
       \ By setting ALARM to run this word's NAME, QTASK ensures that 
       \ this word will be run again in nSec. 
       
         ] \ end bracket region for TEXT

       \ Gather electronic data from the previous collection, then 
       \ queue up QTASK for another one.
         PIT not IF MKT hist_add THEN
{
         The following phrase runs when ALARM goes off (or whenever 
         this word runs).  

         This word's phrase simply places the ptr to local word QTASK
         into the queue, where it will be run as soon as possible.  

         The ALARM to go again is set when QTASK runs, and not by this
         word, in case there is a big delay; there is no sense queuing
         up again if the earlier one is still in the queue.
}
         PIT IF MKT ELSE "e" MKT + THEN " queued at " + date + . nl
         NAME "QTASK" localref ptr queue_add \ whenever this word runs

      "} "TEXT" book \ text for word to be created (by word macro)
      ]

\-----------------------------------------------------------------------

   Words for collecting market data.

   This file sources all the files of words for collecting market data.

   Notes about each file are given below:

      1. bch.v

         Volume and open interest (yesterday's) match WSJ.

         All contract months are present, so summed volume and open
         interest are complete.

         MP is collected with an extra digit, but unlike the others
         it is always zero.

         Connecting shows different last digits in IP address: .19,
         .20, or .21.  I guess this means several servers.

         For some reason, closing bytes from this site show up
         after the connection is supposedly closed.  These bytes
         show up: 3E 0D 0A.  The 3E is the > that ends the pattern
         </http>.  It appears to show up with the usual endings of
         CRLF (0D0A).

         Word HTTPget closes the connection as soon as </http is
         received, but 3E0D0A shows up in the socket (or sometimes
         just 0D0A or simply 0A).

         This is the same as behavior from the CRB site that changed
         their formats and caused this file and bch.v, fs.v, and
         tch.v to be created in 2004.

      2. fs.v

         Smallest number of bytes for the amount of data; files are
         about one-third of the size from bch.v.

         All contract months are present, so summed volume and open
         interest are complete.

         Volume and open interest (yesterday's) may match WSJ, but
         sometimes estimated volume is given (probably today's).

         Prices continue after regular markets close for markets that
         continue with late sessions.  These include

            metals: HG, GC, PL, SI
            oil: CL, HO, HU, NG
            currencies: SF, EU, JY, BP
            bonds: US, TN, FF, ED
            stocks: SP, NQ

         In 2007 this site completely changed its symbols, requiring
         a major update to fs.v.

      3. tch.v

         Files are relatively small.

         Volume and open interest do not match (and occasional volume
         may match one collected by the other ones).

         Not all contract months are present, so summed volume and open
         interest are incomplete even if the correct values were there.

         There is a bug displaying changes in grains (W, C, S) when the
         fractional part (eights) is zero; see note in tch.v.

         The notes above were written in 2004.  In 2007 file tch.v was
         updated and contract months were found to be pretty complete
         and the grains bug mentioned above has been eliminated.  This
         site now has electronic data, and it is being used in updates
         made to tch.v in 2008.

      4. ino.v

         Written in 2007 for newly discovered quotes.ino.com.  This 
         seems to be a very good site, well organized with all the
         markets including electronic ones.

------------------------------------------------------------------------
