/* {{{1 GNU General Public License

Program Tops - a stack-based computing environment
Copyright (C) 1999-2014  Dale R. Williamson

Author: Dale R. Williamson <dale.williamson@prodigy.net>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
1}}} */

/* math1.h  April 1999

Copyright (c) 1999-2014  D. R. Williamson

Note: /usr/include/mathcalls.h shows calls to system math functions.
*/

/* Interpolation cases: */
enum {LERP,  LEXT, CLOSEST, LOOK,     FIND }; /* in lerp1() */
enum {INTERP,XTRAP,CLOSESTX,NEARBELOW,FINDX}; /* in lerp() */

#define SEED0 1073743823 /* gives random value of about 0.5 */
double SEED;
double VQSORT;

int abs1(); /* abs (hA --- hA1) */
int across(); /* across (hA --- hV) */
int and(); /* and (hA hB --- hC) */
int and_(); /* and (hA hB --- hC) */
double _and(double x, double y);
double _atan2(double y, double x);
int atan2_(); /* atan2 (hY hX --- hY/X) */
int bins(); /* bins (hV x1 x2 n --- hB) */
int bit(); /* bit (hA n --- hB) */
int bitget(); /* bitget (hV hN --- hA) */
int bitoff(); /* bitoff (hA n --- hB) */
int biton(); /* biton (hA n --- hA1) */
int bitset(); /* bitset (hV n --- hB) */
int brandom(); /* brandom (b1 b2 r c --- hT) */
int bsearch1(); /* bsearch (hA x --- r f) */
int bsearchd(double x, double *xtable, int len, int *delta);
int byteorder(int **k); 
int byteorder1(); /* endian ( --- n) */
int byterm1(int oncase); /* arg: int oncase; stk: (hA --- hB) */
int byterm2(int oncase); /* arg: int oncase; stk: (hA hB --- hC) */
int closest(); /* closest (hXYt hX --- hY) */
int colsort(); /* colsort (hA --- hA1) */
int colsort1(); /* colsort1 (hA n --- hA1) */
int colsortAB(); /* colsortAB (hA hB f --- hA1 hB1) */
int compare(); /* compare (hA hB fac ref --- hC) */
double _cos(double x);
int cos1(); /* cos (hA --- hA1) */
double _cosh(double x);
int cosh1(); /* cosh (hA --- hA1) */
int cross(); /* *cross (hA hB --- hC) */
int delta(); /* delta (hA --- hdA) */
int dotprod(); /* *dot (hA hB --- hV) */
int eq(); /* = (hA hB --- hF) */
double _eq(double x, double y);
double _exp(double x);
int exp1(); /* e^ (hA --- hA1) */
int __f(); /* __f (hV n --- hF) */
int __fsum(); /* __fsum (hV hD --- hF) */
int false(); /* false ( --- false) */
int filter1(); /* filter (hA x --- hB) */
int find(); /* find (hXt hX --- hf) */
double _fivepow(double x);
int fivepow(); /* 5^ (hA --- hA1) */
int ge(); /* >= (hA hB --- hF) */
double _ge(double x, double y);
int greg(); /* greg (YYmmdd --- d) */
int growth(); /* growth (hS hN --- hR) */
int gt(); /* > (hA hB --- hF) */
double _gt(double x, double y);
int histogram(); /* histogram (hV hC b --- hH) */
int INFpos(); /* INF ( --- bigval) */
int INFneg(); /* -INF ( --- -bigval) */
void insrt(double *A, int n, int *rnew, double Anew, double *B, \
   double Bnew);
int int2_(); /* (not used) (hA --- hI) */
int int4_(); /* ints or int (hA --- hI) */
int int8_(); /* int8 (hA --- hI) */

int uint2_(); /* (not used) (hA --- hI) */
int uint4_(); /* uints or uint (hA --- hI) */
int uint8_(); /* int8 (hA --- hI) */

int int2(); /* int2 or uint2 (hA --- hT) */
int int4(); /* int4 or uint4 (hA --- hT) */

double _int(double x);

double _int2(double x);
double _int4(double x);
double _int8x(double x);

int integer(); /* integer (hA --- hI) */
int intervals(); /* intervals (x1 x2 n --- hX) */
int lag(); /* lag (hA n -- hA1) */
int lagN(); /* lagN (hA hN -- hB) */
int lagr(); /* lagr (hA n -- hA1) */
int lagV(); /* lag (hV hN -- hA) */
int le(); /* <= (hA hB --- hF) */
double _le(double x, double y);
int lerp(int opt, double *xtable, double *ytable, int lentable,
         double x, double *y);
int lerp1(int opt, int srch);
int lerp2(); /* lerp (hXYt hX --- hY) */
int lext(); /* lext (hXYt hX --- hY) */
double _ln(double x); 
int ln(); /* ln (hA --- hA1) */
double _log2(double x); 
int log2a(); /* log2 (hA --- hA1) */
double _log5(double x);
int log5(); /* log5 (hA --- hA1) */
double _log10(double x);
int log10_(); /* log10 (hA --- hA1) */
int logistic_rmax(); /* logistic_rmax (hdS --- hR) */
int logistic_steps(); /* logistic_steps (hS n% --- hR) */
int look(); /* look (hXYt hX --- hY) */
int looking(); /* looking (hV hR --- hV1) */
int looking1(); /* looking1 (hV hR r --- hV1) */
int looking2(); /* looking2 (hV hU hR --- hW) */
int lt(); /* < (hA hB --- hF) */
double _lt(double x, double y);
int mag(); /* mag (hA --- hV) */
int mathinit();
double _max(double x, double y);
int max1(); /* max (hA hB --- hC) */
int max2(); /* max1 (hA --- hB) */
int maxcompress(); /* maxcompress (hA ht ht1 --- hB) */
int maxfetch(); /* maxfetch (hA --- x i j) */
double _min(double x, double y);
int min1(); /* min (hA hB --- hC) */
int min2(); /* min1 (hA --- hB) */
int minfetch(); /* minfetch (hA --- x i j) */
int minus(); /* - (x y --- x-y) or (hA hB --- hC) */
int minusd(); /* -d (hA d --- hB) \ B(i,j)=A(i,j)-d */
int minusm(); /* - (hA hB --- hC) */
int minusn(); /* - (x y --- x-y) */
int mod(); /* mod (x y --- rem) */
int mod1(); /* % (x y --- mod) */
int mpy(); /* mpy (hA hB --- hC) \ C=A*B */
int mpyad(); /* mpyad (hD hA hB --- hC) \ C=D+A*B */
void mpyad1(double *D, double *Ain, double *Bin, int rowA, int colA, \
   int colB, double *Cout);
int mpydg(); /* mpydg (hA hB --- hC) \ C=diag(A*B) */
int ne(); /* <> (hA hB --- hF) */
double _ne(double x, double y);
int negate(); /* negate (x --- -x) or (hA --- hB) */
int nit(); /* nit (x --- x-1) */
int norm(); /* norm (hA --- hB) */
int not(); /* not (hA --- hB) */
double _not(double x);
int nott(); /* nott (hA --- hB) */
double _nott(double x);
int nottx(); /* nottx (hA --- hB) */
double *_nottx(double x);
int nrcrv(); /* nrcrv (hV hA --- hV1 hK) */
int nrcrv2(); /* nrcrv2 (hV hA --- hV1 hK) */
int nzmin1(); /* nzmin1 (hA --- hB) */
int or(); /* or (hA hB --- hC) */
int or_(); /* or (hA hB --- hC) */
double _or(double x, double y);
int outside(double *x, double xMin, double yMin);
int overlay(); /* overlay (hA hB --- hC) */
int partials(); /* partials (hA --- hB) */
int patint(double x);
unsigned long patlong(double x);
unsigned int patuint(double x);
int plus(); /* + (x y --- x+y) or (hA hB --- hC) */
int plusd(); /* +d (hA d --- hB) \ B(i,j)=A(i,j)+d */
int plusm(); /* + (hA hB --- hC) */
int plusn(); /* + (x y --- x+y) */
int plusi(); /* ( hA hD hR hC --- hB ) \ B(R,C) = A(R,C) + D */
int power(); /* pow (hA d --- hB) */
int power1(); /* ^by (hA d --- hB) \ B(i,j)=A(i,j)**d */
void qsort1(double *A, int len, int dir);
int *qsort2(double *A, int len, int dir);
void qsortdn(double *A, int *p, int left, int right);
void qsortup(double *A, int *p, int left, int right);
double rand0(double *seed);
int random1(); /* random (r c --- hA) */
int ranking(); /* ranking (hV n --- hR hH) */
int ranking1(); /* ranking1 (hV hP n --- hR hH) */

double _real2(short x);
double _real4(long x);
double _real4f(float x);
int real2(); /* 2real (hI --- hA) */
int real4(); /* 4real (hI --- hA) */
int real2_(); /* not used (hI --- hA) */
int real4_(); /* not used (hI --- hA) */
int ureal2(); /* u2real (hI --- hA) */
int ureal4(); /* u4real (hI --- hA) */
int ureal2_(); /* not used (hI --- hA) */
int ureal4_(); /* not used (hI --- hA) */
double _ureal2(unsigned short x);
double _ureal4(unsigned long x);

int rsort(double *A, int n, int *rnew, double Anew, double Aold);
int searching(); /* searching (u "U(k)" kmax --- k) */
int seed0(); /* seed0 ( --- x) */
int seedget(); /* seedget ( --- x) */
int seedset(); /* seedset (x --- ) */
int sign(); /* sign ( --- n) */
int sign1(int *k);
double _sin(double x);
int sin1(); /* sin (hA --- hA1) */
double _sinh(double x);
int sinh1(); /* sinh (hA --- hA1) */
int slash(); /* / (x y --- x/y) or (hA --- hB) */
int slashby(); /* /by (hA hB --- hC) \ C(i,j)=A(i,j)/B(i,j) */
int slashf(); /* /f (hA f --- hB) \ B(i,j)=A(i,j)/f */
int slashmod(); /* /mod (x y --- rem quot) */
int slashn(); /* / (x y --- x/y) */
int sort1(); /* sort (hA f --- hA1) */
int sorton(); /* sorton (hA f n --- hA1) */
int sqrt1(); /* sqrt (x -- sqrt_x) */
int star(); /* * (x y --- x*y) or (hA hB --- hC) */
int starby(); /* *by (hA hB --- hC) \ C(i,j)=A(i,j)*B(i,j) */
int starf(); /* *f (hA f --- hB) \ B(i,j)=A(i,j)*f */
int starm(); /* * (hA hB --- hC) */
int starn(); /* * (x y --- x*y) */
int stats(); /* stats (hA --- hB) */
int stats1(); /* stats1 (hA --- hB) */
int stats2(); /* stats2 (hA hW --- hB) */
double _tan(double x);
int tan1(); /* tan (hA --- hA1) */
double _tanh(double x);
int tanh1(); /* tanh (hA --- hA1) */
double _tenpow(double x);
int tenpow(); /* 10^ (hA --- hA1) */
int tic(); /* tic (x --- x+1) */
int totals(); /* totals (hA --- hB) */
int trandom(); /* trandom (rows bytes --- hT) */
int trandom1(); /* trandom1 (rows bytes --- hV) */
int true(); /* true ( --- true) */
double _twopow(double x);
int twopow(); /* 2^ (hA --- hA1) */
double UNDEF;
int urn(); /* urn ( --- x) */
int vqsort(double *A, int len);
int VQSORTset(); /* VQSORT (f --- ) */
int xor(); /* xor (hA hB --- hC) */
double _xor(double x, double y);
int zeroeq(); /* 0= (hA --- hF) */
double _zeroeq(double x);
int zerogt(); /* 0> (hA --- hF) */
double _zerogt(double x);
int zerolt(); /* 0< (hA --- hF) */
double _zerolt(double x);
int zerone(); /* 0<> (hA --- hF) */
double _zerone(double x);

/* end math1.h headers */

