/* {{{1 GNU General Public License

Program Tops - a stack-based computing environment
Copyright (C) 1999-2014  Dale R. Williamson

Author: Dale R. Williamson <dale.williamson@prodigy.net>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
1}}} */

/* mmath.h  October 2000

Copyright (c) 2000-2014  D. R. Williamson

*/
int ceig(); /* ceig (hC f --- hAr hAi) */
int chmats_(double *rr, double *ri, double *ar, double *ai, int *mx,
   double *a, double *b, double *c__, int *mda, int *mdb, int *mdc,
   int *n, int *nopt);
int conj1(); /* conj (hA --- hB) */
int cross_correlation(); /* cross-correlation (hX hY d --- hR) */
int diagpre(); /* diagpre (hV hA --- hB) */
int diagpost(); /* diagpost (hA hV --- hB) */
int diagpost_complex(); /* (hA hV --- hB) */
int diagpre_complex(); /* (hV hA --- hB) */
void dot1(double *Ain, double *Bin, int len, double *dot);
double dsign(double z, double p);
int eig_(double *a, double *rr, double *ri, int n);
int elmhes_(double *a1, int n);
int hqr_(double *a1, int n, double *wr1, double *wi1);
int inverd_(int *ndim, double *a, int *n, double *b, int *m,
   double *determ, int *ising, int *index);
void _lag(double *V, int rows, int n, double *A);
int _lamp(); /* _lamp (hA ht hf --- hFr hFi) */
int lsqfit(); /* lsqfit (hA n dt --- hB) */
int lsqprj(); /* lsqprj (hA n dt --- hB hBd hBdd) */
void matB(double *B, int n, double t);
void matD(double *D, int n, double t);
void _mmax(double *A, int rows, int n, double *B);
int mmax1(); /* mmax1 (hV ht ntau --- hV1) */
int mmin1(); /* mmin1 (hP ht ntau --- hP1) */
void _mmin(double *A, int rows, int n, double *B);
int modald_(double *c__, int *n, int *m, double *rr, double *ri,
   double *b, double *a, int *mdc, int *mdb, int *mda,
   double *ear, double *eai, int *mx, double *ar, double *ai,
   int *nopt, int *imp, float *tol, double *pivots, int *kwork,
   double *work, int *w);
int nlag(); /* nlag (hA f --- hN) */
int s3coef(); /* s3coef (hX ht --- hC) */
int s3eval(); /* s3eval (hC ht --- hX hX' hX'') */
int skyline(); /* skyline (hA --- hA1) */
int solve(); /* solve (hb hA --- h[Ainv*b]) */
void spline3(int n, double *x, double *y, double *coef);
int vectrd_(double *ar, double *ai, int *n, int *nrdim, int *nidim,
   int *irel, int *nvct, float *zro, double *pivots, int *ncol,
   double *wr, double *wi, int *iout);

/* end mmath.h headers */
