/* {{{1 GNU General Public License

Program Tops - a stack-based computing environment
Copyright (C) 1999-2014  Dale R. Williamson

Author: Dale R. Williamson <dale.williamson@prodigy.net>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
1}}} */

/* wapp.h  December 1999

Words for applications and projects
 
Prototypes for functions in wapp.c
*/

/*--------------------------------------------------------------------*/

/* Example of new word compilation in file word.h */
int alpha(); /* alpha (hA hB --- hC) */
int funtest(); /* funtest (... --- ...) */

/*--------------------------------------------------------------------*/
/* Functions to demonstrate overloading */

int starA(); /* *A (hA hB --- hC) */
int starB(); /* *B (hA hB --- hC) */
int starC(); /* *C (hA hB --- hC) */

/*--------------------------------------------------------------------*/

/* Functions for dynamic analysis */
#define RADPERDEG 0.017453292519943295
int centroid(); /* centroid (hW hA --- hC) */
int cgm(); /* cgm (hf hA --- hx) */
int cmagphase(); /* cmagphase (Ar Ai --- hMag hPhase) */
int cmagphase1(); /* -cmagphase (R P --- Ar Ai) */
int detrend(); /* detrend (hA hB0 hB1 --- hA1) */
int logarea(); /* logarea (hP hF --- hA) */
int moveave(); /* ma (hA n --- hB) */
int movetot(); /* mtot (hA n --- hB) */
int retrend(); /* retrend (hA1 hB0 hB1 --- hA) */
int stardircos9(); /* *dircos9 (hCba hXa --- hXb) */
int steady(); /* steady (hZ hW hQ hF --- hqr hqi) */
int tr(); /* tr (hSig n --- hTr) */
int tr1(); /* tr1 (hSig n r --- hTr) */
int trend(); /* trend (hA --- hB0 hB1) */

/*--------------------------------------------------------------------*/

/* Functions for net.v */
int logistic(); /* logistic (hH nBeta --- hFexp) */
int net_activate(); /* (hIn hOut --- ) */
int net_step(); /* stepping (qNet --- ) */

/*--------------------------------------------------------------------*/

/* Functions for linear prediction.  */
int lpcoef(); /* lpcoef (hA ncoef --- hC msq) */
int lpeval(); /* lpeval (hA hC n --- hP) */

/*--------------------------------------------------------------------*/

/* Functions for bdf.v */
int cylvec(); /* cylvec (hRTZ --- hXYZ) */
int op2mat1(); /* op2mat1 (hFile hMap rows cols type endian --- hA) */
int render(); /* render (hT --- hT1) */
int sphvec(); /* sphvec (hRTP --- hXYZ) */

/*--------------------------------------------------------------------*/

/* Functions for genetic algorithm */
int ga_bit(); /* ga_bit (hV hR --- hB) */
int ga_bitoff(); /* ga_bitoff (hV hR --- hV1) */
int ga_biton(); /* ga_biton (hV hR --- hV1) */
int ga_crossover(); /* ga_crossover (hA hB nbit --- hC hD) */
int ga_fill(); /* ga_fill (hR --- hV) */
int ga_random(); /* ga_random (n --- hV) */
int ga_strstk(int bytes, char *name);
int ga_toggle(); /* ga_toggle (hV hR --- hV1) */

/*--------------------------------------------------------------------*/

/* Functions for mday.n and other related files. */
int cposn(); /* cposn (hS hC ht nT --- hS1 hC1 ht1 ht2) */
int crossing(); /* crossing (hX hY --- hF) */
int crossing1(); /* crossing1 (hX hY --- hF) */
int dposn(); /* dposn (hC hNd --- hP) */
/*int dposn1();*/ /* dposn1 (hC hNd N --- hP) */
int dposn2(); /* dposn2 (hC hNd N --- hP hV) */
int mmax(); /* mmax (hA n --- hB) */
int mmaxf(); /* mmaxf (hA n --- hB hR hf) */
int mmaxN(); /* mmaxN (hA n N--- hB) */
int mmaxN2(); /* mmaxN2 (hA n N --- hB hJ) */
int mmaxr(); /* mmaxr (hA hB0 n --- hB) */
int mmaxV(); /* mmaxV (hV hN --- hB) */
int mminV(); /* mminV (hV hN --- hB) */
int mmaxv(); /* mmaxv (hA hf --- hB) */
int mmin(); /* mmin (hA n --- hB) */
int mminf(); /* mminf (hA n --- hB hR hf) */
int mminN(); /* mminN (hA n N--- hB) */
int mminN2(); /* mminN2 (hA n N --- hB hJ) */
int mminr(); /* mminr (hA hB0 n --- hB) */
int mminv(); /* mminv (hA hf --- hB) */
int newHL(); /* newHL (hC hN --- hR2 hR1) */
int pnckclps(); /* pnckclps (hC hP d --- hF) */
int rolldelta(); /* rolldelta (hK hC hChg --- hDelta) */
int runs(); /* runs (hC hF --- hR) */
int vec_origin(); /* vec_origin (hE hL --- hO1 hL1) */

/*--------------------------------------------------------------------*/

/* Transient analysis */
int uncoupled(); /* uncoupled (hB hK hP hqd0 hq0 step -- hqdd hqd hq) */
/* Transient analysis Fortran functions in wapp_f.f: */
#ifdef FORT_UDSC
   #define RAMP ramp_
   #define RAMP0 ramp0_
#else
   #define RAMP ramp
   #define RAMP0 ramp0
#endif

void RAMP(double *t, double *r0, double *r1, double *xd0, double *x0,\
          double *g, double *h, double *cx, double *w2,\
          double *xdd1, double *xd1, double *x1);
void RAMP0(double *t, double *b, double *k, double *g, double *h,\
           int *err);

/*--------------------------------------------------------------------*/

/* end wapp.h headers */
