\ {{{1 GNU General Public License
{
Program Tops - a stack-based computing environment
Copyright (C) 1999-2014  Dale R. Williamson

Author: Dale R. Williamson <dale.williamson@prodigy.net>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
1}}}
}
{  File sys/dog.v  September 2002

   Copyright (c) 2002-2014   D. R. Williamson

   Watchdog.

   Simple interprocess communication.
      Words for simple communication, over a shared message file,
      between different instances of this program running, perhaps
      as watchdogs on intruders.

   Words to watch files.
      File can mean regular file, subdirectory, or device.

\-----------------------------------------------------------------------

   How to get a list of inlines in this file:
   syspath "dog.v" cat asciiload this " inline:" grepr reach dot

   Table of Contents.

   Change notes.

   Interprocess communication.
   Channels for interprocess communication.
      msgPub ( --- nB) \ public channel number
      msgChat1 ( --- nB) \ private channel number 1
      msgChat2 ( --- nB) \ private channel number 2
   Words for interprocess communication.
   inline: msgChn (nB --- ) \ communication is on channel B
   inline: msgClean ( --- ) \ delete communication files
   inline: msgComm ( --- hM) \ fetch all of the communication messages
   inline: msgDel (qS --- ) \ delete message S from the messages
   inline: msgGet (qS --- hM) \ get message S and remove S from messages
   inline: msgGetIP (qS qIP nPort --- hM) \ get msgs for S at IP(Port)
   inline: msgHold ( --- ) \ idle until messages are available
   inline: msgPeek (qS --- hM) \ sneak a peek at messages for S
   inline: msgPeekIP (qS qIP nPort --- hM) \ peek at S msgs on IP(Port)
   inline: msgPeekSocket (qS nSocket --- hM) \ messages S from Socket
   inline: msgPeep (qS nB --- hM) \ peep at messages for S on channel B
   inline: msgPoll (qName --- ) \ create a word that polls for messages
   inline: msgPub? ( --- f) \ true if process is using pubic channel
   inline: msgPut (hM qS --- ) \ put new message for S with the messages
   inline: msgPutIP (hM qS qIP nPort -- ) \ put new msg S(M) at IP(Port)
   inline: msgRel ( --- ) \ give up control of message file
   inline: msgRm ( --- ) \ delete the message file and busy file
   inline: msgSave (hM --- ) \ save messages M if within time window
   inline: msgToc ( --- ) \ show all the messages
   Initial channel for msgcomm and msghold.

   Words to watch files.
   inline: BUSY ( --- addr) \ global busy flag for all watch words
   inline: dir_watch (qToPath qDir qWord --- ) \ watch files in Dir
   inline: file_watch (qToPath qFile qWord --- ) \ save file on deletion

   Appendix.
   Obsolete words.

------------------------------------------------------------------------

   Change notes.

      Sat Apr 26 11:48:28 PDT 2014.  Word msgPeep() tries multiple 
      times to peep at a message file it does not control.  When it
      controls the file, it uses msgPeek() which holds the message
      file from others until it is read; multiple tries are unneces-
      sary in this case.

      Fri Apr 18 14:05:37 PDT 2014.  Having msgPeek() make multiple
      tries to read the message file has been abandoned, and it now
      works like msgGet() to place a hold on the message file before
      gathering its messages.  

      The thinking that prompted this came from a msgPeep() error dur-
      ing normal operation of a data file server, that the message file
      was not found:
         ...
         tasker: interruption Tue Apr 15 11:37:09 PDT 2014
         tasker: busy task VCUTOFF,0:CODE__ interrupted by queue_run...
         UPDATED queue: EU US DJ ... Tue Apr 15 11:37:37 PDT 2014
         UPDATED queue: CL JY DJ ... Tue Apr 15 11:38:37 PDT 2014
         UPDATED queue: SP NQ HG ... Tue Apr 15 11:39:37 PDT 2014
         msgPeep: message file not found
         UPDATED queue: JY TN DJ ... Tue Apr 15 11:40:37 PDT 2014
         ...

      Words msgPeek() and msgPeep() were similar except that msgPeek()
      had a branch to try multiple times and msgPeep() did not.  This
      means that both words are susceptable to the same error, but 
      msgPeep() will fail without even one additional attempt.

      The change to place a hold on the message file is straight for-
      ward in msgPeek().  MsgPeep() may be peeping at a message file
      for which it has no control, so placing a hold is impossible; 
      however, it was made to use msgPeep(), when the message file re-
      quested is the same as the message file it controls.

      That means that msgPeep() is still subject to a file not found
      error if the files differ.  In the future, it could be made more
      robust by inserting the capability for multiple tries in the now-
      abandoned version of msgPeek(), which is in the Appendix.  [This
      has been done; see above Sat Apr 26 11:48:28 PDT 2014.]

      Sun Mar  9 11:56:31 PDT 2014.  Words msgGetIP(), msgPeekIP() and
      msgPutIP() have been rewritten.  These words access the message
      channel being used by a remote server.  The remote server must 
      allow the client's Internet IP address, which is set beforehand 
      using word SERVER_ALLOW().

      Sat Mar  1 10:53:59 PST 2014.  Once the same channel has been set
      by msgChn() in a number of processes, it is risky for any of them
      to switch to another channel.  New word msgPeep() works just like
      msgPeek() but for any channel, making it safe to peep at messages
      on another channel without switching to that channel to run msg-
      Peek().  

      Sat Mar  1 08:58:12 PST 2014.  The note in msgPeek(), "M has zero
      rows if there are no messages for S," implies an empty VOL, not 
      an empty STR, is returned because an empty STR always has 1 row 
      (see man STR).  In all words, instances of returned empty STR 
      ("") have been replaced with "VOL tpurged" in case downstream 
      uses require zero rows.  The following shows an empty string ("")
      has 1 row and an empty VOL (tpurged(VOL)) has 0 rows:

         [tops@plunger] ready > "" rows .i, VOL tpurged rows .i
          1 0
         [tops@plunger] ready > 

         (Note: "" is equivalent to STR tpurged.)

      Thu Feb 27 12:44:10 PST 2014.  New word msgChn() allows differ-
      ent communication channels by using different msgcomm and msghold
      files.  There are two private channels and one public channel.
      The former single channel defaults to the public channel if word
      msgChn() is never invoked.  

      Each channel uses two files: msgcomm and msghold.  Word msgChn()
      is used to switch from one channel to another by switching to the
      msgcomm and msghold files appropriate for the channel.  See the
      library of msgChn() for the default path and file names for each
      of the channels. 
     
---------------------------------------------------------------------- }

   CATMSG push no catmsg
{
   Interprocess communication.
 
   Simple interprocess communication using a shared message file.
 
      Each line in the text file of messages has the form:

         S Message

      For messages that use more than one line, each line in the mes-
      sage file will begin with the same pattern S.  Word msgPut will
      take care of transforming a message string or the lines of a mes-
      sage volume to this format, and all lines will be gathered by 
      word msgGet.

      The access status of the communication messages after a word 
      finishes running is noted in its definition below by its "Comple-
      tion status."  Status "Released" means other words can access and 
      change messages; "Hold" means they will be barred from access 
      until Hold is released.  Words msgComm and msgHold are the only 
      ones that exit in the Hold state.

      When a word cannot access the messages, it idles in a loop and 
      checks periodically until they are available (word msgHold).

      Sat Jun 15 11:41:29 PDT 2013.  This file continues to be useful
      every day.  Perhaps its speculated demise below is premature.

      Wed Mar  9 10:03:07 PST 2011.  It was fun while it lasted.  The 
      interprocess communication approach in this file works adequately,
      but close study of its design (now that we are a little smarter)
      reveals flaws that make it vulnerable to timing problems between 
      msgComm, msgHold, msgHold.capture, msgSave and msgRel.

      Someday perhaps it should be redesigned to use its own message 
      queuing system--like the asynchronous one given in task.v that 
      was invented much later than this file--to eliminate the idle 
      wait in msgHold and the need for busy flag file msghold.

      Such a change means that the words of this file would be run
      separately as a daemon, like the sound file server, and not as 
      part of every job that writes to the message file.  All every
      job would need to know is how interface with the "message file"
      server to send and fetch messages; the message file server would 
      worry about safely writing messages to the message file.

      These ideas and capabilities weren't around when this file was 
      written.

      Thu Feb 20 20:28:56 PST 2014.  And still this file continues to
      be useful every day.  Perhaps its speculated demise above was 
      premature, and the idea of using a queuing system may have its
      own pitfalls.

---------------------------------------------------------------------- }

\  Channels for interprocess communication.

{" These macros name the channels and imply what they may be used for:

   // Thu Feb 27 12:44:10 PST 2014

   /* Channel 0, e.g., servers put messages for use by all clients: */
         macro("0 '_msgPub' naming", "msgPub");

   /* Channels 1 and 2, between related PIDs: */
         macro("1 '_msgChat1' naming", "msgChat1");
         macro("2 '_msgChat2' naming", "msgChat2");

   /* Example:
         msgChat2 msgChn   \ instances define their interprocess channel
         (qM qS) msgPut    \ and put messages on their own channel
         (qS) msgPeek (hM) \ and peek at their own channel
         (qS) msgGet (hM)  \ and get from their own channel
         (qS) msgPub msgPeep (hM) \ but only peep at the public channel
   */
"} eval

\  Words for interprocess communication.

   inline: msgChn (nB --- ) \ communication is on channel B
{     Thu Feb 27 11:46:21 PST 2014.  Set the communication files for B.

      Current numbers allowed for B are:
         0 for public channel called msgPub
         1 for private channel called msgChat1
         2 for private channel called msgChat2

      Newly set communication files are in effect until this word is
      run again.  Once a channel is set at start up, it is risky to 
      switch to another one.

      To display the current channel in use, look at msgChn.CHN:

         >> .("Using message channel"); .i(msgChn.CHN);
         Using message channel 0
         >> 

      Files are intended to reside in a user's directory, rather than
      somewhere like /tmp.  Example of FILES names in this word's local
      library for user dash:

         >> .(indent(msgChn.FILES, 3))
            /home/dash/msgcomm
            /home/dash/msghold
            /home/dash/msgcomm1
            /home/dash/msghold1
            /home/dash/msgcomm2
            /home/dash/msghold2
         >> 
}
      [ "HOME" env (hPath) "PATH" book

        depth push

      \ Public (B=0):
        PATH "msgcomm" catpath 
        PATH "msghold" catpath 

      \ Chat1 (B=1):
        PATH "msgcomm1" catpath
        PATH "msghold1" catpath

      \ Chat2 (B=2):
        PATH "msgcomm2" catpath
        PATH "msghold2" catpath

        depth pull less pilen (hT) "FILES" book

        FILES rows 2 / 1- "Bmax" book
      ]
      (nB) dup 0 Bmax within not (nB f)
      IF " msgChn: channel" . (nB) .i " is out of range" . nl return
      THEN (nB) "CHN" book

      CHN 2 * xbase + (nB)
      (nB) FILES over quote strchop "msgComm" "File" bank
      FILES swap (nB) 1+ quote strchop "msgHold" "File" bank

    \ Making a msgHold file if there is none or if the existing one has
    \ zero bytes:
      "msgHold" "File" yank (qFile) this file?
      IF (qFile) filesize 0= IF msgRel THEN
      ELSE (qFile) drop msgRel
      THEN

    \ Making a one-byte msgComm file if there is none:
      "msgComm" "File" yank (qFile) this file?
      IF (qFile) drop ELSE (qFile) crush THEN
   end

   inline: msgClean ( --- ) \ delete communication files
\     Completion status: Released
      [ yes is cleanup ] cleanup IF msgRm THEN
   end

   inline: msgComm ( --- hM) \ fetch all of the communication messages
{     Completion status: Hold

      Set Hold so others cannot modify the message file, and fetch all 
      the messages; return with status Hold still on.

      Change notes.

      Sun Mar  6 23:36:43 PST 2011.  Rearrange so msgHold is run before
      checking for existence of File, and add a message if File is mis-
      sing.  This fixes an error noted on Fri Nov 26 09:33:58 PST 2010
      (usr/tops_http.v, word msgcomm_bad()) under the following theory:

         On rare occasions query file? could find File missing as 
         another process was rewriting, probably because msgHold 
         was not run first.  To make matters worse, this word would 
         then return (to msgPut) without a hold on the file and with
         an empty VOL (from word blockofblanks) instead of the con-
         tents of File, so msgPut would cause all messages to be lost 
         except the new one it was writing.  Later, msgPeek would 
         fail to find the message it wanted because it was one of 
         the lost ones.

         This is a glaring oversight, and it is surprising it did
         not cause errors more often over the years.  The error has 
         only been seen recently on the web machines, which keep 
         getting faster and faster.  Is that the reason?  Or, did it
         always occur but was not noticed until recently because 
         on the web machines there is now a test in tops_http to run 
         msgPeek for the IP address of machine plunger?  This latter 
         reason seems the most correct: file msgcomm has been getting
         wiped out for years but no one noticed.

         This problem was first noticed in November 2010, and word
         msgcomm_bad() was placed into usr/tops_http.v on November 26,
         2010 to sense when it occurred.  Various fixes were imple-
         mented as the problem arose, but none really fixed it until 
         now.  It took about 3.5 months to isolate a rare problem in 
         automated programs running 24 hours a day, 5 days a week.

         That is kind of sobering, and the lesson is (again) to always
         do something to start a process for isolating a problem, then
         be patient and keep at it because it might take a long time.

}     [ "" is File \ name to be set by msgChn
        0 "ftime" book \ File time, used to test the age of msgcomm
      ]
    \ This is the only place where msgHold is run:
      msgHold \ must return with status Hold on, under all conditions

      File file?
      IF File asciiload chop noblanklines
      ELSE " msgComm: " File + " is missing, " + date + . nl
         VOL tpurged (hM)
      THEN
   end

   inline: msgDel (qS --- ) \ delete message S from the messages
\     Completion status: Released
      msgGet drop ;

   inline: msgGet (qS --- hM) \ get message S and remove S from messages
{     Completion status: Released

      Gets message S and removes it from the communication messages. 

}     1st word (S1 f)
      IF (S1) msgComm (S1 hM) any?
         IF (S1 hM) this 1st word trash them grepe any?
            IF (S1 hM hRows) those rows teeth rake (S1 hM0 hM1)
               (hM1) msgSave \ saving what is left
               (S1 hM0) over (S1) chars tic negate indent chop (hM)
               (S1 hM) "_" rot + naming (hM)
            ELSE (S1 hM) 2drop VOL tpurged (hM)
            THEN (hM)
         ELSE (S1) drop VOL tpurged (hM)
         THEN (hM)
      ELSE " msgGet: incoming stack error" ersys VOL tpurged (hM)
      THEN msgRel (hM)
   end

   inline: msgGetIP (qS qIP nPort --- hM) \ get msgs for S at IP(Port)
    \ Sun Mar  9 11:39:42 PDT 2014

    \ Gets all messages for S and removes them from the communication 
    \ messages on remote IP(Port).  Runs clients on the remote to show
    \ in the remote log file who connected.

      (qIP nPORT) CLIENT "S" book S 0>
      IF (qS) quoted " clients msgGet remotefd remoteput ACK" + (qS)
         (qS) S remoterun1 (f)
         IF " msgGetIP: OK " date + . nl
         ELSE " msgGetIP: error in msgGet " date + . nl 
            VOL tpurged (hM)
         THEN S sclose
      ELSE " msgPeekIP: error connecting to host" . nl drop 
         VOL tpurged (hM)
      THEN
   end

   inline: msgHold ( --- ) \ idle until messages are available
{     Completion status: Hold

      Waits for messages to become available, then holds the messages 
      so others cannot see or modify them.

      Later, word msgRel is run to again make the messages available
      to others.

      A one-byte file is used to broadcast the Hold flag.  Over a 
      shared network, the file must be closed every time it is acces-
      sed.  If not, there is huge latency (perhaps 10 or 15 seconds) 
      before other machines reading the file get the latest update.

      By closing the file on every access, response between machines 
      is instantaneous (at least on the scale of human reaction times).

      Change notes.

      Tue Mar  8 14:36:32 PST 2011.  Add tmax=time+twindow as the time
      interval that Hold will be in effect.  Word msgSave will not save
      its messages if time is later than tmax. 

      Sat Feb 26 14:34:43 PST 2011.  Rearrange macro busy to close file
      as soon as possible.

      Here is a phrase that runs msgHold for more than maxwait (about
      2 seconds), forcing msgRel (a "hit maxwait" message) and return:
         "msgHold" "capture" localrun \ set non-null byte
         4 "msgRel" ALARM \ delay release beyond 2 seconds
         msgHold \ holding

      Here is a phrase that runs msgHold for less than maxwait seconds,
      resulting in normal termination (no "hit maxwait" message):
         "msgHold" "capture" localrun \ set non-null byte
         1 "msgRel" ALARM \ release before 2 seconds
         msgHold \ holding
}
      [ "" is File \ a one-byte file, name to be set by msgChn
        .25 (sec) is wait
        2 (sec) is maxwait

        maxwait 0.80 * "twindow" book
        -1 "tmax" book

        no into hFile
        no is total

        {" ( --- ) Setting non-null byte:
              File forn binary "hFile" open
              NLch hFile dup rewind fput hFile close
              time twindow + "tmax" book
        "} "capture" macro

        {" ( --- f) Checking for non-null byte:
              File forn binary "hFile" open
              hFile one fget (hS) hFile close 
              (hS) nullbyte strmatch 0<> (f)
        "} "busy" macro

      ]
      hFile filetrue IF hFile close THEN

      BEGIN busy 
         IF wait dup idle total bump
            " msgHold: " runid + " idling " + dot date dot nl
         ELSE capture return \ the short way out
         THEN 

         total maxwait > 
         IF " msgHold: " runid + " hit maxwait " + dot date dot nl
            yes
         ELSE no
         THEN (f)
      UNTIL 

      capture
   end

   inline: msgPeek (qS --- hM) \ sneak a peek at messages for S
{     Completion status: Released

      Messages remain on the message file.
      M has zero rows if there are no messages for S.

      Change notes.

      Fri Apr 18 12:39:43 PDT 2014.  Complete revision.  Patterned after
      msgGet(), using msgComm() to hold msgComm.File before reading it;
      eliminate multiple tries in the previous version.  The previous
      version is in the Appendix; its multiple tries may be appropriate
      for a future revision to msgPeep(), since it cannot use msgComm()
      to hold msgComm.File.
}
      1st word (S1 f)
      IF (S1) msgComm (S1 hM) msgRel (S1 hM) any?
         IF (S1 hM) this 1st word drop (S1 hM) them grepe any?
            IF (S1 hM hRows) those rows teeth rake (S1 hM0 hM1) drop
               (S1 hM0) over (S1) chars tic negate indent chop (S1 hM)
               (S1 hM) "_" rot + naming (hM)
            ELSE (S1 hM) 2drop VOL tpurged (hM)
            THEN (hM)
         ELSE (S1) drop VOL tpurged (hM)
         THEN (hM)
      ELSE " msgPeek: incoming stack error" ersys VOL tpurged
      THEN (hM)
   end

   inline: msgPeekIP (qS qIP nPort --- hM) \ peek at S msgs on IP(Port)
    \ Sun Mar  9 11:03:16 PDT 2014

    \ Peeks at messages for S in the communication messages on remote 
    \ IP(Port).  Runs clients on the remote to show in the remote log
    \ file who connected.

      (qIP nPORT) CLIENT "S" book S 0>
      IF (qS) quoted " clients msgPeek remotefd remoteput ACK" + (qS) 
         (qS) S remoterun1 (f)
         IF " msgPeekIP: OK " date + . nl
         ELSE " msgPeekIP: error in msgPeek " date + . nl VOL tpurged
         THEN S sclose
      ELSE " msgPeekIP: error connecting to host" . nl drop VOL tpurged
      THEN
   end

   inline: msgPeekSocket (qS nSocket --- hM) \ messages S from Socket
\     Mon Jun  8 06:06:31 PDT 2009
\     Note: Socket is not closed by this word.
      (nSocket) swap strchop (qS)
      (qS) quoted " msgPeek remotefd remoteput" + swap remoterun1 (hM)
   end

   inline: msgPeep (qS nB --- hM) \ peep at messages for S on channel B
{     Sat Mar  1 08:58:12 PST 2014
      Messages remain on the message file.
      Completion status: Released
      M has zero rows if there are no messages for S.

      Similar to msgPeek(), but for any channel B, not just the current
      channel in use.  Uses msgPeek() if channel B and the current one
      match.

      Sat Apr 26 11:23:28 PDT 2014.  If msgPeek(), with its advantage
      of using msgComm() which holds the message file, cannot be used
      here because msgComm.File is not the same as msgChn.Files(nB), 
      use multiple tries from the old version of msgPeek() now in the 
      Appendix.  These are the variables used for control:

         Use EOP and TRIES>0 to enable error output and multiple
         attempts to see S.  Initial values are EOP=yes, TRIES=3.

            Set TRIES>0 to make more than one attempt for messages S.
            Set EOP to yes for error output.  Note that output ERR 
            displayed is 1 or 2 to denote the branch taken.

            Examples:
               Give error output (postfix and infix shown):
                  yes "msgPeep" "EOP" bank
                  msgPeep.EOP = yes;

               Make three delayed attempts to peek at S:
                  3 "msgPeep" "TRIES" bank

               Set delay time between attempts to 1.5 seconds:
                  msgPeep.SEC = 1.5;

      Fri Apr 18 13:12:51 PDT 2014.  Uses msgPeek() if msgComm.File is
      the same as msgChn.Files(nB).
}
      [ "msgChn" "Bmax" yank "Bmax" book

        yes "EOP" book, 3 "TRIES" book

        "msgHold" "maxwait" yank "SEC" book
{
        Initial values above force multiple tries and display messages
        if not found.  If it is valid for a message to be missing, then
        EOP=yes and TRIES>0 may not be desired.  

        Setting EOP=no will eliminate messages, but time will always be
        wasted going through all TRIES before returning.  To force no
        multiple tries, set these as follows:

           msgPeep.EOP = no;
           msgPeep.TRIES = 0;

        Another way around this problem is to leave the initial values
        alone and have a dummy message S(X) always present on the mes-
        sage file.  Dummy message S(X) will never be used, but it will
        stand in when useful messages, say S(J) and S(K), are missing.
}
        0 "TRY" book
        '(n --- ) 1 = IF " try " ELSE " tries " THEN .' ".tries" macro
      ]
      (qS nB) swap strchop (nB qS)

      (nB qS) over (nB) 0 Bmax within not (f)
      IF " msgPeep: channel" . (nB qS) drop (nB) .i " is out of range"
         .  nl return
      THEN (nB qS) swap (nB) dup "B" book (nB) 2 * xbase + (nS nRow)

      "msgChn" "FILES" yank swap (hFiles nRow) quote strchop (nS qFile)

    \ If File is the same as msgComm.File, use msgPeek() so a hold
    \ can be used:
      (qFile) "msgComm" "File" yank over =
      IF \ simple case; just call msgPeek() and return:
         (qS qFile) drop msgPeek return 
      THEN (qS qFile)

      0 "ERR" book \ will show error branch taken, if any

      (qFile) scratch fcopy (qS) dup "S" book
      scratch asciiload scratch deleteif chop noblanklines (hM) any?
      IF this 1st word drop (S1 hM) them grepe any?
         IF (S1 hM hRows) those rows teeth rake (S1 hM0 hM1) drop
            (S1 hM0) over (S1) chars tic negate indent chop (S1 hM)
            (S1 hM) "_" rot + naming (hM)
         ELSE \ " msgPeep: no messages found" . nl 
            (S1 hM) 2drop VOL tpurged 1 "ERR" book
         THEN (hM)
      ELSE \ " msgPeep: message file not found" . nl
         (qS) drop VOL tpurged (hM)
         2 "ERR" book
      THEN (hM)

      TRIES 0= IF (hM) return THEN (hM)

    \ This section is run if TRIES>0:
      (hM) any? \ retry if M is an empty string
      IF \ success
         TRY 0> EOP and
         IF " msgPeep: found msg " S + " after" + . TRY .i
            TRY .tries date . nl
         THEN
         (hM) 0 "TRY" book
      ELSE 1 TRY incr TRY TRIES <=
         IF EOP
            IF " msgPeep: TRY=" TRY intstr +
               " ERR=" ERR intstr + + " for msg " + S + .
               sp date . nl
            THEN

          \ Idle for SEC and reenter this word:
            SEC idle S B msgPeep (hM)

         ELSE EOP
            IF " msgPeep: no msg " S + " after" + . TRY 1- .i
               TRY 1- .tries date . nl
            THEN
            VOL tpurged (hM) \ failed after TRY
            (hM) 0 "TRY" book
         THEN (hM)
      THEN (hM)
   end

   inline: msgPoll (qName --- ) \ create a word that polls for messages
{     Creates a word called Name to poll for messages and act upon the 
      ones that have its name.

      Any number of words can be created by this word, msgPoll.  See
      "manny, moe and jack" demo in man msgPoll.

      After it is created, Name can be started in the multitasker (using
      word PLAY or word TASK) to begin polling for messages called Name.

      Message strings are sent to word Name using msgPut:
         "quoted phrase 1" "Name" msgPut
         "quoted phrase 2" "Name" msgPut
         "quoted phrase 3" "Name" msgPut

      A volume of text strings can also be sent to Name using msgPut:
         (hMessage) "Name" msgPut
      where Message can contain many lines of text.

      Messages are stacked by word msgPut in the order received, with 
      latest one last.

      Messages called Name are removed every time word Name runs in the
      multitasker, i.e., Name messages are removed every cycle.
}
      [  
       {" This is the text for the word called Name to be created:
         [ defname is Name

         \ The stack diagram for Cyc and Ack is (qName --- ), so the
         \ initial ptr for them is set to the ptr to word drop:
              "drop" ptr is Cyc \ the cyclic task, run every cycle
              "drop" ptr is Ack \ the task run when message is received
{
         Cyc and Ack are words being run (by exe) whose ptrs have been
         banked here.  But they are not like inlines that may have been
         created here when word Name was created, and so do not share 
         Name's local library.  They see only their own local libraries,
         not Name's, and so they will need to use word extract (synonym
         yank) to get anything out of the library of Name.

         Example 1 in the Appendix explores some uses of words for Cyc
         and Ack, including the issue of their local libraries.
}
         ]
       \ These phrases are run every time word Name runs:

       \ This word is running in the multitasker.  Put it to sleep
       \ until it is ready to exit (probably not really necessary):
         Name SLEEP 

       \ Get the mail:
         Name msgGet (hM) any?
         IF "M" book      \ book M so Ack has control over it
            Name Ack exe  \ perform acknowledgement task
            M any?        \ ack task may have deleted M or banked new
            IF (hM) local \ run phrase M
            THEN
         THEN

       \ Perform the cyclic task:
         Name Cyc exe 

         Name WAKE

       "} asciify chop noblanklines (hT) 
       (hT) into Ftext \ the text used to create word called Name
      ] 
    \ These phrases are run at the time word Name is created:
      (qName) "Name" book  \ name of word to make

      CATMSG (f) no catmsg \ turn off console 'into catalog' message
      Ftext Name macro     \ making word Name using phrases in Ftext
      (f) catmsg           \ reset console message flag
   end

   inline: msgPub? ( --- f) \ true if process is using pubic channel
    \ Sun Mar  2 12:17:56 PST 2014
      "msgChn" "CHN" yank msgPub = (f)
   end

   inline: msgPut (hM qS --- ) \ put new message for S with the messages
\     Completion status: Released

\     Puts new message for S with the current messages.

      strchop spaced nose (hM0)
      msgComm (hM1) swap (hM1 hM0) pile \ newest message on the bottom
      (hM) msgSave 
      msgRel
   end

   inline: msgPutIP (hM qS qIP nPort -- ) \ put new msg S(M) at IP(Port)
    \ Sun Mar  9 11:03:16 PDT 2014

    \ Puts new message for S with the communication messages on remote 
    \ IP(Port).  Runs clients on the remote to show in the remote log
    \ file who connected.

      (qIP nPORT) CLIENT "S" book S 0>
      IF (hM qS) quoted " clients msgPut" + (hM qS) S remoterun2 
         S sclose
      ELSE " msgPutIP: error connecting to host" . nl 2drop
      THEN
   end

   inline: msgRel ( --- ) \ give up control of message file
\     Completion status: Released

\     Broadcasting that messages are available by setting null byte in
\     msgHold File (the busy file).

      [ no into hFile ]

      hFile filetrue IF hFile close THEN
      "msgHold" "File" yank (qFile)

    \ Setting a null byte where msgHold.capture set a non-null byte:
      (qFile) forn binary "hFile" open
      nullbyte hFile fput, hFile close

      no "msgHold" "total" bank
      -1 "msgHold" "tmax" bank
   end

   inline: msgRm ( --- ) \ delete the message file and busy file
      "msgComm" "File" yank deleteif 
      "msgHold" "File" yank deleteif ;

   inline: msgSave (hM --- ) \ save messages M if within time window
    \ Tue Mar  8 14:45:04 PST 2011.  Replaces macro msgPut.msgSave.
    \ Completion status: Released

    \ Note: if unable to save revised messages here when running msgGet,
    \ the old message file is probably still intact with the msgGet mes-
    \ sages still in it.

      time "msgHold" "tmax" yank (time tmax) < 
      IF (hM) noblanklines "msgComm" "File" yank (qFile) save
      ELSE " msgSave: unable to save messages " date + . nl
         (hM) two indent . nl
      THEN 
      msgRel
   end

   inline: msgToc ( --- ) \ show all the messages
\     Completion status: Released
      time ctime -3 indent . 
      " Messages in " "msgComm" "File" yank ":" cat cat .
      msgComm (hM) msgRel (hM) any?
      IF (hM)
      ELSE "no messages"
      THEN two indent nl .
   end

\-----------------------------------------------------------------------

\  Initial channel for msgcomm and msghold is public.
   msgPub msgChn

\  Sat Jun 15 10:32:49 PDT 2013.  Save the current time of msgcomm; to
\  be used at start up to test its age (mytops/usr/uboot.v, word START):
   "msgComm" "File" yank filetime "msgComm" "ftime" bank

\-----------------------------------------------------------------------

\  Words to watch files.

   inline: BUSY ( --- addr) \ global busy flag for all watch words
\     Used to constrain sampling to one watch word at a time, so con-
\     secutive lines in DGLOG are for that word.
      [ scalar "busy" book, no busy ! ] busy (addr)
   end

   inline: dir_watch (qToPath qDir qWord --- ) \ watch files in Dir
{     This word makes a word called Word to watch creation, deletion,
      and modification of files in Dir.  Running Word in the multitasker
      allows continuous monitoring of the files in Dir.  

      This word looks at file times, while word file_watch looks at 
      file sizes.

      Example. Making a directory-watch word D1 and starting it at 
      sample rate 4 Hz:

         "/tmp" "/home/ftp" "D1" dir_watch
         4 (Hz) "D1" PLAY

      While the directory-watch word runs and new files appear in Dir, 
      or existing ones change or disappear, an action word in the cre-
      ated directory-watch word is fired.

      The action word receives lists of new and changed files (hFnew),
      and files gone since the last sample (hFgone), under the follow-
      ing stack diagram:

         Action (hFnew hFgone --- )

      As examples, the action word might examine list Fnew and set a 
      file-watch word to monitor changes in a new file or in a changing
      file; or, the action word might deactivate a previous file-watch
      word when the file it is watching is reported gone.

      The ptr to an action word is banked into each directory-watch
      word, so any variety of actions can be taken.  To bank the ptr to
      an action word into a directory-watch word, say one called D1, a
      phrase of the following form is used:

         "Start_dogs" ptr "D1" "Action" bank

      where Start_dogs is the action word, and it has the stack diagram:

         Start_dogs (hFnew hFgone --- )

      This program allows changes at any time to items in a word's local
      library, even while it is running under the multitasker.  So while
      a directory-watch word runs, a new action word can be banked into
      its library and the new action will immediately take effect, as in

         "More_dogs" ptr "D1" "Action" bank

      The default action word, in any directory-watch word created, is
      the ptr to 2drop, to drop the two incoming lists from the stack.
      Thus a directory-watch word will run with no action word banked,
      and simply report changes in log file DGLOG.

      The default name of file DGLOG is built into dir_watch, and can
      be changed by banking a new one into dir_watch before directory-
      watch words are made.  Here is sourcing this file and viewing
      the default DGLOG file name on a user's machine:

         [tops@clacker] ready > "dog.v" source
          word BUSY into catalog
          word dir_watch into catalog
          word file_watch into catalog

         [tops@clacker] ready > "dir_watch" "DGLOG" yank .
         /home/dale/dirwatch.log

      File-watch words use the same DGLOG file name, so all logging is 
      in consistent time order.  The global flag BUSY is used to con-
      strain logging to one word at a time.

      ToPath is where file-watch words, started by the directory-watch
      words, will write their watched-file results.

      Notes on file time.

         For directories on a network, the time for a file just written 
         can vary from the machine's clock time.  To overcome this pro-
         blem, word net_file_time is used to determine the time delta 
         needed to add to file times to align them with machine time.  

         The file time delta, dT, is determined only when Word is cre-
         ated.  If Word is used to monitor a directory on a network, 
         accurate dT is important.  To keep dT current, it may be re-
         quired to run word net_file_time periodically and bank an up-
         dated dT into Word (perhaps by a word running under the multi-
         tasker).

         Note that word filetime gives modification times, and will not
         catch the case where the date is preserved while a file is 
         copied or moved within a directory.  But word filectime will 
         catch such cases, and it is used below.
}
      [ "HOME" env "/dirwatch.log" + "DGLOG" book \ default log file

       {" A local word to characterize the directory:
          Dir dirnames Dir nose (hFname) dup

          (hFname) filectime \ catches cp and mv with preserved dates
          dT plus            \ clock delta added to file times 

          dup totals ontop (hFname hFtime nTag)
       "} "tag" book

       {" This is the text for Word to be created:
         [ "" is ToPath, "" is Dir, no is seen, no is gone

           "dir_watch" "tag" yank "tag" inlinex

           "dir_watch" "DGLOG" yank "DGLOG" book \ get log file name
           "2drop" ptr "Action" book             \ set default Action

           defname is myName
         ]
           BUSY @ IF return THEN yes BUSY !
           Dir dir?
           IF seen not
              IF yes is seen
                 time "Time" book
                 tag (hFname hFtime nTag)
                 "Tag" book "Ftime" book "Fname" book
              ELSE
                 time "Time1" book
                 tag (hFname hFtime nTag) 
                 "Tag1" book "Ftime1" book "Fname1" book

                 Tag Tag1 <> \ has Tag changed?

                 IF SYSOUT (S) push DGLOG set_sysout \ write to DGLOG

                  \ Files with times later or same as last time must 
                  \ have changed or are new:
                    Fname1 Ftime1 Time those rows repeat >=
                    rake lop (hT) any?
                    IF (hT) time ctime . sp
                       myName ": dir_watch files new or changed:" + . nl
                       these rows 1st 
                       DO this I quote strchop its dir? 
                          IF "" catpath THEN three spaces . . nl
                       LOOP (hT)
                    ELSE VOL tpurged (hT)
                    THEN (hT) "Fnew" book
      
                  \ Files from last time that have disappeared:
                    Fname dup filesize 0<
                    rake lop (hT) any?
                    IF (hT) time ctime . sp
                       myName ": dir_watch files gone:" + . nl
                       dup chop three indent . nl
                    ELSE VOL tpurged (hT)
                    THEN (hT) "Fgone" book

                    flush_sysout
      
                  \ Resume SYSOUT before running the action word, since
                  \ it may have its own log file:
                    pull (S) set_sysout \ resume writing to SYSOUT

                  \ Running the action word:
                    Fnew Fgone Action exe

                  \ Advance the references, forgetting the past:
                    Fname1 "Fname" book
                    Ftime1 "Ftime" book
                    Time1 "Time" book
                    Tag1 "Tag" book
                 THEN
              THEN

           ELSE gone not
              IF yes is gone
                 SYSOUT (S) push DGLOG set_sysout \ write to DGLOG
                 time ctime . sp 
                 myName ": subdirectory gone: " + . nl
                    Dir . nl
                 pull (S) set_sysout \ resume writing to SYSOUT
              THEN
           THEN 
           no BUSY !
       "} into Ftext
      ]
      other other (qToPath qWord) alike
      IF " dir_watch: ToPath must be different from Dir"
         " (and ToPath must not be within Dir, or logged activity will"
         " generate more and more activity; this is not checked)"
         + + sp COLS .out nl "" ersys return
      THEN
      (qWord) "Word" book
      CATMSG (f) no catmsg
      Ftext Word inlinex \ making Word
      (f) catmsg

      (qDir) "" catpath dup (qDir)

      (qDir) Word "Dir" bank              \ banking Dir name into Word

      (qDir) dup "test" + fallow 
      IF net_file_time    \ newtork dT
      ELSE (qDir) drop 0  \ can't test; set dT to zero
      THEN Word "dT" bank \ banking file time delta

      (qToPath) Word "ToPath" bank \ banking the to-path for file_watch
   end

   inline: file_watch (qToPath qFile qWord --- ) \ save file on deletion
{     This word makes a word called Word to watch creation and deletion
      of File.  Running Word in the multitasker will monitor the comings
      and goings of File.

      This word looks at file sizes, while word dir_watch looks at 
      file times.

      As File is deleted or rendered smaller, its contents that were
      captured while it was being watched are written to another file
      at ToPath.

      Example:
         Making file_watch word f1 to watch for arrival of a particular
         file:
            "/home/data/" "/home/ftp/newdata.c" "f1" file_watch

         This line starts f1 in the multitasker to continuously grab
         new portions of file /home/ftp/newdata.c as it grows, and save 
         everything collected if it disappears:
            4 (Hz) "f1" PLAY

         When newdata.c arrives, f1 will capture newer portions of it 
         in memory it as is being written.  

         When /home/ftp/newdata.c shrinks or disappears, f1 will write 
         its memory contents to file newdata.c.1, at /home/data.  

         It then continues watching for another instance of newdata.c.

         Note that nothing will be saved at /home/data if the file
         being watched never shrinks or disappears.
}
      [
       {" This local inline saves the captured text to file at ToPath:

         hFile filetrue not IF no is seen return THEN
         hFile close

         nl time ctime . sp "myName" local .
          ": " . File . " saved;" . no is seen

         ToPath File -path catpath
         "." count suffix cat (qF) this deleteif

         (qF) T chars .i " bytes to " . dup . nl
         (qF) forn binary "hFile" open hFile any?

         IF (hFile) T over fput (hFile) close
         ELSE " save: invalid file handle" . nl
         THEN

       "} "save" book

       {" This is the text for Word to be created:
         [ "" is ToPath, "" is File, no is hFile, no is fptr
           no is count, no is T, no is seen

           "dir_watch" "DGLOG" yank "DGLOG" book

           "file_watch" "save" yank "save" inlinex

           defname is myName
           VOL tpurged into T \ initialize
         ]
           BUSY @ IF return THEN yes BUSY !
           SYSOUT (S) push DGLOG set_sysout \ write to DGLOG
           File file?
           IF File filesize one > \ bigger than one byte
              IF seen not
                 IF yes is seen
                    time ctime . sp 
                    myName ": " File " here" cat cat cat .

                    hFile filetrue IF hFile close THEN
                    File old binary "hFile" open, hFile any?

                    IF (hFile) INF fget (hT) into T
                       hFile fpos into fptr
                       count tic into count
                    ELSE no is seen " open failed" . 
                    THEN nl

                 ELSE
                    File filesize dup fptr <
                    IF \ file has shrunk; save the grabbed bytes:
                       (filesize) drop save
                    ELSE \ if file is growing, grab latest bytes:
                       (filesize) fptr >
                       IF \ file is growing; must close and reopen
                          \ to get the size right in hFile:

                          hFile filetrue IF hFile close THEN
                          File old binary "hFile" open hFile any?

                          IF (hFile) fptr fseek \ to end of prev fget
                             T hFile INF fget (hT) park into T
                             hFile fpos into fptr
                          ELSE time ctime . sp 
                             myName ": " File cat cat .
                             " open failed after size" . nl
                          THEN

                       THEN
                    THEN
                 THEN
              ELSE save \ file has shrunk; save the grabbed bytes
              THEN
           ELSE \ file gone; save the grabbed bytes if seen:
              seen IF save THEN
           THEN 
           pull (S) set_sysout \ resume writing to SYSOUT
           no BUSY !
       "} into Ftext
      ]
      (qWord) "Word" book
      CATMSG (f) no catmsg
      Ftext Word inlinex \ making Word
      (f) catmsg
      (qFile) Word "File" bank \ banking File name into Word
      (qToPath) Word "ToPath" bank \ banking the to-path for saved bytes
   end

   pull catmsg halt

\-----------------------------------------------------------------------

;  Appendix.

   Example.  See man msgPoll example usage: creating three poll words 
   (manny, moe and jack), then sending a message to manny, to have him
   send a message to moe, telling moe to add 1 and 2.

   Example 1.

   This example shows some behavior of a word created by msgPoll.

   It explores how a message acknowledgment task (Ack) and a cyclic 
   task (Cyc) performed by msgPoll words can be installed into them, 
   and shows some simple control of behavior using messages sent.

   To run Example 1, first source its Part 1 using this phrase:

      "dog.v" "Part 1." msource

   Loading Part 1 creates word D1 and starts it running every four
   seconds.

   Then move down to Part 2 and copy and drop the phrases there to 
   affect word D1, now running.

\  ------------------------------------------------------------------
   Part 1.

   "msgPoll" missing IF "dog.v" source THEN
   "ranint" missing IF "math.v" source THEN

   "D1" msgPoll

\  Banking a message acknowledgement task into D1:

   inline: ackD1 (qName --- ) \ acknowledgement
\     D1 acknowledging receipt and time.
      drop "D1: received on " time ctime cat nl . nl
   end

   "ackD1" ptr "D1" "Ack" bank

\  Banking a cyclic task into D1:

   inline: cycD1 (qName --- ) \ cyclic task
{     D1 showing a random sample of some data in its library.
      This task is performed on every cycle.

      A ptr to this word is in D1's libaray and is run by D1.  But 
      this word still cannot see anything in D1's libary.  It needs 
      words bank and yank as used below to access the library of D1 
      where its ptr resides.
}
      drop "D1" "DATA" yank (hDATA) \ yank DATA from D1
      (hDATA) 1st those rows ndx 6 1 ranint reach (hdata)
      "D1" . (hdata) .i nl

      [ 1 1000 uniform "D1" "DATA" bank ] \ bank initial DATA into D1
   end

   "cycD1" ptr "D1" "Cyc" bank

\  Starting D1 running at 1/4 Hz:

   1 4 / (Hz) "D1" PLAY

   private halt

\  ------------------------------------------------------------------
   Part 2. 

\  Things to run while D1 is running:

\  Shows D1 running at 0.25 Hz:
   tasks 

\  Sending D1 a message to negate its DATA (remember there is a lag of 
\  up to 4 seconds since D1 is running at 1/4 Hz): 
   "DATA negate 'DATA' book" "D1" msgPut \ D1 will acknowledge

\  Sending D1 a message to turn its cyclic task off (an alternative
\  to just directly banking noop as in: "noop" ptr "D1" "Cyc" bank):

   '"drop" ptr into Cyc' "D1" msgPut \ D1 will acknowledge

\  Shows D1 still running (its just not doing the cyclic task):
   tasks 

\  Sending D1 a message to turn cyclic task back on:
   "'cycD1' ptr into Cyc" "D1" msgPut \ D1 will acknowledge

\  Changing D1's rate:
   1 2 / (once every two seconds) "D1" PLAY
   1 4 / (once every four seconds) "D1" PLAY

\  Stopping D1 entirely, and starting it again:
   "D1" SLEEP 
   tasks
   "D1" WAKE 

\  D1 Gone completely:
   "D1" OMIT
   tasks

   private halt

\-----------------------------------------------------------------------

   Appendix.

   Obsolete words.

  _inline: msgGetIP (qS qIP nPort --- hM) \ get msgs for S at IP(Port)
{     Connect to this program's HTTP server at IP(Port) and get the
      messages for S from the remote interprocess message file.

      Received messages S(M) are removed from the remote's message file.

      Note: This word requires REMOTE_CONNECT1 which is not generally
      available.  It is here for example only, showing how output is
      diverted to a temporary log file while a connection is made.  If 
      there is an error, the log file is displayed before it is deleted
      when the word returns.
}
      [ -1 "S" book ] \ socket to remote HTTP server

      "PORT" book "IP" book
      S -1 > IF S sclose THEN

      SYSOUT "SYSOUTsav" book \ record connection to log file
      ftempsys (qLOG) dup "LOG" book (qLOG) set_sysout

      IP PORT REMOTE_CONNECT1 (nS) \ connection on socket S

      SYSOUTsav set_sysout

      (nS) dup 0< 
      IF LOG asciiload . nl \ display log file
         " msgGetIP: connection from X failed" "X" IP strp . nl
         (qS nS) 2drop 
         
      ELSE " msgGetIP: connected to " IP + . nl
         (nS) "S" book

         (qS) strchop quoted " msgGet remotefd remoteput" + (qT) 

         (qT) dup push S remoterun1 (hT)
         " msgGetIP sent: " . pull (qT) . nl

         (hT) any?
         IF " msgGetIP OK: " . nl dup 3 indent . nl (hT)
         ELSE " msgGetIP: no message" . nl VOL tpurged
         THEN 

         -1 S sclose "S" book
         " msgGetIP: connection closed" . nl
      THEN
      LOG delete (hM)
   end

  _inline: msgPeek (qS --- hM) \ sneak a peek at messages for S
{     Completion status: Released

      Messages remain on the message file.
      M has zero rows if there are no messages for S.
      Works even if there is a Hold on the messages. 

      Change notes.

      Sun Mar  2 09:39:28 PST 2014.  Use program scratch file instead
      of ftempsys.

      Sat Feb 26 10:46:57 PST 2011.  Better control of error so this 
      word works as it always has.  With error output added Feb 21,
      multiple attempts to peek at S cause latency and error output.
      Most of the time it is ok if S is not present and empty M (not 
      found) is a valid response, so this word should work as it has
      always.  

         Use EOP and TRIES>0 to enable error output and multiple 
         attempts to see S.  IMPORTANT: They must be set every time 
         this word is used where such behavior needed:

            Set EOP to yes for error output.
            Set TRIES>0 to make more than one attempt for messages S.
 
            Examples:
               Give error output (postfix and infix shown):
                  yes "msgPeek" "EOP" bank
                  msgPeek.EOP = yes;
        
               Make three delayed attempts to peek at S:
                  3 "msgPeek" "TRIES" bank

               Set delay time between attempts to 1.5 seconds (initial
               delay time, SEC, is 2 seconds):
                  msgPeek.SEC = 1.5;

      Mon Feb 21 16:29:54 PST 2011.  Add error output to the three
      branches where message S is not found.

      Mon Feb 21 08:42:42 PST 2011.  On very rare occasions (weeks and
      months apart), usage at a particular site produces empty M for
      message S even though S is on the message file with a valid mes-
      sage M.  It is not known which of the three ELSE branches in the 
      phrases below produce bogus empty M (given by empty quotes ""). 
      Since it might be a latency problem making the message file un-
      available while another process is rewriting it (the message file
      is written by word msgSave), phrases to idle and reenter this word
      multiple times have been added.

      Tue Dec 14 10:51:42 PST 2010.  Copy the message file to a scratch
      file before running asciiload, since hold is not run and another
      process can change its length while asciiload runs function 
      fileload(), resulting in a file error.
}
      [ 0 "TRIES" book, 0 "TRY" book, no "EOP" book, 2 "SEC" book 
        '(n --- ) 1 = IF " try " ELSE " tries " THEN .' ".tries" macro ]

      (qS) strchop
      0 "ERR" book

      "msgComm" "File" yank scratch fcopy
      scratch asciiload scratch deleteif chop noblanklines (hM) any?
      IF this 1st word drop (S1 hM) them grepe any?
         IF (S1 hM hRows) those rows teeth rake (S1 hM0 hM1) drop
            (S1 hM0) over (S1) chars tic negate indent chop (S1 hM)
            (S1 hM) "_" rot + naming (hM)
         ELSE (S1 hM) 2drop VOL tpurged 1 "ERR" book
         THEN (hM)
      ELSE (qS) drop VOL tpurged 
         2 "ERR" book
      THEN (hM)
      
      TRIES 0= IF return THEN

    \ This section is run if TRIES>0:
      1 TRY incr
      (hM) any? not \ retry if M is an empty string
      IF TRY TRIES <=
         IF EOP
            IF " msgPeek: ERR=" ERR intstr + " for msg " + S + . 
               sp date . nl 
            THEN
            SEC idle S msgPeek (hM) \ reenter this word
         ELSE EOP
            IF " msgPeek: no msg " S + " after" + .  TRY .i 
               TRY .tries date . nl
            THEN 
            VOL tpurged (hM) \ failed after TRY
            (hM) 0 "TRIES" book 0 "TRY" book no "EOP" book 
         THEN (hM)
      ELSE (hM) 0 "TRIES" book 0 "TRY" book no "EOP" book
      THEN (hM) 
   end

  _inline: msgPeekIP (qS qIP nPort --- hM) \ peek at S msgs on IP(Port)
{     Connect to this program's HTTP server on IP(Port) and peek at the
      messages for S that are on the remote interprocess message file.

      Received messages S(M) remain on the remote's message file.

      Note: This word requires REMOTE_CONNECT1 which is not generally
      available.  It is here for example only, showing how output is
      diverted to a temporary log file while a connection is made.  If
      there is an error, the log file is displayed before it is deleted
      when the word returns.
}
      [ -1 "S" book ] \ socket to remote HTTP server

      "PORT" book "IP" book
      S -1 > IF S sclose THEN

      SYSOUT "SYSOUTsav" book \ record connection to log file
      ftempsys (qLOG) dup "LOG" book (qLOG) set_sysout

      IP PORT REMOTE_CONNECT1 (nS) \ connection on socket S

      SYSOUTsav set_sysout

      (nS) dup 0<
      IF LOG asciiload . nl \ display log file
         " msgPeekIP: connection from X failed" "X" IP strp . nl
         (qS nS) 2drop

      ELSE " msgPeekIP: connected to " IP + . nl
         (nS) "S" book

         (qS) strchop quoted " msgPeek remotefd remoteput" + (qT)

         (qT) dup push S remoterun1 (hT)
         " msgPeekIP sent: " . pull (qT) . nl

         (hT) any?
         IF " msgPeekIP OK: " . nl dup 3 indent . nl (hT)
         ELSE " msgPeekIP: no message" . nl VOL tpurged
         THEN

         -1 S sclose "S" book
         " msgPeekIP: connection closed" . nl
      THEN
      LOG delete
   end

  _inline: msgPutIP (hM qS qIP nPort -- ) \ put new msg S(M) at IP(Port)
{     Connect to this program's HTTP server at IP(Port) and put message
      M for S on the remote interprocess message file.

      If M is a text VOL, only the first line is taken.

      Note: This word requires REMOTE_CONNECT1 which is not generally
      available.  It is here for example only, showing how output is
      diverted to a temporary log file while a connection is made.  If 
      there is an error, the log file is displayed before it is deleted
      when the word returns.
}
      [ -1 "S" book ] \ socket to remote HTTP server

      "PORT" book "IP" book
      S -1 > IF S sclose THEN

      SYSOUT "SYSOUTsav" book \ record connection to log file
      ftempsys (qLOG) dup "LOG" book (qLOG) set_sysout

      IP PORT REMOTE_CONNECT1 (nS) \ connection on socket S

      SYSOUTsav set_sysout

      (nS) dup 0< 
      IF LOG asciiload . nl \ display log file
         " msgPutIP: connection from X failed" "X" IP strp . nl
         (hM qS nS) drop 2drop 
         
      ELSE " msgPutIP: connected to " IP + . nl
         (nS) "S" book

         (hM hS) swap 1st quote notrailing quoted spaced
         swap strchop quoted + " msgPut" + (qT) \ phrase: "M" "S" msgPut

         (qT) "T" book 

         T " ACK" + S remoterun1 (f)

         IF " msgPutIP OK: " ELSE " msgPutIP FAILED: " 
         THEN T + . nl

         -1 S sclose "S" book
         " msgPutIP: connection closed" . nl
      THEN
      LOG delete
   end

