\ {{{1 GNU General Public License
{
Program Tops - a stack-based computing environment
Copyright (C) 1999-2014  Dale R. Williamson

Author: Dale R. Williamson <dale.williamson@prodigy.net>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
1}}} 
}

{ File key.v  June 1999

   Copyright (c) 1999-2014   D. R. Williamson

   Sourcing this file locks the program in an endless loop, accepting 
   keyboard input and running words until word bye, exit, or quit.

   Word console created below is where the program is running when
   connected interactively.
}
{ ----------------------------------------------------------------------

   Contents:

   Use these to obtain the following list of contents:
      syspath "key.v" + asciiload this " inline:" grepr reach dot
      syspath "key.v" + asciiload this " define:" grepr reach dot
      syspath "key.v" + asciiload this " function " grepr reach dot

   inline: console ( --- ) \ interactive keyboarding
   inline: cprompt ( --- qS) \ the prompt string of word console
   inline: clear ( --- ) \ clear window, cursor at Home
   inline: ESC? (nKEY --- f) \ flag f is true if KEY is the ESC key
   inline: getch1 (s --- n) \ get key n in s seconds or get n = 0
   define: __getch1 1 nulls key_in ; \ used by getch1; must be a define
   define: help (qWord --- ) \ showing stack notation of word
   inline: keyboard_finish ( --- ) \ finish starting the keyboard
   inline: LoadIndex ( --- ) \ loading word source index from file
   inline: MakeIndex ( --- ) \ making index to source of defined words
   inline: mano ( --- ) \ display manual in editor for browsing
   define: manual ( --- hManual) \ fetch the entire manual volume
   inline: numinp (qS --- x) \ input numbers until one is ok
   inline: query (qQ --- qS) \ showing prompt and getting response
   inline: r_num ( --- nD) \ relative number from successive events
   inline: r_num_bank (nD --- ) \ bank number D into r_num
   inline: refs (hT hRef qS --- hR) \ rake of ones at T rows with S+Ref
   inline: sourceof (qWord --- qFile) \ source File of Word
   inline: startswith (qS --- qS1) \ words that start with S
   inline: strinp (qQ --- qS) \ input strings until one is ok
   inline: stty ( --- ) \ set options for standard input
   inline: tabfill (qS f --- ) \ complete string S and display it
   define: textsearch (hT qS --- ) \ search text T for expression S
   inline: timekeys ( --- hT hN) \ times T for key numbers N
   inline: tos_quote ( --- qS) \ the first line in stack display
   inline: whatis ( --- ) \ keep feeding words for their defs
   inline: where (qWord --- ) \ where source and stack diagram of Word
   inline: wherem (qS --- ) \ display a description S within Unix more

---------------------------------------------------------------------- }

   "keyboard" missing IF halt THEN

\-----------------------------------------------------------------------

\  The next line allows this file to be sourced only once:

      "console" exists? IF " console is running" dot nl halt THEN 

\-----------------------------------------------------------------------

\  Final stage of start up for running interactively (finishing the 
\  job that began in function start(), main.c):

   private 

\  Loading keyboard words in this file, and then user words ukey.v last:
   " info: begin keyboard start up" . nl
   "key.v" (this file) "Keyboard words" (see below) msource

\  Word console drives the keyboard when running interactively:

   inline: console ( --- ) \ interactive keyboarding
      [ no is On
        " [Enter]" '[Enter]' naming "[Enter]" book

        "_bin" "prompt" extract, " ready " cat (qS)
        getuid 0= (root?) IF "# " ELSE "> " THEN cat (qS) 
        "ready>" naming makes prompt1

        getuid 0= (root?) 
        IF "## " ELSE ">> " THEN (qS)
        "infix>" naming makes prompt2

        "INFIX IF prompt2 ELSE prompt1 THEN" "prompt" macro

        NL into NLopt \ optional NL, controllable (once) from outside
                      \ by banking zero for NLopt

        0 "Kptr" book \ ptr to word to run before the prompt appears;
                      \ the stack diagram for Kptr word is ( --- )

      ] hide, On
      IF " console is running" dot nl return 
      ELSE set_keyout \ vectoring output to keyboard display
         SYSOUT "fileout" book 
         proghello, yes is On 
         seed0 seedset \ initialize random seed
      THEN 
      nl
      BEGIN prompt accept_keys (0 | qS1 -1)
         IF nl \ NL for phrase about to be run

            (qS1) nohide parse1 hide
            noblanklines 

            [Enter] those rows one =
            IF cat (qS) ELSE pile (hT) THEN (qS or hT)

            fileout set_sysout \ vectoring output to fileout
            nohide 

            (qS or hT) execute (f) \ running postfix text 

            hide
            SYSOUT "fileout" book 

            set_keyout \ vectoring output to keyboard display

            Kptr ptr? 
            IF (f) push Kptr exe nl pull (f) 
            ELSE
               NLopt putch \ NL for prompt (word clear banks zero for 
                           \ NLopt when it runs)
            THEN
            NL into NLopt \ always revert to regular NL
 
         ELSE 
            Kptr ptr? 
            IF nl Kptr exe nl 
            ELSE nl \ NL for prompt
            THEN
            true
         THEN 

         (f) depth one > 
         IF (f) .sf ELSE (f) drop THEN 
         no erp

      UNTIL
   end

   inline: cprompt ( --- qS) \ the prompt string of word console
      "console" "prompt" extract ;

   ercnt 0> 
   IF " info: keyboard start up failed" . nl \ writing on log file 
      set_stderr \ closing log file, opening STDERR
      " Start up failed.  See log file: " . \ writing to display
      '_bin' 'filelog' extract (log file name) . nl
      ARGV "-l" pile  (hT) 'ARGV' 'ARGS' bank  
      halt
   THEN

   " info: starting keyboard" . nl \ writing on log file
   keyboard 
   keyboard_finish

\  Keep console on a separate line: the line shows up in "faulty 
\  phrase" messages.
   console 

   <<
   halt

\-----------------------------------------------------------------------

   Keyboard words

{  Other words that can be used for interactive input.

   Keyboard words defined below and already in the catalog if running 
   interactively:

      numinp - input numbers until one is ok
      query - showing prompt and getting response
      r_num - relative number from successive events
      strinp - input strings until one is ok
      UP - jumping to higher run level with unique prompt and
         separate history: accepting typing until ESC-q (see 
         demo below)

   Related keyboard words defined in other files (to include the words
   from another file, like tex.v, say "tex.v" source):

      choose - spinner to choose a row from text menu T (tex.v)
      datespinner - interactive date prompter (cal.v)
}
\-----------------------------------------------------------------------

   inline: clear ( --- ) \ clear window, cursor at Home
      [ \ Escape sequence for the Home key:
        list: 27 "[" 1st byte "H" 1st byte ; into Home 
      ]
      "console" exists?
      IF zero "console" "NLopt" bank \ deactivates NL this time only
      THEN
      LINES nit 1st DO NL putch LOOP Home putch ;

   inline: ESC? (nKEY --- f) \ flag f is true if KEY is the ESC key
\     Makes sure that ESC is not part of an extended key.  If it is,
\     returned f is false.

    \ Make sure just ESC was pressed, and not an extended key that 
    \ sends ESC followed by other bytes.  Do this by seeing if there
    \ any readable bytes in the stdin socket:
      (nKey) ESC =
      IF 0 (stdin) socket_readable 0>
         IF 0 sflush \ empty the socket
            drop false \ a key like Ins, Home, Del, PgUp was pressed
         ELSE true     \ plain old ESC was pressed
         THEN
      ELSE false 
      THEN (f)
   end

   define: __getch1 1 nulls key_in ; \ used by getch1; must be a define

   inline: getch1 (s --- n) \ get key n in s seconds or get n = 0
      (s) 0.1 max "__getch1" ALARM getch "__getch1" -ALARM
   end

   define: help (qWord --- ) \ showing stack notation of word
\     Typing help with no string on the stack gives a message.
      {"
         Ways to leave:
            bye [Enter]
            exit [Enter]
            quit [Enter]
            Ctrl-D (may have been disabled by: 4 keyignore)
            Ctrl-Z or Ctrl-C if things get out of control

         Getting started:
            hints [Enter] displays hints for learning

            man xxx [Enter] displays the stack diagram and description 
            of word xxx, as in:
                  man parse [Enter]
                  man function [Enter]
                  man constructor [Enter]
            Many of the word descriptions contain examples of use
            that can be copied and dropped at the prompt
      
            topic xxx [Enter] displays lines in manual containing xxx

            Some Unix commands work from the program prompt:
               cd, vi, ls, ll, llr, more
            and Unix-style command recall works at the program prompt
            and [Tab Tab] attempts to finish partial words:
               man r [Tab Tab]

         Search paths used for files (current, usrpath, syspath):
      "} -8 indent (hT)
      "T1" book

      INFIX 
      IF {"

         Copy and drop this phrase at the prompt to run this program's 
         command line help message:
            shell("tops -h | more -d")
         "}
      ELSE 
         {"

         Copy and drop this phrase at the ready prompt to run this 
         program's command line help message:
            "tops -h | more -d" shell
         "}
      THEN
      (ht) -8 indent "T2" book

      no STR stkok IF where return THEN 
      T1      
      pwd usrpath syspath pile pile commas 4 indent (hPaths)
      T2 3 pilen . nl
   end

   inline: keyboard_finish ( --- ) \ finish starting the keyboard
   \  Running user word ureset (if it exists) silently to initialize 
   \  settings (doing this last, after all files have been sourced):

      "ureset" exists?
      IF SYSOUT (qS)            \ saving SYSOUT on stack
         ftempsys (qFile)       \ temp file from system
         (qFile) dup set_sysout \ send output to temp file

         ureset                 \ initializing settings

         (qFile) delete         \ delete temp file
         (qS) set_sysout        \ putting output back to SYSOUT

         ercnt 0>
         IF " ureset: error initializing user settings" ersys
            ureset 
         THEN
      THEN

      keys? \ this flag was just set when word keyboard ran
      IF 
       \ COLS and LINES make inlines the first time they run.  Run them
       \ now so the inlines will be behind the fence (to be made next), 
       \ and will not be shown by whos:
         COLS LINES 2drop 
      ELSE nl \ for node windows, simulate user hitting Enter
      THEN

   \  Protecting words to here from being redefined.
   \  Words after this point will be shown by word whos (word catitems
   \  lists all the words):
      fence

   \  Note: errors after this point are not on log file.

      SYSOUT "log" grepr rows 0> \ last line on log file
      IF " info: keyboard start up complete" . nl
         " info: start up complete" . nl 
      THEN

      set_stdout \ closing log file, opening STDOUT

   \  Deleting the log file if no errors during start up and no -l argv:
      '_bin' 'filelog' extract (log file name)
      "-l" argv chars 0>
      IF (log file name) " log file kept: " . . nl
      ELSE ercnt 0= IF (log file name) deleteif ELSE drop THEN
      THEN

    \ Command line parameter can set infix mode:
      "-i" argv chars 0> IF >> THEN
      "-p" argv chars 0> IF << THEN \ -p trumps all
   end

   inline: LoadIndex ( --- ) \ loading word source index from file
      [ "version1" "IndexFile" yank "IndexFile" book
        4000 "bins" book
      ]
      IndexFile filefound not
      IF MakeIndex \ making new index file if none found
      ELSE (qFile) asciiload (hT)

         (hT) 1st those rows two slash items, 
         those rows teeth rake (hKeys hVals)
         (hKeys hVals) notrailing swap notrailing swap

         (hKeys hVals) bins "%Index" hash_make
      THEN
   end

   inline: MakeIndex ( --- ) \ making index to source of defined words
      [
        {" Some files of defined words:
          boot.v    hash.v    mmath.v    task.v    net.v     clu.v
          matlab.v  pppcon.v  sys.v      ukey.v    dog.v
          cal.v     key.v     recurse.v  tex.v     sparse.v
          file.v    mat.v     perl.v     web.v     uboot.v
          nas.v     math.v    plot.v     signal.v  xterm.v
          ../usr/netbp.v  ../sys/netbp.v ../usr/easy_io.v
          ../usr/nasrun.v ../sys/nasrun.v
        "} words "Files" book

        "rot pile push swap pile pull" "stackem" macro

      \ Utility to strip path from S1 and use S2 if they match;
      \ otherwise, use S1 with full path:
        "(hS1 hS2) that -path that alike IF lop ELSE drop THEN"
        "FileName" macro

        "%Index" "IndexName" book
      ]
      " Making man index..." . 

    \ Constants at start up, defined in file word.p:
      catitems (hT) dup
      (hT) "SNOC" backward tug dup 1st four items catch
      "SNOC" backward grepr reach -5 indent notrailing notag
      "native constant" those rows pileof (hT hKeys hVals)

    \ Words at start up, native words defined in word.p:
      rot (hT) "ITAN" backward tug dup 1st four items catch
      "ITAN" backward grepr reach -5 indent notrailing notag

      "native word" those rows pileof (hKeys hVals)

      stackem

    \ Words from Files:
      Files rows 1st
      DO "./" Files I quote cat dup file?
         IF dup voc swap -path those rows pileof stackem
         ELSE drop
         THEN

         usrpath Files I quote cat dup file?
         IF dup voc swap Files I quote (S1 S2) FileName
            those rows pileof stackem
         ELSE drop
         THEN

         syspath Files I quote cat dup file?
         IF dup voc swap Files I quote (S1 S2) FileName
            those rows pileof stackem
         ELSE drop
         THEN

      LOOP
      (hWords hFiles) 

    \ Sneak in the version and date as the first entry:
      (hWords hFiles) push
      version
      " (" date ")" cat cat cat crowd swap (date hWords) pile \ date
      "version and date" pull (qS hFiles) pile \ phony file place holder

    \ Making index hash:
      "LoadIndex" "bins" extract (bins) "%Index" hash_make

    \ Name of hash index file:
      "LoadIndex" "IndexFile" extract is File

    \ Saving hash index file to syspath/ if allowed: 
      syspath File cat dup fallow
      IF (qFile) yes ELSE (qFile) drop no THEN
      (no | qFile yes) \ on stk: have no, or have file name and yes

      no = 
      IF usrpath File cat dup fallow not \ trying at usrpath
         IF " cannot write index file: " swap cat nl .
            " permission denied" nl ersys return
         THEN
      THEN (qFile)

    \ Saving hash index file:
      %Index hash_Keys 
      %Index hash_Vals 
      pile (hT) 
      (qFile hT) swap again deleteif (hT qFile) save
   end

   inline: mano ( --- ) \ display manual in editor for browsing
    \ Thu Jan 16 18:10:05 PST 2014.  Revised to not run .out.  Former
    \ version is in the appendix.

      [ "_bin" "newman" extract "doc" book
        no is MAN
      ]  
      manual nl (hDoc) eview
   end

   define: manual ( --- hManual) \ fetch the entire manual volume
      "where" missing IF " manual: require word where" ersys return THEN
      "where" "loadm" localrun ;

   inline: numinp (qS --- x) \ input numbers until one is ok
\     Example:
\        " How much? " numinp
      [ "n" 1st byte is n 
        " ok?" is ok? 
        " ain't a number" is nonum
        no is line (place holder for zipback macro made below)]
      "line" book
      BEGIN line accept_keys
         IF its number
            IF lop ok? dot getch ELSE nonum dot getch drop n THEN
         ELSE zero this int$ dot ok? dot getch
         THEN n = this
         IF [ "lop line, out spaces cr dot, cr dot" "zipback" inline ] 
            zipback run 
         THEN not
      UNTIL
   end

   inline: query (qQ --- qS) \ showing prompt and getting response
\     Example: " what? > " query ".  You said " . . 
      accept_keys not IF " " THEN end \ returns a blank if NL response
 
   inline: r_num ( --- nD) \ relative number from successive events
{     Thu Jan 16 04:33:23 PST 2014

      For use in real time, to obtain number D=d2-d1 from two events
      that happened within the last TSPAN seconds.

      Usage:

         Word r_num_bank is used twice for initialization.  Bank the
         first number DX:
            (nDX) r_num_bank

         and within TSPAN seconds, bank the second number DY:
            (nDY) r_num_bank

         If two numbers have been banked as above, then running r_num
         within TSPAN seconds of the second number will return number
         DY-DX on the stack:
            r_num (nDY-nDX)

         Otherwise, r_num will return UDEF:
            r_num (nUDEF)
}
      [ 10 "TSPAN" book \ return D=UDEF when (time-t2)>TSPAN

      \ When step=yes, get ready for another t2 event by setting d1=d2
      \ and t1=time:
        yes "step" book 

      \ Event 1 is earlier than event 2:
           0 "t1" book \ time of event 1
           0 "d1" book \ data of event 1
           0 "t2" book \ time of event 2
           0 "d2" book \ data of event 2
       ]
       time t2 - TSPAN > IF UDEF ELSE d2 d1 - THEN (nD) 
       (nD) dup UDEF = not step and
       IF d2 "d1" book time "t1" book 0 "t2" book THEN
   end

   inline: r_num_bank (nD --- ) \ bank number D into r_num
    \ Thu Jan 16 06:25:59 PST 2014.  Initialize values in r_num.
      time "r_num" "t1" yank - (dt)
      "r_num" "TSPAN" yank (dt dtMAX) <
      IF   (nD) "r_num" "d2" bank, time "r_num" "t2" bank
      ELSE (nD) "r_num" "d1" bank, time "r_num" "t1" bank
           0 "r_num" "t2" bank
      THEN
   end

   inline: refs (hT hRef qS --- hR) \ rake of ones at T rows with S+Ref
{     This is a utility for word where [an obsolete version, now in the
      appendix below], but it may be generally useful.  For general use,
      stack checking is recommended because of pryexe.

      Creates a rake for rows of T that begin with string S followed by
      any of the strings in Ref.  Ref is a list of pointers to strings,
      so pryexe is used to pull each out and put it on the stack.
}
      into w hand into Ref
      (hT) these rows one null "rk" book, Ref rows 1st
      DO these 1st w Ref I pryexe cat cite 0= rk or "rk" book LOOP
      drop rk (hR)
   end

   inline: sourceof (qWord --- qFile) \ source File of Word
      %Index swap hash_lookup drop any?
      IF 1st quote strchop ELSE "" THEN
   end

   inline: startswith (qS --- qS1) \ words that start with S
      yes "tabfill" >stk noblanklines any?
      IF 1st those rows nit items reach ELSE "" THEN
   end

   inline: strinp (qQ --- qS) \ input strings until one is ok
\     Example:
\        " You stepped on a what? " strinp
      [ "n" 1st byte is n, "  Really? " is ok?,
        "" is line (place holder for macro made below)
        "lop line, out spaces cr dot, cr dot" says fast
      ]
      "line" book
      BEGIN line accept_keys not IF "" THEN ok? dot getch n = dup
         IF zipback [ fast "zipback" macro ] THEN not
      UNTIL
   end

   inline: stty ( --- ) \ set options for standard input
{     This word makes terminal line settings when the text window is
      initialized by function keywin() in key.c.

      Original settings are saved and restored upon exit, through
      word clean, defined above.

      Some handy stty commands are:
         stty -a displays current commands
         stty -g gives a string suitable for another stty command

      Warning: running this word in a non-keyboard setting, such as
      under nohup, can cause failure.

      Note: Under AIX (bash, ksh, and csh); and under Linux (bash) this
      word works with word minshell for system commands.  But this word
      using minshell fails to run under a Sun version of unix and tcsh,
      and so minshell has been replaced by word shell (in six places).
}
      [ SBIN "stty " cat into STTY

      \ Saving shell's current stty commands right now:
        STTY "-g > " cat scratch cat shell
        scratch asciiload (hT) scratch delete
        (hT) strchop into shell_sys

        no is reset

      \ Making a local word to later restore these saved shell stty
      \ commands if they are ever reset:
        "reset IF STTY shell_sys cat shell THEN" "clean" macro

      \ Making a local word to later restore this program's saved
      \ stty commands:
        "STTY prog_sane cat shell" "stty_sane" macro
      ]
      reset not
      IF \ this branch runs only once, during keyboard start up:

         SH "csh" <> \ skip csh; it says: /bin/stty: No match.
         IF STTY "erase 0x7F" cat shell THEN \ same as "erase \^?"
       \ IF STTY "erase 0x8" cat shell THEN \ same as "erase \^H"

         STTY "onlcr" cat shell \ newline to carriage return-newline
         STTY "-echo" cat shell \ no key echo; newch() prints it

       \ Saving these program settings for word sane:
         STTY "-g > " cat scratch cat shell
         scratch asciiload (hT) scratch delete
         (hT) strchop into prog_sane

         yes is reset

      ELSE stty_sane \ restoring this program's saved stty commands
      THEN
   end

   inline: tabfill (qS f --- ) \ complete string S and display it
{     This word is run by function tabfill() in key.c, every time the 
      Tab key is pressed while characters are being input.

      Find a unique string in Table that begins with last string in 
      S, and display S with its last string filled out.

      Table to search is the list of words in the Index used by word 
      man (created by MakeIndex), plus words in the current keyboard 
      history, plus file names (with paths) that the program can see.

      (Looking at typing history has been removed, since it confusing-
      ly shows mistyped words.)

      Function tabfill() in key.c sends f=true to here on the second 
      consecutive Tab key press.  When f is true, display all Table 
      entries that begin with string S.
}
      [ "" is Table, 
        "'" '"' cat makes quotes 
        "(qS) quotes chkeep strchop chars any" "quote?" macro

        "" is S2 \ initial entry needed for macro words made next

        {" files ( --- hT) \ local inline to gather list of files

         \ If S2 begins with /, need all files; otherwise, just pwd:
           S2 1st catch quote? IF S2 -1 indent ELSE S2 THEN any?
           IF (S2) 1st catch "/" alike 
              IF seefiles (hAll) 
              ELSE pwd dirnames (hPwd) \ includes directory names
              THEN
           ELSE ""
           THEN (hFiles)

           S2 1st catch dup quote?
           IF dup rev nose right justify
              swap tail left justify
           ELSE drop
           THEN
        "} "files" macro

        {" added ( --- hT) \ local inline for names added to the catalog
           ".d" "newdefs" localrun
           ".e" "newitems" localrun
           pile (hT) \ the following tugs over to the third word:
           left justify " " tug, left justify " " tug, left justify
           notag noq_alike
        "} "added" macro

         200 is toomany
      ]
      true one NUM stkok and, two STR stkok and not
      IF "tabfill" stknot return THEN

      (f) "hint" book, "S" book 

      S its strlen ndx catch " " strcmp 0=
      IF return THEN \ return if S ends with blank

   \  Breaking S into beginning text S1, and endmost string S2:
      S strings one endmost 1st quote strchop is S2
      S 1st that strlen, S2 strlen less items catch is S1

   \  Look for a match to a file name if S2 begins with quote:
      S2 1st catch quote? \ beginning with quote?
      IF S2 its strlen ndx catch
         S2 1st catch alike not \ and not ending with quote?
         IF files 
         ELSE S2 dims blockofblanks
         THEN (hT)

   \  Otherwise, look for a match to a word in the index+library+added:
      ELSE Table chars any not 
         IF %Index hash_Keys (hTindex)

            catitems its 2nd word drop dup
            "INLI" grepr swap
            "DEFN" grepr pile
            reach 3rd word drop notag (hTlib)

            (hTindex Tlib) pile noq_alike "Table" book

         THEN
         Table, added, files three pilen

      THEN (hT)

   \  Looking in Table, T, for exact (grepe) matches to S2:
      (hT) these 1st S2 strlen items catch, S2 grepe (hRows) 

      (hT hRows) these rows toomany > IF true is hint THEN hint 

      IF \ on second Tab press, showing hints:
         (hT hRows) any? 
         IF these rows toomany > 
            IF 2drop toomany int$ " hits is too many" cat nl sp .

            ELSE \ show partial matches
               reach noq_alike alphabetize (hT)
               these chars 33 < those rows 33 20 * < and
               IF vol2str 
                  "hints: " swap cat nl sp COLS .out
               ELSE \ here for wide and many, to avoid .out overflow
                  "hints: " nl sp . nl 3 indent . 
               THEN
               nl
            THEN

            S nl dot 
         ELSE (hT) drop
         THEN 

      ELSE \ looking for partial matches: 

         (hT hRows) these rows toomany >
         IF 2drop toomany int$ " hits is too many" cat nl sp .

         ELSE (hT hRows) reach noq_alike any?
          \ Showing exact, or most likely, match:
            IF (hT) its rows one =

               IF (hT) strchop spaced \ have one match
               ELSE (hT) S2 strmin \ have partial matches to S2
               THEN (qS)

               S2 strlen tic ndx (qS n0)
               that strlen, S2 strlen less
               (qS n0 #n) items catch dot \ display added characters
            THEN
         THEN 
      THEN
   end

   define: textsearch (hT qS --- ) \ search text T for expression S
      [ "******************************************************"
        "******** Enter :q or :q! to close this window ********"
        "******************************************************"
        pile pile onto msg
        "" "S" book, "" "T" book
      ] "S" book "T" book
      T lowercase S lowercase grepr any?
      IF T swap reach
         msg "Lines that contain " S strchop cat ":" cat pile
         swap pile scratch save, scratch _view 
      ELSE S " No match for " dot dot nl
      THEN freed is T, freed is S ; \ don't delete scratch; _view runs 
                                    \ background xterm, and takes a 
                                    \ while to load

   inline: timekeys ( --- hT hN) \ times T for key numbers N
\     Times and keys hit until NL key.  Times are relative to the time
\     of first key hit.
      0 1 null dup (hT hN)
      BEGIN getcht dup NL <>
      WHILE (hT hN t n) 3 roll rot pile rev pile (hT hN)
      REPEAT 
      (t NL) 2drop
      (hT hN) swap dup 1st pry - swap
   end

   inline: tos_quote ( --- qS) \ the first line in stack display
      depth any
      IF ok ontop (f) push ok on
         yes ".sf" >stk (hT)
         pull (f) not IF ok off THEN

         (hT) 2nd reach dup 2nd word drop "number:" alike
         IF "number:" tug -7 indent
         ELSE words 2nd those rows one less items reach
         THEN vol2str neat " tos = " swap cat

      ELSE ""
      THEN
   end

   inline: whatis ( --- ) \ keep feeding words for their defs
\     When studying a text, can type or copy and drop words while
\     this word runs, and it will look them up.
      BEGIN " What word? ([Enter] to quit): "
         query this " " strmatch any
         IF 64 cr0 where nl false ELSE drop true THEN
      UNTIL ;

   inline: where (qWord --- ) \ where source and stack diagram of Word
{     Phrase man xxx actually runs "xxx" where.  For definition of \,
      word where will work: "\" where, while saying man \ will prompt 
      for a continuation line (but man "\" will work, since word 
      unquoted is used below).

      Revised to use word fstr1 to fetch text directly from files 
      instead of loading files into memory.  With long lines, volumes 
      get large because all lines must be as long as the longest.  
      The manual volume loaded into memory got to be about 1.6M.  

      Now nothing big is in memory and response is faster.

      Rev Sat Mar 14 11:08:02 PDT 2009
         Remove query if not found, so wherem does not hang
}
      [ scalar is fnewman, scalar is fautoman, scalar is fappman, 
        scalar is fexpress
      \ Local inlines that open the manual files:

         {" \ general manual:
           fnewman filetrue IF fnewman fclose THEN
           "_bin" "newman" extract filefound
           IF old ascii "fnewman" file fnewman true ELSE false THEN
         "} "fnewman_open" macro

         {" \ auto manual:
           fautoman filetrue IF fautoman fclose THEN
           "_bin" "automan" extract filefound
           IF old ascii "fautoman" file fautoman true ELSE false THEN
         "} "fautoman_open" macro

         {" \ applications manual:
           fappman filetrue IF fappman fclose THEN
           "_bin" "appman" extract filefound
           IF old ascii "fappman" file fappman true ELSE false THEN
         "} "fappman_open" macro

         {" \ express manual, to be phased out:
           fexpress filetrue IF fexpress fclose THEN
           "_bin" (express) "manual" extract filefound
           IF old ascii "fexpress" file fexpress true ELSE false THEN
         "} "fexpress_open" macro
         {"
           SYSOUT "SYSKEY" = IF " Mapping..." . THEN 

           fautoman_open
           IF dup fmapNL "automanNL"  book fclose true is manual THEN

           fappman_open
           IF dup fmapNL "appmanNL"  book fclose true is manual THEN

           fnewman_open
           IF dup fmapNL "newmanNL"  book fclose true is manual THEN

           fexpress_open
           IF dup fmapNL "expressNL" book fclose true is manual THEN

           "%Index" exists? not IF LoadIndex THEN

           SYSOUT "SYSKEY" = IF cr "           " . cr THEN 
         "} "map_files" macro

         {" \ Loading manual for textsearch.  This is only done when a
             \ search is requested.  It is very slow and will get worse
             \ as the manual grows.  Need to write a word, fstr, that
             \ uses new words fmap and fmapNL to avoid loading files.
             \ Word fstr would find all lines containing a string,
             \ similar to the way fstr1 finds all lines that begin with
             \ a certain string.
           " Loading..." .

           "_bin" "automan" extract filefound \ new words
           IF asciiload THEN

           "_bin" "appman" extract filefound \ app words
           IF asciiload pile THEN

           "_bin" "newman" extract filefound \ new words
           IF asciiload pile THEN

           "_bin" (express) "manual" extract filefound \ from express,
            IF asciiload THEN \ being phased out
           left justify, asciify "A. Words" tear lop
           pile

           left justify
         "} "loadm" macro

        72 is def_wid, yes is auto_wid
        false is manual, no is found

        "(w) '__remap' that alike, swap '__reload' alike or" 
        "remap" macro

{       Symbols used to parse tokens (function tokenget()) that act 
        like words, but are not really words in the catalog.  They are 
        symbols for pre-parsing text patterns before they are sent to 
        program function perform():
}       '{ } ( ) \ # {" "} // /* */ {# #}' words into tok_parse

      ]
      hand 1st quote no STR stkok not
      swap strchop these chars 0= rot or
      IF "where" stknot return THEN

      unquoted "w" book
      manual not, w remap or
      IF map_files manual not
         IF " manual unavailable" . nl return
         THEN w remap IF return THEN
      THEN
      [
        "a decimal number input will go to top of stack in 64-bit IEEE"
        " floating point form (52 mantissa bits, 11 exponent bits)"
        cat
        "itsaNumber" book
      ]
      auto_wid IF COLS ELSE def_wid THEN "wid" book

      w number
      IF drop (qN) cr " Entry for " w ":" cat cat dot nl
         two spaces dot w " ( --- " w ") " cat
         itsaNumber cat cat cat wid .out nl

         two spaces dot w " related: zero, one, two, ... ten, GIJILLION"
         cat wid .out nl
         return
      THEN

      fautoman_open
      IF dup automanNL w spaced fstr1 swap fclose
      ELSE no no blockofblanks
      THEN

      fappman_open
      IF dup appmanNL w spaced fstr1 swap fclose
      ELSE no no blockofblanks
      THEN

      fexpress_open
      IF dup expressNL w spaced fstr1 swap fclose
      ELSE no no blockofblanks
      THEN

      fnewman_open
      IF dup newmanNL w spaced fstr1 swap fclose
      ELSE no no blockofblanks
      THEN

      \ Displaying w info for the four sets of strings:
      four pilen any?  
      IF " Entry for " w ":" cat cat dot nl 
         0 those rows nit ones pile rake
         w chars negate indent pile dup "T" book
         two spaces dot, wid .out
         true is found
 
         \ Showing source of w:
         "%Index" exists?
         IF w sourceof any? 
            IF drop \ " Source for " w ": " cat cat swap cat nl .
               yes "have_source" book
               w missing
               IF w " is not currently in the catalog" cat nl sp . 
               THEN
            ELSE no "have_source" book
            THEN
            tok_parse w grepe rows any
            IF w " is a symbol used to skip over or "
               "gather blocks of text" cat cat nl sp sp .
            ELSE have_source not T "defined:" grepr chars 0= and
               IF " Source for " w " not specified" cat cat nl . THEN
            THEN
         THEN 
         nl
      ELSE no is found
      THEN w 1st that strlen nit ndx crop
      this strlen 1000 > (change 1000 to 1 to reinstate recursion)
      IF "where" main \ recursing with last character lopped off
      ELSE trash found not
         IF " No man entry for word " w cat . nl
            "%Index" exists?
            IF w sourceof any? 
               IF " Source for " w ": " cat cat swap cat . 
                  w missing
                  IF w " is not currently in the catalog" cat nl sp . 
                  THEN
                  nl
               ELSE w exists?
                  IF w catseq fence_at <
                     IF w " is a word currently in the catalog" 
                     ELSE "word " w cat 
                        " was recently added to the catalog"
                     THEN 
                     cat sp .  nl
                  ELSE 
                     " Use word topic to search for expressions"
                     " in manual" + . nl
                   \ " Search manual for expression? (y,[n]) " query
                   \ strchop lowercase 'y' strmatch 0=
                   \ IF nl loadm w " searching..." . textsearch
                   \ ELSE nl
                   \ THEN
                  THEN
               THEN
            ELSE " Use word topic to search for expressions in manual" 
               . nl
             \ " Search manual for expression? (y,[n]) " query
             \ strchop lowercase 'y' strmatch 0=
             \ IF nl loadm w " searching..." . textsearch 
             \ ELSE nl
             \ THEN
            THEN
         THEN no is found
      THEN
   end

   inline: wherem (qS --- ) \ display a description S within Unix more
\     Sat Mar 14 10:33:02 PDT 2009
\     Use Unix more (or less if present) to display a description of
\     word S that allows backward and forward movement in a text-only 
\     environment, usually with keys like u (up) and d (down).
      [
         " q quit, u up, d down, h help" 
         " ----------------------------" pile "HEAD" book
      ]
      remotefd -1 > \ cannot use Unix function if running remotely
      IF where return THEN 

      quoted " where" + >stk (hT)
      (hT) dup rows depth + 2 + \ lines used, incl stk display depth
      LINES >
      IF (hT) HEAD over pile (hT1)
         (hT1) scratch save
         "_more" "do" yank spaced (qScript) scratch +
         (qS) shell \ running Unix more or less
         X11 not IF nl THEN
         scratch deleteif
         (hT) 1st 5 LINES min items reach .
      ELSE (hT) any? IF . THEN
      THEN nl
   end

   LoadIndex \ load word-source index

\  User key file, ukey.v.  Loading optional user-specific words last:
   "ukey.v" filefound 
   IF source yes "ukey_done" "ans" bank THEN

\-----------------------------------------------------------------------

   private halt

\-----------------------------------------------------------------------
;
   Appendix.

   Here's a demo of word UP that jumps to a run level above the current
   one and begins receiving text (levels 21 and 41--each with its own
   prompt--are visited in this example).  Each run level keeps its own
   history array of typing, which can be recalled on revisits (see 
   key.h, notes on unix command line editing and recalling typed lines).

   The stack diagram for UP is
      UP (qS n --- )
   where S is the quote string for the prompt it brings when it jumps
   to level n+1, as shown below.

 
[user@gutter] /home/dale/proj/sage/sou > sage > myfile
          Tops 0.5
Thu Sep  2 06:36:23 PDT 1999

(This shows nested jumps--to 21, to 41, back to 21, back to home:)
[tops@gutter] ready > " [21 club] > " 20 UP     <<< firing word UP to 21

 [21 club] > runlevel .i                        <<< keying at level 21
 21
 [21 club] > " Typing goes into another history buffer" .
 Typing goes into another history buffer
 [21 club] > "  [41 club] > " 40 UP             <<< firing UP, go to 41

  [41 club] > 1 2 + .i " abc" .                 <<< keying at level 41
 3 abc
  [41 club] > (press ESC-q, return to previous)
 [21 club] > (press Esc-q and back to home)     <<< keying at level 21
[tops@gutter] ready >                           <<< back home


(This shows serial jumps--to 21, back to home, to 41, back to home:)
[tops@gutter] ready > " [21 club] > " 20 UP,   "  [41 club] > " 40 UP

 [21 club] > 1 2 + .i                           <<< keying at level 21
 3
 [21 club] > (pressing ESC-q)                   <<< home, then up to 41
  [41 club] > sp sp sp "Now working at 41" .    <<< keying at level 41
   Now working at 41
  [41 club] > (pressing ESC-q)
[tops@gutter] ready > (home again)              <<< back home
[tops@gutter] ready > bye
        Good-bye
Thu Sep  2 06:39:42 PDT 1999
[user@gutter] /home/dale/proj/sage/sou > 

End demo of word UP

\-----------------------------------------------------------------------

\  Here is an early interpretive version of word console:

   define: console ( --- ) \ interactive keyboarding
      " [Enter]" '[Enter]' naming into [Enter]
      no _bin " ready > " cat 'ready>' naming makes prompt
      BEGIN prompt nl accept_keys
         IF nl [Enter] cat main THEN no
      UNTIL
   end
   console end

{  Here's another style for an inline word.  With this version, saying 
   the word, like console, just puts the executable function on the
   stack; word run is needed to make it go:
}
   "console" ( --- ) {" \ interactive keyboarding
      " [Enter]" '[Enter]' naming into [Enter]
      no _bin " ready > " cat 'ready>' naming makes prompt
      BEGIN prompt nl accept_keys
         IF nl [Enter] cat main THEN no
      UNTIL
      "} swap inline
   console run end

\-----------------------------------------------------------------------

\  Obsolete words or words rewritten.

  _define: bye [ "'        Good-bye ' . nl exit " "U" inline ] U run ;

  _define: manual ( --- hManual) \ fetch the entire manual volume
\     This word looks in word where's library for manual, and if not
\     there it makes word where load the manual (as we can by typing
\     "__remap" where) and then it puts the volume on the stack.

      [ "manual" tagsep "where" cat cat is Manual ] \ where's man name
      Manual libpry (hManual) chars 0= \ is word where's man empty?
      IF "__remap" where THEN \ making word where load the manual
      Manual libpry (hManual) ; \ putting handle to manual on stack


\ Has error with .out, perhaps due to changes for beta character.
  _inline: mano ( --- ) \ display manual in editor for browsing
      [ "_bin" "newman" extract "doc" book
        no is MAN
      ]
      MAN any? not
      IF " Formatting (this takes a while) ..." .
         SYSOUT push scratch set_sysout

         manual nl COLS .out

         scratch asciiload dup "MAN" book pull set_sysout
         scratch delete
      THEN (hDoc) eview
   end



