\ {{{1 GNU General Public License
{
Program Tops - a stack-based computing environment
Copyright (C) 1999-2014  Dale R. Williamson

Author: Dale R. Williamson <dale.williamson@prodigy.net>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
1}}} 
}

\ File math.v  July 1999

\  Copyright (c) 1999-2014   D. R. Williamson

{ ----------------------------------------------------------------------

   Contents:

   Use these to obtain the following list of contents:
      syspath "math.v" + asciiload this " inline:" grepr reach dot
      syspath "math.v" + asciiload this " define:" grepr reach dot

   define: .totals (hV --- ) \ display totals of true and false in V
   inline: _nearest (hX x --- x1) \ fetch x1 from X nearest to x
   inline: 2space (x1 x2 n --- hX) \ n uniform log2 spaces, x1 to x2
   inline: bfind (hV x --- 0 or r -1) \ find index r to value x
   inline: bins1 ( hV hb --- hB) \ vector V items into b bins
   inline: bitand (hV hN --- hU) \ bitwise-and for all bits N in V
   inline: bitor (hV hN --- hU) \ bitwise-or for all bits N in V
   inline: changes (hA --- hA') \ nonzero changes in quantized A
   inline: expspace (x1 x2 n --- hX) \ uniform exponential spacing
   inline: flatten (hV --- hV1)  \ flatten curve V
   define: flips (n --- hF) \ true-and-false vector of n coin flips
   inline: lgaps (g1 nrows --- hG) \ logarithmic gaps; smallest is g1
   inline: logistic1 (ht a x0 xT --- hx hr) \ limited exponential growth
   inline: logspace (x1 x2 n --- hX) \ n uniform log spaces, x1 to x2
   define: ma1 (hA n --- hB) \ n sample moving average, lagged 1 step
   inline: nearest (hX x --- x1) \ fetch x1 from X nearest to x
   inline: newt (ptrFx x1 --- x) \ root x where Fx[x]=0
         inline: Fx (x --- f[x]) \ slope of a parabola at x
   inline: plateaus (hV --- hV1) \ flat peaks of V
   inline: quantize (hV hA --- hA1) \ quantize cols of A to nearest in V
   inline: stepped (Y X --- Y X) \ Y versus X into stepped form
   inline: stepped1 (hY hX nDX --- hY1 hX1)
   inline: sticks (hY hX --- hY1 hX1) \ 0-to-Y verticals at X
   inline: valleys (hV --- hV1) \ flat valleys of V

------------------------------------------------------------------------

   Notes: 

   In C, multiplying 0 by a negative number sets the sign bit, giving 
   -0, as these lines show:

      On big endian machine (aix), sign bit is leftmost:
[tops@bach] ready > 0 -1 * .bin
 10000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000

      On little endian machine (linux), sign bit is 57th:
[tops@gutter] ready > 0 -1 * .bin
 00000000 00000000 00000000 00000000 00000000 00000000 00000000 10000000

      But relational tests in C, such as 0==, must not look at the sign
      bit because this says -0 is equal to 0:
[tops@gutter] ready > 0, 0 -1 * = .i
 -1 (-1 is true, saying -0 equals 0)

      Function display() in tex.c has been tweaked to display -0 as
      0.  But other words, like .m using a C format, will show -0.

---------------------------------------------------------------------- }

   CATMSG push no catmsg
 
   inline: 2space (x1 x2 n --- hX) \ n uniform log2 spaces, x1 to x2
    \ Thu Feb 23 03:09:40 PST 2012
    \ Example: 1 24 items 2 2 24 ^ 23 2space park itext .m
      push, swap log2, swap log2, pull intervals 2^ ;

   define: .totals (hV --- ) \ display totals of true and false in V
      hand these rows bob, totals abs ontop
      " Heads: " . dup int$ . "  Tails: " . - int$ . nl ;

   inline: bfind (hV x --- 0 or r -1) \ find index r to value x
    \ Sun Nov 24 14:53:22 PST 2013

    \ In unordered vector V, find index r to value x. 

    \ Uses sorting and binary search instead of exhaustive search.
    \ Sorting and binary search are very fast, even for short lists. 
    
    \ Returns r and a true flag if x is found, or only a false flag
    \ if x is not found.

    \ If there are duplicates of x, index r may point to any one of 
    \ them.

      (hV x) swap
      (x hV) 1st over rows items park (x hA) yes sort dup (hB)
      (x hB hB) rot (hB x) bsearch (hB r f) 
      IF (hB r) 2nd fetch true (r -1) ELSE 2drop false (0) THEN
   end

   inline: bins1 ( hV hb --- hB) \ vector V items into b bins 
{     The first column of returned B contains bin interval beginning
      value, and the second column of B is the number of items it
      contains.

      Examples:

      (1) Expect about 20% of the values (200 of them) to lie outside 
          the two bins from -.4 to 0 and 0 to +.4:

          1000 1 random 0.5 -d \ randoms -.5 to +.5
          list: -INF -.4 0 +.4 INF ; bins1 nl .m

      (2) Expect about 1000 in each of 10 uniform bins:

          10000 1 random .1 10 uniform bins1 nl .m
}
      yes sort "b" book "A" book

      b 1st those rows items park (hXY) A look
      yes sort INF pile, dup sling \ need INF so sling gets endmost
      swap over rake lop "N" book  \ N is list of bin indices

      1st those rows items swap rake lop 
      no swap pile delta 

      2nd those rows nit items reach (hC)    \ items in bins not empty
      b rows those rows less those cols null \ null mat for empty bins
      (hC hCempty) N b rows teeth tier (hC)

      b swap park (hB)
   end

   inline: bitand (hV hN --- hU) \ bitwise-and for all bits N in V
{     Thu Oct 31 04:14:05 PDT 2013

      Incoming V is a vector of r rows; each row of V has 64 bits.

      Vector N is a list of bit numbers (in the range of the current
      index base, either 0 to 63 or 1 to 64).

      Output vector U is the result of bitwise-and of the bits of V
      that are listed in N.

      Example.  Paste the following line at the ready prompt:
         "math.v" "test_bitand" msource

         test_bitand
            "bitand" missing IF "math.v" source THEN
            {"
               1 1 0 0 1 0
               1 1 1 0 0 1
               1 0 0 1 1 0
               0 1 1 0 0 1
               0 0 1 0 1 0
            "} 6 matread (hA) 1st over cols items (hA hN)
            (hA hN) bitset (hV) dup nl .bin nl
            (hV) list: 1 4 5 ; (hN) dup bend itext neat nl .i nl
            (hV hN) bitand (hU) itext neat nl . nl
         halt
}
      (hV hN) bitget (hA) dup cols negate swap across =
   end

   inline: bitor (hV hN --- hU) \ bitwise-or for all bits N in V
{     Thu Oct 31 04:12:46 PDT 2013

      Incoming V is a vector of r rows; each row of V has 64 bits.

      Vector N is a list of bit numbers (in the range of the current
      index base, either 0 to 63 or 1 to 64).

      Output vector U is the result of bitwise-or of the bits of V
      that are listed in N.

      Example.  Paste the following line at the ready prompt:
         "math.v" "test_bitor" msource

         test_bitor
            "bitor" missing IF "math.v" source THEN
            {"
               1 1 0 0 1 0
               1 1 1 0 0 1
               1 0 0 1 1 0
               0 1 1 0 0 1
               0 0 1 0 1 0
            "} 6 matread (hA) 1st over cols items (hA hN)
            (hA hN) bitset (hV) dup nl .bin nl
            (hV) list: 1 4 5 ; (hN) dup bend itext neat nl .i nl
            (hV hN) bitor (hU) itext neat nl . nl
         halt
}
      (hV hN) bitget (hA) across 0<>
   end

   inline: changes (hA --- hA') \ nonzero changes in quantized A
\     Example:
\        list: 1 1 1 5 5 5 3 3 3 -1 -1 ; dup changes park .m
      delta these 0<> looking ;

   inline: expspace (x1 x2 n --- hX) \ uniform exponential spacing
{     Example: spacings for 25 cm (10 in.) slide rule:
         0 25 9 expspace "  %5.2f" format .
      Also see logspace.
}     tic push no peek ln two listn, rev two listn
      park one pull items ln lerp ;
   
   inline: flatten (hV --- hV1)  \ flatten curve V
{     Best for quantized data; see also plateaus and valleys
      Example: 
         list: 1 1 1.1 2 2 1.5  2 2.1 3 3 ; dup flatten park .m
}     its delta 0= looking ; 

   define: flips (n --- hF) \ true-and-false vector of n coin flips
      (n) one random, -0.5 +d, sign bit ; \ grabbing sign bits

   inline: lgaps (g1 nrows --- hG) \ logarithmic gaps; smallest is g1
{     Tue May 27 04:27:22 PDT 2014

      Logarithmic gaps centered about zero; g1 is the first gap from
      zero, and there are nrows in G.

      Cleanest if nrows+1 is a power-of-two.  Then the first gap is 
      g1 and each gap following is two times the size of the previous. 

      Example: 
         [tops@plunger] ready > 5 15 lgaps .m
           Row 1:     -320
           Row 2:     -160
           Row 3:      -80
           Row 4:      -40
           Row 5:      -20
           Row 6:      -10
           Row 7:       -5
           Row 8:        0
           Row 9:        5
          Row 10:       10
          Row 11:       20
          Row 12:       40
          Row 13:       80
          Row 14:      160
          Row 15:      320
         [tops@plunger] ready >
}
      (nrows) 1+ 2 / (ng)
      (g1 ng) 2 pow (ng^2) dup rev
      (ng^2 g1 ng^2) over * (ng^2 g1 g2)
      rot (ng^2) log2 (g1 g2 n) logspace (hV)
      (hV) dup reversed negate 0 pile swap pile "_G" naming (hG)
   end

   inline: logistic1 (ht a x0 xT --- hx hr) \ limited exponential growth
{     Sat Oct 27 13:05:16 PDT 2012.

      Reference:
         Luenberger, David G., "Introduction to Dynamic Systems," copy-
         right 1979 by John Wiley & Sons, Inc., ISBN 0-471-02594-1, pub-
         lished by John Wiley & Sons, p. 318.

      Returned x(t) is a limited exponential growth function, called a
      logistic function, of the form 

         x(t) = c/[1 + b*e^(-a*t)]          (1)

      where x(t) is the solution to the differential equation

         dx(t)/dt = a*[1 - x(t)/c]*x(t)     (2)

      Returned r(t) is the diminishing instantaneous growth rate, which
      is the coefficient of x(t) in (2)

         r(t) = a*[1 - x(t)/c]              (3)

      Incoming x0 and xT (where xT > x0 > 0) are:
         x0 = initial x; the first value in returned x
         xT = maximum growth of x; the highest possible in returned x

      and constants c and b (where c > b > 0) are given by:
         c = xT
         b = c/x0 - 1

      Digression.  How to get from (2) from (1):

      Regarding the solution of (2) to get (1), the Reference says:

         "the solution of this equation (which is easy to obtain;
         see Problem 1) ..." 

      and Problem 1 suggests:

         "... (using) a suitable change of variable, convert the logis-
         tic equation to a linear first-order differential equation."

      This link to a youtube video ("The Logistic Equation and the 
      Analytic Solution") shows solution of logistic differential
      equation (2) to produce equation (1):

         http://www.youtube.com/watch?v=vsYWMEmNmZo&feature=relmfu

      According to Luenberger (see Reference), the solution is "easy to
      obtain" (but he doesn't show how) so this probably means that only
      wimps will need to watch the video.  

      The rest can just think about it and write out the solution, per-
      haps using "a suitable change of variable" as Luenberger suggests.

      This is done next.

      The approach below is different from the one in the youtube video,
      but of course the end result is the same:

         Assume the variable y where

            x(t) = 1/y(t)                  (4)

         The derivative dx(t)/dt is

            dx(t)/dt = -(dy(t)/dt)/y^2     (5)

         With (4) and (5), change (2) into an equation for new vari-
         able y; it turns out to be a linear first-order differential
         equation that will be easy to solve:

            dy(t)/dt = -a*y(t) + a/c       (6)

         Equation (6) can be solved for y(t) a number of ways; the
         following was obtained using Laplace transforms:

            y(t) = [1 + b*e^(-a*t)]/c      (7)

         where b = c*y(0) - 1 = c/x(0) - 1

         Inverting (7) to transform back to x(t) (by (4)) gives

            x(t) = c/[1 + b*e^(-a*t)]      (8)

         and we're done: (8) matches (1).
}
      (ht a x0 xT) dup "c" book
      (x0 xT) swap (xT x0) / 1- "b" book
      (a) "a" book

      (ht) a negate * e^ b * 1+ -1 ^ c * "_x" naming \ eq (1)
      (hx) 1 over c / - "_r" naming                  \ eq (3)
   end

   inline: logspace (x1 x2 n --- hX) \ n uniform log spaces, x1 to x2
\     Example: 1 10000 8 logspace "  %8.2f" format . (see expspace)
      push, swap ln, swap ln, pull intervals e^ ;

   define: ma1 (hA n --- hB) \ n sample moving average, lagged 1 step
      push one lag pull ma ;

   inline: _nearest (hX x --- x1) \ fetch x1 from X nearest to x
\     Incoming X is a vector of numbers in ascending order.
      says x again, x bsearch trash
      2dup pry (x1) push, tic those rows ndx min pry (x2)
      pull (x2 x1) two listn again x two repeat less abs minfetch
      (hX min row col) drop lop (hX row) pry
   end

   inline: nearest (hX x --- x1) \ fetch x1 from X nearest to x
\     Incoming X is a vector of numbers in ascending order; x is a 
\     column vector or a number.
      hand into x, into X
      list: x rows 1st DO X x I pry _nearest LOOP end
      purged into x, purged into X
   end

   inline: newt (ptrFx x1 --- x) \ root x where Fx[x]=0
{     Approximation of root x using Newton's method.
      ptrFx is the ptr to a word that computes y=F[x]:
            Fx (x --- y).

      Reference: Sokolnikoff, I. S., and R. M. Redheffer,
         "Mathematics of Physics and Modern Engineering,"
         McGraw-Hill, 1958.

      begin man newt
      \ Finding the peak of a parabola by finding where the derivative 
      \ is zero.

         X11 not IF " X11 graphics required" . halt THEN

         "newt" missing IF "math.v" source THEN

         \ Function for newt that returns the derivative of parabola:
         inline: Fx (x --- f[x]) \ slope of a parabola at x
         \  Using a difference equation for the derivative rather than
         \  closed form derivative:
         \     g[x] = B + A*(x - C)^2 (parabola)
         \     f[x] = (g[x+dx] - g[x])/dx (difference equation)

            [ -100 is A, 1e4 is B, 10 is C, 0.1 is dx

              \ Function Gx is the parabola:
              "(x) C - dup star, A star, B plus (g[x])" "Gx" inlinex

            ] dup dx plus Gx, swap Gx less dx slash
         end 

         \ Displaying the parabola and its derivative:
         list: 40 -40 DO I "Fx" "Gx" localrun LOOP ; \ parabola (B)
         list: 40 -40 DO I Fx LOOP ;                 \ derivative (G)
         list: 40 -40 DO 0 LOOP ; 3 parkn            \ line at 0 (R)
         list: 40 -40 DO I LOOP ; plot 
         " Root is where green derivative curve crosses red zero-line" 
         dot nl "Fx" ptr -100 newt " Root: " . .
         pause plotclose
      end man newt

         \ Running newt for a couple of starting locations:
         "Fx" ptr -100 newt
         " Root: " . . " in " . "newt" "count" yank .u " iterations" .

         "Fx" ptr 1000 newt
         " Root: " . . " in " . "newt" "count" yank .u " iterations" .

         \ Result for both starting locations:
         Root:  9.9500E+00 in 2 iterations
}
      [ 1e-4 "delta" book, 1e-4 "eps" book, 1e-6 "teensy" book
        10 is loops
      ]
      "x" book, "Fx" book

      no is failed, zero is count
      BEGIN
         x Fx exe dup "y" book abs eps >
         failed not and
         count loops < and (f)
      WHILE
         x delta plus Fx exe y less \ f(x+delta) - f(x)
         delta slash (slope)    \ slope = [f(x+delta) - f(x)]/delta

         dup (slope) abs teensy >
         IF x y rot slash less "x" book \ next x is x - y/slope
         ELSE drop                                                                  " newt: slope is zero, can't continue" . nl yes is failed
         THEN

         one count bump
      REPEAT
      count loops >= IF " newt: failed to converge" . nl THEN
      x (root)
   end
      
   inline: plateaus (hV --- hV1) \ flat peaks of V
      [ 1e-12 is tiny ] flatten, -INF that 1st reach park bob,
      1st those rows items again push that park bob,
      delta tiny greater rake trash pile pull look ;

   inline: quantize (hV hA --- hA1) \ quantize cols of A to nearest in V
{     Levels in V are unsigned, but signs in A are retained
      Example:
           0.5 10 uniform (hV), " Level every 0.5:" . nl dup .m nl
           list: -1.1 1.3 -1.6 ; list: 2.2 2.9 3.1 ; park (hA)
           dup nl .m quantize nl nl .m
}
\     This version quantizes to nearest:
      dup sign bit push abs "A" book
      abs yes sort "V" book
      A cols 1st DO V A I catch nearest LOOP A cols parkn
      pull (-1, 0) this plus one +d (-1, 1)
      *by, freed is A, freed is V

\     Here is old version; it quantizes to floors, always lower, since
\     word look always returns equal-to or nearest-below:

\inline: quantize (hV hA --- hA1) \ quantize cols of A to floors in V
\      dup sign bit push abs, swap abs, right sort those cows,
\      tic clone back look, pull this plus one, +d *by ;

   end

   inline: stepped (Y X --- Y X) \ Y versus X into stepped form
      dup rows 3 < IF return THEN
      dup  2nd over rows 1- items reach pile 
      swap dup 1 lag 2nd over rows 1- items reach pile
      park yes sort
      1 over cols 1- 1 null pile claw
   end

   inline: stepped1 (hY hX nDX --- hY1 hX1)
{     Show a step in Y data when the interval between successive
      X values (period between X(i) and X(i+1)) is longer than DX.

      Points in X are assumed to be in ascending order, such as
      times in a function Y(X).

      Purpose: for displaying data collected at discrete times, when 
      Y(i) is the last known value until Y(i+1) is later known.  
      A plot of the real time collection process would show Y stepping 
      from Y(i) to Y(i+1) at X(i+1).

      Add new points X(k)=X(i+1)-eps between X(i) and X(i+1),
      where eps = DX * 0.001.

      Add new points Y(k)=Y(i) between Y(i) and Y(i+1).
}
      "DX" book
      (hX) dup 1 endmost 1+ pile \ append an extra point to X

      (hX) dup "X" book
      (hX) delta DX < "F" book

      (hY) dup 1 endmost pile "Y" book \ append an extra point to Y

    \ Added X are at a tiny distance in front of (before) the X(i+1):
      X F rake drop DX 0.001 * - X pile (hX1) 

      Y F -1 lag rake drop Y pile (hY1)

      (hX1 hY1) park yes sort (hA)
      1st over rows 1- items reach \ remove the appended extra point

      (hA) dup 2nd over cols 1- items catch (hY1)
      (hY1 hA) swap (hA) 1st catch (hX1)

      purged "F" book purged "X" book purged "Y" book
   end

   inline: sticks (hY hX --- hY1 hX1) \ 0-to-Y verticals at X
\     Makes Y and X into triplets Y1 and X1:
\        Y1:  0 Yi  0   0  Yj  0   0 Yk  0   ...
\        X1: Xi Xi Xi  Xj  Xj Xj  Xk Xk Xk   ...

      [ list: 0 1 ; makes apart ]
      park yes 2nd sorton, apart claw

      no hand those rows three star, three spikes pile
      1st them rows three star items reach (hRake) push

      swap (hY) peek rows, those rows less, those cols null (hY0)
      swap (hY0 hY) pull tier
      swap (hX) three repeat yes sort
   end

   inline: valleys (hV --- hV1) \ flat valleys of V
      negate plateaus negate ;

   pull catmsg halt

\-----------------------------------------------------------------------

;  Appendix.

   Words replaced by native functions:

  _inline: *diagonal (hA hD --- hA1) \ A1 = A*D, diag D is stored as vec
\     For large square matrices, this is many times faster than the 
\     equivalent phrase >square *.
      hand bend swap hand swap over cols (hD r) repeat *by ;
*diagonal (hA hD --- hA1) multiply square matrix A by matrix D, a diagonal square matrix stored as a column
*diagonal note: note that matrix A must be square
*diagonal related: diagpre, diagpost

   -stkbal \ for one push, branch IF gives two pulls: turn off bal check
   _inline: looking (hV hR --- hV1) \ looking at V(k) when R(k) is true
{     Where R(k) equals 0, set V1(k)=V(j) coinciding with closest
      previous R(j) not equal to 0 (or true), j < k.

      This word forces R(1st)=true.  Otherwise, in real time simula-
      tions past data can receive future values.

      Note: the convention for R is opposite the one for word looking
      in express.
}
      (hR) true over 1st poke
      1st over rows items too push
      rot park back rake lop
      any?
      IF pull look, ELSE pull rows left empty THEN
   end
   stkbal

  _inline: skyline (hA --- hA1) \ A1 is flat at all peaks of A columns
{     Peaks in columns of A are where:
         the value is greater than the previous
         the value is greater than or equal to the next
         and both of these are true.
} 
      dup push cols 1st
      DO peek I catch again
         this one lag >
         that this -1 lag >=
         and looking
      LOOP
      pull cols parkn
   end

  _inline: stats (hC --- hC1) \ C1 holds min, ave, max over cols of C
\     C1 holds min, ave and max taken over the cols of C
      dup bend mean, swap dup min1 1st catch
      rot rot max1 1st catch three parkn
      "_stats" naming
   end

   Words that manipulate things term-by-term should be written in C.
   The following word, tr, is very slow compared to its C counterpart;
   and the C version is much easier to read:

      [tops@gutter] ready > 3000 1 null 1000 +d dup dup 3 parkn is S
      [tops@gutter] ready > time S 3 tr time rot - .i
       10 <<<< took 10 seconds for 3000x3 matrix
      Running the C version, takes 0 seconds

  _inline: tr (hSig n --- hTr) \ exponential trace of signal, Sig
\     Tr(k) = Tr(k-1) + [Sig(k) - Tr(k-1)]/(n+1)
\     Tr(0)=Sig(0)
      xbase push 0based
      "n" book, "Sig" book
      one n tic slash "1/n+1" book
      Sig cols 1st
      DO
         list: 
            Sig 1st I fetch, Sig rows 2nd
            ?DO dup Sig I J fetch over less 1/n+1 star plus LOOP                 end
      LOOP Sig cols parkn
      freed is Sig pull indexbase
   end



