\ {{{1 GNU General Public License
{
Program Tops - a stack-based computing environment
Copyright (C) 1999-2014  Dale R. Williamson

Author: Dale R. Williamson <dale.williamson@prodigy.net>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
1}}}
}
{ File net.v  June 2003

   Copyright (c) 2003-2014  D. R. Williamson

   Words for networking.

   This file works with compiled words from net.c.  File net.c is
   compiled with the -DNET switch in the program Makefile.

   Other network related files of high level words: 
      clu.v Processing on a cluster
      term.v Interactive terminal 

\-----------------------------------------------------------------------

   References:

      1. Stevens, W. R., "UNIX Network Programming Volume 1, Networking
         APIs: Sockets and XTI," second edition, Prentice Hall, 1998.

      2. Stevens, W. R., "UNIX Network Programming Volume 2, Inter-
         process Communications," second edition, Prentice Hall, 1999.

      3. Unix Socket FAQ: http://www.developerweb.net/forum
         Search on Maholski for comments on how to check for readable
         socket, and to determine how many bytes are waiting to be read.

      4. GNU Wget software package for retrieving files:
            http://www.gnu.org/software/wget/

      5. Port assignments:
         http://www.iana.org/numbers.html
         ftp://ftp.iana.org/assignments/port-numbers
         Author's machine: see file iana-port-numbers.txt
         Notes:
            The port numbers are divided into three ranges:
               the Well Known Ports, 0 through 1023
               the Registered Ports, 1024 through 49151
               the Dynamic and/or Private Ports, 49152 through 65535

            The Well Known Ports--0 through 1023-- are assigned by the
            IANA and on most systems can only be used by system (or
            root) processes or by programs executed by privileged users.

      6. Greenwich Mean Time (word NISTdelta):
         http://www.nist.gov/
         ftp://time-a.nist.gov/pub/daytime/
         http://physics.nist.gov/GenInt/Time/world.html
         http://tf.nist.gov/service/acts.htm (shows time code)
         http://tf.nist.gov/service/time-servers.html (server IP addr)

      7. HTTP Explanations:
         http://www.w3.org/Protocols/rfc2616/rfc2616-sec3.html
         http://www.jmarshall.com/easy/http/

------------------------------------------------------------------------

   Contents:

   Use this phrase to obtain the following list of contents:
      syspath "net.v" + asciiload this " inline:" grepr reach dot

   inline: +CLIENT_ALLOW (qS --- ) \ add S to CLIENT_ALLOW.clients
   inline: +SERVER_ALLOW (qS --- ) \ add S to SERVER_ALLOW.clients
   inline: _NISTdelta ( --- sec) \ NIST time minus the machine's time
   inline: _NISTdelta_test ( --- ) \ test the connections for _NISTdelta
   inline: .CLIENT_ALLOW ( --- ) \ display table CLIENT_ALLOW.clients
   inline: .SERVER_ALLOW ( --- ) \ display table SERVER_ALLOW.clients
   inline: ACK ( --- ) \ send acknowledgement to remotefd
   inline: ALLOW (qIP --- ) \ add IP address to allowed-client tables
   inline: BRIDGE (qCNAME --- ) \ connect remote machines
   inline: CLIENT (qIPaddr nPort --- nSocket) \ connect to this prog
   inline: CLIENT_ALLOW (qIP --- f) \ flag f true if IP can connect
   inline: CLIENT_ALLOWING ( --- hT) \ list of client IPs allowed
   inline: CLIENT_F (qIPaddr nPort --- nSocket) \ connect to this prog
   inline: CLIENT_SSL (qIPaddr nPort --- nSocket) \ connect to this prog
   inline: CONNECT_HOST (qHost nPort ptrRun --- nS) \ connect to Host
   inline: CONNECTIONS ( --- ) \ library of connections
   inline: CROSSLINK (nSocket1 nSocket2 qS --- ) \ link two machines
   inline: def_port ( --- nPort) \ default port number
   inline: def_server ( --- ) \ start server listening on default port
   inline: def_server1 ( --- ) \ start server listening on def port+1
   inline: DSERV-DN (nPort --- ) \ shut down server listening on Port
   inline: DSERV-UP ( --- nPort) \ server started, listening on Port
   inline: fremoteget (qFile qFile_to nSocket --- f) \ File from Socket
   inline: fremoteput (qFile qFile_to nSocket --- f) \ File to Socket
   inline: IPhost (qHost --- qIP) \ the IP address for Host
   inline: IPhostr (qS --- qIP) \ randomly fetch IP from multihomed list
   inline: HTTPget (qHost hPathFile --- ... hT) \ get files from Host
   inline: HTTPgetr (qHost qRequest --- hT) \ receive request from Host
   inline: HTTPput (qT nS --- ) \ service request T and put in S
   inline: IPloop ( --- qS) \ loopback IP address
   inline: localsockets ( --- hR) \ local clients connected to remote
   inline: MAXBLOCK ( --- sec) \ time to block a pending socket read
   inline: monkeyIP ( --- qIP) \ query ipmonkey.com for this IP addr
   inline: net_file_time (qDir --- nsec) \ file time latency on network
   inline: new_conn (nS --- ) \ runs when S has just connected
   inline: new_conn_say (nS --- ) \ announce new socket connection
   inline: nfs_load (qFile --- hT) \ an nfs text file to the stack
   inline: nfs_mounts ( --- hT) \ list of nfs mounts on the system
   inline: NIST_DELTA ( --- ) \ sync program time with NIST time
   inline: NIST_SYNC ( --- ) \ sync program time with NIST time
   inline: NISTdelta ( --- sec) \ NIST time minus the machine's time
   inline: PING (qIP --- f) \ f true if Unix ping returns 0% loss for IP
   inline: port_on (nPort --- f) \ f is true if Port is being used
   inline: port_listening (Port --- f) \ f is true if listening on Port
   inline: REMOTE-DN (nP qIP nPORT --- ) \ IP:PORT shut down server on P
   inline: REMOTE-UP (qIP nPORT --- nP) \ IP:PORT started server on P
   inline: REMOTEdelta (nSocket --- sec) \ time remote minus time local
   inline: remoteack (hSockets --- f) \ remotes acknowledge
   inline: remoteclients (nSocket --- hT) \ run word clients on remote
   inline: remotehost (nSocket --- qS) \ name of host at end of Socket
   inline: remotekeys (hT nSocket --- ) \ run the keyboard at Socket
   inline: remoteputf1 (qT nS1 nS2 --- ) \ send T to S1, echoes to S2
   inline: remoteputmat1 \ (hA nSocket --- ); stack on remote: ( --- hA)
   inline: remoteprompt (nSocket --- ) \ run at a prompt on Socket
   inline: remoteprompt_run (qS --- ) \ phrase to run text at remote
   inline: remoteprompt_stk ( --- ) \ phrase to run remote stk display
   inline: remotercv (nS nSec nBytes --- qT) \ receive Bytes in Sec on S
   inline: remoterun1 (hT hSockets --- ...) \ run T on all Sockets
   inline: remotesockets ( --- hR) \ remotes connected to local
   inline: remotestack (nSocket --- hT) \ get stack display at Socket
   inline: remotetasks (nSocket --- hT) \ multitasker tasks at Socket
   inline: remotewhos (nSocket --- hT) \ run word whos on remote
   inline: SERVER-CYCLE ( --- ) \ close and open listening port
   inline: SERVE_F (hT nSocket --- ) \ process a foreign SERVER request
   inline: SERVE_F_TERM ( --- ) \ initialize SERVE_F as TERM type
   inline: SERVER_ALLOW (qIP --- f) \ flag f true if IP can connect
   inline: SERVER_ALLOWING ( --- hT) \ list of client IPs allowed
   inline: serverport ( --- nPort) \ port of local server listening
   inline: servershutdown ( --- ) \ close clients, shut down server
   inline: serverstart (nPort --- f) \ turn server on, listening on Port
   inline: SERVER_WAIT (nSec --- ) \ ignore new connections for Sec
   inline: SHSERVER (nSec --- nPort) \ shell server for Sec on Port
   inline: SNDSERVER ( --- nPORT) \ port of the sound file server
   inline: SNDSERVER_ON ( -- f) \ true if sound file server is listening
   inline: SNDSERVER_RATE (nHz --- ) \ set rate of sound file queuing
   inline: socket_ack (nSocket --- f) \ this program remote acknowledge
   inline: socket_ack1 (nSocket --- f) \ this program remote acknowledge
   inline: socket_check (nS --- ) \ display a check of socket S
   inline: socket_scan (n --- hA) \ scan of the first n sockets
   inline: sockets ( --- hR) \ all connected sockets
   inline: SSLcert (qFile --- hT) \ text of OpenSSL certification File
   inline: TASK_PORT (nWAIT qJ --- hA) \ perform task J, return item A
   inline: TIME_SYNC ( --- ) \ this machine in synch with remote
   inline: time_sync (nS --- f) \ this machine in synch with remote
   inline: wrapHTML (hT --- qT1) \ T wrapped with HTML
   inline: www_open ( --- f) \ f true if connected to the Internet

   Remote word substitutions.
   inline: remote_exit ( --- ) " use Esc-q to exit" . nl ;
   inline: remote_invalid ( --- ) " invalid word on remote" . nl halt ;

   Appendix.
   HTTP server log output from various remotes.
   What an HTTP server receives from Netscape, Wget, and MS IE.
   HTTPget vs. WGET timing test, July 2004 (dial up).
   HTTPget vs. WGET timing test, April 2008 (DSL).

   Obsolete.
}
   "CONNECT" missing IF " Networking words required" . halt THEN
   "msgPeek" missing IF "dog.v" source THEN

\-----------------------------------------------------------------------

   inline: +CLIENT_ALLOW (qS --- ) \ add S to CLIENT_ALLOW.clients
{     Sun Mar  7 16:07:53 PST 2010.  Tables are updated only for the 
      current session.

      Incoming S can be a VOL of IPs, one per row.  Each row can 
      have a second identifier string following the IP address.

      Example:
         "192.168.0.100 diego" (qS1)
         "192.168.0.101 kaffia" (qS1 qS2) pile (hT) +CLIENT_ALLOW
         "CLIENT_ALLOW" "clients" yank .
}
      0 STR stkok 1 VOL stkok or not
      IF "+CLIENT_ALLOW" stknot return THEN

      "CLIENT_ALLOW" "clients" yank any? IF swap pile THEN neat (hT)
      (hT) noq_alike (hT) "CLIENT_ALLOW" "clients" bank 
   end

   inline: +SERVER_ALLOW (qS --- ) \ add S to SERVER_ALLOW.clients
{     Sun Mar  7 16:07:53 PST 2010.  Tables are updated only for the 
      current session.

      Incoming S can be a VOL of IPs, one per row.  Each row can 
      have a second identifier string following the IP address.

      Example:
         "192.168.0.100 diego" (qS1)
         "192.168.0.101 kaffia" (qS1 qS2) pile (hT) +SERVER_ALLOW
         "SERVER_ALLOW" "clients" yank .
}
      (qS) 0 STR stkok (qS f1) 1 VOL stkok (f1 f2) or not
      IF "+SERVER_ALLOW" stknot return THEN

      "SERVER_ALLOW" "clients" yank any? IF swap pile THEN neat (hT)
      (hT) noq_alike (hT) "SERVER_ALLOW" "clients" bank
   end

   inline: .CLIENT_ALLOW ( --- ) \ display table CLIENT_ALLOW.clients
    \ Sat Mar 12 08:23:52 PST 2011
      "CLIENT_ALLOW" "clients" yank . nl
   end 

   inline: .SERVER_ALLOW ( --- ) \ display table SERVER_ALLOW.clients
    \ Sat Mar 12 08:23:52 PST 2011
      "SERVER_ALLOW" "clients" yank . nl
   end 

   inline: _NISTdelta ( --- sec) \ NIST time minus the machine's time
{     This is the first word to use (and test out) TCP/IP socket con-
      nections as they are developed in 2003.

      Sat May 28 11:07:51 PDT 2011.  Compute median instead of average
      when there are more than two samples, to reduce the effect of
      outliers.

      Fri May 27 09:03:07 PDT 2011.  This word is now called _NISTdelta
      (formerly NISTdelta) placing it on a lower level to be called by 
      new word NISTdelta.  See NISTdelta in this file.

      Fetch GMT from the National Institute of Standards and Technol-
      ogy (NIST) web sites and return the difference from the machine's
      GMT.

      These sites are running so-called daytime servers, and they pro-
      vide date and time information on well-known port 13.

      This word fetches GMT from the first "samples" items in the list
      of daytime server IP addresses created below and called IPlist.

      Assumes the machine is connected to the Internet.

      Returns sec=UDEF if error.

      Here is a phrase for timing this word:
         time push NISTdelta time pull less .i nl .m
}
      [ 10 "wait" book      \ max seconds to block each read

        two "TIME_OUT" book \ time out seconds to connect
        no "VERBOSE" book
        no "VERBOSE1" book

{       This macro, called receive, connects to the NIST TCP/IP socket 
        at IPaddr, daytime port 13, and returns the difference between 
        NIST GMT and the machine's GMT:
}       {" (qIPaddr --- delta_sec) \ delta_sec=UDEF if error

           "_NISTdelta.receive 1" ERRset \ Fri Mar 29 11:31:09 PDT 2013

           (qIPaddr) strchop dup "IPaddr" book

         \ Cannot hide connect messages, so put them on ftempsys:
           SYSOUT push 
           ftempsys dup push (ftempsys) set_sysout 
           (qIPaddr) 13 (port) zero CONNECT (nSocket) "S" book

           pull deleteif   \ delete ftempsys
           pull set_sysout \ restore sysout

           ERR \ end ERRset \ Fri Mar 29 11:31:09 PDT 2013

           "_NISTdelta.receive 2" ERRset \ 2

           S 0>
           IF "OK" "OK" \ we are connected!
              VERBOSE1
              IF " NISTdelta: connected to " . IPaddr .
                  " on socket" . S .i nl
              THEN
{
              About 51 bytes from NIST come to function drainf() and
              arrive here on the stack.  The 51 bytes begin with 0Ah
              (newline) and end with 20h, 0Ah (blank, newline).

              Here is an example of the 49 visible bytes:

                 52909 03-09-27 23:09:52 50 0 0 199.7 UTC(NIST) *

              Then NIST sends zero bytes, and drainf() closes the con-
              nection.
}
            \ Receiving bytes from NIST:
              S wait BLOCK (qG)       \ receive remote GMT string G
              time1 (Gmach) "t1" book \ get machine's GMT seconds now

            \ If timed out, drainf() may not have closed S:
              S sclose \ does nothing if S is closed

            \ Is the stack still intact?  Expect (OK OK qG):
              (qG) depth three <
              IF (OK OK) depth dump UDEF ERR return 
              THEN (qG) rev (qG OK OK)

              (qG OK OK) that type STR = that type STR = and not
              IF three dump UDEF ERR return THEN

              (qG OK OK) alike (qG f)
              IF (qG)

               { Extract GMT seconds from remote string on the stack.

                 Word ltime gives GMT seconds, which is the number of
                 seconds in Greenwich, England since 00:00:00 on Janu-
                 ary 1, 1970.
               }
               \ Make Year, month, day string into number YYYmmdd where
               \ YYY is 1900-based:
                 (qG) "1" that 2nd word drop + \ 03-09-27 to 103-09-27
                 (qDate) "-" " " strp chpack   \ 103-09-27 to 1030927
                 number drop (YYYmmdd)

               \ Make Hour, minutes, seconds string into number HHmmss:
                 swap 3rd word drop
                 (qTime) ":" " " strp chpack \ 23:09:52 to 230952
                 number drop (HHmmss)

               \ Compute the difference from the machine's GMT time:
                 (YYYmmdd HHmmss) ltime (GMTworld) \ remote GMT seconds
                 (GMTworld) t1 (Gmach) less (delta_sec)

              ELSE (qG) drop UDEF \ error; return undefined
              THEN

           ELSE UDEF \ error; return undefined
           THEN

           ERR \ end ERRset \ 2

        "} "receive" macro

        depth push

\       Entries with # were found to be unreliable, and are skipped.
\       See word _NISTdelta_test in this file.
\       Last test for # entries: Sat May 28 10:13:41 PDT 2011

\          IP address         Server name
        "192.43.244.18"   \ time.nist.gov
        "129.6.15.28"     \ time-a.nist.gov
        "129.6.15.29"     \ time-b.nist.gov

      # "131.107.1.10"    \ time-nw.nist.gov

        "132.163.4.101"   \ time-a.timefreq.bldrdoc.gov
        "132.163.4.102"   \ time-b.timefreq.bldrdoc.gov
        "132.163.4.103"   \ time-c.timefreq.bldrdoc.gov

        "128.138.140.44"  \ utcnist.colorado.edu

        "69.25.96.13"     \ nist1.symmetricom.com

      # "216.200.93.8"    \ nist1-dc.glassey.com
      # "208.184.49.9"    \ nist1-ny.glassey.com
      # "207.126.98.204"  \ nist1-sj.glassey.com

        "207.200.81.113"  \ nist1.aol-ca.truetime.com
        "64.236.96.53"    \ nist1.aol-va.truetime.com

        depth pull less pilen
        chop "#" " " qreplace asciify noblanklines
        onto IPlist
{

To test manually for connection, use word CONNECT.  CONNECT returns
-1 for socket number if cannot connect.  Here is an example:

   [tops@clacker] ready > "205.188.185.33" 13 0 CONNECT
    connect_timeo: 10 sec alarm timeout
    connect_timeo: 10 sec alarm timeout
    CONNECT: could not connect to 205.188.185.33 in 2 attempts
    fault at word: CONNECT
    faulty phrase: "205.188.185.33" 13 0 CONNECT [Enter]

    stack elements:
          0 number: -1
    [1] ok!
   [tops@clacker] ready >

Information from: http://tf.nist.gov/service/time-servers.html
July 2, 2004

Name    IP Address      Location
time-a.nist.gov         129.6.15.28     NIST, Gaithersburg, Maryland
time-b.nist.gov         129.6.15.29     NIST, Gaithersburg, Maryland
time-a.timefreq.bldrdoc.gov     132.163.4.101   NIST, Boulder, Colorado
time-b.timefreq.bldrdoc.gov     132.163.4.102   NIST, Boulder, Colorado
time-c.timefreq.bldrdoc.gov     132.163.4.103   NIST, Boulder, Colorado
utcnist.colorado.edu    128.138.140.44  University of Colorado, Boulder
time.nist.gov   192.43.244.18   NCAR, Boulder, Colorado
time-nw.nist.gov        131.107.1.10    Microsoft, Redmond, Washington
nist1.symmetricom.com 69.25.96.13 Symmetricom, San Jose, California
nist1-dc.glassey.com    216.200.93.8    Abovenet, Virginia
nist1-ny.glassey.com    208.184.49.9    Abovenet, New York City
nist1-sj.glassey.com    207.126.98.204  Abovenet, San Jose, California
nist1.aol-ca.truetime.com       207.200.81.113  TrueTime, AOL facility, Sunnyvale, California
nist1.aol-va.truetime.com       64.236.96.53  TrueTime, AOL facility, Virginia
}
        IPlist rows "samples" book \ quantity to fetch from IPlist
        86400 10 * "TOO_BIG" book \ too big to believe; ignore result

        UDEF "Tdelta" book
      ]
      "_NISTdelta" ERRset

      depth "DEP0" book \ record the beginning stack depth

      CONNTO (sec_to) "sec_to" book \ save old connection time out
      TIME_OUT (sec) connto         \ set new connection time out

    \ Initialize samples undefined:
      UDEF samples one fill "DELTA" book

    \ Gather samples DELTA:
      samples 1st 
      DO IPlist I quote 
         VERBOSE IF " _NISTdelta contacting " . dup . THEN
         receive 
         VERBOSE IF " received delta: " . dup "%0.3f" format . nl THEN
         DELTA I poke 
      LOOP

    \ Remove undefined samples:
      DELTA these numbad rake trash

    \ Compute the sample median:
      (hDELTA) any?
      IF (hDELTA)
         these rows two >
         IF (hDELTA) yes sort dup rows 2 / 1+ pry (sec) \ median
         ELSE (hDELTA) dup totals swap rows / @ \ average
         THEN (DELTA) 0.5 + integer
      ELSE
         UDEF \ no samples

      THEN (sec) this abs TOO_BIG > IF drop UDEF THEN "Tdelta" book

      sec_to connto \ connection time out back to old

    \ Clean up the stack:
      depth DEP0 > IF depth DEP0 - 1st DO drop LOOP THEN

      Tdelta (sec)

      ERR \ end "_NISTdelta" ERRset
   end

   inline: _NISTdelta_test ( --- ) \ test the connections for _NISTdelta
{     Sat May 28 10:15:43 PDT 2011

      Test the connections to the servers used by word _NISTdelta.

Test May 28, 2011.

[tops@plunger] ready > _NISTdelta_test
_NISTdelta_test: Testing daytime conections Sat May 28 10:13:41 PDT 2011
 1 192.43.244.18  55709 11-05-28 17:13:41 50 0 0 163.5 UTC(NIST) *  
 2 129.6.15.28    55709 11-05-28 17:13:42 50 0 0 941.4 UTC(NIST) *  
 3 129.6.15.29    no data
 4 131.107.1.10   cannot connect
 5 132.163.4.101  no data
 6 132.163.4.102  no data
 7 132.163.4.103  no data
 8 128.138.140.44 55709 11-05-28 17:13:54 50 0 0  18.2 UTC(NIST) *  
 9 69.25.96.13    55709 11-05-28 17:13:55 50 0 0 891.9 UTC(NIST) *  
 10 216.200.93.8   cannot connect
 11 208.184.49.9   cannot connect
 12 207.126.98.204 cannot connect
 13 207.200.81.113 55709 11-05-28 17:14:19 50 0 0 742.2 UTC(NIST) *  
 14 64.236.96.53   55709 11-05-28 17:14:19 50 0 0 541.3 UTC(NIST) *  

In list IPlist of word _NISTdelta (this file), # has been placed beside
entries that cannot connect: 131.107.1.10, 216.200.93.8, 208.184.49.9, 
207.126.98.204.

}
      [ 10 "BLOCKWAIT" book, 2 "CONNWAIT" book ]

      "_NISTdelta_test: Testing daytime conections " . date . nl

      CONNTO push CONNWAIT connto
      "_NISTdelta" "IPlist" yank "IP" book

      IP rows 1st
      DO depth push IP I quote I .i sp dup .   

       \ Cannot hide connect messages, so put them on ftempsys:
         SYSOUT push ftempsys set_sysout
         (qIP) 13 0 CONNECT "S" book
         pull set_sysout

         S 0>
         IF S BLOCKWAIT BLOCK S sclose
            depth peek - 0=
            IF " no data" ELSE asciify THEN
         ELSE " cannot connect"
         THEN . nl
         pull drop
      LOOP
      pull connto
   end

   inline: ACK ( --- ) \ send acknowledgement to remotefd
      yes remotefd remoteput ;

   inline: ALLOW (qIP --- ) \ add IP address to allowed-client tables
{     Tables are updated only for the current session.

      Incoming IP can be a space delimited list of IPs all in one 
      string.

      Example: IP can be a quoted list (string) of IP addresses:
         "192.168.1.254   192.168.1.249" ALLOW
         "SERVER_ALLOW" "clients" yank .
}
      0 STR stkok not IF "ALLOW" stknot return THEN \ must be STR

      (qS) words " ALLOW" tail (hT)
      (hT) dup +CLIENT_ALLOW +SERVER_ALLOW
   end

   inline: BRIDGE (qCNAME --- ) \ connect remote machines
{     Connect the first two machines that are remotely connected to
      this machine.  The sockets for the connection will be named
      CNAME on each of the remote machines.

      For an application of word BRIDGE, see word BRIDGING in file
      usr/uboot.v.
}
      "CNAME" book
      remotesockets these rows one >
      IF this 1st pry swap 2nd pry CNAME CROSSLINK
      ELSE drop " BRIDGE: need two remote connections" ersys
      THEN
   end

   inline: CLIENT (qIPaddr nPort --- nSocket) \ connect to this prog
{     Connect to another instance of this program running a SERVER on
      Port at IPaddr.

      SERVER determines the connection type on its end (LOSERV or 
      FOREIGN) by the first bytes received after connection (drainf(), 
      file net.c).

      SERVER expects the string LOGIN if CLIENT is also this program
      and type is to be LOSERV.

      When string received is LOGIN, SERVER sends it back as acknowl-
      edgment.  This word blocks for the expected read, then uses it in
      clientLOGIN_set.  The acknowledgment is important for stabilizing
      the connection before other transfers are attempted.
}
      [ "LOGIN " getlogin spaced host + + "LOGIN" book
        -1 "Sclosed" book
      ]
      (nPort) dup 0< \ require nonnegative nPort
      IF 2drop Sclosed return THEN 

      (qIPaddr nPort) -1 CONNECT (nSocket) this any
      IF "S" book
         depth push
         LOGIN S remoteputf \ will enter drainf on remote to match LOGIN
         S MAXBLOCK BLOCK (qLOGIN)
         depth pull less (n) 0>
         IF (hT)
          \ Update the LOGIN entry in the table displayed by word 
          \ clients using T just returned from server:
            (hT) S clientLOGIN_set

            S cop \ return a copy

         ELSE S sclose Sclosed 
         THEN
      THEN (nSocket) 
   end

   inline: CLIENT_ALLOW (qIP --- f) \ flag f true if IP can connect
{     Table "clients" in this local library contains the list of IP 
      addresses that can connect when the program's server is running.

      Given a prospective IP address, this word returns f true if it
      matches an entry in clients table.

      Only the first word in each line of the clients table is used
      to match against IP, so any arbitrary text can follow the first 
      word.

      If clients table is empty, as it is at start up, then f returned 
      is always true.

      When word SERVER or DSERVER (term.c) is run with the incoming 
      stack item IPaddr containing one or more IP addresses (rather 
      than "" or "*" denoting wildcard), that stack item is appended
      to the clients table in this word.  

      If started with a wildcard, SERVER and DSERVER do nothing to the 
      clients table here.

      See man CLIENT_ALLOW for ways to view and add to clients table.
}
      [ VOL tpurged "clients" book 
        no "APP_CLIENT_ALLOW" book
      ]
      APP_CLIENT_ALLOW 0<>
      IF (qIP) APP_CLIENT_ALLOW exe 
      ELSE \ default behavior:
         clients chars any
         IF clients 1st word drop swap (hT qIP) grepe (hA) rows any (f)
         ELSE (qIP) drop yes
         THEN
      THEN
   end

   inline: CLIENT_ALLOWING ( --- hT) \ list of client IPs allowed
    \ Sat Jan 21 11:01:00 PST 2012

    \ List of IP addresses allowed to connect as soon as their con-
    \ nection is known in terminal(), file term.c.

      "CLIENT_ALLOW" "clients" yank
   end

   inline: CLIENT_F (qIPaddr nPort --- nSocket) \ connect to this prog
{     Connect as a foreign client to another instance of this program
      running a SERVER on Port at IPaddr.

      The flag in this library called set_CONN is initially set to 0,
      meaning bytes from SERVER will go to the stack.  The ptr to a
      word to service bytes from SERVER can be banked here instead,
      before running CLIENT_F, as in:

         "myCLIENT" ptr "CLIENT_F" "set_CONN" bank

      For more about the ptr for set_CONN, see notes about ptrRun in
      man CONNECT.

      SERVER determines its connection type (LOSERV or FOREIGN) on the 
      first bytes received after connection (drainf(), file net.c).

      This connection will be type FOREIGN, and SERVER will close the 
      connection in NEW_CLIENT_TIMEOUT seconds if nothing is received.

      Word new_client_timeout can be used to modify the value of
      NEW_CLIENT_TIMEOUT.
}
      [ 0 "set_CONN" book \ bytes from SERVER will go to stack
        -1 "Sclosed" book
      ]
      (qIPaddr nPort) set_CONN CONNECT (nSocket) this 0<
      IF drop Sclosed THEN (nSocket)
   end

   inline: CLIENT_SSL (qIPaddr nPort --- nSocket) \ connect to this prog
{     Sat Mar 12 12:59:52 PST 2011

      Connect to another instance of this program running SERVER_SSL
      on Port at IPaddr.
}
      SSL (f)
      IF yes ssl_connect
         (qIPaddr nPort) CLIENT (nSocket) 
      ELSE " CLIENT_SSL: OpenSSL functions are missing" . nl 
         (qIPaddr nPort) 2drop -1 (nSocket)
      THEN
   end

   inline: CONNECT_HOST (qHost nPort ptrRun --- nS) \ connect to Host
{     Resolve multi-homed Host to its IP addresses, then try making a
      connection to each until one succeeds.

      Incoming number ptrRun is the ptr to a catalog word that will be 
      run whenever bytes from the remote server are received in socket 
      S and the remote server is not this program running SERVER.

      Returns a valid socket number S if successful.

      Returns socket S equal to -1 if Host name resolution fails or if
      all connection attempts fail.

      The IP address of the connection (or the last attempt) is booked
      here as IP.

      This shows trying to connect to a nonexistent listening port.
      It shows 4 seconds between tries in CONNECT (the connect_timeo
      closings) which is controlled by "sec" below, and a 3 second 
      idle by due to "WAIT" before trying again, so the third attempt
      starts 4+3 seconds after the second. 

         Mon Jun 9 05:06:56 PDT 2008
         [dale@plunger] /home/dale > tops
                  Tops 3.0.1
         Mon Jun  9 05:06:59 PDT 2008
         [tops@plunger] ready > IPloop 9871 0 CONNECT_HOST
          connect_timeo: errno 111  Mon Jun  9 05:07:03 PDT 2008
          connect_timeo: closing socket 3
          connect_timeo: errno 111  Mon Jun  9 05:07:07 PDT 2008
          connect_timeo: closing socket 3
          CONNECT: could not connect to 127.0.0.1:9871 in 2 attempts
          CONNECT_HOST: idling for 3 seconds before trying again
          connect_timeo: errno 111  Mon Jun  9 05:07:14 PDT 2008
          connect_timeo: closing socket 3
          connect_timeo: errno 111  Mon Jun  9 05:07:18 PDT 2008
          connect_timeo: closing socket 3
          CONNECT: could not connect to 127.0.0.1:9871 in 2 attempts

          stack elements:
                0 number: -1
          [1] ok!
         [tops@plunger] ready > 

      File /usr/include/asm/errno.h shows errno 111: 
         #define ECONNREFUSED    111     /* Connection refused */
}
      [ 4 "sec" book, 2 "TRIES" book, 3 "WAIT" book ]

      "ptrRun" book "nPort" book "Host" book
      "" "IP" book

      Host IPhost (hIPaddr) any?

      IF "IPlist" book CONNTO "SEC" book \ save current time out, SEC
         sec connto                      \ set time-out to sec
         SSL_CONNECT "SSLflag" book

         true (nS)
         TRIES TIMES \ also tries twice in CONNECT, so total = 2*TRIES
         DO IPlist rows 1st \ loop over IP addresses:
            DO drop IPlist I quote chop (qIPaddr) this "IP" book

               SSLflag IF yes ssl_connect THEN
               (qIPaddr) nPort ptrRun CONNECT (nS)

               (nS) this any IF EXIT THEN
            LOOP
            (nS) this any IF EXIT THEN

            I qdx TRIES < 
            IF " CONNECT_HOST: idling for " WAIT intstr + 
               " seconds before trying again" + . nl
               WAIT idle \ delay between tries
            THEN
         LOOP

         SEC connto \ put time-out back to SEC

      ELSE true (-1)
      THEN (nS)
   end

   inline: CONNECTIONS ( --- ) \ library of connections
\  WORK IN PROGRESS.  A LIBRARY FOR CONNECTIONS.
{     Within C code, items from this library can be placed on the stack
      as follows:

         double *client;
         char *clientIP;

         extract1("CONNECTIONS","client"); /* sockets numbers to stk */
         client=tos->mat; /* address of client socket numbers */
         drop(); /* client is cat item, so drop will not deallocate */

         extract1("CONNECTIONS","clientIP"); /* clientIP to stk */
         clientIP=tos->tex; /* address of IP text */
         drop();
}
      [ 0 1 null "client" book \ descriptor (socket number)
        0 1 null "clport" book \ port
        0 1 null "contyp" book \ connection type
        0 1 null "cliptr" book \ ptr to run when receive in drainf()
        0 1 null "clitim" book \ time of connection
        0 1 blockofblanks "clientIP" book \ IP address
      ] 
   end

   inline: CROSSLINK (nSocket1 nSocket2 qS --- ) \ link two machines
{     Start the machine at Socket1 listening on its nextport and
      have the machine at Socket2 connect to it; then close the
      listening port at Socket1.
}
      "SOCKET_NAME" book
      "S2" book "S1" book

    \ Start a server on S1, or use the one already ON:
      "serverport remotefd remoteput" S1 remoterun1 (nPort) any?
      IF (nPort) yes
      ELSE "def_port tic nextport '*' that SERVER remotefd remoteput"
         S1 remoterun1 (nPort) no
      THEN
      (nP1port f) "ON" book "P1port" book \ listening at S1

    \ Connect the machine at S2 to SERVER at S1:
      clientIPs S1 clientindex quote (qIP)
      (qIP) quoted spaced P1port intstr + " CLIENT" +
      (qIP nP1port CLIENT) S2 remoterun

    \ The socket number connecting to S1 is on the stack of S2.  Have
    \ S2 give it SOCKET_NAME and book it into its main library:
      SOCKET_NAME quoted " book" + (qSOCKET) S2 remoterun

    \ Have S2 make S1 put the socket number of their connection on its
    \ stack:
      "'remotefd dup remoteput' "
      SOCKET_NAME +
      " remoterun1 (nPORT) remotefd remoteput" +
      S2 remoterun1 (nPORT) drop

    \ Now the socket number connecting to S2 is on the stack of S1.
    \ Have S1 give it SOCKET_NAME and book it into its main library:
      SOCKET_NAME quoted " book" + (qSOCKET) S1 remoterun

    \ Close server on S1 if it was not already on:
      ON not IF "serverclose" S1 remoterun THEN
   end

   inline: def_port ( --- nPort) \ default port number
      [ 9877 is PORT ] PORT ;

   inline: def_server ( --- ) \ start server listening on default port
\     If the server cannot be started, the default port is probably
\     being used by another program.
      def_port serverstart not
      IF " def_server: could not start default server" ersys THEN
   end

   inline: def_server1 ( --- ) \ start server listening on def port+1
\     If the server cannot be started, default port+1 is probably
\     being used by another program.
      def_port 1+ serverstart not
      IF " def_server1: could not start default server1" ersys THEN
   end

   inline: DSERV-DN (nPort --- ) \ shut down server listening on Port
{     Thu Mar  6 18:33:16 PST 2014

      This is a companion word to DSERV-UP, but it will work to shut
      down any server this program is running on IPloop and that 
      accepts clients through word CLIENT and is listening on Port.
}
      [ 2 intstr "SECS" book ]
      (nPort) dup port_on (f)
      IF (nPort) "P" book
         IPloop P CLIENT (nS) dup -1 > (f)
         IF (nS) "S" book
            " DSERV-DN: shutting down port" . P .i nl

            SECS ' "exit"' + " ALARM ACK" + (qT) \ reset EOL alarm
            (qT) S remoterun1 (f) 
            IF " DSERV-DN: OK, received ACK from socket " 
            ELSE " DSERV-DN: failed to receive ACK from socket " 
            THEN S intstr + (qMsg)
            S sclose 

         ELSE (nS) drop
            " DSERV-DN: connection failed to server on port " 
            P intstr + (qMsg)
         THEN
         (qMsg) . nl
      ELSE (nPort) " DSERV-DN: port" . (nPort) .i " is not on" . nl
      THEN
      " DSERV-DN: returning" . nl
   end

   inline: DSERV-UP ( --- nPort) \ server started, listening on Port
{     Thu Mar  6 18:08:45 PST 2014

      Starts as a server a remote instance of this program on the same
      machine, and returns its listening port.

      Returns invalid Port=-1 if test connection to the server fails.

      The script that runs the server is usr/dserv1.  It will run for
      5 days (24*5 hours) if not killed before then (see word DSERV-DN).

      While it is running, the server will write messages to log file
      /tmp/runid+_dserv1.log.  The log file will be deleted on exit
      (but see command line options below).

      Server start up adapted from word TASK_PORT.
}
      [ {" ( --- f)
         { This indeterminate wait state task, WTASK, avoids waiting
           the entire STARTUP period before trying to connect to the
           server started.

           Typical connection times are 3 or 4 seconds versus waiting
           the entire 10 second STARTUP period.

           Initial CONNECT attempts will fail; send the cannot connect
           messages to scratch:
         } SYSOUT push scratch set_sysout
           CONNTO push 0 connto \ no idle between CONNECT tries

           IPloop PORT -1 CONNECT any?
           IF (S) sclose -1 ELSE 0 THEN

           pull connto
           pull set_sysout  \ restore SYSOUT
           scratch deleteif \ delete scratch
        "} "WTASK" macro

        10 (Hz) "CONRATE" book  \ running WTASK ten times per second
        10 (sec) "STARTUP" book \ server start up wait, seconds
        0 "t0" book
      ]
      "dserv1" filefound
       IF
       \ Start a server.
         (qServ) \ this is the program script to be run
         time "t0" book \ timing the start up

       \ Initialize the indeterminate wait state task, WTASK, to watch
       \ the connection and return as soon as the server is running:
         STARTUP (nSec)              \ max indeterminate wait
         "DSERV-UP" "WTASK" localref \ full lib name of WTASK
         (nSec qWord) WAIT_INIT      \ install WTASK and start WAITING
         CONRATE "WAITING" RATE      \ speed up rate of WAITING

       \ Make the script that starts the server (runs dserv1):
         (qServ)

       \ While it is running, the server will write messages to log
       \ file /tmp/runid+_dserv1.log.  The log file will be deleted on
       \ exit unless option -logsav is specified (see command line
       \ options below; current usage does not save the log file).

       \ Command line switches for dserv1 server script:
          \ " -logsave " +         \ add this to save log
          \ " -logsave -ntrace " + \ add this to save log with net trace
            " -exit " + 24 5 * 3600 * (nSec) intstr + \ exit time
          \ Port to use:
            " -port " + def_port nextport dup "PORT" book intstr +
            " &" + (qS)

         (qS) shell \ run the start up script

         WAIT_BEGIN \ indeterminate wait state while script runs

       \ Make a test connection to the server on loopback IP:
         IPloop PORT CLIENT (nS) dup -1 >
         IF (nS)

          \ Set server to allow clients only from loopback:
            "'127.0.0.1 loopback' 'SERVER_ALLOW' 'clients' bank " 
            "'127.0.0.1 loopback' 'CLIENT_ALLOW' 'clients' bank " + 
            " remotefd sclose" + (qS) \ make remote close from its end
            over (qS nS) remoterun

            " DSERV-UP: test to port" . PORT .i ", connected in "
            time t0 less "%0.2f" format + " sec on socket" + . dup .i nl

            (nS) dup sclose \ close test connection
            " DSERV-UP: test connection to socket" . .i " closed" . nl

            PORT (nPort) \ return port number

         ELSE
            (nS) drop
            " DSERV-UP: test connection to server failed" . nl
            -1 (nPort) \ return invalid port number
         THEN

      ELSE " DSERV-UP: file " "dserv1" + " not found" + . nl
         -1 (nPort) \ return invalid port number
      THEN
      (nPORT)
   end

   inline: fremoteget (qFile qFile_to nSocket --- f) \ File from Socket
\     Fetch File from the remote tops machine connected on Socket and
\     copy to File_to on this machine.

      [ 
\     These phrases make the remote fetch its local file, put it on its
\     stack, and then send it to the stack here:
        {" ( --- )
         no "F" book
         "FILENAME" (qFile) filefound 
         IF (qFile) old binary "F" file 
            F this file.size pry (nbytes) fget (hT) 
            F fclose no "F" book
         ELSE "" \ empty T if file not found
         THEN remotefd (hT nS) remoteput \ send T to requestor
        "} chop textput "file_get" book

        no "F" book
        600 "SEC" book
      ]
      true 1 NUM stkok and, 2 STR stkok and, 3 STR stkok and not
      IF "fremoteget" stknot return THEN
      
      " fremoteget: begin " date + . nl \ entry for log file

      "remoterun1" "SEC" yank push
      SEC "remoterun1" "SEC" bank

      time "t0" book

      swap (qFile_to) push

      (qFile nSocket) file_get (hT) "FILENAME" 3 roll strp (hT) swap
      (hT nSocket) remoterun1 (hT) any?

      IF (hT) F filetrue IF F fclose THEN
         peek (qFile_to) fallow (f) \ check file permission
         IF 
          \ Fri Dec  6 09:18:12 PST 2013.  Delete old file at the
          \ last possible point.
          \ An old file must be deleted, because fput simply appends
          \ bytes to a file if it already exists:
            peek (qFile_to) dup deleteif
            (qFile_to) forn binary "F" file F rows any
            IF (hT) dup sizeof push 

               (hT) F fput F fclose no "F" book

               time t0 - 
               " fremoteget: " peek intstr + " bytes at " +
               pull 0.5 + rot / integer intstr + " bytes/sec" + . nl

               -1 (f)
            ELSE (hT) drop
               " fremoteget: file handle error for " peek + . nl 0 (f) 
            THEN
         ELSE " fremoteget: write permission denied for " peek + 
            . nl 0 (f)
         THEN
      ELSE " fremoteget: file not found" . nl 0 (f) \ empty T
      THEN 
      pull (qFile_to) drop 
      pull (SEC) "remoterun1" "SEC" bank
      (f) cop
      " fremoteget: end " date + . nl
   end

   inline: fremoteput (qFile qFile_to nSocket --- f) \ File to Socket
{     Copy File from this machine to File_to on the remote tops machine
      that is connected on Socket.  This word uses fremoteget to trans-
      fer the file from the stack here to the remote stack, where it is
      then written to a file.
}     
      [     
    \ These phrases make the remote run its word fremoteget (just like
    \ the one above) and then send the success flag back to here:
        {" ( --- f) 
          "FROM" "TO" remotefd fremoteget (f) dup \ NUM success flag

        \ Message to local log:
          IF " fremoteget: success; sending true" 
          ELSE " fremoteget: failed; sending fail" 
          THEN " flag to socket " remotefd intstr + + . nl 

          (f) remotefd remoteput \ send success flag to remotefd
        "} chop textput "file_put" book
      ]
      true 1 NUM stkok and, 2 STR stkok and, 3 STR stkok and not
      IF "fremoteput" stknot return THEN
      
      depth three less "d0" book \ depth below incoming 3 stack items

      two roll (qFile) filefound (f)
      IF (qFileName)
         time "t0" book 

         "remoterun1" "SEC" yank push
         "fremoteget" "SEC" yank "remoterun1" "SEC" bank

         (qFilename) dup filesize push

         rev (qFile qFile_to nSocket) push push push 

       \ Replace the placeholder names in the text of file_put:
         file_put (hT)
         "FROM"  pull (qFile) strp (hT) 
         "TO" pull (qFile_to) strp (hT)

       \ Run T on the remote, which blocks until T returns f:
         pull (hT nSocket) remoterun1 (f) 

       \ Integrity checks on stack and f from running T on remote:
         depth 0= 
         IF fail (f)
         ELSE depth push
            (f) dup type NUM =   \ per file_put(), expect a NUM flag
            pull d0 1+ = and not \ and depth with (f) should be d0+1
            IF fail THEN         \ fail flag on stack if error
         THEN (f)

         time t0 - 
         " fremoteput: " peek intstr + " bytes at " +
         pull 0.5 + rot / integer intstr + " bytes/sec" + . nl

         pull (SEC) "remoterun1" "SEC" bank

      ELSE " fremoteput: file not found" . nl 2drop false (f)
      THEN (f) cop
   end
   
   inline: IPhost (qHost --- qIP) \ the IP address for Host
\     High level driver for _IPhost in net.c.

      -path \ remove leftmost items like http://
      this "." chblank chpack numerate any?
      IF drop (qIP) \ nothing to do if already IP form
      ELSE
         dup host = \ does this machine host name match Host?
         IF drop IPloop \ use loopback addr for simulated cluster demo
                        \ and security on UMLs
         ELSE (qHost) "HOST" book
            HOST _IPhost noq_alike any? not
            IF "" THEN \ return empty string if not found
         THEN
      THEN
   end

   inline: IPhostr (qS --- qIP) \ randomly fetch IP from multihomed list
      IPhost these rows 1 = IF return THEN
      1st those rows dup 1 ranint 1st pry reach (qIP)
   end

   inline: HTTPget (qHost hPathFile --- ... hT) \ get files from Host
{     Get the files listed in PathFile from HTTP (Hypertext Transfer
      Protocol) web server Host.  This word is run on a client to re-
      ceive T from HTTP server Host.

      Each file name in Pathfile is a separate substring or line.

      Each file will be a returned as a one-line volume T on the stack.
      Returned T is an empty string if there was an error.

      HTTP web servers usually listen on port 80, which is the default
      that this word assumes.  To connect to a server listening on a 
      different port, like port 9877, use a phrase like this beforehand:
         9877 "HTTPget" "PORT" bank
}
      [ 120 "TIMEOUT" book \ seconds to BLOCK for HTTP bytes each file
        TIMEOUT "timeout" book

\       To change timeout, say to 20, run this before HTTPget:

\          20 "HTTPget" "timeout" bank

\       After HTTPget runs, timeout is always set back to TIMEOUT.
\       Never change TIMEOUT.

        yes "CREDENTIALS" book

\       Various user-agents (the Appendix shows what some clients send
\       to HTTP servers):
         \ This program:
           progname "/" version + + "progUA" book 

         \ Wget:
           "Wget/1.7" "wgetUA" book  

         \ Netscape:
         \ Fri Jul 13 15:17:02 PDT 2012:
           "Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.4) "
           "Gecko/20030624 Netscape/7.1" +
           "netscapeUA" book  

         \ MSIE
           "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; "
           "SV1; .NET CLR 1.1.4322)" +
           "msieUA" book

         \ Google:
           "Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US) " 
           "AppleWebKit/532.0 (KHTML, like Gecko) " + 
           "Chrome/3.0.195.32 Safari/532.0" + 
           "googleUA" book

        progUA "UA" book \ initial user-agent is this program

\       To change user-agent:
\          "my_user-agent_quote" "HTTPget" "UA" bank
\       or
\          "HTTPget" "googleUA" yank "HTTPget" "UA" bank

{       Examples.

        Fetching files from IWIN (Interactive Weather Information
        Network [2008: IWIN no longer works; www.weather.gov does]):

           Weather in California:
           \ This old address does not work:
             "iwin.nws.noaa.gov" "/iwin/ca/state.html" HTTPget

           \ This new address works:
             "http://www.weather.gov" 
             "/view/prodsByState.php?state=ca&prodtype=state"
             HTTPget

           Using Wget for weather in California (run this at the Unix
           prompt); Wget is smart enough to follow this old address:

             wget iwin.nws.noaa.gov/iwin/ca/state.html

           to the new one using when it sees:
              HTTP request sent, ... 301 Moved Permanently

           National weather (warning: this file has over 7 Mb):
              "http://www.weather.gov"
              "/view/national.php?prodtype=nationalsummary"
              HTTPget

        Also see "HTTPget vs. WGET timing test" in this file.
}
        "<html" "BEGINhttp" book
        "</htm" "ENDhttp"   book

        80 "PORT" book

        " " "FILES" book \ list of files to get
        " " "Host" book  \ connecting to host
{
        Some sites balk at an IP address, instead of site name, ap-
        pearing in the credentials.  Host_alias is a site name, bank-
        ed into into this library before calling this word, that will 
        be used in the credentials even though incoming Host is an IP 
        address string.

        Why use Host_alias?  For a multihomed host, it may be pref-
        erable to go to a specific IP address chosen ahead of time
        from its list of IP addresses, but the host returns an error 
        if that IP address is in the credentials--it wants to see its
        site name (and presumably choose the IP address itself).

        Host_alias allows HTTPget to connect to the desired IP ad-
        dress while sending the site name in the credentials.

        Example: A snippet for SITE, forcing the use of the Nth host:

          \ Put site name into HTTPget.Host_alias and it will go into
          \ the credentials, then use specified index N for the IP:
            SITE (qSite) dup (qSite) "HTTPget" "Host_alias" bank
            (qSite) IPhost (hList)             \ list of host IPs
            (hList) dup rows ndx N min (N)     \ N within bounds
            (hList N) quote (qIP)              \ Nth host IP from List
            (qIP) "/path/" FILE + HTTPget (hT) \ get FILE

         // Here is the example written in infix instead of postfix:
            HTTPget.Host_alias = SITE;
            List = IPhost(SITE);
            IP = quote(List, min(ndx(rows(List)), N)); // N is an index
            T = HTTPget(IP, "/path/"+FILE));

        Host_alias is used only if it is not an empty string (""), 
        and it is set back to an empty string after each use:  
}       "" "Host_alias" book \ site name in credentials to host

        no "CHARS" book   \ count of characters received
        no "CLOSED" book  \ flag, set to yes when done
        no "CLOSING" book \ flag, set to yes to force closing
        no "ENCODE" book  \ encode incoming FILE (reset to no each time)
        " " "FILE" book   \ current file getting
        no "t0" book      \ initial time
        no "VOLS" book    \ count of received volumes on stack
      ]
      "HTTPget" ERRset
      -1 "S" book

      (hPathFile) "FILES" book
      (qHost) "HOST" book

      HOST -path "Host" book
      " HTTPget: host " . Host . nl

      FILES rows 1st
      DO S socket_open not
         IF HOST PORT ptr_receive CONNECT_HOST "S" book THEN
         S -1 >
         IF " HTTPget: connected to "   
            "CONNECT_HOST" "IP" yank + ":" + PORT intstr +
            " on socket " + S intstr + . nl

            FILES I quote strchop any? not IF "/" THEN "FILE" book
            " HTTPget: " . FILE COLS out - .out nl

          \ Mon Mar 10 16:32:17 PDT 2014.  Encode if user word
          \ ENCODE_HTTP exists and flag ENCODE is true:
            "ENCODE_HTTP" exists? ENCODE and 
            IF FILE ENCODE_HTTP (f)
               IF (hT1) "FILE" book 
               ELSE " HTTPget: ENCODE_HTTP failed" . nl
                  EXIT \ jump to LOOP
               THEN
            THEN

            no "CHARS" book   \ count of characters received
            no "CLOSED" book  \ flag, set to yes when done
            no "CLOSING" book \ flag, set to yes to force closing
            no "VOLS" book    \ count of received volumes on stack

          \ Start request to server.  The program does not handle
          \ chunked encoding, so request HTTP/1.0 (see Reference 7):

            "GET " FILE " HTTP/1.0" + + (qT)
            CRLF + (qT) 

          \ Additional info sent if CREDENTIALS is yes:
            CREDENTIALS (f)
            IF "User-Agent: " UA + CRLF + +

               "Host: " (qS) Host_alias (qAlias) any? 
               IF 
                \ Use alias just banked to lib, removing path if any:
                  (qAlias) -path \ in case path http:// still there
               ELSE Host (qHost) \ use incoming string
               THEN 
               (qS qHost) + CRLF + +

               "Accept: */*" CRLF + +
              
               UA googleUA =
               IF "Connection: keep-alive"
               ELSE "Connection: Keep-Alive"
               THEN CRLF + +

            THEN
            CRLF +       \ end request to server
            S remoteputf \ send request to server

          \ Fri May  6 08:05:20 PDT 2011.  Setting HOLD to yes has
          \ been moved into receive, so it is not set until bytes
          \ are actually coming:
          \ yes HOLD        \ word receive will say no HOLD when done

            S timeout BLOCK \ until time out

          \ Send closeout to word receive if BLOCK timed out:
            CLOSED not 
            IF yes "CLOSING" book ENDhttp (qS) S receive THEN

            S socket_open not
            IF " HTTPget: connection closed by host" . nl
               S sclose \ clientclose() will delete S from lists
               -1 "S" book
            THEN

         ELSE " HTTPget: error connecting to " Host + ersys
            "" (hT)
         THEN
      LOOP
      "" "Host_alias" book \ set back to empty
      no "ENCODE" book \ set back to no

      S socket_open
      IF " HTTPget: closing connection" . nl THEN
      S sclose \ deletes S from socket lists, even if S is closed

      TIMEOUT "timeout" book
      ERR

      [ \ Begin bracket mode (again).  Making local macro receive.

{     The local word called receive is made below.  Its ptr is given to
      CONNECT to be run by C function drainf() and receive bytes from
      an HTTP server.  The ptr to word receive is called ptr_receive,
      and it is used in the CONNECT phrase above.

      Function drainf() runs word receive while the program state is
      HOLD BLOCK and bytes are being received from a server.

      A local word like this one, located within another word, shares
      the library of that word--in this case, the library of word
      HTTPget.  Thus local variables in the library of HTTPget, like
      CHARS, CLOSED, t0 and VOLS can be seen by this word, receive.

      This word tests one-line volumes on the top of stack, flowing
      through drainf(), and ignores them until one is received with
      text ENDhttp, signifying the end of data from an HTTP server.

      When the end-of-data text is detected, all the bytes received
      are concatenated into a single one-line volume on the stack,
      and HOLD is then set to "no."

      With HOLD set to "no," the event loop in C function terminal()
      will take care of removing BLOCK and getting things back to 
      normal.
}
      {" receive (... hT nSocket --- hT1) \ this is local word receive

         (nSocket) 
         "receive from socket " swap intstr + ERRset

         VOLS 0= 
         IF CLOSING not
            IF time "t0" book \ initial time is now
               yes HOLD       \ this word will say no HOLD when done
               " HTTPget: receiving bytes ..." . nl 
            THEN
         THEN

         one VOLS bump
         (hT) these chars CHARS bump

       \ Tue Mar 18 05:53:38 PDT 2014.  Function grepr() has been re-
       \ vised to ignore nondisplay characters in T (bytes less than 
       \ 20h), so T can be an encoded string (which may contain bytes
       \ from 0 to 20h-1) that is followed by unencoded ENDhttp and 
       \ grepr() will find it:
         (hT) dup lowercase ENDhttp grepr (hRows) rows 0> (f)
         (hT f)
         IF time " HTTPget: received" .
            (time) t0 less this 0>
            IF CHARS .i " bytes at" .
               CHARS swap slash rounded dup 1E6 <
               IF .i " bytes/sec" .
               ELSE 1E6 slash 
                  "%8.2f" format strchop sp . " Mbytes/sec" .
               THEN
            ELSE drop CHARS .i " bytes in under 1 second" .
            THEN nl

            depth VOLS >= 
            IF VOLS parkn (hT) \ concatenate volumes on the stack
            ELSE " HTTPget: insufficient number on stack for VOLS:" .
               VOLS .i nl
               "" \ return an empty STR
            THEN

            "_/" FILE -path + naming (hT1) \ T1 stack name is _/FILE

            yes "CLOSED" book
            no HOLD \ no more holding, so BLOCK will be removed

         THEN (hT1)

         ERR

      "} "receive" macro

    \ Using localref to get the full main library name needed for
    \ word ptr:
      "HTTPget" "receive" localref (qName) ptr "ptr_receive" book
      ]
   end

   inline: HTTPgetr (qHost qRequest --- hT) \ receive request from Host
{     Send HTTP (Hypertext Transfer Protocol) Request to web server
      Host, and receive response T.

      This word is similar to HTTPget.  Word HTTPget builds a request
      for HTTP procedure GET and sends it to Host.  This word expects 
      an HTTP procedure already built in string Request, and sends it 
      directly to Host.

      Note: HTTPget loop structure was changed in April 2008.  This 
      word still has the old loop structure.

      Word receive in this library operates identically to word receive
      in the library of HTTPget.

      The response is received as a one-line volume T on the stack.
      Returned T is an empty string if there was an error.

      HTTP web servers usually listen on port 80, which is the default
      that this word assumes.  To connect to a server listening on a
      different port, like port 9877, use a phrase like this beforehand:
         9877 "HTTPgetr" "PORT" bank
}
      [ 120 "TIMEOUT" book \ seconds to BLOCK for HTTP bytes each file
        TIMEOUT "timeout" book

\       To change timeout, say to 20, run this before HTTPgetr:

\          20 "HTTPgetr" "timeout" bank

\       After HTTPgetr runs, timeout is always set back to TIMEOUT.
\       Never change TIMEOUT.

        "<html" "BEGINhttp" book
        "</htm" "ENDhttp"   book

        80 "PORT" book

        " " "Host" book   \ connecting to host
        no "CHARS" book   \ count of characters received
        no "CLOSED" book  \ flag, set to yes when done
        no "CLOSING" book \ flag, set to yes to force closing
        no "VOLS" book    \ count of received volumes on stack
        no "t0" book      \ initial time
      ]
      "HTTPgetr" ERRset

      (hRequest) any? not IF "/" THEN "REQUEST" book
      (qHost) this -path "Host" book
      " HTTPgetr: host " . Host . nl

      (qHost) PORT ptr_receive CONNECT_HOST any? \ socket to PORT
      IF (nSocket) "S" book

         " HTTPgetr: connected to "   
         "CONNECT_HOST" "IP" yank + ":" + PORT intstr +                
         " on socket " + S intstr + . nl

         no "CHARS" book   \ count of characters received
         no "CLOSED" book  \ flag, set to yes when done
         no "CLOSING" book \ flag, set to yes to force closing
         no "VOLS" book    \ count of received volumes on stack

         REQUEST S remoteputf \ send request to server

       \ Fri May  6 08:05:20 PDT 2011.  Setting HOLD to yes has
       \ been moved into receive, so it is not set until bytes
       \ are actually coming:
       \ yes HOLD        \ word receive will say no HOLD when done

         S timeout BLOCK \ until time out

       \ Send closeout to word receive if BLOCK timed out:
         CLOSED not IF yes "CLOSING" book ENDhttp (qS) S receive THEN

         S socket_open not
         IF " HTTPgetr: connection closed by host" . nl
            S sclose \ informs clientclose() to delete S from lists
         THEN

         S socket_open
         IF " HTTPgetr: closing connection" . nl THEN
         S sclose \ deletes S from socket lists, even if S is closed

      ELSE " HTTPgetr: error connecting to " Host + ersys
         "" (hT)
      THEN

      TIMEOUT "timeout" book
      ERR

      [ \ Begin bracket mode (again).  Making local macro receive.

      {" receive (... hT nsocket --- hT1) \ this is local word receive

         (nSocket) 
         "receive from socket " swap intstr + ERRset

         VOLS 0=
         IF CLOSING not
            IF time "t0" book \ initial time is now
               yes HOLD       \ this word will say no HOLD when done
               " HTTPgetr: receiving bytes ..." . nl
            THEN
         THEN

         one VOLS bump
         (hT) these chars CHARS bump

         (hT) this lowercase ENDhttp grepr rows any
         IF
            time " HTTPgetr: received" .
            (time) t0 less this 0>
            IF CHARS .i " bytes at" .
               CHARS swap slash rounded dup 1E6 <
               IF .i " bytes/sec" .
               ELSE 1E6 slash
                  "%8.2f" format strchop sp . " Mbytes/sec" .
               THEN
            ELSE drop CHARS .i " bytes in under 1 second" .
            THEN nl

            depth VOLS >= 
            IF VOLS parkn (hT) \ concatenate volumes on the stack
            ELSE " HTTPgetr: insufficient number on stack for VOLS:" .
               VOLS .i nl
               "" \ return an empty STR
            THEN
            
            "_" REQUEST asciify " " "_" strp +
            1st those chars 64 min items catch naming

            yes "CLOSED" book
            no HOLD \ no more holding, so BLOCK will be removed

         THEN (hT1)

         ERR

      "} "receive" macro

    \ Using localref to get the full main library name needed for
    \ word ptr:
      "HTTPgetr" "receive" localref (qName) ptr "ptr_receive" book
      ]
   end

   inline: HTTPput (qT nS --- ) \ service request T and put in S
{     Get a response to T and send it (put it) in socket S.  This is a
      word run on the server side of socket S that connects to a client.

      HTTP request T for socket S may be serviced by a server (such as 
      Apache) or by a word in the program.  

      Whether to use a server or a word is controlled by PROVIDER as
      follows:

         A (PROVIDER, PORT) pair defining a server that is called
         below by running word HTTPgetr: 

            PROVIDER: a STR that is the IPaddress of the server 
               that will service the HTTP request 

            PORT: the listening port of the PROVIDER server
         
         or a word pointer NUM to be run below by exe (PORT is not 
         used in this case):

            PROVIDER: a ptr NUM to the word that will service 
            the HTTP request; the stack diagram for a PROVIDER 
            word is:

                  (qT nSocket --- qR) 

               where R is the response for request T

         Initial PROVIDER is a server defined by string "127.0.0.1" 
         and initial PORT is 80.

         The initial TIMEOUT for HTTPgetr when PROVIDER is a server 
         is 20 seconds.  A phrase like

             40 "HTTPput" "TIMEOUT" bank

         can be used to change it.

         REQUESTcheck and RESPONSEcheck in this library are ptrs to 
         words with stack diagrams given by 

            (qT nSocket --- qT1) 

         that check the request and response, respectively.  

         The initial ptr for these two words is ptr("drop"), which will
         simply drop nSocket and leave T as T1.  See words HOSTcheck 
         and REQUESTcheck in file usr/tops_http.v for words whose ptrs
         are banked here for a simple web server application.
}
      [ 
      \ Initial values:
           "127.0.0.1" "PROVIDER" book 
           80 "PORT" book
           20 "TIMEOUT" book \ wait time for HTTPgetr to perform request
           "drop" ptr "REQUESTcheck" book
           "drop" ptr "RESPONSEcheck" book

           yes "SCLOSE_ON_EXIT" book \ default
      ]
      "HTTPput" ERRset

      "S" book 

      nl \ Log the client:
      S clientindex 0<
      IF " HTTPput: client on socket" . S .i " is gone" .
         "unknown" "IP" book
      ELSE
         " HTTPput: client " . 
         clientIPs S clientindex over rows min quote 
         strchop this "IP" book .  " on socket " S intstr + . nl

         " HTTPput: client login: " . 
         clientLOGINs S clientindex over rows min quote strchop any? 
         IF vol2str COLS out - .out
         ELSE "this client's LOGIN string is empty" .
         THEN
      THEN
      nl

    \ Turning on ntrace for xxxx.html:
    \ (qT) dup "xxxx.html" grepr rows any not
    \ IF ntrace ELSE nontrace THEN

      (qT) any? not IF "/" THEN textput (qT) \ single string with \n

    \ Debug.  Save the request in array REQUEST: 
      (qT) this "REQUEST" book

    \ Check the request:
      (qT) S REQUESTcheck exe (qT)

    \ Perform the request:
      time push \ save initial time 

    \ If PROVIDER is a string (type STR), it is an IP address to con-
    \ nect to and return the response to send (put) back; otherwise, 
    \ PROVIDER is a ptr (NUM) to run and return the response to send
    \ (put) back:
      PROVIDER (qHost) this type STR = \ IP address string?
      IF (qIP) \ HTTPgetr connects to server and gets the response:

       \ Bank this word's TIMEOUT into HTTPgetr:
         TIMEOUT "HTTPgetr" "timeout" bank

       \ Save the original PORT value from HTTPgetr and bank this one:
         "HTTPgetr" "PORT" yank (nPORT) push
         PORT "HTTPgetr" "PORT" bank

        " HTTPput: connecting to server " over (qIP) + ":" + 
        PORT intstr + " and running HTTPgetr" + . nl

       \ Connect to server and get the response:
         (qT qIP) swap (qIP qT) HTTPgetr (qR)

       \ Restore the original PORT value in HTTPgetr (timeout is always
       \ restored in HTTPgetr when returns):
         pull (nPORT) "HTTPgetr" "PORT" bank

       \ Debug.  Save the response in local library: 
         (qR) this "RESPONSE" book

       \ Check the response:
       \ WARNING: If RESPONSEcheck=ptr->HOSTcheck, R will be chopped
       \ to the first null if it contains any.  For this reason, the
       \ response is not checked in the ELSE branch since it operates
       \ for trusted clients.
         (qR) S RESPONSEcheck exe (qR)

      ELSE (ptr) \ run the word that provides the response:
         " HTTPput: running ptr to word " over ptrtok + . nl
         (qT ptr) S swap (ptr) exe (qR)

       \ Debug.  Save the response in local library: 
         (qR) this "RESPONSE" book
      THEN

    \ Send the response:
      S socket_open IF (qR) S remoteputf ELSE (qR) drop THEN

    \ Close socket S if flag is true:
      SCLOSE_ON_EXIT IF S sclose THEN

    \ Log the response time:
      " HTTPput: client " . IP . " socket " S intstr + 
      SCLOSE_ON_EXIT IF " closed " ELSE " kept open " THEN + .
      time pull less 1000 * intstr .  " msec " . date . nl

      yes "SCLOSE_ON_EXIT" book \ reset default

      ERR
   end

   inline: IPloop ( --- qS) \ loopback IP address
      [ "127.0.0.1" is L ] L ;

   inline: localsockets ( --- hR) \ local clients connected to remote
      clientsockets this 3rd catch rake drop 1st catch
      "_localsockets" naming
   end

   inline: MAXBLOCK ( --- sec) \ time to block a pending socket read
      [ 6 is sec ] sec ;

   inline: monkeyIP ( --- qIP) \ query ipmonkey.com for this IP addr
\     Query http://ipmonkey.com for this machine's IP address.
      [ "IP Address:" "IP" book ]

      "HTTPget" "UA" yank "UAsav" book

    \ Make us look like MS Internet Explorer:
      "HTTPget" "msieUA" yank "HTTPget" "UA" bank

    \ Save connection output on log file to show only if there is
    \ an error:
      SYSOUT "SYSOUTsav" book
      ftempsys (qLOG) dup "ERRLOG" book (qLOG) set_sysout

      "http://ipmonkey.com" "/" HTTPget (hHTML)

      SYSOUTsav set_sysout \ back to regular output

      (hHTML) any?
      IF (hHTML) html2text textget dup IP grepr any? (hR f)
         IF (hHTML hR) @ quote IP "" strp strchop (qIP) \ extract IP

         ELSE (hHTML) drop 
            " monkeyIP error: no IP address received" . nl 
            "" (qIP) \ return empty string

         THEN
      ELSE
         " monkeyIP connection error log:" . nl
         ERRLOG asciiload 2 indent . nl
         "" (qIP) \ return empty string
      THEN
      ERRLOG deleteif
      UAsav "HTTPget" "UA" bank

      (qIP)
   end

   inline: net_file_time (qDir --- nsec) \ file time latency on network
{     Returns current clock time less file time for a file just written
      in directory Dir.

      On a standalone machine, net_file_time should be zero.

      Requires write permission in Dir.

      Examples:

         Directory /tmp is local to the machine, so lag is zero:
            [tops@riggo] ready > "/tmp" net_file_time .i nl
             0

         Present working directory is on the network:
            [tops@riggo] ready > pwd net_file_time .i nl
             191 (time on file lags clock by 191 seconds)

         User's home directory is on the network:
            [tops@riggo] ready > "HOME" env net_file_time .i nl
             192 (time on file lags clock by 192 seconds)

      Word dir_watch (file dog.v) uses this word to adjust file time
      to clock time.
}
      (qDir) runid catpath ".net_file_time" + (qFile) push
      NLch peek (qFile) save
      time (t2) peek (qFile) filectime (t2 t1) less (nsec)
      pull (qFile) delete
   end

   inline: new_conn (nS --- ) \ runs when S has just connected
{     This word is run by drainf(), file net.c, when a new client 
      running this program connects.  

      A server can bank into PTR a ptr to a word to run whenever 
      this occurs.  See word new_conn_say() for an example.

      PTR is to a word with the stack diagram (nS --- ).

}     [ 0 "PTR" book ] 
      (nS) PTR dup ptr? IF (nS ptr) exe ELSE 2drop THEN
   end

   inline: new_conn_say (nS --- ) \ announce new socket connection
{     Sun Oct 30 00:07:38 PDT 2011

      On a SERVER, bank the pointer to this word into new_conn(),
      and every time a CLIENT connects, this word will announce
      the connection.

      This word is just a simple example.  Most applications have
      more to do than just announce a new socket connection, and
      a word like this can be made to do a lot more.

      Using this word with new_conn():

         Run one of these phrases to bank ptr("new_conn_say") into 
         word new_conn:

            postfix: "new_conn_say" ptr "new_conn" "PTR" bank

            infix: new_conn.PTR = ptr("new_conn_say");

         Example:
            >> new_conn.PTR = ptr("new_conn_say");

            >> wholib("new_conn");
             Variables in the library of word new_conn:
              Name Rows Cols Bytes Type  Description
              PTR  0    0    8     NUM   ptr->new_conn_say
                             8     total
}
      " new connection on socket:" . .i nl
   end

   inline: nfs_load (qFile --- hT) \ an nfs text file to the stack
    \ Tue Sep  6 17:55:45 PDT 2011.

    \ File name includes the path, like /nfs/.

    \ File may contain nulls, so word asciiload will not work.  In
    \ returned T, nulls have been replaced by blanks.

      [ "" "nfs_file" book ]
      nfs_file filetrue IF nfs_file fclose THEN

      (qFile) forn "nfs_file" file
      nfs_file INF fget " " nulrp

      nfs_file fclose
   end

   inline: nfs_mounts ( --- hT) \ list of nfs mounts on the system
{     Tue Sep  6 05:45:29 PDT 2011.  Returned T is a list of directories
      that are nfs mounted to clients on this machine.

      An empty volume is returned if there are no nfs mounts.

      Nfs mounted clients in list T should unmount before the client 
      machine shuts down, or on reboot the kernel may continually try
      to link to the server even though the server may not even be 
      running, as described next.

      Here is a message in /var/log/messages from kernel on localhost 
      plunger trying to reach nfs server .103 which is no longer run-
      ning:
   
         Sep  5 14:49:13 localhost kernel: nfs: 
            server 192.168.1.103 not responding, still trying

      With effort trying by the kernel, work level hovered around 1.0
      instead of dropping to near zero.  (Displaying top CPU processes 
      with /usr/bin/top showed no processes hogging the time, which
      probably means it was the kernel.)  

      By starting the nfs server on .103, and then running "umount" on
      localhost plunger to properly unmount the nfs directory, the pro-
      blem vanished and workload on plunger dropped to near zero.

      This is a typical response to system command "mount -t nfs" that 
      is run below by shell:

         192.168.1.104:/nfs on /mnt/nfs/plunger type nfs \
         (rw,hard,intr,rsize=8192,wsize=8192,addr=192.168.1.104)

      The third word, /mnt/nfs/plunger, is the mounted directory on this
      machine, and is returned in T.  If there are others, returned T 
      will contain more than one line.
}
      "/bin/mount -t nfs > " scratch + shell
      scratch asciiload scratch delete noblanklines (hT) any?
      IF (hT) 3rd word (hT f) drop (hT) "_nfs_mounts" naming
      ELSE VOL tpurged
      THEN (hT)
   end

   inline: NIST_DELTA ( --- ) \ sync program time with NIST time
{
      Sun Mar  2 12:23:08 PST 2014.  The branch to run NIST_SYNC
      is only taken if this process is using the public channel.

      Wed Feb  9 20:53:47 PST 2011.  Set the SEC alarm for next time
      at the beginning rather than the end to remove the delay due to
      execution time.

      Mon May 10 13:35:31 PDT 2010

      Usage: One program must be running word NIST_SYNC, to periodi-
         cally write the machine time correction to the interprocess
         message file.

         All other programs can then run this word to fetch the time 
         correction from the interprocess message file.  

         This is more reliable than all programs trying to connect to 
         NIST at various time by running NIST_SYNC or by running 
         TIME_SYNC to connect over a socket to another program that 
         runs NIST_SYNC.

      Try first to retrieve the time correction from the interprocess
      message file, then run NIST_SYNC if there is nothing.

      After it first runs, this word will run again every SEC.

      Sometimes connecting to NIST with NIST_SYNC (using NISTdelta) can
      take a long time.

      For the sound file server, such a delay caused some clients to
      lose their connections and resulted in a loss of voice messages
      with no way to know there was even a problem.  

      The risk of such a problem is eliminated when this word used in 
      conjunction with another program that updates the time correction
      on the interprocess message file.
}
      [ 86400 "SEC" book ]

      SEC "NIST_DELTA" ALARM \ run again in SEC

      "msgPeep" exists?
      IF "NIST_DELTA" msgPub msgPeep any?
         IF numerate @ (sec) dup "DELTA" book GMTdelta
            " NIST_DELTA: time sync with NIST, " DELTA intstr + 
            " sec, " + date + . nl
            false
         ELSE true
         THEN
      ELSE true
      THEN (f)
      IF msgPub?
         IF NIST_SYNC          \ run NIST_SYNC
            "NIST_SYNC" -ALARM \ turn off its alarm for next time
         ELSE " NIST_DELTA: must be run by a public server" . nl 
         THEN
      THEN
   end

   inline: NIST_SYNC ( --- ) \ sync program time with NIST time
{
      Other programs can get the NIST correction from the public
      interprocess message file using NIST_DELTA, msgPeek or msgPeep.

      Sun Mar  2 12:23:08 PST 2014.  Require the process running this
      function to be using channel msgPub so NIST time goes to the
      public message file.

      Tue Jan 11 17:58:16 PST 2011.  Set the SEC alarm for next time 
      at the beginning rather than the end to remove the delay due to
      execution time.

      Thu Dec  2 14:34:45 PST 2010.  Try to run again in LWAIT seconds
      if LOCKED is true.

      Mon May 10 13:35:31 PDT 2010.  Write the time correction to the
      interprocess message file.

      After it first runs, this word will run again every SEC.
}
      [ 86400 "SEC" book, 20 "LWAIT" book, no "VERBOSE" book ]

      msgPub? not
      IF " NIST_SYNC: must be run by a public server" . nl return THEN

      LOCKED (f)
      IF " NIST_SYNC: system is locked; try again in" . LWAIT .i
         " seconds" . nl
         LWAIT "NIST_SYNC" ALARM \ wait a little while and run again
         return
      THEN

      SEC "NIST_SYNC" ALARM \ run again in SEC

      VERBOSE 
      IF syspath "net.v NIST_SYNC" + ERRset \ begin 1
      ELSE
       \ Save error output from word NISTdelta to a temp log file to
       \ show only if there is an error:
         SYSOUT push
         ftempsys (qFtemp) dup "FTEMP" book (qFtemp) set_sysout
      THEN

      syspath "net.v NIST_SYNC call to NISTdelta" + ERRset \ begin 2
      NISTdelta (sec) "DELTA" book
      ERR \ end 2

      VERBOSE not IF pull (SYSOUT) set_sysout THEN \ restore output unit
   
      DELTA UDEF <>
      IF DELTA (sec) GMTdelta

         "NIST_DELTA" msgDel DELTA (sec) intstr "NIST_DELTA" msgPut

         " NIST_SYNC: time sync with NIST, " DELTA intstr + " sec, " + 
         date + (hT)
      ELSE
         " NIST_SYNC: error in time sync with NIST " date + ":" + . nl
         FTEMP asciiload (hT) 3 indent (hT)
      THEN
      (hT) . nl 

      VERBOSE 
      IF ERR \ end 1
      ELSE FTEMP deleteif 
      THEN
   end

   inline: NISTdelta ( --- sec) \ NIST time minus the machine's time
{      Sun Aug 14 09:03:23 PDT 2011.  This word will be replaced by
       word NISTdelta contained in any of the following files which 
       are read (in the order shown) after this one:
               tops/sys/uboot.v
               tops/usr/uboot.v
               mytops/usr/uboot.v

       As an example, see tops/usr/uboot.v.
}
      _NISTdelta
   end

   inline: PING (qIP --- f) \ f true if Unix ping returns 0% loss for IP
{     Thu Feb 18 10:57:37 PST 2010

      The program is idled while this word runs.

      Examples:
         IPlocal PING \ test local Internet connection
         "google.com" PING \ test remote host
         "127.0.0.1" PING \ check loopback
}
      [ "_bin" "tmppath" yank (qTMP) runid + "_PING_" + ftemp (qFile)  
        (qFile) "LOG" book
        LOG deleteif

      \ Rate of packets sent is one per second.  Set up ping to send
      \ 4 packets and finish in no more than 10 seconds:
        SBIN "ping -c 4 -w 10 " + "XXX > " + LOG + " & " + (qS)
        (qS) "COMMAND" book

        "4 packets transmitted, 4 received, 0% loss" "OK" book
      ]
      (qIP) dup chars 0= IF drop fail return THEN \ empty string

      15 expectout
      COMMAND "XXX" rot strp (qS) running (f)
      IF 2 idle \ let ping finish LOG file
         LOG asciiload noblanklines (hT) any?
         IF (hT) OK grepr any?
            IF drop true ELSE fail THEN
         ELSE fail
         THEN
      ELSE " PING: word running failed on script" . nl
         fail
      THEN
      30 expectout \ back to default setting
      LOG deleteif
   end

   inline: port_on (nPort --- f) \ f is true if Port is being used
    \ Sat Aug  8 11:27:21 PDT 2009

    \ This word shows how to use nextport to see if a port is active.
    \ If active, any program may be using the port, not just this one.
      (nPort) dup -1 >
      IF (nPORT) dup nextport = not \ in use if nPORT!=nextport
      ELSE drop no
      THEN
   end

   inline: port_listening (Port --- f) \ f is true if listening on Port
{     Flag f is true if Port is a listening port.

      This program may or may not be the one doing the listening.

      Assumes a line in netstat display of one of these forms:
         tcp   0   0 *:9877      *:*         LISTEN (Linux)
         tcp4  0   0 *.9877      *.*         LISTEN (AIX)

      Accounts for AIX style where dot is used instead of colon.
}
      [ "netstat -a | grep PORT > FILE" "command" book  

      \ Tue May 17 01:06:11 PDT 2011.  Add runid to name of TMP so it
      \ is unique, and one of two sumultaneous jobs won't delete the
      \ other's TMP file:
        "HOME" env runid "port_listening.tmp" + catpath "TMP" book ]

      0 STR stkok, 1 NUM stkok or not
      IF "port_listening" stknot return THEN

      dup type NUM = IF intstr THEN "Port" book

      command (hT)
      "PORT" Port strp (hT)
      "FILE" TMP strp (hT)
      (hT) vol2str strchop (qS)

      (qS) shell TMP asciiload TMP delete (hT)
      (hT) asciify noblanklines any?
      IF this "LISTEN" grepr any?     \ grep for LISTEN
         IF reach "." ":" strp        \ AIX . to Linux :
            ":" Port + grepr rows any \ grep for Port
         ELSE drop no
         THEN
      ELSE no
      THEN
   end

   inline: REMOTE-DN (nP qIP nPORT --- ) \ IP:PORT shut down server on P
{     Wed Mar 19 19:07:58 PDT 2014

      Contact the server at IP:PORT and have it shut down the local
      server at IP that is listening on port P.

      Note that IP and PORT are in the same stack order as they are
      for REMOTE-UP.

      Warning: Don't switch P and PORT.  Switching P and PORT usually
      will work but will not do what was intended.  
}
      depth 3 < IF "REMOTE-DN" stknot return THEN

      "PORT" book "IP" book "P" book

      IP PORT CLIENT "S" book S -1 >
      IF " REMOTE-DN: connected to " . IP ":" + PORT intstr + . nl

         " REMOTE-DN: shutting down port" . P .i nl

       \ Make phrase T to be run on remote PORT:

          \ 1. On remote PORT, close the socket from here:
               "remotefd sclose " (qT)

          \ 2. On remote PORT, run DSERV-DN to shut down server on P:
               (qT) P intstr + " (nPORT) DSERV-DN" + (qT)

       \ Run phrase T on remote port PORT:
         (qT) S remoterun S sclose

         " REMOTE-DN: done" . nl

      ELSE " REMOTE-DN: failed to connect to " . 
         IP ":" + PORT intstr + . nl
      THEN
   end

   inline: REMOTE-UP (qIP nPORT --- nP) \ IP:PORT started server on P
{     Wed Mar 19 20:42:58 PDT 2014

      Contact the server at IP:PORT and have it start a local server
      and send back the number P of its listening port.

      Returns invalid P=-1 if starting a server failed.

      The server at IP runs DSERV-UP() which starts script usr/dserv1.  

      See DSERV-UP() in this file for the command line options it uses
      when starting dserv1.  For example, when initially started the
      server is set to run for 5 days and allow connections only from
      the local loopback IP address, 127.0.0.1.

      The Example below shows a session using REMOTE-UP.
}
      [
{        The following phrases make a list of commands, T.  They are 
         nested within brackets, so they only run once when this word
         is sourced.  Then T can be used over and over whenever this
         word runs.

         The phrases are in quotes, and are strung together on the 
         stack by + into command string T that is later sent to the 
         server to run.  Each quote is written to ensure a blank space, 
         tail to head, at the join point. 

         Word remoterun1() will send command string T from here to the
         server (at IP:PORT) on socket S, where it will be run.  The 
         last part of the string, "THEN (nP) remotefd remoteput," will
         make the server send port number P back through S to here, 
         where it will appear on this machine's stack.

         There are three processes on two machines involved here:

            1 - This client wanting a port to a new server on remote IP

            2 - The server on remote IP:PORT working to set up a new 
                server on IP at port P for this client

            3 - The new server on remote IP:P 
 
         The phrases in T involve interactions between 1 and 2 and be-
         tween 2 and 3.  When T runs, the new server on IP:P will be
         started and this client will be given its port number P.  In-
         structions in T guarantee that the new server will allow this
         client to later connect to it on IP:P, using word CLIENT().

         Comments in the following are the server at IP:PORT talking.
         They apply to operations as it interacts with the new server
         to set up connect permissions for the client, and then as it
         sends the new server port number back to the client.
}
       \ Start a new server for the client:
         "DSERV-UP (nP) dup -1 > "
         "IF (nP) " +

          \ Open a connection to the new server and put my client's IP
          \ address into the allowed lists:
            "IPloop over (nP) CLIENT (nS) dup -1 > " +
            "IF (nS) " +
 
             \ Get my client's IP address:
               "clientIPs remotefd clientindex quote (qIP) " +

             \ Allow my client to connect to this machine:
               "(nS qIP) dup '+CLIENT_ALLOW' (qIP qT2) " +
               "(nS qIP qIP qT2) 3 pick (nS) remoterun2 " +
 
             \ Allow my client to connect to new server running tops,
             \ and then close the socket from new server to me:
               "(nS qIP) '+SERVER_ALLOW remotefd sclose' (qIP qT2) " +

               "(nS qIP qT2) 2 pick (nS) remoterun2 " +
  
             \ Close the socket from me to new server:
               "(nS) sclose " +
 
          \ Connection to new server failed, can't install client's IP
          \ address.  Close new server and send invalid P=-1 to client:
            "ELSE (nP nS) sclose 3 idle DSERV-DN -1 (nP) " +
            "THEN (nP) " +

       \ The new server is running and will allow the client to connect;
       \ send the port number of the new server back to the client:
         "THEN (nP) remotefd remoteput" + (qT) 

         (qT) \ list of commands to have server at IP:PORT run

       \ Thu Mar 20 21:33:51 PDT 2014.  Make T into a macro.  Instead
       \ of sending a list of commands to the server, send a command to 
       \ have it run its macro REMOTE-UP.T which is just like this one:
         (qT) "T" macro
      ]
{
      Fri Mar 21 03:54:05 PDT 2014.  Aside.  Below are the phrases that
      run every time this word runs.  They involve connecting to remote
      IP:PORT on socket S, and then running postfix phrases that are
      equivalent this infix expression that shows concisely to a human
      reader just what is being done (infix is read from inside (inner-
      most) to outside):

         P = sclose(remoterun1(localrun(REMOTE-UP.T), S), S);

      It's obvious that a parser is needed to take apart the infix ex-
      pression above and figure out a list of commands to run step by
      step, and where to run them--on this end, or that end, of socket 
      connection S.  

      Postfix, not infix, is used in commands sent over sockets.  Like
      notes in a score, postfix literally means step-by-step, so the
      added imposition of a parser, either here or at the other end of
      socket S, is unnecessary.

      See src/net.c text at "The parsing branch below works great in
      certain cases" where it took about ten minutes of actual practice
      (in 2005 when the infix parser, src/prs.c, was made) to figure 
      out the rule about no infix over sockets.
}
      depth 2 < IF "REMOTE-UP" stknot return THEN
      "PORT" book "IP" book 

    \ Save connection output on log file to show only if there is an
    \ error:
      [ "" "ERRLOG" book ] ERRLOG deleteif 
      SYSOUT "SYSOUTsav" book
      ftempsys (qLOG) dup "ERRLOG" book (qLOG) set_sysout

    \ Connect to the server at IP:PORT:
      IP PORT CLIENT "S" book S -1 > (f) \ connect on socket S:

      (f) SYSOUTsav set_sysout \ from ERRLOG, back to console output

      IF " REMOTE-UP: connected to " . IP ":" + PORT intstr + . nl
       \ At IP:PORT, run commands in macro REMOTE-UP.T and get back
       \ port number P.  Word remoterun1() blocks until stack item nP
       \ arrives or until it times out in 30 seconds (default):
         "'REMOTE-UP' 'T' localrun" (qT)
         (qT) S remoterun1 (nP) \ wait for port number P

         " REMOTE-UP: server up at " IP ":" + + over (nP) intstr + . nl
         "remotefd sclose" S remoterun S sclose \ close both ends of S

         " REMOTE-UP: done" . nl
      ELSE 
       \ Sat Jun  7 14:54:29 PDT 2014.  Add multiple attempts to con-
       \ nect:
         [ 3 "TRY-MAX" book 0 "TRY" book -1 "bad_port" book ]
         1 TRY bump TRY TRY-MAX 1- > 
         IF " REMOTE-UP: failed to connect to " . IP . ":" . PORT .u
            " in" .  TRY-MAX .i " attempts" . nl 

            " REMOTE-UP: xray of error log:" . nl
            ERRLOG "BIN" file BIN INF xray . \ xray of error log
            BIN close 

            bad_port (nP) \ return an invalid port number
         ELSE 
          \ Idle a couple of seconds and try running this word again:
            2 idle
            IP PORT REMOTE-UP (nP)
         THEN
      THEN (nP)
      ERRLOG deleteif 
      0 "TRY" book
      (nP)
   end
{
   Example.  Output from a session running REMOTE-UP.  Some blank lines
   have been inserted to make the output more readable.

      [dale@plunger] /home/dale > tops
               Tops 3.2.1
      Thu Mar 20 19:14:38 PDT 2014
      [tops@plunger] ready > host .
      plunger
      [tops@plunger] ready > topsdog.com 6011 REMOTE-UP
 
       stack elements:
             0 number: 7021
       [1] ok!

      [tops@plunger] ready > topsdog.com 7021 CLIENT, clients
       Server local is off
       Clients:
        socket 3, port  7021, conn C>S, XXX.XXX.XXX.XX xxxxx topsdog

       stack elements:
             0 number: 3
             1 number: 7021
       [2] ok!
      [tops@plunger] ready > 3 remoteprompt [moving to prompt on server]
      tops@socket3 > host .
      topsdog

      tops@socket3 > clients
       Server local is listening on port 7021
       Clients:
        socket 2, port 45992, conn S<C, 174.47.228.170 \
           LOGIN dale plunger

      tops@socket3 > CLIENT_ALLOWING .
      127.0.0.1      loopback
      174.47.228.170

      tops@socket3 > SERVER_ALLOWING .
      127.0.0.1      loopback
      174.47.228.170

      tops@socket3 > whos
       Variables added to the main library:
        Name Rows Cols Bytes Type  Description
        FILE 1    0    0     STR   string(empty)
        LOG  1    22   22    STR   string
        EOL  0    0    8     NUM   43200
        f    0    0    8     NUM   0
        PORT 0    0    8     NUM   7021
                       46    total

      tops@socket3 > tasks
       Multitasker tasks:
        exit,0:CODE__ alarm period 432000 seconds; remaining 431937

      tops@socket3 > LOG .
      /tmp/T24959_dserv1.log

      tops@socket3 > [pressing Esc+q and returning to plunger]
 
       stack elements:
             0 number: 3
             1 number: 7021
       [2] ok!
      [tops@plunger] ready > sclose
 
       stack elements:
             0 number: 7021
       [1] ok!
      [tops@plunger] ready > topsdog.com 6011 REMOTE-DN
 
      [tops@plunger] ready > bye
      191 keys
                Good-bye
      Thu Mar 20 19:21:14 PDT 2014
      [dale@plunger] /home/dale >

   Entries in the log file made by remote IP:PORT (IP:6011) for this
   session are shown next.

   This shows the connection from here at 02:14:48 UTC to make the 
   server (DSERV-UP was run when we ran word REMOTE-UP; see session
   above):

      Fri Mar 21 02:14:48 UTC 2014 SERVER: 174.47.228.170 connect
       -120 bytes delta: memprobe socket 2 connect
       DSERV-UP: server on port 7021, connected in 1.07 sec
       clientclose: socket 2 closing on flag 2, Fri Mar 21 02:14:52 \
          UTC 2014
       clientclose: socket 2, port 45992, conn S<C is closed

   Here is connection at 02:17:59 UTC to shut down the server (DSERV-DN
   was run when we ran word REMOTE-DN; see session above):

      Fri Mar 21 02:17:59 UTC 2014 SERVER: 174.47.228.170 connect
       16 bytes delta: memprobe socket 2 connect
       DSERV-DN: shut down server on port 7021
       clientclose: socket 2 closing on flag 2, Fri Mar 21 02:18:02 \
          UTC 2014
       clientclose: socket 2, port 46018, conn S<C is closed

   Unfortunately the log file for remote IP:P (IP:7021) for this session
   (noted as /tmp/T24959_dserv1.log above) was deleted when the server
   was shut down (us running REMOTE-DN above), because the option to 
   save the log has been commented out in the definition for DSERV-UP
   in this file (see command line switch -logsave in the source for 
   DSERV-UP in this file; search for string ": DSERV-UP").
}
   inline: REMOTEdelta (nSocket --- sec) \ time remote minus time local
\     Remote machine time minus local machine time.
\     If sec is positive, time on the remote machine is ahead of local.

      [ "date sysdate ltime remotefd remoteput" "GET_TIME" book ]
      GET_TIME swap (qS nSocket)

      (qS nSocket) remoterun1 (sec_remote)

      date sysdate ltime (sec_local)

      (sec_remote sec_local) less
   end

   inline: remoteack (hSockets --- f) \ remotes acknowledge
{     Waits for up to SEC seconds for acknowledgement from all remote
      connections to Sockets.

      This program is presumed to be running at the other end of all
      Sockets.
}
      [ 30 "SEC" book, no "FLAG" book
{
        This one-line macro is run by the multitasker during the wait
        period.  It is run by word WAITING, the multitasker assistant
        to word WAIT_INIT, and in this case returns true when all re-
        motes have acknowledged a connection as evidenced by the number
        of rows in local matrix ACK:
}          'SOCKETS rows "ACK" local rows = (f) dup "FLAG" book (f)'
           "ack" macro

      \ A remote makes the program here add the remote's socket number
      \ to the local list, ACK, by having it run this macro as its
      \ acknowledgement:
        {"
           remotefd
           "ACK" local pile
           "ACK" book

         \ Maybe all socket numbers are now piled in ACK, so do not
         \ wait for the next multitasker cycle for word WAITING to
         \ be run.  Run word WAITING now:
           WAITING \ runs word ack shown above

        "} "pile_ACK" macro

        no one null "ACK" book \ local list of acknowledged sockets
      ]
      hand zero MAT stkok not
      IF "remoteack" stknot return THEN

      no "FLAG" book

      (hSockets) any?
      IF "SOCKETS" book
         no one null "ACK" book \ initialize local list of sockets

         [ {" With this phrase, a remote makes the program run pile_ACK:
             "'remoteack' 'pile_ACK' localrun" remotefd remoterun
           "} strchop "JOB" book
         ]
         SEC                        \ seconds to wait
         "remoteack" "ack" localref \ full lib name of local word ack
         (nSEC qWORD) WAIT_INIT     \ initialize WAITING

         ercnt push
         JOB (qJOB) SOCKETS remoterun
         ercnt pull - 0=
         IF WAIT_BEGIN              \ WAITING until ack returns true
         ELSE " remoteack: remoterun failed" . nl no "FLAG" book
            "WAITING" -ALARM \ turn off WAITING, started by WAIT_INIT
         THEN
      THEN
      FLAG (f)
   end

   inline: remoteclients (nSocket --- hT) \ run word clients on remote
\     Get what the word clients would show at remote end of Socket.
      no NUM stkok not IF "remoteclients" stknot return THEN
      this 0> not IF drop "socket closed" hand return THEN
      (nSocket) "'clients' >stk" that remoterun (nSocket) remoteget
   end

   inline: remotehost (nSocket --- qS) \ name of host at end of Socket
      no NUM stkok not IF "remotehost" stknot return THEN
      this 0> not IF drop "socket closed" hand return THEN
      (nSocket) "host" that remoterun (nSocket) remoteget
   end

   inline: remotekeys (hT nSocket --- ) \ run the keyboard at Socket
\     Assumes the remote has keyboard enabled; run word keys? remotely
\     to see, with a phrase like:
\        [tops@dobro] ready > "keys? remotefd remoteput" 6 remoterun1

      "S" book (hT) textput these chars 1st
      DO this I character S remoteput "key_in" S remoterun LOOP
      drop
   end

   inline: remoteputf1 (qT nS1 nS2 --- ) \ send T to S1, echoes to S2
\     Send T to S1 and send echoes received to S2.  Bytes of T are
\     sent one at a time.
      "S2" book "S1" book "T" book
      T chars 1st
      DO S1 T I catch that remoteputf MAXBLOCK BLOCK (qR)
         (qR) S2 remoteputf
      LOOP
   end

{  Below is an alternative version of remoteputmat (file net.c) that
   uses an indeterminate wait state to wait until the matrix is re-
   ceived on the remote.
}
   inline: remoteputmat1 \ (hA nSocket --- ); stack on remote: ( --- hA)
{     Sent matrix A to the remote on Socket.

      Begins an indeterminate wait state with word WAIT_BEGIN, and
      counts upon a WAIT_END command from the remote after the matrix
      is received.

      To be safer, an alarm could be set using WAIT_ALARM before saying
      WAIT_BEGIN (as in TASK_PORT).

      January 2008:
      USING WAIT_END IS A BAD IDEA BECAUSE IT DESTROYS THE SYNCHRONI-
      ZATION WITH A SIMULTANEOUS WORD ALSO USING WAIT_BEGIN.  SEE
      NOTE IN WORD WAIT_INIT, FILE sys.v.  WAIT_END HAS BEEN REMOVED 
      FROM TASK_PORT AND SHOULD ALSO NOT BE DEVELOPED HERE.

      This word is experimental.  Word remoteput will send a matrix to
      a remote.
}
      zero NUM stkok not
      IF "remoteputmat1" stknot return THEN

      swap this type MAT = that type NUM = or not
      IF swap "remoteputmat1" stknot return THEN (nSocket hA)

      (nSocket hA) that socket_open not
      IF " remoteputmat1: socket is not open" ersys return THEN

      (hA) export8n (hT) \ MAT to network endian VOL

    \ The following phrase run on the remote will send command WAIT_END
    \ to here after it gets the matrix from the stack.  Then the remote
    \ will run import8n to convert network endian to its endian:
      "remotefd remoteget 'WAIT_END' remotefd remoterun import8n" (qS)

      rot (hT qS nSocket) remoterun

      WAIT_BEGIN \ begin indeterminate wait until remote says WAIT_END
   end

   inline: remoteprompt (nSocket --- ) \ run at a prompt on Socket
{     Begin running interactively on a remote instance of the program
      on connected Socket.  Pressing Esc-q returns to the ready prompt
      of this program.  The remote program remains connected.

      Example: Connecting to server, which returns socket 6, then
      running remoteprompt on socket 6.  Word clients on the server
      shows four clients connected to it (S<C).  Running word remotefd
      on the server shows that our socket 6 is its socket 7.

         [tops@clacker] ready > IPloop 9877 CLIENT

          stack elements:
                0 number: 6
          [1] ok!
         [tops@clacker] ready > clients
          Server local is off
          Clients:
           socket 6, port  9877, conn C>S, 127.0.0.1 dale clacker

          stack elements:
                0 number: 6
          [1] ok!
         [tops@clacker] ready > remoteprompt
         tops@socket6 > clients
          Server local is listening on port 9877
          Clients:
           socket 3, port  9881, conn C>S, 127.0.0.1 dale clacker
           socket 5, port 32778, conn S<C, 127.0.0.1 LOGIN dale clacker
           socket 6, port 32779, conn S<C, 127.0.0.1 LOGIN dale clacker
           socket 7, port 32780, conn S<C, 127.0.0.1 LOGIN dale clacker
           socket 8, port 32781, conn S<C, 127.0.0.1 LOGIN dale clacker
           socket 9, port  9880, conn C>F, 127.0.0.1 dale clacker
         tops@socket6 > remotefd .i
          7
         tops@socket6 >

      WARNING: typing bye, exit, quit will close the remote program
      resulting in "broken pipe" and probable seg fault in the local
      program.  Words like these are caught using exe_remote to install
      substitutes.  See "Remote word substitutions" below in this file.
}
      no NUM stkok not IF "remoteprompt" stknot return THEN

      this socket_open
      IF (nSocket) pname "@socket" other intstr " > "
         + + + remoteprompter
      ELSE " remoteprompt: socket " swap intstr " is not open"
         + + ersys
      THEN
   end

   inline: remoteprompt_run (qS --- ) \ phrase to run text at remote
\     This inline runs the text at the remote prompt when running
\     word remoteprompt or word remoteprompter.
      >stk remotefd remoteput nullbyte remotefd remoteput
   end

   inline: remoteprompt_stk ( --- ) \ phrase to run remote stk display
\     This inline displays the remote stack when running word remote-
\     prompt or word remoteprompter.
      ok @ ".sf" >stk remotefd remoteput
   end

   inline: remotercv (nS nSec nBytes --- qT) \ receive Bytes in Sec on S
{     Block the program until pending reads from socket S return a total
      of Bytes or more, or until time out after Sec seconds.

      After Bytes have been received, the program resumes normal opera-
      tion.
}
      [ no "Bytes" book 
        no "ptrSav" book
        no "S" book

        {" rcv (qT1 qT2 nS --- qT) \ receive bytes from drainf()
           (nS) drop

           (qT1 qT2) +

           NTRACE
           IF " rcv: got:" . these chars .i " need:" . Bytes .i nl THEN

           these chars Bytes >=
           IF (qT) \ have Bytes or more:
              NTRACE IF " rcv: done; have" . these chars .i nl THEN

              ptrSav S ptrRun_upd \ put back saved ptrRun

            \ Run ptrRun(T), just as drainf() would for NATIVE client:
              (qT) ptrSav 0<> 
              IF { Mimic this code in drainf(): 
                     return(
                        pushint(sockfd) &&
                        pushd(ptrRun) &&
                        exeq() && /* stk: qT nSocket ptrRun */
                        drop() /* dropping flag left by exeq() */
                     );
                 }
                 (qT) S ptrSav exe? (f) drop 
            \ ELSE (qT) \ drainf() just returns with T on the stack
              THEN
              no HOLD \ break HOLD, and normal operation resumes
              yes "OK" book
           THEN
        "} "rcv" macro \ local macro to receive bytes from drainf()

        defname "rcv" localref ptr "ptr_rcv" book
      ] 
      "Bytes" book "Sec" book "S" book
      no "OK" book \ can be yanked later to see if OK=yes

      "" (qT) \ initial empty string

      S ptrRun "ptrSav" book
      ptr_rcv S ptrRun_upd

      yes HOLD
      (qT) S Sec BLOCK

    \ Put back saved ptrRun in case rcv did not, due to time out:
      OK not IF ptrSav S ptrRun_upd THEN
   end

   inline: remoterun1 (hT hSockets --- ...) \ run T on all Sockets
{
      Fri Oct 29 07:12:32 PDT 2010.  Correct the stack when there is
      an error; use client_open instead of socket_open in macro TOTAL.

      Fri Oct 29 08:42:49 PDT 2010.  Testing this word:
         1. Start the program and open a listening socket on the next
         available port:
            [dale@plunger] /home/dale > tops
                     Tops 3.2.0
            Fri Oct 29 08:45:39 PDT 2010
            [tops@plunger] ready > "*" 9877 nextport SERVER clients
             Server local is listening on port 9887
             No clients

            [tops@plunger] ready > 

         2. Start the program in three other windows and connect each
         one to the listening server of step 1.  Here is a typical 
         connection being made in one of the other windows:

            Fri Oct 29 08:47:32 PDT 2010
            [dale@plunger] /home/dale > tops
                     Tops 3.2.0
            Fri Oct 29 08:47:39 PDT 2010
            [tops@plunger] ready > IPloop 9887 CLIENT

             stack elements:
                   0 number: 3
             [1] ok!
            [tops@plunger] ready > 

         3. On the server started in step 1, this shows the window in
         step 2 and the other two windows connecting:

            [tops@plunger] ready > 
            Fri Oct 29 08:47:47 PDT 2010 SERVER: 127.0.0.1 connect
             742936 bytes delta: memprobe socket 6 connect

            Fri Oct 29 08:48:59 PDT 2010 SERVER: 127.0.0.1 connect
             40 bytes delta: memprobe socket 7 connect

            Fri Oct 29 08:49:01 PDT 2010 SERVER: 127.0.0.1 connect
             40 bytes delta: memprobe socket 8 connect

            [tops@plunger] ready > clients
             Server local is listening on port 9887
             Clients:
              socket 6, port 46247, conn S<C, 127.0.0.1 LOGIN dale p...
              socket 7, port 46249, conn S<C, 127.0.0.1 LOGIN dale p...
              socket 8, port 46250, conn S<C, 127.0.0.1 LOGIN dale p...

            [tops@plunger] ready > 

         4. Test this word, remoterun1(), by having the server make 
         each client place its socket number on the server upon the 
         server's stack: 
            [tops@plunger] ready > "'remotefd' remotefd remoterun" 
            [tops@plunger] ready > sockets remoterun1

             stack elements:
                   0 number: 8
                   1 number: 7
                   2 number: 6
             [3] ok!
            [tops@plunger] ready > 

         5. The stack contents in step 4 conform to the socket numbers 
         shown in step 3; this test is complete.

      Words in T are run remotely on each connection in Sockets.  The
      program waits until every remote has sent back a stack item, or
      until SEC seconds have passed.

      T must contain a phrase that returns one (and only one) item to
      the program's stack.  This means that as many stack items are
      expected as there are rows in Sockets.

      If T has not been written to return a stack item, word ACK can
      be appended to it so a true flag will be sent when it finishes 
      running on the remote.

      If there are more sockets than returned stack items, the entire
      wait period will pass; i.e., if each remote does not return one
      stack item or causes the number of stack items to be reduced,
      the entire wait period will pass.

      Word remoterun1 is asynchronous, so each client must make the 
      server do exactly the same thing (if anything) regarding its 
      stack, and leave it with a single stack item when finished. 

      Examples:

         1. This grabs Done, a number, from each remote and returns it
            to the stack of this program (as a 1-by-1 MAT):
               "Done remotefd remoteput" (hT) sockets remoterun1

         2. Each remote makes the program place the remote's socket
            number on the program's stack (if you get this example,
            you understand remotefd):
               "'remotefd' remotefd remoterun" sockets remoterun1

         3. Placed inside of list: ... end to collect returned NUMs 
            into a column MAT:
               list: Text_run sockets remoterun1 end (hA)
}
      [ 30 "SEC" book

      { This macro called TOTAL is run in the multitasker by word
        WAITING, as this word waits for Nwait items to appear on the
        stack.  Word TOTAL returns f=true to stop WAITING when all
        sockets are done, or when any socket client prematurely closes:
      } {" ( --- f)
           depth d0 - Nwait < not (f1)
           list: Nwait 1st DO Sockets I pry client_open LOOP end 
           totals ontop abs Nwait <> (f2)
           (f1 f2) or dup "FLAG" book
        "} "TOTAL" macro
      ]
      depth two < IF "remoterun1" stknot return THEN

      hand (hA) swap (hT) textput (qS) swap
      true one MAT stkok and, two STR stkok and not
      IF "remoterun1" stknot return THEN

      (hSockets) any?
      IF (qS hSockets) "Sockets" book
         no "FLAG" book

         (qS) depth 1- "d0" book   \ "empty" stack depth to test
         Sockets rows "Nwait" book \ number of stack items to wait for

         SEC                       \ sec to wait for remote responses
         "remoterun1" "TOTAL" localref \ full lib name of macro TOTAL
          (nSEC qTOTAL) WAIT_INIT
{
         Add a line to T to have the remote cause this program to run
         word WAITING, which has been given the job to run local inline
         TOTAL defined above (see WAIT_INIT above).

         Word WAITING can be run as soon as FLAG from TOTAL might become
         true, and the time waiting for the next multitasker cycle to 
         run word WAITING can be saved (warning: "remotefd sclose" must
         not be run somewhere in T (now S on the stack) or the socket 
         will be invalid when used here; must wait until WAIT_BEGIN 
         finishes (Fri Mar 28 11:59:44 PDT 2014)):
}        (qS)
         " 'WAITING' remotefd remoterun" (qS1) \ ending for S
         (qS qS1) + (qS)

         ercnt push
         (qS) Sockets remoterun \ run S on all remotes
         ercnt pull - 0=
         IF WAIT_BEGIN \ WAITING until word TOTAL returns true
            FLAG not \ flag from TOTAL was not true?
            IF " remoterun1: " SEC intstr + " second wait has passed" +
               . nl
               depth d0 > IF depth d0 - dump THEN
            THEN
         ELSE " remoterun1: remoterun failed" . nl no "FLAG" book
            "WAITING" -ALARM \ turn off WAITING, started by WAIT_INIT
            depth d0 > IF depth d0 - dump THEN
         THEN

         depth d0 less Nwait < \ make up stack shortage with false NUMs
         IF depth d0 less Nwait swap less 1st
            DO false LOOP
         THEN

      ELSE (qS) " remoterun1: no connections" + sp . nl
      THEN
   end

   inline: remotesockets ( --- hR) \ remotes connected to local
\     R is purged if no remotes are connected to local server.
      clientsockets this 3rd catch rake lop 1st catch
      "_remotesockets" naming
   end

   inline: remotestack (nSocket --- hT) \ get stack display at Socket
      no NUM stkok not IF "remotestack" stknot return THEN
      this 0> not IF drop "socket closed" hand return THEN
      (nSocket) "yes '.sf' >stk" that remoterun (nSocket) remoteget
   end

   inline: remotetasks (nSocket --- hT) \ multitasker tasks at Socket
      no NUM stkok not IF "remotetasks" stknot return THEN
      this 0> not IF drop "socket closed" hand return THEN
      (nSocket) "'tasks' >stk" that remoterun (nSocket) remoteget
   end

   inline: remotewhos (nSocket --- hT) \ run word whos on remote
\     Get what word whos would show at remote end of Socket.
      no NUM stkok not IF "remotewhos" stknot return THEN
      this 0> not IF drop "socket closed" hand return THEN
      (nSocket) "'whos' >stk" that remoterun (nSocket) remoteget
   end

   inline: SERVER-CYCLE ( --- ) \ close and open listening port
{     Cycle the server listening port off and on if there are no
      current clients and the last one disconnected more than TWAIT
      seconds ago.

      Purpose: Run a server duty cycle to cut off surreptitious connec-
      tions that use a port but are not connected as clients (SYN_RECV).
      Legal clients may have to try again to get a connection.

      Sat Mar  5 14:21:52 PST 2011.  Add IPallow.

      Example usage: 

         Running a server duty cycle, closing and opening listening 
         port 80 every 20 seconds.  Closing and opening will be de-
         layed for 70 (TWAIT) seconds after the last client has dis-
         connected to span the client's TIME_WAIT period.

         host "kaffia" =
         IF " Starting SERVER-CYCLE" . nl
            80 "SERVER-CYCLE" "PORT"  bank \ for port 80 server
            70 "SERVER-CYCLE" "TWAIT" bank \ delay after last client
          \ Restrict IPs allowed to connect:
            "205.134.241.76  66.240.8.119" "SERVER-CYCLE" "IPallow" bank
            1 20 / "SERVER-CYCLE" PLAY     \ run in the multitasker
         THEN
}
      [ 9877 "PORT" book
        5 "SEC" book
        90 "TWAIT" book
        "*" "IPallow" book

      \ A macro to start the server again:
        "IPallow PORT SERVER" "RESTART" macro
      ]
      remotesockets rows 0> IF return THEN

      time clienttimesoff any?
      IF bend   \ rows into cols for max1()
         max1 @ \ latest time of all rows
         less (dt)
      THEN (dt) TWAIT > \ if dt > TWAIT, restart server
      IF serverclose SEC "RESTART" ALARM THEN
   end

   inline: SERVE_F (hT nSocket --- ) \ process a foreign SERVER request
{     Process a SERVER request from a new client just connecting or an
      established foreign client.

      This word is central to the program running TCP/IP.  It is run by 
      drainf() in net.c and clientmake(), clientclose() and terminal()
      in term.c for these purposes:

         Function         Run by                    Purpose
         SERVE_F          drainf()                  receive client bytes
         SERVE_F.ADD      clientmake()              connection beginning
         SERVE_F.REM      clientclose(), drainf()   connection closing
         SERVE_F.TYPE     drainf()                  fetch SERVER type
         SERVE_F.CONNSHOW terminal()                show each connection
         SERVE_F.RFSEC    terminal()                delay when refuse

      SERVE_F provides the interface to new clients and establisned
      foreign clients when the program is running as a SERVER.  (For-
      eign clients are clients that are not this program.)  Here is the
      enumeration of foreign types in net.c:

         enum foreign_types {HTTP=0,TERM};

      Type HTTP disconnects when this word returns (drainf()).  Type 
      TERM is more general and the connection is maintained allowing 
      a dialog between this SERVER and connected foreign clients.

      SERVE_F is set up before SERVER is started by banking here the 
      appropriate items for TYPE, SERVICE (and local functions ADD and 
      REM if the defaults here are not adequate).

      Since there is only one TYPE and one SERVICE for all sockets, 
      the server is restricted to running the same foreign type of
      service for all that connect.

      Examples.

      1. To set up a simple server for testing foreign clients:

            "" 9877 SERVER
            1 "SERVE_F" "TYPE" bank              \ TERM type
            "2drop" ptr "SERVE_F" "SERVICE" bank \ drops (hT nSocket)
            300 new_client_timeout               \ runs 5 minutes

      2. Here is an example of an HTTP type:

         The word for processing a SERVER request must have its ptr
         and type banked here as in this example for an HTTP type:

            Banking the ptr to word do_HTTP for processing requests:
               "do_HTTP" ptr "SERVE_F" "SERVICE" bank
               0 (type HTTP) "SERVE_F" "TYPE"    bank

            where the stack diagram for do_HTTP must be the same as the 
            one for this word: (hT nSocket --- )

         For TYPE=HTTP, drainf() will close Socket when this word re-
         turns.  See usr/tops_http for this program as HTTP server.

      3. Here is an example of a TERM type for telnet:
         Configuring the program as a telnet server:
            "TELNET_CLIENT" ptr   "SERVE_F" "SERVICE" bank
            1 (TERM)              "SERVE_F" "TYPE"    bank
            "TELNETD_CONNECT" ptr "SERVE_F" "ADDptr" bank

         The stack diagram for the word being used for SERVICE must
         be (hT nSocket), as it is for TELNET_CLIENT used above.
}
      [ \ Begin the library of this word.

\        The default settings for TYPE and SERVICE are for getting 
\        bytes from HTTP servers (using HTTPget).

            0          "TYPE"     book \ HTTP server type
            zero (ptr) "SERVICE"  book \ zero ptr means to skip
            yes        "CONNSHOW" book \ show each connection
            5          "RFSEC"    book \ sec ignore connection refused

         0 1 null "SOCKS" book \ list of foreign sockets being served

\        Default functions to update SOCKS list; ADDdef adds incoming
\        nSocket to SOCKS and REMdef removes it from SOCKS:
         "(S) SOCKS pile 'SOCKS' book" "ADDdef" macro \ latest first
         "(S) SOCKS dup rot = rake drop 'SOCKS' book" "REMdef" macro
{
         Below are default ptrs to functions that update the local list
         of foreign sockets, SOCKS.  These are used by ADD and REM that
         are run by the program (see below):
}           "ADDdef" ptr "ADDptr" book \ SOCKS default to add
            "REMdef" ptr "REMptr" book \ SOCKS default to remove 
{
         Below are functions ADD and REM to update the local list of
         foreign sockets, SOCKS.  The stack diagram for ADD and REM 
         is (nSocket --- ).  These functions are run by the program 
         when clients connect and close (clientmake() and clientclose()
         in term.c, and drainf() in net.c): 
}           "ADDptr exe" "ADD" macro \ run local ptr ADDptr
            "REMptr exe" "REM" macro \ run local ptr REMptr

{        To know when clients connect or close, a ptr to a word can
         be banked here replacing ADDptr or REMptr so it will be run 
         instead.  

         For example, word TELNETD_CONNECT (file sys/term.v) does this 
         for ADDptr, so it can start a telnetd daemon when a client 
         first connects.  

         Either of these phrases will bank a new ptr here for ADDptr, 
         so word TELNETD_CONNECT will be used to add a new client:
            >> SERVE_F.ADDptr=ptr("TELNETD_CONNECT"); <<
            "TELNETD_CONNECT" ptr "SERVE_F" "ADDptr" bank

         Note that ADD and REM, with stack diagrams (nSocket --- ) are
         in addition to SERVICE with stack diagram (hT nSocket --- ).

         On connection, word SERVICE will be called after word ADD runs.
       
      Always comes here from drainf() when bytes arrive on SERVER from 
      a foreign client, and the word having ptr stored here in SERVICE 
      is executed:
}     ] SERVICE 0<> IF (hT nSocket) SERVICE exe return THEN

      TYPE 0 (HTTP) =
      IF \ Send something back so programs like wget quit retrying:
         CRLF swap remoteputf drop return
      THEN

      (hT nSocket) sclose drop \ nothing specified, so close Socket
   end

   inline: SERVE_F_TERM ( --- ) \ initialize SERVE_F as TERM type
      1 "SERVE_F" "TYPE" bank             \ TERM type
      "noop" ptr "SERVE_F" "SERVICE" bank \ (hT nSocket) from drainf()
      300 new_client_timeout              \ 5 minutes to log connect
   end

   inline: SERVER_ALLOW (qIP --- f) \ flag f true if IP can connect
{     Table "clients" in this local library contains the list of IP
      addresses where this program running can connect using word
      CLIENT.

      Given a prospective IP address, this word returns f true if it
      matches an entry in clients table.

      The program runs this word in drainf() after client type has
      been determined to be LOSERV.  This means that the SERVER must
      have allowed the client to connect by having a proper entry
      in table CLIENT_ALLOW.clients.

      Only the first word in each line of the clients table is used
      to match against IP, so any arbitrary text can follow the first
      word.

      Sat Mar  5 14:21:52 PST 2011.  Loop back is always allowed.
}
      [ "127.0.0.1 loop_back" "clients" book ]
      clients 1st word drop swap (hT qIP) grepe (hA) rows any (f)
   end

   inline: SERVER_ALLOWING ( --- hT) \ list of client IPs allowed
    \ Sat Jan 21 10:57:16 PST 2012

    \ List of IP addresses allowed to connect after it is known that
    \ this program, and not a foreign program, is connecting in 
    \ drainf(), file net.c.

      "SERVER_ALLOW" "clients" yank
   end

   inline: serverport ( --- nPort) \ port of local server listening
\     Returned number Port is 0 if server is not on.
      "clients" >stk its "listening" grepr any?
      IF reach numerate ontop ELSE drop false THEN
   end

   inline: servershutdown ( --- ) \ close clients, shut down server
      sockets any?
      IF these rows 1st DO this I pry sclose LOOP drop THEN
      serverclose
   end

   inline: serverstart (nPort --- f) \ turn server on, listening on Port
      no NUM stkok not IF "serverstart" stknot return THEN

      this port_listening

      IF \ Port is listening already; is it this server?:
         (nPort) serverport = (f)
      ELSE
         "*" that SERVER port_listening (f)
      THEN (f)
   end

   inline: SERVER_WAIT (nSec --- ) \ ignore new connections for Sec
      [ "yes READY" "SERVER_RESUME" macro ]
      no READY (nSec) "SERVER_WAIT" "SERVER_RESUME" localref ALARM 
   end

   inline: SHSERVER (nSec --- nPort) \ shell server for Sec on Port
\     Start a shell running this program as a server for up to nSec.
\     Listening Port being used is returned.

      [ 10 (seconds) "STARTUP" book \ server start up seconds
      ]
      no "PORT" book
      (nSec) "SEC" book

      "tserv" filefound
      IF (qScript)
         " -exit " SEC STARTUP plus intstr + +
         " -port " def_port nextport dup "PORT" book intstr + +
         " &" +
         (qS) shell STARTUP idle

      ELSE " SHSERVER: script usr/tserv not found" ersys
      THEN PORT cop
   end

   inline: SNDSERVER ( --- nPORT) \ port of the sound file server
{     Script tops_snd runs a daemon sound file server queue, listening
      on PORT.

      Clients can obtain PORT from this word, and connect to the sound 
      file server using:

         IPloop SNDSERVER CLIENT "S" book

      where S is nonnegative if the server is running and a valid con-
      nection has been made.

      Once connected to the sound file server, rather than running

         (qFile) wavPlayb

      to play a file named File (see sys/snd.v), a client submits File 
      name over socket S to the sound file server by running the phrase

         (qFile) " wavque_add" + S remoterun


      The file will be queued and played when its turn comes, and the
      client can disconnect any time from the server by running

         S sclose

      WARNING: files played by the sound file server are deleted; see
      wavPlayq in sys/snd.v.

      Note: interprocess communication word msgPeep from file sys/dog.v
      must be present: "dog.v" source.

}     [ -1 "OFF" book ] 
      "msgPeep" exists?
      IF "SNDSERVER" msgPub msgPeep any?
         IF (qPORT) number drop ELSE OFF THEN
      ELSE OFF
      THEN
   end

   inline: SNDSERVER_ON ( -- f) \ true if sound file server is listening
    \ Sat Aug  8 11:27:21 PDT 2009
      SNDSERVER port_on
   end

   inline: SNDSERVER_RATE (nHz --- ) \ set rate of sound file queuing
    \ Wed Mar 24 12:12:50 PDT 2010
    \ Set the rate of the wave file queuing system in tops_snd.

    \ The rate at start up is 0.2 Hz, or once every 5 seconds. 

    \ Example: 1 15 / SNDSERVER_RATE \ once every 15 seconds

      "Hz" book IPloop SNDSERVER CLIENT "S" book S -1 >
      IF Hz "%10.6f" format " 'wavque_play' RATE" + S remoterun
         " SNDSERVER_RATE: set queue rate to " Hz "%4.3f Hz" format +
         S sclose

      ELSE " SNDSERVER_RATE: unable to connect to SNDSERVER"

      THEN . nl
   end

   inline: socket_ack (nSocket --- f) \ this program remote acknowledge
{
      When a socket is not open and this word is running in the multi-
      tasker, conflict arises due to the necessary delay needed to see
      if the socket is open.

      This shows the problem when word offline_check runs this version
      of socket_ack (all messages execpt "busy task offline_check" are
      obtained by recompiling term.c with debug in tasker() turned on):

         tasker task: queue_run,0:CODE__ Mon Jul 13 11:28:57 PDT 2009

         tasker task: offline_check,0:CODE__ Mon Jul 13 11:29:06 PDT 200
         tasker: busy task offline_check,0:CODE__ interrupted Mon Jul 13
         tasker task: WAITING,0:CODE__ Mon Jul 13 11:29:06 PDT 2009
         tasker task: WAITING,0:CODE__ Mon Jul 13 11:29:07 PDT 2009
         tasker task: WAITING,0:CODE__ Mon Jul 13 11:29:08 PDT 2009
         tasker task: WAITING,0:CODE__ Mon Jul 13 11:29:08 PDT 2009
         tasker task: WAITING,0:CODE__ Mon Jul 13 11:29:09 PDT 2009

         tasker task: queue_run,0:CODE__ Mon Jul 13 11:29:19 PDT 2009
      
      The problem is not fatal and simply causes this line in the log 
      file:
         tasker: busy task offline_check,0:CODE__ interrupted Mon Jul 13

      A better approach is probably not to run periodic socket_ack at 
      all, but instead to have machines sent periodic messages that 
      they are connected.

      When this program is connected remotely on Socket, this word is 
      a reliable way to see it the connection is still open.  

      It makes this program send back an acknowledgement, resulting in
      true flag f arriving on the stack here.

      If a remote hangs up, word socket_open and related socket testing
      words will often return a false positive.

      Once a socket is found to be no longer connected, word sclose
      should be run so it will be removed from the list of clients.

}     [ MAXBLOCK "WAIT" book ]
      dup 0< IF drop false return THEN

      dup client_open \ must be a client that has connected
      IF "remoteack" "SEC" yank push
         WAIT "remoteack" "SEC" bank
         remoteack
         pull "remoteack" "SEC" bank
      ELSE drop false
      THEN
   end

   inline: socket_ack1 (nSocket --- f) \ this program remote acknowledge
{     
      Mon Mar 21 11:51:33 PDT 2011
         Show time (milliseconds) spent blocking.

      Fri Nov 27 09:36:18 PST 2009
         Make time of BLOCK a local variable called SEC that can be
         set externally.  The initial value of SEC is MAXBLOCK.

      Thu Sep 24 05:19:54 PDT 2009
         Revised to test stack depth for returned item after BLOCK,
         and to close socket if nothing came back.

      When this program is connected remotely on Socket, this word is
      a reliable way to see it the connection is still open.

      It makes this program send back an acknowledgement, resulting in
      true flag f arriving on the stack here.

      If a remote hangs up, word socket_open and related socket testing
      words will often return a false positive.

      If the socket is not open, and this word is running in the multi-
      tasker, BLOCK will time out and probably cause an interruption
      message like the one discussed in word socket_ack.  

      If returned f is false, this word will already have closed Socket
      by running sclose, which removes it from the list of clients.

}    
      [ MAXBLOCK "SEC" book, no "VERBOSE" book ]

       (nSocket) dup 0< IF drop false return THEN

      (nSocket) dup client_open \ must be a client that has connected
      IF "S" book 
         depth push
         time "t1" book

         "ACK" S remoterun S SEC BLOCK \ expect item from ACK in SEC

         VERBOSE (f)
         IF time t1 - 1000 * 
            " socket_ack1:" . .i " msec wait for ack from socket" . 
            S .i nl
         THEN

         depth pull - (n) dup 0> \ has stack grown?
         IF (n) dump VERBOSE (f) IF " socket_ack1: ok" . nl THEN true 
         ELSE (n) drop S sclose 
            " socket_ack1: failed, socket" . S .i " is closed" . nl 
            false
         THEN 
      ELSE (nSocket) sclose false
      THEN
   end

   inline: socket_check (nS --- ) \ display a check of socket S
      "S" book

      S socket_open
      IF S .i " is open" ELSE S .i " is not open" THEN . nl

      S socket_writable
      IF S .i " is writable" ELSE S .i " is not writable"
      THEN . nl

      S socket_readable dup 0<
      IF drop S .i " is not open or has pending read error" . nl
      ELSE dup 0=
         IF drop S .i " has" . " no bytes to read" . nl
         ELSE S .i " has" . .i " bytes to read" . nl
         THEN
      THEN
   end

   inline: socket_scan (n --- hA) \ scan of the first n sockets
\     Column 1 of A contains the socket number, and column 2 contains
\     true (-1) if the socket is open.
      depth nit push
      nit 0 DO I dup socket_open park LOOP
      depth pull less pilen
   end

   inline: sockets ( --- hR) \ all connected sockets
      clientsockets 1st catch "_sockets" naming ;

   inline: SSLcert (qFile --- hT) \ text of OpenSSL certification File
    \ Sat Mar 19 14:26:20 PDT 2011

    \ Example: 
    \    [tops@kaffia] ready > usrpath "client.pem" + SSLcert (hT)

      [ ftempsys "OUT" book OUT delete

      \ Possible locations of OpenSSL executable binary:
        "/usr/bin/openssl " "SSLPROG1" book
        "/usr/local/ssl/bin/openssl " "SSLPROG2" book

      \ Command line string:
        "x509 -text -in XXX > " OUT + "OPENSSL" book
      ]
      0 STR stkok not IF "SSLcert" stknot return THEN
      (qFile) "FILE" book 

      SSLPROG1 dup file? not 
      IF drop SSLPROG2 dup file? not IF drop "" THEN 
      THEN (qPROG) dup "SSLPROG" book any?
      IF (qPROG) OPENSSL "XXX" FILE strp + shell
         "File " FILE spaced + date + (hH)
         OUT asciiload (hH hC) pile 
      ELSE " SSLcert: require program " SSLPROG1 + 
         "or " + SSLPROG2 + . nl 
         VOL tpurged (hT)
      THEN
      (hT) "_SSLcert" naming
      OUT deleteif
   end

   inline: TASK_PORT (nWAIT qJ --- hA) \ perform task J, return item A
{     Runs task J remotely, over a port on the same machine.

      Starts this program remotely as a server, sends task J through
      the listening port, waits no longer than WAIT seconds for stack 
      item A to appear, then closes the port and kills the remote pro-
      gram.

      If J has not been written to return a stack item, word ACK can
      be appended to it so a true flag will be sent when it finishes,
      as in: (nWAIT qJ) " ACK" pile (nWAIT qJ) TASK_PORT.

      Through the -exit ARGV sent when the server script, dserv1, is
      started, the server will exit on its own in STARTUP+WAIT seconds
      if this word fails to kill it.
}
      [ 10 (sec) "STARTUP" book \ server start up seconds
        2  (sec) "ASEC" book    \ shut down alarm seconds

        {" ( --- f)
         { This indeterminate wait state task, WTASK, avoids waiting
           the entire STARTUP period before trying to connect to the
           server started.

           Typical connection times are now 0.8 seconds versus waiting 
           the entire 10 sec STARTUP.

           Initial CONNECT attempts will fail; send the cannot connect
           messages to scratch: 
         } SYSOUT push scratch set_sysout
           CONNTO push 0 connto \ no idle between CONNECT tries

           IPloop PORT -1 CONNECT any? 
           IF (S) sclose -1 ELSE 0 THEN 

           pull connto
           pull set_sysout \ restore SYSOUT
        "} "WTASK" macro

        10 (Hz) "CONRATE" book \ running WTASK ten times per second
      ]
      swap "WAIT" book
      (qJ) textput \ lines of VOL into string with new line chars

      "dserv1" filefound 
      IF (qServ) 
       \ Start a server.
         time "t0" book               \ timing the start up

       \ Initialize the indeterminate wait state task, WTASK, to watch 
       \ the connection and return as soon as the server is running:
         STARTUP (nSec)               \ max indeterminate wait
         "TASK_PORT" "WTASK" localref \ full lib name of WTASK
         (nSec qWord) WAIT_INIT       \ install WTASK and start WAITING
         CONRATE "WAITING" RATE       \ speed up rate of WAITING

       \ Make the script that starts the server (runs dserv1):
         (qServ) 

       \ Command line options for dserv1 server script:
          \ " -logsave " +         \ add this to save log
          \ " -logsave -ntrace " + \ add this to save log with net trace
            " -exit " + WAIT STARTUP + (nSec) intstr + \ exit time
          \ Port to use:
            " -port " + def_port nextport dup "PORT" book intstr + 
            " &" + (qS)

         (qS) shell \ run the start up script

         WAIT_BEGIN \ indeterminate wait state while script runs

       \ Connect to the server on loopback IP:

         IPloop PORT CLIENT (nSocket)

         (nSocket) this -1 >
         IF " TASK_PORT: server running, connected to socket " 
            over intstr + " in " + 
            time t0 less "%0.2f" format + " sec" + . nl 
         THEN
         (nSocket)

      ELSE " TASK_PORT: file " "dserv1" + " not found" + . nl 
         -1 (nSocket) 

      THEN (nSocket) "S" book

      S -1 <>
      IF 
       \ Get PID of server for killing it later:
       \ No longer done (see old listings).  Killing required an 
       \ ALARM, and rapid back-to-back calls to TASK_PORT caused
       \ timing problems.
       \ "getpid remotefd remoteput" S remoterun1 "PID" book

       \ Do task J:
         "remoterun1" "SEC" yank "WAITsave" book
         WAIT "remoterun1" "SEC" bank

         (qJ) " remotefd remoteput" pile (qJ) depth push

         (qJ) S remoterun1 (hA)
         WAITsave "remoterun1" "SEC" bank

       \ Check the stack:
         depth pull less 0<> \ expect no change (consume qJ, receive hA)

         IF " TASK_PORT: remote task failed" ersys
            VOL tpurged (hA) \ return an empty VOL
         THEN

{        Active close (both client and server closing) avoids the
         CLOSE_WAIT state on PORT.  CLOSE_WAIT means the server port 
         waits for this client to close, which could be hours if this 
         is a long running job.  

         Active close means a TIME_WAIT state is obtained which ex-
         pires after a small wait (seconds or minutes depending on 
         the system).

         Active socket close is run from server using the phrase made
         below and sent to the server.  

         The phrase sends sclose to here, then runs sclose there and 
         finally ALARM(sec,"exit") there to shut itself down:
}        "'remotefd sclose' remotefd remoterun " \ close client (here)
         " remotefd sclose" +                    \ close server (there)
         " 0.5 'exit' ALARM" + (qT)              \ shutdown (there)
         (qT) S remoterun \ run T on the server

         S sclose

         " TASK_PORT: remote task complete in " 
         time t0 less "%0.2f" format + " sec" + . nl 

      ELSE (qJ) drop " TASK_PORT: failed to connect" ersys
         STR tpurged (hA) \ return an empty STR
      THEN
   end

   inline: TIME_SYNC ( --- ) \ this machine in synch with remote
{     Tue Mar 30 09:11:16 PDT 2010

      This word works like NIST_SYNC.

      After it first runs, this word will run again every SEC.

      A valid socket number for S that is connected to the machine to
      be synchronized with must be banked here, as in:

         6 "TIME_SYNC" "S" bank
      or
         TIME_SYNC.S = 6;

      To invalidate socket S, run:

         UDEF "TIME_SYNC" "S" bank

      Socket S remains connected after this word runs.
}
      [ 86400 "SEC" book UDEF "S" book ]

      S UDEF =
      IF " TIME_SYNC: skipping, no socket defined " date + . nl
      ELSE
         S time_sync (f)
         IF "time_sync" "DT" yank "DELTA" book
            " TIME_SYNC: socket " S intstr + " time sync " +
            DELTA intstr + " sec " + date + (qS) . nl
         ELSE " TIME_SYNC: no response from socket " S intstr +
            spaced date + . nl
         THEN
      THEN
      SEC "TIME_SYNC" ALARM \ run again in SEC
   end

   inline: time_sync (nS --- f) \ this machine in synch with remote
{     Synchronize the program time on this machine with the program
      time on the machine connected on socket S.

      Returned flag f is true if the time change was successful.  The 
      time sync will fail if the remote does not respond within SEC 
      seconds, and f will be false.

      After time_sync, times on the two machines should be within
      one second.

      After running, the time difference applied can be recalled by:
         dt = time_sync.DT;
      and is positive when time on the remote machine is ahead.

      Adapted from cluster_timesync (the version that uses time) on
      file clu.v.
}
      [ 10 "SEC" book ] \ wait time in remoterun1

      "remoterun1" "SEC" yank push
      SEC "remoterun1" "SEC" bank 
      UDEF "DT" book

      "time remotefd remoteput ACK"
      swap (nS) remoterun1 (0 or nt -1) \ fetch head node time
      IF (nt) time1 less                \ less local machine time
         dup (deltaT) GMTdelta          \ set program time delta
         "DT" book
         true
      ELSE " time_sync: failed to obtain time from remote" . nl
         false
      THEN
      (f)
      pull "remoterun1" "SEC" bank 
   end

   inline: wrapHTML (hT --- qT1) \ T wrapped with HTML
{     Incoming bytes of T have <p> added at the end of each line and
      HTML header and footer added to top and bottom, for retrieval by 
      HTTPget.  Without HTML header and footer, retrieval can be very, 
      very slow (on the order of 100 bytes/sec).

      Returned T1 is a string with new line characters replacing the
      trailing blanks of VOL T.
}
      [ {"
           <HTML>
           <HEAD>
              <META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">
              <META NAME="GENERATOR" CONTENT="Mozilla/4.05 [en] (X11; U; AIX 4.3) [Netscape]">
           </HEAD>
        "} left justify "HTML" book

        "</HTML>" "/HTML" book
      ]
      (hT) "<p>" tail
      HTML swap /HTML pile pile textput (qT)
   end

   inline: www_open ( --- f) \ f true if connected to the Internet
{     Test for an active Internet connection by trying to connect to
      each of the IP addresses in the list of daytime servers located
      in the library of word NISTdelta.
}
      [ "_NISTdelta" "IPlist" yank "IPtry" book ]

      "ppplog" exists?
      IF ppplog file?
\        For dial up or pppoe DSL:
         IF "_pppconnect" "log" yank (f1)
            "_pppconnect" "CONN" yank (f2) and (f)
           (f) dup "www" book return
         THEN
      THEN

\     Some CONNECT attempts may fail; send the cannot connect messages
\     to temp file:
      SYSOUT push
      ftempsys dup set_sysout (qFile)

      no "www" book
      depth push
      IPtry rows 3 min 1st
      DO IPtry I quote 13 (daytime port) 0
         CONNECT (nSocket) any?
         IF (nSocket) sclose
            depth peek - dump
            yes "www" book
            EXIT \ leave loop when a good connection is found
         THEN
      LOOP pull drop

      pull set_sysout \ restore SYSOUT
      (qFile) delete  \ delete temp file

      www (f)
   end

\-----------------------------------------------------------------------
{
   Remote word substitutions.

   This section makes word substitutions when running remotely, using
   word exe_remote.

   Words are running remotely during periods when remotefd is a valid
   socket descriptor.  At other times, remotefd equals -1 (invalid).

   Examples of running remotely:

      Sending a phrase down socket 5.  The program at socket 5 is
      running remotely:
         [tops@localhost] ready > "'widget1' Ksolve" 5 remoterun

      Using word remoteprompt so keyed input runs the program on the
      machine at socket 3:
         [tops@localhost] ready > 3 remoteprompt
         tops@socket3 > [Things keyed here are running remotely]
         tops@socket3 > 'widget1' Ksolve
}
\  Words that would cause the remote program to exit will simply display
\  a message:

   inline: remote_exit ( --- ) " use Esc-q to exit" . nl ;
   "remote_exit" (qW2)

   "abort" that exe_remote
   "bye"   that exe_remote
   "exit"  that exe_remote
   "quit"  that exe_remote
   (qW2) drop

   "killmy" "drop" exe_remote \ silently drop the input to killmy

{
   Example running word exit on remoteprompt:

      [tops@client] ready > 3 remoteprompt
      tops@socket3 > exit
       use Esc-q to exit
      tops@socket3 >
}

\  Block words that mimic Unix functions and that do not work over
\  remote.  Shown below on the right are words that can be substituted.

   inline: remote_invalid ( --- ) " invalid word on remote" . nl halt ;
   "remote_invalid" (qW2)
\                            Substitute
   "cd"    that exe_remote \ chdir: "/tmp" chdir
   "cp"    that exe_remote \ fcopy: "fname1" "fname2" fcopy
   "diff"  that exe_remote \ diff1: "fname1" "fname2" diff
   "grep"  that exe_remote \ grep2: "filename" "pattern" grep2
   "man"   that exe_remote \ where: "dup" where (only if keys?=yes)
   "rm"    that exe_remote \ delete: "core" delete
   "topic" that exe_remote \ none available
   "utail" that exe_remote \ tailf: "filename" 100 tailf
   "remoteprompt" that exe_remote
   (qW2) drop

\  Word HALT and return do not work correctly: 
   "HALT"    "remote_invalid" exe_remote 
   "return"  "remote_invalid" exe_remote 
   "return2" "remote_invalid" exe_remote 
{
   Example:
      Trying to use word rm on remoteprompt to socket 7:
         tops@socket7 > rm core
          invalid word on remote

      Using word delete instead:
         tops@socket7 > "core" delete
}
\  Words in the following list do not work for viewing remote files
\  (but see below, "Ways to view remote text files"):

   "remote_invalid" (qW2)
   "eview fview more _more vi _vi view vim _vim xterm xtermsb" (qW1)
   words these rows 1st DO this I quote other exe_remote LOOP 2drop
{
   Ways to view remote text files:

      To view a small remote file remotely, just load and display it:
         Go to remote:
            [tops@clacker] ready > 3 remoteprompt

         On remote:
            tops@socket3 > ".bashrc" asciiload .
            # .bashrc
            alias rm='rm -i'
            alias cp='cp -i -p'
            alias mv='mv -i'
            set -o vi
            tops@socket3 >

      To view a large remote file, bring it to local and view it there:

         Go to remote:
            [tops@clacker] ready > 3 remoteprompt

         On remote:
            tops@socket3 > ntrace \ shows network activity
            tops@socket3 > "savannah.log" asciiload remotefd remoteput
            netvolwrite: all 3421367 bytes to socket 6
            tops@socket3 > (Press Esc-q to return)

         Back from remote, run eview to view the sent stack item in
         the program's designated text viewer:
             stack elements:
                   0 volume: _Tsocket3  13009 by 263
             [1] ok!
            [tops@clacker] ready > eview
}
   private halt

\-----------------------------------------------------------------------
;

Appendix.

HTTP server log output from various remotes.

Sat Jul  5 11:28:58 PDT 2014.  These are excerpts from various HTTP 
server log files, tops_http.log, showing connections to the running 
program tops_http.

Hint: A first response to debugging remote HTTP server errors can be to
simply log on remotely and turn on ntrace.  This adds a lot of output 
to file tops_http.log that may be useful.  For example, jmptable() out-
put added to case 1 below would show that REQUESTrun() (not on CVS) is
being run. 

Note: In these examples, fortycoupe.com output shows new connection as
"SERVER: 174.47.228.170:2 connect" from the latest compilation of tops,
while topsdog.com and rilefile.com show "SERVER: 174.47.228.170 connect"
from the previous compilation that does not append socket :2.

1. Local request for remote status.html (taken from fortycoupe.com):

Sat Jul  5 17:13:41 UTC 2014 SERVER: 174.47.228.170:2 connect
 -8 bytes delta: memprobe socket 2 connect

 HTTPput: client 174.47.228.170 on socket 2
 HTTPput: client login: GET /status.html HTTP/1.0
 HTTPput: connecting to server 127.0.0.1:9881 and running HTTPgetr
 HTTPgetr: host 127.0.0.1
 HTTPgetr: connected to 127.0.0.1:9881 on socket 3
 HTTPgetr: receiving bytes ...
 HTTPgetr: received 803 bytes at 4.16 Mbytes/sec
 HTTPgetr: connection closed by host
 HTTPput: client 174.47.228.170 socket 2 closed 271 msec Sat Jul  5
             17:13:41 UTC 2014

2. Local requesting its IP address (taken from topsdog.com):

Sat Jul  5 16:43:22 UTC 2014 SERVER: 174.47.228.170 connect
 3888 bytes delta: memprobe socket 2 connect

 HTTPput: client 174.47.228.170 on socket 2
 HTTPput: client login: GET /clientIP.html HTTP/1.0
 HTTPput: connecting to server 127.0.0.1:9881 and running HTTPgetr
 HTTPgetr: host 127.0.0.1
 HTTPgetr: connected to 127.0.0.1:9881 on socket 3
 HTTPgetr: receiving bytes ...
 HTTPgetr: received 595 bytes at 6.01 Mbytes/sec
 HTTPgetr: connection closed by host
 HTTPput: client 174.47.228.170 socket 2 closed 1538 msec Sat Jul  5
             16:43:24 UTC 2014

3. Local running REGIP() (read mytops/uboot.v; not on CVS) to remotely
register its IP (taken from fortycoupe.com; REQUESTrun() not on CVS):

Sat Jul  5 17:06:01 UTC 2014 SERVER: 174.47.228.170:2 connect
 272 bytes delta: memprobe socket 2 connect

 HTTPput: client 174.47.228.170 on socket 2
 HTTPput: client login: this client's LOGIN string is empty
 HTTPput: running ptr to word HTTP,0:REQUESTrun
 HTTPput: client 174.47.228.170 socket 2 kept open 3 msec Sat Jul  5
             17:06:01 UTC 2014
 REQUESTrun: 'plunger' msgDel '174.47.228.170' 'plunger' msgPut
               '174.47.228.170 remote' +SERVER_ALLOW (plunger)
 REQUESTrun: complete for socket 2 Sat Jul  5 17:06:01 UTC 2014

4. Local running REGIP() to remotely register its IP (taken from rile-
file.com); with ENCODE() error and recovery (ENCODE() not on CVS))

Sat Jul  5 16:43:24 UTC 2014 SERVER: 174.47.228.170 connect
 -160 bytes delta: memprobe socket 2 connect

 HTTPput: client 174.47.228.170 on socket 2
 HTTPput: client login: this client's LOGIN string is empty
 HTTPput: running ptr to word HTTP,0:REQUESTrun
 ENCODE: failed on attempt 1 of 6
 ENCODE: success on attempt 2
 HTTPput: client 174.47.228.170 socket 2 kept open 4 msec Sat Jul  5
          16:43:24 UTC 2014
 REQUESTrun: 'plunger' msgDel '174.47.228.170' 'plunger' msgPut
               '174.47.228.170 remote' +SERVER_ALLOW (plunger)
 REQUESTrun: complete for socket 2 Sat Jul  5 16:43:24 UTC 2014

5. Local running cpsta, which runs remote DSERV-UP() to open a port and
then runs remote DSERV-DN to close it (taken from rilefile.com):

Sat Jul  5 17:48:22 UTC 2014 SERVER: 174.47.228.170 connect
 104 bytes delta: memprobe socket 2 connect
 DSERV-UP: test to port 9880, connected in 1.07 sec on socket 3
 DSERV-UP: test connection to socket 3 closed

Sat Jul  5 17:48:35 UTC 2014 SERVER: 174.47.228.170 connect
 24 bytes delta: memprobe socket 2 connect
 DSERV-DN: my remotefd is 2
 DSERV-DN: shutting down port 9880
 DSERV-DN: connected to port on socket 2
 DSERV-DN: sending this run phrase to socket 2:
   2 "exit" ALARM ACK
 DSERV-DN: OK, received ACK from socket 2
 DSERV-DN: returning

6. Local (diego) tops_rtc runs its CONN() every 3 minutes to place an
RTC_CONNECT message on remote file msgcomm (read tops_rtc).  The word 
that places the RTC_CONNECT message on the remote is msgPutIP() (read
dog.v).  A typical RTC_CONNECT message looks like this, with an IP and
port setting up the stack for word server_connect(), which runs on the
remote when msgPoll() picks up the message (read tops_rtcmon):
   RTC_CONNECT "71.107.4.6" 9886 server_connect

As it places the message, word msgPutIP() also causes word clients to
run on the remote, giving the Server and Clients messages seen below: 

6a. First time (note NEWCLI):
Wed May 21 21:57:09 UTC 2014 SERVER: 174.47.228.170 connect
 80 bytes delta: memprobe socket 2 connect
 Server local is listening on port 80
 Clients:
  socket 2, port 45910, conn S<C, 174.47.228.170 LOGIN dale diego
 clientclose: socket 2 closing on flag 2, Wed May 21 21:57:10 UTC 2014
 clientclose: socket 2, port -1, conn S<NEWCLI is closed

6b. Again three minutes later:
Wed May 21 22:00:10 UTC 2014 SERVER: 174.47.228.170 connect
 32 bytes delta: memprobe socket 2 connect
 Server local is listening on port 80
 Clients:
  socket 2, port 45913, conn S<C, 174.47.228.170 LOGIN dale diego
 clientclose: socket 2 closing on flag 2, Wed May 21 22:00:11 UTC 2014
 clientclose: socket 2, port 45913, conn S<C is closed

6c. Again three minutes later, and until the message is picked up by
remote tops_rtcmon.  This will be after collection starts at about 
22:15 UTC (15:15 PDT):
Wed May 21 22:03:10 UTC 2014 SERVER: 174.47.228.170 connect
 96 bytes delta: memprobe socket 2 connect
 Server local is listening on port 80
 Clients:
  socket 2, port 45925, conn S<C, 174.47.228.170 LOGIN dale diego
 clientclose: socket 2 closing on flag 2, Wed May 21 22:03:11 UTC 2014
 clientclose: socket 2, port 45925, conn S<C is closed

------------------------------------------------------------------------

What an HTTP server receives from Netscape, Wget, MS IE, Google Chrome.

Starting this program as SERVER on port 80 (requires root):

   [root@clacker] /home/user # tops
            Tops 2.4.3
   Sun Sep 28 08:09:18 PDT 2003
   [tops@clacker] ready # '' 80 SERVER

For the command
   [user@clacker] /home/user > netscape http://127.0.0.1/index.html &
this is what Netscape (RH7.2 Linux) sends the HTTP server:

   GET /index.html HTTP/1.0
   Connection: Keep-Alive
   User-Agent: Mozilla/4.78 [en] (X11; U; Linux 2.4.7-10 i686)
   Host: 127.0.0.1
   Accept: image/gif, image/x-xbitmap, image/jpeg, image/pjpeg,
    image/png, */*
   Accept-Encoding: gzip
   Accept-Language: en
   Accept-Charset: iso-8859-1,*,utf-8

For this program listening on (non-priviledged) port 9877, for the
command
   [user@blake] /home/user > netscape http://blake:9877/index.html &
this is what Netscape (AIX 4.3) sends the HTTP server:

   GET /index.html HTTP/1.0
   Connection: Keep-Alive
   User-Agent: Mozilla/4.78 [en] (X11; U; AIX 4.3)
   Host: blake:9877
   Accept: image/gif, image/x-xbitmap, image/jpeg, image/pjpeg,
    image/png, */*
   Accept-Encoding: gzip
   Accept-Language: en
   Accept-Charset: iso-8859-1,*,utf-8

For the command
   [user@clacker] /home/user > wget clacker:80/index.html
this is what Wget sends the HTTP server:

   GET /index.html HTTP/1.0
   User-Agent: Wget/1.7
   Host: clacker
   Accept: */*
   Connection: Keep-Alive

For this program listening on (non-priviledged) port 9877, for the
command from MS Internet Explorer:
   http://blake:9877/index.html &
this is what is sent to an HTTP server:

   GET /index.html HTTP/1.1
   Accept: image/gif, image/x-xbitmap, image/jpeg, image/pjpeg,
    application/vnd.ms-powerpoint, application/vnd.ms-excel,
    application/msword, */*
   Accept-Language: en-us
   Accept-Encoding: gzip, deflate
   User-Agent: Mozilla/4.0 (compatible; MSIE 5.5; Windows NT 5.0;
      XYZ_Inc Custom Install; T999999)
   Host: blake:9877
   Connection: Keep-Alive

What an HTTP server receives from Google Chrome:

   Mon Mar 22 00:00:12 UTC 2010 SERVER: 127.0.0.1 connect
    0 bytes delta: memprobe socket 2 connect
    WBSVR: on mysite received from socket 2:
   GET /xxxxx.html HTTP/1.1
   Host: mysite.com
   Connection: keep-alive
   User-Agent: Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US) AppleWebKit/532.0 (KHTML, like Gecko) Chrome/3.0.195.32 Safari/532.0
   Accept: application/xml,application/xhtml+xml,text/html;q=0.9,text/plain;q=0.8,image/png,*/*;q=0.5
   Accept-Encoding: gzip,deflate,sdch
   Accept-Language: en-US,en;q=0.8
   Accept-Charset: ISO-8859-1,utf-8;q=0.7,*;q=0.3
   If-None-Match: W/"7861f-71a-571268aa"
   If-Modified-Since: Thu, 19 Nov 2009 16:20:08 GMT

------------------------------------------------------------------------

HTTPget vs. WGET timing test, July 2004 (dial up).

Timing word HTTPget and program Wget (Reference 4) to retrieve a text
file from the Interactive Weather Information Network:

For back-to-back runs, during the day, dial-up connection.

 Run       Elapsed sec  Bytes fetched   Stated Rate      Bytes/Elapsed
 Wget-1    14.351       85903           6.28 KB/s        5986 bytes/sec
 Wget-2    14.230       85903           6.34 KB/s        6037 bytes/sec

 HTTPget-1 14.777       86156           6004 bytes/sec   5830 bytes/sec
 HTTPget-2 14.762       86156           6013 bytes/sec   5836 bytes/sec

(Note: bytes fetched differ because HTTPget saves the header too.)

Comparing Bytes/Elapsed (bytes/sec):
      Wget average: 6011.5
   HTTPget average: 5833.0
shows that Wget was about 3% faster.

A note about times of day displayed:

   The times of day displayed by tops are corrected to "true GMT"
   obtained from NIST (word NISTdelta) whenever it logs on to the
   Internet, as it has for this test.

   Times of day displayed by Wget use the machine time, so there will
   be a discrepancy.

   This shows that the machine time was 63 seconds fast when the test
   was run:

      [tops@clacker] ready > time time1 -

       stack elements:
             0 number: -63.0000100136
       [1] ok!

   A negative result means the machine is fast, so times of day shown
   by Wget are fast by 63 seconds.

   For example, the corrected start time for Wget Run 1 would be the
   given time, 08:22:10, less 63 seconds, or about 08:21:07.

   The Wget runs were made before the tops runs, and applying the 63
   second correction to the Wget times of day shows this.

Here are the runs:

Run 1 Wget:
[user@clacker] /home/user > time wget iwin.nws.noaa.gov/iwin/ca/state.html
--08:22:10--  http://iwin.nws.noaa.gov/iwin/ca/state.html
           => `state.html'
Connecting to iwin.nws.noaa.gov:80... connected!
HTTP request sent, awaiting response... 200 OK
Length: 85,903 [text/html]

    0K .......... .......... .......... .......... .......... 59% @  10.92 KB/s
   50K .......... .......... .......... ...                  100% @   3.86 KB/s

08:22:25 (6.28 KB/s) - `state.html' saved [85903/85903]
real    0m14.351s
user    0m0.020s
sys     0m0.000s

Run 2 Wget:
[user@clacker] /home/user > time wget iwin.nws.noaa.gov/iwin/ca/state.html

--08:22:26--  http://iwin.nws.noaa.gov/iwin/ca/state.html
           => `state.html.1'
Connecting to iwin.nws.noaa.gov:80... connected!
HTTP request sent, awaiting response... 200 OK
Length: 85,903 [text/html]

    0K .......... .......... .......... .......... .......... 59% @  11.34 KB/s
   50K .......... .......... .......... ...                  100% @   3.84 KB/s

08:22:41 (6.34 KB/s) - `state.html.1' saved [85903/85903]
real    0m14.230s
user    0m0.010s
sys     0m0.010s

Run 1 tops:
[tops@clacker] ready > date . nl time push "iwin.nws.noaa.gov" "/iwin/ca/state.html" HTTPget time pull - .
Thu Jul 15 08:22:00 PDT 2004
 HTTPget: host iwin.nws.noaa.gov
 HTTPget: connected to 205.156.51.137
 HTTPget: getting /iwin/ca/state.html
 HTTPget: receiving bytes ...
 HTTPget: received 86156 bytes at 6004 bytes/sec
 HTTPget: closing connection
 1.4777E+01
 stack elements:
       0 volume: _state.html  1 by 86156
 [1] ok!

Run 2 tops:
[tops@clacker] ready > date . nl time push "iwin.nws.noaa.gov" "/iwin/ca/state.html" HTTPget time pull - .
Thu Jul 15 08:22:16 PDT 2004
 HTTPget: host iwin.nws.noaa.gov
 HTTPget: connected to 205.156.51.137
 HTTPget: getting /iwin/ca/state.html
 HTTPget: receiving bytes ...
 HTTPget: received 86156 bytes at 6013 bytes/sec
 HTTPget: closing connection
 1.4762E+01
 stack elements:
       0 volume: _state.html  1 by 86156
       1 volume: _state.html  1 by 86156
 [2] ok!
[tops@clacker] ready >

------------------------------------------------------------------------

HTTPget vs. WGET timing test, April 2008 (DSL).

The National weather summary has grown to over 7 Mb.  Here is fetching
it using Wget and this program's HTTPget on Verizon DSL.  

Wget is smart enough to figure out the new IP address from the old; 
HTTPget had to be given the new one.

Wget:
[dale@plunger] /home/dale > time wget "iwin.nws.noaa.gov/iwin/us/nationalsummary.html"
--12:36:09--  http://iwin.nws.noaa.gov/iwin/us/nationalsummary.html
           => `nationalsummary.html'
Resolving iwin.nws.noaa.gov... done.
Connecting to iwin.nws.noaa.gov[140.90.113.200]:80... connected.
HTTP request sent, awaiting response... 301 Moved Permanently
Location: http://www.weather.gov/view/national.php?prodtype=nationalsummary [following]
--12:36:09--  http://www.weather.gov/view/national.php?prodtype=nationalsummary
           => `national.php?prodtype=nationalsummary'
Resolving www.weather.gov... done.
Connecting to www.weather.gov[140.90.113.200]:80... connected.
HTTP request sent, awaiting response... 200 OK
Length: unspecified [text/html]

    [                                                   <=>       ] 7,749,142     89.83K/s             

12:37:34 (89.83 KB/s) - `national.php?prodtype=nationalsummary' saved [7749142]


real    1m25.555s
user    0m0.140s
sys     0m0.460s
[dale@plunger] /home/dale > 

Total Wget time: 1m25.555s = 85.555 seconds


HTTPget:

[tops@plunger] ready > date . nl time push "http://www.weather.gov" "/view/national.php?prodtype=nationalsummary" HTTPget time pull - .
Sat Apr  5 12:37:47 PDT 2008
 HTTPget: host www.weather.gov
 HTTPget: connected to 140.90.113.200
 HTTPget: /view/national.php?prodtype=nationalsummary
 HTTPget: receiving bytes ...
 HTTPget: received 7749451 bytes at 91899 bytes/sec
 HTTPget: connection closed by host
 8.5428E+01
 stack elements:
       0 volume: _national.php?prodtype=nationalsummary  1 by 7749451
 [1] ok!
[tops@plunger] ready > 

Total HTTPget time: 85.428 seconds

It looks like a draw.  HTTPget time is a shade faster, but Wget was
able to resolve the old address, something HTTPget cannot do.

In network tests, the time probably boils down to how fast the network 
is running and less on how well the two programs run.

\-----------------------------------------------------------------------

Obsolete.

   Word nextport is now a native word in term.c, as this shows:
      [dale@kaffia] /opt/tops/tops/src > grep 'nextport (' *.c
      term.c:int nextport()  /* nextport (nPORT --- nPORT1) */

  _inline: nextport (nPort --- nPort1) \ next available port from nPort
\     Tries up to 20 ports, and returns Port1=-1 if no port found.
      [ 20 "max" book ]
      no NUM stkok not IF "nextport" stknot return THEN

      (nPort) "port" book
      port max + "port_max" book

      netstat these chars tic +trailing push
      peek this "LISTEN " grepr reach
      peek this "WAIT" grepr reach pile
      peek this "LAST" grepr reach pile
      peek this "ESTABLISHED" grepr reach pile

      pull drop any?
      IF "listen" book
      ELSE port return
      THEN

      BEGIN listen this port
         intstr grepr reach rows any
         port port_max < and
      WHILE one port bump
      REPEAT

      port port_max >=
      IF -1 (error)
      ELSE port (nPort1)
      THEN
   end

