\ {{{1 GNU General Public License
{
Program Tops - a stack-based computing environment
Copyright (C) 1999-2014  Dale R. Williamson

Author: Dale R. Williamson <dale.williamson@prodigy.net>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
1}}} 
}

{ File sys.v  September 1999

   Copyright (c) 1999-2014  D. R. Williamson
}  
\-----------------------------------------------------------------------

   "filesearch" missing IF "file.v" source THEN

{ ----------------------------------------------------------------------

   Contents:

   Use these to obtain the following list of contents:
      syspath "sys.v" + asciiload this " inline: " grepr reach dot
      syspath "sys.v" + asciiload this " define: " grepr reach dot
      syspath "sys.v" + asciiload this " function " grepr reach dot

   inline: .d ( --- ) \ display definitions that are outside the fence
   inline: .e ( --- ) \ display cataloged stack items outside the fence
   inline: >OCLOCK (nSEC --- qHH:MM:SS) \ sec into hours:minutes:sec
   inline: >SEC (qHH:MM:SS --- nSEC) \ hours:minutes:sec into sec
   inline: >stk (qS --- hT) \ text from running S upon the stack
   inline: clocko (hhmmss --- hh:mm:ss)
   inline: constructor (qArgList qWord --- ) \ make Word to make words
   inline: elapsed (qS1 qS2 --- n) \ seconds elapsed between time str
   inline: eload (qS key --- hT) \ load file saved by esave with key
   inline: esave (hT qS key --- ) \ save volume T to encoded file S
   inline: ERR ( --- ) \ compare error counts at current ERR stack level
   inline: ERRclr ( --- ) \ clear the ERR stack
   inline: ERRset (qS --- ) \ set ERR stack for S
   inline: ESSL ( --- f) \ true if ESSL library words are loaded
   inline: expecting (qE --- f) \ wait for E to be true or timeout
   inline: expectkill ( --- ) \ stop word expecting
   inline: expectout (sec --- ) \ seconds to timeout in word expecting
   inline: forever ( --- ) \ run forever, getting commands from a file
   inline: HH:MM (sec --- qHH:MM) \ seconds into hours and minutes
   inline: key_fetch ( --- nKey) \ fetch a Key saved by keys_save()
   inline: key_find (nKey --- f) \ find a Key saved by keys_save()
   inline: keys_get ( --- hKeys) \ get Keys saved by keys_save()
   inline: keys_make (nN nS --- hKeys) \ make 8-byte keys
   inline: keys_save (nS --- ) \ save keys in a file in user home
   inline: matlab ( --- ) \ start Matlab or go to Matlab prompt
   inline: memcat ( --- Mbytes) \ Mbytes in cataloged stack items
   inline: memspy ( --- Mbytes) \ real-memory size of this process
   inline: msource (qFile qM --- ) \ sourcing File words after marker M
   inline: msource1 (qFile qM qE --- ) \ sourcing File from M to E
   inline: nexthour ( --- HH) \ the hour after the present one
   inline: nn ( --- ) "work.n" psource end \ psourcing work.n
   inline: nodewin (qS --- ) \ make simulated node in scroll bar window
   inline: perl ( --- ) \ load perl words or go to perl prompt
   inline: psource1 (qFile qM qE --- ) \ evaluate infix from M to E
   inline: purgelib (qWord --- ) \ purge the MAT items in lib of Word
   inline: running (qS --- f) \ run command str S until done or timeout
   inline: set_time (qHH:MM:SS --- ) \ program time to HHMMSS
   inline: time_breakdown (sec --- HH:MM:SS)
   inline: time_randomize (qHH:MM:SS nSec --- qHH1:MM1:SS1) \
   inline: todayat (qHH:mm:ss --- s) \ seconds until today at HH:mm:ss
   inline: WAIT_ALARM (nSec --- ) \ initialize for a wait state
   inline: WAIT_INIT (nSec qWord --- ) \ initialize for a wait state
   inline: WAITING ( --- ) \ multitasker word started by word WAIT_INIT
   inline: who ( --- ) \ display names of cataloged items in main lib
   inline: whocat ( --- hT) \ wholib listings for all words in catalog
   inline: wholib (qW --- ) \ show table of cataloged stack items in W
   inline: whos ( --- ) \ show table of main library cataloged items
   inline: whoseq ( --- ) \ main library items displayed in sequence

   Words that use the multitasker.
   inline: ALARMR (d qW --- ) \ randomized alarm
   inline: everyhour (qWord --- ) \ make a word to do a task hourly
   inline: FLIP ( --- ) \ internal random coin flip
   inline: PLAY (r hT --- ) \ start words named in T at rate r
   inline: tap ( --- -1 or 0) \ latest flip, true or false

   Common commands to work with Unix.
   inline: noNL ( --- ) \ limit a NL in word console
   inline: shellunix ( --- qS) \ shell command for Unix
   inline: catf (qF1 qF2 --- qF) \ concatenate F1 and F2 to temp file F
   define: cd ( --- ) \ mimic Unix cd command: cd dirname
   define: cp ( --- ) \ Unix cp command: cp fromfile tofile
   inline: ctar (hNames qDir qFile --- ) \ Names of files to tar File
   define: diff ( --- ) \ Unix diff command: diff file1 file2
   inline: diff1 (qFile1 qFile2 --- hT) \ difference between files
   inline: finger ( --- hT) \ Unix finger command
   define: grep ( --- ) \ Unix grep command
   inline: grep1 (hT qS --- hT1) \ grep S in volume T with Unix grep
   inline: grep2 (qF qS --- hT1) \ grep S in file F
   define: gvim ( --- ) \ gvim command in the form: gvim filename
   define: gvim ( --- ) " not available" . nl ;
   inline: killmy (nPID --- ) \ kill my job PID
   inline: killjob (qS --- ) \ kill job in ps table having string S
   define: ll ( --- ) \ Unix subdirectory long list
   define: llr ( --- ) \ long list, reversed time order
   define: ls ( --- ) \ Unix ls (sort of)
   inline: ltar (qFile --- hT) \ list files from tar File archive
   define: man ( --- ) \ showing stack notation of word
   inline: _more (qFile --- ) \ Unix more command, ready-aim-fire style
   inline: .more (qFile --- ) \ display File in more if too many lines
   define: more ( --- ) \ the more command, fire-ready-aim version
   inline: netstat ( --- hT) \ Unix netstat -a command
   inline: netstat1 ( --- ) \ show Unix netstat
   define: noM ( --- ) \ perl command to remove DOS ctrl-M
   define: noTB ( --- ) \ perl command to trim file's trailing blanks
   inline: ns ( --- ) netstat1 ; \ show Unix netstat
   inline: pidtable ( --- hT) \ table of process ids and commands
   inline: remtab (hT --- hT1) \ from string or volume, remove tabs
   inline: remtabf (qS --- qS1) \ S1 is file S with tabs removed
   define: rm ( --- ) \ remove files with wildcards; interactive only
   inline: sysdate (qUnix --- d t) \ numbers from Unix date and time
   define: topic ( --- ) \ searches for expressons in manual
   inline: uptime ( --- s) \ total seconds since start up
   define: utail ( --- ) \ Unix tail command: tail filename
   inline: .upsince ( --- ) \ display uptime
   inline: .uptime ( --- ) \ display uptime
   inline: _vi (qS --- ) \ vi editor, ready-aim-fire version
   define: vi ( --- ) \ vi editor, fire-ready-aim version
   define: view ( --- ) \ vi read-only
   inline: viewbin (hX n --- hT) \ images of first n bytes of X
   define: vim ( --- ) \ vim editor, fire-ready-aim version
   define: vim ( --- ) typing "vim" tug -3 indent _vi done ;
   inline: _view (qS --- ) \ vi read-only
   inline: _vim (qS --- ) \ vim editor, ready-aim-fire version
   inline: _vim (qS --- ) _vi ;
   inline: which (qS --- qS1) \ Unix which command, postfix style
   define: ww ( --- ) "work.v" source end \ sourcing work.v
   inline: xtar (qDir qFile --- ) \ extract files from tar File archive
   inline: xterm (qS --- ) \ run program S in xterm window
   inline: xtermsb (qS --- ) \ run S in xterm window with scroll bar

---------------------------------------------------------------------- }

   inline: .d ( --- ) \ display definitions that are outside the fence
\     Definitions are catalog types DEFN and INLI, created by
\     words define:, inline:, inlinex, and inline.

\     Note: to obtain definitions on the stack, run this word's newdefs:
\         ".d" "newdefs" localrun

      [ "all words are inside the fence" is msg 

      {" inline: newdefs ( --- hT)
         fence_at _catitems any?
         IF this 2nd word drop "DEFN" grepr
            that 2nd word drop "INLI" grepr pile
            yes sort nodupes reach
         ELSE "" 
         THEN 
      "} "newdefs" inlinex
      ] newdefs (hT) any? not IF msg THEN one indent dot nl
   end

   inline: .e ( --- ) \ display cataloged stack items outside the fence
\     When booked into the catalog, stack items NUM, MAT, STR and VOL
\     go into catalog types VARI, MATR, STRI, and VOLU respectively.

\     Note: to obtain items on the stack, run this word's newitems:
\         ".e" "newitems" localrun

      [ "all cataloged stack items are inside the fence" is msg

      {" inline: newitems ( --- hT)
         fence_at _catitems any?
         IF this 2nd word drop "VARI" grepr
            that 2nd word drop "MATR" grepr pile
            that 2nd word drop "STRI" grepr pile
            that 2nd word drop "VOLU" grepr pile
            yes sort nodupes reach
         ELSE "" 
         THEN 
      "} "newitems" inlinex
      ] newitems (hT) any? not IF msg THEN one indent dot nl
   end

   inline: >OCLOCK (nSEC --- qHH:MM:SS) \ sec into hours:minutes:sec
    \ Incoming SEC can be a matrix column of numbers.
      dup push hand dup push rows 1st
      DO peek I pry time_breakdown LOOP
      pull rows pilen
      pull type NUM = IF 1st quote THEN
   end

   inline: >SEC (qHH:MM:SS --- nSEC) \ hours:minutes:sec into sec
{     Convert the day's HH:MM:SS into the number of seconds since
      the day's start at 00:00:00.
      Examples:
         One day:
         [tops@plunger] ready > "24:00:00" >SEC .i
          86400
         Two days:
         [tops@plunger] ready > "48:00:00" >SEC .i
          172800
}
      dup push
      ":" chblank 3 matread push
      peek 1st catch 3600 star
      peek 2nd catch 60 star plus
      pull 3rd catch plus
      pull type STR =
      IF dup chars IF ontop (show NUM) THEN THEN
   end

   inline: >stk (qS --- hT) \ text from running S upon the stack
{     This word runs text S and returns on the stack a volume, T, con-
      taining all the text that words in S running would have written 
      to the screen.

      This word can be entered up 12 times before LEVELS of nesting 
      is exceeded.  It demonstrates the use of words local and main 
      and the difference between putting a name on the stack and run-
      ning a name on the stack.

      The following example enters twice, and so produces two items 
      on the stack:

         " '3 2 random .m' >stk 8 1 random '%5.2f' format . " >stk

      Items in this word do not ride on the stack, in case there are 
      errors in S that clobber the stack when S runs.  Also the local 
      stack is not used, because a phrase being run could empty it, as
      by running word xl.

      Word cleantmp removes files in /tmp that have pattern runid.
      To avoid having cleantmp remove files while >stk is using them,
      use word runid1.  Word >stk deletes its own files as it runs.
}
      [ 12 into LEVELS
      \ Making unique file names for LEVELS levels of nesting:
           "_bin" "tmppath" yank runid1 +
           "_stkXX.tmp" + push
           list: LEVELS 1st 
              DO peek "XX" I "%02.0f" format strp LOOP
           end words "File" book pull drop

      \ Run this to see File name list: ">stk" "File" yank .

      \ Initialize LEVELS names now before this word is used, so when
      \ it is used the names already exist behind the fence and don't 
      \ show up in whos lists:
        LEVELS 1st DO "" "S" I suffix book "" "Y" I suffix book LOOP

        no "lev" book
      ]
      hide
      yes \ testing for STR or VOL on stack:
      one STR stkok and
      one VOL stkok or not IF ">stk" stknot return THEN (qS)

      lev tic "lev" book         \ bump run level
      "Y" lev suffix "Y" book    \ Y is unique name for SYSOUT this lev
      "S" lev suffix "S" book    \ S is unique name for text S this lev
 
      (qS) S (qName) book          \ incoming text is called S
      SYSOUT (qSYS) Y (qName) book \ current sysout saved is called Y

      File lev ndx quote (qFile) \ file name for this lev
      (qFile) this deleteif      \ delete old, or text is appended

      (qFile) set_sysout         \ set sysout to send output to file

      S (qName) local (qS) main  \ run S in main; output goes to file

\     Because of reentrancy, lev below this point may not be the same 
\     as lev above.  If it is different, it is greater.

      File lev ndx quote (qFile) \ file name for this lev
      (qFile) this asciiload     \ load file of text output
      notrailing hand (hT)       \ clean up text; get handle to VOL

      swap (qFile) delete        \ delete file

      "Y" lev suffix (qName)     \ name of saved SYSOUT, this lev
      (qName) local set_sysout   \ set sysout back to saved

      "" S book                  \ free library memory of S this lev
      -1 lev bump                \ decrement lev

      nohide
   end

   inline: clocko (hhmmss --- hh:mm:ss)
\     Opposite of oclock.
      10000 /mod int "%02d:" format swap
      100 /mod int "%02d:" format swap
      int "%02d" format + +
   end

   inline: constructor (qArgList qWord --- ) \ make Word to make words
{     Make a constructor word called Word to make other words that are 
      container words containing the items in quoted ArgList.

      When they run, the container words created by a constructor word
      simply put their names on the stack (see man container).

      Example:

         1. Making constructor word "car:"
               >> constructor("make model year engine","car");

         2. Using car to make a container word called Fortycoupe:
               >> car("Ford", "coupe", 1940, "hemi", "Fortycoupe");

         3. Showing names in the library of container word:
               >> wholib("Fortycoupe");

         4. Extracting an item and printing it:
               >> dot(Fortycoupe.make);
}     [
       \ The following text volume, MAKE, contains the phrases for 
       \ the inline code of constructor Words created:  
         {" (hA1 hA2 ... hAn qNewLib) \ stack diagram of Word

           [ defname "NAME" book, VOL tpurged "ARGS" book ]

          \ Check the stack:
            depth ARGS rows tic < not \ need 1+rows(ARGS) items on stack
            1 STR stkok and           \ and need STR NewLib on tos
            those chars 0> and not    \ and need some chars in NewLib
            IF NAME stknot return THEN

          \ Make a container word named by the incoming quote on the
          \ stack.  The stack diagram for a container word called 
          \ Newlib is ( --- NewLib); see man container.
            (qNewLib) dup push container \ make a container word

          \ Store items on the stack into named items in the library
          \ of NewLib, where names are given in ARGS:
            ARGS chars any

            IF ARGS rows 1st DO (hAi) peek ARGS I quote bank LOOP
               pull (qNewLib) drop
            THEN

         "} chop "MAKE" book \ volume containing the text for Word
      ]
    \ Check the stack:
      these chars 0>        \ require some chars for WORD
      one STR stkok and     \ require STR first on stack
      two STR stkok and not \ require STR second on stack
      IF "constructor" stknot return THEN

      (qArgs qWord) "WORD" book

      MAKE WORD -inlinex \ make inline called WORD

    \ Bank list ARGS, reversed for incoming stack when WORD runs: 
      (qArgs) words any? IF reversed WORD "ARGS" bank THEN
   end

   inline: elapsed (qS1 qS2 --- n) \ seconds elapsed between time str
      no swap oclock ltime, no rot oclock ltime less 
   end

   inline: eload (qS key --- hT) \ load file saved by esave with key
      [ scalar is esav ] esav filetrue IF esav fclose THEN
      swap filefound
      IF old binary "esav" file
         esav its file.size pry fget swap bload
         this type NUM = \ if NUM, key is probably invalid
         IF 2drop 0 0 blockofblanks return ELSE textget THEN
      ELSE " file not found" ersys
      THEN
   end

   inline: esave (hT qS key --- ) \ save volume T to encoded file S
\     key is a number greater than 0 used to load T using word eload.
      [ scalar is esav ] esav filetrue IF esav fclose THEN
      swap dup deleteif new binary "esav" file
      (hT key) bmake esav fput esav fclose 
   end

   inline: ERR ( --- ) \ compare error counts at current ERR stack level
{     Flag an error to a region of an application with an arbitrary 
      marker in a FIFO stack that has been previously set by ERRset.

      Use pairs of (ERRset ... ERR) throughout words of an application
      to flag where an error occurs.  These pairs can be left in place
      after an application is running, and will only show anything when
      there is an error.

      Example: Copy the following into the top of file work.v and at 
      the ready prompt run: ww abc

         ERRclr

         inline: abc ( --- )
            "abc running def1" ERRset \ initialize
               def1                   \ run def1
            ERR                       \ get message if error in def1
         end
         inline: def1 ( --- )
            "def1 running def2" ERRset
               def2 \ run def2
            ERR
            . \ nothing on stack to print, so word . has an error
         end
         inline: def2 ( --- )
            "def2 running def3" ERRset
               def3 \ run def3
            ERR
            + \ two items not on stack to add, so word + has an error
         end
         inline: def3 ( --- )
            " **** def3 running ok ****" . nl
         end

         halt

      Demo: The following shows (ERRset, ERR) pairs working in words
      _NISTdelta and NIST_SYNC when there is a connection problem (in
      NIST_SYNC, VERBOSE=yes):

         [dale@plunger] /home/dale > tops
                  Tops 3.2.0
         Fri Mar 29 14:33:25 PDT 2013
         [tops@plunger] ready > NIST_SYNC
          unblock: alarm to read from socket 6 has timed out
          ERR: error in _NISTdelta.receive 2
          ERR: error in _NISTdelta
          ERR: error in /opt/tops/tops/sys/net.v NIST_SYNC call to 
             NISTdelta
          NIST_SYNC: time sync with NIST, -4 sec, Fri Mar 29 14:33:55 
             PDT 2013
          ERR: error in /opt/tops/tops/sys/net.v NIST_SYNC
          fault at word: NIST_SYNC
          faulty phrase: NIST_SYNC [Enter]

         Purged counts and empty names are in the library of ERR after
         these errors, indicating good balance of (ERRset, ERR) pairs:

         [tops@plunger] ready > "ERR" wholib
          Stack items and words in the library of word ERR:
           Name              Rows Cols Bytes Type  Description
           add               11   1    44    PTR   inline
           "counts"          1    6    8     STR   string
           "names"           1    5    7     STR   string
           " ERR: error in " 1    15   17    STR   string
           8C48850#          1    51   51    STR   string
           names             0    0    0     VOL   volume(empty)
           counts            0    1    0     MAT   dense(purged)
                                       127   total
        
         This shows that NIST_SYNC.VERBOSE is true (-1) (as running
         "NIST_SYNC" wholib would also show):

         [tops@plunger] ready > "NIST_SYNC" "VERBOSE" yank

          stack elements:
                0 number: VERBOSE  -1

         [tops@plunger] ready > 
}
      [ 0 1 null "counts" book
        VOL tpurged "names" book

      \ Macro to pile S name and current ercnt on top of FIFO stacks:
        '(qS) names pile "names" book '
        'ercnt counts pile "counts" book' + "add" macro
      ]
      counts rows 0= 
      IF " ERR: error; check for unbalanced ERRset:ERR pairs" . nl 
         names rows 0> \ this probably cannot happen, but just in case:
         IF "ERR: these ERRset names are present:" . nl names . nl
         THEN
         return
      THEN

      ercnt counts 1st pry <> \ has error count changed?
      IF " ERR: error in " names 1st quote strchop + . nl 
      THEN
      counts rows 1 > 
      IF \ pop 1st item from stacks:
         counts 2nd over rows 1- items reach "counts" book
         names 2nd over rows 1- items reach "names" book
      ELSE \ stacks are empty: 
         0 1 null "counts" book VOL tpurged "names" book
      THEN
   end

   inline: ERRclr ( --- ) \ clear the ERR stack
      0 1 null "ERR" "counts" bank
      VOL tpurged "ERR" "names" bank
   end

   inline: ERRset (qS --- ) \ set ERR stack for S
      0 STR stkok
      IF strchop "ERR" "add" localrun
      ELSE "ERRset" stknot return
      THEN
   end

   inline: ESSL ( --- f) \ true if ESSL library words are loaded
\     See essl.c for words that use the IBM Engineering and Scientific 
\     Subroutine Library.
      "trilowSSL" "exists?" main
   end

   -stkbal
   inline: expecting (qE --- f) \ wait for E to be true or timeout
{     Returned f=true as soon as periodically running phrase E returns 
      true; return f=false if timed out or killed.

      Text E contains phrases that when run in main produce a true or
      false flag.  The stack diagram of E is: E ( --- f).

      This word idles sourcing of words, as from files or from the key-
      board.  Word running uses it to wait for an output file.  

      While the machine idles, the multitasker continues to run its
      tasks.

      Word expectout can be used to change the initial timeout set be-
      low.

      This word is not reentrant: E cannot run word expecting.  This is
      really not a restriction, since the same result can be achieved 
      by restructuring words to run serially.

      Words that expect something, but that do not need to idle the ma-
      chine, can use word ALARM, and there is no restriction on how many
      alarms can be running.

      Word expectkill can be used in an ALARM to stop expecting, for
      any reason, before the timeout period.
}
      [ 30 (sec) is timeout, 3 (sec) is waiting ]

      chop "event" no "killed" book book 

      timeout waiting min "waiting" book

      timeout waiting plus push
      BEGIN killed 
         IF pull fail and return 
         THEN pull waiting less this push
         any event main this "f" book not and
      WHILE waiting idle                         
      REPEAT pull trash f
   end
   stkbal
   
   inline: expectkill ( --- ) \ stop word expecting
\     This word is likely to be fired by an ALARM, since word expecting
\     will have everything idled.
      yes "expecting" "killed" implant ;
   
   inline: expectout (sec --- ) \ seconds to timeout in word expecting
      oh NUM stkok not IF "expectout" stknot return THEN
      "expecting" "timeout" implant ;

   inline: forever ( --- ) \ run forever, getting commands from a file
{     The name of the file (initially) is ftask.     

      The following Unix script will run the program in batch, waiting
      for commands to be run that appear on the file called ftask:

         #!/usr/local/bin/tops
         1 "expecting" "waiting" bank forever

      In the example above, banking 1 for the value of waiting in word 
      expecting means it will look for file ftask once every second.
      This replaces the initial value of waiting=3 in word expecting.

      In the same way, another name for file in word forever could be 
      banked to change the name from ftask, or replace it with one that
      has a path, as in: "/tmp/myfile" "forever" "file" bank

      The heart of this word is the local inlinex called forever_see.

      Since forever_see is reentrant, a long running task started by 
      word forever can take a brief pause and execute another command 
      file that might be waiting by running the phrase:

         "forever" "forever_see" localrun

      For example, the phrase above might be run after each iteration
      through a long loop, before the original invocation of forever_see
      returns and loops back to word expecting.
}
      [ "ftask" is file \ looking for this local file
        {"
           file file?
           IF file asciiload (hT)
              file delete
              (hT) main
           THEN
        "} "forever_see" inlinex
      ]
      MILLION expectout \ timeout in word expecting is a very long time
      file deleteif
      BEGIN file quoted " file?" cat (qE) expecting forever_see false
      UNTIL
   end

   inline: HH:MM (sec --- qHH:MM) \ seconds into hours and minutes
    \ Thu Jan 16 08:33:27 PST 2014

      (sec) dup 0< IF abs yes ELSE no THEN "neg" book
      (sec) 3600 /mod 
      (sec_rem HH) "%02.0f:" format swap
      (sec_rem) 60 / 0.5 + integer 59 min "%02.0f" format +
      neg IF "-" swap + THEN
   end

   inline: key_fetch ( --- nKey) \ fetch a Key saved by keys_save()
    \ Mon Mar 10 05:47:00 PDT 2014
    \ Read a Key from the file saved by word keys_save().
      keys_get (hKeys) 1st over rows ndx 1 1 ranint @ pry
   end

   inline: key_find (nKey --- f) \ find a Key saved by keys_save()
{     Mon Mar 10 06:05:41 PDT 2014
      Find a Key in the file saved by word keys_save().

      Example (requires keys saved previously using keys_save()):
         key_fetch (nKey) dup key_find swap nl " key" . .hex \
         IF " found" ELSE " not found" THEN . \
         urn dup key_find swap nl " key" . .hex \
         IF " found" ELSE " not found" THEN . nl
}
      keys_get (nKey hKeys) swap bsearch lop
   end

   inline: keys_get ( --- hKeys) \ get Keys saved by keys_save()
    \ Mon Mar 10 06:49:25 PDT 2014
    \ Get the vector of Keys in the file saved by word keys_save().
      [ "" "KBIN" book ]
      KBIN filetrue IF KBIN fclose THEN
      "keys_save" "KFILE" yank old "KBIN" file
      KBIN "keys" get (hKeys) KBIN fclose
   end

   inline: keys_make (nN nS --- hKeys) \ make 8-byte keys
    \ Thu Mar 13 18:48:09 PDT 2014
      (nS) seedset (nN) push 
      list: pull 1st DO urn drop seedget LOOP ; 
      "_keys" naming (hKeys)
   end

   inline: keys_save (nN nS --- ) \ save N keys in a file in user home
{     Mon Mar 10 04:35:16 PDT 2014

      A sorted N-by-1 vector of random floating point numbers is saved
      to a protected file of private keys.

      Companion word key_fetch reads randomly one of the saved keys.

      Incoming numbers N and S are the numbers passed to the word whose
      ptr is stored in this library, and called pKEYS_MAKE.  Number N 
      is the number of keys to be saved, and number S is the random 
      seed for generating them.

      These are private keys, so the ptr pKEYS_MAKE in this library is
      to a user word that makes the keys.   The ptr must be banked here
      before this word can work.  The stack diagram for the word having
      ptr pKEYS_MAKE is (nN nS --- hKeys) where number N is the number
      of keys (rows) in output vector Keys and number S is the random
      seed to use.

      The ptr for word keys_make would be suitable for pKEYS_MAKE.

      On different machines requiring the same keys, the same values
      of N and S must be used.

      Example: 
      This shows banking ptr(keys_make) into keys_save.pKEYS_MAKE,
      setting the file name in keys_save.KFILE and then running
      keys_save to make 10 keys:
         "keys_make" ptr "keys_save" "pKEYS_MAKE" bank \
         "/tmp/keys.bin" "keys_save" "KFILE" bank \
         10 seed0 (nS) keys_save \
         keys_get "%12.0f" format nl . nl
}
      [ "HOME" env (qENV) dup                 \ user home
        (qENV) -path "USER" book              \ name of user
        (qENV) "my_keys" catpath "KFILE" book \ name of saved file
        0 "KBIN" book                         \ handle to saved file
        0 "pKEYS_MAKE" book                   \ ptr to maker of keys
      ]
      true 1 NUM stkok and, 2 NUM stkok and not
      IF "keys_save" stknot return THEN

      pKEYS_MAKE ptr? not
      IF (nN nS) 2drop 
         " keys_save: ptr pKEYS_MAKE is not set" . nl 
         HALT \ don't just return; halt the train
      THEN

      KFILE file? 
      IF KFILE fallow not
         IF (nN nS) 2drop 
            " keys_save: file " . KFILE . " must be deleted by "
            USER + . nl
            HALT \ don't just return; halt the train
         THEN
      THEN

      KBIN filetrue IF KBIN fclose THEN
      KFILE new "KBIN" file

    \ Run user function to make keys:
      (nN nS) pKEYS_MAKE exe (hkeys) yes sort "keys" naming KBIN put

    \ These are private keys.  Set very protected permission:
      KBIN fclose KFILE 256 chmod \ only owner can read, cannot write

      " keys_save: keys saved in " . KFILE . nl 
   end

   inline: matlab ( --- ) \ start Matlab or go to Matlab prompt
      "_engOpen" exists? not
      IF " Matlab engine facility is not present" . nl return THEN

      "_matlab" exists?
      IF _matlab \ go to prompt
      ELSE "matlab.v" source \ load words
         "engOn" exists? IF engOn THEN \ start engine
      THEN
   end

   inline: memcat ( --- Mbytes) \ Mbytes in cataloged stack items
{     Total bytes used for these library items: 
         DEFN, INLI, MATR, STRI, VARI, VOLU.

      Note: after running this word, running 
          "memcat" wholib
      will show, within the library listing of memcat, the number 
      of bytes found for each type of library item.
}
      [ 16 "per_item" book ]

      no "OVERHEAD" book

      catitems push

      peek "DEFN" tug
      -5 indent noblanklines counting (n) dup "DEFN" book

      peek "INLI" tug
      -5 indent noblanklines counting (n) dup "INLI" book

      peek "MATR" tug
      -5 indent noblanklines counting (n) dup "MATR" book

      peek "STRI" tug
      -5 indent noblanklines counting (n) dup "STRI" book

      peek "VARI" grepr rows eight star (n) dup "VARI" book

      pull "VOLU" tug
      -5 indent noblanklines counting (n) dup "VOLU" book

      OVERHEAD

      seven listn totals ontop MILLION slash

      \ Local inline word counting, to sum the size of each lib item:
      [ {" (hT --- n) \ T contains tagged names of cataloged stack items
           no (n) 
           (hT n) those dims star any
           IF those rows 1st \ summing bytes of each item

              DO (hT n) that I quote 
                 libpry sizeof (bytes) plus (n)
              LOOP
              (hT n)

            \ Plus some overhead per item:
              those rows per_item star OVERHEAD plus "OVERHEAD" book

           THEN lop (n)
        "} "counting" inlinex
      ]
   end

   inline: memspy ( --- Mbytes) \ real-memory size of this process
      "ps v > " scratch cat minshell
      scratch asciiload scratch delete
      this 1st quote words "RSS" (Unix and Linux) grepr any? not
      IF this 1st quote words "DSIZ" (older Linux) grepr THEN
      any?
      IF ontop (row) swap these 1st ten items catch
         getpid int$ spaced grepr reach words (hT)
         swap (hT row) quote number 
         IF 1000 slash "Mbytes" naming ELSE zero THEN
      ELSE drop zero
      THEN
   end

   inline: msource (qFile qM --- ) \ sourcing File words after marker M
{     In File with marker M, begin sourcing at the first line that
      begins with string M.

      Marker M must be the first word on its line, and followed by a 
      blank space.

      Sourcing stops at a word like halt or end, or when the end
      of File is hit.
}
      [ scalar "mfil" book ] \ local ref for filetrue below

      true one STR stkok and two STR stkok and not
      IF "msource" stknot return THEN

      mfil filetrue IF mfil fclose THEN

      (hM) strchop "MARKER" book
      (qFile) filefound not
      IF " file not found" ersys return THEN

      (qFile) old ascii "mfil" open, mfil rows any not
      IF " msource: invalid file handle--check permission" . nl 
         return 
      THEN

      purged (hT) push
      -1 "MSEEK" book

      mfil purged MARKER fmapleft (hMap) any?

      IF (hMap) dup push rows 1st
       \ Find the first marker that matches:
         DO mfil peek I 1st fetch (n) fseek
            mfil peek I 2nd fetch (bytes) fget strchop (qS)
            1st MARKER chars items catch (qS)

            MARKER (qS qM) strmatch 0=
            IF peek I 1st fetch "MSEEK" book \ where to seek 
              EXIT                           \ exit this loop
            THEN
         LOOP pull (hMap) drop
      THEN

      MSEEK -1 >

      IF mfil MSEEK fseek 
         mfil INF fget (hT)
         MARKER tug MARKER chars negate indent (hT)
         pull trash (hT) push 
      ELSE " msource: marker not found: " MARKER cat ersys
      THEN 
      mfil fclose, pull (hT) any? IF (hT) main THEN
   end

   inline: msource1 (qFile qM qE --- ) \ sourcing File from M to E
    \ In File, strings M and E are different, and are the only strings
    \ in their lines.  M and E can contain blanks between substrings.

      xbase push 1based rot filefound
      IF asciiload dup rot chop (qE) grepe any?
         IF 1st pry nit 1st swap items reach
            this other chop (qM) grepe any?
            IF 1st pry those rows that less
               tic items reach any?
               IF this 1st quote chop 
                  rot chop chars negate indent
                  those chars blpad
                  that 1st said notrailing noblanklines (hT)
                  peek indexbase 
                  (hT) main 
               ELSE 2drop " no lines to source" ersys
               THEN
            ELSE 2drop " msource1: beginning string not found" ersys
            THEN
         ELSE 2drop " msource1: ending string not found" ersys
         THEN
      ELSE 2drop " msource1: file not found" ersys
      THEN pull indexbase
   end

   inline: nexthour ( --- HH) \ the hour after the present one
\     Returns 24 if this hour is 11 PM.
      systime$ oclock 10000 /mod lop tic (HH)
   end

   inline: nn ( --- ) "work.n" psource end \ psourcing work.n

\  For simulated node windows, S into word nodewin is a string that runs
\  this or another program.
   inline: nodewin (qS --- ) \ make simulated node in scroll bar window
\     Run shell string S in a new window.
\     To change window geometry, bank a string like this into GEO: 
\        "-geometry 50x8+0+146" "nodewin" "GEO" bank

      [ "-geometry 50x8+0+0" "GEO" book 
        "SeaShell3" "BACK" book
        "Black" "FORE" book
      ]

      "xtermsb" "XSET" yank (qSav) push \ save XSET from xtermsb lib

       TERM \ defining node window properties:
       "-bg BACK -fg FORE -cr Salmon3 -fn 7x14 " cat
       "-display " "DISPLAY" env spaced cat cat
       "-sb -sl 1024 GEO -title " cat (qXSET)

      "GEO"  GEO  strp
      "BACK" BACK strp
      "FORE" FORE strp

      (qXSET) "xtermsb" "XSET" bank \ bank new XSET into xtermsb
      (qS) xtermsb                  \ make window that is running S

      pull (qSav) "xtermsb" "XSET" bank \ set XSET back in xtermsb lib
   end

   inline: perl ( --- ) \ load perl words or go to perl prompt
      "_perl" missing
      IF "perl.v" source \ load words
      ELSE _perl \ go to prompt
      THEN
   end
      
   inline: psource1 (qFile qM qE --- ) \ evaluate infix from M to E
    \ Sat Jul 27 12:03:52 PDT 2013.  Based on msource1.

    \ In File, strings M and E are different, and are the only strings
    \ in their lines.  M and E can contain blanks between substrings.

      xbase push 1based rot filefound
      IF asciiload dup rot chop (qE) grepe any?
         IF 1st pry nit 1st swap items reach
            this other chop (qM) grepe any?
            IF 1st pry those rows that less
               tic items reach any?
               IF this 1st quote chop
                  rot chop chars negate indent
                  those chars blpad
                  that 1st said notrailing noblanklines (hT)
                  peek indexbase
                  (hT) eval
               ELSE 2drop " psource1: no lines to source" ersys
               THEN
            ELSE 2drop " psource1: beginning string not found" ersys
            THEN
         ELSE 2drop " psource1: ending string not found" ersys
         THEN
      ELSE 2drop " psource1: file not found" ersys
      THEN pull indexbase
   end

   inline: purgelib (qWord --- ) \ purge the MAT items in lib of Word
      (qWord) dup exists? not IF drop return THEN "Word" book
      Word "wholib" >stk (qT) 
      (qT) 3rd those rows thrulist reach \ toss topmost 2 title lines
      (qT) dup 1st word drop "Name" book
      (qT) dup 5 ndx word drop "Type" book
      (qT) rows 1st
      DO Type I quote strchop "MAT" =
         IF purged Word Name I quote bank THEN
      LOOP
      "" "Name" book
      "" "Type" book
   end

   inline: running (qS --- f) \ run command str S until done or timeout
{     Run a command shell script and do not return until the job is 
      done or word expecting times out.

      Incoming S can be the name of a script file, in which case it 
      must be an executable file, or S can be a volume T that contains 
      all the commands of a script.

      Appends to S a line to write a dummy file when S ends, starts S
      in background, and runs word expecting to wait for the file to 
      appear.
}
      [ yes is REPORT \ yes to display this msg if timeout:
        " running timed out before script ended; pausing..." says msg
        30 "errpause" book \ secs to pause if timeout

\       File names to use:
           "_bin" "tmppath" yank (pathtmp) push
              peek runid ".ready" cat cat is ready
              pull runid ".script" cat cat makes script
{
        Strings ready and script are file names in this word's local 
        library; here is viewing these names interactively:

           [tops@clacker] ready > "running" "ready" yank .
           /tmp/T1412.ready

           [tops@clacker] ready > "running" "script" yank .
           /tmp/T1412.script
}
      ]
      ready script deleteif deleteif
      (qS) textput (qS)

      (qS) "echo>" ready + pile (qS1) \ append a line to say ready
      (qS1) script save \ write the appended script to run
      script 448 chmod  \ make the script executable

      script " &" cat shell   \ run the appended script in background
      ready quoted " file?" + \ phrase for expecting
      (qE) expecting (f)      \ wait here until file 'ready' appears

      IF yes 
      ELSE 
         REPORT IF msg ersys THEN

       \ Saving the failed script to go with any core file:
         time ctime "  running failed on script: " script cat cat
         script asciiload
         "-" 72 cats (qTime qScript q-) three pilen
         "running.core" append

         errpause idle \ let things like wget settle out
         fail
      THEN
      ready script deleteif deleteif
   end

   inline: set_time (qHH:MM:SS --- ) \ program time to HHMMSS
      date1 sysdate drop (YYYMMDD) swap          \ machine day     

      (qHH:MM:SS) oclock (HHMMSS)                \ set to time

      (YYYMMDD HHMMSS) ltime (s)                 \ set to local seconds
      time1 date1 sysdate ltime less (ZONEdelta) \ zone delta
      (s ZONEdelta) plus (GMTprog)               \ set to gmt seconds
      time1 (GMTmachine) less (delta)            \ gmt delta

      (delta) GMTdelta                           \ set program sec
   end

   inline: time_breakdown (sec --- HH:MM:SS)
{     Time in seconds into hour, minutes and seconds.

      If sec is machine time from word time, then HH:MM:SS is the
      current time in Greenwich, England, no matter where you are.

      If sec is negative, the previous day is assumed.

      Example:
         time dup ctime . nl time_breakdown 11 spaces . . nl
}
      (sec) dup 0< IF 86400 + THEN (sec) \ assumes |-sec|<86400
      86400 mod integer
      3600 /mod "%02.0f:" format swap
      60 /mod   "%02.0f:" format swap
      (sec_rem) 60 mod "%02.0f" format + +
   end

   inline: time_randomize (qHH:MM:SS nSec --- qHH1:MM1:SS1) \
\     Add random seconds, up to nSec, to time HH:MM:SS.

\     Note: if hour wraps when HH=23, then HH1=24.
\     Example: "23:59:00" 300 time_randomize (24:02:35)

      [ list: 3600 60 1 ; "SEC" book ]

      (nSec) "Sec" book

      dup push rows 1st
      DO peek I quote
         (qHH:MM:SS) ":" chblank numerate SEC *by totals
         one Sec one one ranreal plus ontop
 
         3600 /mod "%02.0f" format swap
         60 /mod ":%02.0f" format swap
         integer ":%02.0f" format cat cat
      LOOP pull rows pilen
   end

   inline: todayat (qHH:mm:ss --- s) \ seconds until today at HH:mm:ss
         [ "' time of day has passed' dot nl" "sorry" inlinex ]
                           no systime$ oclock
                         that three roll oclock
                          ltime rev ltime less
                              any? not IF
                               sorry no
                               THEN end

   inline: uptime ( --- s) \ total seconds since start up
\     Uses time1 and not time, to bypass any changes made after start up
\     by GMTdelta and reflected in word time.
      [ time1 "time0" book ] time1 time0 less integer ;

   inline: .upsince ( --- ) \ display uptime
      "uptime:" uptime (s) 

      [ {" (s --- qS)
           86400 /mod " %03.0f day" format swap
           3600 /mod " %02.0f hr"  format swap
            60 /mod " %02.0f min" format spaced swap drop
           cat cat cat
        "} "UFORMAT" inlinex

      ] UFORMAT "since " "uptime" "time0" yank ctime cat cat . nl
   end

   inline: .uptime ( --- ) \ display uptime
      "uptime:" uptime (s) ".upsince" "UFORMAT" localrun
      "on " date cat cat . nl
   end

   inline: WAIT_ALARM (nSec --- ) \ initialize for a wait state
{     Prepare for an indeterminate wait state that will begin with 
      upcoming word WAIT_BEGIN.

      WAIT_ALARM sets an alarm to end the indeterminate wait state, 
      about to be started, after a specified time if the wait state 
      has not ended sooner.

      This word will set an alarm to run WAIT_END in Sec.  It is in-
      tended as a time out measure, in case WAIT_END is not obtained
      from its expected source.
}
      (nSec) "WAIT_END" ALARM
   end

   inline: WAIT_INIT (nSec qWord --- ) \ initialize for a wait state
{     Prepare for an indeterminate wait state that will begin with 
      upcoming word WAIT_BEGIN.

      WAIT_INIT allows the program to run a word that will dictate when
      the indeterminate wait state, about to be started, will end.

      At word WAIT_BEGIN, the program will pause at the current location
      in text or typing, for up to Sec seconds, waiting until Word re-
      turns a true flag.

      The stack diagram for Word is ( --- f).
 
      When this word, WAIT_INIT, is run, it starts its companion word, 
      WAITING, running in the multitasker to limit the wait period 
      to Sec seconds.  As soon as word WAITING detects a true flag 
      from Word, it turns itself off and the indeterminate wait state
      ends.

      Word WAITING is run as a periodic TASK every frac*Sec seconds,
      rather than as an ALARM at Sec seconds.  

      For example, if frac=0.25 and Sec=10, WAITING will test Word for 
      a true flag after 2.5, 5, 7.5, and 10 seconds.  These are rather 
      coarse intervals, and the wait will always be at least 2.5 seconds
      if no other method of ending the wait period is implemented.

      One approach for overcoming this is to increase the frequency of 
      multitasker checking of Word for a true flag, such as making frac
      ten times smaller.  This is the only choice when waiting for a 
      system command to complete, like running a script to start a 
      server.

      But in other cases it may be possible to have the word using 
      WAIT_INIT to also run word WAITING every time something has been 
      done that might cause Word to return a true flag.  WAITING is 
      simply a word, and there is no reason not to run it just because 
      the multitasker is running it too.

      As examples of running word WAITING to end the waiting period 
      as soon as possible, see words remoteack and remoterun1 in file
      net.v, and word make_piece in file clu.v.  Here is a snapshot
      of the text in word make_piece as cluster nodes report to the
      head node and WAITING is testing that all have reported in:
         ...
         ELSE
            S NODES_DONE pile "NODES_DONE" book

          \ Don't wait for next multitasker cycle to run WAITING.  
          \ Maybe all the nodes are done now:
            WAITING
         THEN
         ...

      Word WAIT_INIT and related words are meant to run with no external
      influence.  While WAITING runs, behavior is unpredictable if word
      WAIT_END is run externally, as by a command from a TCP/IP con-
      nection or an alarm from word WAIT_ALARM.  This will upset the 
      synchronization of the wait stack row count (array ptrs) in 
      WAIT_INIT with the number of times word WAITING has run WAIT_END.
}
      [ {"
           no one null "ptrs" book  \ Word ptr
           no one null "sec" book   \ Sec to wait (max)
           no one null "start" book \ starting time
           no one null "rates" book \ multitasker rate
        "} "Purged_Arrays" inlinex, Purged_Arrays

        .25 "frac" book \ WAITING multitasker period = frac*Sec
      ]
      (qWord) this exists? not 
      IF " WAIT_INIT: word " that " not found" cat cat ersys return THEN

      (qWord) ptr ptrs pile "ptrs" book \ on top of pile of ptrs
      (nSec) dup sec pile "sec" book    \ on top of pile of secs
      time start pile "start" book      \ on top of pile of start times
      (nSec) frac * one swap / (rate)   \ multitasker rate for Word
      this rates pile "rates" book      \ on top of pile of rates

      (rate) "WAITING" PLAY \ start task WAITING, running Word at rate
   end

   inline: WAITING ( --- ) \ multitasker word started by word WAIT_INIT
{     This word handles overlapping wait states stacked in the arrays 
      of word WAIT_INIT.  

      The multitasker runs this word to monitor the wait period for 
      time out, but the application should also run this word to end 
      the wait period as soon as possible; see notes in word WAIT_INIT.
}
      [ no "timeout" book ]

      "WAIT_INIT" "ptrs" yank any? not
      IF no "timeout" book return THEN

      (hPtrs) 1st pry exe (f1) \ run Word
      timeout (f2) or

      IF \ timeout, or Word returned true:
         "WAIT_INIT" "ptrs" yank (hPtrs) these rows one >

         IF \ Resume WAITING for the 2nd in array stacks of WAIT_INIT.  

          \ Rows in all arrays of WAIT_INIT (ptrs, sec, start, rates)
          \ are raised so 2nd becomes 1st (using reach):

            (hPtrs) 2nd those rows nit items (hRows), this push 
            (hPtrs hRows) reach (hPtrs) "WAIT_INIT" "ptrs" bank

            "WAIT_INIT" "sec" yank (hSec) peek (hRows)
            (hSec hRows) reach (hSec) "WAIT_INIT" "sec" bank

            "WAIT_INIT" "start" yank (hStart) peek (hRows)
            (hStart hRows) reach (hStart) "WAIT_INIT" "start" bank

            "WAIT_INIT" "rates" yank (hR) pull (hRows)
            (hR hRows) reach these (hR) "WAIT_INIT" "rates" bank (hR)
            (hR) ontop (r) "WAITING" RATE \ new rate at resumed r(1st)

         ELSE 
            (hPtrs) drop

          \ Down to the 1st level of the wait stack in WAIT_INIT.

          \ Remove periodic WAITING task and purge WAIT_INIT arrays:
            "WAITING" OMIT
            "WAIT_INIT" "Purged_Arrays" localrun 

         THEN

         no "timeout" book 

{        This ends the wait state for Word, and then returns.  The next
         wait state in the "Array" stack will resume (at the resumed
         rate set above), so all waiting may not be over.

         All waiting is over when the initial wait state resumes and
         ends, and the ELSE branch above has been taken.
}
         WAIT_END

{        Running the phrase above causes the program to longjmp to where
         WAIT_BEGIN was originally run, and this region will not be 
         reached.
}
      ELSE \ check for timeout:
         time "WAIT_INIT" "start" yank ontop less \ minus start time
         "WAIT_INIT" "sec" yank ontop (t2 t1) >   \ above nSec max wait?
         IF 
            yes "timeout" book 
            WAITING \ re-enter to end wait for Word

         THEN
      THEN
   end

   inline: who ( --- ) \ display names of cataloged items in main lib
\     Display a sorted list of cataloged stack item names that are in 
\     the main library.
      [ 72 "width" book "" "TMP" book ]

    \ Running the local inline WHOS of word whos, but capturing on
    \ TMP file the text it would normally write to the display:
      ftempsys "TMP" book
      SYSOUT push TMP set_sysout
      "whos" "WHOS" localrun TMP asciiload TMP delete
      chop noblanklines (hT)

      (hT) any?
      IF \ getting names from 1st column and sorting them:
         (hT) 1st word drop

         this lowercase eight blpad spaced swap park
         yes sort 2nd word drop

         (hT) "whos" "SEPout" localrun
         vol2str \ into horizontal form

         (qS) width ".out" >stk left justify (qS)

      ELSE "whos" "noitems" yank (qS)
      THEN 
      pull set_sysout
      TMP deleteif \ sometimes the above delete does not work
      (qS) one indent dot nl
   end

   inline: whocat ( --- hT) \ wholib listings for all words in catalog
\     Listing of the contents in libraries of all inlines and defines.
      "whos" >stk "T" book
      T "inline" grepr
      T "define" grepr pile any?
      IF T swap reach 1st word drop alphabetize push
         purged "T" book 
         peek rows 1st DO peek I quote dup . nl "wholib" >stk LOOP
         pull rows pilen (hT)
      ELSE no no blockofblanks (hT)
         purged "T" book
      THEN (hT) "_whocat" naming
   end

   inline: wholib (qW --- ) \ show table of cataloged stack items in W
{     Display names, sizes, bytes and types of cataloged stack items
      that are in the library of word W.
      Banking W for LIB in word whos, and running whos.
}
      no STR stkok not IF "wholib" stknot return THEN

      strchop any? not IF whos return THEN \ main lib if empty string

      (qW) this ctype push
      peek DEFN = 
      peek INLI = or
      pull NATI = or not
      IF " wholib: " swap cat " is not a word" cat ersys return THEN

      "whos" "LIB" yank (qLIB) push          \ save whos LIB

      (qW) tagsep swap cat "whos" "LIB" bank \ the LIB to do
      yes "whos" "from_wholib" bank          \ whos will be expecting us
      whos                                   \ whos for lib of S

      pull (qLIB) "whos" "LIB" bank          \ reinstate whos LIB
   end

   inline: whos ( --- ) \ show table of main library cataloged items
{     Display names, sizes, bytes and types of cataloged stack items
      and local inlines that are in the library of LIB.

      LIB is initially the main library tag.  But word wholib uses this 
      word to display the local library of a word.  To do this, wholib 
      banks the library tag for its word into LIB.

      Studying this word in detail, line by line, will reveal many 
      things about this program, including how items in the catalog
      are kept.
}
\-------------------- begin whos bracket region ------------------------

\   Initial values and local inlines for word whos are defined here.
    [ 
      tagmain "LIB" book \ main library; word wholib banks its LIB here
      no "from_wholib" book

      {" noitems ( --- qMsg) \ a local inline with msg when no lib items
         INFIX
         IF LIB tagmain =
            IF "No variables or functions " 
               "have been added to main library" cat
            ELSE "No variables or functions in the library of word "
               LIB strchop tagsep strlen negate indent cat
            THEN
         ELSE LIB tagmain =
            IF "No stack items or words have been added to main library"
            ELSE "No stack items or words in the library of word "
               LIB strchop tagsep strlen negate indent cat
            THEN
         THEN
      "} "noitems" inlinex

    \ Local inline to remove lib tag if not doing main
      "LIB tagmain = not IF notag THEN" "NOTAG" inlinex

    \ Temporarily replaces blanks in quoted names:
      "" "SEP" book \ Tue Mar 29 16:43:03 PDT 2011: char 191  is rare
    \ "|" "SEP" book \ Discontinued.  Causes error when | is in a word

      {" SEPin (hT --- hT1) \ replace blanks with SEP symbol
       \ WARNING: this word changes T in place; original is booked into
       \ Names_orig.

       \ Blanks in T are replaced by a separation byte, SEP, so a string
       \ with blanks does not appear as blank-delimited strings:

         no no blockofblanks (hNames_orig) push
         these rows 1st
         DO (hT) this I quote (qS)
            pull that pile push (qS) \ copy of original, including tag
            NOTAG strchop " " SEP replace$ (qS) 
            (hT qS) that I said
         LOOP (hT)
         pull "Names_orig" book
      "} "SEPin" inlinex

      {" SEPout (hT --- hT1) \ back to original strings without SEP byte
         (hT) Names_orig any?
         IF rows 1st
            DO (hT) Names_orig I quote NOTAG strchop (qOrig) dup
               (qRep) " " SEP replace$ (qRep)
               swap (hT qRep qOrig) replace$
            LOOP
 
          \ Tue Mar 29 17:27:43 PDT 2011.  Extra insurance to catch 
          \ all .  Needed when run "DATA__" "wholib" >stk eview to 
          \ clean up string "'C1'BRIDGEACK"
            (hT) "" " " strp (hT)
         THEN
      "} "SEPout" inlinex

      {" WHOS ( --- ) \ This local inline writes to the display
      {
      In the loops below, for cataloged stack items (items in DATA__,
      which are ctypes STRI, VOLU, VARI, and MATR) word quote puts the 
      name of the cataloged stack item on the stack, and then phrase 
      "ptr exe" consumes the name and puts the actual handle of the 
      stack item on the stack, so its properties can be obtained.  

      If name is for a define or an inline (items in CODE__, of ctype 
      DEFN and INLI), word libpry is used to obtain the VOLU or PTR 
      containing its code (for these types, "ptr exe" will cause them 
      to fire, while libpry simply puts their VOLU or PTR on the stack).

      To study the phrases of this local inline, WHOS, place word halt 
      at a desired location within this bracket region after the program
      is running interactively.  Then run this modified region using the
      phrase:
         "sys.v" "TEST" msource
      Until halt is reached, the words following TEST will run.

      TEST 

    \ Uncomment one of these or add another for TEST:
        \"NISTdelta" \ use this to process the library of NISTdelta
        \"whos" 
        \"HTTPget" 
         "*" \ doing main

         tagsep swap cat "LIB" book 

       \ These substitutes are needed for running TEST:
         tagmain "LIB" book
         "" "SEP" book
         "dup notag 'Names_orig' book" "SEPin" inlinex
         no "from_wholib" book
    \ }
    \ Fetching library item names and types:
      from_wholib not (f1) LIB tagmain = (f1 f2) and \ doing main?
      IF ".e" "newitems" localrun \ text that .e would display
         ".d" "newdefs" localrun  \ text that .d would display
         pile "T" book

       \ Showing words in the main library.  Words in the main 
       \ library have tags DATA__ (cataloged stack items) or 
       \ CODE__ (defines or inlines).

         T dup "DATA__" grepr any?
         IF reach ELSE drop "" THEN 

         T dup "CODE__" grepr any?
         IF reach ELSE drop "" THEN 

         pile (hT) chop noblanklines (hT) \ must keep main tag**
{
         ** A local T in whos will incorrectly appear instead of a 
            T in main if the main tag is removed.  This means not 
            to use notag in the phrase above, as in:
               pile (hT) notag chop noblanklines (hT)

            Phrase "ptr exe" used below needs the main tag to grab
            the main word (the purpose of this branch) when there 
            is a local one in this function, whos, of the same name.
}
      ELSE catitems \ doing a word for wholib; bring in everything

       \ Extract just the names and catalog types for tagsep LIB:
         spaced this (hT hT)
         LIB spaced (qS)
         (hT hT qS) grepr reach (hT)

      THEN (hT) noq_alike any? not
      IF return THEN (hT)

      (hT) chop "T" book  \ cataloged names and types into T

    \ After whos has run, the current T can be displayed by: 
    \    "whos" "T" yank dot

 \ 1. Showing cataloged stack items listed in T (catalog types STRI, 
 \    VOLU, VARI, and MATR).
      no "STK?" book \ a flag for later

    \ Processing T for catalog item type STRI.  Catalog type STRI holds
    \ a stack item type STR:
      T its 2nd word drop "STRI" grepr reach (hT)
      "STRI" tug -5 indent any? (hNames f)
      IF yes "STK?" book 
         (hNames) SEPin (hNames) \ names with SEP on stack
         these rows 1st
         DO (hNames) this I quote (qSTR) notag (qS)

          \ A short string name is the string itself, quoted; the
          \ quotes add 2 bytes:
            this 1st character "'" =
            that 1st character '"' = or
            IF two ELSE zero THEN (+size)

            (qS +size) swap (qS) dot

            that I quote SEP chblank ptr exe (qS)

            (qS) these rows .i these cols .i
            (qS) sizeof (+size size) + (size) this .i

            " STR string" dot
            (size) 0= IF "(empty)" dot THEN

            nl
         LOOP (hNames1) drop
      THEN

    \ Processing T for catalog item type VOLU.  Catalog type VOLU holds
    \ a stack item type VOL:
      T its 2nd word drop "VOLU" grepr reach (hT)
      "VOLU" tug -5 indent any? (hNames f)
      IF yes "STK?" book these rows 1st
         DO (hNames) this I quote (qVOL) this notag dot (qVOL) 
            (qVOL) ptr exe (hVOL)
            (hVOL) these rows .i these cols .i 
            this sizeof this (N) push .i
            " VOL " dot 

            (hVOL) this tag? any?
            IF (qS) strchop " " ":" replace$ (qS)

               (hVOL qTag) swap (hVOL)
               (hVOL) dims star 0= IF (qS) "(purged)" cat THEN

            ELSE drop " volume"
            THEN (qS)

            pull (N) 0= IF (qS) "(empty)" cat THEN

            (qS) dot nl
         LOOP (hNames) drop
      THEN

    \ Processing T for catalog item type VARI.  Catalog type VARI holds
    \ a stack item type NUM:
      T its 2nd word drop "VARI" grepr reach (hT)
      "VARI" tug -5 indent any? (hNames f)
      IF 
         ".sf" "GFORM" yank push
         "%0.4G" ".sf" "GFORM" bank \ display fewer digits

         yes "STK?" book these rows 1st

         DO (hNames) this I quote (qSTR) this notag dot (qSTR)
            zero .i zero .i \ NUMs have 0 rows and 0 cols

            (qSTR) ptr exe (n)
            (n) this is_complex IF 16 ELSE eight THEN .i

            " NUM" dot
            (n)

          \ Using stack display word .number inside of word .sf to
          \ display n:
            (n) cop \ copy so no tok name (but NUM ptr keeps tok name) 

            ".sf" ".number" "localrun" >stk 

            chpack \ no spaces so neat won't spread complex out
            sp dot nl
         LOOP (hNames) drop

         pull ".sf" "GFORM" bank
      THEN

    \ Processing T for catalog item type MATR.  Catalog type MATR holds
    \ a stack item type MAT:
      T its 2nd word drop "MATR" grepr reach (hT)
      "MATR" tug -5 indent any? (hNames f)
      IF yes "STK?" book these rows 1st
         DO (hNames) this I quote (qMAT) this notag dot (qMAT) 
            (qMAT) ptr exe (hMAT)
            (hMAT) these rows .i these cols .i 
            this sizeof .i
            " MAT " dot 

            (hMAT) this tag? strchop " " ":" replace$ (qS)

            (hMat qS) swap (hMAT)
            (hMAT) dims star 0= IF (qS) "(purged)" cat THEN

            (qS) dot nl
         LOOP (hNames) drop
      THEN

 \ 2. Showing words listed in T (catalog types DEFN and INLI).
      no "WORD?" book \ a flag for later

    \ Processing T for catalog item type DEFN.  Catalog type DEFN, a 
    \ "define," holds a stack item type VOL containing the text that
    \ is interpreted when the word runs:
      T its 2nd word drop "DEFN" grepr reach (hT)
      "DEFN" tug -5 indent any? (hNames f)
      IF yes "WORD?" book these rows 1st
         DO (hNames) this I quote (qSTR) this notag dot

            (qSTR) libpry (hVOL)
            these dims * 0= IF notag libpry THEN

            (hVOL) these rows .i these cols .i sizeof .i
            " VOL define" dot nl
         LOOP (hNames) drop
      THEN

    \ Processing T for catalog item type INLI.  Catalog type INLI, an
    \ "inline," holds a stack item type PTR containing 32-bit addresses
    \ that are executed when the word runs:
      T its 2nd word drop "INLI" grepr reach (hT)
      "INLI" tug -5 indent any? (hNames f)
      IF yes "WORD?" book these rows 1st
         DO (hNames) this I quote (qPTR) this notag dot (qPTR)

            (qPTR) libpry (hPTR)
            these dims * 0= IF notag libpry THEN

            (hPTR) these rows .i these cols .i sizeof .i
            " PTR inline" dot nl
         LOOP (hNames) drop
      THEN

      return \ halt equivalent, placed here only to stop TEST running

      "} "WHOS" inlinex

    \ The order for grouping by type:
         "PTR STR VOL NUM MAT" words "ITEM" book

    \ Initial setting is to group by type:  
         yes "byTYPE" book

    \ To not group by type, and instead group by name, run the phrase: 
    \    no "whos" "byTYPE" bank

    ]
\---------------------- end whos bracket region ------------------------

    \ Running the local inline WHOS, but capturing on TMP file
    \ the text it would normally write to the display:
      [ "" "TMP" book ]
      ftempsys "TMP" book
      SYSOUT push TMP set_sysout
      WHOS
      pull set_sysout TMP asciiload TMP delete
      chop noblanklines (hT)

      (hT) any?
      IF \ doing more formatting of T on stack.

         LIB tagmain =

         IF (hT) LIB its chars spaces replace$ THEN

       \ Sort the rows according to the names in 1st column (sort uses
       \ only the first eight characters):
         (hT) this 1st word drop lowercase 
 
\        right justify spaced \ sorted number strings look better
\        eight blpad spaced   \ force width of at least eight chars
 
         spaced these rows columnofints park
         yes sort
         2nd word drop (hV) numerate (hRows) ndx reach (hT)

         (hT) byTYPE
         IF { Sort by item type in 5th column according to list ITEM.
              SEP byte is essential here to correctly obtain the fifth
              substring, TYP.  

              Example: for the case with SEP, , word string will cor-
              rectly pick the fifth substring as "STR."  For the other 
              case, it will not (it will pick the 0 under Rows):
                 Name        Rows Cols Bytes Typ   Descr
                 "001NUM" 0    0    2     STR   string
                 "0 0 1 NUM" 0    0    2     STR   string
            }
            (hT) this five ndx string drop (hC5)
            (hC5) spaced these rows columnofints park "TYP" book
            depth push
            ITEM rows 1st
            DO TYP this ITEM I quote grepr any?
               IF reach 2nd word drop (hTrow) 
               ELSE drop 
               THEN
            LOOP 
            depth pull less pilen (hTrow) numerate (hRow)
            (hT hRow) ndx reach
         THEN (hT)

       \ Total the bytes in the fourth column:
         (hT) this 4th word drop numerate totals ontop "TOT" book

       \ Note that bytes TOT will be in error (too high) when different 
       \ items share the same memory pointer, as in: 
       \    100 100 random "A" book, A "B" book

       \ Add a total bytes line to the fourth column:
         NLch spaced three cats \ non-char place holder for cols 1-3
         TOT int$               \ bytes total is 4th
         " total" cat cat pile (hT)

       \ Add column headings:
         "Name Rows Cols Bytes Type Description" swap pile (hT)

       \ Align things: 
         neat (hT) \ SEP byte to fill blanks in names is needed here

         (hT) SEPout (hT) \ finally, remove the SEP byte

       \ Add a title :
         WORD?
         IF STK? 
            IF INFIX
               IF "Variables and functions"
               ELSE "Stack items and words" 
               THEN
            ELSE INFIX IF "Functions" ELSE "Words" THEN
            THEN
         ELSE INFIX IF "Variables" ELSE "Stack items" THEN
         THEN (qS)

         LIB tagmain =
         IF " added to the main library:" 
         ELSE " in the library of word " 
            LIB tagsep chars negate indent (qWord) cat 
            ":" cat (qS)
         THEN cat (qS)
         (hT qS) swap one indent pile (hT)
 
      ELSE noitems (hT) 
      THEN
      (hT) one indent dot nl
      no "from_wholib" book
   end

   inline: whoseq ( --- ) \ main library items displayed in sequence 
\     Display the list of names in the sequence they were placed into 
\     the main library, last items last.

      [ "" "TMP" book ]
      ftempsys "TMP" book
      SYSOUT push TMP set_sysout
      "whos" "WHOS" localrun TMP asciiload TMP delete
      chop noblanklines (hT)

      (hT) any?
      IF \ getting names from 1st column: 
         (hT) 1st word drop
         this catseq hand 1st those rows items park yes sort
         2nd catch reach

         (hT) "whos" "SEPout" localrun
         vol2str \ into horizontal form

         (qS) "who" "width" yank ".out" >stk left justify (qS)

      ELSE "whos" "noitems" yank (qS)
      THEN 
      pull set_sysout
      TMP deleteif \ sometimes the above delete does not work
      (qS) one indent dot nl
   end
{
   Demos for words who, wholib, whos, and whoseq.

   These can be run with the phrase: 
      "sys.v" "whos demo" msource

      whos demo
         98 is n1
         99 is n2
         10 12 random "Arand" book
         5 500 trandom "Vrand" book
         1774 219 random mat2vol "PV" book
         0 0 blockofblanks "PV1" book
         0 1 blockofblanks "PV2" book
         123 47 random dup complex "B" book
         141 51 random sparse dup complex "Cmat" book
         pi 3 / 1E6 * speye "Ibig" book
         9 0 random dup complex sparse "Kp" book
         "this is a string" "str1" book
         "this string is longer than 16 bytes" "str2" book
         "" "str3" book
         1 0 random "bp" book

         "MOD1" missing IF
         inline: MOD1
            [ 100 3 random "GRIDS" book
              600 600 random sparse "Kgg" book
              Kgg "Mgg" book
            ]
            "model_1"
            "a short str"  
            "this string is longer than 16 bytes" 
          end THEN

         "MOD1" ptr "ADDR" book

         "Demo running whos:" nl . nl whos
         "Demo running who:" nl . nl who
         "Demo running whoseq:" nl . nl whoseq
         "Demo running wholib for word MOD1:" nl .  nl 
            "MOD1" wholib

       \ Free the memory of big items in this demo:
         purged sparse "Cmat" book
         purged sparse "Ibig" book
         purged "Vrand" book
         purged "Arand" book
         purged "B" book
         purged "PV" book

         purged "MOD1" "GRIDS" bank
         purged "MOD1" "Kgg" bank
         purged "MOD1" "Mgg" bank
      halt
}

   define: ww ( --- ) "work.v" source end \ sourcing work.v

\-----------------------------------------------------------------------

\  Words that use the multitasker.

   inline: ALARMR (d qW --- ) \ randomized alarm
\     Set ALARM to run W some time in the next d seconds
      (d qW) systime$ rot (qHH d) time_randomize todayat (qW d)
      swap ALARM
   end

   inline: everyhour (qWord --- ) \ make a word to do a task hourly
{     Makes a word called Word with the following stack diagram:

         Word (ptrTask MM --- )

      When Word is fired, Task will be performed at MM minutes after 
      every hour, starting at MM minutes past the present hour if it 
      has not past.

      Example:

         Creating an hourly word called beeper:
            "beeper" everyhour

         Creating a task for beeper:
            inline: 3beep ( --- ) 3 1st DO beep .25 idle LOOP ;

         Starting word beeper to run task 3beep at ten minutes past 
         every hour:
            "3beep" ptr 10 (ptrTask MM) beeper

         Checking tasks, including beeper; note that beeper is shown as
         an alarm; it will go off at 10 minutes past the next hour:
            [tops@clacker] ready > tasks
             Multitasker tasks:
              dogger task running at 1 Hz; tics remaining 4
              beeper alarm period 2557 seconds; remaining 2553

         On the fly, changing beeper to run at 20 minutes past:
            no "beeper" "set" bank \ required to reprocess ptrTask, MM
            "3beep" ptr 20 (ptrTask MM) beeper

            [tops@clacker] ready > tasks
}
      [ \ This is the text for Word to be created:

        {" Word (ptrTask MM --- ) or ( --- )

         [ defname is myName, "%02.0f:%02.0f:00" is FORM
           no is set, no is ptrTask, no is MM, list: 4 5 ; is MMcols
         ]
         set not
         IF true one NUM stkok and, two NUM stkok and not
            IF myName stknot return THEN

            (ptrTask MM) "MM" book, "ptrTask" book

            SYSOUT (S) 
            ftempsys (qFile)        \ temp file from system
            (qFile) dup set_sysout  \ output to temp file

            systime$ ":" chblank 1st word drop numerate (HH)
            (HH) MM park FORM format this todayat

            any not IF drop nexthour (HH) MM park FORM format THEN

            (HH:MM:00) todayat myName ALARM
            yes is set

            (S qFile) delete \ delete temp file
            (S) set_sysout \ reset SYSOUT

            return
         THEN
 
{        Set the time for the next hour first, in case we never return 
         here after doing Task.  

         The following runs this word again, but for set=no to set 
         ALARM above, then returns down here following word main:
}
         no is set, ptrTask MM myName main \ set to run again next hour

{        Setting the next time to run before running Task means that
         Task can OMIT running next time (and all future times) if
         its logic dictates (see man everyhour).
}
         ptrTask its ptr?
         IF exe \ do the Task
         ELSE drop
         THEN

        "} into Ftext

      ] 
      (qWord) "Word" book

      CATMSG (f) no catmsg
      Ftext Word inlinex \ making Word
      (f) catmsg
   end

\  A constantly running coin flipper: do not awaken FLIP if repeatable
\  random seeds are required.
   inline: FLIP ( --- ) \ internal random coin flip
      urn 0.5 > "tap" book ; FLIP (run once to initialize tap)
{
   Warning: In random studies where seed is controlled and results 
   must be repeatable, turn FLIP off if it is present: "FLIP" SLEEP 

   The default is to NOT turn FLIP on.  The following will start it
   later:

      3 (Hz) "FLIP" PLAY \ flipping coin
}
   inline: PLAY (r hT --- ) \ start words named in T at rate r
{     Play the words in T at rate r times per second (Hz).

      Each row in T contains the name of a word to play.  T can also
      be a string of space-delimited words.

      The stack diagram for a word that plays is usually ( --- ).

      On exit from this word, all words in T are being played at
      rate r (Hz) under the mulitasker.
}
      hand (hT) words any?
      IF these rows 1st
         DO again I quote, them that TASK WAKE LOOP (hT) drop
      THEN (r) drop
   end

   inline: tap ( --- -1 or 0) \ latest flip, true or false
\     Warning: tap changes slowly, at the rate of FLIP (about 3 Hz)
      "FLIP" "tap" extract ; \ grab value from FLIP's local library

\-----------------------------------------------------------------------
{
   Common commands to work with Unix.

   Commands to a Unix function are text strings parsed after the func-
   tion is running, when the function figures out what to do.

   Words, the functions in this program, do not use parsing to control 
   their action.

   Instead, things are flipped around.  Text patterns coming in are 
   matched with patterns in the catalog to control the placing of items
   on the stack and the firing of words.  

   Words work by what is carried on the stack before they are fired 
   (the ready-aim-fire rule), so the stack must be ready ahead of time.

   All this means that trying to mimic Unix commands takes some addi-
   tional work, and word done is used to help.  Unfortunately, word 
   done causes problems with inlines.

   Word done intercedes in the typing stream and stops further pat-
   terns from being acted upon by the program since they are proces-
   sed by Unix.  But inline operation adds another run level that 
   causes word done to be ineffective; use define: to make words that 
   use the word done and do not turn them into inlines.

   For example, this program's word grep turned into an inline will 
   falter on the strings and file name that follow the Unix grep com-
   mand (as one can verify by changing grep's define: to inline:). 

   There are usually ways to work around this problem.  For example,
   time consuming phrases in word rm that do not involve done are made 
   into a local inlinex, so the heart of word rm is an inline.
}
{  inline: noNL ( --- ) \ limit a NL in word console
\     One less NL in word console when run Unix command.
      keys? 
      IF out 0= IF no "console" "NLopt" bank THEN THEN ;
}
   inline: noNL ( --- ) \ limit a NL in word console
      noop ; \ deactivate for now; get non-display char in RH5.2

   inline: shellunix ( --- qS) \ shell command for Unix
\     Used below in interactive words that mimic Unix commands.
      [ "noNL do typing name tug dent indent cat minshell" 
        makes quote 
      ] quote ;

\  Words:
   inline: catf (qF1 qF2 --- qF) \ concatenate F1 and F2 to temp file F
\     Note: ties up file scratch1
      [ scratch1 makes F, " > " scratch1 cat makes toF ] 
      SBIN "cat " cat rot spaced rot cat cat toF cat minshell F
   end

   define: cd ( --- ) \ mimic Unix cd command: cd dirname
\     Using word chdir (qS --- ).
      [ defname dup is name, chars negate is dent ]
      noNL depth push

      typing name tug dent indent 
      chdir

    \ Keeping stack uniform in case chdir had error and left qS:
      depth pull less dump done ;

   define: cp ( --- ) \ Unix cp command: cp fromfile tofile
\     This version preserves the date.
      [ SBIN "cp -p " cat is do 
        defname dup is name, chars negate is dent 
      ] shellunix local done ;

   inline: ctar (hNames qDir qFile --- ) \ Names of files to tar File
{     Create a Unix tar File archive of the files with Names that are 
      in Dir.  File includes its directory path.

      Sun Dec  4 12:51:18 PST 2011.  Run words(Names) to make a list
      in case incoming Names is a string of names.

      Wed Apr  6 09:24:15 PDT 2011.  Add a step that verifies the file
      Names exist.

      Example: Below is the Unix tar SCRIPT file made and run by the
      following phrase: pwd dirfiles drop pwd '/tmp/mydir.tgz' ctar
         /bin/tar -zcvf /tmp/mydir.tgz \
         band.txt                      \
         model.ps                      \
         mail.sav                      \
         benchmark.txt                 \
         accept.txt                    \
         XHOST_START                   \
         makelinks                     \
         user.txt
}
      [ "HOME" env runid catpath "ctar_script" + "SCRIPT" book ]

      "File" book
      "Dir" book

      (hNames) strings \ if single string, get list of strings

      (hNames) -path noblanklines chop any?
      IF "Names" book
         pwd push
         Dir chdir

       \ Verify files exist:
         Names dup file? rake swap (hNames hNot) any?
         IF (hNot) " ctar: the following files were not found"  
            " in directory " + Dir + . nl
            (hNot) 3 indent . nl
         THEN (hNames) any? 
         IF "Names" book
          \ Make a script for the Unix tar command:
            "/bin/tar -zcvf " File + Names pile spaced (hT)

          \ Append backslash + newline to each row (except the last):
            (hT) "5C 0A" hexbytes over rows 1- pileof " " pile park (hT)

          \ This keeps things clean when networked:
            (hT) SCRIPT save            \ save Unix script
            SCRIPT 448 chmod            \ give execute permission
            SCRIPT ">/dev/null" + shell \ run script
            SCRIPT delete               \ delete script
         ELSE 
            " ctar: no files found, no archive created" . nl 
         THEN
         pull chdir
      ELSE
         " ctar: list of file names is empty, no archive created" . nl 
      THEN
   end

   define: diff ( --- ) \ Unix diff command: diff file1 file2
      [ "diff " is do 
        defname dup is name, chars negate is dent 
      ] shellunix local done ;

   inline: diff1 (qFile1 qFile2 --- hT) \ difference between files
{     Version of diff for automation: gets input from stack, not typing
      stream.  Versions for automation do not require words "typing"
      and "done" (these are used in the version of diff above) and can
      run without a human being present.

      Returned T has no chars if no difference; otherwise it contains
      the text of display from Unix diff showing line differences.

      Two switches are used in the diff command below (see the Unix 
      man page for diff):

         The -e switch makes a file in ed editor format, for use by 
         Unix function patch.

         The -b switch ignores trailing white space.

      Example use in phrase to make backup if file changes:
         Processing next pair of file names from list of files to be
         backed up:
            "work/file.c" "back/file.c" 2dup diff1 (hT) chars any
            IF (qFile1 qFile2) fcopy ELSE 2drop THEN

}     one indent "diff -eb " rev cat cat, " > "
      scratch cat cat minshell
      scratch asciiload scratch delete notrailing end

   inline: finger ( --- hT) \ Unix finger command
      "Host: " host cat
      "finger >" scratch cat shell
      scratch asciiload scratch deleteif
      pile chop
      "_finger" naming
   end

   define: grep ( --- ) \ Unix grep command
      "grep" typing over tug four tic erase cat
      " > " scratch cat cat SBIN swap cat minshell
      scratch asciiload scratch delete notrailing dot done end

   inline: grep1 (hT qS --- hT1) \ grep S in volume T with Unix grep
\     Version for automation: gets input from stack, not typing stream.
\     If text is too big for dot to display, eview can be used
      bob scratch1 save
      SBIN "grep -i " cat bob cat spaced scratch1 cat
      " > " scratch cat cat minshell, scratch file?
      IF scratch asciiload notrailing ELSE 1 0 blockofblanks THEN 
   end

   inline: grep2 (qF qS --- hT1) \ grep S in file F
\     Example:
\        syspath "*.v" cat "dup" grep2 eview
      SBIN "grep -i " cat swap quoted cat spaced bob cat
      " > " scratch cat cat minshell, scratch file?
      IF scratch asciiload notrailing ELSE one zero blockofblanks THEN
   end

   "gvim" filesearch
   IF (qGVIM) push
   define: gvim ( --- ) \ gvim command in the form: gvim filename
      [ pull into do defname dup is name, chars negate is dent ] 
      do typing, name tug, dent indent, cat shell done ;
   ELSE
   define: gvim ( --- ) " not available" . nl ;
   THEN

   inline: killmy (nPID --- ) \ kill my job PID
      hand @ no NUM stkok not
      IF " killmy: need PID number on stack" ersys return THEN

      dup 0< "silent" book
      abs (PID) intstr "PID" book

      pidtable (hT) this 1st word drop getlogin grepr "R" book
      R rows any
      IF (hT) R reach 2nd word drop PID grepe rows 0>
         IF \ found jobid and it is one of mine:
            " killmy: killing pid " PID + spaced date + . nl
            "kill -9 " PID + " &" + shell
         ELSE 
            silent not
            IF " killmy: PID " PID + " not found " + date + . nl THEN
         THEN
      ELSE 
         (hT) drop
         silent not IF " killmy: no jobs " date + . nl THEN
      THEN
   end

   inline: killjob (qS --- ) \ kill job in ps table having string S
      no STR stkok not
      IF " killjob: need string on stack" return THEN

      "S" book
      S chars any
      IF pidtable (hT) dup S (hT qS) grepr (hR) any?
         IF (hT hR) reach 1st quote 2nd word drop (qPID)
            (qPID) number drop (nPID) killmy
         ELSE (hT) drop
         THEN
      THEN
   end
{
   During bracket mode in word ll, shellunix is made into an inline,
   called job, for more speed.  

   In contrast, word llr that follows just puts string shellunix on 
   the stack then runs the string's words using word local (so local 
   library items do, name, and dent are used).
}
   define: ll ( --- ) \ Unix subdirectory long list
      [ SBIN "ls -alFo >" scratch cat cat is do 
        defname dup is name, chars negate is dent 
        shellunix "job" inlinex
        "scratch asciiload notrailing any? "
        "IF dot THEN scratch deleteif" +
        "display" inlinex
      ] 
      job display done ;

   define: llr ( --- ) \ long list, reversed time order
      [ SBIN "ls -alFort >" scratch cat cat is do 
        defname dup is name, chars negate is dent
        "scratch asciiload notrailing any? "
        "IF dot THEN scratch deleteif" +
        "display" inlinex
      ] shellunix local display done ;

   define: ls ( --- ) \ Unix ls (sort of)
\     Using neat1 to display rows in alphabetical order.
\     Unix ls shows columns in alphabetical order.
      [ SBIN "ls -F >" scratch cat cat is do
        defname dup is name, chars negate is dent
        "scratch asciiload COLS neat1 any? "
        "IF dot THEN scratch deleteif" +
        "display" inlinex
      ] shellunix local display done ;

   inline: ltar (qFile --- hT) \ list files from tar File archive
\     List a tar File archive; File includes its directory path.
      [ "HOME" env runid catpath "ltar.tmp"    + "TMP"    book ]
      [ "HOME" env runid catpath "ltar_script" + "SCRIPT" book ]

      "/bin/tar -ztvf " swap + " > " + TMP + (hT)

    \ This keeps things clean when networked:
      (hT) SCRIPT save            \ save Unix script
      SCRIPT 448 chmod            \ give execute permission
      SCRIPT ">/dev/null" + shell \ run script
      SCRIPT delete               \ delete script

      TMP asciiload 
      "_ltar" naming
      TMP delete
   end

   define: man ( --- ) \ showing stack notation of word
\     Same as words help or where, but used in form: man Word
\     where Word follows and is not enclosed in quotes.
      
      "where" missing 
      IF " man: require word where" ersys done return THEN

      typing
      hide
      "man" tug, 2nd string
      IF wherem
      ELSE INFIX IF where return THEN
         " used in the form: man xxx" . nl " where xxx is a word;" .
         ' equivalent to "xxx" where' .
        (mano)
      THEN
      done nohide ;

   inline: _more (qFile --- ) \ Unix more command, ready-aim-fire style
{     Choose one of these for word more: the classic Unix more, or Unix 
      less, created to work like more but allowing movement backward 
      as well as forward; less works better, but it is not in SBIN 
      with the common Unix functions, and it may not even be on your
      system.  If less is not found, more will be forced.
}
      [ defname this is name, chars negate is dent 

      \ Choosing more or less (function less is not on all systems):
        SBIN "more -d " cat into moredo 
        "less" filesearch not 
        IF moredo THEN spaced into lessdo

\       Pick moredo or lessdo and comment-out the other:
#          moredo
           lessdo 
        is do
{
      Later, run this to see what you have:
         [tops@clacker] ready > '_more' 'do' yank .
         /usr/bin/less
         [tops@clacker] ready > 

      And you can always change it on the fly:
         [tops@clacker] ready > "_more" "moredo" yank, "_more" "do" bank

      Notes on using minshell instead of shell in the code below:
         more does not highlight its command line at the bottom of
         the window

         less displays this: 
           WARNING: terminal is not fully functional
           /opt/tops/tops/sys/dog.v  (press RETURN)
}
      ]
      0 STR stkok, not IF "_more" stknot return THEN noNL
      filefound 
      IF do swap cat shell \ see notes above concerning minshell
      ELSE " more: file not found" ersys return 
      THEN
   end

   inline: .more (qFile --- ) \ display File in more if too many lines
\     Wed Mar 18 12:16:35 PDT 2009
\     Adapted from wherem, key.v.

\     Use Unix more (or less if present) to display File that allows 
\     backward and forward movement in a text-only environment, usually 
\     with keys like u (up) and d (down).

      remotefd -1 > IF where return THEN

      (qS) filefound (0 or qS -1) not
      IF " .more: file not found" . nl return THEN (qS)

      (qS) asciiload (hT) any?
      IF (hT) dup rows LINES >
         IF (hT) "/tmp/" runid + ftemp dup "FNAME" book 
            (hT qFNAME) save
            "_more" "do" yank spaced (qScript) FNAME + (qS) shell
            FNAME deleteif
         ELSE (hT) any? IF . THEN
         THEN
      ELSE " .more: error loading file" . nl
      THEN
   end

   define: more ( --- ) \ the more command, fire-ready-aim version
      typing "more" tug -4 indent _more done ;

   inline: netstat ( --- hT) \ Unix netstat -a command
      "Host: " host +
      "netstat -anp >" scratch + nullshell
      scratch asciiload scratch deleteif
      pile chop
      "_netstat" naming
   end

   inline: netstat1 ( --- ) \ show Unix netstat
\     This word can be run in the multitasker to periodically display.
\     Example to show every 5 seconds: 1 5 / "netstat1" PLAY
      nl date . nl
      "netstat -anp > " scratch + shell \ use -n to save host lookup
      scratch asciiload scratch delete
      dup 1st 3 items catch "tcp" grepr reach neat . nl
   end

   define: noM ( --- ) \ perl command to remove DOS ctrl-M
{     Usage: noM <dos text file(s)>

      Equivalent to the following two-line Unix script file:
         #!/usr/local/bin/perl -pi
         s/\cM$//; # strip Ctrl-M from end of line
}
      [ perl$ " -pi -e 's/\cM$//' " cat makes noM (from Al Danial) ]
      typing "noM" tug -4 indent (qFiles) this 1st word lop
      IF noM swap cat minshell THEN done ;

   define: noTB ( --- ) \ perl command to trim file's trailing blanks
{     Usage: noTB <file(s)>

      Equivalent to the following two-line Unix script file:
         #!/bin/sh
         perl -pi -e 's/ * $//' $1
}
      [ perl$ " -pi -e 's/ * $//' " cat makes noTB ]
      typing "noTB" tug -5 indent (qFiles) this 1st word lop
      IF noTB swap cat minshell THEN done ;

   inline: ns ( --- ) netstat1 ; \ show Unix netstat

   inline: pidtable ( --- hT) \ table of process ids and commands
      [ os "linux" =
        IF SBIN "ps -Af --cols 512 >"
        ELSE SBIN "ps -Af >" 
        THEN + "PS" book
      ] PS scratch + minshell
      scratch asciiload scratch delete notrailing
      "_pidtable" naming
   end

   inline: remtab (hT --- hT1) \ from string or volume, remove tabs
\     Note: ties up scratch1, and remtabf ties up scratch
      scratch1 save, scratch1 remtabf asciiload noscratch ;

   inline: remtabf (qS --- qS1) \ S1 is file S with tabs removed
\     Note: ties up scratch; note: expand is in /usr/bin.
      "expand " swap cat " > " cat scratch, cat minshell scratch ;

   define: rm ( --- ) \ remove files with wildcards; interactive only
{     Usage: rm *.out 

      Uses Unix command ls to obtain list of files, then runs query 
      on list.  Query will fail for file names that have trailing 
      blanks. 

      Since done cannot be used in an inline, the central portion of 
      this word, not containing word done, is made into an inlinex
      within brackets when the word is created.

}     [ "y" 1st byte says YES, "q" 1st byte says QUIT 
      {"
      1st push 0based
      SBIN "ls " cat bob cat spaced "> " scratch cat cat minshell
      scratch asciiload scratch delete asciify "T" book, T rows 1st
      ?DO T I quote notrailing this strlen 0>
         IF " rm: remove " swap "? (y,n,q): " cat cat
            query left justify lowercase 1st byte
            (char) its YES =
            IF (char) drop T I quote strchop this fallow
               IF delete
                  T I quote strchop sp sp . " removed" . nl
               ELSE sp sp "Cannot remove " . . nl
               THEN
            ELSE (char) QUIT = IF EXIT THEN nl
            THEN
         ELSE drop
         THEN
      LOOP pull indexbase 
      "} "rmcentral" -inlinex
      ]
      typing "rm" tug 2 erase, chop this strlen 0=
      IF drop done beep return THEN noNL rmcentral done
   end

   inline: sysdate (qUnix --- d t) \ numbers from Unix date and time
\     Assumes Unix date string of the form:
\        Mon Jul 17 05:37:52 PDT 2000
\     as delivered by word date.  For this example, returned d 
\     and t are 1000717 and 53752

      [ "Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec"
         words chop lowercase vol2mat bend
         1 12 items park yes sort "Months" book
      ] 
      oh STR stkok 
      one VOL stkok or not IF "sysdate" stknot return THEN

      words these push six ndx quote number drop 
      1900 less 10000 star
      peek 2nd quote lowercase str2num
      Months these rot bsearch drop 
      (Months row) two (col) fetch 100 star plus
      peek 3rd quote (day) number drop plus (d)
      pull four ndx quote (qTime) oclock (t)
   end

   define: topic ( --- ) \ searches for expressons in manual
\     Usage: topic xxx will search for lines in the manual that contain
\     expression xxx, and will display them in another window
      typing "topic" tug 2nd word
      IF manual back textsearch THEN done ;

   define: utail ( --- ) \ Unix tail command: tail filename
      [ "tail >" scratch cat is do 
        defname dup is name, chars negate is dent
        "scratch asciiload notrailing dot scratch deleteif" 
        "display" inlinex
      ] shellunix local display done ;

   inline: _vi (qS --- ) \ vi editor, ready-aim-fire version
\     Set vi default options in file ~/.exrc.
      [ no is viXSET ]

      0 STR stkok, not IF "_vi" stknot return THEN 

\     As default, using xterm settings XSET from word xterm.
\     See ukey.v where new settings XSET are banked here later.
      viXSET any? IF drop ELSE "xterm" "XSET" yank "viXSET" book THEN

\     Under rxvt, root running vi from this program messes up files 
\     /dev/ttypX.  Do not allow root to run vi:
      getuid 0= 
      IF " root cannot run vi from this program" . nl 
         (qS) drop HALT 
      THEN

      noNL
      (qS) +path "vi " swap cat (qS) 
      X11
      IF (qS) "xterm" "XSET" yank (qXSET) push \ save original xterm
         viXSET "xterm" "XSET" bank (qS) xterm \ run vi in its xterm
         pull (qXSET) "xterm" "XSET" bank      \ put original back

      ELSE shell \ run a shell when tty
      THEN
   end

   define: vi ( --- ) \ vi editor, fire-ready-aim version
\     Set vi default options in file ~/.exrc.
      typing "vi" tug -2 indent _vi done ;

   inline: viewbin (hX n --- hT) \ images of first n bytes of X
\     Note: Unix viewbin must be on the system.

\     X can be stack item type MAT, NUM, VOL, or STR.

\     Example.  The last 11 terms of a matrix column:

\        100 1 random, 11 endmost, these rows 8 * viewbin eview

      [ no "File" book ]

      "viewbin" filesearch not
      IF " viewbin: Unix viewbin not found" . nl HALT THEN

      intstr "n" book
 
      File filetrue IF File fclose THEN \ close File
      scratch forn binary "File" file   \ open File handle for scratch

      hand (hX) File fput, File fclose  \ write X to scratch
      "scratch1" deleteif               \ delete scratch1 existing

\     Running a command shell of the form:
\        viewbin scratch 0 n > scratch1

      "viewbin " scratch cat, " 0 " n cat cat
      " > " scratch1 cat cat (qS) shell

      scratch1 file? \ is there a file scratch1?
      IF scratch1 asciiload notrailing
      ELSE 1 0 blockofblanks
      THEN
   end

   inline: _view (qS --- ) \ vi read-only
      +path "-R " swap cat _vi ;

   define: view ( --- ) \ vi read-only
      typing "view" tug -4 indent +path "-R " swap cat _vi done ;

   "vim" filesearch 
   IF (qVIM) drop

   inline: _vim (qS --- ) \ vim editor, ready-aim-fire version
\     Running the Vi IMproved editor.
\     Set vim default options in file ~/.vimrc.

      [ "vim " makes VIM 
      \ Enable lines like the following to add vim command line options:
        VIM 
        "-u NONE "  cat \ skip initializations
        "-i NONE " cat  \ won't seek $HOME environment for .viminfo
        "" cat          \ more options here
        makes VIM

        no is viXSET
      ]
      0 STR stkok, not IF "_vim" stknot return THEN 

\     As default, using xterm settings XSET from word xterm.
\     See ukey.v where new settings XSET are banked here later.
      viXSET any? IF drop ELSE "xterm" "XSET" yank "viXSET" book THEN

\     Under rxvt, root running vim from this program messes up files 
\     /dev/ttypX.  Do not allow root to run vim:
      getuid 0= 
      IF " root cannot run vim from this program" . nl 
         (qS) drop HALT 
      THEN

      noNL
      (qS) +path VIM spaced swap cat (qS) 
      X11
      IF (qS) "xterm" "XSET" yank (qXSET) push \ save original xterm
         viXSET "xterm" "XSET" bank (qS) xterm \ run vim in its xterm
         pull (qXSET) "xterm" "XSET" bank      \ put original back

      ELSE shell \ run a shell when tty
      THEN
   end

   define: vim ( --- ) \ vim editor, fire-ready-aim version
\     Running the Vi IMproved editor.
\     Set vim default options in file ~/.vimrc.
      typing "vim" tug -3 indent _vim done
   end
 
   ELSE \ case when vim is not found:

   inline: _vim (qS --- ) _vi ;

   define: vim ( --- ) typing "vim" tug -3 indent _vi done ;

   THEN

   inline: which (qS --- qS1) \ Unix which command, postfix style
\     S1 is an empty string is no match for S is found.

\     Example: "nedit" which .

      SYSOUT (S) push 
      ftempsys (qFile) \ temp file from system
      (qFile) dup push set_sysout  \ output to temp file

      "/usr/bin/which " swap + " > " + scratch + shell
      scratch asciiload scratch delete 1st word
      IF strchop these 1st 5 items catch "which" grepr rows any
         IF drop "" THEN
      ELSE ""
      THEN

      pull (qFile) delete \ delete temp file
      pull (S) set_sysout \ reset SYSOUT
   end

   inline: xtar (qDir qFile --- ) \ extract files from tar File archive
\     Extract in Directory a tar File archive.
\     File includes its directory path.
      [ "HOME" env runid catpath "xtar_script" + "SCRIPT" book ]

      "File" book 
      "Dir" book
      pwd push
      Dir chdir

      "/bin/tar -zxvf " File + (hT)

\     This keeps things clean when networked:
      (hT) SCRIPT save            \ save Unix script
      SCRIPT 448 chmod            \ give execute permission
      SCRIPT ">/dev/null" + shell \ run script
      SCRIPT delete               \ delete script

      pull chdir
   end

   inline: xterm (qS --- ) \ run program S in xterm window
{     Opens another window and starts running program S.

      Example:
         "vi myfile" xterm

      To set options in a running xterm window, press
         XX-leftButton for Main Options
         XX-rightButton for VT Fonts (Modes on aixterm)
         XX-bothButtons for VT Options (nothing on aixterm)
      where XX=Ctrl-Alt (AIX, HP)
            XX=Ctrl (Linux)
      If numeric keypad does not work, try VT Options menu

      At the command prompt type the following to see other settings
      for xterm:
         xterm -help
         man xterm

      Notes on using minshell:
         rvxt terminal has no problem
         xterm says can't open display, so arg -display has been added

      Note: XSET settings seen below may not be current.  New ones may 
      have been banked at start up by phrases in usr/ukey.v.
}     [ TERM
        "-bg PeachPuff3 -fg Black -cr Firebrick4 -fn 7x14 " cat
        "-display " "DISPLAY" env spaced cat cat
        "+sb -geometry 72x32+1+1 -title " cat 
        makes XSET
      ] X11 
      IF no STR stkok, not IF "xterm" stknot return THEN noNL
         (qS) "&" chblank \ no & 
         XSET over quoted cat " -e " rot " &" cat cat cat 
\        minshell \ requires arg -display in XSET
         shell \ need this for env variables 
      ELSE " xterm: X11 graphics required" ersys
      THEN
   end

   inline: xtermsb (qS --- ) \ run S in xterm window with scroll bar
{     Opens another window with a scroll bar, and starts running pro-
      gram S.

      Note: XSET settings seen below may not be current.  New ones may 
      have been banked at start up by phrases in usr/ukey.v.
}     [ TERM
        "-bg PeachPuff3 -fg Black -cr Firebrick4 -fn 7x14 " cat
        "-display " "DISPLAY" env spaced cat cat
        "-sb -sl 1024 -geometry 72x32+1+1 -title " cat 
        makes XSET
      ] X11
      IF no STR stkok, not IF "xtermsb" stknot return THEN noNL
         (qS) "&" chblank \ no & 
         XSET over quoted cat " -e " rot " &" cat cat cat
\        minshell \ requires arg -display in XSET
         shell \ need this for env variables 
      ELSE " xtermsb: X11 graphics required" ersys
      THEN
   end

   private halt

\-----------------------------------------------------------------------
;
\  Appendix:

\  Equivalent to native word ltime:
  _inline: ltime (YYYmmdd HHmmss --- s)
      [ 700101 greg 86400 star "t0" book ]
      100 /mod 100 /mod 3600 * swap 60 star plus plus
      swap greg 86400 star plus, t0 less
   end

   Not-bad background colors that work with black text (see file 
   color.txt):
      PeachPuff3
      DarkSlateGray4
      Aquamarine4 (green)
      Turquoise4 (more blue than Aquamarine4)
      PaleTurquoise4 (more gray than Turquoise4)
      Sienna3 (orange/brown)
      Tan3 (yellow/brown)
      Peru (less yellow than Tan3--choose over Tan3**)
      SaddleBrown (too dark, but a good brown (not too reddish))

   ** On gutter's monitor, Peru and Tan3 look the same--there are not 
      enough colors.

Obsolete word alarmevery and company; improved multitasker lets word
ALARM do the job (see man ALARM).

  _inline: alarmevery ( --- ) \ after secs, run Task every dsecs
\     The multitasker always shuts an alarm off each time it runs.
\     The job of alarmevery is to start it again.

\     Word alarmeveryoff is used to permanently shut off this periodic
\     alarm.

\     Variables secs and dsecs are banked into the libary here by
\     word alarmeveryset.

\     Only runs once at secs if dsecs is not greater than zero.

\     Runs Task continuously if it takes longer than dsecs to perform.

      [ no "ptrTask" book, no "ticking" book
        0 "secs" book, -1 "dsecs" book,
      ]
      no ptrTask = IF return THEN
      ticking
      IF time dsecs plus "next" book \ next scheduled time to run
         ptrTask exe? not IF " alarmevery task had errors" . nl THEN

         dsecs 0>
         ticking and \ check again: ptrTask may have turned us off
         IF next time less "alarmevery" ALARM \ set to run again
         THEN

      ELSE
         yes "ticking" book
         secs "alarmevery" ALARM \ set to start in secs
      THEN
   end

  _inline: alarmeveryoff ( --- ) \ turn off alarmevery
\     Note: Use this to permanently shut off the periodic alarm.
      "alarmevery" "ticking" extract
      IF "alarmevery" -ALARM, no "alarmevery" "ticking" bank THEN
   end

  _inline: alarmeveryset (qTask sec0 dsecs --- ) \ set alarmevery
{     Sets alarm to perform Task after sec0 seconds have passed,
      and then every dsecs seconds after that; Task is the name
      of the catalog function that is run.
      
      This word just banks these things in the local library of
      word alarmevery.  To start the alarm, alarmevery must be said.

}     (dsecs) "alarmevery" "dsecs" bank
      (sec0) "alarmevery" "secs" bank
      (qTask) ptr "alarmevery" "ptrTask" bank
   end

Obsolete text from manual for alarmevery and company:
alarmevery ( --- ) starts the periodic alarm defined by word alarmeveryset, to begin a defined Task in n seconds and repeat every d seconds thereafter
alarmevery note: first set start time n, increment d, and Task using word alarmeveryset; then start alarm by saying alarmevery
alarmevery note: if increment d is zero or less, alarmevery will turn itself off after it runs Task at start time in n seconds
alarmevery note: saying alarmeveryoff stops alarmevery--perhaps the periodic Task runs alarmeveryoff after has run a required number of cycles or a certain number of hours; otherwise, alarmevery runs indefinitely
alarmevery usage: this alarm displays times that are 3 seconds apart:
alarmevery use 1> inline: ticking  time 't0' main - .i ; \
alarmevery use 2> "ticking" 0 3 alarmeveryset \
alarmevery use 3> time "t0" book alarmevery pause alarmeveryoff
alarmevery note: in use 2>, alarmeveryset sets word ticking to be run every 3 seconds starting 0 seconds after alarmevery starts running; use 3> starts word alarmevery running, and then stops it when you hit the Enter key to continue
alarmevery note: alarmevery and alarmeveryset can do only one task at a time; but word ALARM can be used to build similar words for all kinds of alarms, and all can be running in parallel
alarmevery related: alarmeveryoff, alarmeveryset, ALARM, tasks, TASK
alarmeveryoff ( --- ) turn off the periodic alarm started by word alarmevery
alarmeveryoff note: use this word to permanently shut off the periodic alarm when it is no longer needed
alarmeveryoff note: the multitasker takes care of shutting off the alarm after each of its cycles, and the alarm is then queued for another cycle
alarmeveryoff related: alarmevery, alarmeveryset, tasks
alarmeveryset (qTask n d --- ) set alarmevery to begin Task in n seconds and repeat every d seconds thereafter
alarmeveryset note: Task is the word in the catalog that is run each time alarmevery goes off
alarmeveryset note: if d is zero or less, alarmevery will turn itself off after it runs Task once at the start time in n seconds
alarmeveryset note: alarmevery and alarmeveryset can do only one task at a time; but word ALARM can be used to build similar words for all kinds of alarms, and all can be running in parallel
alarmeveryset related: alarmevery, alarmeveryoff, tasks, todayat



Obsolete text from manual for word alarm and related:
alarm ( --- ) starts timer set by word alarmset, and after defined seconds have passed, the defined task will be run
alarm note: first set alarm and task using word alarmset, then start the timer by saying word alarm
alarm note: alarm deactivates itself after it runs; it can be deactivated earlier by saying word alarmoff
alarm note: alarm and alarmset can do only one task at a time
alarm use 0> tasks \ shows alarm in multitasker's list
alarm usage: alarmdemo is a word in the catalog; set it to run 6 seconds after alarm is started:alarm use 1> "alarmdemo" 6 alarmset
alarm use 2> alarm \ starting the timeralarm note: nothing will happen for 6 seconds
alarm use 3> tasks \ shows alarm running
alarm use 4> alarmoff \ alarmdemo resets itself; this turns it off
alarm use 5> tasks \ shows alarm asleep
alarm related: alarmoff, alarmset, alarmevery, tasks, TASK, sigalarm
alarm related (identical in operation): watch, watchset, watchoff
alarmoff ( --- ) turn off timer started by word alarm
alarmoff related: alarm, alarmset, tasks
alarmset (qTask secs --- ) set alarm so that after secs have passed, Task will be run
alarmset note important: this just sets the alarm; the timer must be started by saying alarm too
alarmset note: Task is the word in the catalog that is run when alarm goes off
alarmset note: alarm and alarmset can do only one task at a time
alarmset related: alarm, alarmoff, tasks, todayat

  _inline: alarm ( --- ) \ after secs, run Task set by alarmset
      [ scalar "Task" book, scalar "secs" book, zero "Tstart" book
        scalar "running" book, no running bang
      ] running ontop
      IF time Tstart less secs ontop >=
         IF alarmoff Task ontop exe? not
            IF " alarm task failed" . nl THEN
         THEN
      ELSE time "Tstart" book, yes running bang "alarm" WAKE
      THEN
   end

  _define: alarmdemo ( --- ) \ demonstrate alarm in manual
\     Runs dummy task for alarm, then sets to run itself again in 5
\     seconds.
      nl " demo alarmed task done here" .
      nl " demo resetting to run again in 5 seconds" .
      nl " type alarmoff to stop demo" .
      nl cprompt .
      "alarmdemo" 5 alarmset alarm \ run this word again
   end

  _define: alarmoff ( --- ) \ turn off alarm timer
      "alarm" SLEEP, no "alarm" "running" extract bang ;

  _define: alarmset (qTask secs --- ) \ set alarm: after secs run Task
{     Set alarm to perform Task after secs have passed; Task is the
      name of the catalog function that is run.
      This word just stores these things in the local library of
      word alarm.
}     (secs) "alarm" "secs" extract bang
      (qTask) ptr "alarm" "Task" extract bang
   end
   one (Hz) "alarm" TASK \ making alarm a multitasker task

  _define: cp ( --- ) \ Unix cp command: cp fromfile tofile
\     This version preserves the date.      
   typing "cp" tug -2 indent "cp -p " swap cat shell done end

  _define: diff ( --- ) \ Unix diff command: diff file1 file2      
      typing "diff" tug " > " scratch cat cat shell
      scratch asciiload notrailing dot done end

  _define: ll ( --- ) \ Unix subdirectory long list
      [ SBIN "ls -alFg" cat is do
        defname dup is name, chars negate is dent
        shellunix "job" inlinex
      ] job done ;

  _define: llr ( --- ) \ long list, reversed time order
      [ SBIN "ls -rgFlat " cat is do
        defname dup is name, chars negate is dent
      ] shellunix local done ;

  _define: ls ( --- ) \ Unix ls
      [ SBIN "ls -F " cat is do
        defname dup is name, chars negate is dent
      ] shellunix local done ;

  _define: ll ( --- ) \ Unix subdirectory long list
      [ "ls -alFg " is alias, defname dup is name,
        chars negate is dent
      ]
      alias typing, name tug, dent indent cat
      " > " scratch cat cat shell
      scratch asciiload notrailing dot done end

  _define: llr ( --- ) \ long list, reversed time order
      [ "ls -rgFlat " is do, defname dup is name, chars negate is dent
      ] do typing, name tug, dent indent cat
      " > " scratch cat cat shell
      scratch asciiload notrailing dot done end

  _define: ls ( --- ) \ Unix ls
      "ls" typing over tug, 2 erase cat " > /dev/tty" cat shell done ;

  _define: more ( --- ) \ Unix more command
      "more" typing over tug four erase cat
      " > /dev/tty" cat shell done ;

  This version reads the entire file into memory; it is replaced by a
  version using fmapleft to just read the relevant region to be sourced.
  _inline: msource (qFile qM --- ) \ source File words at M and beyond
\     In File, string M is first in its line; sourcing ends at a
\     word like halt or end, or when the end of File is hit.
\     Text following M on its line is sourced.
      chop that filefound
      IF asciiload over (hT qM) tear (hTop hBot) any?
         IF (qM hTop hBot) swap these rows ndx quote left justify
            rot (qM) chars negate indent swap pile
            (qFile hT) lop main
         ELSE (qFile qM hTop) three dump " marker not found" ersys
         THEN
      ELSE " file not found" ersys
      THEN
   end

\-----------------------------------------------------------------------

\  Word to temporarily fix LD_LIBRARY_PATH until bug was found and 
\  fixed.
  _inline: LD_LIBRARY_PATH ( --- ) \ fix LD_LIBRARY_PATH
{     Fix LD_LIBRARY_PATH.

      NOTE: Assumes path names for LD_LIBRARY_PATH begin with /.

      From environ supplied by the operating system, the lines for 
      LD_LIBRARY_PATH appear as:

         LD_LIBRARY_PATH=/home/user/txdir/
         /opt/tops/tx/
         /usr/local/sqlite/lib/

      for this entry in .bashrc:

export LD_LIBRARY_PATH=/home/user/txdir/:/opt/tops/tx/:/usr/local/sqlite/lib/

      Function getenv1() obtains these lines from the environ array
      supplied by the operating system.  For second and third path
      entries to appear on separate lines, there must be nulls in the
      array from the os. 

      This word connects the paths, so for strings on separate lines
      the path would become the single string:

  LD_LIBRARY_PATH=/home/user/txdir/:/opt/tops/tx/:/usr/local/sqlite/lib/

      Without this fix, shells opened by this program only see the
      first entry:

         LD_LIBRARY_PATH=/home/user/txdir/

      Shells needing the third entry, /usr/local/sqlite/lib/, will 
      fail to start.

      After this word has fixed LD_LIBRARY_PATH, getenv will continue
      to show the incorrect one:

[tops@clacker] ready > getenv dup "LD_LIBRARY_PATH" grepr reach .
LD_LIBRARY_PATH=/home/user/txdir/

      But LD_LIBRARY_PATH has been installed correctly in the program's
      shell environment as this shows:

[tops@clacker] ready > "LD_LIBRARY_PATH" env .
LD_LIBRARY_PATH=/home/user/txdir/:/opt/tops/tx/:/usr/local/sqlite/lib/

      When LD_LIBRARY_PATH is installed correctly, the following is
      possible:

         [user@clacker] /home/user > tops
                  Tops 2.4.3
         Thu Oct 30 08:38:24 PST 2003
         [tops@clacker] ready > 'tops' shell
                 Tops 2.4.3
         Thu Oct 30 08:38:28 PST 2003
         [tops@clacker] ready > bye
         4 keys
                   Good-bye
         Thu Oct 30 08:38:54 PST 2003

         [tops@clacker] ready > 
}
      getenv (hT) dup "LD_LIBRARY_PATH" grepr any?
      IF ontop those rows those less tic items reach (hT)
         these rows 1 >
         IF this push 1st quote strchop
            peek rows 2nd
            DO peek I quote strchop this 1st character "/" =
               IF ":" swap cat cat
               ELSE drop EXIT
               THEN
            LOOP pull drop
         ELSE vol2str
         THEN
         (qS) setenv
      ELSE (hT) drop
      THEN
   end

   LD_LIBRARY_PATH \ fix LD_LIBRAY_PATH now, during start up

