\ {{{1 GNU General Public License
{
Program Tops - a stack-based computing environment
Copyright (C) 1999-2013  Dale R. Williamson

Author: Dale R. Williamson <dale.williamson@prodigy.net>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
1}}}
}
{ File tops/sys/uboot.v  June 1999

   User additional words at boot time.

   This is file tops/sys/uboot.v.  File tops/usr/uboot.v is probably 
   sourcing this file before it loads user words that will replace or
   add to those in this file.

   Tue Jul 17 16:48:23 PDT 2012.  See notes in tops/usr/uboot.v for 
   more about how this program's uboot.v files work to give control 
   over the words that are loaded at start up.

   This is where to load words for batch or interactive processing.

   File tops/sys/ukey.v or tops/usr/ukey.v are places to load words 
   just for interactive processing.
}
   uboot_done
   IF " uboot.v: only at start up" . nl halt THEN \ only source once

   " info: sourcing " syspath "uboot.v" + + . nl 

\-----------------------------------------------------------------------

\  Sourcing other files

   "cal.v" filefound (0 or qFile -1)
   IF (qFile) " info: sourcing " over + . nl 

      dup (qFile) source

      (qFile) " info: sourcing " swap + " complete" + . nl
   THEN

{  Sourcing sys/uboot.nv (infix words from uboot.n) if it is found.

   Policy: do not source infix files during startup since they require
   the parser which is still under development (file prs.c). 

   File uboot.nv is a postfix file previously created from infix file
   uboot.n (using word parse_save).  Source it instead:
}  "uboot.nv" filefound IF "uboot.nv" source THEN

\  Use this to keep words-defined messages coming to start up log file:
   yes catmsg \ in case any files sourced above turned catmsg off

\-----------------------------------------------------------------------

{  Contents

 \ This line gives inline names for the list of contents below:
      syspath "uboot.v" + asciiload this " inline:" grepr reach dot

\  Parameters saved at exit and read at start up
   inline: params_get ( --- ) \ gather saved parameters from last run
   inline: params_put ( --- ) \ parameters on a file for next time
   inline: uclean ( --- ) \ called by word clean on exit

\  Miscelleneous words
   inline: APP_CLIENT_ALLOW (qIP --- f) \ flag f true if IP can connect
   inline: chtime (htm --- hT) \ machine time to Chicago time in VOL T
   inline: GMT>LA (GMT_sec --- LA_sec) \ machine time sec to LA sec
   inline: LA>GMT (LA_sec --- GMT_sec) \ LA to GMT
   inline: pExposeUser (hWCB hGCB hY hX hL --- ) \ expose event handler
   inline: psave (f --- ) \ control power to the monitor
   inline: telserver_start (qIPaddr nPort --- f) \ start telserver
   inline: WORKLOAD ( --- ) \ write work load to WORK.LOG

   Remote sound words
   inline: announcing ( --- ) \ ta da
   inline: phoneALARM (qPhone --- ) \ ring my phone
   inline: pulse ( --- ) \ a short burst of sound
   inline: reminder ( --- ) \ a word of reminder
   inline: remote_wavPlayq (qWav --- ) \ play wave file on remote
   inline: remote_wavque_clr ( --- ) \ clear the remote sound file queue
   inline: remote_wavque_len ( --- n) \ number of items in queue

   Words for networks
   inline: BRIDGING ( --- ) \ machine clacker bridges to machine plunger
   inline: mycon ( --- ) \ show my ppp connection parameters
   inline: myNET ( --- ) \ start networked machines
   inline: mySERVERS (n --- f) \ start n nodes running for client
   inline: SPEED_LOG ( --- ) \ Internet speed fetching bytes

   Connecting to the Internet 
   inline: _WWW ( --- ) \ a user word for connecting
   inline: WWW ( --- ) \ a user word for connecting

   Matlab for this machine
   inline: MATLAB ( --- qS) \ the command string to start Matlab
}
\-----------------------------------------------------------------------

\  Parameters saved at exit and read at start up

   inline: params_get ( --- ) \ gather saved parameters from last run
\     Get parameters saved by params_put and set them.

      [ no "FILE" book, list: 0 seed0 ; "NUMS" book ]

      usrpath ".params.bin" catpath "Fname" book \ name of file
      Fname file? not IF return THEN

      FILE filetrue IF FILE close THEN

      Fname old binary "FILE" open
      FILE "NUMS" get "NUMS" book
      FILE close

      NUMS 1st pry (delta) GMTdelta \ correction used by word time
      NUMS 2nd pry (last random seed) seedset
   end

   inline: params_put ( --- ) \ parameters on a file for next time
{     Put parameters on a file at usrpath, to be loaded by word
      params_get when the program is started again.

      The same file is written to usrpath each time an instance
      of the program exits.
}
      [ no "FILE" book, no "ROOT" book ]

      getuid 0= ROOT no = and
      IF return THEN \ do not let root write this file
{
      Since GMTdelta is what's important on this file that is common to
      all instances of the program, do not write the file unless the
      GMTdelta value is different from the initial one.

      A different value implies a new one from an Internet connection,
      and it will be recorded.  A program instance that did not connect
      and started before and closed after the one that did write a new
      GMTdelta will not be allowed to overwrite with its same-old value.
}  
      ROOT no =
      IF "params_get" "NUMS" yank 1st pry  \ GMTdelta value at start up
         time integer time1 integer less = \ GMTdelta value now
         IF return THEN
      THEN

      "params_get" "Fname" yank "Fname" book
      Fname fallow not IF return THEN

      FILE filetrue IF FILE close THEN

      Fname deleteif \ must delete because put is used below
      Fname forn binary "FILE" open
      
      list:

         time integer time1 integer less \ GMTdelta
         seedget                         \ last random seed

      end (hA)
      (hA) "NUMS" naming FILE put
      FILE close

    \ Because file was deleted and then written by this user, only the 
    \ user has write permission.  Use chmod to give permission to all:
      Fname 256 128 + 32 16 + + 4 2 + + chmod \ permission to all
   end

   inline: uclean ( --- ) \ called by word clean on exit
\     User clean up.

      params_put \ parameters to file that is read on start up

\     Other phrases to run on exit:
\        ...

   end

   params_get \ get parameters now during start up

\-----------------------------------------------------------------------

\  Miscelleneous words

   inline: APP_CLIENT_ALLOW (qIP --- f) \ flag f true if IP can connect
{     Returns f true if IP is not in file usrpath/ACCESS.

      To use this word, bank its ptr into CLIENT_ALLOW as follows:
         "APP_CLIENT_ALLOW" ptr "CLIENT_ALLOW" "APP_CLIENT_ALLOW" bank

      To use a file of hosts to deny that is different from 
      usrpath/ACCESS:
         "myPATH/myFILE_ACCESS" "APP_CLIENT_ALLOW" "FILE" bank

      Example.  This shows that a remote machine is using a ptr to this
      word in its word CLIENT_ALLOW:

         [dale@rilefile] /home/dale > tops
                  Tops 3.2.1
         Thu Jan 23 01:48:59 UTC 2014
         [tops@rilefile] ready > 'IPloop' 80 CLIENT

          stack elements:
                0 number: 3
          [1] ok!
         [tops@rilefile] ready > remoteprompt
         tops@socket3 > 'CLIENT_ALLOW' wholib
          Stack items in the library of word CLIENT_ALLOW:
           Name             Rows Cols Bytes Type  Description
           clients          3    25   75    VOL   volume
           APP_CLIENT_ALLOW 0    0    8     NUM   ptr->APP_CLIENT_ALLOW
                                      83    total
         tops@socket3 > 

         [tops@rilefile] ready > bye
         60 keys
                   Good-bye
         Thu Jan 23 01:49:44 UTC 2014
         [dale@rilefile] /home/dale > 
}
      [ usrpath "ACCESS" catpath "FILE" book ]
      FILE file?
      IF (qIP) FILE asciiload (hT) noblanklines chop any?
         IF 1st word drop swap 
            (hT qIP) grepe (hA) rows any not (f)
         ELSE (qIP) drop yes
         THEN
      ELSE (qIP) drop yes
      THEN
   end

   inline: chtime (htm --- hT) \ machine time to Chicago time in VOL T
    \ Thu Feb  2 03:30:53 PST 2012.  Time to Chicago time, assuming my 
    \ machine in the Pacific time zone.

    \ Used for making text output for debug.  Just say "t chtime."

      (htm) 7200 + (ht) ctime (hT) "P" "C" replace$ spaced (hT)
      "_chtime" naming
   end

   inline: GMT>LA (GMT_sec --- LA_sec) \ machine time sec to LA sec
\     Incoming GMT_sec is machine time (word time, seconds relative
\     to UTC on January 1, 1970).
      LAdiff plus ;

   inline: LA>GMT (LA_sec --- GMT_sec) \ LA to GMT
\     GMT_sec is machine time (seconds relative to UTC on January 1,
\     1970).
      LAdiff minus ;

#def pExposeUser

   inline: pExposeUser (hWCB hGCB hY hX hL --- ) \ expose event handler
{     Fri May 24 06:14:08 PDT 2013

      User handler for expose events in window WCB.  This word is a 
      stub that can be made into an expose event handler to work with
      functions in sys/plot.v.

      See word pExpose() in sys/plot.v.

      Banking the ptr to this word into pExpose(), either as USERptr1 
      or USERptr2, will make it run when there is a graphics expose
      event.

      How to set up:

         Banking the ptr to this word into pExpose.USERptr2 (showing
         postfix and infix expressions):

            ready > "pExposeUser" ptr "pExpose" "USERptr2" bank

            >> pExpose.USERptr2 = ptr("pExposeUser");

         Setting pExpose.USERptr2 means this word will be run after 
         pExpose() has handled the expose event.

      Example.  At the ready prompt, paste the four lines following:
         "pExposeUser" missing IF syspath "uboot.v" +                \
         "#def pExposeUser" "#end pExposeUser" msource1 THEN         \
         syspath "uboot.v" + "#def User Example" "#end User Example" \
         msource1 pause plotclose
\
         #def User Example

          \ Load words:
            "pExpose" missing IF "plot.v" source THEN
            "sine" missing IF "mmath.v" source THEN

          \ Set handlers in pExpose():
            "pExposeUser" ptr "pExpose" "USERptr1" bank 
            "pExposeUser" ptr "pExpose" "USERptr2" bank 

          \ Make a plot and zoom to see expose events updated:
            1 10 2pi * 0.05 0 0.001 1000 sined plot

         #end User Example
  
      How to zoom:

         To zoom in: Left click two points to define the diagonal
         corners of an imaginary rectangle, then right click.

         Continuing this action (left, left, right) will zoom in
         closer.

         Right clicking will zoom back out through each zoom in.
}
 
      [ no "NTRY" book ]
 
    \ This stub handler simply prints a message, clears the incoming
    \ stack and returns.  

    \ By toggling NTRY, it works for both USERptr1 and USERptr2 in
    \ pExpose().

      NTRY no =
      IF yes "NTRY" book
 
         " This is pExposeUser for USERptr1" nl . nl 

        \ draw here before pExpose() draws

         (hWCB hGCB hY hX hL) drop 2drop 2drop
         return
 
      ELSE no "NTRY" book
 
         " This is pExposeUser for USERptr2" . nl 

        \ draw here after pExpose() draws

         (hWCB hGCB hY hX hL) drop 2drop 2drop
         return
 
      THEN
   end

#end pExposeUser

   inline: psave (f --- ) \ control power to the monitor
{     Fri Sep  2 10:35:06 PDT 2011.

      Control power to the monitor and always turn the screen saver off.

      Examples.  

      These are default settings (run xset to see how to change them):

         [user@kaffia] /home/user > xset q
         DPMS (Energy Star):
           Standby: 1200    Suspend: 1800    Off: 2400
           DPMS is Disabled

      With power saving Enabled, the monitor will go into Standby
      mode in 1200 seconds (20 minutes).  Running

         ready > yes psave

      will enable these settings as this now shows:

         [user@kaffia] /home/user > xset q
         DPMS (Energy Star):
           Standby: 1200    Suspend: 1800    Off: 2400
           DPMS is Enabled
           Monitor is On

      To query last setting:

         if(psave.power==yes) dot("power saving is on");

      Setting power saving on and off at designated times:

         Make on and off ALARM words:
            inline: psaveON ( --- ) yes psave ;
            inline: psaveOFF ( --- ) no psave ;

         These must be run before 7 AM:
            "07:00:00" todayat "psaveOFF" ALARM \ off at 7 AM
            "19:00:00" todayat "psaveON"  ALARM \ on at 7 PM
}
      [ UDEF "power" book ]
      no NUM stkok not IF "psave" stknot return THEN

      (f)
      IF yes (p) "xset dpms"   \ power saving on
      ELSE no (p) "xset -dpms" \ power saving off
      THEN shell (p) "power" book

      "xset s off" shell \ always set screen saver off
   end

   inline: telserver_start (qIPaddr nPort --- f) \ start telserver
\     Start telserver listening on Port and allow only IPaddr to
\     connect.  The telserver script is file usr/telserver.

      [ "telserver -allow IP -port P -ntrace" "COMMAND" book
        "PORT dup nextport <> (f)" "PORT_ON" macro
        "PORT dup nextport = (f)" "PORT_OFF" macro
        10 "SEC" book 10 "Hz" book
      ]
      "PORT" book "IP" book
      PORT_OFF (f)
      IF SEC "telserver_start" "PORT_ON" localref WAIT_INIT

         COMMAND "IP" IP strp "P" PORT intstr strp shell

         Hz "WAITING" RATE
         WAIT_BEGIN \ wait for confirmation that PORT is on
         PORT_ON (f)

      ELSE false \ Port is not available
      THEN (f)
   end

   inline: WORKLOAD ( --- ) \ write work load to WORK.LOG
      [ "HOME" env "WORK.LOG" catpath "WORK" book
        "HOME" env runid catpath "WORKLOAD" + "FILE" book
      ]
      date words 1st 3 items reach vol2str (qDate)
      "w > " FILE cat shell
      FILE asciiload FILE delete 1st quote strchop (qWork)
      these chars 0= IF drop " no data" THEN
      (qDate qWork) park neat (hW)

      (hW) WORK append
   end

\-----------------------------------------------------------------------

\  Remote sound words

   inline: announcing ( --- ) \ ta da
    \ Sun May 26 10:34:33 PDT 2013

    \ Remotely runs ANNOUNCING in sys/snd.v.

      IPloop SNDSERVER CLIENT (nS) dup -1 >
      IF (nS) "ANNOUNCING" that remoterun sclose
      ELSE " announcing: cannot connect to SNDSERVER" . nl
      THEN
   end

   inline: phoneALARM (qPhone --- ) \ ring my phone
    { Ring Phone number as an alarm.  There is no message, but caller 
      ID will show it is this machine calling.  

      Incoming Phone string is of dial up modem form. 

      A dial up ISP is not needed, just a dial up modem connected to
      the phone.

      File /var/log/ppp normally shows the dial up activity this word
      generates.

      Examples:
         phoneALARM.DT = 10; // minimum 10 minute interval between calls
         phoneALARM.TTY = "ttyS3"; // set modem device if not ttyS4
         phoneALARM("ATD-1-XXX-YYY-ZZZZ"); // make a call
    }
      [ 
      { Here is a script that rings PHONE number, using the machine's 
        pppd and chat with a dial up modem.  A dial up ISP is not 
        needed, just the old modem connected to the phone.  

        Bank TTY for the modem into this word, such as
           "ttyS3" "phoneALARM" "TTY" bank
        if it is different from default ttyS4.
      } {" 
           #!/bin/sh
            /usr/sbin/pppd user user@isp.net debug /dev/ttyXX 57600 \
            connect "/usr/sbin/chat -v '' '\dATQ0V1&C1&D2M0' OK \
            PHONE CONNECT--ECT"          
        "} chop "SCRIPT" book

        0 "tlast" book        \ time of last call
        3 (minutes) "DT" book \ don't call interval, minutes

        "ttyS4" "TTY" book \ default modem device
      ] 
      time tlast - DT 60 * < IF (qPhone) drop return THEN
      time "tlast" book \ remember time now

      (qPhone) SCRIPT "PHONE" rot strp (hT) \ phone number into script
      (hT) "ttyXX" TTY strp (hT)            \ machine's TTY into script

    \ See this program's man chmod for an example of running a Unix 
    \ script in this way: 
      (hT) scratch save, scratch 448 chmod, scratch shell

      scratch delete
   end

   inline: pulse ( --- ) \ a short burst of sound
    \ Thu Mar 25 08:31:53 PDT 2010

    \ Remotely runs PULSE in sys/snd.v.

      IPloop SNDSERVER CLIENT (nS) dup -1 >
      IF (nS) "PULSE" that remoterun sclose
      ELSE " pulse: cannot connect to SNDSERVER" . nl
      THEN
   end

   inline: reminder ( --- ) \ a word of reminder
    \ Sun May 26 10:34:33 PDT 2013

    \ Remotely runs REMINDER in sys/snd.v.

      IPloop SNDSERVER CLIENT (nS) dup -1 >
      IF (nS) "REMINDER" that remoterun sclose
      ELSE " reminder: cannot connect to SNDSERVER" . nl
      THEN
   end

   inline: remote_wavPlayq (qWav --- ) \ play wave file on remote
{     Fri Mar 12 11:52:30 PST 2010, allow incoming list of files

      Queue up and play Wav file on the remote sound file server.  
      See file usr/tops_snd for the remote sound file server.

      If incoming Wav is a STR or VOL of more than one file to play,
      all are queued at the same time, in sequence, on the remote 
      sound file server, ensuring that another program won't inject
      its files between.

      A copy of each incoming file is made, and the copy is deleted
      by the sound file server after it is played.

      With the sound file server running, the program running this 
      word does not need any sound words. 

      Example:
         "/mdat/voices/signal8/crystal_3reminderH.wav"   \
         "/mdat/voices/signal8/crystal_hitthat.wav" pile \
         "/mdat/voices/signal8/bong1.wav" pile           \
         remote_wavPlayq
}
      [ "_bin" "tmppath" yank "remote_wavPlayq_" + "FIL" book ]

      LOCKED 
      IF " remote_wavPlayq: program state is LOCKED; try later" 
         . nl (qWav) drop return
      THEN

      IPloop SNDSERVER CLIENT (nS) dup -1 >
      IF (nS) "S" book

       \ Copy the incoming files to temp files; wavque_play() on the 
       \ sound file server always deletes a file after it is played:
         (qWav) words (hW) push
         list: peek rows 1st 
            DO peek I quote (qWav) FIL ftemp (qTMP)
               (qWav qTMP) dup rev fcopy (qTMP)
            LOOP 
         end (hV) 
         pull (hW) drop      

         (hV) words (hT1) \ list of temp files to play
         (hT1) "wavque_add" S remoterun2
         S sclose

      ELSE " remote_wavPlayq: cannot connect to SNDSERVER" . nl
         (qWav nS) 2drop
      THEN
   end

   inline: remote_wavque_clr ( --- ) \ clear the remote sound file queue
{     Clear the queue on the remote sound file server.
      See file usr/tops_snd for the remote sound file server.

      With the sound file server running, the program running this word
      does not need any sound words.
}
      LOCKED 
      IF " remote_wavque_clr: program state is LOCKED; try later"
         . nl return
      THEN

      IPloop SNDSERVER CLIENT (nS) dup -1 >
      IF (nS) "wavque_clr" over remoterun
         (nS) sclose
      ELSE " remote_wavque_clr: cannot connect to SNDSERVER" . nl
         (nS) drop
      THEN
   end

   inline: remote_wavque_len ( --- n) \ number of items in queue
{     Fetch the number of items in the queue of the remote sound file
      server.  See file usr/tops_snd for the remote sound file server.

      Returned n includes the file being played.

      With the sound file server running, the program running this word
      does not need any sound words.
}
      LOCKED 
      IF " remote_wavque_len: program state is LOCKED; try later"
         . nl 0 return
      THEN

      IPloop SNDSERVER CLIENT (nS) "S" book
      S -1 >
      IF "'wavque_play' 'queue' yank rows remotefd remoteput"
         S remoterun1 (n)
         S sclose
      ELSE " remote_wavque_len: cannot connect to SNDSERVER" . nl
         -1 (n)
      THEN (n)
   end


\-----------------------------------------------------------------------

\  Words for networks

\  Connecting two machines using a third with a fixed IP address.
   public
   inline: BRIDGING ( --- ) \ machine clacker bridges to machine plunger
{     This word is run (nearly) simultaneously on two machines.  The
      two machines use a third machine to connect them to each other.

      The two machines being connected may have roving IP addresses
      assigned by an ISP.  This word will connect them using a third
      machine with a fixed IP address.  When the machines are connected,
      their connections to the third machine are closed.

      In an automation, this word may be started at the same time on
      each machine by an alarm, but this requires times on the machines
      to be close to each other.

      Waiting periods in the phrases below assume the times on the ma-
      chines are within plus or minus 15 seconds.

      This program's word NISTdelta will set the program's GMT to with-
      in 1 second and it is usually run every time a connection to the
      Internet is made, so a 30 second window is easy to meet.

      This word has been written for two machines, clacker and plunger,
      and connecting to a third machine at site and port given by word
      topsdog.  But it can be run on a single machine to demonstrate
      its use before converting it for other machines and sites, as de-
      scribed next.

      Running a demo on a single machine.  To run this word on a single
      machine with no Internet connection required, first paste each one
      of these in a separate window where this program is running:

           "plunger" "host1" book (Window 1)
           "clacker" "host1" book (Window 2)

      and in a third window have the program running def_server:

           def_server (Window 3)

      Finally, put this word's entire text (including "public" above and
      "private" below) at the top of file work.v, followed by word halt,
      and switch # to bring the four demo lines below into play.

      Then in Windows 1 and 2, run

         ww BRIDGING

      and wait for about one minute until Windows 1 and 2 report
      "BRIDGING: connected to ... ."  For the single machine demo, host
      names shown will be the name of the machine.

      Running word clients in Windows 1 and 2 shows the final connec-
      tions.

      To see more of what is going on, word ntrace can be run in each
      window before "ww BRIDGING" is fired.
}
      [ 60 "WAIT1" book 30 "WAIT2" book, 60 "WAIT" book ]

      -1 'C1' book \ invalidate socket name C1

#     host1 "clacker" = (demo) \ host clacker
      host  "clacker" =        \ host clacker

      IF \ this is Clacker's branch:
{        Clacker connects to the third machine immediately, then idles
         WAIT1 (about 60) seconds while Plunger connects:
}
#        IPloop def_port CLIENT (demo) \ connect to third machine
         WWW topsdog CLIENT            \ connect to third machine

         "TD" book WAIT1 idle \ connected to TD, then wait

         "'C1' BRIDGE ACK" TD remoterun1 (ack) drop \ make the bridge

         C1 -1 <> \ C1 is name of bridge socket
         IF TD sclose \ Clacker closes its connection to third machine

          \ Clacker has Plunger close its connection to third machine,
          \ and also run WAIT_END to end its wait state (see Plunger's
          \ phrases below):
            "TD sclose ACK WAIT_END" C1 remoterun1 (ack) drop

            nl " BRIDGING: connected to " C1 remotehost cat

         ELSE " BRIDGING: socket C1 not found"
         THEN . nl

      ELSE

#        host1 "plunger" = (demo) \ host plunger
         host  "plunger" =        \ host plunger

         IF \ this is Plunger's branch:
{           Plunger idles WAIT2 (about 30) seconds so Clacker will con-
            nect to the third machine first, because the first one to
            connect becomes the server in word CROSSLINK.  This word is
            written with Clacker as the server.

            After Plunger connects to the third machine, it enters a
            WAIT state to be ended by Clacker's WAIT_END command (see
            Clacker's phrases above):
}
            WAIT2 idle \ time for Clacker to connect first

#           IPloop def_port CLIENT (demo) \ connect to third machine
            WWW topsdog CLIENT            \ connect to third machine

            "TD" book \ connected to TD

            WAIT WAIT_ALARM WAIT_BEGIN \ enter indeterminate WAIT

            nl " BRIDGING: connected to " . C1 remotehost . nl

         THEN

      THEN
   end
   private

   inline: mycon ( --- ) \ show my ppp connection parameters
      "From:" missing
      IF " mycon: file web.v must be sourced" . nl
      ELSE nl
         " email from: " . From: . nl
         " sendmail .cf file: " . SENDMAIL.CF . nl
         "pppscript" exists?
         IF " next pppd script: " . nl pppscript 3 indent . nl THEN
      THEN
   end

   inline: myNET ( --- ) \ start networked machines
{     Setting up a cluster of networked machines:
         Using files:
            mytops/usr/tserv as script to run tops on networked machines
            mytops/usr/myclu.v for names of machines that are networked

      Until this word starts to run and sources file clu.v, words below
      like cluster_initialize, cluster_start, and cluster_connect are
      unsatisfied external references.

      Warning: uses the same port for all connections, so machines must
      be separate.
}
      [ 9878 "myPORT" book, 10 "SEC" book ]

      "cluster_connect" exists?
      IF "cluster_connect" "HOST" yank any?
         IF " myNET: must close running cluster first" ersys return THEN
      THEN

      " myNET: for machines defined in " . "myclu.v" filefound
      IF . nl ELSE "... file not found" . nl HALT THEN

      " myNET: connecting network cluster..." . nl

      CATMSG push no catmsg
      "clu.v" "Words for networking machines as a cluster." msource
      myPORT "USE_PORT" "PORT" bank
      "clu.v" "Demo network." msource
      pull catmsg

      cluster_initialize

    \ WARNING: Allow a delay for this program to start up on the nodes
    \ before trying to connect them:
      nodes_all one cluster_start \ start the nodes running
      SEC idle

      cluster_connect \ head node to the cluster nodes

      cluster_ack (f)

      IF
       \ Synchronize nodes to head node time:
         cluster_timesync (hT) " done" . nl

         cluster_props three indent . nl
         " myNET: client server clocks are synchronized to host "
         host ":" cat cat . nl
         (hT) three indent . nl

       \ Nodes to /tmp directory
         " '/tmp' chdir" cluster_run

       \ Nodes inherit the head node's usrpath:
         usrpath quoted " usrpath_set" cat cluster_run
      ELSE
         " myNET: cluster acknowledgement failed" ersys
      THEN
   end
{
   Word mySERVERS allows a client window to start a number of servers
   in server windows to work with the program on the same machine.

   If not X11, or VISIBLE in mySERVERS is banked to no, the servers
   will be running but not visible.

   If the servers are visible, they will be started in keyboard mode
   so each can respond to key strokes.

   This is a great word for developing code on a serial machine that
   will run as-is on a real cluster.  The window from which mySERVERS
   is run acts as the head node, and the servers act as the cluster
   nodes.

   If the cluster node windows are visible, then the keyboard works in
   them too, something that may not be possible on a real cluster.
}
   inline: mySERVERS (n --- f) \ start n nodes running for client
\     Start up to 12 nodes running.
\     Patterned after cluster_start in file test/cluster.

      [ 3 "SEC" book       \ seconds to idle to start 2 servers
        12 "Nmax" book     \ max servers

        yes "VISIBLE" book \ this will make windows and start keyboards
      \ Note: to make servers that do not show, bank no for VISIBLE:
      \    no "mySERVERS" "VISIBLE" bank

        "-geometry 50x8+450+0"   "GEOM1" book
        "-geometry 50x8+450+150" "GEOM2" book
        "-geometry 50x8+225+0"   "GEOM3" book
        "-geometry 50x8+225+150" "GEOM4" book
        "-geometry 50x8+0+0"     "GEOM5" book
        "-geometry 50x8+0+150"   "GEOM6" book

        "-geometry 50x8+450+300" "GEOM7" book
        "-geometry 50x8+450+450" "GEOM8" book
        "-geometry 50x8+225+300" "GEOM9" book
        "-geometry 50x8+225+450" "GEOM10" book
        "-geometry 50x8+0+300"   "GEOM11" book
        "-geometry 50x8+0+450"   "GEOM12" book

      \ Assuming the same machine, different ports must be used:
        9877 (nPort1)
        Nmax qdx 1 
        DO (nPortI) dup "PORT" I suffix book tic LOOP drop
{
        This is where server window k falls for GEOMk defined above:
              5  3  1
              6  4  2
             11  9  7
             12 10  8

        List START_ORDER defines the order to start the Nmax (=12)
        windows.  If START_ORDER contains consecutive numbers from 1
        to 12 (default), then the windows will appear as above.

        Example: to start 4 servers at positions 1, 2, 7, 8:

           list: 1 2 7 8               \ for 4 servers
                 3 4 5 6 9 10 11 12 ;  \ just place holders to make 12
           "mySERVERS" "START_ORDER" bank 4 mySERVERS
}
        1st Nmax items "START_ORDER" book \ default
      ]
      (n) Nmax min "N" book

      "cluster_connect" exists?
      IF "cluster_connect" "HOST" yank any?
         IF (hHOST) drop
            " mySERVERS: cluster is running" dot nl true (f) return
         THEN
      THEN

    \ Must find script tserv that runs this program as a server:
      usrpath "tserv" catpath filefound not
      IF " mySERVERS: require script tserv at usrpath: " usrpath cat
         ersys false (f) return
      THEN
      "TSERV" book

    \ Include clu.v now, instead of when this file is sourced at start
    \ up, so clu.v words do not get loaded behind the fence where they
    \ cannot be replaced (may want to replace word cluster_start):
      "USE_PORT" missing IF "clu.v" source THEN cluster_initialize

    \ Waited until now to make GEOMS and PORTS, in case different GEOMx
    \ strings or PORTx numbers were banked:
      Nmax qdx one DO "GEOM" I suffix local LOOP Nmax pilen "GEOMS" book
      list: Nmax qdx one DO "PORT" I suffix local LOOP end  "PORTS" book
{
[tops@clacker] ready > 'mySERVERS' 'PORTS' yank .i
 Column 1:
   9878   9879   9880   9881   9882   9883   9884   9885   9886   9887
   9888   9890

   [tops@clacker] ready > 'mySERVERS' wholib
 Stack items in the library of word mySERVERS:
  Name              Rows Cols Bytes Type  Description
...
  GEOM1             1    20   20    STR   string
  GEOM10            1    22   22    STR   string
  GEOM11            1    20   20    STR   string
  GEOM12            1    20   20    STR   string
  GEOM2             1    22   22    STR   string
  GEOM3             1    20   20    STR   string
  GEOM4             1    22   22    STR   string
  GEOM5             1    18   18    STR   string
  GEOM6             1    20   20    STR   string
  GEOM7             1    22   22    STR   string
  GEOM8             1    22   22    STR   string
  GEOM9             1    22   22    STR   string
  TSERV             1    21   21    STR   string
  GEOMS             12   22   264   VOL   volume
...
  PORT1             0    0    8     NUM   9878
  PORT10            0    0    8     NUM   9887
  PORT11            0    0    8     NUM   9888
  PORT12            0    0    8     NUM   9889
  PORT2             0    0    8     NUM   9879
  PORT3             0    0    8     NUM   9880
  PORT4             0    0    8     NUM   9881
  PORT5             0    0    8     NUM   9882
  PORT6             0    0    8     NUM   9883
  PORT7             0    0    8     NUM   9884
  PORT8             0    0    8     NUM   9885
  PORT9             0    0    8     NUM   9886
...
}
    \ Make strings to run shells for all Nmax windows, since any subset
    \ of them might be started by list START_ORDER:
      Nmax qdx one
      DO TSERV " -port " cat 
       \ If server is running here, nextport causes bump in values:
         PORTS I pry nextport
         dup PORTS I poke                \ override Ith with nextport
         dup "PORT" I suffix book        \ and named override PORTi
         dup 1+ PORTS I 1+ Nmax min poke \ and make (I+1)st one greater
         intstr + " &" +
      LOOP (qPORT1 ... qPORTn)
      Nmax pilen "shell_run" book
{
Here are all the shell scripts in shell_run, just created:

[tops@clacker] ready > 'mySERVERS' 'shell_run' yank .
/opt/mytops/usr/tserv -port 9878 &
/opt/mytops/usr/tserv -port 9879 &
/opt/mytops/usr/tserv -port 9880 &
/opt/mytops/usr/tserv -port 9881 &
/opt/mytops/usr/tserv -port 9882 &
/opt/mytops/usr/tserv -port 9883 &
/opt/mytops/usr/tserv -port 9884 &
/opt/mytops/usr/tserv -port 9885 &
/opt/mytops/usr/tserv -port 9886 &
/opt/mytops/usr/tserv -port 9887 &
/opt/mytops/usr/tserv -port 9888 &
/opt/mytops/usr/tserv -port 9889 &
}
      N 1st \ start the first N items listed in START_ORDER:
      VISIBLE X11 and
      IF DO GEOMS START_ORDER I pry quote "nodewin" "GEO" bank
            shell_run START_ORDER I pry quote nodewin 
            1 idle \ delay a second in case order matters for overlaying
         LOOP
      ELSE DO shell_run START_ORDER I pry quote nullshell LOOP
      THEN

    \ Make a JOBS array for word cluster_start (clu.v), even though we
    \ are not using it (starting instead the cluster by phrases here),
    \ and bank it there so other cluster words will find it when they
    \ look for it:
      N 1st \ using local loopback IP address:
      DO IPloop spaced PORTS START_ORDER I pry pry int$ cat (qJOBi)
      LOOP (qJOB1 ... qJOBn)
      N pilen (qJOBS) "cluster_start" "JOBS" bank

    \ For two servers, want to idle for SEC seconds; for Nmax servers,
    \ want to idle for SEC*4.  Interpolate the seconds to idle for N
    \ servers:
      list: two, Nmax ; (X) list: SEC, SEC four * ; (Ysec) park (hXY)
      N lerp ontop (sec)

      (sec) " Idle "
      that "%0.1f" format " seconds while cluster servers start..."
      cat cat dot
      (sec) idle
      " done" . nl

      " Connecting cluster servers..." .
      cluster_connect
      " done" . nl

      cluster_ack (f1) \ acknowledgment from all the servers

    \ Rows in JOBS must equal rows in sockets list (here and in
    \ word cluster_ack):
      "cluster_start" "JOBS" yank rows
      "cluster_ack"   "ACK"  yank rows = (f2)

      (f1 f2) and (f)

      IF " mySERVERS:" dot N .i " servers are connected" dot nl
         VISIBLE X11 and
         IF "no catmsg 'key.v' source" cluster_run \ install keyboard
            one idle \ pause for a second
         THEN

       \ On the servers, install PORTS into word mySERVERS if the word
       \ exists:
         localsockets rows 1st
         DO "'mySERVERS' exists? (f) remotefd remoteputmat" (qS)
            (qS) localsockets I pry remoterun1 ontop (f)
            IF "mySERVERS" "PORTS" yank (hA)
               localsockets I pry remoteputmat
               "'mySERVERS' 'PORTS' bank" (qS)
               localsockets I pry remoterun
            THEN
         LOOP

         true
      ELSE
         "cluster_ack" "ACK" yank (hACK) any?
         IF (hACK) " mySERVERS: failed to connect all servers" dot nl
            "   the following sockets are connected:" dot nl
            (hACK) .m
         ELSE " mySERVERS: failed to connect any servers" dot nl
         THEN
         false
      THEN (f)
   end

   inline: SPEED_LOG ( --- ) \ Internet speed fetching bytes
\     Test Internet speed fetching bytes and add to log.
\     This word can be run periodically in the multitasker to make a
\     running log of network speed.
      [ "HOME" env "SPEED.LOG" catpath "SPEED" book ]
      "http://www.weather.gov" "/" "HTTPget" >stk (hHtml hT) lop 
      (hT) dup "received" grepr (hR) any?
      IF (hT hR) reach (hT)
         "HTTPget: received" "" strp neat spaced date +
         SPEED append
      THEN
   end

\-----------------------------------------------------------------------

\  Connecting to the Internet 
{
   The following word demonstrates nested use of word local to run
   phrases placed on the stack.

   For machine clacker (and perhaps others), "local" runs the inline
   "C_LINE" that decides which phone line based upon hour and day of
   week.  Within C_LINE is another instance of "local" to run either
   inline "LINE1" or "LINE2."

   Other machines simply run "local" once to run the inline they have
   been set to always run, either "LINE1" or "LINE2."
}
   inline: _WWW ( --- ) \ a user word for connecting
{     This word uses dial up words in file web.v.  It assumes that my
      phone numbers are defined in word PORT_LIB in usr/pppcon.v.

      File sys/pppcon.v gives a template for making file usr/pppcon.v
      for a specific user.

      Behavior can be changed by banking other strings into USE or ISP
      before running this word.

      Here are some examples:

         My pppcon.v defines two ISPs: "earthlink" and "prodigy."  Here
         is forcing their use:
            for earthlink: "earthlink" "_WWW" "ISP" bank
              for prodigy: "prodigy" "_WWW" "ISP" bank

         The default for line to use is USE equal to "LINE2."  Here is
         forcing the use of my line 1 or line 2:
            line 1: "LINE1" "_WWW" "USE" bank
            line 2: "LINE2" "_WWW" "USE" bank
         The inlines below only do something if ATD has patterns -81-
         or -82-).

         Here are other ways to define USE:
         To force the use of clacker's schedule for a line (see below):
            "C_LINE" "_WWW" "USE" bank

         To choose a line using a custom word, like "MY_LINE," use
            "'MY_LINE' main" "_WWW" "USE" bank

         This last one is interesting because _WWW is running a word in
         the main library, MY_LINE, which is probably a word that was
         unknown when _WWW was sourced at start up.
}     [
        "earthlink" "ISP" book \ initial ISP

      \ Words LINE1 and LINE2 are run to set the ATD prefix in the
      \ phone numbers within word PORT_LIB that go to the modem:
        {"
           "PORT_LIB" "PhoneNumbers" yank "-82-" "-81-" replace$
           "PORT_LIB" "PhoneNumbers" bank
        "} "LINE1" inlinex
        {"
           "PORT_LIB" "PhoneNumbers" yank "-81-" "-82-" replace$
           "PORT_LIB" "PhoneNumbers" bank
        "} "LINE2" inlinex
      \ If phone number strings do not have line prefixes of the form
      \ -81- or -82-, then words LINE1 and LINE2 change nothing.

      host "clacker" alike
      host "rugger"  alike or
      host "riggo"   alike or

      IF {" This is clacker's schedule for a line.

       \ These machines use line 2 except on weekdays before 6 PM
       \ when they use line 1:

            "weekday" missing \ text below needs word weekday
            IF CATMSG push no catmsg
              "cal.v" source
              pull catmsg
            THEN

            date sysdate (YYYMMDD HHMMSS) \ current date and time

            180001 < \ is it before 6 PM?

            IF (YYYMMDD) weekday (n) 2 6 (Mon Fri) within \ a weekday?

               IF "LINE1"   \ use line 1 before 6 PM on weekdays
               ELSE "LINE2" \ use line 2 any weekend day
               THEN

            ELSE (YYYMMDD) drop "LINE2" \ use line 2 any day after 6 PM
            THEN
            (qLine) local \ run word LINE1 or word LINE2

         "} (hT) "C_LINE" inlinex

         "C_LINE" (qS)

      ELSE \ plunger always uses line 2
       \ Other machines always use line 2 (see note above to override):
            "LINE2 (qLINE)" (qS)

      THEN (qS) "USE" book
      ]
      www_open
      IF " _WWW: connected " date neat + . nl return THEN

      CATMSG push no catmsg

      "PPPCON" missing IF "web.v" source THEN
      ISP ISP_config \ using ISP

      pull catmsg

    \ Set up the line to use:
         USE (qS)   \ put phrase to run on the stack
         (qS) local \ run the phrase on the stack, using local lib

    \ Make the connection:
      60 (sec) "_pppconnect" "waiting" bank \ reduce from 120 sec
      pppconnect (f) not
      IF " _WWW: failed to connect " date neat + ersys
      ELSE " _WWW: on " ISP + spaced IPlocal + spaced date neat + . nl
      THEN
   end

   inline: WWW ( --- ) \ a user word for connecting
\     Directing two machines that fight over the phone:
      host "clacker" =
      IF "LINE1" "_WWW" "USE" bank "prodigy" "_WWW" "ISP" bank THEN

      host "plunger" =
      IF "LINE2" "_WWW" "USE" bank "earthlink" "_WWW" "ISP" bank THEN

      _WWW "LAdiff" exists? IF LAdiff drop THEN
   end

\-----------------------------------------------------------------------

\  Matlab for this machine

   "_engOpen" exists?
   IF

   inline: MATLAB ( --- qS) \ the command string to start Matlab
      [ host "bach" alike \ example of remote login to host hayden:
        IF "rsh hayden 'export DISPLAY="   \ the machine running Matlab
           "DISPLAY" env "; "              \ your machine's DISPLAY env
           "/usr/local/matlab/bin/matlab'" \ for Matlab on hayden
           cat cat cat
        ELSE
           "/opt/matlab53/lib" is matlab53
           "/opt/matlab65/lib" is matlab65
           "matlab" \ default any machine
           host "anabelle" alike IF drop "matlab65" THEN
           host "chopin"   alike IF drop "matlab53" THEN
           host "motzart"  alike IF drop "matlab53" THEN
        THEN (qS) spaced makes S
      ] S
   end

   THEN

\-----------------------------------------------------------------------

\  Making an environmental variable of syspath if there is none:
   "TOPS_SYSPATH" env chars 0=
   IF "TOPS_SYSPATH=" syspath cat setenv THEN

\  Get an initial mem value to which the next will be relative:
   memprobe1 drop 

   " info: sourcing " syspath "uboot.v complete" + + . nl 
