File server.v  January 2006

Copyright (c) 2006   D. R. Williamson

This is the server for interacting with a web browser.

Server words for remote login and running.
Words for Xserver and Xhost.
Requires file term.v.

References:
   (All http links tested ok 2-20-2006.)

   1. Williams, Paul, "A Parser for DEC's ANSI-compatible video
      terminals," last update September 2001:
         http://www.vt100.net/emu/dec_ansi_parser

   2. Bourke, Paul, "ANSI Standard (X3.64) Control Sequences for
      Video Terminals and Peripherals," March 1989:
         http://astronomy.swin.edu.au/~pbourke/dataformats/ansi.html

   3. _______, "ANSI/VT100 Terminal Control Escape Sequences,"
         http://www.termsys.demon.co.uk/vtansi.htm

   4. Smith, J., "Summary of ANSI Standards for ASCII Terminals,"
      May 1984:
         http://www.inwap.com/pdp10/ansicode.txt

   5. File term.v.

   Reference 1 is the basis for vtparse3 used to parse escape sequences
   into commands; Reference 4 is a very complete summary of ANSI escape
   sequence definitions from ANSI standards X3.4-1979.

------------------------------------------------------------------------

   Copy and paste these phrases to make a list of words in this file
   (there will be many duplicates due to existing tables of contents):

      usrpath "server.v" + asciiload this " inline:" grepr reach 
      usrpath "server.v" + asciiload 
      these 1st 10 items catch "function" grepr reach 
      pile left justify notrailing 3 indent dot
 
------------------------------------------------------------------------

   Testing.

   How to use tops/usr/telserver and tops/usr/telclient to view the
   VT100 escape sequences sent to a client:

   1. From the tops ready prompt, run the telserver script to start
   a telnet server in the interactive session, then turn on ntrace.

   This shows starting the server, and connection by the client in
   step 2:

      [dale@clacker] /home/dale > tops
               Tops 3.0.1
      Mon Feb 20 21:19:44 PST 2006
      [tops@clacker] ready > >> psource("telserver");
      >> ntrace sane clients
       settings made by ureset are:
        1based, ok on, private, strict, stkbal, xl, yes catmsg, -kon
       Server local is listening on port 9891
       No clients

   This shows client connecting when step 2 is run:
      >> 
      Mon Feb 20 21:20:35 PST 2006 SERVER: connection from 127.0.0.1
       1108044 bytes delta: memprobe socket 3 connect
       TELNETD_CONNECT: new client on socket 3

   After client has connected (step 2), run this phrase to redirect 
   bytes through ROUTER1, so trace of parsed escape sequences can be 
   seen in ntrace:

      << "ROUTER1" ptr "TELNETD_CONNECT" "S1" yank ptrRun_upd >>

   2. Run telnet client from the Unix command prompt in another window.
      This shows logging on to the server started in step 1 (listening
      on port 9891 as shown above):

      [dale@clacker] /home/dale > telclient -port 9891
      login: dale
      Password: 
      Last login: Mon Feb 20 21:11:09 on tty1
      [dale@clacker] /home/dale > cd /tmp
      [dale@clacker] /tmp > ls
      kaffia.log  msgcomm  orbit-dale/  rioja.log     stel.log
      malaga.log  msghold  orbit-root/  rufysnow.log  vesuvio.log
      [dale@clacker] /tmp > 

   Commands from the client of step 2 are seen in the server window of
   step 1 as they are sent to telnetd.  Then response being relayed
   from telnetd to client is seen, which is in the form of one or more 
   VT100 escape sequences.

   This shows the escape sequences (strings that begin with 0x1B) that
   are sent back to the client when :q is keyed to exit the vi editor.
   Escape sequences needed to clear regions of the screen and redisplay
   the command prompt are being transmitted:

 ROUTER: receive from socket 7 send on socket 3
 remoteputf: writing 50 bytes to socket 3
       0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F  0123456789ABCDEF
   0  0D 00 1B 5B 3F 32 35 6C 1B 3E 1B 5B 3F 32 35 68  ...[?25l.>.[?25h
   2  1B 5B 32 4A 1B 5B 3F 34 37 6C 1B 38 5B 64 61 6C  .[2J.[?47l.8[dal
   4  65 40 63 6C 61 63 6B 65 72 5D 20 2F 74 6D 70 20  e@clacker] /tmp
   6  3E 20 00 00 00 00 00 00 00 00 00 00 00 00 00 00  > ..............
 2273 microsec delta: end remoteputf

Sequence from above ( . = 1B):
   .[2J .[?47l .8[dale@clacker] /tmp> 

From /etc/termcap (\E = 1B):
   te=\E[2J\E[?47l\E8 

------------------------------------------------------------------------

This is the server for interacting with a web browser.  Companion files
on the browser are usr/Xclient.html and usr/Xclient.js.

Words continuing from I and II of term.v.

III. Words for serving a web client: Xserver layer.

   Xserver spends most of its time routing bytes between Xclients and 
   their Xhost nodes.  On a cluster, Xserver is the head node.

   These are the Xserver words:
   inline: jslist ( --- hT) \ listing of Xclient JavaScript
   inline: WebInput (qT nS --- ) \ route input from Xclient to Xhost
   inline: XclientConnect (qT nS1 --- ) \ connect to client on socket S1
   inline: XclientLogin (qT nS2 --- ) \ router while Xclient logs in
   inline: XclientReconnect (qXhost nS --- ) \ reconnect Xclient to S
   inline: XhostClose (nS2 --- ) \ tasks when Xhost(S2) closes
   inline: XhostName (nS --- qHost) \ name of Host that owns socket S
   inline: XhostOutput (qT nS2 --- ) \ router from Xhost(S2) to Xclient
   inline: XhostPick ( --- qName) \ pick an Xhost that is not busy
   inline: XhostStart (qIP nPORT qName --- qList) \ start Xhost server
   inline: XMLtemplate ( --- qT) \ template for XML text to Xclient
   function Xserver(PORT_IN) /* start Xserver listening on PORT_IN */
   inline: XserverOutput (qT nS1 --- ) \ send T as HTML to Xclient on S1


                Web  
      Xclient(a)      Xclient(b): client of Xserver
         |               |
     ____|______SSL______|____  
         |               |
         |_____     _____|
               |   |
            S1a|   |S1b
               |   |
              Xserver: Server for Xclients, client of Xhosts
               |   |
            S2a|   |S2b
          _____|   |_____ 
         |               |
         |     Nodes     |
         |               |
      Xhost(a)        Xhost(b): Server for Xserver, client of telnetd(b)
         |               |
         |               |
      telnetd(a)      telnetd(b): Server for Xhost(b)

                   Figure: Xserver network


   Looking from top to bottom in the figure above:

      Xclient is the highest level client, and is only a client.  When
      on the Internet, each Xclient is separated from the server, Xser-
      ver, by the SSL (Secure Socket Layer) protocol.

      Xserver is a server for each Xclient, but a client of all the 
      Xhost nodes.  Xserver starts an Xhost node when an Xclient con-
      nects during the pre-login phase.
 
      Xhost nodes are servers to Xserver, and clients of the telnetd
      daemons they start.

      Telnetd daemons are the lowest level servers, and they are only
      servers.

      Any element in the figure that has one element directly above it 
      is a server for that element, and indirectly, a server for all 
      elements above that one.  

      Elements that are servers, such as Xserver, Xhost nodes, and 
      telnetd daemons, have a listening socket so clients can connect.  

   See Appendix for notes on Xserver closing.
 
   Xserver Words

   "CONNECT" missing IF " Networking words are required" . halt THEN

   inline: jslist ( --- hT) \ listing of Xclient JavaScript
\     Listing as sent to Xclient, for line numbers when debugging.
\     Usage: jslist eview
      "hostname" "XclientConnect" "Xhtml" yank
   end

   inline: WebInput (qT nS --- ) \ route input from Xclient to Xhost
{     This word services all bytes from Xclients.  It was given this 
      task by the phrase

         SERVE_F.SERVICE=ptr("WebInput");

      that was run in function Xserver() at start up.  

      Function SERVE_F(), where SERVICE() resides, is central to the 
      program running TCP/IP to serve foreign clients.  SERVE_F() is 
      run by drainf() in net.c when bytes arrive from a foreign client,
      and by clientmake() and clientclose() in term.c when foreign 
      clients connect and close.

      The figure below shows the network with Xserver in the middle, a 
      logged-in Xclient on the left and its Xhost node on the right.

      The permanent socket to Xclient, S1, is a one-way connection 
      where bytes from Xhost to Xclient are relayed by Xserver word 
      XhostOutput().  

               SSL                       SSL 
             Encrypt                   Decrypt
                |                         |
                |-----------S------input->|  Xserver machine  |
            Web |                         |                   | Xhost
        Xclient |        Internet         |<---S2(Xclient)--->| node
                |                         |                   | machine
                |<---S1=RTAB(S2)--output--|                   |
                |                         |             Secure Network
               SSL                       SSL 
             Decrypt                   Encrypt

      This network defines the complete circuit of a key press that 
      originates on Xclient.  Xserver is serving a number of Xclients,
      and the network for each is like the one shown above.  

      The notes below describe how sockets S1 and S2 are determined for
      processing this input T received from an Xclient on arbitrary 
      socket S.

      Xclient input T is relayed from here to Xhost over socket S2.  
      This is how S2 is determined:

         T from Xclient contains the name of the Xhost node that is
         serving Xserver for this Xclient.  This Xhost node name was 
         given to Xclient during pre-login; word XclientConnect() per-
         forms the two-phase connection and login.  

         Function FetchSocket() in word XhostName is used to get socket 
         number S2 for the Xhost node name taken from T: 

            S2 = XhostName.FetchSocket(Host(T));

      Response from Xhost to Xclient input T is relayed back to Xclient
      over socket S1.  This is how S1 is determined:

         Socket S1 is a permanent socket that was established when
         Xclient successfully logged in after requesting the C (con-
         nect) method for the Xhost node host name given to it during
         pre-login (word XclientConnect()).

         Upon successful login, the pairing of sockets S1 and S2 was
         saved in table RTAB in function XhostOutput().  Now, when
         Xhost sends a response back to Xserver on S2, bound for
         Xclient, the response comes to XhostOutput() where RTAB(S2)
         provides S1 for sending it to Xclient:

            S1 = XhostOutput.RTAB(S2);

      Socket S1 is permanent because, for a single request, it is not 
      known how many times Xhost will be sending bytes for XhostOutput 
      to relay to Xclient.  These are some cases where more than one 
      instance of bytes from Xhost will be sent to Xclient:

         After successful login password, the "last login" message
         comes first, followed separately by the user prompt, all
         due to Xclient hitting Enter after the last password key.

         Running ls on a directory with many file names can produce
         several separate groups of bytes from Xhost to Xclient.

         Running top to look at processor activity will cause Xhost
         to send bytes every 5 seconds or so until Xclient hits the
         key to quit.

         On log out, a "logout" string is sent followed by escape
         sequence "H0J2" to clear the screen, followed by a "Con-
         nection closed by ..." string.

      If S1 is closed too soon, the failure to have a valid socket for
      additional Xhost bytes such as those cited above will cause Xhost
      to close.  

      So S1 remains permanent until logout or until Xclient requests a 
      reconnection (word XclientReconnect()).

      These are the readyState states of an XMLHttpRequest on Xclient
      (Xclient is running JavaScript usr/Xclient.js):

         readyState:
            0 = uninitialized
            1 = loading
            2 = loaded
            3 = interactive
            4 = complete (socket is closed)

      By keeping socket S1 open, the readyState on Xclient is never
      higher than 3 throughout a session.

      When S1 is finally closed and there is no other open socket from
      Xclient, readyState 4 will be reached.  This is when Xclient has
      logged out.
}
      [ 128 "BYTES" book \ max bytes needed from an Xclient socket
        0.01 "SEC" book \ period to idle between Xclient key inputs

        {"  ABORT method
\           Processing a command from Xclient.  T contains command A
\           plus host name, as in: A /malaga
            K

        "} "A" macro

        {"  CONNECT method
{           Step 2, Login to Xhost node.  T contains browser type and 
            pre-login-assigned host name, such as: CM /kaffia (browser 
            type can be M (Mozilla) or I (IE)).

            Connect to running node XhostName to perform login:
}           (qT nS) XclientConnect 

        "} "C" macro

        {"  GET method
{           Step 1, pre-login.  T contains: GET /login
            Xclient is connecting for the first time.  XclientConnect()
            will select an Xhost node and send message Xhtml to Xclient.

            Xclient will be connecting again to respond to Xhtml, but
            phrase "no READY" has suspended server listening (requests 
            will just sit in the socket) so the connecting Xclient does
            not interrupt the start up of Xhost node, which will take a
            few seconds.

            Send pre-login Xhtml, close socket S, and start Xhost node:
}           
            no READY \ suspend incoming until Xhost node is started
            (qT nS) XclientConnect

        "} "G" macro

        {"  KEY method
{           Processing a key from Xclient.  

            String K on the stack contains one key number and the name 
            of Xhost, such as: K101 /malaga
}
            (qK nS) sclose (qK)

\           Set up for Xhost method T:
            (qK) "T" that 1st word drop (qK) -1 indent 
            (qT qChar) number drop export1 + (qT) \ K101 becomes Te
            
            swap (qHost) 2nd word drop (/malaga) -1 indent (qXhost)

\           Find socket to the Xhost node that is serving this Xclient:
            (qT qXhost) "XhostName" "FetchSocket" yank (nS2) any?

            IF (qK nS2) remoteputf0 \ send K to Xhost node

            ELSE \ An old connection not properly closed--keys still
             \ come:
               (qK) drop
            THEN

\           Flow control:
            \\\\\ SEC idle \ control Xclient abusive keyboarding

        "} "K" macro

        {"  RECONNECT method
\           Reconnecting Xclient.
\           T contains R and host name, such as: R /malaga

            (qT nS) XclientReconnect

        "} "R" macro

        {"  SIZE method
\           Browser window has been resized.

\           T contains rows:cols, such as: S24:80 /malaga

            (qT nS) sclose

            (qT) this 1st word drop (qSR:C)
            swap 2nd word drop (/malaga) -1 indent (qXhost)

          \ Find socket to the Xhost node that is serving this Xclient:
            (qSR:C qXhost) "XhostName" "FetchSocket" yank (nS2) any?

            IF (qSR:C nS2) remoteputf0 \ send S to Xhost node
            ELSE 
             \ An old connection not properly closed--keys still come:
               (qSR:C) drop
            THEN

        "} "S" macro

        {"  TEXT string method

{           T contains counted string: TBBbbString... /hostname
            where BBbb is the two byte count, followed by a string of
            BBbb bytes.  In addition, a blank space and /hostname must
            follow String:
               TBBbbString... /hostname (hostname 8 bytes or less)

            This shows the example above with bytes labeled "x" that
            are required in addition to counted String (there are 15
            of them for the maximum sized hostname of 8 bytes):
               TBBbbString... /hostname (hostname 8 bytes or less)
               xxxxxString...xxxxxxxxxx
}           [ 15 "addons" book \ "x" bytes required as shown above
               8 "maxhost" book 
            ]
\           Put the counted string on the stack and run Xhost
            (qT nS) push
            dup  2nd 2 items catch (BB) hexbytes uimport1 256 * 
            over 4th 2 items catch (bb) hexbytes uimport1 + @ \ count
            dup addons + other chars >
            IF " WebInput: insufficient T bytes for" . .i 
               " chars from client" . nl (qT) drop

            ELSE (count) push (qT) dup 6 ndx peek items catch (qS)
              "T" swap + (qS)

              swap (qT) pull (count) maxhost + ndx 
              maxhost items catch (hostname) 
              "XhostName" "FetchSocket" yank (nS2) any?
              IF (qS nS2) remoteputf0 THEN \ send string S to Xhost

            THEN pull sclose

        "} "T" macro

        {"  UNKNOWN method, unknown Xclient
\           Close connection:
            (qT nS) " WebInput: unknown method " . swap (qT) . nl
            (nS) push " WebInput: closing socket " peek intstr + . nl 
            pull sclose
        "} "U" macro
      ]
\     Process incoming method from an Xclient on socket S.

\     Require BYTES or more when socket is read. 
      (qT nS) those chars BYTES >=

      IF that (qT) 1st catch (qM) this local? \ macro M from local lib

         IF (qT nS qM)         \ M is the macro to run
         ELSE drop (qT nS) "U" \ else use macro U, unknown
         THEN 

      ELSE (qT nS) "U"         \ else use macro U, unknown
      THEN 

      (qT nS qM) local \ run the designated macro from local lib

      yes READY \ put server back in action (G method suspends it)
   end

   inline: XclientConnect (qT nS1 --- ) \ connect Xclient on socket S1
{
      Incoming T has one of these forms:
         Pre-login: GET /login
             Login: CI /rufysnow (I = IE browser; M = Mozilla, Netscape)

      Connecting an Xclient is done in two phases:

         Pre-login: 
            Xclient sends GET method to Xserver on socket S1.  

            Xserver sends html with NAME=XhostPick() to Xclient on S1, 
            and then closes S1.

            Xserver starts an Xhost node server (word XhostStart), then
            closes the connection to it after noting the IP address and
            PORT for future connection when this Xclient connects again
            to log in.  The Xhost node server runs for up to 30 seconds
            waiting for Xclient login (ALARM set by XhostStart).

         Login: 
            Xclient connects to Xserver on socket S1 with C (connect)
            method, requesting Xhost(NAME) (S1 is probably not the same
            socket S1 used in pre-login).  

            Xserver connects as a FOREIGN client to listening server 
            Xhost(NAME) on IP address and PORT saved from pre-login.  
            The connected socket, S2, is probably not the same S2 as 
            in pre-login. 

            Xserver records the link between socket S1 to Xclient and 
            socket S2=XhostName.FetchSocket(NAME) to Xhost node in  
            table XhostOutput.RTAB.

            Socket S1 from Xserver to Xclient and socket S2 between
            Xserver and Xhost node will last until logoff. 

            After connecting to Xhost node (CLIENT_F) and setting up 
            the connection tables, this word relays incoming T from 
            Xclient to Xhost(S2) to kick off the login process.
}
      [ 100 "MAX_XCLIENTS" book \ max Xclients

      \ This local word, Xhtml, prepares the html+javascript sent to
      \ the client in the pre-login phase.

      \ To see the script sent to Xclient of host kaffia, run: 
      \    >> eview(XclientConnect.Xhtml("kaffia"));

      {" Xhtml (qHOST --- qS) \ JS(HOST) into HTML, return STR with NLs
         (qHOST) push
         usrpath "Xclient.html" + asciiload notrailing (HTML)
         "JAVASCRIPT HERE" (qS1)

         usrpath "Xclient.js" + asciiload notrailing (hT) "JS" book
         JS dup "CLIP HERE" grepr 1+ JS rows : reach 

         "ID" pull (qT qS1 qHOST) strp (qT) 
         "*ok" 400 intstr (qT qS1 qS2) strp (qT) 

         9 indent notrailing textput (qS2) \ JS
         (HTML qS1 qS2) strp (qT)

         textput (qS)  \ STR with new lines
         CRLF CRLF + + \ 0D 0A 0D 0A
      "} "Xhtml" macro

      { Since socket numbers S are small integers (and not equal to 
        zero due to other sockets already defined), let each socket
        number be the index in the RTAB array in XhostOutput.  This 
        local macro, VALID, checks these assumptions:
      } {" (nS --- nS) returns if valid, HALTs if invalid
           (nSocket) "XclientConnect" "MAX_XCLIENTS" yank
           that < that 0< or
           IF (nS) " XclientConnect: socket number " over intstr +
              " is invalid to use for an index" + ersys 
              (nS) sclose HALT
           THEN (nS)
        "} "VALID" macro

      \ The following text is run by a temporary server, through word
      \ TASK_PORT, to start an Xhost node that will serve an Xclient:
        {" XHOSTSTART ( --- qList) \ start Xhost node, return param list
           "server.v" "Load XhostStart" msource 
           Sec1 "XhostStart" "WSEC" bank
           Sec2 "XhostStart" "FDELAY" bank
           host IPhost serverport "HOST" XhostStart (qList)
        "} chop textput "XHOSTSTART" book

      \ Timing data for XHOSTSTART:
        0.1 (sec) "FDELAY" book \ delay Xhost start until DSERVER forks
        5 "WSEC" book           \ Xhost start up time

        "/tmp/index.html" "DOC" book
      ]
      (nS1) VALID "S1" book

    \ Incoming T on stack is a string like: CM /malaga
      (qT) any?
      IF (qT) this 1st catch "C" = 

         IF \ Login phase.  Xclient has sent back pre-login XhostName.

          \ Incoming T on stack is a string like: CM /malaga
            (qT) this 2nd word drop -1 indent (/ remove) chop (qXhost)

          \ Connect to running XHost node started at pre-login:
            (qT qXhost) 
            this "XhostName" "FetchIP" yank (qIP) any? not

            IF (qT qXhost) \ pre-login must have failed:
               " XclientConnect: requested Xhost " . (qXhost) dup .
               " is not running" . nl 

               (qHost) "Host " swap + " is not available" + 
               (qMessage) S1 XserverOutput S1 sclose 

               (qT) drop return
            THEN

            (qT qXhost qIP)
            that "XhostName" "FetchPort" yank (nPORT)

            "XclientLogin" ptr "CLIENT_F" "set_CONN" bank \ byte handler
            (qIP nPORT) CLIENT_F (nS2) any? not           \ connecting

            IF (qT qXhost) 
               " XclientConnect: failed to connect to Xhost " 
               . (qXhost) dup . nl 

               (qHost) "Host " swap + " is not available" + 
               (qMessage) S1 XserverOutput S1 sclose 

               (qT) drop return
            THEN 

          \ Connected to Xhost.  Do set ups:
            (qXhost nS2) VALID "S2" book
            (qXhost) S2 "XhostName" "StoreSocket" yank

          \ Set table RTAB in XhostOutput for paired S1-S2: 
            S1 "XhostOutput" "RTAB" yank (hRTAB) S2 poke \ RTAB(S2)=S1
            S2 "XhostOutput" "RTAB" yank (hRTAB) S1 poke \ RTAB(S1)=S2

          \ Set ptrCls that runs when S2 closes:
            "XhostClose" ptr S2 ptrCls_upd 

          \ Send T to Xhost node on socket S2, and it performs login:
            (qT) S2 remoteputf0 \ to Xhost, start login
 
         ELSE \ Pre-login phase.   

          \ For no error exit, incoming T on stack must be the string: 
          \    GET /login

            (qT) dup "T" book 2nd word (qName)
            IF dup (qName) "/login" =

             \ Pick an Xhost node to support client, send html to 
             \ client and close its socket, then start Xhost node:

               IF (qName) drop XhostPick any? 
                  IF (qHostName) "HOST" book
\                    Send Xhtml(HOST) to Xclient:
                     HOST Xhtml S1 remoteputf \ sending to Xclient
{
                     S1 must be closed before Xhost node is started. 

                     Leaving Xclient socket S1 open while Xhost node is
                     started will link Xclient to Xhost node (and its 
                     telnetd), and S1 cannot be closed until Xhost node
                     and telnetd are closed.

                     S1 is not needed any more now that file Xhtml has 
                     been sent to Xclient, so close S1 right now:
}                    S1 sclose \ close before starting Xhost node

{                    Use a temporary server to start Xhost node and get 
                     its list of parameters, using text XHOSTSTART.  A 
                     temporary, non-SSL server is used so Xhost node can
                     connect easily to pass along its list for Xserver.
}
                     HOST (qHOST)
                     nl " XclientConnect: starting Xhost " . dup . 
                     sp date . nl
                     WSEC 2 * (n) \ max WAIT for TASK_PORT temp server

\                    Place relevant strings into script XHOSTSTART:
                     XHOSTSTART "HOST" HOST strp
                     "Sec1" WSEC   intstr   strp
                     "Sec2" FDELAY "%0.4f" format strp (qScript)

\                    The following will run Script to start Xhost node 
\                    in n sec or less and return List of its parameters:
                     (n qScript) TASK_PORT (qList) any?

                     IF (qHOST qList)
                        " XclientConnect: Xnode host " other (qHOST) +
                        " running " + . date . nl
\                       Store list of parameters from Xhost(HOST) by
\                       running XhostName.StoreHostList(qHOST,qList):
                        (qHOST qList) "XhostName"
                        "StoreHostList" yank

                     ELSE (qHOST) " XclientConnect: failed to start " 
                        . (qHOST) . nl
                     THEN

                  ELSE " XclientConnect: all hosts are busy" . nl
                     "<HTML><BODY>" 
                     "All hosts are busy" + CRLF CRLF + + 
                     "</BODY></HTML>" + CRLF CRLF + +
                     S1 remoteputf \ sending to Xclient

                     S1 sclose
                  THEN
               ELSE (qName) DOC -path = 
                  IF DOC file?
\                    Service a request for HTML file named DOC.

                     IF DOC old ascii "ASC" file 
                        ASC INF fget (hT) ASC fclose
                     ELSE 
                        "<HTML><BODY>" 
                        "Requested file not found" + CRLF CRLF + + 
                        "</BODY></HTML>" + CRLF CRLF + +
                     THEN
                     S1 remoteputf \ sending to Xclient
                     S1 sclose
                  ELSE " XclientConnect: invalid request: " . T . nl
                     "<HTML><BODY>" 
                     "Invalid request" + CRLF CRLF + + 
                     "</BODY></HTML>" + CRLF CRLF + +
                     S1 remoteputf \ sending to Xclient
                     S1 sclose
                  THEN
               THEN
            ELSE " XclientConnect: empty request" . nl 
               S1 sclose
            THEN
         THEN
      ELSE S1 sclose \ empty T
      THEN
   end

   inline: XclientLogin (qT nS2 --- ) \ router while Xclient logs in
{     During login, this word routes bytes to Xclient while looking for
      FLAG from Xhost(S2) that login is successful.  

      Note that S2 is the socket from Xhost, not the socket to Xclient.

      On the initial transmission from Xhost to Xclient, when the login
      prompt is being sent, the HTTP header is sent first as Xclient
      begins a new XMLHttpRequest.  The first transmission to Xclient 
      is defined by LOGGED(S2)=0.

      After login, this word sets word XhostOutput as the router of
      bytes from Xhost(S2) to Xclient, and LOGGED(S2) is set to true.

}     [ "XclientConnect" "MAX_XCLIENTS" yank 1 null "LOGGED" book

\       FLAG matches the one in XloginOut() on Xhost node:
        "login_ok" "FLAG" book, FLAG chars "len" book 
      ]

      (nS2) LOGGED that (nS2) pry 0= \ first time on S2 (LOGGED(S2)=0)
      IF 
\        On first time (before sending login prompt), send HTTP header:
         "XMLtemplate" "HEAD" yank that (qT nS2)
         (qT nS2) "XhostOutput" "RTAB" yank swap (nS2) pry (nS1)
         (qT nS1) remoteputf \ sending to Xclient

         (nS2) dup LOGGED that (S2) poke \ LOGGED(S2)=S2
      THEN

      those chars len > 
      IF those 1st len items catch FLAG grepr rows 0> \ have FLAG?
         IF 
\           Matching FLAG means successful client login.
            (qT nS2) push (qT) \ T is from XloginOut() on Xhost node

\           After removing FLAG from T, any remainder is ack for 
\           Xclient; send it on:
            (qT) FLAG "" strp (qT) any? \ replace FLAG with nothing
            IF (qT) peek (nS2) XhostOutput THEN

\           Set XhostOutput to be the word that processes bytes
\           received on S2 from now on:
            "XhostOutput" ptr (ptr_new) peek (nS2) ptrRun_upd

            " XclientLogin: successful client login to "
            peek (S2) XhostName spaced + date + . nl

            true LOGGED pull (S2) poke \ LOGGED(S2)=true until logout
            return
         THEN
      THEN
      (qT nS2) XhostOutput 
   end

   inline: XclientReconnect (qT nS --- ) \ reconnect Xclient to S
{     Xclient reconnect on new permanent socket S.  

      T contains R and host name, such as: R /malaga

      During a session Xclient may start a new XMLHttpRequest to 
      free and reuse the accumulating memory of the old request.  

      Xclient sends method R to reconnect on the very next 0x0D key
      after its response text length, R.responseText.length, exceeds
      the value Rmax (see Xclient.js, function send()).

      Permanent socket S1 that carries XML output to Xclient (see 
      figure in word WebInput) is closed, and socket S incoming on 
      the stack becomes the new "permanent" socket for XML output.

      The socket to Xhost is given by:

         S2 = XhostName.FetchSocket(Xhost); // to Xhost

      and the Xclient socket from the previous connection, which is
      still open, is:

         S1 = XhostOutput.RTAB(S2); // to Xclient

      The following lines change the routing table to route Xhost 
      server node socket S2 to Xclient socket S, remove S1 from the 
      routing table, and close S1.

      Xhost is also informed of the reconnection so it can reset the 
      XML frame count.
}
      (qT nS) "S" book 
      (qT) 2nd word drop -1 indent "HOST" book
      " XclientReconnect: reconnecting Xclient to " HOST + dot nl

      HOST "XhostName" "FetchSocket" yank (nS2) any? not
      IF " XclientReconnect: socket for host " HOST + " not found" +
         dot nl S sclose (qT) drop return 
      THEN

      (nS2) "S2" book   

\     Send XMLtemplate.HEAD to Xclient to start this reply.  Xclient
\     will begin a new XMLHttpRequest:
      "XMLtemplate" "HEAD" yank S remoteputf \ sending to Xclient

\     Inform Xhost to reset frame count:
      "R" S2 remoteputf0 \ sending R to Xhost

\     Fix up references in XhostOutput.RTAB, then close S1.

      "XhostOutput" "RTAB" yank S2 pry "S1" book \ old S1

\     Set table RTAB in XhostOutput for paired S-S2, remove S1 ref: 
      S  "XhostOutput" "RTAB" yank (hRTAB) S2 poke \ RTAB(S2)=S, new S1
      S2 "XhostOutput" "RTAB" yank (hRTAB) S  poke \ RTAB(S)=S2
      0  "XhostOutput" "RTAB" yank (hRTAB) S1 poke \ RTAB(S1)=0, old S1

\     Close S1; S is the new S1:
      S1 sclose 
   end

   inline: XhostClose (nS2 --- ) \ tasks when Xhost(S2) closes
\     Socket S2 to Xhost has closed.  Close socket S1 to Xclient.

\     Do not run this word directly.  It is run by sclose(S2).
  
      (nS2) push

\     Close S1 and void S1 in routing table XhostOutput(RTAB):
      "XhostOutput" "RTAB" yank peek (nS2) pry (nS1) any? 
      IF (nS1) push 0
         "XhostOutput" "RTAB" yank (hRTAB) peek (nS1) poke \ RTAB(S1)=0
         pull sclose \ may already be closed
      THEN

\     XclientLogin.LOGGED(S2)=0:
      0 "XclientLogin" "LOGGED" yank (hHEAD) peek (nS2) poke 

\     XhostOutput.RTAB(S2)=0:
      0 "XhostOutput"  "RTAB" yank (hRTAB) peek (nS2) poke 

\     Invalid entries in XhostName:
      peek (nS2) XhostName dup (qName) any?
      IF (qName) "-1 -1 -1 -1" (List: IP PORT PID TPORT)
         (qName qList) "XhostName" "StoreHostList" yank
         (qName) -1 "XhostName" "StoreSocket" yank
      THEN

      pull (nS2) drop
   end

   inline: XhostName (nS --- qHost) \ name of Host that owns socket S
{     Host is the name of the Xhost node connected to Xserver on S,
      or an empty string if S is not connected to an Xhost node.

      In addition to this word, which returns Host name for given 
      socket S, as in

         Host_name = XhostName(5);
 
      macros in this library perform the following:

         Fetch socket number for given Host name:
            S = XhostName.FetchSocket(qHost);

         Fetch IP address for given Host name:
            IP = XhostName.FetchIP(qHost);

         Fetch port number for given Host name:
            PORT = XhostName.FetchPort(qHost);

         Fetch information list for Host: 
            List = XhostName.FetchHostList(qHost);
            (Items in List are: IP PORT PID TPORT)

         Store Socket number for given Host name:
            XhostName.StoreSocket(qHost, nS);

         Store information list for Host: 
            XhostName.StoreHostList(qHost,qList);
            (Items in List are: IP PORT PID TPORT)
}
      [  seedget time seedset

      \ Names 8 characters long or less:
      {" Host names a to z and more:
         altabar barsac corvo diego etnia falerno gragano hocker 
         infierno julep kaffia lugana malaga nadeen oloroso pomace 
         quiote rioja soave tokay umbra vesuvio wassail xanadu yeoman 
         zucco

         amanaman buffet geo ignition leo maxair meco miter moa momento
         pinion ploa rachet riggo rounder rufysnow stel warp wrench 

      "} words \ mix up the names:
         these rows 1 random 1 those rows : park yes sort 
         2nd catch reach "NAMES" book

       \ For testing, these are always first:
         "rufysnow kaffia malaga rioja stel vesuvio" words NAMES pile
         noq_alike "NAMES" book
{
         3 "N" book \ unique beginning chars

       \ Keep only those with first N characters unique (possible
       \ future restriction):
         NAMES dup 1st N items catch namedupes rake (n0 n1)
         (n1) "NAMES" book (n0) any?
         IF " XhostName: server names rejected" 
            " (1st " + N intstr + " characters are not unique):" +
            dot nl 3 indent . nl
         THEN
}
         seedset

       \ A list of connection properties is kept in a hash:
            32 "HWIDTH" book \ hash_store requires fixed width Vals
            "XhostName" "NAMES" yank (hKey)
            1 HWIDTH blockofblanks those rows repeat (hVals)
            (hKeys hVals) these rows 2 * (nBins)
            "XhostName" "HOST$" localref hash_make

       \ Definitions of paired (Host name, socket number) are kept
       \ in sorted binary lists:
            NAMES vol2mat bend        \ col 1 names
            -1 those rows 1 fill park \ col 2 socket numbers
            yes sort "NAME_LIST" book
         
          \ Swap the columns of NAME_LIST to make SOCK_LIST:
            NAME_LIST 2nd catch 
            NAME_LIST 1st catch park "SOCK_LIST" book
          
       \ Make local macros to store and fetch Xhost information.  Some 
       \ use the hash, others use binary search of the sorted lists:

         {" (qHost --- qIP) \ fetch IP addr for given Host
            FetchHostList any?
            IF 1st word not IF "" THEN ELSE "" THEN
         "} "FetchIP" macro

         {" (qHost --- nPORT) \ fetch listening port for given Host
            these chars 0= IF drop -1 return THEN
            FetchHostList 2nd word IF number drop ELSE -1 THEN
         "} "FetchPort" macro

         {" (qHost --- nS) \ fetch socket number for given Host
            these chars 0= IF drop -1 return THEN
            strchop NAME_LIST over str2num bsearch not
            IF drop " FetchSocket: " swap + 
               " not found in list of Xhosts" + ersys -1 
            ELSE lop NAME_LIST swap 2nd fetch
            THEN
         "} "FetchSocket" macro

         {" (qHost --- qList) \ fetch list for qHost from hash
            (Items in List: IP PORT PID TPORT)
            these chars 0= IF drop "" return THEN
            (qHost) HOST$ swap hash_lookup drop 1st quote
         "} "FetchHostList" macro

         {" (qHost qList --- ) \ store list for qHost into hash
            (Items in List: IP PORT PID TPORT)
            those chars 0= IF 2drop return THEN
            (qHost qList) HWIDTH blpad HOST$ rot
            (qList hHash qHost) hash_store
         "} "StoreHostList" macro

         {" (qHost nS --- ) \ store socket number S for given Host
            those chars 0= IF 2drop return THEN
            swap strchop NAME_LIST over str2num bsearch not
            IF drop lop " StoreSocket: " swap + 
               " not found in list of Xhosts" + ersys
            ELSE lop (nS k) NAME_LIST swap 2nd store
               NAME_LIST 2nd catch NAME_LIST 1st catch park
               yes sort "SOCK_LIST" book
            THEN
         "} "StoreSocket" macro

      ] no NUM stkok not IF "XhostName" stknot return THEN

        (nS) SOCK_LIST over bsearch not
        IF 2drop "" \ return empty string if not found        
        ELSE lop SOCK_LIST swap 2nd fetch num2str strchop
        THEN
   end

   inline: XhostOutput (qT nS2 --- ) \ router from Xhost(S2) to Xclient
\     Receive VT parsed output from Xhost node on S2 and send it to 
\     Xclient on socket S1=RTAB(S2).
      [ 
      \ Routing table RTAB is kept here:
        "XclientConnect" "MAX_XCLIENTS" yank 1 null (hTable)
        (hTable) "RTAB" book \ gets values from XclientConnect

      \ Word XclientConnect() initializes RTAB and XclientReconnect() 
      \ keeps RTAB current if there is a reconnection.
      ]
" Check of socket:" . nl dup socket_check
    \ Wrap T in XML:
      swap
      (qT) XMLtemplate "_TEXT_" rot strp (qT) 
      swap

      (qT nS2) RTAB swap (nS2) pry (nS1)
      (qT nS1) remoteputf
   end

   inline: XhostPick ( --- qName) \ pick an Xhost that is not busy
\     Returned Name is an empty string if no Xhost is available.

\     A host is not busy if XhostName.FetchSocket(Name)=-1.

      "XhostName" "NAMES" yank (NAMES) push

      "" (qEmpty) \ start with empty string on stack
      peek (NAMES) rows 1st 
      DO peek (NAMES) I quote (qName) 
         dup "XhostName" "FetchSocket" yank -1 =
         IF lop EXIT ELSE drop THEN \ EXIT if found one, or try another
      LOOP pull (NAMES) drop
      strchop (qName)
   end
{
   This region enclosed by braces and skipped over in normal sourcing, 
   contains word XhostStart that is loaded by a temporary TASK_PORT 
   server (using msource--see word XHOSTSTART in the library of word 
   XclientConnect) when it is starting an Xhost node server.

   This is why a server other than Xserver is used to start an Xhost
   node: 

   When an Xhost node starts, it contacts the server that started it to
   relay a list of its parameters: IP PORT PID TPORT.  Because Xserver 
   is an SSL protocol server, connecting to its listening socket in-
   volves SSL encryption and decryption.  

   To avoid this complexity for just a simple list, Xserver uses word 
   TASK_PORT to start a temporary server on its machine.  The TASK_PORT
   server starts an Xhost node and receives its list of parameters.
   Before it exits, TASK_PORT returns the list of parameters to the 
   stack of Xserver.  Since Xserver connected to the TASK_PORT server,
   no SSL protocol is involved.

   This is done in word XclientConnect (text XHOSTSTART), where the
   TASK_PORT server sources and runs the following word, XhostStart.  

   Pattern "Load XhostStart" below is the marker that word msource
   finds to source this region, which ends with word halt.

   Load XhostStart

   inline: XhostStart (qIP nPORT qName --- qList) \ start Xhost server
{     Start the server node Xhost(Name) on an Xhost server machine.

      When Xhost(Name) starts, it will connect to incoming IP:PORT 
      where this word is now running, and deliver the items in List.  
      See text XHOSTSTART in XclientConnect.

      Returned List contains these parameters for the library of 
      word Xhost(Name):
         IP PORT PID TPORT
      List is empty if there was an error.

      Utilities in XhostName() allow retrieval of items IP, PORT,
      PID and TPORT for a given Name.  For example, the listening
      PORT for an Xhost node server named momento is
         PORT = XhostName.FetchPort("momento");

      This word makes a script to start Xhost(Name), and then runs 
      the script on the Xhost(Name) machine.  Information that is 
      specific to Xhost(Name), from file usr/xhost_start.n, is in-
      serted into the script template below, called SCRIPT.

      The indeterminate wait for remote start up of Xhost(Name) is 
      handled by WTASK, waiting for these six stack items to appear 
      from Xhost: socket number, IP address, listening PORT number, 
      PID number, telnetd listening port number, and echo of Xhost 
      name.  

      As soon as WTASK counts up all these items, the indeterminate 
      wait is ended.  Maximum time to wait is WSEC (about 5 seconds),
      which can be varied on-the-fly for other machines or workloads
      by banking a new value as in: XhostStart.WSEC=20.
}
      [ 
      \ The following file must be where the program can find it using 
      \ word filefound; the initial location is /usr (usrpath):
        "xhost_start.n" "INIT" book \ file of Xhost-specific info

        "XHOST_START" "FILE" book \ script name to start Xhost node
      \ Note: FILE is placed at PATH on Xhost node, where PATH is
      \ obtained when file INIT (named above) is sourced below.

        9890 "P0" book \ Xhost starts looking for an open port at P0
        0.1 "FDELAY" book \ alarm to delay running until daemon forks 

      \ Controls for Xhost start up indeterminate wait (see below,
      \ WAIT_INIT and WAIT_BEGIN):
         \ Expect six items on stack when successfully connect to Xhost:
         \    nS qIP nPORT nPID nTelPort qHost

         \ Function for indeterminate wait during Xhost start up:
           "depth d0 - 5 > (f)" "WTASK" macro \ expect 6 stk items

         \ Max seconds to wait:
           5 "WSEC" book
{
        Below is the template of the script to start an Xhost node, 
        which runs under DSERVER.

        As soon as its DSERVER is running, Xhost node connects to 
        Xserver on Xserver's listening port (actually to Xserver's
        delegate, TASK_PORT on its listening port, due to difficulty
        connecting to Xserver's SSL listening port), to communicate 
        its own listening port to which Xserver will later connect 
        when it has an Xclient for login.  Then the connection is 
        closed.

        All this is done in function Xserver_connect() that is in
        SCRIPT (see below).  An ALARM delays the running of function 
        Xserver_connect() until after the server daemon, DSERVER, 
        has forked.  
}
    \ Template of SCRIPT to start Xhost node; to be run by shell().

    \ The beginning sh-bang line that follows is kept separate from its
    \ script until after parsing, because the parser will eliminate it 
    \ as a comment due to the leading #: 
      "#!$TOPS_EXE -p -s $SYS_PATH -u $USR_PATH" NLch + (qHeader)

      {" Template of script to start Xhost node:
         catmsg(no);

         HOST = "$HOST";

      // Connect to log file:
         set_sysout((LOG = "$LOG_PATH" + HOST + ".log"));
         nl(dot(nl, cats("-",72))); // log new header
         nl(dot("Server " + HOST + " started " + neat(date)));

      // Next available port:
         PORT = nextport(P0); 
         if(PORT < 0) (
            nl(dot(" Xhost: no open port for " + HOST)),
            nl(dot(" Xhost: exit")),
            exit()
         );

      // Use an empty shell environment when word running shells to 
      // telnetd (term.v, word TELNETD_START):
         shellset("");

         function Xserver_connect() /* connect back to Xserver */
         /* This function makes a connection to Xserver (or its
            TASK_PORT agent) and sends information about this Xhost 
            node (for example, its IP address and listening port 
            number so it can be contacted later), and then it closes 
            the connection.  

            Running this function is delayed until after DSERVER 
            has forked (see ALARM() below). */
         {
            nl(dot(" PID: " + intstr(getpid))); 

         // Connect to Xserver (or its agent) as type LOCLI (this prog 
         // to this prog):
            S = CLIENT("$X_IP",X_PORT); 
            if(S<0) exit(nl(dot(
               " Xserver_connect: failed to connect; exit"))
            );
            nl(dot(" Xserver_connect: Xserver or agent on " 
                   + "$X_IP" // may be Xserver agent, TASK_PORT
                   + ":" + intstr(X_PORT) 
                   + " socket " + intstr(S))
            );
         // Put socket number to this Xhost on Xserver stack, and
         // receive quick OK:
            SEC_SAV = remoterun1.SEC;
            remoterun1.SEC = 10; // should be much quicker than this
            nl(dot(" Xserver_connect: sending data on socket " 
               + intstr(S)));
            T = remoterun1("remotefd 'OK' remotefd remoteput", S);
            remoterun1.SEC = SEC_SAV;

            if(T != "OK") exit(nl(dot(
               " Xserver_connect: invalid ack from Xserver; exit")));

         // Source Xhost words:
            msource("server.v", "Xhost Words");
            whos();

         // The future connection from Xserver will be as type FOREIGN
         // using CLIENT_F.  Set up SERVE_F for foreign clients:
            SERVE_F.SERVICE = ptr("ClientInput"); 
            SERVE_F.TYPE = 1;       // 1 means TERM type
            new_client_timeout(60); // connect timeout (sec)

         // Start telnetd:
            main(TELNETD_START, "'TPORT' book"); 
            nl(dot(" Xserver_connect: telnetd started on port " +
                     intstr(main("TPORT"))));

         // Send 5 more items to Xserver:
            remoteput(main("HOST"), S);  // HOST name 
            remoteput(IPhost(host), S);  // HOST IP address
            remoteput(serverport, S);    // HOST PORT 
            remoteput(getpid, S);        // HOST PID 
            remoteput(main("TPORT"), S); // telnetd port

         // End Xserver indeterminate wait and close the connection:
            remoterun("WAIT_END", S); // end Xserver WAIT 
            nl(dot(" Xserver_connect: closing socket " + intstr(S)));
            sclose(S); // close this type LOCLI connection

         // Set an ALARM that closes this node and telnetd if there is
         // no login attempt within a grace period:
            ALARM(120, "XhostALARM"); // seconds for first key
         }

      // Set alarm to connect to Xserver after DSERVER forks:
         ALARM(ASEC, "Xserver_connect");

      // Xhost node running until killed:
         DSERVER("*", PORT); 

      "} (qHeader hInfix) chop noblanklines textput (qHeader qInfix)

      (qInfix) parse (qPostfix)
      (qHeader qPostfix) + (qT) "SCRIPT" book
      ]
      (qName) "HOST" book
      (nPORT) "SERVER_PORT" book
      (qIP) "SERVER_IP" book

      INIT filefound
      IF (qINIT) 
         CATMSG push no catmsg \ no sourcing messages

       \ Place all bytes from INIT on stack; T on stack is a 1-row VOL
       \ with bytes exactly as they are on file INIT:
         (qINIT) old ascii "IN" file IN INF fget (qT) IN fclose (qT)

       \ Parsing and sourcing file INIT (word local sources the text):
         (qT) parse local        \ parsing and sourcing T into local lib
         EXEC "'EXEC' book" main \ into main lib so XexecFile() can find
         COPY "'COPY' book" main \ into main lib so XcopyFile() can find

         pull catmsg \ restore

       \ Inserting into SCRIPT the substitutions just sourced from T,
       \ such as TOPS_EXE file name and USR_PATH directory:
         SCRIPT
         "$TOPS_EXE" TOPS_EXE strp
         "$USR_PATH" USR_PATH strp
         "$SYS_PATH" SYS_PATH strp
         "$LOG_PATH" LOG_PATH strp

       \ More substitutions:
         "ASEC"   FDELAY "%0.4f" format strp
         "$X_IP"  SERVER_IP             strp
         "X_PORT" SERVER_PORT    intstr strp
         "$HOST"  HOST                  strp
         "P0"     P0             intstr strp (qS) textput
{
         Now have on stack the script to start Xhost node.  Save it in 
         ~/FILE for review when debugging.
}        (qS) "HOME" env FILE catpath dup (qFile) push (qS qFile) save 

         peek (qFile) PATH XcopyFile \ copy script to Xhost machine
         "/bin/chmod a+x " PATH + FILE + XexecFile \ make it executable

         depth "d0" book \ stack depth for WTASK; expect 6 more items

         "WAIT_INIT" "frac" yank push \ save default
         0.01 "WAIT_INIT" "frac" bank \ sample more often than default

         WSEC "XhostStart" "WTASK" localref (nSec qTask) 
         (nSec qTask) WAIT_INIT \ initialize for indeterminate wait

         time push             \ clocking the wait
         PATH FILE + XexecFile \ run script to start Xhost node daemon
         WAIT_BEGIN            \ begin indeterminate wait

         time pull - "ET" book        \ indeterminate wait has ended
         pull "WAIT_INIT" "frac" bank \ replace frac default

       \ Xhost node daemon server should be running.
         "/bin/rm " PATH + FILE + XexecFile \ delete Xhost script
         pull (qFile) drop                  \ keep ~/FILE copy for debug

       \ Running XexecFile should have added six stack items:
         (nS qHost qIP nPORT nPID nTelPort)
         depth 5 > (nS qHost qIP nPORT nPID nTelPort)
         IF (nTelPort) "TPORT" book
            (nPID)     "PID"   book
            (nPORT)    "PORT"  book
            (qIP)      "IP"    book
            (qHost)    "HOST1" book
            (nS) sclose \ use S to close the connection

          \ Cursory checks:
            HOST1 HOST =     \ host echo valid?
            TPORT 0> and (f) \ and valid telnetd port?
         ELSE fail (f) 
            no "PID" book
         THEN (f) not \ (f not)=true if failed

         IF PID any? IF killmy THEN 
            "ClientClose" "killtelnetd" yank \ kill telnetd
            " XhostStart: connection to HOST failed" 
            "HOST" HOST strp ersys << ""  return
         THEN

         " XhostStart: HOST started in"
         ET " %0.3f sec" format + "HOST" HOST strp . nl

         " XhostStart: HOST is listening on port "
         "HOST" HOST strp . PORT intstr . nl

         " XhostStart: HOST telnetd is listening on port "
         "HOST" HOST strp . TPORT intstr . nl

       \ Make list: IP PORT PID TPORT)
         IP             spaced
         PORT  intstr + spaced
         PID   intstr + spaced 
         TPORT intstr + (qList)

      ELSE " XhostStart: init file INIT not found" "INIT" INIT strp
         ersys << "" return
      THEN
   end

   private halt

   End braced region for XhostStart
}
   inline: XMLtemplate ( --- qT) \ template for XML text to Xclient
{     Insert text for Xclient where _TEXT_ appears in this template.

      Example: (qT1) XMLtemplate "_TEXT_" rot strp (qT2) 

      HEAD is the XML header that is sent to Xclient with the login 
      prompt, word XclientLogin, and whenever a new XMLHttpRequest
      is started in XclientReconnect().

      Once HEAD has been sent, only TAIL is required to accompany 
      bytes to Xclient, so TAIL is the string returned by this word.
}     [
      {" 
         HTTP/1.0 400
         Cache-Control: no-cache
         Pragma: no-cache
         Content-Type: text/xml

      "} left justify textput "HEAD" book

     \'<?xml version="1.0" encoding="ISO-8859-1"?>_TEXT_'
      '<?xml version="1.0" encoding="US-ASCII"?>_TEXT_'
      "TAIL" book

      ] TAIL (qT)
   end

{" Gather the following infix and parse it to postfix:

function Xserver(PORT_IN) /* start Xserver listening on PORT_IN */
{
   { IP="127.0.0.1"; /* Xserver IP address on secure network */
     SSL=yes;      /* default (secure sockets layer) */
     show_conn=no; /* default (show every connection in log file) */
     daemon=no;    /* default (run as daemon) */
   }
   PORT=PORT_IN; /* save Xserver.PORT in local library */

   SERVE_F.SERVICE=ptr("WebInput"); /* receives bytes from Xclient */
   SERVE_F.TYPE=1;                  /* 1 means TERM type */ 
   SERVE_F.CONNSHOW=show_conn;      /* yes echoes all new connections*/ 
   new_client_timeout(60);          /* connect timeout (sec) */

   COG(yes);                        /* server will cog */
   READ_F(WebInput.BYTES);          /* bytes per web Xclient cog */

   <<
   "*" PORT daemon
   IF   SSL IF DSERVER_SSL ELSE DSERVER THEN \ running as daemon
   ELSE SSL IF SERVER_SSL  ELSE SERVER  THEN \ running interactively
   THEN
   >>

/* DSERVER and DSERVER_SSL fork and never get to this point. */

   if(!serverport) return(nl(dot(" Xserver: failed to start")));

   if(SSL) nl(dot(" Xserver SSL listening on port " + intstr(PORT)));
   else nl(dot(" Xserver listening on port " + intstr(PORT)));
}
"} >> parse << main

   inline: XserverOutput (qT nS1 --- ) \ send T as XML to Xclient on S1
\***** T NEEDS TO BE CONVERTED INTO PARSED TEXT FROM TELNETD BEFORE 
\      THIS WILL WORK.  IT NEEDS TO BE SENT THROUGH  Xoutput() on 
\      Xhost TO GET THE PROPER FRAME NUMBER.
" XserverOutput: this function does not operate" . nl 2drop return 
      push XMLtemplate "_TEXT_" rot strp pull remoteputf
   end

   private halt

   End of Xserver Words.

\-----------------------------------------------------------------------

IV. Words for serving an Xserver client: Xhost node layer.

   These are the Xhost words:
   inline: ClientClose (nS1 --- ) \ tasks when Xclient socket closes
   inline: ClientInput (qT nS1 --- ) \ receive bytes from client on S1
   inline: LoginFinish (qT nS2 --- ) \ complete the login process
   inline: LoginPasswd (qT nS2 --- ) \ step 6 of login
   inline: LoginUser (qT nS2 --- ) \ step 5 of login
   inline: MAIN ( --- qMain) \ main library word
   inline: newt (ptrFx x1 --- x) \ root x where Fx[x]=0
   inline: XhostALARM ( --- ) \ close connection after grace period
   inline: XhostExit (qT --- ) \ close everything down and exit
   inline: Xkey (qKey qHost --- ) \ process a single Key from client
   inline: XkeyBuf (qHost --- qKbuf) \ fetch client key buffer to stack
   inline: Xlogin (qHost --- ) \ client login to Host
   inline: XloginOut (qT nS2 --- ) \ send bytes to Xserver during login
   inline: Xoutput (qT nS2 --- ) \ send TELNETD bytes from S2 to Xserver
   inline: Xoutput1 (qT --- ) \ send to Xserver without parsing first
  function Xserver_connect() /* connect back to Xserver */
   inline: XtelnetClose (nS2 --- ) \ tasks when TELNETD socket closes
   inline: XtelnetSend (qT qHost --- ) \ send T to TELNETD Host

   In addition, the following words are sourced from term.v:
   inline: CLIENT_NEGOTIATE (qIPaddr nPort --- qT nS) \ get login prompt
   inline: CLIENT_WINDOW (nRows nCols --- qS) \ window size for telnetd
   inline: SEND ( --- hPTR) \ login strings sent to Unix telnetd server
   inline: TELNETD_START ( --- nPort) \ start telnetd, return its Port

   This shows the relationship of Xhost node to Xclient and TELNETD:

      Xclient <---> Xserver <---S1---> Xhost node <---S2---> TELNETD 

   The closest client to Xhost node is Xserver, which is serving 
   Xclient.

   See Appendix for notes on Xhost closing.

   Xhost Words

   "CONNECT" missing IF " Networking words required" . halt THEN

   "CLIENT_NEGOTIATE" missing 
   IF "term.v" "\  CNEG MARKER" "\  CNEG END" msource1 THEN

   "CLIENT_WINDOW" missing 
   IF "term.v" "\  CWIN MARKER" "\  CWIN END" msource1 THEN

   "SEND" missing 
   IF "term.v" "\  SEND MARKER" msource THEN

   "TELNETD_START" missing 
   IF "term.v" "\  TEL MARKER" msource THEN

\  Constants that define Host.KeyMode:
   "1" "ON_KEY"   macro \ sending input to TELNETD on each key
   "2" "ON_ENTER" macro \ sending input to TELNETD on Enter key

   0 "S1" book \ socket to Xserver
   0 "S2" book \ socket to TELNETD

{  Below are bytes 1-255 for CHARS used in Xclient.js.  Xhost uploads 
   these to the Xclient browser to use for byte values.  Zero is not
   sent because it does not transmit well, and to keep the number sent
   below 256, which is too much for the 1-byte count of counted strings:
}  "" 255 1 DO I export1 + LOOP "CHARS" book

   inline: ClientClose (nS1 --- ) \ tasks when Xserver socket closes
{     Socket S1 to Xserver, the client of this Xhost node, has been
      closed.

      Do not run this word directly.  It is run by sclose(S1).

      The ptr to this word is assigned to ptrCls(S1) in Xlogin(), so it 
      is run automatically by sclose(S1).
}
      [ {" Local word to close telnetd daemon:
           MAIN "TPORT" yank push
           " ClientClose: killing telnetd on port " peek intstr + . nl

         \ Using CLIENT (meant for a tops server) on a foreign server 
         \ gives invalid run flag here and leads to mutual closure.
         \ Word >stk is used to hide CONNECT error messages:
           IPloop pull "CLIENT" >stk (f qSTK) 2drop

        "} "killtelnetd" macro
      ]

    \ Deactivate the host word (there is only one host in this applica-
    \ tion, and the "host word" is MAIN and the library is the main 
    \ library):

      (nS1) drop             \ socket from Xserver is already closed
      killtelnetd            \ kill telnetd

      "" MAIN "BRWSR"   bank \ set invalid brwsr
      "" MAIN "LOGNAME" bank \ set empty user name

       0 MAIN "Klen"    bank \ empty char buffer
      -1 MAIN "S1"      bank \ invalid socket
      -1 MAIN "S2"      bank \ invalid socket
       0 MAIN "STEP"    bank \ available again for steps of login
      -1 MAIN "TPORT"   bank \ invalid TELNETD port

      " ClientClose: exit " date + . nl 1 "exit" ALARM
   end

   inline: ClientInput (qT nS1 --- ) \ receive bytes from client on S1
{     This word services all bytes received on the listening server
      of Xhost node.  It was given this task by the phrase

         SERVE_F.SERVICE = ptr("ClientInput");

      that was run in function Xserver_connect() at start up.
      (See SCRIPT in XhostStart().)

      Function SERVE_F() (net.v) is central to the program running
      TCP/IP to serve foreign clients.  SERVE_F() is run by drainf() in
      net.c when bytes arrive from a foreign client, and clientmake()
      and clientclose() in term.c when foreign clients connect and 
      close.

      So when bytes arrive on socket S1 and drainf() runs SERVE_F,
      SERVE_F.SERVICE contains ptr("ClientInput") and this word runs.
}
\     Process incoming bytes from the client on socket S1.  The client
\     is Xserver serving an Xclient.

      [ {" (qT) Method A: Xclient aborted by Xserver; A is from browser
           (qT) drop S1 sclose 
        "} "A" macro

        {" (qT) Method C: client logging in
\          For Netscape, T contains: CM /hostname
\          For IE, T contains: CI /hostname

\          Login:
           (qT) this 2nd word drop -1 indent chop "HOST" book

           HOST MAIN "HOST" yank <>
           IF " ClientInput: " HOST + " sent to wrong host" + . nl 
              (qT) drop 
              S1 sclose 
              CRLF "wrong host, connection closing" + XhostExit
           THEN
           (qT) 2nd catch "BRWSR" book \ BRWSR is char M or I

\          In this application there is only one client.  Bank items
\          in main lib and make "HOST" appear as MAIN:
           S1 MAIN "S1" bank            \ socket to client
           0  MAIN "S2" bank            \ socket to TELNETD

           BRWSR    MAIN "BRWSR"   bank \ client brwsr type
           ON_ENTER MAIN "KeyMode" bank \ keyboard mode

           0    MAIN "Klen" bank        \ key buffer length used
           1012 MAIN "Kmax" bank        \ key buffer max
           1024 nulls MAIN "Kbuf" bank  \ key buffer size

           0  MAIN "STEP"    bank       \ login step (logged=6)
           "" MAIN "LOGNAME" bank       \ logged in user name
           no MAIN "ON_PASSWD" bank     \ not doing password yet

           "CHARS" main cstr 02 vtreserved Xoutput1 \ send byte array
           MAIN (qHost) Xlogin \ client login
        "} "C" macro

        {" (qT) Method R: Xclient is reconnecting to Xserver
\          T has the form R+KEY, as in: R13
\          Reset frame count to F1:
           "Xoutput" "F1" yank "Xoutput" "FRAME_INIT" localrun
           " ClientInput: reset frame count for Xclient reconnection"
           dot nl
\          Process the browser key that accompanies R, if any:
           (qT) these chars 1 > 
           IF -1 indent (qKEY) MAIN Xkey ELSE drop THEN
        "} "R" macro

        {" (qR:C) Method S: size method; send TELNETD new window size
           (qR:C) ":S" chblank ("R C") numbers 
            dup 1st pry swap 2nd pry (nR nC) 
            (nR nC) CLIENT_WINDOW (qT)
            (qT) MAIN XtelnetSend
        "} "S" macro

        {" (qT) Method T: inputting a byte string
"************ T method" . nl

MAIN "KeyMode" yank ON_KEY =    \ Host.KeyMode
IF " KeyMode is ON_KEY" ELSE " KeyMode is ON_ENTER" THEN . nl

\ ****** NOW THAT JUST BYTES ARE BEING SENT, ELIMINATE intstr AND
\ REVISE Xkey TO USE BYTES.

           (qT) these chars 2nd
           DO this I byte intstr (qKEY) MAIN Xkey LOOP drop
        "} "T" macro

        {" (qT) Method U: unknown method, unknown Xserver
\          Close client when here:
           (qT) drop 
           " ClientInput: closing client socket S1: " 
           S1 intstr + . nl 
           CRLF "unknown method, connection closing" + XhostExit
           S1 sclose 
        "} "U" macro
      ]
{     Process incoming methods from Xserver client on S1.  T may hold
      several null-terminated strings (from remoteputf0).

Here is an example of two null-separated strings entering this word,
one for method R and one for method K:

 readn1: 6 bytes from socket 4
       0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F  0123456789ABCDEF
   0  52 00 4B 31 33 00 00 00 00 00 00 00 00 00 00 00  R.K13...........
}

ntrace
      (qT nS1) "S1" book
      xbase "k" book

"************** ClientInput: " . dup . nl dup .hex nl

      BEGIN 
         (qT) this k str0 any?
      WHILE (qTk)
         1 k bump

         (qT) this 1st catch (qM)  \ gives the processing method

         (qM) this local? not      \ macro M not in local lib?
         IF (qTk qM) drop "U" THEN \ use macro U, unknown

         (qTk qM) local \ run the designated macro from local lib

      REPEAT (qT) drop
k 2 > IF " XXXXXXXXXXXXXXXXX MULTIPLE INPUTS:" . k 1- .i nl THEN
   end

   inline: LoginFinish (qT nS2 --- ) \ finish the login process
{     Complete the login through Unix telnetd running on remote machine.

      This word runs after step 6, password, and receives the TELNETD
      response to the keyed password from the client.

      Several attempts at login are allowed before Xhost closes.

      See doc/telnet.doc for the trace of steps during Unix telnet
      login that was used to write this word.
}
      [ no "TRIES" book 3 "MAX_TRIES" book ]

      "S2" book
      "T" book
      MAIN "STEP" yank "step" book

      step 6 =
      IF 
{        Examples of messages for bad login:

            netkit-telnet-0.17 in RH Linux 7.2:
               Login incorrect

            telnet in AIX 4.3:
               You entered an invalid login name or password
 
         Here is the macro for determining incorrect login message: 
}        [ 'dup "ogin incorrect" grepr rows any '
           'swap "invalid login" grepr rows any or ' + "BADLOGIN" macro
         ] 
         T chars 3 < IF T S2 XloginOut return THEN

         T BADLOGIN
         IF TRIES MAX_TRIES >=
            IF " LoginFinish: login failed after " TRIES intstr +
               " tries" + . nl
               CRLF "Login failed" + XhostExit
            ELSE \ try another login:
               no MAIN "ON_PASSWD" bank
               ON_ENTER MAIN "KeyMode" bank
               T S2 XloginOut \ error T to Xclient contains login prompt
               0 Xlogin
            THEN
         ELSE 
\           T finally will contain the user prompt but before that it
\           may contain login messages (like "You have mail") that pre-
\           cede the user prompt:
          \ TESTING BEHAVIOR WITHOUT THIS CHECK FOR 0 chars
          \ CONSIDER AN ALARM ON TOTAL TIME TO GET LOGGED IN
          \ T chars 0>
          \ IF 
               no "TRIES" book 
               no MAIN "ON_PASSWD" bank
               ON_KEY MAIN "KeyMode" bank  \ single key mode forever
               7 MAIN "STEP" bank          \ no prior LoginXXX will run
               "XloginOut" ptr S2 ptrRun_upd \ to pick up user prompt

               T S2 XloginOut \ send T to Xclient
               return 

{ \ TESTING BEHAVIOR WITHOUT THIS BRANCH
            ELSE 
\              Problem here if system is busy.  Login may be ok, but 
\              T is empty and this kicks you out.

               " LoginFinish: blank TELNETD response " date + . nl
               CRLF "no host response, connection closing" + XhostExit
               return
            THEN
}
         THEN
      ELSE " LoginFinish: invalid step " step intstr + . nl
         CRLF "host login invalid step, connection closing" + XhostExit
      THEN
   end

   inline: LoginPasswd (qT nS2 --- ) \ step 6 of login
{     Perform login through Unix telnetd running on remote machine.  

      This word does step 6, password.

      See doc/telnet.doc for the trace of steps during Unix telnet
      login that was used to write this word.
}
      MAIN "STEP" yank "step" book 

      (qT nS2) step 6 = MAIN "ON_PASSWD" yank yes = and
      IF "LoginFinish" ptr over (nS2) ptrRun_upd \ receive passwd keys
         (qT nS2) XloginOut                      \ send T to client

      ELSE " LoginPasswd: invalid step " step intstr + . nl
         2drop CRLF "LoginPasswd invalid step" + XhostExit
      THEN
   end

   inline: LoginUser (qT nS2 --- ) \ step 5 of login
{     Perform login through Unix telnetd running on remote machine.  

      This word runs login step 5, user name. 

      Incoming T is the TELNETD response to the keyed user name from 
      client.

      See doc/telnet.doc for the trace of steps during Unix telnet
      login that was used to write this word.
}
    \ Bump STEP; steps are noted in term.v, word SEND and word REC:
      1 MAIN "STEP" yank incr \ bump step 5 to step 6
      MAIN "STEP" yank "step" book

      (qT nS2) step 6 =
      IF (qT nS2) 
         "XhostALARM" -ALARM \ kill the grace period alarm
         over (hT) "LoginFinish" "BADLOGIN" localrun 
         IF \ try another login:
            no MAIN "ON_PASSWD" bank
            ON_ENTER MAIN "KeyMode" bank
            (qT nS2) XloginOut \ TELNETD error msg contains login prompt
            0 Xlogin return
         THEN
       \ T should contain name + password prompt: "username^MPassword: "

         (qT nS2) that asciify (qT) 1st word (0, or username -1)

         IF (qT nS2 qName)

          \ Bank user name into host library:
            (qName) MAIN "LOGNAME" bank

          \ Move ptrRun for TELNETD to step 6:
            yes MAIN "ON_PASSWD" bank
            ON_ENTER MAIN "KeyMode" bank
            (qT nS2) "LoginPasswd" ptr that (nS2) ptrRun_upd

          \ Send T to client and return.
            (qT nS2) XloginOut
            return

         ELSE " LoginUser: empty user name" . nl
         THEN
      ELSE " LoginUser: invalid step " step intstr + . nl
      THEN
      2drop CRLF "Login failed" + XhostExit
   end

   inline: MAIN ( --- qMain) \ main library word
{     Since there is only one client and one host, their items are 
      stored in the main library, rather than in separate libraries
      for each paired client and host as was done in an earlier version
      (archived in /opt/mytops/sys/term_orig.v).

      But to continue to use words that expect a separate word for each
      client/host pair, this word lets the main library be treated like
      a word's library, so bank and yank can be used, as in:

         MAIN "S1" yank
}
      [ "DATA__" "LIB" book ] \ DATA__ is the official name of main lib
      LIB
   end

   inline: XhostALARM ( --- ) \ close connection after grace period
      CRLF "End of login grace period" CRLF + + (qT)
      (qT) MAIN "S2" yank Xoutput

      MAIN "S2" yank XtelnetClose \ gives "Connection closed by ..." msg

      "" XhostExit 
      " XhostALARM: no response during grace period" . nl
   end

   inline: XhostExit (qT --- ) \ close everything down and exit
      (qT) any? IF MAIN "S2" yank Xoutput THEN \ send to Xclient

      MAIN "S1" yank any?
      IF (nS1) sclose  \ run ptrCls(S1)=ptr("ClientClose")
      ELSE 0 ClientClose \ run shutdown and exit
      THEN
   end

   inline: Xkey (qKey qHost --- ) \ process a single Key from Xclient
{     Operating in one of two modes:

         ON_KEY: send char(number(qKey)) directly to TELNETD

         ON_ENTER: verify that buffer Host.Kbuf is not full, then 
            place char(number(qKey)) in the very next byte and echo
            back to Xclient as TELNETD would; when qKey is CR, fetch 
            Host.Kbuf to stack, add x00, and send to TELNETD

      XtelnetSend sends to TELNETD.  Stack diagram for XtelnetSend 
      is (qT qHost --- ).
}
      [ CRLF 1st catch "CR" book "00" hexbytes "x00" book 
        "0D 00" hexbytes "EOL" book \ CR + 00 sent to telnetd daemon
      ]
      dup (qHost) "KeyMode" yank ON_KEY =    \ Host.KeyMode

      IF (qKey qHost) that number (n f)      \ qKey number 
         IF char (qChar) dup CR =            \ ASCII char
            IF drop EOL swap XtelnetSend     \ send 0D 00 to TELNETD
            ELSE (qChar) swap XtelnetSend    \ send char to TELNETD
            THEN 
            (qKey) drop return               \ and return
         ELSE (qKey qHost) "HOST" book
            " Xkey: bad key " . .hex nl
         THEN

      ELSE                                   \ putting qKey in Host.Kbuf
         (qHost) "HOST" book                 

         HOST "Klen" yank (n)                \ n=Host.Klen to stack
         dup (n) HOST "Kmax" yank (n max) <  \ is n < Host.Kmax?

         IF (n) tic (n)                      \ tos+=1
            dup (n) HOST "Klen" bank         \ Host.Klen=tos

            (qKey n) swap number             \ qKey number 
            IF (n num) dup 8 =               \ 08h backspace case
               IF swap (num n)               \ 08h+20h+08h is correction
                  8 char 32 char + dup       \ 08h+20h

                  HOST "S2" yank Xoutput     \ 08h+20h to Xclient
                  HOST "Kbuf" yank 
                  other ndx strplace         \ 08h+20h into Kbuf
                  (n) tic tic                \ increment n by 2
                  dup (n) HOST "Klen" bank   \ new Klen
                  (num n) swap               \ ending 08h is added below
               THEN
               (n num) char                  \ to ASCII char 
               dup rev (char n char)         \ rev char on stk for later
             
               (n char) HOST "Kbuf" yank     \ Host.Kbuf to stack
               rot (n) ndx (char Kbuf n)     \ n index to top of stack
               strplace                      \ Host.Kbuf(n)=char

               (char) dup CR =               \ CR is 0D (decimal 13)
               IF (char) drop HOST XkeyBuf   \ Host.Kbuf to stack
                  printf                     \ remove typing mistakes
                  x00 + (qChars)             \ + x00 makes ending 0D 00
                  HOST XtelnetSend           \ send to TELNETD
               ELSE HOST "ON_PASSWD" yank
                  IF drop "08 20" hexbytes   \ ON_PASSWD, echo BKS BL
                  THEN
                  (char) HOST "S2" yank      \ imitate TELNETD output
                  Xoutput                    \ and echo back to Xclient
               THEN 
               return                        \ and return

            ELSE " Xkey: bad key" . nl
            THEN 
         ELSE                              
            (qKey n) 2drop                   \ Kbuf is full
            " Xkey: " peek + " key buffer is full" + . nl 
         THEN 
      THEN \ close Xclient when here:
      " Xkey: closing host " HOST + . nl
      HOST "S1" yank sclose
      CRLF HOST " closing on Xkey error" + + XhostExit
   end

   inline: XkeyBuf (qHost --- qKbuf) \ fetch Xclient key buffer to stack
\     Fetch buffer of keys from host, then empty the buffer.
      dup push                         \ Host name to local stack
      (qHost) "Kbuf" yank              \ Host.Kbuf to stack
      1st peek "Klen" yank items catch \ 1st Host.Klen chars
      dup chars nulls                  \ string of Klen nulls
      peek "Kbuf" yank 1st strplace    \ Host.Kbuf(1:Klen)=null
      0 pull "Klen" bank               \ Host.Klen=0
   end

   inline: Xlogin (qHost --- ) \ Xclient login to Host
{     Perform login for Host now connected on socket Host.S1.  

      When this word returns, a connection to TELNETD will have been 
      made on socket Host.S2, and the tables and ptrs to handlers are 
      ready for Xclient now connected on socket Host.S1 to engage the 
      following words for login:

         LoginUser
         LoginPasswd
         LoginFinish
 
      Note: in this application there is only one Host, called MAIN.
}
      (qHost) any?
      IF (qHost) 
         MAIN "STEP" yank 0>
         IF " Xlogin: host " swap + " is unavailable" + . nl
            CRLF "host server is unavailable" + XhostExit 
            return
         THEN
         (qHost) drop

         MAIN "S1" yank "S1" book \ valid socket to Xclient

         0 "CLIENT_F" "set_CONN" bank

         IPloop MAIN "TPORT" yank 
         (qIPaddr nPort) CLIENT_NEGOTIATE (qT nS2) "S2" book 

         (qT) drop \ use our own login prompt:
         "0D" hexbytes "login: " + (qT)
         (qT) "T" book \ login prompt

         S2 0> not
         IF " Xlogin: failed to connect to TELNETD" ersys
            CRLF "host server connection failed" + XhostExit 
            return
         THEN

\        Inform Host of its socket number to TELNETD:
         S2 MAIN "S2" bank \ into library of Host

\        Set ptrCls for sockets S1 and S2 to words that run when they 
\        close:
         "ClientClose" ptr S1 ptrCls_upd 
         "XtelnetClose" ptr S2 ptrCls_upd 

         5 MAIN "STEP" bank            \ set ptr to step 5
         "LoginUser" ptr S2 ptrRun_upd \ ptr("LoginUser") for step 5
         T S2 XloginOut \ send first login prompt T to Xclient

      ELSE \ reentering to try login again; use same S2
         5 MAIN "STEP" bank            \ go back to step 5
         "LoginUser" ptr S2 ptrRun_upd \ ptr("LoginUser") for step 5
       \ TELNETD error msg contains login prompt for Xclient
      THEN
   end

   inline: XloginOut (qT nS2 --- ) \ send bytes to Xserver during login
{     Used for output to Xclient during login by words LoginFinish, 
      LoginPasswd, LoginUser and Xlogin to manage login attempts and to
      send confirmation of successful login to Xserver and to Xclient.

      Guides login at these steps, adding bytes that Xclient uses (see
      JavaScript, Xclient.js):

         1. When login prompt is sent, the prompt is preceded with bytes
            0F+04:
               (qT1) "" 04 vtreserved swap + \ 0F+04+T1

         2. When password prompt is sent, bytes 0F+03 are appended to
            it:
               (qT1) "" 03 vtreserved + \ T1+0F+03

         3. When login is successful, the user prompt is preceded with
            0F+01+hostname:
               MAIN "HOST" yank cstr 01 vtreserved \ 0F+01+hostname

}     [ "LoginFinish" "MAX_TRIES" yank "MAX_TRIES" book 

      \ These are the login prompt patterns to look for:
        "0D" hexbytes "login: " + "LOGIN1" book \ first time
        "0A" hexbytes "login: " + "LOGIN2" book \ on error

\    Here are the byte patterns of LOGIN1 and LOGIN2:

\      0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F  0123456789ABCDEF
\     0D 6C 6F 67 69 6E 3A 20 00 00 00 00 00 00 00 00  .login: ........

\     0A 6C 6F 67 69 6E 3A 20 00 00 00 00 00 00 00 00  .login: ........

\       This is the password prompt to look for, including a blank
\       space after the colon:
        "Password: " "PASSWD" book

        "0A" hexbytes "EOL" book
        "login_ok" "FLAG" book 
      ]
\     Keep count of login prompts sent:
      (qT nS2) that LOGIN1 grepr rows any
      (qT nS2 f) other LOGIN2 grepr rows or
      IF 1 "LoginFinish" "TRIES" yank incr 

         "LoginFinish" "TRIES" yank MAX_TRIES > 
         IF 2drop " XloginOut: login failed after " 
            MAX_TRIES intstr + " tries" + . nl
            CRLF "Login failed" + (qT) XhostExit

         ELSE 
\           Send 0F+04+prompt to Xclient:
            (qT nS2) vtparse3 (qT1)       \ login prompt
            (qT1) "" 04 vtreserved swap + \ 0F+04+prompt
            Xoutput1
         THEN
      ELSE
         (qT nS2) that PASSWD grepr rows any
         IF (qT nS2) 
{           If user name accompanies the bytes of password prompt in 
            LoginUser, the program will be here without LoginPasswd() 
            being called.  

            Otherwise, the program will be here from LoginPasswd().  

            Just in case the former happens, do the checks of STEP and 
            ON_PASSWD and set ptrRun_upd as done in LoginPasswd().
}        
            MAIN "STEP" yank 6 = MAIN "ON_PASSWD" yank yes = and
            IF "LoginFinish" ptr over (nS2) ptrRun_upd \ to receive keys

               (qT nS2) vtparse3 (qT1)  \ password prompt
               (qT1) "" 03 vtreserved + \ password flag 0F+03
               (qT) Xoutput1

            ELSE \ this will fail the same test and do the error return:
               (qT nS2) LoginPasswd 
            THEN
{
This is an example of the password prompt string sent from here to 
Xclient.  It is a case of user name accompanying password prompt
mentioned above, where LoginPasswd() will be bypassed.

The string contains an echo of the user name, carriage return (0D) and 
new line (0A), and the password prompt.  Bytes 0F 03 that follow "Pas-
sword: " cause the cursor on Xclient to remain fixed while the password
is keyed, and were added by the vtreserved phrase above:
       0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F  0123456789ABCDEF
   0  0C 04 64 61 6C 65 05 0D 05 0A 0C 0A 50 61 73 73  ..dale......Pass
   2  77 6F 72 64 3A 20 0F 03 00 00 00 00 00 00 00 00  word: .........
}
         ELSE
            MAIN "STEP" yank 7 = \ LoginFinish sets this when ok login
            IF \ successful login

               (qT nS2) those dup chars ndx catch EOL <> 

               IF \ no EOL, so this must be the prompt 

                  (qT nS2)
                  "Xoutput" ptr over ptrRun_upd \ ptrRun TELNETD forever

\                 Inform Xserver that login is successful (the receiver
\                 of these bytes is word XclientLogin:
                  FLAG MAIN "S1" yank remoteputf

\                 To add message lines above the user prompt, do it
\                 here.  Add CRLF to each line and add them all:
 
                  "1. This is where a final message goes." CRLF +
                  "2. This is where a final message goes." CRLF + +
                  "3. This is where a final message goes." CRLF + +
                  "4. This is where a final message goes." CRLF + +
                  "5. This is where a final message goes." CRLF + +

                  (qT nS2 qTfinal) rot + swap (qT nS2)
 
\                 Prepend confirmation bytes 0F+01 to prompt T going to 
\                 Xclient (see example below):
                  (qT nS2)
                  MAIN "HOST" yank cstr 01 vtreserved \ 0F+01+hostname
                  (qT nS2 qHost) 
                  rev (qHost qT nS2) vtparse3 (qT1) + (qT)
                  (qT) Xoutput1

\                 Successful client login.
                  " XloginOut: successful client login " date + . nl
{
This is an example of a string sent to Xclient upon successful login to 
host rufysnow.  Bytes 0F+01 denote successful login, and the counted 
string (0C 1C=count ... ) following host name is the prompt:
       0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F  0123456789ABCDEF
   0  0F 01 08 72 75 66 79 73 6E 6F 77 0C 1C 5B 64 61  ...rufysnow..[da
   2  6C 65 40 63 6C 61 63 6B 65 72 5D 20 2F 68 6F 6D  le@clacker] /hom
   4  65 2F 64 61 6C 65 20 3E 20 00 00 00 00 00 00 00  e/dale > .......
Host name rufysnow will go on the browser status bar.
}
               ELSE \ not quite complete; waiting for the user prompt
                  (qT nS2) Xoutput \ forward message after good login
               THEN
            ELSE 
               (qT nS2) Xoutput \ forward message prior to good login
            THEN
         THEN
      THEN
   end

   inline: Xoutput (qT nS2 --- ) \ send TELNETD bytes from S2 to Xserver
{     After login, this function is pointed to by ptrRun(S2) (see word
      LoginFinish).

      Incoming T contains ANSI/VT100 text and escape sequences from 
      TELNETD.
      This word parses T and sends results to Xserver.

      There is only one Xserver client, and it is on socket S1 stored 
      in the main library.
}    
      [ 0 "F1" book \ must match initial K in usr/Xclient.js

        {" (nFRAME --- )
           "FRAME" book 
           "<f" FRAME "%0.f" format ">" + dup push + "FL" book
           "</f" pull                              + "FR" book
        "} "FRAME_INIT" macro

        {" (qT --- )
         \ Enclose T in FL and FR:
           (qT) FL swap (qT) FR + + (qT)

           "Xoutput VT parsed " . date . sp time dup integer - . nl
           dup INF xray these rows 800 < not
           IF drop " volume is too big to display" THEN . nl

         \ Send T:
           MAIN "S1" yank any? 
           IF (qT S1) remoteputf \ to Xserver to relay to Xclient

           "Bottom of Xoutput " . date . sp time dup integer - . nl

            \ Do this after T has been sent to Xserver:
              1 FRAME incr
              "<f" FRAME "%0.f" format ">" + dup push + "FL" book
              "</f" pull                              + "FR" book
           ELSE (qT) drop 
           THEN
        "} "FRAME_SEND" macro
      ]
      (nS2) "S2" book

" Check of socket:" . nl S2 socket_check
"Xoutput before parsing " . date . sp time dup integer - . nl
dup INF xray these rows 800 < not
IF drop " volume is too big to display" THEN . nl

    \ Parse T:
      (qT) S2 vtparse3 (qT) \ parse escape sequences
      (qT) any? not IF return THEN
      (qT) FRAME_SEND
   end
   "Xoutput" "F1" yank "Xoutput" "FRAME_INIT" yank

   inline: Xoutput1 (qT --- ) \ send to Xserver without parsing first
{     Send bytes to Xserver that are already in vt parsed form.   

      This word is like Xoutput except T does not come from TELNETD 
      and vtparser is not run.  

      Variables FRAME, FR, and FL in the library of Xoutput are used 
      and updated as if Xoutput had been run.

      There is only one Xserver client, and it is on socket S1 stored
      in the main library.
}
    \ Enclose T in FL and FR:
      (qT) "Xoutput" "FL" yank swap (qT) "Xoutput" "FR" yank + + (qT)

"Xoutput1 VT parsed " . date . sp time dup integer - . nl
dup INF xray these rows 800 < not
IF drop " volume is too big to display" THEN . nl

    \ Send T:
      MAIN "S1" yank any?
      IF (qT S1) remoteputf \ send T to Xserver to relay to Xclient

"Bottom of Xoutput1 " . date . sp time dup integer - . nl

       \ Do this after T has been sent to Xserver.  Update the values
       \ of FRAME, FR, and FL in lib of Xoutput as if it had been run:
         1    "Xoutput" "FRAME" yank incr
         "<f"         "Xoutput" "FRAME" yank "%0.f" format ">" + 
         dup push +   "Xoutput" "FL" bank
         "</f" pull + "Xoutput" "FR" bank
      ELSE (qT) drop
      THEN
   end

   inline: XtelnetClose (nS2 --- ) \ tasks when TELNETD socket closes
{     Host.S2 socket to TELNETD has been closed; close the client socket
      (to Xserver), Host.S1, too, where S1 is in the main library.

      Do not run this word directly.  It is run by sclose(S2).
} 
      (nS2) MAIN "S1" yank any? 
      IF (nS2 nS1) 

         "" 134 (x86) vtreserved Xoutput1 \ logged out byte to Xclient

         "Connection closed by host " MAIN "HOST" yank + other 
         (qT nS2) Xoutput \ message to Xserver to relay to Xclient

         (nS2 nS1) sclose \ close Xserver connection

      THEN (nS2) drop

"Bottom of XtelnetClose " . date . sp time dup integer - . nl

   end

   public
   inline: XtelnetSend (qT qHost --- ) \ send T to TELNETD Host
\     There is only one TELNETD Host, and it is on socket S2 stored in 
\     the main library.
      (qHost) drop S2 (qT S2) remoteputf \ send to TELNETD
   end
   private 

   private halt

   End of Xhost Words.

\-----------------------------------------------------------------------

V. Trouble Shooting.

   Diagnostics
{
   Starting an Xhost node.

   Note: some of the words mentioned below may be in file term.v
   or file net.v.

   Use these steps to start an Xhost node as it is done in word 
   XclientConnect during the pre-login phase.

   Reasons an Xhost node will not start:

      1. Incorrect entries in usr/xhost_start.n 
         Try: run the self tests in xhost_start.n

      2. Incorrect paths on the #! line in usr/dserv1 (TASK_PORT
         uses dserv1 and Xserver uses TASK_PORT to start Xhost)
         Try: run dserv1 standalone or run usr/telserver

      3. TASK_PORT not running
         Try: run test/net

      4. Telnet not starting
         a. Try: start usr/telserver -ntrace 
                 and log in with usr/telclient
            These run Part I and Part II of term.v; see next for more
            basic ways of running

         b. Try at the program's ready prompt in two different windows:
            1. Starting TELNETD server in one window (term.v, Part II):
               "term.v" "Server Words" msource ntrace 9877 TELNETD

            2. Starting a client in another window after the message 
            from TELNETD server reports listening on port 9877 (term.v,
            Part I); this should give a login prompt:
               "term.v" "Client Words" msource
               "clacker" 9877 CLIENT_TELNET

         c. A copy of the script from the latest start up, XHOST_START,
            is always left in home (~/).  Verify ports and the IP addr
            for Xserver.

      5. A slow system and start up timings set too low
         Try: different timing values in the test below

      6. Override the default time for Xhost node to start (WSEC=5)
         using a phrase like:
            20 "XclientConnect" "WSEC" bank \ 20 sec for Xhost to start

   Once the Xhost node starts, you can connect to it using the 
   listening socket number it returns, and then remoteprompt to it
   (see example below).

   Check the Xhost node log where output shows its progress.  Shown
   below is the tail command to watch the log in real time.  Look 
   for the time to start telnetd; if there is a timing problem, it
   may exceed time WSEC.  Start up time for telnetd is set in word
   TELNETD_START, file term.v.
}
   "server.v" "Xserver Words" msource

\  Timings (also check MAX_WAIT in TELNETD (but it should be plenty));
   0.1 (sec) "FDELAY" book \ delay Xhost start until DSERVER forks
   25 "WSEC" book          \ total time for Xhost node to start

\  Define host name and start tail to watch Xhost node log:
   "rufysnow" "HOST" book
\  % touch /tmp/rufysnow.log; tail -f /tmp/rufysnow.log

   WSEC 2 * (T) \ max sec for TASK_PORT (as used in XclientConnect)

\  Placing relevant strings into script XHOSTSTART as done in Xclient-
\  Connect:
   "XclientConnect" "XHOSTSTART" yank (qSCRIPT)
   "HOST" HOST strp
   "Sec1" WSEC intstr strp
   "Sec2" FDELAY "%0.4f" format strp (qScript)

\  The following will run Script to start Xhost node in T sec and return
\  the list of its parameters on the stack:
   dup nl . nl
   (T qScript) TASK_PORT (qList)

   private halt

   Example: the following shows running the phrases in this region:

      [dale@clacker] /home/dale > tops
               Tops 3.0.1
      Wed Dec 28 17:11:38 PST 2005
      [tops@clacker] ready > "server.v" "Diagnostics" msource
       word WebInput into catalog
       word Xhtml,0:XclientConnect into catalog
      ...
       word PORT_IN,0:Xserver into catalog
       word PRE__,0:Xserver into catalog
       word RET__,0:Xserver into catalog
       word ret__,0:Xserver into catalog
       word Xserver into catalog

   This is the script for TASK_PORT to run, built by the phrases
   above:

      "server.v" "Load XhostStart" msource
      5 "XhostStart" "WSEC" bank
      0.1000 "XhostStart" "FDELAY" bank
      host IPhost serverport "rufysnow" XhostStart (qList)
   
   TASK_PORT server has started:
       TASK_PORT: server start up (sec): 1.30

   TASK_PORT has returned.  Xhost node is running, and the following 
   are the parameters that would be returned to the stack of Xclient 
   in word XclientConnect (IP, PORT, PID, TPORT):

       stack elements:
             0 string: 127.0.0.1 9891 7948 9924  24 characters
       [1] ok!

   Here is going to the prompt of Xhost and viewing its main library:

      [tops@clacker] ready > IPloop 9891 CLIENT remoteprompt
      tops@socket3 > whos
       Stack items and words added to the main library:
        Name             Rows Cols Bytes Type  Description
        CLIENT_NEGOTIATE 166  1    664   PTR   inline
        ClientClose      49   1    196   PTR   inline
        ClientInput      154  1    616   PTR   inline
        docBk            15   1    60    PTR   inline
        docBl            4    1    16    PTR   inline
        docCopy          150  1    600   PTR   inline
        docCr            9    1    36    PTR   inline
      ...
        XtelnetSend      5    1    20    PTR   inline
        HOST             1    8    8     STR   string
        LOG              1    17   17    STR   string
        PORT             0    0    8     NUM   9891
        S1               0    0    8     NUM   0
        S2               0    0    8     NUM   0
        TPORT            0    0    8     NUM   9924
                                   8797  total
      tops@socket3 > 
   Pressing Esc+q to return to ready prompt

       stack elements:
             0 string: 127.0.0.1 9891 7948 9924  24 characters
       [1] ok!
      [tops@clacker] ready >

   Killing daemon Xhost node and its telnetd:

      [root@clacker] /home/dale # ps
      dale 7948 1  0 17:11 ?  00:00:00 /usr/local/bin/tops -p
                                       -s /usr/local/tops/sys/ 
                                       -u /opt/mytops/usr/ 
                                       /tmp/XHOST_START
      root 7955 1  0 17:11 ?  00:00:00 telnetd -debug 9924
      [root@clacker] /home/dale # kill -9 7948 7955 

   End of example

   Try this approach to start an Xhost node and connect to it:

      1. Start Xserver.  Here is a script in work.v that was used:

         "server.v" "Xserver Words" msource
         {"
            Xserver.SSL=yes;       # SSL option
            Xserver.show_conn=yes; # show connections in log
            XclientConnect.WSEC=20;# time for Xhost node to start
         "} >> parse << main
         wtrace 9870 Xserver

      2. From the ready prompt, run:

         "GET /login" 8 XclientConnect

      where 8 is a bogus socket number.  

      3. Some errors will be seen, but an Xhost node should start and 
         stay running.  Check these:
         a. ps -Af should show an Xhost job running
         b. log file, like /tmp/rufysnow.log
         c. from the ready prompt, remoteprompt to Xhost node by
            running: 
               IPloop 9890 CLIENT (if Xhost listening port is 9890)

   End of Trouble Shooting.

\-----------------------------------------------------------------------

; Appendix

------------------------------------------------------------------------

  Some traces during login are shown below (these may not reflect cur-
  rent operation):

  T on stack, from TELNETD, is something like this--user name + prompt
  for password (prompt for password may not be present, and will arrive
  in the next packet):
       0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F  0123456789ABCDEF
   0  64 61 6C 65 0D 0A 0D 0A 50 61 73 73 77 6F 72 64  dale....Password
   2  3A 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  :...............

  Note: the above is during early development and contains an unwanted
  (additional) 0D 0A after the user name.  Here is a later example of a
  transition from login name to request for password:

Xkey. KeyMode=2 Thu Nov 17 07:31:34 PST 2005
 remoteputf: writing 6 bytes on socket 4 [Sending login name to TELNETD]
       0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F  0123456789ABCDEF
   0  64 61 6C 65 0D 00 00 00 00 00 00 00 00 00 00 00  dale............
 drainf: entering
 readn1: 6 bytes received on socket 4 [Receiving login name echo from
    TELNETD]
       0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F  0123456789ABCDEF
   0  64 61 6C 65 0D 0A 00 00 00 00 00 00 00 00 00 00  dale............
 drainf: 6 bytes from socket 4 type 1 ptrRun 0x43 0x80000000
 readn1: 0 bytes received on socket 4
 drainf: exit while-loop for socket 4
 drainf: 6 total bytes from socket 4
 drainf: socket 4 running ptr 0x43 0x80000000
 Xoutput: TELNETD to Xclient: dale
 Thu Nov 17 07:31:34 PST 2005
 remoteputf: writing 6 bytes on socket 1 [Sending this echo of login
    name from TELNETD to client]
       0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F  0123456789ABCDEF
   0  64 61 6C 65 0D 0A 00 00 00 00 00 00 00 00 00 00  dale............
 drainf: entering
 readn1: 10 bytes received on socket 4 [Receiving request from TELNETD]
       0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F  0123456789ABCDEF
   0  50 61 73 73 77 6F 72 64 3A 20 00 00 00 00 00 00  Password: ......
 drainf: 10 bytes from socket 4 type 1 ptrRun 0x48 0x80000000
 readn1: 0 bytes received on socket 4
 drainf: exit while-loop for socket 4
 drainf: 10 total bytes from socket 4
 drainf: socket 4 running ptr 0x48 0x80000000

 Running word LoginPasswd:
 LoginPasswd: Password:  Thu Nov 17 07:31:34 PST 2005
 Xoutput: TELNETD to Xclient: Password:  Thu Nov 17 07:31:34 PST 2005
 remoteputf: writing 10 bytes on socket 1 [Sending TELNETD request for 
    password to client]
       0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F  0123456789ABCDEF
   0  50 61 73 73 77 6F 72 64 3A 20 00 00 00 00 00 00  Password: ......

------------------------------------------------------------------------

   Xserver notes on closing (somewhat outdated; Xclientclose is now
   called ClientClose)

   1. This shows timeout by system login when Xclient does not respond 
      within 60 seconds to login prompt (rightmost floating point num-
      bers are fractions that add to the SS of HH:MM:SS).
      (See "Xhost notes on closing" for the view of this from Xhost.)

      Mon Jan  2 18:55:13 UTC 2006 SERVER: connection from ...

      [The next line is relaying login prompt from Xhost to Xclient.]
      Bottom of XhostOutput Mon Jan  2 18:55:16 UTC 2006  1.9991E-01

      ... one minute passes, then system login times out

      [The next line is relaying message to Xclient from Xhost (word 
      XtelnetClose) that connection is closing.]
      Bottom of XhostOutput Mon Jan  2 18:56:16 UTC 2006  1.0300E-01

      [Xhost word ClientClose closes socket S2 to Xserver, and Xserver 
      word XhostClose is run automatically.]
      Top of XhostClose Mon Jan  2 18:56:16 UTC 2006  

         [XhostClose node closes S1, and XclientClose is run automati-
         cally.]
         Bottom of XclientClose Mon Jan  2 18:56:16 UTC 2006  1.1049E-01

      Bottom of XhostClose Mon Jan  2 18:56:16 UTC 2006  1.1502E-01
      [Time shown is one minute later than the login prompt.]

------------------------------------------------------------------------

   Xhost notes on closing 
   (messages to Xserver noted are relayed by Xserver to Xclient)

   1. This shows timeout by system login when Xserver (Xclient) does
      not respond within 60 seconds to login prompt (floating point
      numbers on the right are fractions to add to SS of HH:MM:SS).
      (See "Xserver notes on closing" for the view of this from
      Xserver.)

      Mon Jan  2 18:55:16 UTC 2006 SERVER: connection from 127.0.0.1

      [Sending login: to Xserver.]
      Top of Xoutput Mon Jan  2 18:55:16 UTC 2006  1.8172E-01
      Bottom of Xoutput Mon Jan  2 18:55:16 UTC 2006  1.8972E-01

      ... one minute passes and XtelnetClose is automatically called
      when socket S2 closes due to system login timeout

      Top of XtelnetClose Mon Jan  2 18:56:16 UTC 2006  8.2080E-02

         Top of Xoutput Mon Jan  2 18:56:16 UTC 2006  8.6084E-02
         [Sending message to Xserver that connection is closing.]
         Bottom of Xoutput Mon Jan  2 18:56:16 UTC 2006  9.2804E-02

         [Socket S1 to Xserver is closed when next line appears.]
         Top of ClientClose Mon Jan  2 18:56:16 UTC 2006  1.2839E-01
         ClientClose: killing telnetd on port 9923
         ClientClose: exit Mon Jan  2 18:56:16 UTC 2006
         [ALARM has been set for Xhost node to exit in 1 second.]

      Bottom of XtelnetClose Mon Jan  2 18:56:16 UTC 2006  1.5186E-01
      [Xhost node will exit in less than one second.]

------------------------------------------------------------------------

Code no longer used.

ACK method from WebInput:
        {"  (qT --- ) send ACK to Xclient via its host, HOST(T)
{
            ACK to Xclient must come from Xhost to have the proper 
            frame count, so this function sends ACK to Xhost to
            send to Xclient.  

            All data from here to Xhost is received in ClientInput().
            Processing method X in ClientInput() will send an ACK to 
            Xclient with the right frame count.  

            ACK will come back through this server via XhostOutput() 
            on its way to Xclient.
}
\           Get the socket to Xhost serving this Xclient:
            (qT) 2nd word 
            IF -1 indent (HOST) \ Xhost name in 2nd word
               (HOST) "XhostName" "FetchSocket" yank (nS2) any?
               IF (nS2) \ socket for Xhost serving this Xclient
                  "XclientLogin" "LOGGED" yank that pry true =
                  IF \ client on Xhost is logged in:
                     "X" \ specify processing method X on Xhost
                     "" 03 vtreserved + (qT) \ ACK message for Xclient
\                    This is an example an ACK message: 58 0F 03, where 
\                    0x58 is X, 0x0F and 0x03 are used in Xclient.js

1 nACK bump "+++++++++++++++++ nACK:" . nACK .i nl
                    (nS2 qT) swap remoteputf0 \ send ACK to Xhost
                  ELSE (nS2) drop 
        0 "nACK" book
                  THEN
               THEN
            THEN
        "} "ACK" macro

These are the lines of WebInput when ACK is used:
\     Process incoming method from an Xclient on socket S.

\     Require BYTES or more when socket is read. 
      (qT nS) those chars BYTES >=

      IF that (qT) 1st catch (qM) this local? \ macro M from local lib

         IF (qT nS qM)         \ M is the macro to run
            other (qT) ACK     \ send ACK to Xclient before running M
         ELSE drop (qT nS) "U" \ else use macro U, unknown 
         THEN    

      ELSE (qT nS) "U"         \ else use macro U, unknown 
      THEN    

      (qT nS qM) local \ run the designated macro from local lib

      yes READY \ put server back in action (G method suspends it)
   end

These are the lines in ClientInput when ACK is used (method X):
        {" (qT) Method X: send vt parsed message T to Xclient
"************ X method" . nl
1 nACK bump "+++++++++++++++++ nACK:" . nACK .i nl
           (qT) -1 indent Xoutput1 
        "} "X" macro
0 "nACK" book
