// Cook_shader.hpp
//
// Copyright 2012-2013 Roan Trail, Inc.
//
// This file is part of Tovero.
//
// Tovero is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License
// version 2.1 as published by the Free Software Foundation.
//
// Tovero is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.  You should have
// received a copy of the GNU Lesser General Public License along with
// Tovero. If not, see <http://www.gnu.org/licenses/>.

// Cook-Torrence direct illumination shader

#ifndef TOVERO_GRAPHICS_COOK_SHADER_HPP_
#define TOVERO_GRAPHICS_COOK_SHADER_HPP_

#include <tovero/graphics/base/Shader.hpp>
#include <tovero/math/geometry/Unitless.hpp>
#include <string>

namespace Roan_trail
{
  namespace Tovero_graphics
  {
    class Cook_shader : public Shader
    {
    public:
      // constructors/copy
      Cook_shader(const std::string& name = "");
      Cook_shader(const Roan_trail::Tovero_math::Unitless& slope,
                  int shine,
                  const Roan_trail::Tovero_math::Unitless& specular,
                  const Roan_trail::Tovero_math::Unitless& diffuse,
                  const Roan_trail::Tovero_math::Unitless& transmitted,
                  const Roan_trail::Tovero_math::Unitless& reflected,
                  const Roan_trail::Tovero_math::Unitless& refractive_index,
                  const Roan_trail::Tovero_math::Unitless& extinction,
                  const std::string& name = "");
      Cook_shader(const Cook_shader& shader);
      Cook_shader& operator=(const Cook_shader& shader);
      // accessors/mutators
      const Roan_trail::Tovero_math::Unitless& slope() const { return m_slope; }
      void set_slope(const Roan_trail::Tovero_math::Unitless& value) { m_slope = value; }
      int shine() const { return m_shine; }
      void set_shine(int value) { m_shine = value; }
      const Roan_trail::Tovero_math::Unitless& specular() const { return m_specular; }
      void set_specular(const Roan_trail::Tovero_math::Unitless& value) { m_specular = value; }
      const Roan_trail::Tovero_math::Unitless& diffuse() const { return m_diffuse; }
      void set_diffuse(const Roan_trail::Tovero_math::Unitless& value) { m_diffuse = value; }
      const Roan_trail::Tovero_math::Unitless& transmitted() const { return m_transmitted; }
      void set_transmitted(const Roan_trail::Tovero_math::Unitless& value) { m_transmitted = value; }
      const Roan_trail::Tovero_math::Unitless& reflected() const { return m_reflected; }
      void set_reflected(const Roan_trail::Tovero_math::Unitless& value) { m_reflected = value; }
      const Roan_trail::Tovero_math::Unitless& refractive_index() const { return m_refractive_index; }
      void set_refractive_index(const Roan_trail::Tovero_math::Unitless& value) { m_refractive_index = value; }
      const Roan_trail::Tovero_math::Unitless& extinction() const { return m_extinction; }
      void set_extinction(const Roan_trail::Tovero_math::Unitless& value) { m_extinction = value; }
      // shader presets
      static Cook_shader& cook();
      static Cook_shader& mirror();
      static Cook_shader& glass();
    private:
      // shader parameters
      Roan_trail::Tovero_math::Unitless m_slope;
      int m_shine;
      Roan_trail::Tovero_math::Unitless m_specular;
      Roan_trail::Tovero_math::Unitless m_diffuse;
      Roan_trail::Tovero_math::Unitless m_transmitted;
      Roan_trail::Tovero_math::Unitless m_reflected;
      Roan_trail::Tovero_math::Unitless m_refractive_index;
      // TODO: what are the units for this?
      Roan_trail::Tovero_math::Unitless m_extinction;
      // visitor
      virtual Shader_visitor::Visit_result accept(Shader_visitor& visitor) const { return visitor.visit(*this); }
    protected:
      virtual ~Cook_shader() {}
    };
  }
}

#endif // TOVERO_GRAPHICS_COOK_SHADER_HPP_
