// Light_shader.hpp
//
// Copyright 2012-2013 Roan Trail, Inc.
//
// This file is part of Tovero.
//
// Tovero is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License
// version 2.1 as published by the Free Software Foundation.
//
// Tovero is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.  You should have
// received a copy of the GNU Lesser General Public License along with
// Tovero. If not, see <http://www.gnu.org/licenses/>.

// Light points in the -Z direction, have to perform a rotation to change

#ifndef TOVERO_GRAPHICS_LIGHT_SHADER_HPP_
#define TOVERO_GRAPHICS_LIGHT_SHADER_HPP_

#include <tovero/graphics/base/Shader.hpp>
#include <tovero/math/geometry/Angle.hpp>
#include <tovero/math/geometry/Unit_vector.hpp>
#include <tovero/math/geometry/Unitless.hpp>
#include <string>

namespace Roan_trail
{
  namespace Tovero_graphics
  {
    class Light_shader : public Shader
    {
    public:
      // constructors/copy
      Light_shader(const std::string& name = "");
      Light_shader(const Roan_trail::Tovero_math::Unit_vector& target_direction,
                   const Roan_trail::Tovero_math::Unitless& intensity,
                   const Roan_trail::Tovero_math::Angle& beam_dispersion_angle,
                   const Roan_trail::Tovero_math::Unitless& fraction,
                   int shadow_ray_count,
                   bool infinite,
                   bool visible,
                   const std::string& name = "");
      Light_shader(const Light_shader& shader);
      Light_shader& operator=(const Light_shader& shader);
      // accessors/mutators
      const Roan_trail::Tovero_math::Unit_vector& target_direction() const { return m_target_direction; }
      void set_target_direction(const Roan_trail::Tovero_math::Unit_vector& value) { m_target_direction = value; }
      const Roan_trail::Tovero_math::Unitless& intensity() const { return m_intensity; }
      void set_intensity(const Roan_trail::Tovero_math::Unitless& value) { m_intensity  = value; }
      const Roan_trail::Tovero_math::Angle& beam_dispersion_angle() const { return m_beam_dispersion_angle; }
      void set_beam_dispersion_angle(const Roan_trail::Tovero_math::Angle& value)
      { m_beam_dispersion_angle = value; }
      const Roan_trail::Tovero_math::Unitless& fraction() const { return m_fraction; }
      void set_fraction(const Roan_trail::Tovero_math::Unitless& value) { m_fraction = value; }
      int shadow_ray_count() const { return m_shadow_ray_count; }
      void set_shadow_ray_count(int value) { m_shadow_ray_count = value; }
      bool is_infinite() const { return m_is_infinite; }
      void set_is_infinite(bool value) { m_is_infinite = value; }
      bool is_visible() const { return m_is_visible; }
      void set_is_visible(bool value) { m_is_visible = value; }
    private:
      // shader parameters
      Roan_trail::Tovero_math::Unit_vector m_target_direction;
      // TODO: what are the units for this?
      Roan_trail::Tovero_math::Unitless m_intensity;
      Roan_trail::Tovero_math::Angle m_beam_dispersion_angle;
      Roan_trail::Tovero_math::Unitless m_fraction;
      int m_shadow_ray_count;
      bool m_is_infinite;
      bool m_is_visible;
      // visitor
      virtual Shader_visitor::Visit_result accept(Shader_visitor& visitor) const { return visitor.visit(*this); }
    protected:
      virtual ~Light_shader() {}
    };
  }
}

#endif // TOVERO_GRAPHICS_LIGHT_SHADER_HPP_
