// Half_space.hpp
//
// Copyright 2012-2013 Roan Trail, Inc.
//
// This file is part of Tovero.
//
// Tovero is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License
// version 2.1 as published by the Free Software Foundation.
//
// Tovero is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.  You should have
// received a copy of the GNU Lesser General Public License along with
// Tovero. If not, see <http://www.gnu.org/licenses/>.

// Half-space, specified by a normal vector indicating the outward facing
// direction of a plane and a perpendicular distance from the origin
// to the plane.

#ifndef TOVERO_MATH_HALF_SPACE_HPP_
#define TOVERO_MATH_HALF_SPACE_HPP_

#include <tovero/math/geometry/Solid.hpp>
#include <tovero/math/geometry/Distance.hpp>
#include <tovero/math/geometry/Unit_vector.hpp>
#include <string>

namespace Roan_trail
{
  namespace Tovero_math
  {
    class Half_space : public Solid
    {
    public:
      // constructors/copy
      // defaults to a plane facing the positive x-axis through the origin
      Half_space(const std::string& name = "");
      Half_space(const Unit_vector& normal,
                 const Distance& distance,
                 const std::string& name = "");
      virtual Solid* clone_solid() const { return new Half_space(*this); }
      //   Note: let compiler generate the default copy constructor and operator=
      // accessors/mutators
      const Unit_vector& normal() const { return m_normal; }
      void set_normal(const Unit_vector& normal) { m_normal = normal; }
      const Distance& distance() const { return m_distance; }
      void set_distance(const Distance& distance) { m_distance = distance; }
      // predicates
      virtual bool is_valid(const Geometric_tolerances& tolerances,
                            Roan_trail::Tovero_support::Error_param& return_error) const;
      // visitor
      virtual Solid_visitor::Visit_result accept(Solid_visitor& visitor) const { return visitor.visit(*this); }
      // other
      virtual std::string solid_class() const { return "Half_space"; }
    protected:
      // destructor
      virtual ~Half_space() {}
    private:
      // solid parameters
      Unit_vector m_normal; // direction the plane faces (outward)
      Distance m_distance;  // perpendicular distance from origin to plane
    };
  }
}

#endif // TOVERO_MATH_HALF_SPACE_HPP_
