# test_box.rb
#
# Copyright 2012-2013 Roan Trail, Inc.
#
# This file is part of Tovero.
#
# Tovero is free software; you can redistribute it and/or modify it
# under the terms of the GNU Lesser General Public License
# version 2.1 as published by the Free Software Foundation.
#
# Tovero is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# Lesser General Public License for more details.  You should have
# received a copy of the GNU Lesser General Public License along with
# Tovero. If not, see <http://www.gnu.org/licenses/>.

# Ruby unit test (minitest) for the Box class

require 'minitest/autorun'
require 'test/unit'
require 'libtovero_support_rb_0'
require 'libtovero_math_rb_0'

include Libtovero_support_rb_0
include Libtovero_math_rb_0

class TestBox < Test::Unit::TestCase
  def setup
    @Tolerances = GeometricTolerances.new
  end

  #
  # Solid validity checks
  #

  def test_default
    box = Box.new
    error = ErrorParam.new
    #
    assert box.is_valid?(@Tolerances, error)
  end

  def test_zero_length_dimension
    box = Box.new
    box.name = "box"
    zero_length_vector = Vector.new
    box.depth = zero_length_vector
    error = ErrorParam.new
    #
    refute box.is_valid?(@Tolerances, error)
    assert (error.base.error_class == 'Math_error') and (error.base.code.equal? MathError::Validation)
  end

  def test_direction_vectors_not_mutually_perpendicular
    box = Box.new
    box.height = UnitVector::z * Distance.new(1.0, Distance::meter)
    box.width = UnitVector::z * Distance.new(1.0, Distance::meter)
    box.depth = UnitVector::y * Distance.new(1.0, Distance::meter)
    error = ErrorParam.new
    #
    refute box.is_valid?(@Tolerances, error)
    assert (error.base.error_class == 'Math_error') and (error.base.code.equal? MathError::Validation)
  end

  #
  # Miscellaneous checks
  #

  def test_properties
    box = Box.new
    #
    assert_respond_to box, :vertex
    assert_respond_to box, :vertex=
    assert_respond_to box, :width
    assert_respond_to box, :width=
    assert_respond_to box, :height
    assert_respond_to box, :height=
    assert_respond_to box, :depth
    assert_respond_to box, :depth=
  end

end
