// Reference_counting_base.hpp
//
// Copyright 2012-2013 Roan Trail, Inc.
//
// This file is part of Tovero.
//
// Tovero is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License
// version 2.1 as published by the Free Software Foundation.
//
// Tovero is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.  You should have
// received a copy of the GNU Lesser General Public License along with
// Tovero. If not, see <http://www.gnu.org/licenses/>.

// Abstract base class for Tovero reference counting objects
// (with object naming)

#ifndef TOVERO_SUPPORT_REFERENCE_COUNTING_BASE_HPP_
#define TOVERO_SUPPORT_REFERENCE_COUNTING_BASE_HPP_

#include <tovero/support/common.hpp>
#include <string>

namespace Roan_trail
{
  namespace Tovero_support
  {
    class Reference_counting_base
    {
    public:
      // accessors/mutators
      Long_int reference_count() const { return m_reference_count; }
      const std::string& name() const { return m_name; }
      void set_name(const std::string& name) { m_name = name; }
      // reference/unreference
      // (Note: these member functions are const because the reference count is mutable
      //  with respect to const-ness)
      void reference() const { ++m_reference_count; }
      void unreference_no_delete() const;
      void unreference() const;
    protected:
      // constructor/destructor/copy
      Reference_counting_base(const std::string& name = "") : m_reference_count(0), m_name(name) {}
      Reference_counting_base(const Reference_counting_base& b) : m_reference_count(0), m_name(b.m_name) {}
      Reference_counting_base& operator=(const Reference_counting_base& base);
      virtual ~Reference_counting_base() {} // protected to disallow explicit delete
      // class invariant
      bool mf_invariant(bool check_base_class = true) const;
    private:
      mutable Long_int m_reference_count;
      std::string m_name;
    };
  }
}

#endif // TOVERO_SUPPORT_REFERENCE_COUNTING_BASE_HPP_
