# -*- makefile-automake -*-
#
# Makefile.inc
#
# Copyright 2011-2014 Roan Trail, Inc.
#
# This file is part of Tovero.
#
# Tovero is free software; you can redistribute it and/or modify it
# under the terms of the GNU Lesser General Public License
# version 2.1 as published by the Free Software Foundation.
#
# Tovero is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# Lesser General Public License for more details.  You should have
# received a copy of the GNU Lesser General Public License along with
# Tovero. If not, see <http://www.gnu.org/licenses/>.

#
# Debug options
#
if CFG_COND_DEBUG
#  debug
FLAG_OPTIMIZE = -g
FLAG_DEF_NDEBUG =
FLAG_STRIP_SYMBOLS =
else
#  non-debug
FLAG_OPTIMIZE = -O2
FLAG_DEF_NDEBUG = -DNDEBUG
FLAG_STRIP_SYMBOLS = -s
#    turn warnings off for supplying string literals to functions having char *
#    arguments
CXX_WARNINGS = -Wno-write-strings
endif

#
# Setup the automake compiler flags
#

#   Preprocessor flags
AM_CPPFLAGS = $(FLAG_DEF_NDEBUG) @BOOST_CPPFLAGS@
#   C++ flags
AM_CXXFLAGS = -fmessage-length=0 \
              -fno-nonansi-builtins \
              $(FLAG_OPTIMIZE) \
              $(CXX_WARNINGS)
#   C flags
AM_CFLAGS = -fmessage-length=0 -Wall \
            $(FLAG_OPTIMIZE)
#   Linker flags
AM_LDFLAGS = $(FLAG_STRIP_SYMBOLS) @BOOST_LDFLAGS@

# Shared Boost libraries
BOOST_LIBS = @BOOST_SYSTEM_LIB@

LIBS = @LIBS@ ${BOOST_LIBS}

#
# Miscellaneous setup
#

# Not currently set in the BRL-CAD pkg-config, so we set this up...
BRLCAD_OPENNURBS_CFLAGS = -I@CFG_BRLCAD_INSTALL_PATH@/include/openNURBS

# Set the Ruby library directory path for testing
# export RUBYLIB := $(top_srcdir)/src/tovero/support/.libs:
#      $(top_srcdir)/src/tovero/math/.libs:$(top_srcdir)/src/tovero/graphics/.libs

# setup the base library include directory
LIBRARY_BASE_INCLUDE_DIR = $(top_srcdir)/src
LIBRARY_BASE_DIST_INCLUDE_DIR = $(includedir)/tovero-1/tovero

# setup the sample directory
sampledir = $(docdir)/sample
