// Database.hpp
//
// Copyright 2012-2014 Roan Trail, Inc.
//
// This file is part of Tovero.
//
// Tovero is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License
// version 2.1 as published by the Free Software Foundation.
//
// Tovero is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.  You should have
// received a copy of the GNU Lesser General Public License along with
// Tovero. If not, see <http://www.gnu.org/licenses/>.

// Graphics database

#ifndef TOVERO_GRAPHICS_DATABASE_HPP_
#define TOVERO_GRAPHICS_DATABASE_HPP_

#include <tovero/math/geometry/Geometric_tolerances.hpp>
#include <tovero/support/Reference_counting_list.hpp>
#include <string>
#include <vector>

namespace Roan_trail
{
  namespace Tovero_support
  {
    template <class Value_type> class Reference_counting_list;
    class Error_param;
  }

  namespace Tovero_math
  {
    class Solid;
    class Solid_combination_base;
    class Units_mapper;
  }

  typedef Roan_trail::Tovero_support::Reference_counting_list<Tovero_math::Solid> Solid_list;

  namespace Tovero_graphics
  {
    class Database
    {
    public:
      // constructor/destructor/initialization
      Database(const std::string& title = "",
               const Roan_trail::Tovero_math::Geometric_tolerances& tolerances =
               Roan_trail::Tovero_math::Geometric_tolerances());
      virtual ~Database();
      // accessors/mutators
      const std::string& title() const { return m_title; }
      void set_title(const std::string& title) { m_title = title; }
      const Roan_trail::Solid_list& top_solids() const { return *m_top_solids; }
      Roan_trail::Solid_list& top_solids() { return *m_top_solids; }
      const Roan_trail::Tovero_math::Geometric_tolerances& tolerances() const { return m_tolerances; }
      void set_tolerances(const Roan_trail::Tovero_math::Geometric_tolerances& tolerances)
      { m_tolerances = tolerances; }
      const Roan_trail::Tovero_math::Units_mapper& units_mapper() const { return *m_units_mapper; }
      Roan_trail::Tovero_math::Units_mapper& units_mapper() { return *m_units_mapper; }
      // read/write
      //   write solids in list
      virtual bool write(const std::string& path,
                         bool overwrite,
                         Roan_trail::Tovero_support::Error_param& return_error) = 0;
      //   write an arbitrary solid
      virtual bool write_solid(Roan_trail::Tovero_math::Solid* solid,
                               const std::string& path,
                               bool overwrite,
                               Roan_trail::Tovero_support::Error_param& return_error) = 0;
      //   read solids into list
      virtual bool read(const std::string& path,
                        const std::vector<std::string>& objects,
                        Roan_trail::Tovero_support::Error_param& return_error) = 0;
    protected:
      // invariant check
      bool mf_invariant(bool check_base_class = true) const;
    private:
      std::string m_title;
      Roan_trail::Solid_list* m_top_solids;
      Roan_trail::Tovero_math::Geometric_tolerances m_tolerances;
      Roan_trail::Tovero_math::Units_mapper* m_units_mapper;
    };
  }
}

#endif // TOVERO_GRAPHICS_DATABASE_HPP_
