// BC_combination_attributes.cpp
//
// Copyright 2012-2013 Roan Trail, Inc.
//
// This file is part of Tovero.
//
// Tovero is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License
// version 2.1 as published by the Free Software Foundation.
//
// Tovero is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.  You should have
// received a copy of the GNU Lesser General Public License along with
// Tovero. If not, see <http://www.gnu.org/licenses/>.

#include <tovero/graphics/brlcad/BC_combination_attributes.hpp>
#include <tovero/graphics/brlcad/BC_shader.hpp>
#include <tovero/graphics/base/Color.hpp>
#include <tovero/graphics/base/Combination_attributes.hpp>
#include <tovero/graphics/base/Shader.hpp>
#include <map>
#include <string>

using std::string;
using namespace Roan_trail::Tovero_graphics;

//
// Constructors
//

BC_combination_attributes::BC_combination_attributes(Combination_attributes& attributes)
  : m_material(attributes.material_code()),
    m_color(0),
    m_is_region(attributes.is_part()),
    m_children_inherit(attributes.children_inherit()),
    //
    m_attributes(&attributes),
    m_BC_shader(0)
{
  m_attributes->reference();

  if (m_attributes->shader())
  {
    m_BC_shader = new BC_shader(*(attributes.shader()));
    // shader setup (using visitor pattern)
    m_attributes->shader()->accept(*m_BC_shader); // TODO: check return value?
  }

  // color setup
  Color* color = m_attributes->color();
  if (color)
  {
    m_color = new unsigned char[3];
    m_color[0] = color->red();
    m_color[1] = color->green();
    m_color[2] = color->blue();
  }
}

BC_combination_attributes::BC_combination_attributes(const string& shader,
                                                     int material,
                                                     const unsigned char* color,
                                                     bool is_region,
                                                     bool children_inherit)
  : m_material(material),
    m_color(0),
    m_is_region(is_region),
    m_children_inherit(children_inherit),
    //
    m_attributes(0),
    m_BC_shader(new BC_shader(shader))
{
  // if any of the arguments is not a default, create a combination attributes object
  if (("" != shader)
      || (0 != material)
      || (0 != color)
      || (false != is_region)
      || (children_inherit != false))
  {
    m_attributes = new Combination_attributes(m_BC_shader->shader(),
                                              material,
                                              (color ?
                                               new Color(color[0],
                                                         color[1],
                                                         color[2],
                                                         0) : 0),
                                              is_region,
                                              children_inherit);
    m_attributes->reference();
  }

  // setup color
  if (color)
  {
    m_color = new unsigned char[3];
    m_color[0] = color[0];
    m_color[1] = color[1];
    m_color[2] = color[2];
  }
}

BC_combination_attributes::~BC_combination_attributes()
{
  delete [] m_color;

  delete m_BC_shader;

  if (m_attributes)
  {
    m_attributes->unreference();
  }
}

//
// Accessors
//

void BC_combination_attributes::copy_color(unsigned char color[3]) const
{
  if (m_color)
  {
    color[0] = m_color[0];
    color[1] = m_color[1];
    color[2] = m_color[2];
  }
}
