// -*- C++ -*-
//
// graphics.i
//
// Copyright 2012-2014 Roan Trail, Inc.
//
// This file is part of Tovero.
//
// Tovero is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License
// version 2.1 as published by the Free Software Foundation.
//
// Tovero is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.  You should have
// received a copy of the GNU Lesser General Public License along with
// Tovero. If not, see <http://www.gnu.org/licenses/>.

// SWIG interface file for the Tovero graphics library
// Notes:
//   %include <file> generates wrapper code for file
//   %import <file> just reads declarations, and does not generate wrapper code

%module "libtovero_graphics_rb_1"

%import "../math/math.i"

// Note: code between the %{ %} brackets is copied verbatim to the wrapper file
%{
  #include <sstream>
  #include "../support/error/Error.hpp"
  #include "../support/Logger.hpp"
  #include "../support/Reference_counting_list.hpp"
  #include "../math/geometry/Solid.hpp"
  #include "../math/geometry/Solid_member.hpp"
  #include "../math/geometry/Transformation.hpp"
  //
  #include "base/Color.hpp"
  #include "base/Combination.hpp"
  #include "base/Combination_attributes.hpp"
  #include "base/Cook_shader.hpp"
  #include "base/Database.hpp"
  #include "base/Light_shader.hpp"
  #include "base/Operation.hpp"
  #include "base/Phong_shader.hpp"
  #include "base/Shader.hpp"
  #include "base/Shader_visitor.hpp"
  #include "base/Toon_shader.hpp"
  #include "brlcad/BC_combination_attributes.hpp"
  #include "brlcad/BC_database_reader.hpp"
  #include "brlcad/BC_database_writer.hpp"
  #include "brlcad/BC_database.hpp"

  using Roan_trail::Tovero_math::Solid;
  using Roan_trail::Tovero_graphics::Shader_visitor;
%}

//
// Ruby-specific interface
//

#ifdef SWIGRUBY

// helps Ruby handle uint8_t
%apply unsigned char { uint8_t };

%alias Roan_trail::Tovero_support::Reference_counting_list<Roan_trail::Tovero_math::Solid>::push_back "<<";

namespace Roan_trail
{
  namespace Tovero_graphics
  {
    //   Color
    %rename("red=") Color::set_red(uint8_t red);
    %rename("green=") Color::set_green(uint8_t green);
    %rename("blue=") Color::set_blue(uint8_t blue);
    %rename("alpha=") Color::set_alpha(uint8_t alpha);
    //   Combination
    %rename("attributes=") Combination::set_attributes(Combination_attributes* attributes);
    //   Combination_attributes
    %rename("shader=") Combination_attributes::set_shader(Shader* shader);
    %rename("material_code=") Combination_attributes::set_material_code(int code);
    %rename("color=") Combination_attributes::set_color(Color* color);
    %predicate Combination_attributes::is_part() const;
    %rename("is_part=") Combination_attributes::set_is_part(bool is_part);
    %predicate Combination_attributes::children_inherit() const;
    %rename("children_inherit=") Combination_attributes::set_children_inherit(bool children_inherit);
    //   Cook_shader
    %rename("slope=") Cook_shader::set_slope(const Roan_trail::Tovero_math::Unitless& value);
    %rename("shine=") Cook_shader::set_shine(int value);
    %rename("specular=") Cook_shader::set_specular(const Roan_trail::Tovero_math::Unitless& value);
    %rename("diffuse=") Cook_shader::set_diffuse(const Roan_trail::Tovero_math::Unitless& value);
    %rename("transmitted=") Cook_shader::set_transmitted(const Roan_trail::Tovero_math::Unitless& value);
    %rename("reflected=") Cook_shader::set_reflected(const Roan_trail::Tovero_math::Unitless& value);
    %rename("refractive_index=")
    Cook_shader::set_refractive_index(const Roan_trail::Tovero_math::Unitless& value);
    %rename("extinction=") Cook_shader::set_extinction(const Roan_trail::Tovero_math::Unitless& value);
    //   Light_shader
    %rename("target_direction=")
    Light_shader::set_target_direction(const Roan_trail::Tovero_math::Unit_vector& value);
    %rename("intensity=") Light_shader::set_intensity(const Roan_trail::Tovero_math::Unitless& value);
    %rename("beam_dispersion_angle=")
    Light_shader::set_beam_dispersion_angle(const Roan_trail::Tovero_math::Angle& value);
    %rename("fraction=") Light_shader::set_fraction(const Roan_trail::Tovero_math::Unitless& value);
    %rename("shadow_ray_count=") Light_shader::set_shadow_ray_count(int value);
    %predicate Light_shader::is_infinite() const;
    %rename("is_infinite=") Light_shader::set_is_infinite(bool value);
    %predicate Light_shader::is_visible() const;
    %rename("is_visible=") Light_shader::set_is_visible(bool value);
    //   Operation
    %rename("attributes=") Operation::set_attributes(Combination_attributes* attributes);
    //   Phong_shader
    %rename("shine=") Phong_shader::set_shine(int value);
    %rename("specular=") Phong_shader::set_specular(const Roan_trail::Tovero_math::Unitless& value);
    %rename("diffuse=") Phong_shader::set_diffuse(const Roan_trail::Tovero_math::Unitless& value);
    %rename("transmitted=") Phong_shader::set_transmitted(const Roan_trail::Tovero_math::Unitless& value);
    %rename("reflected=") Phong_shader::set_reflected(const Roan_trail::Tovero_math::Unitless& value);
    %rename("refractive_index=")
    Phong_shader::set_refractive_index(const Roan_trail::Tovero_math::Unitless& value);
    %rename("extinction=") Phong_shader::set_extinction(const Roan_trail::Tovero_math::Unitless& value);
    %rename("emission_red=") Phong_shader::set_emission_red(const Roan_trail::Tovero_math::Unitless& value);
    %rename("emission_green=") Phong_shader::set_emission_green(const Roan_trail::Tovero_math::Unitless& value);
    %rename("emission_blue=") Phong_shader::set_emission_blue(const Roan_trail::Tovero_math::Unitless& value);
  }
}

#endif // SWIGRUBY

// Note: the template parameter must be qualified with a namespace
//       so the appropriate conversion (e.g. value -> pointer) is used by SWIG

%template(SolidList) Roan_trail::Tovero_support::Reference_counting_list<Roan_trail::Tovero_math::Solid>;

//
// Wrap classes
//

%include "base/Color.hpp"
%include "base/Database.hpp"
%include "base/Shader.hpp"
//
%include "base/Combination_attributes.hpp"
%include "base/Cook_shader.hpp"
%include "base/Light_shader.hpp"
%include "base/Phong_shader.hpp"
%include "base/Toon_shader.hpp"
//
// Note: %feature("notabstract") used to force wrapping of constructor
%feature("notabstract") Roan_trail::Tovero_graphics::Combination;
%include "base/Combination.hpp"
%feature("notabstract") Roan_trail::Tovero_graphics::Operation;
%include "base/Operation.hpp"
//
%include "brlcad/BC_database.hpp"
