#!/usr/bin/ruby
#
# whale.rb
#
# Copyright 2012-2014 Roan Trail, Inc.
#
# This file is part of Tovero.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
#
#   (1) Redistributions of source code must retain the above copyright
#   notice, this list of conditions and the following disclaimer.
#
#   (2) Redistributions in binary form must reproduce the above copyright
#   notice, this list of conditions and the following disclaimer in
#   the documentation and/or other materials provided with the
#   distribution.
#
#   (3) The name of the author may not be used to
#   endorse or promote products derived from this software without
#   specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
# INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
# (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
# STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
# IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.

#
# Command line argument processing first
#

mode = ARGV[0]

if mode == 'edit'
  raytrace = false
elsif mode == 'render' or mode == nil
  raytrace = true
else
  abort "error, if an argument is supplied, it must be edit or render"
end

# These load the extension libraries
require 'libtovero_support_rb_1'
require 'libtovero_math_rb_1'
require 'libtovero_graphics_rb_1'

# These are like "using namespace" in C++
include Libtovero_support_rb_1
include Libtovero_math_rb_1
include Libtovero_graphics_rb_1

$shapes = Array.new

load 'whale_data.rb'

# Note: consistently setting the name of graphical entities makes
# it easier to work with the model in BRL-CAD, if necessary
combo = SolidCombination.new("megaptera.c")

$shapes.each { |shape| combo.add_member(SolidMember.new(shape)) }

BC_DB = BCDatabase.new
sl = BC_DB.top_solids
sl << combo

database_file = "whale.g"

error = ErrorParam.new
success = BC_DB.write(database_file, true, error)
if (not success)
  puts("Could not write #{database_file}:")
  puts error.base.to_s
else
  if raytrace
    image_height = 1024
    image_width = 1024

    #   options to "rt":
    #     -A [ambient light fraction (0.0 - 1.0)]
    #     -w [width in pixels of rendering]
    #     -n [height in pixels (number of lines) of rendering]
    #     -C [background color (R/G/B)]
    #     -a [azimuth (degrees)]
    #     -e [elevation (degrees)]
    #     -o [output .pix file]
    #     <first positional arg> [database]
    #     <second positional arg> [entity in database to trace]

    command = "rm -f #{database_file}.pix #{database_file}.png ; \
               rt -A0.1 -w#{image_width} -n#{image_height} -C0/0/50 -a265 -e160 -o #{database_file}.pix \
               #{database_file} megaptera.c"
    result = %x[#{command}]

    if (result)
      # convert image and cleanup
      command = "pix-png -w#{image_width} -n#{image_height} -o #{database_file}.png #{database_file}.pix ; \
              rm -f #{database_file}.pix"
      %x[#{command}]
    end
  else
    command = "mged #{database_file}"
    %x[#{command}]
  end
end
