// Boundary_triangle_mesh.hpp
//
// Copyright 2012-2014 Roan Trail, Inc.
//
// This file is part of Tovero.
//
// Tovero is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License
// version 2.1 as published by the Free Software Foundation.
//
// Tovero is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.  You should have
// received a copy of the GNU Lesser General Public License along with
// Tovero. If not, see <http://www.gnu.org/licenses/>.

// Triangle mesh, boundary version

#ifndef TOVERO_MATH_BOUNDARY_TRIANGLE_MESH_HPP_
#define TOVERO_MATH_BOUNDARY_TRIANGLE_MESH_HPP_

#include <tovero/math/geometry/Triangle_mesh.hpp>
#include <tovero/math/geometry/Triangle_face.hpp>
#include <string>
#include <vector>

namespace Roan_trail
{
  namespace Tovero_math
  {
    class Geometric_tolerances;
    class Point;
    class Vector;

    class Boundary_triangle_mesh : public Triangle_mesh
    {
    public:
      // constructors/copy
      Boundary_triangle_mesh(Triangle_face::Triangle_direction_type triangle_direction,
                             const std::vector<Point>& vertices,
                             const std::vector<Triangle_face>& faces,
                             const std::vector<Unit_vector>& normals,
                             const std::vector<Triangle_face>& face_normals,
                             bool has_surface_normals,
                             bool use_surface_normals,
                             const std::string& name = "");
      virtual Solid* clone_solid() const { return new Boundary_triangle_mesh(*this); }
      //   Note: let compiler generate copy constructor and operator=
      // accessors//mutators
      // visitor
      virtual Solid_visitor::Visit_result accept(Solid_visitor& visitor) const { return visitor.visit(*this); }
      // other
      virtual std::string solid_class() const { return "Boundary_triangle_mesh"; }
    protected:
      // destructor
      virtual ~Boundary_triangle_mesh() {}
    private:
      // solid parameters
      // (none)
    };
  }
}

#endif // TOVERO_MATH_BOUNDARY_TRIANGLE_MESH_HPP_
