// Pipe.hpp
//
// Copyright 2014 Roan Trail, Inc.
//
// This file is part of Tovero.
//
// Tovero is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License
// version 2.1 as published by the Free Software Foundation.
//
// Tovero is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.  You should have
// received a copy of the GNU Lesser General Public License along with
// Tovero. If not, see <http://www.gnu.org/licenses/>.

// Triangle mesh solid

#ifndef TOVERO_MATH_PIPE_HPP_
#define TOVERO_MATH_PIPE_HPP_

#include <tovero/math/geometry/Solid.hpp>
#include <tovero/math/geometry/Pipe_control_point.hpp>
#include <string>
#include <vector>

namespace Roan_trail
{
  namespace Tovero_support
  {
    class Error_param;
  }

  namespace Tovero_math
  {
    class Geometric_tolerances;
    class Point;
    class Vector;

    class Pipe : public Solid
    {
    public:
      // constructors/copy
      Pipe(const std::vector<Pipe_control_point>& control_points,
           const std::string& name = "");
      virtual Solid* clone_solid() const { return new Pipe(*this); }
      //   Note: let compiler generate copy constructor and operator=
      // accessors//mutators
      const std::vector<Pipe_control_point>& control_points() const { return m_control_points; }
      std::vector<Pipe_control_point>& control_points() { return m_control_points; }
      // predicates
      virtual bool is_valid(const Geometric_tolerances& tolerances,
                            Roan_trail::Tovero_support::Error_param& return_error) const;
      // visitor
      virtual Solid_visitor::Visit_result accept(Solid_visitor& visitor) const { return visitor.visit(*this); }
      // other
      virtual std::string solid_class() const { return "Pipe"; }
    protected:
      // destructor
      virtual ~Pipe() {}
    private:
      // solid parameters
      std::vector<Pipe_control_point> m_control_points;
    };
  }
}

#endif // TOVERO_MATH_PIPE_HPP_
