// Pipe_control_point.cpp
//
// Copyright 2014 Roan Trail, Inc.
//
// This file is part of Tovero.
//
// Tovero is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License
// version 2.1 as published by the Free Software Foundation.
//
// Tovero is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.  You should have
// received a copy of the GNU Lesser General Public License along with
// Tovero. If not, see <http://www.gnu.org/licenses/>.

#include <tovero/math/geometry/Pipe_control_point.hpp>

using namespace Roan_trail::Tovero_math;

//
//   Constructors/copy
//

Pipe_control_point::Pipe_control_point()
  : m_position(),           // origin
    m_inner_radius(),
    m_outer_radius(),
    m_bend_radius()
{
}

Pipe_control_point::Pipe_control_point(Point position,
                                       Distance inner_radius,
                                       Distance outer_radius,
                                       Distance bend_radius)
  : m_position(position),
    m_inner_radius(inner_radius),
    m_outer_radius(outer_radius),
    m_bend_radius(bend_radius)
{
}
